/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui.panel;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import net.sourceforge.jocular.gui.panel.AbstractPanel;
import net.sourceforge.jocular.gui.panel.OutputPanel;
import net.sourceforge.jocular.imager.Imager;
import net.sourceforge.jocular.imager.MonoPixel;
import net.sourceforge.jocular.imager.Pixel;
import net.sourceforge.jocular.properties.ImageProperty;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;
import net.sourceforge.jocular.settings.Settings;

public class ImagerPanel
extends AbstractPanel
implements OutputPanel {
    private Imager m_imager;
    private BufferedImage m_image;

    public ImagerPanel(Imager imager) {
        this.m_scale = 0.0015;
        this.m_centre = new Point2D.Double(-300.0, -250.0);
        this.m_imager = imager;
        this.addMouseMotionListener(new AbstractPanel.PanelMouseMotionListener());
        this.addMouseWheelListener(new AbstractPanel.PanelMouseWheelListener());
        Settings.SETTINGS.addPropertyUpdatedListener(new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
                if (e.getPropertyKey() == PropertyKey.USE_POLARIZATION) {
                    ImagerPanel.this.updatePanel();
                }
            }
        });
    }

    public void setImager(Imager imager) {
        this.m_imager = imager;
    }

    @Override
    public void updatePanel() {
        if (this.m_imager == null) {
            return;
        }
        this.m_image = ((ImageProperty)this.m_imager.getProperty(PropertyKey.IMAGE)).getValue();
        this.repaint();
    }

    @Override
    protected void drawPanel(Graphics2D g2) {
        double image_height;
        if (this.m_image == null) {
            return;
        }
        double width = this.getWidth();
        double height = this.getHeight();
        double image_width = this.m_image.getWidth();
        if (width / image_width > height / (image_height = (double)this.m_image.getHeight())) {
            width = image_width / image_height * height;
        } else {
            height = image_height / image_width * width;
        }
        g2.drawImage(this.m_image, 0, 0, (int)width, (int)height, 0, 0, (int)image_width, (int)image_height, null);
    }

    private Point2D.Double getPixelLocation(Point2D.Double mousePos) {
        Point2D.Double pixelLoc = new Point2D.Double(mousePos.x, mousePos.y);
        if (this.m_image != null) {
            double sx = 1.0 / (double)this.getWidth();
            double sy = 1.0 / (double)this.getHeight();
            double s = sx > (sy *= (double)this.m_image.getHeight()) ? (sx *= (double)this.m_image.getWidth()) : sy;
            pixelLoc.x *= s;
            pixelLoc.y *= s;
        }
        return pixelLoc;
    }

    @Override
    protected String getToolTip(Point2D.Double p) {
        if (this.m_imager == null) {
            return "";
        }
        Point2D.Double pixelLoc = this.getPixelLocation(p);
        int x = (int)pixelLoc.x;
        int y = (int)pixelLoc.y;
        Pixel displayPixel = this.m_imager.getPixel(x, y);
        boolean mono = displayPixel instanceof MonoPixel;
        if (displayPixel == null) {
            return "";
        }
        String result = "X, Y: " + x + ", " + y;
        if (mono) {
            DecimalFormat format = new DecimalFormat("######.#E00");
            result = result + " " + format.format(displayPixel.getMaxMagnitude());
        } else {
            DecimalFormat format = new DecimalFormat("######.#");
            result = result + " r: " + format.format(displayPixel.getRed(false)) + " g: " + format.format(displayPixel.getGreen(false)) + " b: " + format.format(displayPixel.getBlue(false));
        }
        return result;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public Imager getImager() {
        return this.m_imager;
    }

    @Override
    public void resetPanel() {
    }
}

