/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import net.sourceforge.jocular.gui.panel.OutputPanel;

public abstract class AbstractPanel
extends JPanel
implements OutputPanel {
    protected double m_scale = 1.0;
    protected Point2D.Double m_centre = new Point2D.Double(0.0, 0.0);

    private AffineTransform getTransform() {
        Dimension panelSize = this.getSize();
        double w = panelSize.width;
        double h = panelSize.height;
        double min = Math.min(w, h);
        double s = min * this.m_scale;
        AffineTransform t = AffineTransform.getScaleInstance(s, -s);
        t.translate(1.0 / this.m_scale * w / min / 2.0, -1.0 / this.m_scale * h / min / 2.0);
        t.translate(this.m_centre.x, this.m_centre.y);
        return t;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle r = g2.getClipBounds();
        g2.setColor(Color.white);
        g2.fillRect(r.x, r.y, r.width, r.height);
        AffineTransform oldTransform = g2.getTransform();
        AffineTransform transform = new AffineTransform(oldTransform);
        transform.concatenate(this.getTransform());
        g2.setTransform(transform);
        this.drawPanel(g2);
        g2.setTransform(oldTransform);
    }

    @Override
    public void zoomIn() {
        this.m_scale *= 1.1;
        this.repaint();
    }

    @Override
    public void zoomOut() {
        this.m_scale /= 1.1;
        this.repaint();
    }

    @Override
    public void zoomExtents() {
    }

    public void setScale(double s) {
        this.m_scale = s;
        this.repaint();
    }

    protected Point2D.Double getMousePos() {
        Point2D.Double result = new Point2D.Double();
        Point p = this.getMousePosition();
        if (p != null) {
            Point2D.Double p1 = new Point2D.Double(p.getX(), p.getY());
            try {
                AffineTransform t = this.getTransform().createInverse();
                t.transform(p1, result);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        return result;
    }

    protected abstract void drawPanel(Graphics2D var1);

    @Override
    public abstract void updatePanel();

    protected abstract String getToolTip(Point2D.Double var1);

    @Override
    public Component getComponent() {
        return this;
    }

    protected class PanelMouseMotionListener
    implements MouseMotionListener {
        protected PanelMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent me) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point2D.Double p = AbstractPanel.this.getMousePos();
            AbstractPanel.this.repaint();
            AbstractPanel.this.setToolTipText(AbstractPanel.this.getToolTip(p));
        }
    }

    protected class PanelMouseWheelListener
    implements MouseWheelListener {
        protected PanelMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int r = e.getWheelRotation();
            if (r > 0) {
                AbstractPanel.this.zoomOut();
            } else if (r < 0) {
                AbstractPanel.this.zoomIn();
            }
            Point2D.Double p = AbstractPanel.this.getMousePos();
            AbstractPanel.this.m_centre = new Point2D.Double(-0.1 * p.x + 0.9 * AbstractPanel.this.m_centre.x, -0.1 * p.y + 0.9 * AbstractPanel.this.m_centre.y);
        }
    }
}

