/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.jocular.actions.OpticsAction;
import net.sourceforge.jocular.graphs.GraphPanel;
import net.sourceforge.jocular.gui.EquationField;
import net.sourceforge.jocular.project.GlobalVariables;

public class GlobalVariableDialog
extends JDialog {
    protected static final String SPLINE_SERIES = "Spline";
    protected static final String POINT_SERIES = "Points";
    protected static final String SELECTED_POINT_SERIES = "Selected Point";
    protected static final String SPLINE_POINT_SERIES = "Spline Points";
    private final GlobalVariables m_variables;
    private GraphPanel m_graph;
    private JTable m_table;
    private EquationField m_simplifyField;

    public GlobalVariableDialog(Frame owner, GlobalVariables vars) {
        super(owner, "Global Variables");
        this.m_variables = vars;
        JToolBar jtb = new JToolBar();
        jtb.setFloatable(false);
        jtb.add(OpticsAction.GLOBAL_VARIABLES_ADD);
        jtb.add(OpticsAction.GLOBAL_VARIABLES_DELETE);
        jtb.add(OpticsAction.GLOBAL_VARIABLES_CLOSE);
        this.setSize(new Dimension(500, 400));
        this.setLayout(new BorderLayout());
        this.m_table = new JTable(this.m_variables);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                Point p = e.getPoint();
                int r = GlobalVariableDialog.this.m_table.rowAtPoint(p);
                GlobalVariableDialog.this.m_table.getSelectionModel().setSelectionInterval(r, r);
            }
        });
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (GlobalVariableDialog.this.m_table.isEditing()) {
                    GlobalVariableDialog.this.m_table.getCellEditor().stopCellEditing();
                }
            }
        });
        this.add((Component)jtb, "North");
        this.add((Component)new JScrollPane(this.m_table), "Center");
        this.setVisible(true);
    }

    public int getSelectedIndex() {
        int i = this.m_table.getSelectedRow();
        return i;
    }
}

