/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;
import net.sourceforge.jocular.settings.Settings;

public class EquationField
extends JTextField {
    PropertyOwner m_owner;
    PropertyKey m_key;
    OpticsProject m_project;

    private EquationField() {
    }

    public EquationField(PropertyOwner owner, PropertyKey key, OpticsProject project) {
        this.m_owner = owner;
        this.m_key = key;
        this.m_project = project;
        this.updateText();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EquationField.this.m_project.addPropertyEdit(EquationField.this.m_owner, EquationField.this.m_key, EquationField.this.getText());
            }
        });
        this.m_owner.addPropertyUpdatedListener(new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
                EquationField.this.updateText();
            }
        });
    }

    private void updateText() {
        EquationProperty p = (EquationProperty)this.m_owner.getProperty(this.m_key);
        if (p == null) {
            this.setText("");
        } else {
            UnitedValue v = p.getValue();
            switch (Settings.SETTINGS.getNumberDisplay()) {
                case EQUATION: {
                    this.setText(p.getDefiningString());
                    break;
                }
                case METRIC: {
                    this.setText(v.getBaseUnitString());
                    break;
                }
                default: {
                    this.setText("Imperial view not implemented yet.");
                }
            }
            if (v.isError()) {
                this.setBackground(new Color(1.0f, 0.5f, 0.5f));
                this.setToolTipText(v.getErrorText());
            } else if (v.isSimpleValue()) {
                this.setBackground(new Color(0.5f, 1.0f, 0.5f));
                this.setToolTipText(v.getBaseUnitString());
            } else {
                this.setBackground(new Color(0.5f, 0.5f, 1.0f));
                this.setToolTipText(v.getBaseUnitString());
            }
        }
    }
}

