/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.graphs;

import java.awt.Color;
import net.sourceforge.jocular.graphs.GraphPanel;

public class GraphSeries {
    public final double[] x;
    public final double[] y;
    protected Color color;
    private GraphPanel.GraphType seriesType;
    private double m_dotSize = 20.0;
    private GraphPanel.DotType m_dotType = GraphPanel.DotType.TRIANGLE;
    private double m_lineWidth = 1.0;

    public GraphSeries(double[] xs, double[] ys, Color c) {
        this.x = (double[])xs.clone();
        this.y = (double[])ys.clone();
        this.color = c;
        this.seriesType = GraphPanel.GraphType.FROM_GRAPH;
    }

    public int size() {
        return Math.min(this.x.length, this.y.length);
    }

    public double getX(int i) {
        int ti = i;
        if (i < 0) {
            ti += this.x.length;
        } else if (i >= this.x.length) {
            ti -= this.x.length;
        }
        return this.x[ti];
    }

    public double getY(int i) {
        int ti = i;
        if (i < 0) {
            ti += this.y.length;
        } else if (i >= this.y.length) {
            ti -= this.y.length;
        }
        return this.y[ti];
    }

    public Color getColor() {
        return this.color;
    }

    public void setType(GraphPanel.GraphType t) {
        this.seriesType = t;
    }

    public GraphPanel.GraphType getType() {
        return this.seriesType;
    }

    public void setDotType(GraphPanel.DotType dt) {
        this.m_dotType = dt;
    }

    public GraphPanel.DotType getDotType() {
        return this.m_dotType;
    }

    public void setDotSize(double s) {
        this.m_dotSize = s;
    }

    public double getDotSize() {
        return this.m_dotSize;
    }

    public double getLineWidth() {
        return this.m_lineWidth;
    }

    public void setLineWidth(double w) {
        this.m_lineWidth = w;
    }
}

