/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.graphs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import net.sourceforge.jocular.graphs.GraphAxis;
import net.sourceforge.jocular.graphs.GraphSeries;

public class GraphPanel
extends JPanel {
    private Point2D.Double startPoint = null;
    private Point2D.Double startPointOrigin = null;
    private Point2D.Double mousePoint = new Point2D.Double();
    private Point2D.Double mousePointOrigin = new Point2D.Double();
    private boolean m_painting = false;
    private boolean m_showCrossHairs = true;
    private HashMap<Object, GraphSeries> series = new LinkedHashMap<Object, GraphSeries>();
    private GraphType defaultGraphType = GraphType.XY_DOT;
    private GraphAxis xAxis;
    private GraphAxis yAxis;
    private static final Color[] COLORS = new Color[]{Color.red, Color.green, Color.blue, Color.magenta, Color.cyan, Color.orange, Color.gray};
    NumberFormat format = new DecimalFormat("##0E0");
    private Color m_gridColor = new Color(220, 220, 220);
    private Color m_cursorColor = new Color(119, 0, 255);
    private static final int OPTIMAL_GRID_COUNT = 10;

    public GraphPanel() {
        this.setPreferredSize(new Dimension(200, 200));
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent me) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Point2D.Double p = GraphPanel.this.getMousePos();
                GraphPanel.this.mousePoint = new Point2D.Double(p.x, p.y);
                GraphPanel.this.mousePointOrigin = GraphPanel.this.getScaledOrigin();
                GraphPanel.this.repaint();
                if (GraphPanel.this.startPoint != null) {
                    Point2D.Double newOrigin = GraphPanel.this.getScaledOrigin();
                    p.setLocation(p.x - (GraphPanel.this.startPoint.x - GraphPanel.this.startPointOrigin.x + newOrigin.x), p.y - (GraphPanel.this.startPoint.y - GraphPanel.this.startPointOrigin.y + newOrigin.y));
                    GraphPanel.this.setToolTipText("delta = " + GraphPanel.this.format.format(p.x) + "," + GraphPanel.this.format.format(p.y));
                } else {
                    GraphPanel.this.setToolTipText(GraphPanel.this.format.format(p.x) + "," + GraphPanel.this.format.format(p.y));
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
                GraphPanel.this.startPoint = GraphPanel.this.getMousePos();
                GraphPanel.this.startPointOrigin = GraphPanel.this.getScaledOrigin();
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
            }

            @Override
            public void mouseReleased(MouseEvent me) {
            }
        });
    }

    public void zeroOffset() {
        this.startPoint = null;
    }

    public Point2D.Double getMousePos() {
        Point2D.Double result = new Point2D.Double();
        Point p = this.getMousePosition();
        if (p != null) {
            Point2D.Double p1 = new Point2D.Double(p.getX(), p.getY());
            try {
                AffineTransform t = this.getTransform().createInverse();
                t.transform(p1, result);
                result = this.unScale(result);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        return result;
    }

    private Point2D.Double unScale(Point2D.Double p) {
        Point2D.Double r = (Point2D.Double)p.clone();
        r.x = this.xAxis.unScale(r.x);
        r.y = this.yAxis.unScale(r.y);
        return r;
    }

    public void updateGraph(Object seriesKey, double[] xNew, double[] yNew) {
        Color c = this.getNextSeriesColor();
        if (xNew.length != yNew.length) {
            throw new RuntimeException("X and Y series are not the same length: " + xNew.length + ", " + yNew.length);
        }
        if (this.series.containsKey(seriesKey)) {
            c = this.series.get(seriesKey).getColor();
        } else {
            System.out.println("Adding " + seriesKey + ": " + c);
        }
        if (!this.m_painting) {
            this.series.put(seriesKey, new GraphSeries(xNew, yNew, c));
        }
    }

    public void setSeriesColor(Object key, Color color) {
        if (this.series.containsKey(key)) {
            this.series.get((Object)key).color = color;
        }
    }

    public void setSeriesSize(Object key, double dotSize, double lineWidth) {
        if (this.series.containsKey(key)) {
            this.series.get(key).setDotSize(dotSize);
            this.series.get(key).setLineWidth(lineWidth);
        }
    }

    public void removeSeries(Object seriesKey) {
        if (this.series.containsKey(seriesKey)) {
            this.series.remove(seriesKey);
        }
        this.repaint();
    }

    public void removeAllSeries() {
        this.series.clear();
        this.repaint();
    }

    public GraphType getSeriesType(Object seriesKey) {
        GraphSeries s = this.series.get(seriesKey);
        return s.getType();
    }

    public void setSeriesType(Object seriesKey, GraphType gt) {
        GraphSeries s = this.series.get(seriesKey);
        s.setType(gt);
    }

    public void setSeriesDotType(Object seriesKey, DotType dt) {
        GraphSeries s = this.series.get(seriesKey);
        s.setDotType(dt);
    }

    public boolean isSeries(Object seriesKey) {
        return this.series.containsKey(seriesKey);
    }

    public void setGraphType(GraphType gt) {
        this.defaultGraphType = gt;
    }

    public void setScale(double xMin, double xMax, double yMin, double yMax, boolean xLog, GraphType gt) {
        this.setScale(xMin, xMax, yMin, yMax, xLog);
        this.defaultGraphType = gt;
    }

    public void setScale(double xMin, double xMax, double yMin, double yMax, boolean xLog) {
        this.xAxis = new GraphAxis(xMin, xMax, xLog, 1.0);
        this.yAxis = new GraphAxis(yMin, yMax, false, 0.0);
    }

    public void autoScale(boolean scaleX, boolean logX, boolean scaleY, boolean logY) {
        double xMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        for (GraphSeries gs : this.series.values()) {
            double[] xs = gs.x;
            double[] ys = gs.y;
            for (int i = 0; i < xs.length; ++i) {
                double x = xs[i];
                double y = ys[i];
                if (x < xMin) {
                    xMin = x;
                }
                if (x > xMax) {
                    xMax = x;
                }
                if (y < yMin) {
                    yMin = y;
                }
                if (!(y > yMax)) continue;
                yMax = y;
            }
        }
        if (scaleX) {
            this.xAxis = new GraphAxis(xMin, xMax, logX, this.getBestGridlineSpacing(xMin, xMax));
        }
        if (scaleY) {
            this.yAxis = new GraphAxis(yMin, yMax, logY, this.getBestGridlineSpacing(yMin, yMax));
        }
    }

    public double getBestGridlineSpacing(double min, double max) {
        double t = Math.abs((max - min) / 10.0);
        double l = Math.floor(Math.log10(t));
        double p = Math.pow(10.0, l);
        t /= p;
        double[] spacingOptions = new double[]{1.0, 2.0, 5.0};
        double sBest = 0.0;
        double distBest = Double.POSITIVE_INFINITY;
        for (double sTest : spacingOptions) {
            double dist = Math.abs(sTest - t);
            if (!(dist < distBest)) continue;
            distBest = dist;
            sBest = sTest;
        }
        return sBest * p;
    }

    public void fitAllSeries() {
        double maxValue = Double.MIN_VALUE;
        double minValue = Double.MAX_VALUE;
        for (Object key : this.series.keySet()) {
            for (int i = 0; i < this.series.get(key).size(); ++i) {
                if (this.series.get(key).getY(i) > maxValue) {
                    maxValue = this.series.get(key).getY(i);
                }
                if (!(this.series.get(key).getY(i) < minValue)) continue;
                minValue = this.series.get(key).getY(i);
            }
        }
        this.setScale(this.xAxis.min, this.xAxis.max, minValue, maxValue, this.xAxis.log);
        this.repaint();
    }

    public double[] getXData(Object key) {
        GraphSeries ser = this.series.get(key);
        if (ser == null) {
            return null;
        }
        int len = ser.size();
        double[] x = new double[len];
        for (int i = 0; i < len; ++i) {
            x[i] = ser.getX(i);
        }
        return x;
    }

    public double[] getYData(Object key) {
        GraphSeries ser = this.series.get(key);
        if (ser == null) {
            return null;
        }
        int len = ser.size();
        double[] y = new double[len];
        for (int i = 0; i < len; ++i) {
            y[i] = ser.getY(i);
        }
        return y;
    }

    public double[] getYDataNormalized(Object key) {
        int i;
        GraphSeries ser = this.series.get(key);
        int len = ser.size();
        double total = 0.0;
        double[] y = new double[len];
        for (i = 0; i < len; ++i) {
            y[i] = ser.getY(i);
            total += y[i];
        }
        i = 0;
        while (i < len) {
            int n = i++;
            y[n] = y[n] / total;
        }
        return y;
    }

    private AffineTransform getTransform() {
        Dimension panelSize = this.getSize();
        AffineTransform t = AffineTransform.getScaleInstance(panelSize.width, -((double)panelSize.height));
        t.translate(0.0, -1.0);
        return t;
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        ArrayList<Double> yGridLines;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle r = g2.getClipBounds();
        g2.setColor(this.getBackground());
        g2.fillRect(r.x, r.y, r.width, r.height);
        AffineTransform oldTransform = g2.getTransform();
        Dimension panelSize = this.getSize();
        AffineTransform transform = new AffineTransform(oldTransform);
        transform.concatenate(this.getTransform());
        g2.setTransform(transform);
        g2.setStroke(new BasicStroke(0.002f));
        g2.setColor(this.m_gridColor);
        g2.draw(new Rectangle2D.Double(0.1, 0.1, 0.8, 0.8));
        ArrayList<Double> xGridLines = this.xAxis.getGridLines();
        if (xGridLines != null) {
            for (Double d : xGridLines) {
                this.drawVertLine(g2, this.xAxis.scale(d), panelSize.width);
            }
        }
        if ((yGridLines = this.yAxis.getGridLines()) != null) {
            for (Double d : yGridLines) {
                this.drawHorizLine(g2, this.yAxis.scale(d), panelSize.height);
            }
        }
        this.m_painting = true;
        for (GraphSeries s : this.series.values()) {
            double pw = panelSize.width;
            double ph = panelSize.height;
            double xr = s.getDotSize() / pw;
            double yr = s.getDotSize() / ph;
            double w = s.getLineWidth() / Math.sqrt(pw * pw + ph * ph);
            g2.setColor(s.getColor());
            block12: for (int i = 0; i < s.size(); ++i) {
                GraphType t = s.getType() == GraphType.FROM_GRAPH ? this.defaultGraphType : s.getType();
                if (Double.isNaN(s.getX(i))) continue;
                switch (t) {
                    case XY_DOT: {
                        this.drawDot(g2, this.xAxis.scale(s.getX(i)), this.yAxis.scale(s.getY(i)), xr, yr, s.getDotType());
                        continue block12;
                    }
                    case BAR: {
                        this.drawBar(g2, this.xAxis.scale(s.getX(i)), this.yAxis.scale(s.getY(i)), xr, yr);
                        continue block12;
                    }
                    case BAR_DOT: {
                        this.drawDottedBar(g2, this.xAxis.scale(s.getX(i)), this.yAxis.scale(s.getY(i)), xr, yr);
                        continue block12;
                    }
                    case XY_DOT_AND_LINE: {
                        this.drawDot(g2, this.xAxis.scale(s.getX(i)), this.yAxis.scale(s.getY(i)), xr, yr, s.getDotType());
                    }
                    case XY_LINE: {
                        if (Double.isNaN(s.getX(i - 1)) || !(s.getX(i - 1) < s.getX(i))) continue block12;
                        this.drawLine(g2, this.xAxis.scale(s.getX(i - 1)), this.yAxis.scale(s.getY(i - 1)), this.xAxis.scale(s.getX(i)), this.yAxis.scale(s.getY(i)), w, w);
                        continue block12;
                    }
                    case XY_CONTINUOUS_AND_DOTS: {
                        this.drawDot(g2, this.xAxis.scale(s.getX(i)), this.yAxis.scale(s.getY(i)), xr, yr, s.getDotType());
                    }
                    case XY_CONTINUOUS: {
                        if (Double.isNaN(s.getX(i - 1))) continue block12;
                        this.drawLine(g2, this.xAxis.scale(s.getX(i - 1)), this.yAxis.scale(s.getY(i - 1)), this.xAxis.scale(s.getX(i)), this.yAxis.scale(s.getY(i)), w, w);
                        continue block12;
                    }
                }
            }
        }
        this.m_painting = false;
        if (this.m_showCrossHairs) {
            g2.setStroke(new BasicStroke(0.002f));
            g2.setColor(this.m_cursorColor);
            Point2D.Double double_ = this.getScaledOrigin();
            if (this.startPoint != null) {
                this.drawVertLine(g2, this.xAxis.scale(this.startPoint.x - this.startPointOrigin.x + double_.x), panelSize.width);
                this.drawHorizLine(g2, this.yAxis.scale(this.startPoint.y - this.startPointOrigin.y + double_.y), panelSize.height);
            }
            Point2D.Double p = this.getMousePos();
            this.mousePoint = new Point2D.Double(p.x, p.y);
            this.mousePointOrigin = this.getScaledOrigin();
            this.drawVertLine(g2, this.xAxis.scale(this.mousePoint.x - this.mousePointOrigin.x + double_.x), panelSize.width);
            this.drawHorizLine(g2, this.yAxis.scale(this.mousePoint.y - this.mousePointOrigin.y + double_.y), panelSize.height);
        }
        g2.setTransform(oldTransform);
    }

    private void drawDot(Graphics2D g, double x, double y, double xr, double yr, DotType dotType) {
        switch (dotType) {
            default: {
                g.fill(new Ellipse2D.Double(x - xr, y - yr, xr * 2.0, yr * 2.0));
                break;
            }
            case CROSS: {
                Line2D.Double cl1 = new Line2D.Double(x - xr, y - yr, x + xr, y + yr);
                Line2D.Double cl2 = new Line2D.Double(x + xr, y - yr, x - xr, y + yr);
                g.draw(cl1);
                g.draw(cl2);
                break;
            }
            case SQUARE: {
                Line2D.Double sl1 = new Line2D.Double(x - xr, y - yr, x + xr, y - yr);
                Line2D.Double sl2 = new Line2D.Double(x - xr, y + yr, x + xr, y + yr);
                Line2D.Double sl3 = new Line2D.Double(x - xr, y - yr, x - xr, y + yr);
                Line2D.Double sl4 = new Line2D.Double(x + xr, y - yr, x + xr, y + yr);
                g.draw(sl1);
                g.draw(sl2);
                g.draw(sl3);
                g.draw(sl4);
                break;
            }
            case TRIANGLE: {
                Point2D.Double p1 = new Point2D.Double(x, y + yr);
                Point2D.Double p2 = new Point2D.Double(x - xr * 0.86602540378, y - yr * 0.5);
                Point2D.Double p3 = new Point2D.Double(x + xr * 0.86602540378, y - yr * 0.5);
                Line2D.Double l1 = new Line2D.Double(p1, p2);
                Line2D.Double l2 = new Line2D.Double(p2, p3);
                Line2D.Double l3 = new Line2D.Double(p3, p1);
                g.draw(l1);
                g.draw(l2);
                g.draw(l3);
            }
        }
    }

    private void drawBar(Graphics2D g, double x, double y, double xr, double yr) {
        g.fill(new Rectangle2D.Double(x - xr, 0.1 - yr, 2.0 * xr, y - 0.1 + yr));
    }

    private void drawDottedBar(Graphics2D g, double x, double y, double xr, double yr) {
        g.fill(new Rectangle2D.Double(x - xr / 2.0, 0.1 - yr, xr, y - 0.1 + yr));
    }

    private void drawLine(Graphics2D g, double x1, double y1, double x2, double y2, double xr, double yr) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double r = (Math.abs(dy * xr) + Math.abs(dx * yr)) / Math.sqrt(dx * dx + dy * dy);
        g.setStroke(new BasicStroke((float)(2.0 * r), 1, 1));
        g.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    private void drawVertLine(Graphics2D g, double x, int xDim) {
        double r = 0.6 / (double)xDim;
        g.fill(new Rectangle2D.Double(x - r, 0.1, 2.0 * r, 0.8));
    }

    private void drawHorizLine(Graphics2D g, double y, int yDim) {
        double r = 0.6 / (double)yDim;
        g.fill(new Rectangle2D.Double(0.1, y - r, 0.8, 2.0 * r));
    }

    protected Color getNextSeriesColor() {
        for (Color c : COLORS) {
            boolean matched = false;
            for (GraphSeries s : this.series.values()) {
                if (!s.getColor().equals(c)) continue;
                matched = true;
            }
            if (matched) continue;
            return c;
        }
        return new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    }

    public void setXGridLineSpacing(double gs) {
        this.xAxis.gridLineSpacing = gs;
    }

    public void setYGridLineSpacing(double gs) {
        this.yAxis.gridLineSpacing = gs;
    }

    public Point2D.Double getScaledOrigin() {
        return new Point2D.Double(this.xAxis.min, this.yAxis.min);
    }

    public Rectangle2D.Double getScaledBounds() {
        double x0 = this.xAxis.min;
        double dx = this.xAxis.max - x0;
        double y0 = this.yAxis.min;
        double dy = this.yAxis.max - y0;
        return new Rectangle2D.Double(x0, y0, dx, dy);
    }

    public void setForegroundSeries(Object key) {
        if (!this.series.containsKey(key)) {
            return;
        }
        GraphSeries s = this.series.get(key);
        this.series.remove(key);
        this.series.put(key, s);
        this.repaint();
    }

    public void showCrossHairs(boolean b) {
        this.m_showCrossHairs = b;
    }

    public void setGridColor(Color c) {
        this.m_gridColor = c;
    }

    public void setTextColor(Color c) {
    }

    public void setCursorColor(Color c) {
        this.m_cursorColor = c;
    }

    public static enum GraphType {
        XY_DOT("XY Dot"),
        XY_DOT_AND_LINE("Dot and Line"),
        XY_LINE("XY Line"),
        XY_CONTINUOUS("XY Continuous Line"),
        XY_CONTINUOUS_AND_DOTS("XY Continuous Line with dots"),
        BAR("Bar"),
        BAR_DOT("Bar Dotted"),
        FROM_GRAPH("from Graph");

        private String name;

        private GraphType(String n2) {
            this.name = n2;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum DotType {
        CIRCLE("Circle"),
        SQUARE("Square"),
        TRIANGLE("Triangle"),
        CROSS("Cross");

        private String name;

        private DotType(String n2) {
            this.name = n2;
        }

        public String toString() {
            return this.name;
        }
    }
}

