/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.graphs;

import java.util.ArrayList;

public class GraphAxis {
    protected double min;
    protected double max;
    protected boolean log;
    protected double gridLineSpacing;

    public GraphAxis(double min, double max, boolean log, double gridLineSpacing) {
        this.min = min;
        this.max = max;
        this.log = log;
        if (log && (min == 0.0 || max == 0.0)) {
            throw new RuntimeException("Cannot use zero limit with log scale.");
        }
        this.gridLineSpacing = gridLineSpacing;
    }

    public double scale(double n) {
        double result = n;
        if (this.log) {
            result = Math.log10(result);
            result -= Math.log10(this.min);
            result /= Math.log10(this.max) - Math.log10(this.min);
        } else {
            result -= this.min;
            result /= this.max - this.min;
        }
        result *= 0.8;
        result += 0.1;
        if (result > 0.9) {
            result = 0.9;
        } else if (result < 0.1) {
            result = 0.1;
        }
        return result;
    }

    public double unScale(double n) {
        double result = n;
        result -= 0.1;
        result /= 0.8;
        if (this.log) {
            result *= Math.log10(this.max) - Math.log10(this.min);
            result += Math.log10(this.min);
            result = Math.pow(10.0, result);
        } else {
            result *= this.max - this.min;
            result += this.min;
        }
        return result;
    }

    public ArrayList<Double> getGridLines() {
        ArrayList<Double> result;
        block5: {
            block4: {
                if (this.gridLineSpacing == 0.0) {
                    return null;
                }
                result = new ArrayList<Double>();
                if (!this.log) break block4;
                double n = Math.ceil(Math.log10(this.min));
                double m = Math.floor(Math.log10(this.max));
                if (!(m - n > 100.0)) break block5;
                for (double i = n; i <= m; i += 1.0) {
                    result.add(Math.pow(10.0, i));
                    if (this.gridLineSpacing != 1.0) continue;
                    for (int j = 2; j < 10; ++j) {
                        if (!(Math.pow(10.0, i) * (double)j < this.max)) continue;
                        result.add(Math.pow(10.0, i) * (double)j);
                    }
                }
                break block5;
            }
            int n = (int)Math.ceil(this.min / this.gridLineSpacing);
            int m = (int)Math.floor(this.max / this.gridLineSpacing);
            for (double i = (double)n; i <= (double)m; i += 1.0) {
                result.add(i * this.gridLineSpacing);
            }
        }
        return result;
    }
}

