/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.clipboard;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import net.sourceforge.jocular.imager.Imager;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.properties.ImageProperty;
import net.sourceforge.jocular.properties.PropertyKey;

public class OpticsObjectTransferable
implements Transferable,
ClipboardOwner {
    private final DataFlavor[] m_flavors;
    private final OpticsObject m_object;

    public OpticsObjectTransferable(OpticsObject o) {
        this.m_object = o;
        if (o instanceof Imager) {
            DataFlavor[] dfs = new DataFlavor[]{new DataFlavor(OpticsObject.class, "Optics Object"), DataFlavor.imageFlavor};
            this.m_flavors = dfs;
        } else {
            DataFlavor[] dfs = new DataFlavor[]{new DataFlavor(OpticsObject.class, "Optics Object")};
            this.m_flavors = dfs;
        }
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }

    @Override
    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
        Object result = null;
        if (!this.isDataFlavorSupported(df)) {
            throw new UnsupportedFlavorException(df);
        }
        if (df.equals(DataFlavor.imageFlavor)) {
            Imager i = (Imager)this.m_object;
            result = ((ImageProperty)i.getProperty(PropertyKey.IMAGE)).getValue();
        } else {
            result = this.m_object.makeCopy();
        }
        return result;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.m_flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor df) {
        boolean result = false;
        for (DataFlavor dft : this.getTransferDataFlavors()) {
            if (!dft.equals(df)) continue;
            result = true;
            break;
        }
        return result;
    }
}

