/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.autofocus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.jocular.autofocus.AutofocusParameterTableModel;
import net.sourceforge.jocular.autofocus.AutofocusSensor;
import net.sourceforge.jocular.imager.Imager;
import net.sourceforge.jocular.math.CalcCompleteEvent;
import net.sourceforge.jocular.math.CalcCompleteListener;
import net.sourceforge.jocular.math.SystemToSolve;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.ProjectRootGroup;
import net.sourceforge.jocular.photons.WranglerEvent;
import net.sourceforge.jocular.photons.WranglerListener;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyManager;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.sources.ImageSource;

public class AutofocusSystemToSolve
implements SystemToSolve,
WranglerListener {
    private final AutofocusParameterTableModel m_model;
    private List<CalcCompleteListener> m_listeners = new CopyOnWriteArrayList<CalcCompleteListener>();

    public AutofocusSystemToSolve(AutofocusParameterTableModel m_model, int numPhotonsPerCalc) {
        this.m_model = m_model;
    }

    @Override
    public double getErrorValue() {
        return this.m_model.getSensor().getError();
    }

    protected PropertyKey getPropertyKey(PropertyOwner po, int i) {
        return PropertyManager.getInstance().getPropertyKey(po, this.m_model.getPropertyName(i));
    }

    @Override
    public double getParameter(int i) {
        PropertyOwner po = this.m_model.getPropertyOwner(i);
        Property<?> p = po.getProperty(this.getPropertyKey(po, i));
        if (!(p instanceof EquationProperty)) {
            throw new RuntimeException("Property is not EquationProperty.");
        }
        double result = ((EquationProperty)p).getValue().getBaseUnitValue();
        return result;
    }

    @Override
    public void setParameter(int i, double v) {
        if (Double.isNaN(v)) {
            throw new RuntimeException("Value is NaN.");
        }
        PropertyOwner po = this.m_model.getPropertyOwner(i);
        PropertyKey pk = this.getPropertyKey(po, i);
        po.setProperty(pk, Double.toString(v));
    }

    @Override
    public double getMinLimit(int i) {
        EquationArrayProperty eap = (EquationArrayProperty)this.m_model.getValueAt(i, 2);
        return eap.getValue()[i].getBaseUnitValue();
    }

    @Override
    public int getParameterCount() {
        return this.m_model.getRowCount();
    }

    @Override
    public double getMaxLimit(int i) {
        EquationArrayProperty eap = (EquationArrayProperty)this.m_model.getValueAt(i, 3);
        return eap.getValue()[i].getBaseUnitValue();
    }

    @Override
    public void computeError(double quality) {
        if (this.m_model.getSensor() == null) {
            return;
        }
        ProjectRootGroup optics = this.m_model.getProject().getOpticsObject();
        Collection<OpticsObject> os = optics.getFlattenedOpticsObjects(false);
        ArrayList<OpticsObject> group = new ArrayList<OpticsObject>();
        for (OpticsObject o : os) {
            if (o instanceof AutofocusSensor || o instanceof ImageSource || o instanceof Imager) continue;
            group.add(o);
        }
        group.add(this.m_model.getSensor());
        this.m_model.getSensor().clear();
        this.m_model.getProject().getWrangler().addWranglerListener(this);
        this.m_model.getProject().getWrangler().wrangle(group, optics, this.getNumPhotonsPerCalc(quality));
    }

    private int getNumPhotonsPerCalc(double quality) {
        double q = quality;
        if (q < 0.0) {
            q = 0.0;
        } else if (q > 1.0) {
            q = 1.0;
        }
        double result = Math.pow(10.0, q);
        return (int)Math.round(result *= 2000.0);
    }

    @Override
    public void addCalcCompleteListener(CalcCompleteListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void removeCalcCompleteListener(CalcCompleteListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public boolean isCalculating() {
        return this.m_model.getProject().getWrangler().isWrangling();
    }

    @Override
    public void wranglingUpdate(WranglerEvent e) {
        switch (e.getType()) {
            case FINISHED: {
                this.m_model.getProject().getWrangler().removeWranglerListener(this);
                this.fireCalcComplete();
                break;
            }
        }
    }

    private void fireCalcComplete() {
        CalcCompleteEvent e = new CalcCompleteEvent(this);
        for (CalcCompleteListener ccl : this.m_listeners) {
            ccl.calcComplete(e);
        }
    }
}

