/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.autofocus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.objects.AbstractOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OutputObject;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.StringArrayProperty;
import net.sourceforge.jocular.sources.HemiPointSource;
import net.sourceforge.jocular.sources.LightSource;

public class AutofocusSensor
extends AbstractOpticsObject
implements OutputObject {
    private EquationProperty m_diameter = new EquationProperty("10cm", this, PropertyKey.DIAMETER);
    private EquationArrayProperty m_minimums = new EquationArrayProperty("", (PropertyOwner)this, PropertyKey.MINIMUMS);
    private EquationArrayProperty m_maximums = new EquationArrayProperty("", (PropertyOwner)this, PropertyKey.MAXIMUMS);
    private StringArrayProperty m_objectNames = new StringArrayProperty("");
    private StringArrayProperty m_objectProperties = new StringArrayProperty("");
    private HashMap<LightSource, StatAccumulator> m_sourceAccumulators = new HashMap();

    public AutofocusSensor() {
        this.clear();
    }

    public double getError() {
        double acc = 0.0;
        for (StatAccumulator sa : this.m_sourceAccumulators.values()) {
            acc += Math.pow(sa.getError(), 2.0);
        }
        return acc;
    }

    @Override
    public void getPossibleInteraction(PhotonTrajectory pt, InteractionSorter is) {
        Vector3D vectToImagerPlane;
        Vector3D pointOnImagerPlane;
        Vector3D distAlongPlane;
        Photon p = pt.getPhoton();
        if (!(pt.getSourceObject(0) instanceof HemiPointSource)) {
            return;
        }
        Vector3D intersection = Vector3D.INF;
        Vector3D distToImagerOrigin = this.getPositioner().getOrigin().subtract(p.getOrigin());
        Vector3D alongImagerNormal = distToImagerOrigin.getParallelComponent(this.getPositioner().getDirection());
        double d = alongImagerNormal.magSquared() / alongImagerNormal.dot(p.getDirection());
        if (d > 0.0 && (distAlongPlane = (pointOnImagerPlane = (vectToImagerPlane = p.getDirection().scale(d)).add(p.getOrigin())).subtract(this.getPositioner().getOrigin())).abs() * 2.0 < this.m_diameter.getValue().getBaseUnitValue()) {
            intersection = pointOnImagerPlane;
        }
        is.add(new PhotonInteraction(p, this, null, intersection, null, ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interact(PhotonInteraction pi, PhotonTrajectory pt) {
        this.addPhoton(pi, pt);
        AutofocusSensor autofocusSensor = this;
        synchronized (autofocusSensor) {
            Photon p = pt.getPhoton();
            Photon nP = new Photon(pi.getLocation(), p.getDirection(), p.getWavelength(), p.getPolarization(), Photon.PhotonSource.UNCHANGED, p.getIntensity(), p.getContainingObject());
            pt.addPhoton(new Photon(nP), pi);
        }
    }

    private void addPhoton(PhotonInteraction pi, PhotonTrajectory pt) {
        if (!(pt.getSourceObject(0) instanceof HemiPointSource)) {
            return;
        }
        if (pt.getNumberOfPhotons() <= 1) {
            return;
        }
        LightSource source = (LightSource)pt.getSourceObject(0);
        if (this.m_sourceAccumulators.containsKey(source)) {
            this.m_sourceAccumulators.get(source).acc(pi.getLocation(), pt.getPhoton().getDirection());
        } else {
            StatAccumulator sa = new StatAccumulator();
            sa.acc(pi.getLocation(), pt.getPhoton().getDirection());
            this.m_sourceAccumulators.put(source, sa);
        }
    }

    @Override
    public void clear() {
        this.m_sourceAccumulators = new HashMap();
    }

    @Override
    public void accept(OpticsObjectVisitor v) {
        v.visit(this);
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case DIAMETER: {
                this.m_diameter = new EquationProperty(s, this, key);
                break;
            }
            case MINIMUMS: {
                this.m_minimums = new EquationArrayProperty(s, (PropertyOwner)this, key);
                break;
            }
            case MAXIMUMS: {
                this.m_maximums = new EquationArrayProperty(s, (PropertyOwner)this, key);
                break;
            }
            case OBJECT_NAMES: {
                this.m_objectNames = new StringArrayProperty(s);
                break;
            }
            case OBJECT_PROPERTIES: {
                this.m_objectProperties = new StringArrayProperty(s);
                break;
            }
            default: {
                super.setProperty(key, s);
            }
        }
        if (this.getProperty(key) != null) {
            this.firePropertyUpdated(key);
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<UnitedValue> result = null;
        switch (key) {
            case DIAMETER: {
                result = this.m_diameter;
                break;
            }
            case MINIMUMS: {
                result = this.m_minimums;
                break;
            }
            case MAXIMUMS: {
                result = this.m_maximums;
                break;
            }
            case OBJECT_NAMES: {
                result = this.m_objectNames;
                break;
            }
            case OBJECT_PROPERTIES: {
                result = this.m_objectProperties;
                break;
            }
            default: {
                result = super.getProperty(key);
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED, PropertyKey.DIAMETER, PropertyKey.MINIMUMS, PropertyKey.MAXIMUMS, PropertyKey.OBJECT_NAMES, PropertyKey.OBJECT_PROPERTIES));
        return result;
    }

    public int getParameterCount() {
        int no = this.m_objectNames.size();
        int np = this.m_objectProperties.size();
        int nm = this.m_minimums.size();
        int nn = this.m_maximums.size();
        int result = no;
        if (result > np) {
            result = np;
        }
        if (result > nm) {
            result = nm;
        }
        if (result > nn) {
            result = nn;
        }
        return result;
    }

    @Override
    public OpticsObject makeCopy() {
        AutofocusSensor result = new AutofocusSensor();
        result.copyProperties(this);
        result.setPositioner(this.getPositioner().makeCopy());
        return result;
    }

    private class StatAccumulator {
        ArrayList<Vector3D> m_points = new ArrayList();
        private double m_avgAccX = 0.0;
        private double m_avgAccY = 0.0;
        private double m_avgAccZ = 0.0;

        private StatAccumulator() {
        }

        public void acc(Vector3D p, Vector3D d) {
            this.m_points.add(p);
            this.m_avgAccX += p.x;
            this.m_avgAccY += p.y;
            this.m_avgAccZ += p.z;
        }

        public double getError() {
            Vector3D avg = new Vector3D(this.m_avgAccX, this.m_avgAccY, this.m_avgAccZ);
            avg = avg.scale(1.0 / (double)this.m_points.size());
            double acc = 0.0;
            for (int i = 0; i < this.m_points.size(); ++i) {
                Vector3D dv = this.m_points.get(i).subtract(avg);
                double r = dv.abs();
                acc += r;
            }
            double result = acc /= (double)this.m_points.size();
            return result;
        }
    }

    public static enum ErrorType {
        VARIANCE,
        MAX_EXTENT,
        MAX_CIRCLE,
        AV_DIST_FROM_AV;

    }
}

