/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.autofocus;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sourceforge.jocular.autofocus.AutofocusSensor;
import net.sourceforge.jocular.math.SolverUpdateEvent;
import net.sourceforge.jocular.math.SolverUpdateListener;
import net.sourceforge.jocular.math.SystemSolver;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyManager;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;
import net.sourceforge.jocular.properties.StringArrayProperty;

public class AutofocusParameterTableModel
implements TableModel,
PropertyUpdatedListener,
SolverUpdateListener {
    private AutofocusSensor m_sensor;
    private OpticsProject m_project;
    private SystemSolver m_solver;
    private NumberFormat m_format = new DecimalFormat("##0.0E0");
    private final CopyOnWriteArrayList<TableModelListener> m_listeners = new CopyOnWriteArrayList();

    public AutofocusParameterTableModel(OpticsProject project, SystemSolver solver) {
        this.m_project = project;
        this.m_sensor = null;
        this.m_solver = solver;
        this.m_solver.addSolverUpdateListener(this);
    }

    @Override
    public void addTableModelListener(TableModelListener tml) {
        if (!this.m_listeners.contains(tml)) {
            this.m_listeners.add(tml);
        }
    }

    @Override
    public Class<?> getColumnClass(int c) {
        Class result;
        switch (c) {
            case 0: {
                result = StringArrayProperty.class;
                break;
            }
            case 1: {
                result = StringArrayProperty.class;
                break;
            }
            case 2: {
                result = EquationArrayProperty.class;
                break;
            }
            case 3: {
                result = EquationArrayProperty.class;
                break;
            }
            case 4: {
                result = String.class;
                break;
            }
            case 5: {
                result = String.class;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int c) {
        String result;
        switch (c) {
            case 0: {
                result = "Object";
                break;
            }
            case 1: {
                result = "Property";
                break;
            }
            case 2: {
                result = "Min Value";
                break;
            }
            case 3: {
                result = "Max Value";
                break;
            }
            case 4: {
                result = "Best Value";
                break;
            }
            case 5: {
                result = "Std. Dev.";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.m_sensor != null) {
            result = this.m_sensor.getParameterCount();
        }
        return result;
    }

    public void addRow(int i) {
        this.m_project.addPropertyEdit(this.m_sensor, PropertyKey.OBJECT_NAMES, ((StringArrayProperty)this.m_sensor.getProperty(PropertyKey.OBJECT_NAMES)).addRowToDefiningString(i));
        this.m_project.addPropertyEdit(this.m_sensor, PropertyKey.OBJECT_PROPERTIES, ((StringArrayProperty)this.m_sensor.getProperty(PropertyKey.OBJECT_PROPERTIES)).addRowToDefiningString(i));
        this.m_project.addPropertyEdit(this.m_sensor, PropertyKey.MINIMUMS, ((EquationArrayProperty)this.m_sensor.getProperty(PropertyKey.MINIMUMS)).addRowToDefiningString(i));
        this.m_project.addPropertyEdit(this.m_sensor, PropertyKey.MAXIMUMS, ((EquationArrayProperty)this.m_sensor.getProperty(PropertyKey.MAXIMUMS)).addRowToDefiningString(i));
    }

    public void deleteRow(int i) {
        if (i < 0) {
            return;
        }
        this.m_project.addPropertyEdit(this.m_sensor, PropertyKey.OBJECT_NAMES, ((StringArrayProperty)this.m_sensor.getProperty(PropertyKey.OBJECT_NAMES)).removeRowFromDefiningString(i));
        this.m_project.addPropertyEdit(this.m_sensor, PropertyKey.OBJECT_PROPERTIES, ((StringArrayProperty)this.m_sensor.getProperty(PropertyKey.OBJECT_PROPERTIES)).removeRowFromDefiningString(i));
        this.m_project.addPropertyEdit(this.m_sensor, PropertyKey.MINIMUMS, ((EquationArrayProperty)this.m_sensor.getProperty(PropertyKey.MINIMUMS)).removeRowFromDefiningString(i));
        this.m_project.addPropertyEdit(this.m_sensor, PropertyKey.MAXIMUMS, ((EquationArrayProperty)this.m_sensor.getProperty(PropertyKey.MAXIMUMS)).removeRowFromDefiningString(i));
    }

    @Override
    public Object getValueAt(int r, int c) {
        Object result;
        if (this.m_sensor == null) {
            return "null";
        }
        switch (c) {
            case 0: {
                result = (StringArrayProperty)this.m_sensor.getProperty(PropertyKey.OBJECT_NAMES);
                break;
            }
            case 1: {
                result = (StringArrayProperty)this.m_sensor.getProperty(PropertyKey.OBJECT_PROPERTIES);
                break;
            }
            case 2: {
                result = (EquationArrayProperty)this.m_sensor.getProperty(PropertyKey.MINIMUMS);
                break;
            }
            case 3: {
                result = (EquationArrayProperty)this.m_sensor.getProperty(PropertyKey.MAXIMUMS);
                break;
            }
            case 4: {
                result = this.m_format.format(this.m_solver.getBestParameterValue(r));
                break;
            }
            case 5: {
                result = this.m_format.format(this.m_solver.getStandardDeviation(r));
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        boolean result;
        switch (c) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    @Override
    public void removeTableModelListener(TableModelListener tml) {
        this.m_listeners.remove(tml);
    }

    @Override
    public void setValueAt(Object v, int r, int c) {
        System.out.println("AutofocusParameterTableModel.setValueAt value is " + v.getClass().getName() + " -> " + v.toString());
        switch (c) {
            case 0: {
                if (!(v instanceof String[])) break;
                String[] ss = (String[])v;
                String s = new StringArrayProperty(ss).getDefiningString();
                this.m_project.addPropertyEdit(this.m_sensor, PropertyKey.OBJECT_NAMES, s);
                break;
            }
            case 1: {
                if (!(v instanceof String[])) break;
                String[] ss = (String[])v;
                String s = new StringArrayProperty(ss).getDefiningString();
                this.m_project.addPropertyEdit(this.m_sensor, PropertyKey.OBJECT_PROPERTIES, s);
                break;
            }
            case 2: {
                if (!(v instanceof String[])) break;
                String[] ss = (String[])v;
                String s = new EquationArrayProperty(ss, (PropertyOwner)this.m_sensor, PropertyKey.MINIMUMS).getDefiningString();
                this.m_project.addPropertyEdit(this.m_sensor, PropertyKey.MINIMUMS, s);
                break;
            }
            case 3: {
                if (!(v instanceof String[])) break;
                String[] ss = (String[])v;
                String s = new EquationArrayProperty(ss, (PropertyOwner)this.m_sensor, PropertyKey.MAXIMUMS).getDefiningString();
                this.m_project.addPropertyEdit(this.m_sensor, PropertyKey.MAXIMUMS, s);
                break;
            }
        }
    }

    public void setSensor(AutofocusSensor s) {
        if (this.m_sensor != null) {
            this.m_sensor.removePropertyUpdatedListener(this);
        }
        this.m_sensor = s;
        if (s != null) {
            this.m_sensor.addPropertyUpdatedListener(this);
        }
        this.fireModelUpdated();
    }

    @Override
    public void propertyUpdated(PropertyUpdatedEvent e) {
        this.fireModelUpdated();
    }

    protected void fireColumnUpdated() {
        for (TableModelListener tml : this.m_listeners) {
            tml.tableChanged(new TableModelEvent(this));
        }
    }

    protected void fireModelUpdated() {
        for (TableModelListener tml : this.m_listeners) {
            tml.tableChanged(new TableModelEvent(this));
        }
    }

    protected String getObjectName(int row) {
        return ((StringArrayProperty)this.m_sensor.getProperty(PropertyKey.OBJECT_NAMES)).getValue()[row];
    }

    protected String getPropertyName(int row) {
        return ((StringArrayProperty)this.m_sensor.getProperty(PropertyKey.OBJECT_PROPERTIES)).getValue()[row];
    }

    public AutofocusSensor getSensor() {
        return this.m_sensor;
    }

    protected PropertyOwner getPropertyOwner(int i) {
        List<OpticsObject> list;
        String oName = this.getObjectName(i);
        boolean isPos = oName.endsWith(" - Pos");
        if (isPos) {
            oName = oName.substring(0, oName.length() - " - Pos".length());
        }
        if ((list = PropertyManager.getInstance().getObjectByName(this.m_project.getOpticsObject(), oName)).size() != 1) {
            throw new RuntimeException("More or less than one object found: " + list.size() + " of name \"" + oName + "\"");
        }
        PropertyOwner result = isPos ? list.get(0).getPositioner() : (PropertyOwner)list.get(0);
        return result;
    }

    public OpticsProject getProject() {
        return this.m_project;
    }

    @Override
    public void solverUpdated(SolverUpdateEvent e) {
        this.fireColumnUpdated();
    }
}

