/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.autofocus;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.StringArrayProperty;
import net.sourceforge.jocular.settings.Settings;

public class AutofocusParameterCellRenderer
extends JLabel
implements TableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(table.getBackground());
        if (isSelected) {
            this.setOpaque(true);
            this.setBorder(new LineBorder(Color.BLACK));
        } else {
            this.setOpaque(true);
            this.setBorder(null);
        }
        if (value instanceof StringArrayProperty) {
            StringArrayProperty sap = (StringArrayProperty)value;
            if (sap.getValue().length > 0) {
                this.setText(sap.getValue()[row]);
            } else {
                switch (column) {
                    case 0: {
                        this.setText("Click to specify object.");
                        break;
                    }
                    case 1: {
                        this.setText("Click to specify property");
                        break;
                    }
                    default: {
                        this.setText("null");
                    }
                }
            }
        } else if (value instanceof EquationArrayProperty) {
            EquationArrayProperty eap = (EquationArrayProperty)value;
            if (eap.getDefiningStrings().length > 0) {
                UnitedValue v = eap.getValue()[row];
                switch (Settings.SETTINGS.getNumberDisplay()) {
                    case EQUATION: {
                        this.setText(eap.getDefiningStrings()[row]);
                        break;
                    }
                    case METRIC: {
                        this.setText(v.getBaseUnitString());
                        break;
                    }
                    default: {
                        this.setText("Imperial view not implemented yet.");
                    }
                }
                if (v.isError()) {
                    this.setBackground(new Color(1.0f, 0.5f, 0.5f));
                    this.setToolTipText(v.getErrorText());
                } else if (v.isSimpleValue()) {
                    this.setBackground(new Color(0.5f, 1.0f, 0.5f));
                } else {
                    this.setBackground(new Color(0.5f, 0.5f, 1.0f));
                }
            } else {
                this.setText("");
            }
        }
        return this;
    }
}

