/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.autofocus;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import net.sourceforge.jocular.autofocus.AutofocusParameterTableModel;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyManager;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.StringArrayProperty;

public class AutofocusParameterCellEditor
implements TableCellEditor {
    OpticsProject m_project;
    AutofocusParameterTableModel m_model;
    String[] m_definingStrings = new String[0];
    int m_indexEditing = 0;
    int m_editingColumn = 0;
    protected static final String POSITIONER_SUFFIX = " - Pos";
    JComboBox<String> m_stringCombo = new JComboBox();
    JTextField m_textField = new JTextField();
    private List<CellEditorListener> m_listeners = new CopyOnWriteArrayList<CellEditorListener>();

    public AutofocusParameterCellEditor(OpticsProject project, AutofocusParameterTableModel model) {
        this.m_project = project;
        this.m_model = model;
        this.m_stringCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AutofocusParameterCellEditor.this.fireEditingStopped();
            }
        });
        this.m_textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutofocusParameterCellEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCancelled();
    }

    @Override
    public Object getCellEditorValue() {
        String v = null;
        switch (this.m_editingColumn) {
            case 0: {
                v = this.m_stringCombo.getItemAt(this.m_stringCombo.getSelectedIndex());
                break;
            }
            case 1: {
                v = this.m_stringCombo.getItemAt(this.m_stringCombo.getSelectedIndex());
                break;
            }
            case 2: {
                v = this.m_textField.getText();
                break;
            }
            case 3: {
                v = this.m_textField.getText();
                break;
            }
        }
        this.m_definingStrings[this.m_indexEditing] = v;
        return this.m_definingStrings;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public boolean shouldSelectCell(EventObject e) {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComponent result = null;
        switch (column) {
            case 0: {
                if (value instanceof StringArrayProperty) {
                    StringArrayProperty sap = (StringArrayProperty)value;
                    this.m_indexEditing = row;
                    this.m_editingColumn = column;
                    this.m_definingStrings = sap.getValue();
                }
                this.updateComboWithObjects();
                result = this.m_stringCombo;
                break;
            }
            case 1: {
                if (value instanceof StringArrayProperty) {
                    StringArrayProperty sap = (StringArrayProperty)value;
                    this.m_indexEditing = row;
                    this.m_editingColumn = column;
                    this.m_definingStrings = sap.getValue();
                }
                this.updateComboWithProperties(this.m_model.getObjectName(row));
                result = this.m_stringCombo;
                break;
            }
            case 2: {
                if (!(value instanceof EquationArrayProperty)) break;
                EquationArrayProperty eap = (EquationArrayProperty)value;
                this.m_indexEditing = row;
                this.m_editingColumn = column;
                this.m_definingStrings = eap.getDefiningStrings();
                this.m_textField.setText(this.m_definingStrings[row]);
                result = this.m_textField;
                break;
            }
            case 3: {
                if (!(value instanceof EquationArrayProperty)) break;
                EquationArrayProperty eap = (EquationArrayProperty)value;
                this.m_definingStrings = eap.getDefiningStrings();
                this.m_textField.setText(eap.getDefiningStrings()[row]);
                this.m_indexEditing = row;
                this.m_editingColumn = column;
                result = this.m_textField;
                break;
            }
        }
        return result;
    }

    private void updateComboWithObjects() {
        this.m_stringCombo.removeAllItems();
        this.m_stringCombo.setSelectedItem(null);
        Collection<OpticsObject> os = this.m_project.getFlattenedOpticsObjects(false);
        for (OpticsObject o : os) {
            String n = o.getName();
            if (n.trim().equals("")) {
                n = o.getID().toHashString();
            }
            this.m_stringCombo.addItem(n);
            this.m_stringCombo.addItem(n + POSITIONER_SUFFIX);
        }
    }

    private void updateComboWithProperties(String objectName) {
        this.m_stringCombo.removeAllItems();
        this.m_stringCombo.setSelectedItem(null);
        PropertyOwner po = AutofocusParameterCellEditor.getPropertyOwner(this.m_project, objectName);
        List<PropertyKey> pks = po.getPropertyKeys();
        ArrayList<PropertyKey> pks2 = new ArrayList<PropertyKey>();
        for (PropertyKey pk : pks) {
            if (!(po.getProperty(pk) instanceof EquationProperty)) continue;
            pks2.add(pk);
        }
        for (PropertyKey pk : pks2) {
            this.m_stringCombo.addItem(pk.getDescription());
        }
    }

    private static PropertyOwner getPropertyOwner(OpticsProject project, String s) {
        List<OpticsObject> os;
        PropertyOwner result = null;
        String name = s;
        boolean objectNotPositioner = true;
        if (s.endsWith(POSITIONER_SUFFIX)) {
            objectNotPositioner = false;
            name = s.substring(0, s.length() - POSITIONER_SUFFIX.length());
        }
        if ((os = PropertyManager.getInstance().getObjectByName(project.getOpticsObject(), name)).size() != 1) {
            throw new RuntimeException("Object not specified enough. \"" + s + "\"");
        }
        result = objectNotPositioner ? (PropertyOwner)os.get(0) : os.get(0).getPositioner();
        return result;
    }

    private void fireEditingStopped() {
        for (CellEditorListener ce : this.m_listeners) {
            ce.editingStopped(new ChangeEvent(this));
        }
    }

    private void fireEditingCancelled() {
        for (CellEditorListener ce : this.m_listeners) {
            ce.editingStopped(new ChangeEvent(this));
        }
    }
}

