/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.autofocus;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.jocular.autofocus.AutofocusParameterCellEditor;
import net.sourceforge.jocular.autofocus.AutofocusParameterCellRenderer;
import net.sourceforge.jocular.autofocus.AutofocusParameterTableModel;
import net.sourceforge.jocular.autofocus.AutofocusSensor;
import net.sourceforge.jocular.autofocus.AutofocusSystemToSolve;
import net.sourceforge.jocular.graphs.GraphPanel;
import net.sourceforge.jocular.math.MultiMinimumSolver;
import net.sourceforge.jocular.math.SolverUpdateEvent;
import net.sourceforge.jocular.math.SolverUpdateListener;
import net.sourceforge.jocular.math.SystemSolver;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyManager;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.StringArrayProperty;

public class AutofocusDialog
extends JDialog {
    protected static final String ERROR_SERIES = "Error";
    protected static final String FIT_SERIES = "Fit";
    private static final int NUM_PHOTONS_PER_CALC = 2000;
    private OpticsProject m_project;
    private GraphPanel m_graph;
    private JComboBox<AutofocusSensor> m_autofocusCombo;
    private final SystemSolver m_solver = new MultiMinimumSolver();
    private final AutofocusParameterTableModel m_tableModel;
    private JButton m_startButton;
    private String[] m_errorSeriesKeys;
    private String[] m_fitSeriesKeys;
    private JTable m_table;

    public AutofocusDialog(Frame owner, OpticsProject project) {
        super(owner, "Autofocus Solver");
        this.m_project = project;
        this.m_tableModel = new AutofocusParameterTableModel(this.m_project, this.m_solver);
        this.m_solver.addSolverUpdateListener(new SolverUpdateListener(){

            @Override
            public void solverUpdated(SolverUpdateEvent e) {
                if (AutofocusDialog.this.m_solver.isSolved()) {
                    JOptionPane.showMessageDialog(AutofocusDialog.this, "System solved.");
                }
                if (AutofocusDialog.this.m_solver.isRunning()) {
                    AutofocusDialog.this.m_startButton.setText("Stop");
                } else {
                    AutofocusDialog.this.m_startButton.setText("Start");
                }
                AutofocusDialog.this.updateGraph();
            }
        });
        this.m_graph = new GraphPanel();
        this.m_graph.setGraphType(GraphPanel.GraphType.XY_DOT);
        this.m_graph.autoScale(true, false, true, false);
        this.m_graph.setPreferredSize(new Dimension(400, 400));
        this.m_autofocusCombo = new JComboBox();
        this.m_autofocusCombo.setRenderer(new ObjectComboRenderer());
        this.m_autofocusCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                AutofocusDialog.this.m_tableModel.setSensor(AutofocusDialog.this.m_autofocusCombo.getItemAt(AutofocusDialog.this.m_autofocusCombo.getSelectedIndex()));
            }
        });
        this.setSize(new Dimension(500, 400));
        Box b = Box.createVerticalBox();
        b.add(this.m_graph);
        JPanel p1 = new JPanel();
        p1.add(new JLabel("Autofocus Sensor:"));
        p1.add(this.m_autofocusCombo);
        b.add(p1);
        this.m_table = new JTable(this.m_tableModel);
        AutofocusParameterCellRenderer apcr = new AutofocusParameterCellRenderer();
        AutofocusParameterCellEditor apce = new AutofocusParameterCellEditor(this.m_project, this.m_tableModel);
        this.m_table.setDefaultRenderer(StringArrayProperty.class, apcr);
        this.m_table.setDefaultRenderer(EquationArrayProperty.class, apcr);
        this.m_table.setDefaultEditor(StringArrayProperty.class, apce);
        this.m_table.setDefaultEditor(EquationArrayProperty.class, apce);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                Point p = e.getPoint();
                int r = AutofocusDialog.this.m_table.rowAtPoint(p);
                AutofocusDialog.this.m_table.getSelectionModel().setSelectionInterval(r, r);
            }
        });
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (AutofocusDialog.this.m_table.isEditing()) {
                    AutofocusDialog.this.m_table.getCellEditor().stopCellEditing();
                }
            }
        });
        b.add(new JScrollPane(this.m_table));
        Box p4 = Box.createHorizontalBox();
        b.add(p4);
        JButton addRowButton = new JButton("Add parameter");
        addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutofocusDialog.this.m_tableModel.addRow(AutofocusDialog.this.m_tableModel.getRowCount());
            }
        });
        JButton deleteRowButton = new JButton("Delete parameter");
        deleteRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = AutofocusDialog.this.m_table.getSelectedRow();
                if (i < 0) {
                    JOptionPane.showMessageDialog(AutofocusDialog.this, "Must select row in order to delete.");
                } else {
                    AutofocusDialog.this.m_tableModel.deleteRow(i);
                }
            }
        });
        p4.add(addRowButton);
        p4.add(deleteRowButton);
        p4.add(new JLabel());
        p4.add(new JLabel());
        Box p3 = Box.createHorizontalBox();
        this.m_startButton = new JButton("Start");
        this.m_startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutofocusDialog.this.runAutofocus();
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutofocusDialog.this.m_solver.stop();
                AutofocusDialog.this.dispose();
            }
        });
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutofocusDialog.this.updateAutofocusCombo();
                AutofocusDialog.this.m_solver.reset();
                AutofocusDialog.this.m_graph.removeAllSeries();
            }
        });
        JButton acceptButton = new JButton("Accept");
        acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                for (int i = 0; i < AutofocusDialog.this.m_solver.getParameterCount(); ++i) {
                    PropertyKey pk = PropertyManager.getInstance().getPropertyKey(AutofocusDialog.this.m_tableModel.getPropertyOwner(i), AutofocusDialog.this.m_tableModel.getPropertyName(i));
                    AutofocusDialog.this.m_tableModel.getProject().addPropertyEdit(AutofocusDialog.this.m_tableModel.getPropertyOwner(i), pk, Double.toString(AutofocusDialog.this.m_solver.getBestParameterValue(i)));
                }
            }
        });
        this.m_startButton.setToolTipText("Start & Stop sovler.");
        clearButton.setToolTipText("Clear the state of the solver. Also stops it if it's running.");
        acceptButton.setToolTipText("Accepts the current best values.");
        closeButton.setToolTipText("Close this dialog.");
        p3.add(this.m_startButton);
        p3.add(clearButton);
        p3.add(acceptButton);
        p3.add(closeButton);
        b.add(p3);
        this.add(b);
        this.updateAutofocusCombo();
    }

    private void updateAutofocusCombo() {
        AutofocusSensor afs = this.m_autofocusCombo.getItemAt(this.m_autofocusCombo.getSelectedIndex());
        this.m_autofocusCombo.removeAllItems();
        Collection<OpticsObject> os = this.m_project.getFlattenedOpticsObjects(false);
        for (OpticsObject o : os) {
            if (!(o instanceof AutofocusSensor)) continue;
            this.m_autofocusCombo.addItem((AutofocusSensor)o);
        }
        if (afs != null) {
            this.m_autofocusCombo.setSelectedItem(afs);
        } else {
            this.m_autofocusCombo.setSelectedItem(0);
        }
    }

    protected static void updateObjectCombo(JComboBox<ObjectComboItem> jcb, OpticsProject project) {
        ObjectComboItem oo = jcb.getItemAt(jcb.getSelectedIndex());
        jcb.removeAllItems();
        Collection<OpticsObject> os = project.getFlattenedOpticsObjects(false);
        for (OpticsObject o : os) {
            jcb.addItem(new ObjectComboItem(o, null));
            jcb.addItem(new ObjectComboItem(o, o.getPositioner()));
        }
        ObjectComboItem soci = null;
        if (oo != null) {
            for (int i = 0; i < jcb.getItemCount(); ++i) {
                if (!oo.equals(jcb.getItemAt(i))) continue;
                soci = jcb.getItemAt(i);
            }
            if (soci != null) {
                jcb.setSelectedItem(soci);
            }
        } else {
            jcb.setSelectedItem(0);
        }
    }

    protected static void updatePropertyCombo(JComboBox<ObjectComboItem> ocb, JComboBox<PropertyKey> pcb) {
        if (ocb.getItemCount() == 0) {
            return;
        }
        PropertyKey pk = pcb.getItemAt(pcb.getSelectedIndex());
        int ioci = ocb.getSelectedIndex();
        if (ioci == -1) {
            ioci = 0;
        }
        Collection<PropertyKey> ps = null;
        if (ocb.getItemCount() != 0) {
            ps = ocb.getItemAt(ioci).getPropertyKeys();
            pcb.removeAll();
        }
        ObjectComboItem oci = ocb.getItemAt(ocb.getSelectedIndex());
        ArrayList<PropertyKey> ps2 = new ArrayList<PropertyKey>();
        for (PropertyKey pkt : ps) {
            if (!(oci.getPropertyOwner().getProperty(pkt) instanceof EquationProperty)) continue;
            ps2.add(pkt);
        }
        ps = ps2;
        for (PropertyKey pkt : ps) {
            boolean exists = false;
            for (int i = 0; i < pcb.getItemCount(); ++i) {
                if (pcb.getItemAt(i) != pkt) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            pcb.addItem(pkt);
        }
        int i = 0;
        while (ps.size() < pcb.getItemCount()) {
            if (!ps.contains((Object)pcb.getItemAt(i))) {
                pcb.removeItemAt(i);
                continue;
            }
            ++i;
        }
        if (pk == null) {
            pcb.setSelectedIndex(0);
        } else {
            pcb.setSelectedItem((Object)pk);
        }
    }

    private void runAutofocus() {
        if (this.m_solver.isRunning()) {
            this.m_solver.stop();
            this.m_startButton.setText("Start");
        } else {
            int n = this.m_tableModel.getRowCount();
            this.m_errorSeriesKeys = new String[n];
            this.m_fitSeriesKeys = new String[n];
            for (int i = 0; i < n; ++i) {
                this.m_errorSeriesKeys[i] = "Error Series " + i;
                this.m_fitSeriesKeys[i] = "Fit Series " + i;
            }
            this.m_solver.solve(new AutofocusSystemToSolve(this.m_tableModel, 2000));
            this.m_startButton.setText("Stop");
        }
    }

    protected void updateGraph() {
        int n = this.m_solver.getParameterCount();
        for (int i = 0; i < n; ++i) {
            double[] xs = this.m_solver.getParameterPlotValues(i);
            double[] ys = this.m_solver.getErrorPlotValues();
            this.m_graph.updateGraph(this.m_errorSeriesKeys[i], xs, ys);
            this.m_graph.setSeriesType(this.m_errorSeriesKeys[i], GraphPanel.GraphType.XY_DOT);
            this.m_graph.setSeriesDotType(this.m_errorSeriesKeys[i], GraphPanel.DotType.CIRCLE);
            this.m_graph.setSeriesSize(this.m_errorSeriesKeys[i], 5.0, 1.0);
            this.m_graph.updateGraph(this.m_fitSeriesKeys[i], this.m_solver.getFitXPlotValues(i), this.m_solver.getFitYPlotValues());
            this.m_graph.setSeriesType(this.m_fitSeriesKeys[i], GraphPanel.GraphType.XY_LINE);
            this.m_graph.setSeriesSize(this.m_fitSeriesKeys[i], 5.0, 1.0);
        }
        this.m_graph.autoScale(true, false, true, false);
        this.m_graph.repaint();
    }

    protected static class ObjectComboItem {
        private final OpticsObject m_object;
        private final ObjectPositioner m_pos;

        ObjectComboItem(OpticsObject oo, ObjectPositioner op) {
            if (oo == null) {
                throw new RuntimeException("Object is null.");
            }
            this.m_object = oo;
            this.m_pos = op;
        }

        public String toString() {
            if (this.m_pos == null) {
                return this.m_object.getName();
            }
            return this.m_object.getName() + " - Pos";
        }

        public Collection<PropertyKey> getPropertyKeys() {
            if (this.m_pos == null) {
                return this.m_object.getPropertyKeys();
            }
            return this.m_pos.getPropertyKeys();
        }

        public PropertyOwner getPropertyOwner() {
            if (this.m_pos == null) {
                return this.m_object;
            }
            return this.m_pos;
        }

        public boolean equals(ObjectComboItem oci) {
            return oci.m_object == this.m_object && oci.m_pos == this.m_pos;
        }
    }

    protected static class ObjectItemComboRenderer
    extends JLabel
    implements ListCellRenderer<ObjectComboItem> {
        protected ObjectItemComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ObjectComboItem> list, ObjectComboItem value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(value.toString());
            return this;
        }
    }

    protected class ObjectComboRenderer
    extends JLabel
    implements ListCellRenderer<AutofocusSensor> {
        protected ObjectComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AutofocusSensor> list, AutofocusSensor value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            String s = value.getName();
            if (s.equals("")) {
                s = value.getID().toHashString();
            }
            this.setText(value.getName());
            return this;
        }
    }
}

