/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import net.sourceforge.jocular.Jocular;
import net.sourceforge.jocular.actions.OpticsAction;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;
import net.sourceforge.jocular.settings.Settings;

public class OpticsMenuBar
extends JMenuBar {
    private final JMenu toolsMenu = new JMenu("Tools");
    private final JMenu viewMenu = new JMenu("View");
    private final JMenu fileMenu = new JMenu("File");
    private final JMenu editMenu = new JMenu("Edit");
    private final JMenu simMenu = new JMenu("Sim");
    private final JMenu helpMenu = new JMenu("Help");
    private final JMenu recentFilesMenu = new JMenu("Recent Files...");

    public OpticsMenuBar() {
        this.recentFilesMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpticsMenuBar.this.updateRecentFilesMenu();
            }
        });
        Settings.SETTINGS.addPropertyUpdatedListener(new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
                if (e.getPropertyKey() == PropertyKey.RECENT_FILES) {
                    OpticsMenuBar.this.updateRecentFilesMenu();
                }
            }
        });
        this.updateRecentFilesMenu();
        this.fileMenu.setMnemonic(70);
        this.editMenu.setMnemonic(69);
        this.toolsMenu.setMnemonic(84);
        this.viewMenu.setMnemonic(86);
        this.simMenu.setMnemonic(83);
        this.helpMenu.setMnemonic(72);
        this.fileMenu.add(OpticsAction.LOAD);
        this.fileMenu.add(OpticsAction.SAVE);
        this.fileMenu.add(OpticsAction.SAVE_AS);
        this.fileMenu.add(this.recentFilesMenu);
        this.fileMenu.add(OpticsAction.NEW);
        this.fileMenu.add(OpticsAction.PRINT);
        this.fileMenu.add(OpticsAction.CAPTURE_SCREEN);
        this.fileMenu.add(OpticsAction.EXIT);
        this.editMenu.add(OpticsAction.UNDO);
        this.editMenu.add(OpticsAction.REDO);
        this.editMenu.addSeparator();
        this.editMenu.add(OpticsAction.CUT);
        this.editMenu.add(OpticsAction.COPY);
        this.editMenu.add(OpticsAction.PASTE);
        this.editMenu.add(OpticsAction.DELETE_OBJECT);
        this.editMenu.addSeparator();
        this.editMenu.add(OpticsMenuBar.makeAddSubMenu());
        this.viewMenu.add(OpticsAction.ZOOM_IN);
        this.viewMenu.add(OpticsAction.ZOOM_OUT);
        this.viewMenu.add(OpticsAction.ZOOM_EXTENTS);
        this.viewMenu.add(this.getViewPlaneSubMenu());
        this.viewMenu.addSeparator();
        this.viewMenu.add(OpticsAction.SIZE_SPLITS);
        this.viewMenu.add(OpticsAction.RESET_WINDOWS);
        this.simMenu.add(OpticsAction.OPEN_IMAGER_WINDOW);
        this.simMenu.add(OpticsAction.CALC_PHOTONS);
        this.simMenu.add(OpticsAction.CALC_DISPLAY_PHOTONS);
        this.simMenu.add(OpticsAction.CLEAR_IMAGERS);
        this.simMenu.add(OpticsAction.STOP_WRANGLER);
        this.toolsMenu.add(OpticsAction.SETTINGS);
        this.toolsMenu.add(OpticsAction.GLOBAL_VARIABLES_SHOW);
        this.toolsMenu.add(OpticsAction.COPY_TRAJECTORY);
        this.toolsMenu.add(OpticsAction.EXPORT_MATERIALS);
        this.helpMenu.add(OpticsAction.HELP);
        this.helpMenu.add(OpticsAction.WEBSITE);
        this.helpMenu.add(OpticsAction.ABOUT);
        this.add(this.fileMenu);
        this.add(this.editMenu);
        this.add(this.viewMenu);
        this.add(this.simMenu);
        this.add(this.toolsMenu);
        this.add(this.helpMenu);
    }

    private JMenu getViewPlaneSubMenu() {
        JMenu panel1Menu = new JMenu("Select View Plane");
        JRadioButtonMenuItem panelXY = new JRadioButtonMenuItem(OpticsAction.SET_VIEW_PLANE_TO_XY);
        JRadioButtonMenuItem panelZY = new JRadioButtonMenuItem(OpticsAction.SET_VIEW_PLANE_TO_ZY);
        JRadioButtonMenuItem panelZX = new JRadioButtonMenuItem(OpticsAction.SET_VIEW_PLANE_TO_ZX);
        panelZY.setSelected(true);
        ButtonGroup panel1Group = new ButtonGroup();
        panel1Group.add(panelZY);
        panel1Group.add(panelZX);
        panel1Group.add(panelXY);
        panel1Menu.add(panelZY);
        panel1Menu.add(panelZX);
        panel1Menu.add(panelXY);
        return panel1Menu;
    }

    private JMenu getClipPlaneSubMenu() {
        JMenu clipMenu = new JMenu("Select Clip Plane...");
        JRadioButtonMenuItem rbN = new JRadioButtonMenuItem(OpticsAction.SET_CLIP_PLANE_TO_NONE);
        JRadioButtonMenuItem rbXY = new JRadioButtonMenuItem(OpticsAction.SET_CLIP_PLANE_TO_XY);
        JRadioButtonMenuItem rbZX = new JRadioButtonMenuItem(OpticsAction.SET_CLIP_PLANE_TO_ZX);
        JRadioButtonMenuItem rbZY = new JRadioButtonMenuItem(OpticsAction.SET_CLIP_PLANE_TO_ZY);
        rbN.setSelected(true);
        ButtonGroup clipGroup = new ButtonGroup();
        clipGroup.add(rbN);
        clipGroup.add(rbZY);
        clipGroup.add(rbZX);
        clipGroup.add(rbXY);
        clipMenu.add(rbN);
        clipMenu.add(rbZY);
        clipMenu.add(rbZX);
        clipMenu.add(rbXY);
        return clipMenu;
    }

    protected static JMenu makeAddSubMenu() {
        JMenu addMenu = new JMenu("Add...");
        addMenu.add(new JMenuItem(OpticsAction.ADD_SPHERICAL_LENS));
        addMenu.add(new JMenuItem(OpticsAction.ADD_GROUP));
        addMenu.add(new JMenuItem(OpticsAction.ADD_IMAGER));
        addMenu.add(new JMenuItem(OpticsAction.ADD_POINT_SOURCE));
        addMenu.add(new JMenuItem(OpticsAction.ADD_TRIANGULAR_PRISM));
        addMenu.add(new JMenuItem(OpticsAction.ADD_IMAGE_SOURCE));
        addMenu.add(new JMenuItem(OpticsAction.ADD_SIMPLE_APERTURE));
        addMenu.add(new JMenuItem(OpticsAction.ADD_SPECTROPHOTOMETER));
        addMenu.add(new JMenuItem(OpticsAction.ADD_AUTOFOCUS_SENSOR));
        addMenu.add(new JMenuItem(OpticsAction.ADD_ROTATED_SPLINE));
        addMenu.add(new JMenuItem(OpticsAction.ADD_EXTRUDED_SPLINE));
        addMenu.add(new JMenuItem(OpticsAction.ADD_PLANO_ASPHERIC_LENS));
        addMenu.add(new JMenuItem(OpticsAction.ADD_PART));
        addMenu.add(new JMenuItem(OpticsAction.ADD_MESH_OBJECT));
        return addMenu;
    }

    public void updateRecentFilesMenu() {
        File[] fs = Settings.SETTINGS.getRecentFiles();
        this.recentFilesMenu.removeAll();
        File[] fileArray = fs;
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            JMenuItem jmi = new JMenuItem(f.getName());
            jmi.setToolTipText(f.getAbsolutePath());
            this.addRecentFileListener(jmi);
            this.recentFilesMenu.add(jmi);
            ++n2;
        }
    }

    private void addRecentFileListener(final JMenuItem jmi) {
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Jocular app = OpticsAction.getApp(e);
                app.open(new File(jmi.getToolTipText()));
            }
        });
    }
}

