/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import net.sourceforge.jocular.ImagerWindow;
import net.sourceforge.jocular.Jocular;
import net.sourceforge.jocular.JocularWindow;
import net.sourceforge.jocular.gui.panel.OutputPanel3d;
import net.sourceforge.jocular.objects.OpticsObjectKey;
import net.sourceforge.jocular.util.ResourceTools;

public enum OpticsAction implements Action
{
    ABOUT("About", null, "about.png", "Call up an about dialog.", 65, ae -> OpticsAction.getApp(ae).about()),
    ADD_AUTOFOCUS_SENSOR("Autofocus Sensor", null, "addObject.png", "Add an autofocus sensor to the tree.", 65, ae -> OpticsAction.getApp(ae).addObject(OpticsObjectKey.AUTOFOCUS_SENSOR)),
    ADD_GROUP("Group", null, "addObject.png", "Add a group to the tree.", 65, ae -> OpticsAction.getApp(ae).addObject(OpticsObjectKey.OPTICS_GROUP)),
    ADD_IMAGE_SOURCE("Image Source", null, "addObject.png", "Add an image source to the tree.", 73, ae -> OpticsAction.getApp(ae).addObject(OpticsObjectKey.IMAGE_SOURCE)),
    ADD_IMAGER("Imager", null, "addObject.png", "Add an imager to the tree.", 65, ae -> OpticsAction.getApp(ae).addObject(OpticsObjectKey.IMAGER)),
    ADD_OBJECT("Add Object", null, "addObject.png", "Add an object to the tree.", 65, ae -> OpticsAction.getApp(ae).addObject(null)),
    ADD_PART("Add Part", null, "addObject.png", "Add a project as a sub-part of this project.", 80, ae -> OpticsAction.getApp(ae).addPart()),
    ADD_PLANO_ASPHERIC_LENS("Add Plano-aspheric Lens", null, "addObject.png", "Add a plano-aspheric lens to the tree.", 80, ae -> OpticsAction.getApp(ae).addObject(OpticsObjectKey.PLANO_ASPHERIC_LENS)),
    ADD_POINT_SOURCE("Point Source", null, "addObject.png", "Add a point source to the tree.", 65, ae -> OpticsAction.getApp(ae).addObject(OpticsObjectKey.POINT_SOURCE)),
    ADD_ROTATED_SPLINE("Rotated Spline", null, "addObject.png", "Add an object defined by a rotated spline curve.", 82, ae -> OpticsAction.getApp(ae).addObject(OpticsObjectKey.ROTATED_SPLINE)),
    ADD_EXTRUDED_SPLINE("Extruded Spline", null, "addObject.png", "Add an object defined by an extruded spline curve.", 82, ae -> OpticsAction.getApp(ae).addObject(OpticsObjectKey.EXTRUDED_SPLINE)),
    ADD_SIMPLE_APERTURE("Simple Aperture", null, "simpleAperture.png", "Add a simple aperture to the tree.", 65, ae -> OpticsAction.getApp(ae).addObject(OpticsObjectKey.SIMPLE_APERTURE)),
    ADD_SPECTROPHOTOMETER("Spectrophotometer", null, "addObject.png", "Add a spectrophotometer to the tree.", 83, ae -> OpticsAction.getApp(ae).addObject(OpticsObjectKey.SPECTROPHOTOMETER)),
    ADD_SPHERICAL_LENS("Spherical Lens", null, "addObject.png", "Add a spherical lens to the tree.", 65, ae -> OpticsAction.getApp(ae).addObject(OpticsObjectKey.SPHERICAL_LENS)),
    ADD_MESH_OBJECT("Mesh Object", null, "addObject.png", "Add object defined from mesh file like STL", 0, ae -> OpticsAction.getApp(ae).addObject(OpticsObjectKey.MESH_OBJECT)),
    ADD_TRIANGULAR_PRISM("Triangular Prism", null, "addObject.png", "Add a triangular prism to the tree.", 80, ae -> OpticsAction.getApp(ae).addObject(OpticsObjectKey.TRIANGULAR_PRISM)),
    AUTOFOCUS("Autofocus Dialog", null, "autofocus.png", "Vary an object parameter to optimize image focus.", 65, ae -> OpticsAction.getApp(ae).autofocus()),
    CALC_DISPLAY_PHOTONS("Calc a Few Photons", null, "calcPhotons24.png", "Calculate just a few more photons", 70, "F6", ae -> OpticsAction.getApp(ae).calcAFewPhotons()),
    CALC_PHOTONS("Calc Photons", null, "calcManyPhotons24.png", "Calculate more photons", 67, "F5", ae -> OpticsAction.getApp(ae).calcPhotons()),
    CAPTURE_SCREEN("Capture Screen", null, "captureScreen.png", "Grab the screen and save to an image file", 65, ae -> OpticsAction.getApp(ae).captureScreen()),
    CHOOSE_MESH_FILE("Choose Mesh File", null, "fileOpen.png", "Choose the mesh file to define this optics object.", 0, ae -> OpticsAction.getApp(ae).chooseMeshFile()),
    CLEAR_IMAGERS("Clear", null, "clear24.png", "Clear imager data.", 67, ae -> OpticsAction.getApp(ae).clearImagers()),
    COPY("Copy", null, "copy.png", "Copy the selected tree object to the clipboard.", 67, "control C", ae -> OpticsAction.getApp(ae).copy()),
    COPY_TRAJECTORY("Copy trajectory", null, "copy.png", "Copy the last photon trajectory to the clipboard as a CSV.", 67, "control T", ae -> OpticsAction.getApp(ae).copyTrajectoryToClipboard()),
    CUT("Cut", null, "cut.png", "Cut the selected tree object to the clipboard.", 85, "control X", ae -> OpticsAction.getApp(ae).cut()),
    DEFINE_IMAGE("Define image", null, "defineImage.png", "Define the image that this Image Source displays.", 77, ae -> OpticsAction.getApp(ae).defineImage()),
    DELETE_OBJECT("Delete Object", null, "delete.png", "Delete an object from the tree.", 68, "DELETE", ae -> OpticsAction.getApp(ae).deleteObject()),
    EXIT("Exit", null, "exit24.png", "Exit the application", 88, "ctrl shift X", ae -> OpticsAction.getApp(ae).exit()),
    EXPORT_IMAGER_DATA("Export Imager Data", null, "exportImagerData.png", "Save data from imager to a CSV.", 0, "", ae -> OpticsAction.getApp(ae).exportImagerData()),
    EXPORT_MATERIALS("Export Materials", null, "export.png", "Export a CSV of all Materials.", 69, ae -> OpticsAction.getApp(ae).exportMaterials()),
    HELP("Help", null, "help.png", "Link to the jOcular help website.", 72, ae -> OpticsAction.getApp(ae).help()),
    LOAD("Open", null, "load24.png", "Open a project", 79, ae -> OpticsAction.getApp(ae).open()),
    LOAD_IMAGER_DATA("Load Imager Data", null, "loadImagerData.png", "Load data into imager calculated from a previous run.", 76, "control alt L", ae -> OpticsAction.getApp(ae).loadImagerData()),
    MOVE_DOWN_IN_TREE("Move Down", null, "arrowDown.png", "Move the selected object down in the project tree.", 68, "control D", ae -> OpticsAction.getApp(ae).moveInTree(false)),
    MOVE_UP_IN_TREE("Move Up", null, "arrowUp.png", "Move the selected object up in the project tree.", 85, "control U", ae -> OpticsAction.getApp(ae).moveInTree(true)),
    NEW("New", null, "new.png", "Start a new project", 78, ae -> OpticsAction.getApp(ae).newProject()),
    NULL("Null", null, null, "An action was referenced that does not exist in the action list.", 78, ae -> OpticsAction.getApp(ae)),
    OBJECT_INFO("Object Info", null, "info.png", "Show details of the selected object.", 73, ae -> OpticsAction.getApp(ae).objectInfo()),
    OPEN_IMAGER_WINDOW("Open an Imager Window", null, "imager24.png", "Opens a new imager windower.", 73, "alt shift I", ae -> OpticsAction.getApp(ae).openImagerWindow()),
    PASTE("Paste", null, "paste.png", "Paste the clipboard contents to the selected tree object.", 80, "control V", ae -> OpticsAction.getApp(ae).paste()),
    PRINT("Print", null, "print.png", "Prints the dialog to a printer", 80, ae -> OpticsAction.getApp(ae).printScreen()),
    REDO("Redo", null, "redo24.png", "Redo last operation that was undone", 82, "ctrl Y", ae -> OpticsAction.getApp(ae).redo()),
    REDRAW("Redraw", null, "redraw.png", "Redraw view", 82, "ctrl shift R", ae -> OpticsAction.getApp(ae).redraw()),
    RESET_WINDOWS("Reset Windows", null, "resetWindow.png", "Reset all windows to their default location, size, etc.", 82, "alt shift R", ae -> OpticsAction.getApp(ae).resetWindows()),
    SAVE("Save", null, "save24.png", "Saves the current project", 83, "control S", ae -> OpticsAction.getApp(ae).save(false)),
    SAVE_AS("Save As", null, "save24.png", "Saves the current data with a new name", 65, ae -> OpticsAction.getApp(ae).save(true)),
    SAVE_IMAGER_DATA("Save Imager Data", null, "saveImagerData.png", "Save data from imager for a future run.", 83, "control alt S", ae -> OpticsAction.getApp(ae).saveImagerData()),
    SET_CLIP_PLANE_TO_NONE("No Clip", null, "noClip24.png", "Set clip plane to none", 78, "shift 0", ae -> OpticsAction.getApp(ae).setClipPlane(OutputPanel3d.ViewPlane.NONE)),
    SET_CLIP_PLANE_TO_ZY("ZY Clip", null, "zyClip24.png", "Set clip plane to ZY plane", 90, "shift 1", ae -> OpticsAction.getApp(ae).setClipPlane(OutputPanel3d.ViewPlane.ZY_PLANE)),
    SET_CLIP_PLANE_TO_ZX("ZX Clip", null, "zxClip24.png", "Set clip plane to ZX plane", 89, "shift 2", ae -> OpticsAction.getApp(ae).setClipPlane(OutputPanel3d.ViewPlane.ZX_PLANE)),
    SET_CLIP_PLANE_TO_XY("XY Clip", null, "xyClip24.png", "Set clip plane to XY plane", 88, "shift 3", ae -> OpticsAction.getApp(ae).setClipPlane(OutputPanel3d.ViewPlane.XY_PLANE)),
    SET_VIEW_PLANE_TO_ZY("ZY Plane", null, "zyPlane24.png", "Set optics geomety panels to ZY plane", 89, "ctrl 1", ae -> OpticsAction.getApp(ae).setViewPlane(OutputPanel3d.ViewPlane.ZY_PLANE)),
    SET_VIEW_PLANE_TO_ZX("ZX Plane", null, "zxPlane24.png", "Set optics geomety panels to ZX plane", 90, "ctrl 2", ae -> OpticsAction.getApp(ae).setViewPlane(OutputPanel3d.ViewPlane.ZX_PLANE)),
    SET_VIEW_PLANE_TO_XY("XY Plane", null, "xyPlane24.png", "Set optics geomety panels to XY plane", 88, "ctrl 3", ae -> OpticsAction.getApp(ae).setViewPlane(OutputPanel3d.ViewPlane.XY_PLANE)),
    SETTINGS("Settings", null, "settings24.png", "Show the settings dialog.", 83, "alt shift S", ae -> OpticsAction.getApp(ae).showSettings()),
    GLOBAL_VARIABLES_SHOW("Global Variables...", null, "globalVariables.png", "Show global variables dialog.", 71, "alt shift G", ae -> OpticsAction.getApp(ae).showGlobalVariablesDialog()),
    GLOBAL_VARIABLES_ADD("Add Global Variable", null, "globalVariableAdd24.png", "Add a global variable.", 65, "", ae -> OpticsAction.getApp(ae).addGlobalVariable()),
    GLOBAL_VARIABLES_DELETE("Delete Global Variable", null, "globalVariableDelete24.png", "Remove a global variable.", 65, "", ae -> OpticsAction.getApp(ae).deleteGlobalVariable()),
    GLOBAL_VARIABLES_CLOSE("Close Global Variable dialog", null, "exit24.png", "Close the global variables dialog.", 67, "", ae -> OpticsAction.getApp(ae).closeGlobalVariablesDialog()),
    SIZE_SPLITS("Size Splits", null, "resizeSplits.png", "Size the split panes.", 78, ae -> OpticsAction.getApp(ae).sizeSplits()),
    SPLINE_OPEN("Edit Spline", null, "splineEdit.png", "Edit points defining spline.", 83, ae -> OpticsAction.getApp(ae).splineDialog()),
    SPLINE_ADD("Add Spline Point", null, "splineAdd.png", "Add a point to the spline polygon.", 0, ae -> OpticsAction.getApp(ae).addSplinePoint()),
    SPLINE_REMOVE("Remove Spline Point", null, "splineDelete.png", "Remove the selected point to the spline polygon.", 0, ae -> OpticsAction.getApp(ae).removeSplinePoint()),
    SPLINE_CLOSE("Close Spline Dialog", null, "exit24.png", "Close the spline dialog.", 0, ae -> OpticsAction.getApp(ae).closeSplineDialog()),
    SPLINE_PASTE("Paste Spline Points", null, "splinePaste.png", "Paste table from clipboard to spline dialog.", 0, ae -> OpticsAction.getApp(ae).pasteSpline()),
    STOP_WRANGLER("Stop", null, "stop24.png", "Stop wrangler.", 83, "F8", ae -> OpticsAction.getApp(ae).stopWrangler()),
    SUPPRESS("Toggle object suppression", null, "suppress.png", "Toggle whether this object is used in calculations or not.", 85, "control U", ae -> OpticsAction.getApp(ae).toggleSuppression()),
    TEST_ACTION("KM Test", null, "kmTest.png", "Run some test code.", 84, ae -> OpticsAction.getApp(ae).testKM()),
    UNDO("Undo", null, "undo24.png", "Undo last operation", 85, "ctrl Z", ae -> OpticsAction.getApp(ae).undo()),
    WEBSITE("jOcular Website", null, "jocular_logo24.png", "Call up the jOcular web site.", 87, "F2", ae -> OpticsAction.getApp(ae).website()),
    ZOOM_IN("Zoom in", null, "zoomIn.png", "Zoom in view", 73, "typed =", ae -> OpticsAction.getApp(ae).zoomIn()),
    ZOOM_OUT("Zoom out", null, "zoomOut.png", "Zoom out view", 79, "typed -", ae -> OpticsAction.getApp(ae).zoomOut()),
    ZOOM_EXTENTS("Zoom extents", null, "zoomExtents.png", "Zoom to see whole project.", 69, "shift E", ae -> OpticsAction.getApp(ae).zoomExtents());

    private String m_description;
    private String m_deselectedName;
    private KeyStroke m_hotKey;
    private String m_iconName;
    private Icon m_icon;
    private int m_mnemonic;
    private int m_selectedMnemonicIndex;
    private ActionListener m_listener;
    private String m_name;
    private boolean m_selected;
    private boolean m_enabled;
    private PropertyChangeSupport m_support = new PropertyChangeSupport(this);

    private OpticsAction(String name, String deselectedName, String iconName, String description, int mnemonic, ActionListener listener) {
        this.m_name = name;
        this.m_deselectedName = deselectedName;
        this.m_description = description;
        this.m_iconName = iconName;
        this.m_icon = ResourceTools.loadImageIcon(iconName);
        this.m_mnemonic = mnemonic;
        this.m_hotKey = null;
        this.m_enabled = true;
        this.m_listener = listener;
        this.setMnemonicIndeces(mnemonic);
    }

    private OpticsAction(String name, String deselectedName, String iconName, String description, int mnemonic, String hotKey, ActionListener listener) {
        this.m_name = name;
        this.m_deselectedName = deselectedName;
        this.m_description = description;
        this.m_iconName = iconName;
        this.m_icon = ResourceTools.loadImageIcon(iconName);
        this.m_mnemonic = mnemonic;
        this.m_enabled = true;
        this.m_hotKey = KeyStroke.getKeyStroke(hotKey);
        this.m_listener = listener;
        this.setMnemonicIndeces(mnemonic);
    }

    String getDescription() {
        return this.m_description;
    }

    String getDeselectedName() {
        return this.m_deselectedName;
    }

    KeyStroke getHotKey() {
        return this.m_hotKey;
    }

    String getIconName() {
        return this.m_iconName;
    }

    int getMnemonic() {
        return this.m_mnemonic;
    }

    private void setMnemonicIndeces(int mnemonic) {
        String key = KeyEvent.getKeyText(mnemonic).toLowerCase();
        this.m_selectedMnemonicIndex = this.m_name.toLowerCase().indexOf(key);
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.m_listener.actionPerformed(e);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object getValue(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[13] lbl69 : CaseStatement: default:\u000a, @NONE, blocks:[13] lbl69 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.binarySort(TimSort.java:296)
         *     at java.base/java.util.TimSort.sort(TimSort.java:221)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void setSelected(boolean v) {
        boolean oldValue = this.m_selected;
        this.m_selected = v;
        this.m_support.firePropertyChange("SwingSelectedKey", oldValue, v);
    }

    @Override
    public void putValue(String key, Object value) {
        Object oldValue = this.getValue(key);
        switch (key) {
            case "AcceleratorKey": {
                this.m_hotKey = (KeyStroke)value;
                break;
            }
            case "ActionCommandKey": {
                System.out.println("OrthoCompassActionKey ACTION_COMMAND_KEY setting to value \"" + value + "\"");
                break;
            }
            default: {
                break;
            }
            case "SwingDisplayedMnemonicIndexKey": {
                System.out.println("OrthoCompassActionKey DISPLAYED_MNEMONIC_INDEX_KEY setting to " + value);
                this.m_selectedMnemonicIndex = (Integer)value;
                break;
            }
            case "SwingLargeIconKey": {
                this.m_icon = (Icon)value;
                break;
            }
            case "LongDescription": {
                this.m_description = value.toString();
                break;
            }
            case "MnemonicKey": {
                this.m_mnemonic = (Integer)value;
                break;
            }
            case "Name": {
                this.m_name = value.toString();
                break;
            }
            case "SwingSelectedKey": {
                this.m_selected = (Boolean)value;
                break;
            }
            case "ShortDescription": {
                this.m_description = value.toString();
                break;
            }
            case "SmallIcon": {
                this.m_icon = (Icon)value;
            }
            case "Default": 
        }
        this.m_support.firePropertyChange(key, oldValue, this.getValue(key));
    }

    @Override
    public void setEnabled(boolean b) {
        this.m_enabled = b;
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_support.removePropertyChangeListener(listener);
    }

    public static void addKeyBindings(JComponent component) {
        OpticsAction[] opticsActionArray = OpticsAction.values();
        int n = opticsActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            OpticsAction key = opticsActionArray[n2];
            if (key.m_hotKey != null) {
                component.getInputMap(2).put(key.m_hotKey, key.getName());
                component.getActionMap().put(key.getName(), key);
            }
            ++n2;
        }
    }

    public static Jocular getApp(ActionEvent ae) {
        Jocular result = null;
        Object jf = null;
        if (ae.getSource() instanceof Component) {
            Component c = (Component)ae.getSource();
            while (c.getParent() != null) {
                if ((c = c.getParent()) instanceof JPopupMenu) {
                    c = ((JPopupMenu)c).getInvoker();
                }
                if (!(c instanceof JFrame)) continue;
                jf = (JFrame)c;
                break;
            }
        }
        if (jf instanceof JocularWindow) {
            result = ((JocularWindow)jf).getApp();
        } else if (jf instanceof ImagerWindow) {
            result = ((ImagerWindow)jf).getApp();
        } else {
            throw new RuntimeException("Action source is a " + jf.getClass().getName());
        }
        if (result == null) {
            throw new RuntimeException("Could not determine Jocular instance that spawned this ActionEvent:" + ae.toString());
        }
        return result;
    }
}

