/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ImagerStatusBar
extends JPanel {
    private static final String DEFAULT_DISPLAY = "Wrangler: ";
    private static final String DEFAULT_COUNT = "Cycles: ";
    JLabel m_statusLabel;
    JLabel m_countLabel;
    int currentCount = 0;
    int totalCount = 0;
    int m_lastCount = 0;
    long m_currentTimeMs;
    long m_startTimeMs;
    double m_rate;
    JProgressBar m_progressBar;

    public ImagerStatusBar() {
        this.setLayout(new BorderLayout(2, 2));
        this.m_statusLabel = new JLabel("Wrangler: Ready");
        this.m_statusLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_statusLabel.setForeground(Color.black);
        this.add("West", this.m_statusLabel);
        this.m_countLabel = new JLabel(DEFAULT_COUNT + this.convertCountsToString());
        this.m_countLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_countLabel.setForeground(Color.black);
        this.add("Center", this.m_countLabel);
        this.m_progressBar = new JProgressBar(0, this.totalCount);
        this.m_progressBar.setValue(0);
        this.m_progressBar.setStringPainted(true);
        this.add("East", this.m_progressBar);
    }

    private String convertCountsToString() {
        Object temp = Integer.toString(this.currentCount);
        temp = (String)temp + "/";
        temp = (String)temp + Integer.toString(this.totalCount);
        temp = (String)temp + ", rate: " + this.m_rate;
        return temp;
    }

    public void setStatusToReady() {
        this.m_statusLabel.setText("Wrangler: Ready");
    }

    public void setStatusToRunning() {
        this.m_statusLabel.setText("Wrangler: Running");
    }

    public void setTotalCounts(int counts) {
        this.currentCount = 0;
        this.m_startTimeMs = System.currentTimeMillis();
        this.totalCount = counts;
        this.m_progressBar.setMaximum(counts);
        this.setCurrentCount(counts);
    }

    public void setCurrentCount(int count) {
        this.m_currentTimeMs = System.currentTimeMillis();
        this.currentCount = count;
        this.m_rate = count == 0 ? 0.0 : Math.floor(1000.0 * (double)this.currentCount / (double)(this.m_currentTimeMs - this.m_startTimeMs));
        this.m_countLabel.setText(DEFAULT_COUNT + this.convertCountsToString());
        this.m_progressBar.setValue(count);
    }
}

