/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.actions;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sourceforge.jocular.Jocular;
import net.sourceforge.jocular.actions.OpticsAction;
import net.sourceforge.jocular.actions.OpticsMenuBar;
import net.sourceforge.jocular.autofocus.AutofocusSensor;
import net.sourceforge.jocular.imager.Imager;
import net.sourceforge.jocular.mesh.MeshOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.objects.OpticsPart;
import net.sourceforge.jocular.objects.PlanoAsphericLens;
import net.sourceforge.jocular.objects.ProjectRootGroup;
import net.sourceforge.jocular.objects.SimpleAperture;
import net.sourceforge.jocular.objects.SpectroPhotometer;
import net.sourceforge.jocular.objects.SphericalLens;
import net.sourceforge.jocular.objects.TriangularPrism;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.sources.HemiPointSource;
import net.sourceforge.jocular.sources.ImageSource;
import net.sourceforge.jocular.splines.ExtrudedSpline;
import net.sourceforge.jocular.splines.RotatedSpline;

public class ContextPopup
implements OpticsObjectVisitor {
    JPopupMenu m_output;
    OpticsObject m_object;

    protected ContextPopup(Jocular app, OpticsObject o) {
        this.m_object = o;
    }

    protected JPopupMenu getPopup() {
        this.m_output = new JPopupMenu();
        this.m_object.accept(this);
        return this.m_output;
    }

    public static JPopupMenu getPopup(Jocular app, OpticsObject o) {
        return new ContextPopup(app, o).getPopup();
    }

    protected void defaultVisit(OpticsObject o) {
        this.m_output.add(OpticsMenuBar.makeAddSubMenu());
        this.m_output.add(new JMenuItem(OpticsAction.CUT));
        this.m_output.add(new JMenuItem(OpticsAction.COPY));
        this.m_output.add(new JMenuItem(OpticsAction.PASTE));
        this.m_output.add(new JMenuItem(OpticsAction.DELETE_OBJECT));
        this.m_output.add(new JMenuItem(OpticsAction.MOVE_UP_IN_TREE));
        this.m_output.add(new JMenuItem(OpticsAction.MOVE_DOWN_IN_TREE));
        this.m_output.add(new JMenuItem(OpticsAction.SUPPRESS));
    }

    @Override
    public void visit(ProjectRootGroup v) {
        this.m_output.add(OpticsMenuBar.makeAddSubMenu());
        this.m_output.add(new JMenuItem(OpticsAction.CUT));
        this.m_output.add(new JMenuItem(OpticsAction.COPY));
        this.m_output.add(new JMenuItem(OpticsAction.PASTE));
    }

    @Override
    public void visit(OpticsPart v) {
        this.defaultVisit(v);
    }

    @Override
    public void visit(MeshOpticsObject v) {
        this.defaultVisit(v);
        this.m_output.add(OpticsAction.CHOOSE_MESH_FILE);
    }

    @Override
    public void visit(TriangularPrism v) {
        this.defaultVisit(v);
    }

    @Override
    public void visit(RotatedSpline v) {
        this.defaultVisit(v);
        this.m_output.add(OpticsAction.SPLINE_OPEN);
    }

    @Override
    public void visit(ExtrudedSpline v) {
        this.defaultVisit(v);
        this.m_output.add(OpticsAction.SPLINE_OPEN);
    }

    @Override
    public void visit(PlanoAsphericLens v) {
        this.defaultVisit(v);
    }

    @Override
    public void visit(Imager v) {
        this.defaultVisit(v);
    }

    @Override
    public void visit(SimpleAperture sa) {
        this.defaultVisit(sa);
    }

    @Override
    public void visit(SphericalLens v) {
        this.defaultVisit(v);
        this.m_output.add(OpticsAction.OBJECT_INFO);
    }

    @Override
    public void visit(SpectroPhotometer v) {
        this.defaultVisit(v);
        this.m_output.add(OpticsAction.OBJECT_INFO);
    }

    @Override
    public void visit(AutofocusSensor v) {
        this.defaultVisit(v);
        this.m_output.add(OpticsAction.AUTOFOCUS);
    }

    @Override
    public void visit(ImageSource v) {
        this.defaultVisit(v);
        this.m_output.add(OpticsAction.DEFINE_IMAGE);
    }

    @Override
    public void visit(HemiPointSource v) {
        this.defaultVisit(v);
    }

    @Override
    public void visit(OpticsObjectGroup v) {
        this.defaultVisit(v);
    }
}

