/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreePath;
import net.sourceforge.jocular.Constants;
import net.sourceforge.jocular.Jocular;
import net.sourceforge.jocular.actions.OpticsAction;
import net.sourceforge.jocular.actions.OpticsMenuBar;
import net.sourceforge.jocular.gui.panel.OutputPanel3d;
import net.sourceforge.jocular.gui.panelfx.OpticsObjectPanelFx;
import net.sourceforge.jocular.gui.tables.OpticsObjectTree;
import net.sourceforge.jocular.gui.tables.OpticsPropertyTable;
import net.sourceforge.jocular.gui.tables.OpticsPropertyTableModel;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.objects.OpticsObjectKey;
import net.sourceforge.jocular.objects.OpticsPart;
import net.sourceforge.jocular.photons.WranglerEvent;
import net.sourceforge.jocular.photons.WranglerListener;
import net.sourceforge.jocular.positioners.ObjectPositionerKey;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.project.ProjectUpdatedEvent;
import net.sourceforge.jocular.project.ProjectUpdatedListener;
import net.sourceforge.jocular.settings.SettingKey;
import net.sourceforge.jocular.settings.Settings;
import net.sourceforge.jocular.util.ResourceTools;

public class JocularWindow
extends JFrame
implements WranglerListener,
ProjectUpdatedListener,
Constants {
    private OutputPanel3d m_3dPanel;
    final OpticsPropertyTableModel m_objectPropertyTableModel = new OpticsPropertyTableModel();
    final OpticsPropertyTableModel m_positionerPropertyTableModel = new OpticsPropertyTableModel();
    final OpticsMenuBar m_menuBar;
    final JTable m_objectPropertyTable = new OpticsPropertyTable(this.m_objectPropertyTableModel);
    final JTable m_positionerPropertyTable = new OpticsPropertyTable(this.m_positionerPropertyTableModel);
    final OpticsObjectTree m_tree;
    OpticsObject m_selectedObject = null;
    final JComboBox<?> m_positionerCombo;
    final Jocular m_app;
    final JSplitPane mainSplitPane;
    final JSplitPane treeSplitPane;
    final JSplitPane positionerSplitPane;
    final JSplitPane geometrySplitPane;

    public JocularWindow(Jocular app) {
        this.m_app = app;
        this.m_tree = new OpticsObjectTree(app);
        OpticsAction.addKeyBindings(this.getRootPane());
        this.m_menuBar = new OpticsMenuBar();
        this.mainSplitPane = new JSplitPane(1);
        this.treeSplitPane = new JSplitPane(0);
        this.positionerSplitPane = new JSplitPane(0);
        this.geometrySplitPane = new JSplitPane(0);
        this.m_3dPanel = new OpticsObjectPanelFx();
        this.m_positionerCombo = new JComboBox<ObjectPositionerKey>(ObjectPositionerKey.values());
        this.m_positionerCombo.setEnabled(false);
        this.m_positionerCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TreePath tp;
                TableCellEditor tce = JocularWindow.this.m_positionerPropertyTable.getCellEditor();
                if (tce != null) {
                    tce.stopCellEditing();
                }
                if ((tp = JocularWindow.this.m_tree.getLeadSelectionPath()) == null || JocularWindow.this.m_selectedObject == null) {
                    return;
                }
                ObjectPositionerKey k = (ObjectPositionerKey)((Object)JocularWindow.this.m_positionerCombo.getSelectedItem());
                if (k == ObjectPositionerKey.getKey(JocularWindow.this.m_selectedObject.getPositioner())) {
                    JocularWindow.this.m_positionerPropertyTableModel.setPropertyOwner(JocularWindow.this.m_selectedObject.getPositioner(), JocularWindow.this.m_app.getProject());
                    return;
                }
                OpticsProject p = JocularWindow.this.m_app.getProject();
                p.addPositionerEdit(JocularWindow.this.m_selectedObject, k);
                if (JocularWindow.this.m_selectedObject != null) {
                    JocularWindow.this.m_positionerPropertyTableModel.setPropertyOwner(JocularWindow.this.m_selectedObject.getPositioner(), JocularWindow.this.m_app.getProject());
                }
            }
        });
        this.setProject(this.m_app.getProject());
        this.initializeDisplay();
        this.initializePanels();
        this.initializeToolbar();
        this.setVisible(true);
    }

    public void setProject(OpticsProject p) {
        if (p == null) {
            return;
        }
        this.m_3dPanel.setProject(p);
        this.m_tree.setProject(p);
        this.updateTitle(p);
        this.setCalcPhotonsEnabled(true);
        p.addProjectUpdatedListener(this);
        p.getWrangler().addWranglerListener(this);
    }

    public void updateTitle(OpticsProject p) {
        String projectName = "";
        if (p != null) {
            projectName = String.valueOf(projectName) + " - ";
            String n = p.getFileName();
            if (n.length() > 0) {
                projectName = String.valueOf(projectName) + p.getFileName();
            }
            if (p.isDirty()) {
                projectName = String.valueOf(projectName) + "*";
            }
        }
        this.setTitle("jOcular" + projectName);
    }

    public void zoomIn() {
        this.m_3dPanel.zoomIn();
    }

    public void zoomOut() {
        this.m_3dPanel.zoomOut();
    }

    public void zoomExtents() {
        this.m_3dPanel.zoomExtents();
    }

    private void initializeDisplay() {
        int xLoc = Settings.SETTINGS.getMainWinXLoc();
        int yLoc = Settings.SETTINGS.getMainWinYLoc();
        int height = Settings.SETTINGS.getMainWinHeight();
        int width = Settings.SETTINGS.getMainWinWidth();
        this.setSize(new Dimension(width, height));
        this.setLocation(xLoc, yLoc);
        String revision = Jocular.getFormattedVersion();
        this.setTitle("jOcular " + revision);
        this.setIconImage(ResourceTools.loadImage("jocular_logo96.png"));
        this.setJMenuBar(this.m_menuBar);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JocularWindow.this.exit();
            }
        });
    }

    private void disableKeyHandlers(JComponent component) {
        KeyStroke ks = KeyStroke.getKeyStroke("control C");
        component.getInputMap(1).put(ks, "disableCopy");
        component.getActionMap().put("disableCopy", null);
        ks = KeyStroke.getKeyStroke("control X");
        component.getInputMap(1).put(ks, "disableCut");
        component.getActionMap().put("disableCut", null);
        ks = KeyStroke.getKeyStroke("control V");
        component.getInputMap(1).put(ks, "disablePaste");
        component.getActionMap().put("disablePaste", null);
        ks = KeyStroke.getKeyStroke("DELETE");
        component.getInputMap(1).put(ks, "disableDelete");
        component.getActionMap().put("disableDelete", null);
        ks = KeyStroke.getKeyStroke("F8");
        component.getInputMap(1).put(ks, "disableF8");
        component.getActionMap().put("disableF8", null);
    }

    private void initializeGeometryView() {
        this.set3DViewPlane(OutputPanel3d.ViewPlane.ZX_PLANE);
        this.geometrySplitPane.add(this.m_3dPanel.getComponent());
        Dimension d = this.getSize();
        int y = d.height / 2;
        int dividerLocation = Settings.SETTINGS.getMainWinSplitGeometry();
        if (dividerLocation == 0) {
            this.geometrySplitPane.setDividerLocation(y);
        } else {
            this.geometrySplitPane.setDividerLocation(dividerLocation);
        }
    }

    public void set3DViewPlane(OutputPanel3d.ViewPlane plane) {
        this.m_3dPanel.setViewPlane(plane);
    }

    public void set3DClipPlane(OutputPanel3d.ViewPlane plane) {
        this.m_3dPanel.setClipPLane(plane);
    }

    private void initializePanels() {
        this.getContentPane().setLayout(new BorderLayout());
        this.initializeGeometryView();
        this.initializeTreeView();
        this.mainSplitPane.add(this.treeSplitPane);
        this.mainSplitPane.add(this.geometrySplitPane);
        int mainDividerLocation = Settings.SETTINGS.getMainWinSplitHorizontal();
        if (mainDividerLocation != 0) {
            this.mainSplitPane.setDividerLocation(mainDividerLocation);
        }
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.validate();
        this.disableKeyHandlers(this.mainSplitPane);
        this.disableKeyHandlers(this.treeSplitPane);
        this.disableKeyHandlers(this.positionerSplitPane);
    }

    private void initializeTreeView() {
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath tp;
                TableCellEditor cellEditor;
                if (JocularWindow.this.m_positionerPropertyTable.isEditing()) {
                    cellEditor = JocularWindow.this.m_positionerPropertyTable.getCellEditor(JocularWindow.this.m_positionerPropertyTable.getEditingRow(), JocularWindow.this.m_positionerPropertyTable.getEditingColumn());
                    cellEditor.stopCellEditing();
                }
                if (JocularWindow.this.m_objectPropertyTable.isEditing()) {
                    cellEditor = JocularWindow.this.m_objectPropertyTable.getCellEditor(JocularWindow.this.m_objectPropertyTable.getEditingRow(), JocularWindow.this.m_objectPropertyTable.getEditingColumn());
                    cellEditor.stopCellEditing();
                }
                if ((tp = e.getNewLeadSelectionPath()) != null && tp.getLastPathComponent() instanceof OpticsObject) {
                    JocularWindow.this.setSelectedObject((OpticsObject)tp.getLastPathComponent());
                } else {
                    JocularWindow.this.setSelectedObject(null);
                }
            }
        });
        this.initializePropertyPanels();
        this.treeSplitPane.add(new JScrollPane(this.m_tree));
        this.treeSplitPane.add(this.positionerSplitPane);
        Dimension d = this.getSize();
        int y = d.height * 2 / 7;
        int treeDividerLocation = Settings.SETTINGS.getMainWinSplitTree();
        if (treeDividerLocation == 0) {
            this.treeSplitPane.setDividerLocation(y);
        } else {
            this.treeSplitPane.setDividerLocation(treeDividerLocation);
        }
    }

    protected void setSelectedObject(OpticsObject opticsObject) {
        if (opticsObject == null) {
            this.m_selectedObject = null;
            this.m_objectPropertyTableModel.setPropertyOwner(null, this.m_app.getProject());
            this.m_positionerPropertyTableModel.setPropertyOwner(null, this.m_app.getProject());
        } else {
            this.m_selectedObject = opticsObject;
            this.m_objectPropertyTableModel.setPropertyOwner(this.m_selectedObject, this.m_app.getProject());
            if (this.m_selectedObject == null) {
                this.m_positionerCombo.setEnabled(false);
            } else {
                this.m_positionerCombo.setSelectedItem((Object)ObjectPositionerKey.getKey(this.m_selectedObject.getPositioner()));
                this.m_positionerCombo.setEnabled(true);
            }
            this.m_positionerPropertyTableModel.setPropertyOwner(this.m_selectedObject.getPositioner(), this.m_app.getProject());
        }
    }

    private void initializePropertyPanels() {
        JPanel posPanel = new JPanel(new GridLayout(1, 2));
        posPanel.add(new JLabel("Positioner"));
        posPanel.add(this.m_positionerCombo);
        posPanel.setMaximumSize(new Dimension(500, 30));
        Box b2 = new Box(1);
        b2.add(posPanel);
        b2.add(new JScrollPane(this.m_positionerPropertyTable));
        this.positionerSplitPane.add(new JScrollPane(this.m_objectPropertyTable));
        this.positionerSplitPane.add(b2);
        Dimension d = this.getSize();
        int y = d.height * 2 / 7;
        int positionerDividerLocation = Settings.SETTINGS.getMainWinSplitPositioner();
        if (positionerDividerLocation == 0) {
            this.positionerSplitPane.setDividerLocation(y);
        } else {
            this.positionerSplitPane.setDividerLocation(positionerDividerLocation);
        }
    }

    private void initializeToolbar() {
        JToolBar jtb = new JToolBar();
        jtb.setFloatable(false);
        jtb.add(OpticsAction.NEW);
        jtb.add(OpticsAction.LOAD);
        jtb.add(OpticsAction.SAVE);
        jtb.add(OpticsAction.UNDO);
        jtb.add(OpticsAction.REDO);
        jtb.add(OpticsAction.ZOOM_IN);
        jtb.add(OpticsAction.ZOOM_OUT);
        jtb.add(OpticsAction.OPEN_IMAGER_WINDOW);
        jtb.add(OpticsAction.CALC_DISPLAY_PHOTONS);
        jtb.add(OpticsAction.CALC_PHOTONS);
        jtb.add(OpticsAction.SET_VIEW_PLANE_TO_ZX);
        jtb.add(OpticsAction.SET_VIEW_PLANE_TO_ZY);
        jtb.add(OpticsAction.SET_VIEW_PLANE_TO_XY);
        jtb.add(OpticsAction.GLOBAL_VARIABLES_SHOW);
        jtb.add(Box.createHorizontalGlue());
        jtb.add(OpticsAction.HELP);
        this.getContentPane().add((Component)jtb, "North");
    }

    public void reset() {
        this.setSize(new Dimension(600, 600));
        this.setLocation(0, 0);
    }

    public void exit() {
        Object[] options;
        int result;
        if (this.m_app.getProject().isDirty() && (result = JOptionPane.showOptionDialog(this, "Project has unsaved Changes! Click Discard to exit anyway or cancel to go back and save.", "Discard Changes?", 2, 3, null, options = new Object[]{"Discard", "Cancel"}, options[1])) != 0) {
            return;
        }
        Settings.SETTINGS.setSetting(SettingKey.MAIN_WIN_X_LOC, String.valueOf(this.getLocationOnScreen().x));
        Settings.SETTINGS.setSetting(SettingKey.MAIN_WIN_Y_LOC, String.valueOf(this.getLocationOnScreen().y));
        Settings.SETTINGS.setSetting(SettingKey.MAIN_WIN_HEIGHT, String.valueOf(this.getSize().height));
        Settings.SETTINGS.setSetting(SettingKey.MAIN_WIN_WIDTH, String.valueOf(this.getSize().width));
        Settings.SETTINGS.setSetting(SettingKey.MAIN_WIN_SPLIT_HORIZ, String.valueOf(this.mainSplitPane.getDividerLocation()));
        Settings.SETTINGS.setSetting(SettingKey.MAIN_WIN_SPLIT_TREE, String.valueOf(this.treeSplitPane.getDividerLocation()));
        Settings.SETTINGS.setSetting(SettingKey.MAIN_WIN_SPLIT_POS, String.valueOf(this.positionerSplitPane.getDividerLocation()));
        Settings.SETTINGS.setSetting(SettingKey.MAIN_WIN_SPLIT_GEO, String.valueOf(this.geometrySplitPane.getDividerLocation()));
        this.dispose();
        System.exit(0);
    }

    public void setCalcPhotonsEnabled(boolean f) {
        OpticsAction.CALC_PHOTONS.setEnabled(f);
    }

    public void setTableSplitRatio() {
        Dimension d = this.getSize();
        int y = d.height * 2 / 7;
        this.positionerSplitPane.setDividerLocation(y);
        this.treeSplitPane.setDividerLocation(y);
        System.out.println("JocularWindow.setTableSplitRatio jsp1,jsp2 divider: " + this.treeSplitPane.getDividerLocation() + ", " + this.positionerSplitPane.getDividerLocation());
    }

    protected void renderDisplay() {
        this.m_3dPanel.updatePanel();
        this.repaint();
    }

    public void updateEverything() {
        this.m_3dPanel.updateEverything();
    }

    protected OpticsObject getSelectedObject() {
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            System.out.println("JocularWindows nothing selected.");
            return null;
        }
        return (OpticsObject)path.getLastPathComponent();
    }

    protected OpticsObject[] getSelectedObjects() {
        TreePath[] paths;
        ArrayList<OpticsObject> os = new ArrayList<OpticsObject>();
        TreePath[] treePathArray = paths = this.m_tree.getSelectionPaths();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath tp = treePathArray[n2];
            os.add((OpticsObject)tp.getLastPathComponent());
            ++n2;
        }
        OpticsObject[] result = new OpticsObject[os.size()];
        return os.toArray(result);
    }

    protected OpticsObjectGroup getClosestGroup() {
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            System.out.println("JocularWindows nothing selected.");
            return this.m_app.getProject().getOpticsObject();
        }
        OpticsObjectGroup g = this.m_app.getProject().getOpticsObject();
        int i = path.getPathCount() - 1;
        while (i >= 0) {
            Object o = path.getPathComponent(i);
            if (o instanceof OpticsObjectGroup && !(o instanceof OpticsPart)) {
                g = (OpticsObjectGroup)path.getPathComponent(i);
                break;
            }
            --i;
        }
        return g;
    }

    public void addObject(OpticsObject oToAdd) {
        OpticsObject o = this.getSelectedObject();
        OpticsObjectGroup g = this.getClosestGroup();
        int pos = o != null && g != null ? g.getPos(o) + 1 : g.getObjects().size();
        this.m_app.getProject().addOpticsObjectEdit(this.getClosestGroup(), oToAdd, pos, null);
    }

    public void addObject(OpticsObjectKey objectKeyToAdd) {
        OpticsObjectKey key = objectKeyToAdd != null ? objectKeyToAdd : (OpticsObjectKey)((Object)JOptionPane.showInputDialog(this, "Select Object to add", "Add object", 3, null, (Object[])OpticsObjectKey.values(), (Object)OpticsObjectKey.OPTICS_GROUP));
        if (key != null) {
            this.addObject(key.getNewObject());
        }
    }

    public void moveInTree(boolean upNotDown) {
        OpticsObject o = this.getSelectedObject();
        if (o == null) {
            return;
        }
        TreePath path = this.m_tree.getSelectionPath().getParentPath();
        Object p = path.getLastPathComponent();
        if (!(p instanceof OpticsObjectGroup)) {
            return;
        }
        OpticsObjectGroup g = (OpticsObjectGroup)p;
        if (o == null || g == null) {
            return;
        }
        this.m_app.getProject().addObjectMoveEdit(g, o, upNotDown);
    }

    public void deleteObject() {
        OpticsObject o = this.getSelectedObject();
        if (o == null) {
            return;
        }
        TreePath path = this.m_tree.getSelectionPath().getParentPath();
        Object p = path.getLastPathComponent();
        if (!(p instanceof OpticsObjectGroup)) {
            return;
        }
        OpticsObjectGroup g = (OpticsObjectGroup)p;
        if (o == null || g == null) {
            return;
        }
        this.m_app.getProject().addOpticsObjectEdit(g, null, -1, o);
    }

    @Override
    public void wranglingUpdate(WranglerEvent e) {
        switch (e.getType()) {
            case FINISHED: {
                this.renderDisplay();
                this.setCalcPhotonsEnabled(true);
                break;
            }
            case ONGOING: {
                this.renderDisplay();
                break;
            }
        }
    }

    @Override
    public void projectUpdated(ProjectUpdatedEvent e) {
        switch (e.getType()) {
            case POSITION: {
                if (this.m_selectedObject != e.getOpticsObject() || this.m_positionerCombo.getSelectedIndex() != -1 && this.m_positionerCombo.getSelectedItem() == ObjectPositionerKey.getKey(this.m_selectedObject.getPositioner())) break;
                this.m_positionerCombo.setSelectedItem((Object)ObjectPositionerKey.getKey(this.m_selectedObject.getPositioner()));
                break;
            }
            case SAVE: 
            case LOAD: 
            case ADD: 
            case REMOVE: 
            case CHANGE: 
            case NONE: {
                this.updateEverything();
            }
        }
    }

    public void stopEditing() {
        TableCellEditor tce = this.m_objectPropertyTable.getCellEditor();
        if (tce != null) {
            tce.cancelCellEditing();
        }
        if ((tce = this.m_positionerPropertyTable.getCellEditor()) != null) {
            tce.cancelCellEditing();
        }
    }

    public Jocular getApp() {
        return this.m_app;
    }

    public void test() {
        this.m_3dPanel.test();
    }
}

