/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sourceforge.jocular.Constants;
import net.sourceforge.jocular.ImagerWindow;
import net.sourceforge.jocular.JocularWindow;
import net.sourceforge.jocular.autofocus.AutofocusDialog;
import net.sourceforge.jocular.clipboard.OpticsObjectTransferable;
import net.sourceforge.jocular.gui.GlobalVariableDialog;
import net.sourceforge.jocular.gui.panel.ImagerPanel;
import net.sourceforge.jocular.gui.panel.OutputPanel;
import net.sourceforge.jocular.gui.panel.OutputPanel3d;
import net.sourceforge.jocular.imager.Imager;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.mesh.MeshLoader;
import net.sourceforge.jocular.mesh.MeshOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectKey;
import net.sourceforge.jocular.objects.OpticsPart;
import net.sourceforge.jocular.objects.OutputObject;
import net.sourceforge.jocular.objects.SpectroPhotometer;
import net.sourceforge.jocular.objects.SphericalLens;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.positioners.AxisPositioner;
import net.sourceforge.jocular.project.GlobalVariables;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.project.ProjectUpdatedEvent;
import net.sourceforge.jocular.project.ProjectUpdatedListener;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.ImageProperty;
import net.sourceforge.jocular.properties.MaterialProperty;
import net.sourceforge.jocular.properties.MeshDataProperty;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyManager;
import net.sourceforge.jocular.settings.SettingKey;
import net.sourceforge.jocular.settings.Settings;
import net.sourceforge.jocular.settings.SettingsDialog;
import net.sourceforge.jocular.sources.ImageSource;
import net.sourceforge.jocular.splines.SplineObject;
import net.sourceforge.jocular.splines.SplinePointDialog;
import net.sourceforge.jocular.util.BackgroundRunner;
import net.sourceforge.jocular.util.ResourceTools;
import net.sourceforge.jocular.util.Utils;

public class Jocular
implements ProjectUpdatedListener,
Constants {
    private static final Jocular SINGLETON = new Jocular();
    final JocularWindow m_window;
    final ImagerWindow m_imagerWindow;
    private OpticsProject m_project = null;
    private String fileChooserPath = "";
    private JFileChooser m_jfc;
    private JFileChooser m_imageFileChooser;
    SplinePointDialog m_splineDialog = null;
    private GlobalVariableDialog m_globalVarsDialog = null;

    private Jocular() {
        ResourceTools.setFonts();
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        Settings.SETTINGS.initialize();
        this.fileChooserPath = Settings.SETTINGS.getDefaultFilePath();
        this.m_jfc = new JFileChooser(this.fileChooserPath);
        this.m_jfc.setFileFilter(new FileNameExtensionFilter("jOcular Project File", "jocproj"));
        this.m_window = new JocularWindow(this);
        this.m_imageFileChooser = new JFileChooser(this.fileChooserPath);
        this.m_imageFileChooser.setFileFilter(new FileNameExtensionFilter("PNG", "png"));
        this.m_imagerWindow = new ImagerWindow(this);
    }

    public static void main(String[] args) {
        SINGLETON.newProject();
    }

    public void testKM() {
        PropertyManager.getInstance().undeferParsing(this.getProject());
        this.getProject().getOpticsObject().doInternalCalcs();
    }

    public void copyTrajectoryToClipboard() {
        PhotonTrajectory pt = this.m_project.getWrangler().getTrajectories().iterator().next();
        if (pt == null) {
            return;
        }
        String s = "x, y, z, dx, dy, dz, in object, interacting object, photon source, #, reference object, surface normal x, y, z\n";
        int i = 0;
        while (i < pt.getNumberOfPhotons()) {
            Photon p = pt.getPhoton(i);
            s = String.valueOf(s) + p.getOrigin().x + ", ";
            s = String.valueOf(s) + p.getOrigin().y + ", ";
            s = String.valueOf(s) + p.getOrigin().z + ", ";
            s = String.valueOf(s) + p.getDirection().x + ", ";
            s = String.valueOf(s) + p.getDirection().y + ", ";
            s = String.valueOf(s) + p.getDirection().z + ", ";
            s = String.valueOf(s) + p.getContainingObject() + ", ";
            s = String.valueOf(s) + pt.getInteraction(i).getInteractingObject() + ",";
            s = String.valueOf(s) + (Object)((Object)p.getPhotonSource()) + ", ";
            s = String.valueOf(s) + i + ", ";
            s = String.valueOf(s) + pt.getInteraction(i).getReferenceObject() + ", ";
            Vector3D norm = pt.getInteraction(i).getNormal();
            s = String.valueOf(s) + norm.x + ", ";
            s = String.valueOf(s) + norm.y + ", ";
            s = String.valueOf(s) + norm.z + ", ";
            s = String.valueOf(s) + "\n";
            ++i;
        }
        StringSelection selection = new StringSelection(s);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    public void exportMaterials() {
        this.m_jfc.setFileFilter(new FileNameExtensionFilter("CSV File", "csv"));
        if (this.m_jfc.showSaveDialog(this.m_window) != 0) {
            System.out.println("Jocular.exportMaterials cancelled.");
            return;
        }
        File f = this.m_jfc.getSelectedFile();
        BufferedWriter fw = null;
        try {
            DecimalFormat nf = new DecimalFormat("0.0####E00");
            fw = new BufferedWriter(new FileWriter(f));
            MaterialProperty.MaterialKey[] mks = MaterialProperty.MaterialKey.values();
            String halfRow1 = "Wavelength (m)";
            String halfRow2 = "Wavelength (m)";
            MaterialProperty.MaterialKey[] materialKeyArray = mks;
            int n = mks.length;
            int n2 = 0;
            while (n2 < n) {
                MaterialProperty.MaterialKey mk = materialKeyArray[n2];
                halfRow1 = String.valueOf(halfRow1) + ", " + mk.name() + " N";
                halfRow2 = String.valueOf(halfRow2) + ", " + mk.name() + " Transmissivity";
                ++n2;
            }
            fw.write(String.valueOf(halfRow1) + ", " + halfRow2 + "\r\n");
            AxisPositioner pos = new AxisPositioner();
            double w = 3.0E-7;
            while (w <= 0.0025) {
                halfRow1 = nf.format(w);
                halfRow2 = nf.format(w);
                MaterialProperty.MaterialKey[] materialKeyArray2 = mks;
                int n3 = mks.length;
                int n4 = 0;
                while (n4 < n3) {
                    MaterialProperty.MaterialKey mk = materialKeyArray2[n4];
                    halfRow1 = String.valueOf(halfRow1) + ", " + nf.format(mk.getMaterial().getOrdinaryRefractiveIndex(w));
                    halfRow2 = String.valueOf(halfRow2) + ", " + nf.format(mk.getMaterial().getTransmissivity(w, Vector3D.Z_AXIS, pos));
                    ++n4;
                }
                fw.write(String.valueOf(halfRow1) + ", " + halfRow2 + "\r\n");
                w += 1.0E-8;
            }
            ((Writer)fw).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File letUserChooseProject() {
        File result = null;
        this.m_jfc.setFileFilter(new FileNameExtensionFilter("jOcular Project File", "jocproj"));
        File f = new File(Settings.SETTINGS.getDefaultFilePath());
        this.m_jfc.setCurrentDirectory(f);
        if (this.m_jfc.showOpenDialog(this.m_window) == 0) {
            Settings.SETTINGS.setSetting(SettingKey.DEFAULT_FILE_PATH, this.m_jfc.getSelectedFile().getPath());
            result = this.m_jfc.getSelectedFile();
        }
        return result;
    }

    private OpticsProject loadProjectFromDisk(File f) {
        OpticsProject project = null;
        project = OpticsProject.loadProject(f);
        if (project != null) {
            project.getOpticsObject().updatePositioner(null);
            PropertyManager.getInstance().undeferParsing(project);
        }
        return project;
    }

    public void open() {
        File f = this.letUserChooseProject();
        if (f != null) {
            this.open(f);
        }
    }

    public void open(File f) {
        Settings.SETTINGS.addRecentFile(f);
        OpticsProject p = this.loadProjectFromDisk(f);
        this.setProject(p);
        PropertyManager.getInstance().undeferParsing(this.getProject());
        this.getProject().getOpticsObject().doInternalCalcs();
        Settings.SETTINGS.addRecentFile(p.getFile());
        Collection<OpticsObject> oos = this.getProject().getFlattenedOpticsObjects(true);
        for (OpticsObject oo : oos) {
            for (PropertyKey key : oo.getPropertyKeys()) {
                oo.firePropertyUpdated(key);
            }
        }
    }

    public void newProject() {
        this.setProject(new OpticsProject());
        PropertyManager.getInstance().undeferParsing(this.getProject());
        this.getProject().getOpticsObject().doInternalCalcs();
    }

    public void showSettings() {
        SettingsDialog s = new SettingsDialog((Frame)this.m_window, Settings.SETTINGS, new OpticsProject());
        s.setVisible(true);
    }

    public void save(boolean showDialog) {
        if (showDialog || this.m_project.getFileName() == "") {
            this.m_jfc.setSelectedFile(this.m_project.getFile());
            if (this.m_jfc.showSaveDialog(this.m_window) == 0) {
                File f;
                Settings.SETTINGS.addRecentFile(this.m_jfc.getSelectedFile());
                String fileName = this.m_jfc.getSelectedFile().getPath();
                Settings.SETTINGS.setSetting(SettingKey.DEFAULT_FILE_PATH, fileName);
                if (!this.m_jfc.getFileFilter().accept(this.m_jfc.getSelectedFile())) {
                    fileName = fileName.concat(".jocproj");
                }
                if ((f = new File(fileName)).exists() && JOptionPane.showConfirmDialog(this.m_window, "File \"" + fileName + "\" exists.", "Overwrite?", 2) != 0) {
                    return;
                }
                this.m_project.setFileName(fileName);
                this.m_project.save();
            }
        } else {
            this.m_project.save();
        }
    }

    public void cut() {
        this.copy();
        this.deleteObject();
    }

    public void copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        OpticsObject o = this.m_window.getSelectedObject();
        if (o == null) {
            return;
        }
        OpticsObjectTransferable oot = new OpticsObjectTransferable(o);
        clipboard.setContents(oot, oot);
    }

    public void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        DataFlavor[] flavors = clipboard.getAvailableDataFlavors();
        Object oClip = null;
        DataFlavor[] dataFlavorArray = flavors;
        int n = flavors.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor f = dataFlavorArray[n2];
            try {
                Object oTest = clipboard.getData(f);
                if (oTest instanceof OpticsObject) {
                    oClip = oTest;
                    break;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        if (oClip == null) {
            return;
        }
        this.m_window.addObject((OpticsObject)oClip);
    }

    public void printScreen() {
    }

    public void captureScreen() {
        BufferedImage i = Utils.getImage(this.m_imagerWindow.getSelectedPanel().getComponent());
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(new FileNameExtensionFilter("PNG Images", "png"));
        if (jfc.showSaveDialog(this.m_window) == 0) {
            try {
                ImageIO.write((RenderedImage)i, "png", jfc.getSelectedFile());
            }
            catch (IOException e) {
                System.out.println("Jocular.captureScreen could not write file.");
            }
        }
    }

    public void undo() {
        this.m_project.undo();
        this.m_window.updateEverything();
    }

    public void redo() {
        this.m_project.redo();
        this.m_window.updateEverything();
    }

    public void sizeSplits() {
        this.m_window.setTableSplitRatio();
    }

    public void exit() {
        this.m_imagerWindow.exit();
        Settings.SETTINGS.store();
        this.m_window.exit();
    }

    public void zoomIn() {
        if (this.m_imagerWindow.isFocused()) {
            this.m_imagerWindow.zoomIn();
        } else {
            this.m_window.zoomIn();
        }
    }

    public void zoomExtents() {
        if (this.m_imagerWindow.isFocused()) {
            this.m_imagerWindow.zoomExtents();
        } else {
            this.m_window.zoomExtents();
        }
    }

    public void zoomOut() {
        if (this.m_imagerWindow.isFocused()) {
            this.m_imagerWindow.zoomOut();
        } else {
            this.m_window.zoomOut();
        }
    }

    public void addObject(OpticsObjectKey keyToAdd) {
        this.m_window.addObject(keyToAdd);
    }

    public void deleteObject() {
        this.m_window.deleteObject();
    }

    public void moveInTree(boolean upNotDown) {
        this.m_window.moveInTree(upNotDown);
    }

    public void calcAFewPhotons() {
        this.m_window.setCalcPhotonsEnabled(false);
        this.m_project.getWrangler().wrangle(this.m_project.getOpticsObject(), Settings.SETTINGS.getPhotonTrajectoryDisplayCount());
    }

    public void calcPhotons() {
        this.m_window.setCalcPhotonsEnabled(false);
        this.m_project.getWrangler().wrangle(this.m_project.getOpticsObject(), Settings.SETTINGS.getPhotonTrajectoryCount());
    }

    public void clearImagers() {
        this.m_project.stopWrangler();
        this.m_project.getWrangler().clear();
        ArrayList os = (ArrayList)this.m_project.getOpticsObject().getOutputObjects();
        for (OutputObject o : os) {
            o.clear();
        }
    }

    public void setSelectedObject(OpticsObject oo) {
        this.m_window.setSelectedObject(oo);
    }

    public void setProject(OpticsProject p) {
        if (p == null) {
            return;
        }
        if (this.m_project != null) {
            PropertyManager.getInstance().removeProject(this.m_project);
        }
        this.closeGlobalVariablesDialog();
        if (this.m_project != null && this.m_project.getWrangler() != null) {
            this.m_project.getWrangler().clear();
        }
        this.m_project = p;
        this.m_window.setProject(p);
        this.m_imagerWindow.setProject(p);
        PropertyManager.getInstance().addProject(this.m_project);
        this.getProject().getOpticsObject().doInternalCalcs();
        this.m_project.addProjectUpdatedListener(this);
        this.m_window.updateEverything();
    }

    public static String getFormattedVersion() {
        String revision = "0.045";
        return revision;
    }

    public OpticsProject getProject() {
        return this.m_project;
    }

    public void openImagerWindow() {
        this.m_imagerWindow.setVisible(true);
    }

    public void resetWindows() {
        this.m_window.reset();
        this.m_imagerWindow.reset();
    }

    public void stopWrangler() {
        this.m_project.stopWrangler();
    }

    public void setViewPlane(OutputPanel3d.ViewPlane plane) {
        this.m_window.set3DViewPlane(plane);
    }

    public void setClipPlane(OutputPanel3d.ViewPlane plane) {
        this.m_window.set3DClipPlane(plane);
    }

    public void objectInfo() {
        OpticsObject o = this.m_window.getSelectedObject();
        String s = "";
        if (o instanceof SphericalLens) {
            SphericalLens sl = (SphericalLens)o;
            double n400 = sl.getFocalLength(4.0E-7);
            double n500 = sl.getFocalLength(5.0E-7);
            double n600 = sl.getFocalLength(6.0E-7);
            double d = ((EquationProperty)sl.getProperty(PropertyKey.DIAMETER)).getValue().getBaseUnitValue();
            s = String.valueOf(s) + "Focal Length, f-number\n";
            s = String.valueOf(s) + "400nm --> " + n400 + "\n";
            s = String.valueOf(s) + "500nm --> " + n500 + "\n";
            s = String.valueOf(s) + "600nm --> " + n600 + "\n";
            s = String.valueOf(s) + "\n";
            s = String.valueOf(s) + "f-number\n";
            s = String.valueOf(s) + "400nm --> " + n400 / d + "\n";
            s = String.valueOf(s) + "500nm --> " + n500 / d + "\n";
            s = String.valueOf(s) + "600nm --> " + n600 / d + "\n";
        } else if (o instanceof SpectroPhotometer) {
            SpectroPhotometer sp = (SpectroPhotometer)o;
            s = String.valueOf(s) + "Histogram:\nWavelength (nm),\tValue (J)\n";
            double[] bins = sp.getBinValues();
            double[] ws = sp.getBinCentres();
            int i = 0;
            while (i < bins.length) {
                s = String.valueOf(s) + ws[i] + ",\t" + bins[i] + "\r\n";
                ++i;
            }
        }
        JTextArea jta = new JTextArea(s, 20, 20);
        jta.setEditable(false);
        JOptionPane.showMessageDialog(this.m_window, new JScrollPane(jta));
    }

    public void defineImage() {
        OpticsObject o = this.m_window.getSelectedObject();
        if (o instanceof ImageSource) {
            ImageSource is = (ImageSource)o;
            is.setProperty(PropertyKey.IMAGE, Jocular.defineImage(this.m_window).getDefiningString());
        }
    }

    public static ImageProperty defineImage(Component c) {
        ImageProperty result = null;
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(new FileNameExtensionFilter("JPG, GIF, PNG Images", "jpg", "gif", "png"));
        if (jfc.showOpenDialog(c) == 0) {
            File f = jfc.getSelectedFile();
            try {
                BufferedImage i = ImageIO.read(f);
                if (i.getPropertyNames() != null) {
                    String[] stringArray = i.getPropertyNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String n3 = stringArray[n2];
                        System.out.print(String.valueOf(n3) + "(" + i.getProperty(n3) + ") ");
                        ++n2;
                    }
                } else {
                    System.out.println("No image properties");
                }
                result = new ImageProperty(i);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public void projectUpdated(ProjectUpdatedEvent e) {
        this.m_window.updateTitle(this.m_project);
    }

    public void toggleSuppression() {
        OpticsObject o;
        boolean s = (o = this.m_window.getSelectedObject()).isSuppressed();
        this.m_project.addPropertyEdit(o, PropertyKey.SUPPRESSED, Boolean.toString(!s));
    }

    public void loadImagerData() {
        OutputPanel op = this.m_imagerWindow.getSelectedPanel();
        if (op instanceof ImagerPanel) {
            ImagerPanel ip = (ImagerPanel)op;
            Imager i = ip.getImager();
            this.fileChooserPath = Settings.SETTINGS.getDefaultFilePath();
            JFileChooser jfc = new JFileChooser(this.fileChooserPath);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("DAT raw data file", "dat");
            jfc.setFileFilter(filter);
            if (jfc.showOpenDialog(this.m_window) == 0) {
                File f = jfc.getSelectedFile();
                try {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
                    i.addContents(ois);
                    ois.close();
                }
                catch (IOException e) {
                    System.out.println("Jocular.loadImageData IOException " + e);
                }
            }
        }
    }

    public void saveImagerData() {
        OutputPanel op = this.m_imagerWindow.getSelectedPanel();
        if (op instanceof ImagerPanel) {
            ImagerPanel ip = (ImagerPanel)op;
            Imager i = ip.getImager();
            this.fileChooserPath = Settings.SETTINGS.getDefaultFilePath();
            JFileChooser jfc = new JFileChooser(this.fileChooserPath);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("DAT raw data file", "dat");
            jfc.setFileFilter(filter);
            if (jfc.showSaveDialog(this.m_window) == 0) {
                File f = jfc.getSelectedFile();
                try {
                    ObjectOutputStream ois = new ObjectOutputStream(new FileOutputStream(f));
                    i.writeContents(ois);
                    ois.close();
                }
                catch (IOException e) {
                    System.out.println("Jocular.saveImageData IOException " + e);
                }
            }
        }
    }

    public void exportImagerData() {
        OutputPanel op = this.m_imagerWindow.getSelectedPanel();
        if (op instanceof ImagerPanel) {
            ImagerPanel ip = (ImagerPanel)op;
            Imager i = ip.getImager();
            this.fileChooserPath = Settings.SETTINGS.getDefaultFilePath();
            File f = Utils.chooseFile(this.m_window, "csv", "Choose File to save", "Save", true, new File(this.fileChooserPath));
            if (f != null) {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(f));){
                        boolean firstRow = true;
                        int rows = i.getRows();
                        int cols = i.getCols();
                        int y = 0;
                        while (y < rows) {
                            if (!firstRow) {
                                osw.write("\r\n");
                            }
                            firstRow = false;
                            boolean firstColumn = true;
                            int x = 0;
                            while (x < cols) {
                                if (!firstColumn) {
                                    osw.write(",");
                                }
                                firstColumn = false;
                                osw.write("" + i.getPixel(x, y).getMaxMagnitude());
                                ++x;
                            }
                            ++y;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    System.out.println("Jocular.saveImageData IOException " + e);
                }
            }
        }
    }

    public void stopEditing() {
        this.m_window.stopEditing();
    }

    public void autofocus() {
        AutofocusDialog afd = new AutofocusDialog((Frame)this.m_window, this.getProject());
        afd.setVisible(true);
    }

    public void splineDialog() {
        OpticsObject o = this.m_window.getSelectedObject();
        if (o instanceof SplineObject) {
            this.m_splineDialog = new SplinePointDialog((Frame)this.m_window, this.getProject(), (SplineObject)o);
            this.m_splineDialog.setVisible(true);
        }
    }

    public void pasteSpline() {
        if (this.m_splineDialog != null) {
            this.m_splineDialog.getTableFromClipboard();
        }
    }

    public void closeSplineDialog() {
        if (this.m_splineDialog != null && this.m_splineDialog.isDisplayable()) {
            this.m_splineDialog.dispose();
            this.m_splineDialog = null;
        }
    }

    public void addSplinePoint() {
        if (this.m_splineDialog != null) {
            this.m_splineDialog.addRow();
        }
    }

    public void removeSplinePoint() {
        if (this.m_splineDialog != null) {
            this.m_splineDialog.deleteRow();
        }
    }

    public void about() {
        Icon i = ResourceTools.loadImageIcon("jocular_logo96.png");
        JTabbedPane jtp = new JTabbedPane(3);
        JTextArea jta1 = new JTextArea("jOcular version " + Jocular.getFormattedVersion());
        JTextArea jta2 = new JTextArea("Copyright (c) 2013-2016, Kenneth MacCallum, Bryan Matthews\nAll rights reserved.\nRedistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:\n     Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.\n     Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. \nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.");
        jta1.setEditable(false);
        jta2.setEditable(false);
        jta2.setLineWrap(true);
        jta2.setWrapStyleWord(true);
        jtp.add("Version", new JScrollPane(jta1, 21, 30));
        jtp.add("License", new JScrollPane(jta2, 20, 30));
        jtp.setPreferredSize(new Dimension(300, 200));
        JOptionPane.showMessageDialog(null, jtp, "About", 1, i);
    }

    public void help() {
        try {
            Desktop.getDesktop().browse(new URI("https://sourceforge.net/p/jocular/wiki/jOcular%20Help/"));
        }
        catch (IOException | URISyntaxException ioe) {
            ioe.printStackTrace();
        }
    }

    public void website() {
        try {
            Desktop.getDesktop().browse(new URI("http://jocular.sourceforge.net"));
        }
        catch (IOException | URISyntaxException ioe) {
            ioe.printStackTrace();
        }
    }

    public void redraw() {
        this.m_window.renderDisplay();
    }

    public void addPart() {
        OpticsProject project = this.loadProjectFromDisk(this.letUserChooseProject());
        OpticsPart part = new OpticsPart();
        part.setProperty(PropertyKey.FILE_NAME, PropertyManager.getRelativePath(part, project.getFile()));
        this.m_window.addObject(part);
        part.firePropertyUpdated(PropertyKey.POSITIONER);
        this.m_window.updateEverything();
    }

    public static Jocular getApp() {
        return SINGLETON;
    }

    public void showGlobalVariablesDialog() {
        if (this.m_globalVarsDialog != null) {
            this.m_globalVarsDialog.dispose();
        }
        this.m_globalVarsDialog = new GlobalVariableDialog((Frame)this.m_window, this.m_project.getGlobalVariables());
    }

    public void addGlobalVariable() {
        int i = this.m_globalVarsDialog.getSelectedIndex();
        GlobalVariables gvs = this.m_project.getGlobalVariables();
        gvs.add(i);
    }

    public void deleteGlobalVariable() {
        int i = this.m_globalVarsDialog.getSelectedIndex();
        GlobalVariables gvs = this.m_project.getGlobalVariables();
        gvs.remove(i);
    }

    public void closeGlobalVariablesDialog() {
        if (this.m_globalVarsDialog != null) {
            this.m_globalVarsDialog.dispose();
            this.m_globalVarsDialog = null;
        }
    }

    public MeshDataProperty chooseMeshFile(Component window) {
        File f;
        MeshDataProperty result = new MeshDataProperty("");
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(new FileNameExtensionFilter("Mesh File", "stl", "ast"));
        if (jfc.showOpenDialog(window) == 0 && (f = jfc.getSelectedFile()).exists()) {
            BackgroundRunner<MeshDataProperty> br = new BackgroundRunner<MeshDataProperty>(){

                @Override
                public MeshDataProperty doTask(BackgroundRunner.ProgressListener pl) {
                    return MeshLoader.load(f, pl);
                }
            };
            result = (MeshDataProperty)br.execute(this.m_window, "Loading Mesh");
        }
        return result;
    }

    public void chooseMeshFile() {
        OpticsObject o = this.m_window.getSelectedObject();
        if (o instanceof MeshOpticsObject) {
            MeshOpticsObject soo = (MeshOpticsObject)o;
            MeshDataProperty sdp = this.chooseMeshFile(this.m_window);
            if (sdp != null) {
                soo.setProperty(PropertyKey.MESH_DATA, sdp.getDefiningString());
            }
        }
    }
}

