/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.jocular.Constants;
import net.sourceforge.jocular.Jocular;
import net.sourceforge.jocular.actions.ImagerMenuBar;
import net.sourceforge.jocular.actions.ImagerStatusBar;
import net.sourceforge.jocular.actions.OpticsAction;
import net.sourceforge.jocular.gui.panel.ImagerPanel;
import net.sourceforge.jocular.gui.panel.OutputPanel;
import net.sourceforge.jocular.gui.panel.SpectroPhotometerPanel;
import net.sourceforge.jocular.imager.Imager;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OutputObject;
import net.sourceforge.jocular.objects.SpectroPhotometer;
import net.sourceforge.jocular.photons.WranglerEvent;
import net.sourceforge.jocular.photons.WranglerListener;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.project.ProjectUpdatedEvent;
import net.sourceforge.jocular.project.ProjectUpdatedListener;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.settings.SettingKey;
import net.sourceforge.jocular.settings.Settings;
import net.sourceforge.jocular.util.ResourceTools;

public class ImagerWindow
extends JFrame
implements ProjectUpdatedListener,
WranglerListener,
Constants {
    OpticsProject m_project;
    ArrayList<OutputObject> m_objects;
    final ImagerMenuBar m_menuBar;
    ImagerStatusBar m_statusBar;
    JTabbedPane m_tabbedPane;
    BufferedImage m_image;
    Jocular m_app;
    ArrayList<OutputPanel> m_outputPanels = new ArrayList();

    public ImagerWindow(Jocular app) {
        this.m_app = app;
        this.m_menuBar = new ImagerMenuBar();
        this.m_tabbedPane = new JTabbedPane();
        this.m_tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImagerWindow.this.updatePanels();
            }
        });
        this.initializeDisplay();
        this.initializePanels();
        this.initializeToolbar();
        this.initializeStatusBar();
        this.setDefaultCloseOperation(2);
        this.setProject(app.getProject());
    }

    public void setProject(OpticsProject project) {
        if (project == null) {
            return;
        }
        this.m_project = project;
        this.m_project.addProjectUpdatedListener(this);
        this.m_project.getWrangler().addWranglerListener(this);
        this.projectUpdated(new ProjectUpdatedEvent(ProjectUpdatedEvent.UpdateType.LOAD));
    }

    @Override
    public void projectUpdated(ProjectUpdatedEvent e) {
        if (e.getType() == ProjectUpdatedEvent.UpdateType.SAVE) {
            return;
        }
        this.m_objects = (ArrayList)this.m_project.getOpticsObject().getOutputObjects();
        this.clearTabs();
        this.m_outputPanels.clear();
        for (OpticsObject opticsObject : this.m_objects) {
            OutputPanel panel = null;
            if (opticsObject instanceof Imager) {
                panel = new ImagerPanel((Imager)opticsObject);
            } else if (opticsObject instanceof SpectroPhotometer) {
                panel = new SpectroPhotometerPanel((SpectroPhotometer)opticsObject);
            }
            if (panel == null) continue;
            this.m_outputPanels.add(panel);
            this.m_tabbedPane.insertTab(opticsObject.getProperty(PropertyKey.NAME).getDefiningString(), null, panel.getComponent(), null, this.m_outputPanels.indexOf(panel));
        }
    }

    private void initializeDisplay() {
        int xLoc = Settings.SETTINGS.getImgWinXLoc();
        int yLoc = Settings.SETTINGS.getImgWinYLoc();
        int height = Settings.SETTINGS.getImgWinHeight();
        int width = Settings.SETTINGS.getImgWinWidth();
        this.setSize(new Dimension(width, height));
        this.setLocation(xLoc, yLoc);
        this.setTitle("jOcular Imager Display");
        this.setIconImage(ResourceTools.loadImage("jocular_logo96.png"));
        this.setJMenuBar(this.m_menuBar);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImagerWindow.this.exit();
            }
        });
    }

    public void resetPanels() {
        for (OutputPanel op : this.m_outputPanels) {
            op.resetPanel();
        }
    }

    public void reset() {
        this.setSize(new Dimension(600, 600));
        this.setLocation(600, 0);
    }

    public void exit() {
        if (!this.isVisible()) {
            return;
        }
        Settings.SETTINGS.setSetting(SettingKey.IMG_WIN_X_LOC, String.valueOf(this.getLocationOnScreen().x));
        Settings.SETTINGS.setSetting(SettingKey.IMG_WIN_Y_LOC, String.valueOf(this.getLocationOnScreen().y));
        Settings.SETTINGS.setSetting(SettingKey.IMG_WIN_HEIGHT, String.valueOf(this.getSize().height));
        Settings.SETTINGS.setSetting(SettingKey.IMG_WIN_WIDTH, String.valueOf(this.getSize().width));
        this.dispose();
    }

    private void initializePanels() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_tabbedPane, "Center");
    }

    private void initializeToolbar() {
        JToolBar jtb = new JToolBar();
        jtb.setFloatable(false);
        jtb.add(OpticsAction.ZOOM_IN);
        jtb.add(OpticsAction.ZOOM_OUT);
        jtb.add(OpticsAction.CALC_PHOTONS);
        jtb.add(OpticsAction.CLEAR_IMAGERS);
        jtb.add(OpticsAction.STOP_WRANGLER);
        this.getContentPane().add((Component)jtb, "North");
    }

    private void initializeStatusBar() {
        this.m_statusBar = new ImagerStatusBar();
        this.getContentPane().add((Component)this.m_statusBar, "South");
    }

    private void clearTabs() {
        this.m_tabbedPane.removeAll();
    }

    public void renderDisplay() {
        this.updatePanels();
        this.updateCount();
        this.m_statusBar.repaint();
    }

    @Override
    public void wranglingUpdate(WranglerEvent e) {
        switch (e.getType()) {
            case FINISHED: {
                this.m_statusBar.setTotalCounts(this.m_project.getWrangler().getCurrentCount());
                this.m_statusBar.setStatusToReady();
                break;
            }
            case ONGOING: {
                this.m_statusBar.setCurrentCount(this.m_project.getWrangler().getTotalCounts());
                break;
            }
            case STARTED: {
                this.m_statusBar.setStatusToRunning();
                this.m_statusBar.setTotalCounts(this.m_project.getWrangler().getTotalCounts());
            }
        }
        this.renderDisplay();
    }

    private void updatePanels() {
        int i = this.m_tabbedPane.getSelectedIndex();
        if (i != -1) {
            this.m_outputPanels.get(i).updatePanel();
        }
    }

    public OutputPanel getSelectedPanel() {
        OutputPanel result = null;
        int i = this.m_tabbedPane.getSelectedIndex();
        if (i != -1) {
            result = this.m_outputPanels.get(i);
        }
        return result;
    }

    private void updateCount() {
        if (this.m_project.getWrangler().isWrangling()) {
            this.m_statusBar.setCurrentCount(this.m_project.getWrangler().getCurrentCount());
        }
    }

    public Jocular getApp() {
        return this.m_app;
    }

    public void zoomIn() {
        this.getSelectedPanel().zoomIn();
    }

    public void zoomOut() {
        this.getSelectedPanel().zoomOut();
    }

    public void zoomExtents() {
        this.getSelectedPanel().zoomExtents();
    }
}

