﻿var fixEdge = true


function applyExtend(settings) {
  usePixelUnits()
  var contentAware = settings.contentAware
  var selectedLayers = getSelectedLayers()
  app.activeDocument.suspendHistory("Extend", "_extend()")
  resetUnits()

  function _extend() {
    for (var i = 0; i < selectedLayers.length; i++) {
      var lay = selectedLayers[i]
      app.activeDocument.activeLayer = lay
      if(settings.createCopy) {
        lay = duplicateWithName(lay.name + ' extended')
      }
      if(fixEdge) {
        mergeWithTwoCopies()
      }
      var bounds = pixelBounds(lay.bounds)
      var layWidth = bounds[2] - bounds[0]
      var layHeight = bounds[3] - bounds[1]

      var amounts = {
        top: toPx(settings.topAmount, layHeight),
        right: toPx(settings.rightAmount, layWidth),
        bottom: toPx(settings.bottomAmount, layHeight),
        left: toPx(settings.leftAmount, layWidth)
      }


      var sides = settings.selectedSides.filter(isOdd)
      var corners = settings.selectedSides.filter(isEven)
      extendSides(bounds, sides, amounts, contentAware)
      extendCorners(bounds, corners, amounts, contentAware)

    } // end layer loop
  }
}

function extendCorners(layerPixelBounds, cornerIndices, amounts, contentAware) {
  var b = layerPixelBounds
  for (var i = 0; i < cornerIndices.length; i++) {
    var cornerIndex = cornerIndices[i]
    var color, fillArea
    var x1 = b[0], x2 = b[2], y1 = b[1], y2 = b[3]

    switch (cornerIndex) {
      case 0: // topleft
        color = colorAt(x1 + 0.5, y1 + 0.5)
        fillArea = expandUpLeft(x1, y1, amounts.left, amounts.top)
        break;
      case 2: // topright
        color = colorAt(x2 - 0.5, y1 + 0.5)
        fillArea = expandUpRight(x2, y1, amounts.right, amounts.top)
        break;
      case 6: // bottomleft
        color = colorAt(x1 + 0.5, y2 - 0.5)
        fillArea = expandDownLeft(x1, y2, amounts.left, amounts.bottom)
        break;
      case 8: // bottomright
        color = colorAt(x2 - 0.5, y2 - 0.5)
        fillArea = expandDownRight(x2, y2, amounts.right, amounts.bottom)
        break;
    }

    select(fillArea)

    if (contentAware) {
      contentAwareFill()
    } else {
      fill(color)
    }
    deselect()
  }
}


function expandUpLeft(x, y, xDist, yDist) {
  return [x - xDist, y - yDist, x, y]
}
function expandDownRight(x, y, xDist, yDist) {
  return [x, y, x + xDist, y + yDist]
}
function expandUpRight(x, y, xDist, yDist) {
  return [x, y - yDist, x + xDist, y]
}
function expandDownLeft(x, y, xDist, yDist) {
  return [x - xDist, y, x, y + yDist]
}

function extendSides(layerPixelBounds, sideIndices, amounts, contentAware) {
  var b = layerPixelBounds
  if (contentAware) {
    _extendSidesCA()
  } else {
    _extendSides()
  }

  function _extendSides() {
    for (var i = 0; i < sideIndices.length; i++) {
      var sideIndex = sideIndices[i]
      var edgePixelBounds
      var xMove = 0, yMove = 0, scaleOffsetX = 0, scaleOffsetY = 0, scaleX = 0, scaleY = 0
      switch (sideIndex) {
        case 1: // top
          edgePixelBounds = [b[0], b[1], b[2], b[1] + 1]
          yMove = -1
          scaleY = amounts.top * 100
          scaleOffsetY = -amounts.top / 2
          break;
        case 3: // left
          edgePixelBounds = [b[0], b[1], b[0] + 1, b[3]]
          xMove = -1
          scaleX = amounts.left * 100
          scaleOffsetX = -amounts.left / 2
          break;
        case 5: // right
          edgePixelBounds = [b[2] - 1, b[1], b[2], b[3]]
          scaleX = amounts.right * 100
          scaleOffsetX = amounts.right / 2
          break;
        case 7: // bottom
          edgePixelBounds = [b[0], b[3] - 1, b[2], b[3]]
          scaleY = amounts.bottom * 100
          scaleOffsetY = amounts.bottom / 2
          break;
      }
      // Apply Extension:
      selectionBoundsToNewLayer(edgePixelBounds)
      if (xMove || yMove) {
        move(targetLayerDescriptor(), xMove, yMove)
      }
      scale(targetLayerDescriptor(), scaleX, scaleY, scaleOffsetX, scaleOffsetY)
      mergeDown()
    }
  }

  function _extendSidesCA() {
    var layWidth = b[2] - b[0]
    var layHeight = b[3] - b[1]
    var srcDistTop = Math.min(amounts.top * 2, layHeight)
    var srcDistRight = Math.min(amounts.right * 2, layWidth)
    var srcDistBottom = Math.min(amounts.bottom * 2, layHeight)
    var srcDistLeft = Math.min(amounts.left * 2, layWidth)

    for (var i = 0; i < sideIndices.length; i++) {
      var sideIndex = sideIndices[i]
      var fillArea, sourceArea

      switch (sideIndex) {
        case 1: // top
          sourceArea = [b[0], b[1], b[2], b[1] + srcDistTop]
          fillArea = [b[0], b[1] - amounts.top, b[2], b[1]]
          break;
        case 3: // left
          sourceArea = [b[0], b[1], b[0] + srcDistLeft, b[3]]
          fillArea = [b[0] - amounts.left, b[1], b[0], b[3]]
          break;
        case 5: // right
          sourceArea = [b[2] - srcDistRight, b[1], b[2], b[3]]
          fillArea = [b[2], b[1], b[2] + amounts.right, b[3]]
          break;
        case 7: // bottom
          sourceArea = [b[0], b[3] - srcDistBottom, b[2], b[3]]
          fillArea = [b[0], b[3], b[2], b[3] + amounts.bottom]
          break;
      }

      // Apply Content Aware Extension:
      selectionBoundsToNewLayer(sourceArea)
      select(fillArea)
      contentAwareFill()
      invertSelection()
      deletePixels()
      deselect()
      mergeDown()
    }
  }
}

function applyClip(settings) {
  usePixelUnits()
  var selectedLayers = getSelectedLayers()
  app.activeDocument.suspendHistory("Extend", "_clip()")
  resetUnits()

  function _clip() {
    for (var i = 0; i < selectedLayers.length; i++) {
      var lay = selectedLayers[i]
      app.activeDocument.activeLayer = lay
      if(settings.createCopy) {
        lay = duplicateWithName(lay.name + ' clipped')
      }
      var bounds = pixelBounds(lay.bounds)
      var layWidth = bounds[2] - bounds[0]
      var layHeight = bounds[3] - bounds[1]
    
      var amounts = {
        top: toPx(settings.topAmount, layHeight),
        right: toPx(settings.rightAmount, layWidth),
        bottom: toPx(settings.bottomAmount, layHeight),
        left: toPx(settings.leftAmount, layWidth)
      }
    
      var sides = settings.selectedSides.filter(isOdd)
      var deletePx = lay.kind == LayerKind.NORMAL
      clipSides(bounds, sides, amounts, deletePx, hasLayerMask())
    } // end layer loop
  }
}

function clipSides(layerPixelBounds, sideIndices, amounts, deletePx, layerHasMask) {
  var b = layerPixelBounds
  var clipAreas = []
  for (var i = 0; i < sideIndices.length; i++) {
    switch (sideIndices[i]) {
      case 1: // top
        clipAreas.push([b[0], b[1], b[2], b[1] + amounts.top])
        break;
      case 3: // left
        clipAreas.push([b[0], b[1], b[0] + amounts.left, b[3]])
        break;
      case 5: // right
        clipAreas.push([b[2] - amounts.right, b[1], b[2], b[3]])
        break;
      case 7: // bottom
        clipAreas.push([b[0], b[3] - amounts.bottom, b[2], b[3]])
        break;
    }
  }
  // Apply Clipping:
  if(layerHasMask) {
    selectMask()
    selectionFromMultipleRects(clipAreas)
    fillBlack()
  } else if(deletePx) {
    selectionFromMultipleRects(clipAreas)
    deletePixels()
  } else {
    createNewMask()
    selectionFromMultipleRects(clipAreas)
    fillBlack()
  }
  deselect()  
}

function applyFitToSpace(settings) {
  usePixelUnits()
  var doc = app.activeDocument
  var docSize = _docSize()
  var availableSpace
  var selectionActive = doc.selection.active()

  if(selectionActive) {
    availableSpace = pixelBounds(doc.selection.bounds)
    deselect()
  } else {
    availableSpace = [0,0, docSize.width, docSize.height]
  }

  var sides = settings.selectedSides.filter(isOdd)
  var corners = settings.selectedSides.filter(isEven)

  var selectedLayers = getSelectedLayers()
  app.activeDocument.suspendHistory("Fit", "_fit()")
  resetUnits()

  function _fit() {
    for (var i = 0; i < selectedLayers.length; i++) {
      var lay = selectedLayers[i]
      app.activeDocument.activeLayer = lay
      if(settings.createCopy) {
        lay = duplicateWithName(lay.name + ' extended')
      }
      if(fixEdge) {
        mergeWithTwoCopies()
      }
      var bounds = pixelBounds(lay.bounds)
      var amounts = {
        top: bounds[1] - availableSpace[1],
        right: availableSpace[2] - bounds[2],
        bottom: availableSpace[3] - bounds[3],
        left: bounds[0] - availableSpace[0],        
      }

      var amountPositive = function(sideIndex) {
        return (sideIndex == 1 && amounts.top > 0) ||
        (sideIndex == 3 && amounts.left > 0) ||
        (sideIndex == 5 && amounts.right > 0) || 
        (sideIndex == 7 && amounts.bottom > 0)
      }

      var sidesToExtend = sides.filter(amountPositive)
 
      extendSides(bounds, sidesToExtend, amounts, settings.contentAware)
      extendCorners(bounds, corners, amounts, settings.contentAware)
    }
  }
}

function mergeWithTwoCopies() {
  duplicateActive()
  duplicateActive()
  mergeDown()
  mergeDown()
}

function isEven(n) {
  return n % 2 == 0;
}

function isOdd(n) {
  return Math.abs(n % 2) == 1;
}



