#include <pro.h>
#include "findcrypt.hpp"

// Various constants used in crypto algorithms
// They were copied from public domain codes

//-----------------
static const unsigned int zinflate_lengthStarts[] =
{
  3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31,
  35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258
};
static const unsigned int zinflate_lengthExtraBits[] =
{
  0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2,
  3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0
};
static const unsigned int zinflate_distanceStarts[] =
{
  1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193,
  257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145,
  8193, 12289, 16385, 24577
};
static const unsigned int zinflate_distanceExtraBits[] =
{
  0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6,
  7, 7, 8, 8, 9, 9, 10, 10, 11, 11,
  12, 12, 13, 13
};
//-----------------
static const unsigned int zdeflate_lengthCodes[] =
{
  257, 258, 259, 260, 261, 262, 263, 264, 265, 265, 266, 266, 267, 267, 268, 268,
  269, 269, 269, 269, 270, 270, 270, 270, 271, 271, 271, 271, 272, 272, 272, 272,
  273, 273, 273, 273, 273, 273, 273, 273, 274, 274, 274, 274, 274, 274, 274, 274,
  275, 275, 275, 275, 275, 275, 275, 275, 276, 276, 276, 276, 276, 276, 276, 276,
  277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 279,
  280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280,
  281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281,
  281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281,
  282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282,
  282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 282,
  283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283,
  283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283,
  284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284,
  284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284, 285
};

//-----------------
static const word64 Whirlpool_C0[256] =
{
  W64LIT(0x1818281878c0d878), W64LIT(0x23236523af0526af),
  W64LIT(0xc6c657c6f97eb8f9), W64LIT(0xe8e825e86f13fb6f),
  W64LIT(0x87879487a14ccba1), W64LIT(0xb8b8d5b862a91162),
  W64LIT(0x0101030105080905), W64LIT(0x4f4fd14f6e420d6e),
  W64LIT(0x36365a36eead9bee), W64LIT(0xa6a6f7a60459ff04),
  W64LIT(0xd2d26bd2bdde0cbd), W64LIT(0xf5f502f506fb0e06),
  W64LIT(0x79798b7980ef9680), W64LIT(0x6f6fb16fce5f30ce),
  W64LIT(0x9191ae91effc6def), W64LIT(0x5252f65207aaf807),
  W64LIT(0x6060a060fd2747fd), W64LIT(0xbcbcd9bc76893576),
  W64LIT(0x9b9bb09bcdac37cd), W64LIT(0x8e8e8f8e8c048a8c),
  W64LIT(0xa3a3f8a31571d215), W64LIT(0x0c0c140c3c606c3c),
  W64LIT(0x7b7b8d7b8aff848a), W64LIT(0x35355f35e1b580e1),
  W64LIT(0x1d1d271d69e8f569), W64LIT(0xe0e03de04753b347),
  W64LIT(0xd7d764d7acf621ac), W64LIT(0xc2c25bc2ed5e9ced),
  W64LIT(0x2e2e722e966d4396), W64LIT(0x4b4bdd4b7a62297a),
  W64LIT(0xfefe1ffe21a35d21), W64LIT(0x5757f9571682d516),
  W64LIT(0x15153f1541a8bd41), W64LIT(0x77779977b69fe8b6),
  W64LIT(0x37375937eba592eb), W64LIT(0xe5e532e5567b9e56),
  W64LIT(0x9f9fbc9fd98c13d9), W64LIT(0xf0f00df017d32317),
  W64LIT(0x4a4ade4a7f6a207f), W64LIT(0xdada73da959e4495),
  W64LIT(0x5858e85825faa225), W64LIT(0xc9c946c9ca06cfca),
  W64LIT(0x29297b298d557c8d), W64LIT(0x0a0a1e0a22505a22),
  W64LIT(0xb1b1ceb14fe1504f), W64LIT(0xa0a0fda01a69c91a),
  W64LIT(0x6b6bbd6bda7f14da), W64LIT(0x85859285ab5cd9ab),
  W64LIT(0xbdbddabd73813c73), W64LIT(0x5d5de75d34d28f34),
  W64LIT(0x1010301050809050), W64LIT(0xf4f401f403f30703),
  W64LIT(0xcbcb40cbc016ddc0), W64LIT(0x3e3e423ec6edd3c6),
  W64LIT(0x05050f0511282d11), W64LIT(0x6767a967e61f78e6),
  W64LIT(0xe4e431e453739753), W64LIT(0x27276927bb2502bb),
  W64LIT(0x4141c34158327358), W64LIT(0x8b8b808b9d2ca79d),
  W64LIT(0xa7a7f4a70151f601), W64LIT(0x7d7d877d94cfb294),
  W64LIT(0x9595a295fbdc49fb), W64LIT(0xd8d875d89f8e569f),
  W64LIT(0xfbfb10fb308b7030), W64LIT(0xeeee2fee7123cd71),
  W64LIT(0x7c7c847c91c7bb91), W64LIT(0x6666aa66e31771e3),
  W64LIT(0xdddd7add8ea67b8e), W64LIT(0x171739174bb8af4b),
  W64LIT(0x4747c94746024546), W64LIT(0x9e9ebf9edc841adc),
  W64LIT(0xcaca43cac51ed4c5), W64LIT(0x2d2d772d99755899),
  W64LIT(0xbfbfdcbf79912e79), W64LIT(0x070709071b383f1b),
  W64LIT(0xadadeaad2301ac23), W64LIT(0x5a5aee5a2feab02f),
  W64LIT(0x83839883b56cefb5), W64LIT(0x33335533ff85b6ff),
  W64LIT(0x6363a563f23f5cf2), W64LIT(0x020206020a10120a),
  W64LIT(0xaaaae3aa38399338), W64LIT(0x71719371a8afdea8),
  W64LIT(0xc8c845c8cf0ec6cf), W64LIT(0x19192b197dc8d17d),
  W64LIT(0x4949db4970723b70), W64LIT(0xd9d976d99a865f9a),
  W64LIT(0xf2f20bf21dc3311d), W64LIT(0xe3e338e3484ba848),
  W64LIT(0x5b5bed5b2ae2b92a), W64LIT(0x888885889234bc92),
  W64LIT(0x9a9ab39ac8a43ec8), W64LIT(0x26266a26be2d0bbe),
  W64LIT(0x32325632fa8dbffa), W64LIT(0xb0b0cdb04ae9594a),
  W64LIT(0xe9e926e96a1bf26a), W64LIT(0x0f0f110f33787733),
  W64LIT(0xd5d562d5a6e633a6), W64LIT(0x80809d80ba74f4ba),
  W64LIT(0xbebedfbe7c99277c), W64LIT(0xcdcd4acdde26ebde),
  W64LIT(0x34345c34e4bd89e4), W64LIT(0x4848d848757a3275),
  W64LIT(0xffff1cff24ab5424), W64LIT(0x7a7a8e7a8ff78d8f),
  W64LIT(0x9090ad90eaf464ea), W64LIT(0x5f5fe15f3ec29d3e),
  W64LIT(0x20206020a01d3da0), W64LIT(0x6868b868d5670fd5),
  W64LIT(0x1a1a2e1a72d0ca72), W64LIT(0xaeaeefae2c19b72c),
  W64LIT(0xb4b4c1b45ec97d5e), W64LIT(0x5454fc54199ace19),
  W64LIT(0x9393a893e5ec7fe5), W64LIT(0x22226622aa0d2faa),
  W64LIT(0x6464ac64e90763e9), W64LIT(0xf1f10ef112db2a12),
  W64LIT(0x73739573a2bfcca2), W64LIT(0x121236125a90825a),
  W64LIT(0x4040c0405d3a7a5d), W64LIT(0x0808180828404828),
  W64LIT(0xc3c358c3e85695e8), W64LIT(0xecec29ec7b33df7b),
  W64LIT(0xdbdb70db90964d90), W64LIT(0xa1a1fea11f61c01f),
  W64LIT(0x8d8d8a8d831c9183), W64LIT(0x3d3d473dc9f5c8c9),
  W64LIT(0x9797a497f1cc5bf1), W64LIT(0x0000000000000000),
  W64LIT(0xcfcf4ccfd436f9d4), W64LIT(0x2b2b7d2b87456e87),
  W64LIT(0x76769a76b397e1b3), W64LIT(0x82829b82b064e6b0),
  W64LIT(0xd6d667d6a9fe28a9), W64LIT(0x1b1b2d1b77d8c377),
  W64LIT(0xb5b5c2b55bc1745b), W64LIT(0xafafecaf2911be29),
  W64LIT(0x6a6abe6adf771ddf), W64LIT(0x5050f0500dbaea0d),
  W64LIT(0x4545cf454c12574c), W64LIT(0xf3f308f318cb3818),
  W64LIT(0x30305030f09dadf0), W64LIT(0xefef2cef742bc474),
  W64LIT(0x3f3f413fc3e5dac3), W64LIT(0x5555ff551c92c71c),
  W64LIT(0xa2a2fba21079db10), W64LIT(0xeaea23ea6503e965),
  W64LIT(0x6565af65ec0f6aec), W64LIT(0xbabad3ba68b90368),
  W64LIT(0x2f2f712f93654a93), W64LIT(0xc0c05dc0e74e8ee7),
  W64LIT(0xdede7fde81be6081), W64LIT(0x1c1c241c6ce0fc6c),
  W64LIT(0xfdfd1afd2ebb462e), W64LIT(0x4d4dd74d64521f64),
  W64LIT(0x9292ab92e0e476e0), W64LIT(0x75759f75bc8ffabc),
  W64LIT(0x06060a061e30361e), W64LIT(0x8a8a838a9824ae98),
  W64LIT(0xb2b2cbb240f94b40), W64LIT(0xe6e637e659638559),
  W64LIT(0x0e0e120e36707e36), W64LIT(0x1f1f211f63f8e763),
  W64LIT(0x6262a662f73755f7), W64LIT(0xd4d461d4a3ee3aa3),
  W64LIT(0xa8a8e5a832298132), W64LIT(0x9696a796f4c452f4),
  W64LIT(0xf9f916f93a9b623a), W64LIT(0xc5c552c5f666a3f6),
  W64LIT(0x25256f25b13510b1), W64LIT(0x5959eb5920f2ab20),
  W64LIT(0x84849184ae54d0ae), W64LIT(0x72729672a7b7c5a7),
  W64LIT(0x39394b39ddd5ecdd), W64LIT(0x4c4cd44c615a1661),
  W64LIT(0x5e5ee25e3bca943b), W64LIT(0x7878887885e79f85),
  W64LIT(0x38384838d8dde5d8), W64LIT(0x8c8c898c86149886),
  W64LIT(0xd1d16ed1b2c617b2), W64LIT(0xa5a5f2a50b41e40b),
  W64LIT(0xe2e23be24d43a14d), W64LIT(0x6161a361f82f4ef8),
  W64LIT(0xb3b3c8b345f14245), W64LIT(0x21216321a51534a5),
  W64LIT(0x9c9cb99cd69408d6), W64LIT(0x1e1e221e66f0ee66),
  W64LIT(0x4343c54352226152), W64LIT(0xc7c754c7fc76b1fc),
  W64LIT(0xfcfc19fc2bb34f2b), W64LIT(0x04040c0414202414),
  W64LIT(0x5151f35108b2e308), W64LIT(0x9999b699c7bc25c7),
  W64LIT(0x6d6db76dc44f22c4), W64LIT(0x0d0d170d39686539),
  W64LIT(0xfafa13fa35837935), W64LIT(0xdfdf7cdf84b66984),
  W64LIT(0x7e7e827e9bd7a99b), W64LIT(0x24246c24b43d19b4),
  W64LIT(0x3b3b4d3bd7c5fed7), W64LIT(0xababe0ab3d319a3d),
  W64LIT(0xcece4fced13ef0d1), W64LIT(0x1111331155889955),
  W64LIT(0x8f8f8c8f890c8389), W64LIT(0x4e4ed24e6b4a046b),
  W64LIT(0xb7b7c4b751d16651), W64LIT(0xebeb20eb600be060),
  W64LIT(0x3c3c443cccfdc1cc), W64LIT(0x81819e81bf7cfdbf),
  W64LIT(0x9494a194fed440fe), W64LIT(0xf7f704f70ceb1c0c),
  W64LIT(0xb9b9d6b967a11867), W64LIT(0x131335135f988b5f),
  W64LIT(0x2c2c742c9c7d519c), W64LIT(0xd3d368d3b8d605b8),
  W64LIT(0xe7e734e75c6b8c5c), W64LIT(0x6e6eb26ecb5739cb),
  W64LIT(0xc4c451c4f36eaaf3), W64LIT(0x030305030f181b0f),
  W64LIT(0x5656fa56138adc13), W64LIT(0x4444cc44491a5e49),
  W64LIT(0x7f7f817f9edfa09e), W64LIT(0xa9a9e6a937218837),
  W64LIT(0x2a2a7e2a824d6782), W64LIT(0xbbbbd0bb6db10a6d),
  W64LIT(0xc1c15ec1e24687e2), W64LIT(0x5353f55302a2f102),
  W64LIT(0xdcdc79dc8bae728b), W64LIT(0x0b0b1d0b27585327),
  W64LIT(0x9d9dba9dd39c01d3), W64LIT(0x6c6cb46cc1472bc1),
  W64LIT(0x31315331f595a4f5), W64LIT(0x74749c74b987f3b9),
  W64LIT(0xf6f607f609e31509), W64LIT(0x4646ca46430a4c43),
  W64LIT(0xacace9ac2609a526), W64LIT(0x89898689973cb597),
  W64LIT(0x14143c1444a0b444), W64LIT(0xe1e13ee1425bba42),
  W64LIT(0x16163a164eb0a64e), W64LIT(0x3a3a4e3ad2cdf7d2),
  W64LIT(0x6969bb69d06f06d0), W64LIT(0x09091b092d48412d),
  W64LIT(0x70709070ada7d7ad), W64LIT(0xb6b6c7b654d96f54),
  W64LIT(0xd0d06dd0b7ce1eb7), W64LIT(0xeded2aed7e3bd67e),
  W64LIT(0xcccc49ccdb2ee2db), W64LIT(0x4242c642572a6857),
  W64LIT(0x9898b598c2b42cc2), W64LIT(0xa4a4f1a40e49ed0e),
  W64LIT(0x28287828885d7588), W64LIT(0x5c5ce45c31da8631),
  W64LIT(0xf8f815f83f936b3f), W64LIT(0x86869786a444c2a4),
};

static const word64 Whirlpool_C1[256] =
{
  W64LIT(0x781818281878c0d8), W64LIT(0xaf23236523af0526),
  W64LIT(0xf9c6c657c6f97eb8), W64LIT(0x6fe8e825e86f13fb),
  W64LIT(0xa187879487a14ccb), W64LIT(0x62b8b8d5b862a911),
  W64LIT(0x0501010301050809), W64LIT(0x6e4f4fd14f6e420d),
  W64LIT(0xee36365a36eead9b), W64LIT(0x04a6a6f7a60459ff),
  W64LIT(0xbdd2d26bd2bdde0c), W64LIT(0x06f5f502f506fb0e),
  W64LIT(0x8079798b7980ef96), W64LIT(0xce6f6fb16fce5f30),
  W64LIT(0xef9191ae91effc6d), W64LIT(0x075252f65207aaf8),
  W64LIT(0xfd6060a060fd2747), W64LIT(0x76bcbcd9bc768935),
  W64LIT(0xcd9b9bb09bcdac37), W64LIT(0x8c8e8e8f8e8c048a),
  W64LIT(0x15a3a3f8a31571d2), W64LIT(0x3c0c0c140c3c606c),
  W64LIT(0x8a7b7b8d7b8aff84), W64LIT(0xe135355f35e1b580),
  W64LIT(0x691d1d271d69e8f5), W64LIT(0x47e0e03de04753b3),
  W64LIT(0xacd7d764d7acf621), W64LIT(0xedc2c25bc2ed5e9c),
  W64LIT(0x962e2e722e966d43), W64LIT(0x7a4b4bdd4b7a6229),
  W64LIT(0x21fefe1ffe21a35d), W64LIT(0x165757f9571682d5),
  W64LIT(0x4115153f1541a8bd), W64LIT(0xb677779977b69fe8),
  W64LIT(0xeb37375937eba592), W64LIT(0x56e5e532e5567b9e),
  W64LIT(0xd99f9fbc9fd98c13), W64LIT(0x17f0f00df017d323),
  W64LIT(0x7f4a4ade4a7f6a20), W64LIT(0x95dada73da959e44),
  W64LIT(0x255858e85825faa2), W64LIT(0xcac9c946c9ca06cf),
  W64LIT(0x8d29297b298d557c), W64LIT(0x220a0a1e0a22505a),
  W64LIT(0x4fb1b1ceb14fe150), W64LIT(0x1aa0a0fda01a69c9),
  W64LIT(0xda6b6bbd6bda7f14), W64LIT(0xab85859285ab5cd9),
  W64LIT(0x73bdbddabd73813c), W64LIT(0x345d5de75d34d28f),
  W64LIT(0x5010103010508090), W64LIT(0x03f4f401f403f307),
  W64LIT(0xc0cbcb40cbc016dd), W64LIT(0xc63e3e423ec6edd3),
  W64LIT(0x1105050f0511282d), W64LIT(0xe66767a967e61f78),
  W64LIT(0x53e4e431e4537397), W64LIT(0xbb27276927bb2502),
  W64LIT(0x584141c341583273), W64LIT(0x9d8b8b808b9d2ca7),
  W64LIT(0x01a7a7f4a70151f6), W64LIT(0x947d7d877d94cfb2),
  W64LIT(0xfb9595a295fbdc49), W64LIT(0x9fd8d875d89f8e56),
  W64LIT(0x30fbfb10fb308b70), W64LIT(0x71eeee2fee7123cd),
  W64LIT(0x917c7c847c91c7bb), W64LIT(0xe36666aa66e31771),
  W64LIT(0x8edddd7add8ea67b), W64LIT(0x4b171739174bb8af),
  W64LIT(0x464747c947460245), W64LIT(0xdc9e9ebf9edc841a),
  W64LIT(0xc5caca43cac51ed4), W64LIT(0x992d2d772d997558),
  W64LIT(0x79bfbfdcbf79912e), W64LIT(0x1b070709071b383f),
  W64LIT(0x23adadeaad2301ac), W64LIT(0x2f5a5aee5a2feab0),
  W64LIT(0xb583839883b56cef), W64LIT(0xff33335533ff85b6),
  W64LIT(0xf26363a563f23f5c), W64LIT(0x0a020206020a1012),
  W64LIT(0x38aaaae3aa383993), W64LIT(0xa871719371a8afde),
  W64LIT(0xcfc8c845c8cf0ec6), W64LIT(0x7d19192b197dc8d1),
  W64LIT(0x704949db4970723b), W64LIT(0x9ad9d976d99a865f),
  W64LIT(0x1df2f20bf21dc331), W64LIT(0x48e3e338e3484ba8),
  W64LIT(0x2a5b5bed5b2ae2b9), W64LIT(0x92888885889234bc),
  W64LIT(0xc89a9ab39ac8a43e), W64LIT(0xbe26266a26be2d0b),
  W64LIT(0xfa32325632fa8dbf), W64LIT(0x4ab0b0cdb04ae959),
  W64LIT(0x6ae9e926e96a1bf2), W64LIT(0x330f0f110f337877),
  W64LIT(0xa6d5d562d5a6e633), W64LIT(0xba80809d80ba74f4),
  W64LIT(0x7cbebedfbe7c9927), W64LIT(0xdecdcd4acdde26eb),
  W64LIT(0xe434345c34e4bd89), W64LIT(0x754848d848757a32),
  W64LIT(0x24ffff1cff24ab54), W64LIT(0x8f7a7a8e7a8ff78d),
  W64LIT(0xea9090ad90eaf464), W64LIT(0x3e5f5fe15f3ec29d),
  W64LIT(0xa020206020a01d3d), W64LIT(0xd56868b868d5670f),
  W64LIT(0x721a1a2e1a72d0ca), W64LIT(0x2caeaeefae2c19b7),
  W64LIT(0x5eb4b4c1b45ec97d), W64LIT(0x195454fc54199ace),
  W64LIT(0xe59393a893e5ec7f), W64LIT(0xaa22226622aa0d2f),
  W64LIT(0xe96464ac64e90763), W64LIT(0x12f1f10ef112db2a),
  W64LIT(0xa273739573a2bfcc), W64LIT(0x5a121236125a9082),
  W64LIT(0x5d4040c0405d3a7a), W64LIT(0x2808081808284048),
  W64LIT(0xe8c3c358c3e85695), W64LIT(0x7becec29ec7b33df),
  W64LIT(0x90dbdb70db90964d), W64LIT(0x1fa1a1fea11f61c0),
  W64LIT(0x838d8d8a8d831c91), W64LIT(0xc93d3d473dc9f5c8),
  W64LIT(0xf19797a497f1cc5b), W64LIT(0x0000000000000000),
  W64LIT(0xd4cfcf4ccfd436f9), W64LIT(0x872b2b7d2b87456e),
  W64LIT(0xb376769a76b397e1), W64LIT(0xb082829b82b064e6),
  W64LIT(0xa9d6d667d6a9fe28), W64LIT(0x771b1b2d1b77d8c3),
  W64LIT(0x5bb5b5c2b55bc174), W64LIT(0x29afafecaf2911be),
  W64LIT(0xdf6a6abe6adf771d), W64LIT(0x0d5050f0500dbaea),
  W64LIT(0x4c4545cf454c1257), W64LIT(0x18f3f308f318cb38),
  W64LIT(0xf030305030f09dad), W64LIT(0x74efef2cef742bc4),
  W64LIT(0xc33f3f413fc3e5da), W64LIT(0x1c5555ff551c92c7),
  W64LIT(0x10a2a2fba21079db), W64LIT(0x65eaea23ea6503e9),
  W64LIT(0xec6565af65ec0f6a), W64LIT(0x68babad3ba68b903),
  W64LIT(0x932f2f712f93654a), W64LIT(0xe7c0c05dc0e74e8e),
  W64LIT(0x81dede7fde81be60), W64LIT(0x6c1c1c241c6ce0fc),
  W64LIT(0x2efdfd1afd2ebb46), W64LIT(0x644d4dd74d64521f),
  W64LIT(0xe09292ab92e0e476), W64LIT(0xbc75759f75bc8ffa),
  W64LIT(0x1e06060a061e3036), W64LIT(0x988a8a838a9824ae),
  W64LIT(0x40b2b2cbb240f94b), W64LIT(0x59e6e637e6596385),
  W64LIT(0x360e0e120e36707e), W64LIT(0x631f1f211f63f8e7),
  W64LIT(0xf76262a662f73755), W64LIT(0xa3d4d461d4a3ee3a),
  W64LIT(0x32a8a8e5a8322981), W64LIT(0xf49696a796f4c452),
  W64LIT(0x3af9f916f93a9b62), W64LIT(0xf6c5c552c5f666a3),
  W64LIT(0xb125256f25b13510), W64LIT(0x205959eb5920f2ab),
  W64LIT(0xae84849184ae54d0), W64LIT(0xa772729672a7b7c5),
  W64LIT(0xdd39394b39ddd5ec), W64LIT(0x614c4cd44c615a16),
  W64LIT(0x3b5e5ee25e3bca94), W64LIT(0x857878887885e79f),
  W64LIT(0xd838384838d8dde5), W64LIT(0x868c8c898c861498),
  W64LIT(0xb2d1d16ed1b2c617), W64LIT(0x0ba5a5f2a50b41e4),
  W64LIT(0x4de2e23be24d43a1), W64LIT(0xf86161a361f82f4e),
  W64LIT(0x45b3b3c8b345f142), W64LIT(0xa521216321a51534),
  W64LIT(0xd69c9cb99cd69408), W64LIT(0x661e1e221e66f0ee),
  W64LIT(0x524343c543522261), W64LIT(0xfcc7c754c7fc76b1),
  W64LIT(0x2bfcfc19fc2bb34f), W64LIT(0x1404040c04142024),
  W64LIT(0x085151f35108b2e3), W64LIT(0xc79999b699c7bc25),
  W64LIT(0xc46d6db76dc44f22), W64LIT(0x390d0d170d396865),
  W64LIT(0x35fafa13fa358379), W64LIT(0x84dfdf7cdf84b669),
  W64LIT(0x9b7e7e827e9bd7a9), W64LIT(0xb424246c24b43d19),
  W64LIT(0xd73b3b4d3bd7c5fe), W64LIT(0x3dababe0ab3d319a),
  W64LIT(0xd1cece4fced13ef0), W64LIT(0x5511113311558899),
  W64LIT(0x898f8f8c8f890c83), W64LIT(0x6b4e4ed24e6b4a04),
  W64LIT(0x51b7b7c4b751d166), W64LIT(0x60ebeb20eb600be0),
  W64LIT(0xcc3c3c443cccfdc1), W64LIT(0xbf81819e81bf7cfd),
  W64LIT(0xfe9494a194fed440), W64LIT(0x0cf7f704f70ceb1c),
  W64LIT(0x67b9b9d6b967a118), W64LIT(0x5f131335135f988b),
  W64LIT(0x9c2c2c742c9c7d51), W64LIT(0xb8d3d368d3b8d605),
  W64LIT(0x5ce7e734e75c6b8c), W64LIT(0xcb6e6eb26ecb5739),
  W64LIT(0xf3c4c451c4f36eaa), W64LIT(0x0f030305030f181b),
  W64LIT(0x135656fa56138adc), W64LIT(0x494444cc44491a5e),
  W64LIT(0x9e7f7f817f9edfa0), W64LIT(0x37a9a9e6a9372188),
  W64LIT(0x822a2a7e2a824d67), W64LIT(0x6dbbbbd0bb6db10a),
  W64LIT(0xe2c1c15ec1e24687), W64LIT(0x025353f55302a2f1),
  W64LIT(0x8bdcdc79dc8bae72), W64LIT(0x270b0b1d0b275853),
  W64LIT(0xd39d9dba9dd39c01), W64LIT(0xc16c6cb46cc1472b),
  W64LIT(0xf531315331f595a4), W64LIT(0xb974749c74b987f3),
  W64LIT(0x09f6f607f609e315), W64LIT(0x434646ca46430a4c),
  W64LIT(0x26acace9ac2609a5), W64LIT(0x9789898689973cb5),
  W64LIT(0x4414143c1444a0b4), W64LIT(0x42e1e13ee1425bba),
  W64LIT(0x4e16163a164eb0a6), W64LIT(0xd23a3a4e3ad2cdf7),
  W64LIT(0xd06969bb69d06f06), W64LIT(0x2d09091b092d4841),
  W64LIT(0xad70709070ada7d7), W64LIT(0x54b6b6c7b654d96f),
  W64LIT(0xb7d0d06dd0b7ce1e), W64LIT(0x7eeded2aed7e3bd6),
  W64LIT(0xdbcccc49ccdb2ee2), W64LIT(0x574242c642572a68),
  W64LIT(0xc29898b598c2b42c), W64LIT(0x0ea4a4f1a40e49ed),
  W64LIT(0x8828287828885d75), W64LIT(0x315c5ce45c31da86),
  W64LIT(0x3ff8f815f83f936b), W64LIT(0xa486869786a444c2),
};

static const word64 Whirlpool_C2[256] =
{
  W64LIT(0xd8781818281878c0), W64LIT(0x26af23236523af05),
  W64LIT(0xb8f9c6c657c6f97e), W64LIT(0xfb6fe8e825e86f13),
  W64LIT(0xcba187879487a14c), W64LIT(0x1162b8b8d5b862a9),
  W64LIT(0x0905010103010508), W64LIT(0x0d6e4f4fd14f6e42),
  W64LIT(0x9bee36365a36eead), W64LIT(0xff04a6a6f7a60459),
  W64LIT(0x0cbdd2d26bd2bdde), W64LIT(0x0e06f5f502f506fb),
  W64LIT(0x968079798b7980ef), W64LIT(0x30ce6f6fb16fce5f),
  W64LIT(0x6def9191ae91effc), W64LIT(0xf8075252f65207aa),
  W64LIT(0x47fd6060a060fd27), W64LIT(0x3576bcbcd9bc7689),
  W64LIT(0x37cd9b9bb09bcdac), W64LIT(0x8a8c8e8e8f8e8c04),
  W64LIT(0xd215a3a3f8a31571), W64LIT(0x6c3c0c0c140c3c60),
  W64LIT(0x848a7b7b8d7b8aff), W64LIT(0x80e135355f35e1b5),
  W64LIT(0xf5691d1d271d69e8), W64LIT(0xb347e0e03de04753),
  W64LIT(0x21acd7d764d7acf6), W64LIT(0x9cedc2c25bc2ed5e),
  W64LIT(0x43962e2e722e966d), W64LIT(0x297a4b4bdd4b7a62),
  W64LIT(0x5d21fefe1ffe21a3), W64LIT(0xd5165757f9571682),
  W64LIT(0xbd4115153f1541a8), W64LIT(0xe8b677779977b69f),
  W64LIT(0x92eb37375937eba5), W64LIT(0x9e56e5e532e5567b),
  W64LIT(0x13d99f9fbc9fd98c), W64LIT(0x2317f0f00df017d3),
  W64LIT(0x207f4a4ade4a7f6a), W64LIT(0x4495dada73da959e),
  W64LIT(0xa2255858e85825fa), W64LIT(0xcfcac9c946c9ca06),
  W64LIT(0x7c8d29297b298d55), W64LIT(0x5a220a0a1e0a2250),
  W64LIT(0x504fb1b1ceb14fe1), W64LIT(0xc91aa0a0fda01a69),
  W64LIT(0x14da6b6bbd6bda7f), W64LIT(0xd9ab85859285ab5c),
  W64LIT(0x3c73bdbddabd7381), W64LIT(0x8f345d5de75d34d2),
  W64LIT(0x9050101030105080), W64LIT(0x0703f4f401f403f3),
  W64LIT(0xddc0cbcb40cbc016), W64LIT(0xd3c63e3e423ec6ed),
  W64LIT(0x2d1105050f051128), W64LIT(0x78e66767a967e61f),
  W64LIT(0x9753e4e431e45373), W64LIT(0x02bb27276927bb25),
  W64LIT(0x73584141c3415832), W64LIT(0xa79d8b8b808b9d2c),
  W64LIT(0xf601a7a7f4a70151), W64LIT(0xb2947d7d877d94cf),
  W64LIT(0x49fb9595a295fbdc), W64LIT(0x569fd8d875d89f8e),
  W64LIT(0x7030fbfb10fb308b), W64LIT(0xcd71eeee2fee7123),
  W64LIT(0xbb917c7c847c91c7), W64LIT(0x71e36666aa66e317),
  W64LIT(0x7b8edddd7add8ea6), W64LIT(0xaf4b171739174bb8),
  W64LIT(0x45464747c9474602), W64LIT(0x1adc9e9ebf9edc84),
  W64LIT(0xd4c5caca43cac51e), W64LIT(0x58992d2d772d9975),
  W64LIT(0x2e79bfbfdcbf7991), W64LIT(0x3f1b070709071b38),
  W64LIT(0xac23adadeaad2301), W64LIT(0xb02f5a5aee5a2fea),
  W64LIT(0xefb583839883b56c), W64LIT(0xb6ff33335533ff85),
  W64LIT(0x5cf26363a563f23f), W64LIT(0x120a020206020a10),
  W64LIT(0x9338aaaae3aa3839), W64LIT(0xdea871719371a8af),
  W64LIT(0xc6cfc8c845c8cf0e), W64LIT(0xd17d19192b197dc8),
  W64LIT(0x3b704949db497072), W64LIT(0x5f9ad9d976d99a86),
  W64LIT(0x311df2f20bf21dc3), W64LIT(0xa848e3e338e3484b),
  W64LIT(0xb92a5b5bed5b2ae2), W64LIT(0xbc92888885889234),
  W64LIT(0x3ec89a9ab39ac8a4), W64LIT(0x0bbe26266a26be2d),
  W64LIT(0xbffa32325632fa8d), W64LIT(0x594ab0b0cdb04ae9),
  W64LIT(0xf26ae9e926e96a1b), W64LIT(0x77330f0f110f3378),
  W64LIT(0x33a6d5d562d5a6e6), W64LIT(0xf4ba80809d80ba74),
  W64LIT(0x277cbebedfbe7c99), W64LIT(0xebdecdcd4acdde26),
  W64LIT(0x89e434345c34e4bd), W64LIT(0x32754848d848757a),
  W64LIT(0x5424ffff1cff24ab), W64LIT(0x8d8f7a7a8e7a8ff7),
  W64LIT(0x64ea9090ad90eaf4), W64LIT(0x9d3e5f5fe15f3ec2),
  W64LIT(0x3da020206020a01d), W64LIT(0x0fd56868b868d567),
  W64LIT(0xca721a1a2e1a72d0), W64LIT(0xb72caeaeefae2c19),
  W64LIT(0x7d5eb4b4c1b45ec9), W64LIT(0xce195454fc54199a),
  W64LIT(0x7fe59393a893e5ec), W64LIT(0x2faa22226622aa0d),
  W64LIT(0x63e96464ac64e907), W64LIT(0x2a12f1f10ef112db),
  W64LIT(0xcca273739573a2bf), W64LIT(0x825a121236125a90),
  W64LIT(0x7a5d4040c0405d3a), W64LIT(0x4828080818082840),
  W64LIT(0x95e8c3c358c3e856), W64LIT(0xdf7becec29ec7b33),
  W64LIT(0x4d90dbdb70db9096), W64LIT(0xc01fa1a1fea11f61),
  W64LIT(0x91838d8d8a8d831c), W64LIT(0xc8c93d3d473dc9f5),
  W64LIT(0x5bf19797a497f1cc), W64LIT(0x0000000000000000),
  W64LIT(0xf9d4cfcf4ccfd436), W64LIT(0x6e872b2b7d2b8745),
  W64LIT(0xe1b376769a76b397), W64LIT(0xe6b082829b82b064),
  W64LIT(0x28a9d6d667d6a9fe), W64LIT(0xc3771b1b2d1b77d8),
  W64LIT(0x745bb5b5c2b55bc1), W64LIT(0xbe29afafecaf2911),
  W64LIT(0x1ddf6a6abe6adf77), W64LIT(0xea0d5050f0500dba),
  W64LIT(0x574c4545cf454c12), W64LIT(0x3818f3f308f318cb),
  W64LIT(0xadf030305030f09d), W64LIT(0xc474efef2cef742b),
  W64LIT(0xdac33f3f413fc3e5), W64LIT(0xc71c5555ff551c92),
  W64LIT(0xdb10a2a2fba21079), W64LIT(0xe965eaea23ea6503),
  W64LIT(0x6aec6565af65ec0f), W64LIT(0x0368babad3ba68b9),
  W64LIT(0x4a932f2f712f9365), W64LIT(0x8ee7c0c05dc0e74e),
  W64LIT(0x6081dede7fde81be), W64LIT(0xfc6c1c1c241c6ce0),
  W64LIT(0x462efdfd1afd2ebb), W64LIT(0x1f644d4dd74d6452),
  W64LIT(0x76e09292ab92e0e4), W64LIT(0xfabc75759f75bc8f),
  W64LIT(0x361e06060a061e30), W64LIT(0xae988a8a838a9824),
  W64LIT(0x4b40b2b2cbb240f9), W64LIT(0x8559e6e637e65963),
  W64LIT(0x7e360e0e120e3670), W64LIT(0xe7631f1f211f63f8),
  W64LIT(0x55f76262a662f737), W64LIT(0x3aa3d4d461d4a3ee),
  W64LIT(0x8132a8a8e5a83229), W64LIT(0x52f49696a796f4c4),
  W64LIT(0x623af9f916f93a9b), W64LIT(0xa3f6c5c552c5f666),
  W64LIT(0x10b125256f25b135), W64LIT(0xab205959eb5920f2),
  W64LIT(0xd0ae84849184ae54), W64LIT(0xc5a772729672a7b7),
  W64LIT(0xecdd39394b39ddd5), W64LIT(0x16614c4cd44c615a),
  W64LIT(0x943b5e5ee25e3bca), W64LIT(0x9f857878887885e7),
  W64LIT(0xe5d838384838d8dd), W64LIT(0x98868c8c898c8614),
  W64LIT(0x17b2d1d16ed1b2c6), W64LIT(0xe40ba5a5f2a50b41),
  W64LIT(0xa14de2e23be24d43), W64LIT(0x4ef86161a361f82f),
  W64LIT(0x4245b3b3c8b345f1), W64LIT(0x34a521216321a515),
  W64LIT(0x08d69c9cb99cd694), W64LIT(0xee661e1e221e66f0),
  W64LIT(0x61524343c5435222), W64LIT(0xb1fcc7c754c7fc76),
  W64LIT(0x4f2bfcfc19fc2bb3), W64LIT(0x241404040c041420),
  W64LIT(0xe3085151f35108b2), W64LIT(0x25c79999b699c7bc),
  W64LIT(0x22c46d6db76dc44f), W64LIT(0x65390d0d170d3968),
  W64LIT(0x7935fafa13fa3583), W64LIT(0x6984dfdf7cdf84b6),
  W64LIT(0xa99b7e7e827e9bd7), W64LIT(0x19b424246c24b43d),
  W64LIT(0xfed73b3b4d3bd7c5), W64LIT(0x9a3dababe0ab3d31),
  W64LIT(0xf0d1cece4fced13e), W64LIT(0x9955111133115588),
  W64LIT(0x83898f8f8c8f890c), W64LIT(0x046b4e4ed24e6b4a),
  W64LIT(0x6651b7b7c4b751d1), W64LIT(0xe060ebeb20eb600b),
  W64LIT(0xc1cc3c3c443cccfd), W64LIT(0xfdbf81819e81bf7c),
  W64LIT(0x40fe9494a194fed4), W64LIT(0x1c0cf7f704f70ceb),
  W64LIT(0x1867b9b9d6b967a1), W64LIT(0x8b5f131335135f98),
  W64LIT(0x519c2c2c742c9c7d), W64LIT(0x05b8d3d368d3b8d6),
  W64LIT(0x8c5ce7e734e75c6b), W64LIT(0x39cb6e6eb26ecb57),
  W64LIT(0xaaf3c4c451c4f36e), W64LIT(0x1b0f030305030f18),
  W64LIT(0xdc135656fa56138a), W64LIT(0x5e494444cc44491a),
  W64LIT(0xa09e7f7f817f9edf), W64LIT(0x8837a9a9e6a93721),
  W64LIT(0x67822a2a7e2a824d), W64LIT(0x0a6dbbbbd0bb6db1),
  W64LIT(0x87e2c1c15ec1e246), W64LIT(0xf1025353f55302a2),
  W64LIT(0x728bdcdc79dc8bae), W64LIT(0x53270b0b1d0b2758),
  W64LIT(0x01d39d9dba9dd39c), W64LIT(0x2bc16c6cb46cc147),
  W64LIT(0xa4f531315331f595), W64LIT(0xf3b974749c74b987),
  W64LIT(0x1509f6f607f609e3), W64LIT(0x4c434646ca46430a),
  W64LIT(0xa526acace9ac2609), W64LIT(0xb59789898689973c),
  W64LIT(0xb44414143c1444a0), W64LIT(0xba42e1e13ee1425b),
  W64LIT(0xa64e16163a164eb0), W64LIT(0xf7d23a3a4e3ad2cd),
  W64LIT(0x06d06969bb69d06f), W64LIT(0x412d09091b092d48),
  W64LIT(0xd7ad70709070ada7), W64LIT(0x6f54b6b6c7b654d9),
  W64LIT(0x1eb7d0d06dd0b7ce), W64LIT(0xd67eeded2aed7e3b),
  W64LIT(0xe2dbcccc49ccdb2e), W64LIT(0x68574242c642572a),
  W64LIT(0x2cc29898b598c2b4), W64LIT(0xed0ea4a4f1a40e49),
  W64LIT(0x758828287828885d), W64LIT(0x86315c5ce45c31da),
  W64LIT(0x6b3ff8f815f83f93), W64LIT(0xc2a486869786a444),
};

static const word64 Whirlpool_C3[256] =
{
  W64LIT(0xc0d8781818281878), W64LIT(0x0526af23236523af),
  W64LIT(0x7eb8f9c6c657c6f9), W64LIT(0x13fb6fe8e825e86f),
  W64LIT(0x4ccba187879487a1), W64LIT(0xa91162b8b8d5b862),
  W64LIT(0x0809050101030105), W64LIT(0x420d6e4f4fd14f6e),
  W64LIT(0xad9bee36365a36ee), W64LIT(0x59ff04a6a6f7a604),
  W64LIT(0xde0cbdd2d26bd2bd), W64LIT(0xfb0e06f5f502f506),
  W64LIT(0xef968079798b7980), W64LIT(0x5f30ce6f6fb16fce),
  W64LIT(0xfc6def9191ae91ef), W64LIT(0xaaf8075252f65207),
  W64LIT(0x2747fd6060a060fd), W64LIT(0x893576bcbcd9bc76),
  W64LIT(0xac37cd9b9bb09bcd), W64LIT(0x048a8c8e8e8f8e8c),
  W64LIT(0x71d215a3a3f8a315), W64LIT(0x606c3c0c0c140c3c),
  W64LIT(0xff848a7b7b8d7b8a), W64LIT(0xb580e135355f35e1),
  W64LIT(0xe8f5691d1d271d69), W64LIT(0x53b347e0e03de047),
  W64LIT(0xf621acd7d764d7ac), W64LIT(0x5e9cedc2c25bc2ed),
  W64LIT(0x6d43962e2e722e96), W64LIT(0x62297a4b4bdd4b7a),
  W64LIT(0xa35d21fefe1ffe21), W64LIT(0x82d5165757f95716),
  W64LIT(0xa8bd4115153f1541), W64LIT(0x9fe8b677779977b6),
  W64LIT(0xa592eb37375937eb), W64LIT(0x7b9e56e5e532e556),
  W64LIT(0x8c13d99f9fbc9fd9), W64LIT(0xd32317f0f00df017),
  W64LIT(0x6a207f4a4ade4a7f), W64LIT(0x9e4495dada73da95),
  W64LIT(0xfaa2255858e85825), W64LIT(0x06cfcac9c946c9ca),
  W64LIT(0x557c8d29297b298d), W64LIT(0x505a220a0a1e0a22),
  W64LIT(0xe1504fb1b1ceb14f), W64LIT(0x69c91aa0a0fda01a),
  W64LIT(0x7f14da6b6bbd6bda), W64LIT(0x5cd9ab85859285ab),
  W64LIT(0x813c73bdbddabd73), W64LIT(0xd28f345d5de75d34),
  W64LIT(0x8090501010301050), W64LIT(0xf30703f4f401f403),
  W64LIT(0x16ddc0cbcb40cbc0), W64LIT(0xedd3c63e3e423ec6),
  W64LIT(0x282d1105050f0511), W64LIT(0x1f78e66767a967e6),
  W64LIT(0x739753e4e431e453), W64LIT(0x2502bb27276927bb),
  W64LIT(0x3273584141c34158), W64LIT(0x2ca79d8b8b808b9d),
  W64LIT(0x51f601a7a7f4a701), W64LIT(0xcfb2947d7d877d94),
  W64LIT(0xdc49fb9595a295fb), W64LIT(0x8e569fd8d875d89f),
  W64LIT(0x8b7030fbfb10fb30), W64LIT(0x23cd71eeee2fee71),
  W64LIT(0xc7bb917c7c847c91), W64LIT(0x1771e36666aa66e3),
  W64LIT(0xa67b8edddd7add8e), W64LIT(0xb8af4b171739174b),
  W64LIT(0x0245464747c94746), W64LIT(0x841adc9e9ebf9edc),
  W64LIT(0x1ed4c5caca43cac5), W64LIT(0x7558992d2d772d99),
  W64LIT(0x912e79bfbfdcbf79), W64LIT(0x383f1b070709071b),
  W64LIT(0x01ac23adadeaad23), W64LIT(0xeab02f5a5aee5a2f),
  W64LIT(0x6cefb583839883b5), W64LIT(0x85b6ff33335533ff),
  W64LIT(0x3f5cf26363a563f2), W64LIT(0x10120a020206020a),
  W64LIT(0x399338aaaae3aa38), W64LIT(0xafdea871719371a8),
  W64LIT(0x0ec6cfc8c845c8cf), W64LIT(0xc8d17d19192b197d),
  W64LIT(0x723b704949db4970), W64LIT(0x865f9ad9d976d99a),
  W64LIT(0xc3311df2f20bf21d), W64LIT(0x4ba848e3e338e348),
  W64LIT(0xe2b92a5b5bed5b2a), W64LIT(0x34bc928888858892),
  W64LIT(0xa43ec89a9ab39ac8), W64LIT(0x2d0bbe26266a26be),
  W64LIT(0x8dbffa32325632fa), W64LIT(0xe9594ab0b0cdb04a),
  W64LIT(0x1bf26ae9e926e96a), W64LIT(0x7877330f0f110f33),
  W64LIT(0xe633a6d5d562d5a6), W64LIT(0x74f4ba80809d80ba),
  W64LIT(0x99277cbebedfbe7c), W64LIT(0x26ebdecdcd4acdde),
  W64LIT(0xbd89e434345c34e4), W64LIT(0x7a32754848d84875),
  W64LIT(0xab5424ffff1cff24), W64LIT(0xf78d8f7a7a8e7a8f),
  W64LIT(0xf464ea9090ad90ea), W64LIT(0xc29d3e5f5fe15f3e),
  W64LIT(0x1d3da020206020a0), W64LIT(0x670fd56868b868d5),
  W64LIT(0xd0ca721a1a2e1a72), W64LIT(0x19b72caeaeefae2c),
  W64LIT(0xc97d5eb4b4c1b45e), W64LIT(0x9ace195454fc5419),
  W64LIT(0xec7fe59393a893e5), W64LIT(0x0d2faa22226622aa),
  W64LIT(0x0763e96464ac64e9), W64LIT(0xdb2a12f1f10ef112),
  W64LIT(0xbfcca273739573a2), W64LIT(0x90825a121236125a),
  W64LIT(0x3a7a5d4040c0405d), W64LIT(0x4048280808180828),
  W64LIT(0x5695e8c3c358c3e8), W64LIT(0x33df7becec29ec7b),
  W64LIT(0x964d90dbdb70db90), W64LIT(0x61c01fa1a1fea11f),
  W64LIT(0x1c91838d8d8a8d83), W64LIT(0xf5c8c93d3d473dc9),
  W64LIT(0xcc5bf19797a497f1), W64LIT(0x0000000000000000),
  W64LIT(0x36f9d4cfcf4ccfd4), W64LIT(0x456e872b2b7d2b87),
  W64LIT(0x97e1b376769a76b3), W64LIT(0x64e6b082829b82b0),
  W64LIT(0xfe28a9d6d667d6a9), W64LIT(0xd8c3771b1b2d1b77),
  W64LIT(0xc1745bb5b5c2b55b), W64LIT(0x11be29afafecaf29),
  W64LIT(0x771ddf6a6abe6adf), W64LIT(0xbaea0d5050f0500d),
  W64LIT(0x12574c4545cf454c), W64LIT(0xcb3818f3f308f318),
  W64LIT(0x9dadf030305030f0), W64LIT(0x2bc474efef2cef74),
  W64LIT(0xe5dac33f3f413fc3), W64LIT(0x92c71c5555ff551c),
  W64LIT(0x79db10a2a2fba210), W64LIT(0x03e965eaea23ea65),
  W64LIT(0x0f6aec6565af65ec), W64LIT(0xb90368babad3ba68),
  W64LIT(0x654a932f2f712f93), W64LIT(0x4e8ee7c0c05dc0e7),
  W64LIT(0xbe6081dede7fde81), W64LIT(0xe0fc6c1c1c241c6c),
  W64LIT(0xbb462efdfd1afd2e), W64LIT(0x521f644d4dd74d64),
  W64LIT(0xe476e09292ab92e0), W64LIT(0x8ffabc75759f75bc),
  W64LIT(0x30361e06060a061e), W64LIT(0x24ae988a8a838a98),
  W64LIT(0xf94b40b2b2cbb240), W64LIT(0x638559e6e637e659),
  W64LIT(0x707e360e0e120e36), W64LIT(0xf8e7631f1f211f63),
  W64LIT(0x3755f76262a662f7), W64LIT(0xee3aa3d4d461d4a3),
  W64LIT(0x298132a8a8e5a832), W64LIT(0xc452f49696a796f4),
  W64LIT(0x9b623af9f916f93a), W64LIT(0x66a3f6c5c552c5f6),
  W64LIT(0x3510b125256f25b1), W64LIT(0xf2ab205959eb5920),
  W64LIT(0x54d0ae84849184ae), W64LIT(0xb7c5a772729672a7),
  W64LIT(0xd5ecdd39394b39dd), W64LIT(0x5a16614c4cd44c61),
  W64LIT(0xca943b5e5ee25e3b), W64LIT(0xe79f857878887885),
  W64LIT(0xdde5d838384838d8), W64LIT(0x1498868c8c898c86),
  W64LIT(0xc617b2d1d16ed1b2), W64LIT(0x41e40ba5a5f2a50b),
  W64LIT(0x43a14de2e23be24d), W64LIT(0x2f4ef86161a361f8),
  W64LIT(0xf14245b3b3c8b345), W64LIT(0x1534a521216321a5),
  W64LIT(0x9408d69c9cb99cd6), W64LIT(0xf0ee661e1e221e66),
  W64LIT(0x2261524343c54352), W64LIT(0x76b1fcc7c754c7fc),
  W64LIT(0xb34f2bfcfc19fc2b), W64LIT(0x20241404040c0414),
  W64LIT(0xb2e3085151f35108), W64LIT(0xbc25c79999b699c7),
  W64LIT(0x4f22c46d6db76dc4), W64LIT(0x6865390d0d170d39),
  W64LIT(0x837935fafa13fa35), W64LIT(0xb66984dfdf7cdf84),
  W64LIT(0xd7a99b7e7e827e9b), W64LIT(0x3d19b424246c24b4),
  W64LIT(0xc5fed73b3b4d3bd7), W64LIT(0x319a3dababe0ab3d),
  W64LIT(0x3ef0d1cece4fced1), W64LIT(0x8899551111331155),
  W64LIT(0x0c83898f8f8c8f89), W64LIT(0x4a046b4e4ed24e6b),
  W64LIT(0xd16651b7b7c4b751), W64LIT(0x0be060ebeb20eb60),
  W64LIT(0xfdc1cc3c3c443ccc), W64LIT(0x7cfdbf81819e81bf),
  W64LIT(0xd440fe9494a194fe), W64LIT(0xeb1c0cf7f704f70c),
  W64LIT(0xa11867b9b9d6b967), W64LIT(0x988b5f131335135f),
  W64LIT(0x7d519c2c2c742c9c), W64LIT(0xd605b8d3d368d3b8),
  W64LIT(0x6b8c5ce7e734e75c), W64LIT(0x5739cb6e6eb26ecb),
  W64LIT(0x6eaaf3c4c451c4f3), W64LIT(0x181b0f030305030f),
  W64LIT(0x8adc135656fa5613), W64LIT(0x1a5e494444cc4449),
  W64LIT(0xdfa09e7f7f817f9e), W64LIT(0x218837a9a9e6a937),
  W64LIT(0x4d67822a2a7e2a82), W64LIT(0xb10a6dbbbbd0bb6d),
  W64LIT(0x4687e2c1c15ec1e2), W64LIT(0xa2f1025353f55302),
  W64LIT(0xae728bdcdc79dc8b), W64LIT(0x5853270b0b1d0b27),
  W64LIT(0x9c01d39d9dba9dd3), W64LIT(0x472bc16c6cb46cc1),
  W64LIT(0x95a4f531315331f5), W64LIT(0x87f3b974749c74b9),
  W64LIT(0xe31509f6f607f609), W64LIT(0x0a4c434646ca4643),
  W64LIT(0x09a526acace9ac26), W64LIT(0x3cb5978989868997),
  W64LIT(0xa0b44414143c1444), W64LIT(0x5bba42e1e13ee142),
  W64LIT(0xb0a64e16163a164e), W64LIT(0xcdf7d23a3a4e3ad2),
  W64LIT(0x6f06d06969bb69d0), W64LIT(0x48412d09091b092d),
  W64LIT(0xa7d7ad70709070ad), W64LIT(0xd96f54b6b6c7b654),
  W64LIT(0xce1eb7d0d06dd0b7), W64LIT(0x3bd67eeded2aed7e),
  W64LIT(0x2ee2dbcccc49ccdb), W64LIT(0x2a68574242c64257),
  W64LIT(0xb42cc29898b598c2), W64LIT(0x49ed0ea4a4f1a40e),
  W64LIT(0x5d75882828782888), W64LIT(0xda86315c5ce45c31),
  W64LIT(0x936b3ff8f815f83f), W64LIT(0x44c2a486869786a4),
};

static const word64 Whirlpool_rc[] =
{
  W64LIT(0x1823c6e887b8014f),
  W64LIT(0x36a6d2f5796f9152),
  W64LIT(0x60bc9b8ea30c7b35),
  W64LIT(0x1de0d7c22e4bfe57),
  W64LIT(0x157737e59ff04ada),
  W64LIT(0x58c9290ab1a06b85),
  W64LIT(0xbd5d10f4cb3e0567),
  W64LIT(0xe427418ba77d95d8),
  W64LIT(0xfbee7c66dd17479e),
  W64LIT(0xca2dbf07ad5a8333)
};
//-----------------
static const uint32 WAKE_tt[8] =
{
  0x726a8f3bL,
  0xe69a3b5cL,
  0xd3c71fe5L,
  0xab3c73d2L,
  0x4d3a8eb3L,
  0x0396d6e8L,
  0x3d4c2f7aL,
  0x9ee27cf3L,
};
//-----------------
static const word64 Tiger_table[4*256] =
{
  W64LIT(0x02AAB17CF7E90C5E)   /*    0 */,    W64LIT(0xAC424B03E243A8EC)   /*    1 */,
  W64LIT(0x72CD5BE30DD5FCD3)   /*    2 */,    W64LIT(0x6D019B93F6F97F3A)   /*    3 */,
  W64LIT(0xCD9978FFD21F9193)   /*    4 */,    W64LIT(0x7573A1C9708029E2)   /*    5 */,
  W64LIT(0xB164326B922A83C3)   /*    6 */,    W64LIT(0x46883EEE04915870)   /*    7 */,
  W64LIT(0xEAACE3057103ECE6)   /*    8 */,    W64LIT(0xC54169B808A3535C)   /*    9 */,
  W64LIT(0x4CE754918DDEC47C)   /*   10 */,    W64LIT(0x0AA2F4DFDC0DF40C)   /*   11 */,
  W64LIT(0x10B76F18A74DBEFA)   /*   12 */,    W64LIT(0xC6CCB6235AD1AB6A)   /*   13 */,
  W64LIT(0x13726121572FE2FF)   /*   14 */,    W64LIT(0x1A488C6F199D921E)   /*   15 */,
  W64LIT(0x4BC9F9F4DA0007CA)   /*   16 */,    W64LIT(0x26F5E6F6E85241C7)   /*   17 */,
  W64LIT(0x859079DBEA5947B6)   /*   18 */,    W64LIT(0x4F1885C5C99E8C92)   /*   19 */,
  W64LIT(0xD78E761EA96F864B)   /*   20 */,    W64LIT(0x8E36428C52B5C17D)   /*   21 */,
  W64LIT(0x69CF6827373063C1)   /*   22 */,    W64LIT(0xB607C93D9BB4C56E)   /*   23 */,
  W64LIT(0x7D820E760E76B5EA)   /*   24 */,    W64LIT(0x645C9CC6F07FDC42)   /*   25 */,
  W64LIT(0xBF38A078243342E0)   /*   26 */,    W64LIT(0x5F6B343C9D2E7D04)   /*   27 */,
  W64LIT(0xF2C28AEB600B0EC6)   /*   28 */,    W64LIT(0x6C0ED85F7254BCAC)   /*   29 */,
  W64LIT(0x71592281A4DB4FE5)   /*   30 */,    W64LIT(0x1967FA69CE0FED9F)   /*   31 */,
  W64LIT(0xFD5293F8B96545DB)   /*   32 */,    W64LIT(0xC879E9D7F2A7600B)   /*   33 */,
  W64LIT(0x860248920193194E)   /*   34 */,    W64LIT(0xA4F9533B2D9CC0B3)   /*   35 */,
  W64LIT(0x9053836C15957613)   /*   36 */,    W64LIT(0xDB6DCF8AFC357BF1)   /*   37 */,
  W64LIT(0x18BEEA7A7A370F57)   /*   38 */,    W64LIT(0x037117CA50B99066)   /*   39 */,
  W64LIT(0x6AB30A9774424A35)   /*   40 */,    W64LIT(0xF4E92F02E325249B)   /*   41 */,
  W64LIT(0x7739DB07061CCAE1)   /*   42 */,    W64LIT(0xD8F3B49CECA42A05)   /*   43 */,
  W64LIT(0xBD56BE3F51382F73)   /*   44 */,    W64LIT(0x45FAED5843B0BB28)   /*   45 */,
  W64LIT(0x1C813D5C11BF1F83)   /*   46 */,    W64LIT(0x8AF0E4B6D75FA169)   /*   47 */,
  W64LIT(0x33EE18A487AD9999)   /*   48 */,    W64LIT(0x3C26E8EAB1C94410)   /*   49 */,
  W64LIT(0xB510102BC0A822F9)   /*   50 */,    W64LIT(0x141EEF310CE6123B)   /*   51 */,
  W64LIT(0xFC65B90059DDB154)   /*   52 */,    W64LIT(0xE0158640C5E0E607)   /*   53 */,
  W64LIT(0x884E079826C3A3CF)   /*   54 */,    W64LIT(0x930D0D9523C535FD)   /*   55 */,
  W64LIT(0x35638D754E9A2B00)   /*   56 */,    W64LIT(0x4085FCCF40469DD5)   /*   57 */,
  W64LIT(0xC4B17AD28BE23A4C)   /*   58 */,    W64LIT(0xCAB2F0FC6A3E6A2E)   /*   59 */,
  W64LIT(0x2860971A6B943FCD)   /*   60 */,    W64LIT(0x3DDE6EE212E30446)   /*   61 */,
  W64LIT(0x6222F32AE01765AE)   /*   62 */,    W64LIT(0x5D550BB5478308FE)   /*   63 */,
  W64LIT(0xA9EFA98DA0EDA22A)   /*   64 */,    W64LIT(0xC351A71686C40DA7)   /*   65 */,
  W64LIT(0x1105586D9C867C84)   /*   66 */,    W64LIT(0xDCFFEE85FDA22853)   /*   67 */,
  W64LIT(0xCCFBD0262C5EEF76)   /*   68 */,    W64LIT(0xBAF294CB8990D201)   /*   69 */,
  W64LIT(0xE69464F52AFAD975)   /*   70 */,    W64LIT(0x94B013AFDF133E14)   /*   71 */,
  W64LIT(0x06A7D1A32823C958)   /*   72 */,    W64LIT(0x6F95FE5130F61119)   /*   73 */,
  W64LIT(0xD92AB34E462C06C0)   /*   74 */,    W64LIT(0xED7BDE33887C71D2)   /*   75 */,
  W64LIT(0x79746D6E6518393E)   /*   76 */,    W64LIT(0x5BA419385D713329)   /*   77 */,
  W64LIT(0x7C1BA6B948A97564)   /*   78 */,    W64LIT(0x31987C197BFDAC67)   /*   79 */,
  W64LIT(0xDE6C23C44B053D02)   /*   80 */,    W64LIT(0x581C49FED002D64D)   /*   81 */,
  W64LIT(0xDD474D6338261571)   /*   82 */,    W64LIT(0xAA4546C3E473D062)   /*   83 */,
  W64LIT(0x928FCE349455F860)   /*   84 */,    W64LIT(0x48161BBACAAB94D9)   /*   85 */,
  W64LIT(0x63912430770E6F68)   /*   86 */,    W64LIT(0x6EC8A5E602C6641C)   /*   87 */,
  W64LIT(0x87282515337DDD2B)   /*   88 */,    W64LIT(0x2CDA6B42034B701B)   /*   89 */,
  W64LIT(0xB03D37C181CB096D)   /*   90 */,    W64LIT(0xE108438266C71C6F)   /*   91 */,
  W64LIT(0x2B3180C7EB51B255)   /*   92 */,    W64LIT(0xDF92B82F96C08BBC)   /*   93 */,
  W64LIT(0x5C68C8C0A632F3BA)   /*   94 */,    W64LIT(0x5504CC861C3D0556)   /*   95 */,
  W64LIT(0xABBFA4E55FB26B8F)   /*   96 */,    W64LIT(0x41848B0AB3BACEB4)   /*   97 */,
  W64LIT(0xB334A273AA445D32)   /*   98 */,    W64LIT(0xBCA696F0A85AD881)   /*   99 */,
  W64LIT(0x24F6EC65B528D56C)   /*  100 */,    W64LIT(0x0CE1512E90F4524A)   /*  101 */,
  W64LIT(0x4E9DD79D5506D35A)   /*  102 */,    W64LIT(0x258905FAC6CE9779)   /*  103 */,
  W64LIT(0x2019295B3E109B33)   /*  104 */,    W64LIT(0xF8A9478B73A054CC)   /*  105 */,
  W64LIT(0x2924F2F934417EB0)   /*  106 */,    W64LIT(0x3993357D536D1BC4)   /*  107 */,
  W64LIT(0x38A81AC21DB6FF8B)   /*  108 */,    W64LIT(0x47C4FBF17D6016BF)   /*  109 */,
  W64LIT(0x1E0FAADD7667E3F5)   /*  110 */,    W64LIT(0x7ABCFF62938BEB96)   /*  111 */,
  W64LIT(0xA78DAD948FC179C9)   /*  112 */,    W64LIT(0x8F1F98B72911E50D)   /*  113 */,
  W64LIT(0x61E48EAE27121A91)   /*  114 */,    W64LIT(0x4D62F7AD31859808)   /*  115 */,
  W64LIT(0xECEBA345EF5CEAEB)   /*  116 */,    W64LIT(0xF5CEB25EBC9684CE)   /*  117 */,
  W64LIT(0xF633E20CB7F76221)   /*  118 */,    W64LIT(0xA32CDF06AB8293E4)   /*  119 */,
  W64LIT(0x985A202CA5EE2CA4)   /*  120 */,    W64LIT(0xCF0B8447CC8A8FB1)   /*  121 */,
  W64LIT(0x9F765244979859A3)   /*  122 */,    W64LIT(0xA8D516B1A1240017)   /*  123 */,
  W64LIT(0x0BD7BA3EBB5DC726)   /*  124 */,    W64LIT(0xE54BCA55B86ADB39)   /*  125 */,
  W64LIT(0x1D7A3AFD6C478063)   /*  126 */,    W64LIT(0x519EC608E7669EDD)   /*  127 */,
  W64LIT(0x0E5715A2D149AA23)   /*  128 */,    W64LIT(0x177D4571848FF194)   /*  129 */,
  W64LIT(0xEEB55F3241014C22)   /*  130 */,    W64LIT(0x0F5E5CA13A6E2EC2)   /*  131 */,
  W64LIT(0x8029927B75F5C361)   /*  132 */,    W64LIT(0xAD139FABC3D6E436)   /*  133 */,
  W64LIT(0x0D5DF1A94CCF402F)   /*  134 */,    W64LIT(0x3E8BD948BEA5DFC8)   /*  135 */,
  W64LIT(0xA5A0D357BD3FF77E)   /*  136 */,    W64LIT(0xA2D12E251F74F645)   /*  137 */,
  W64LIT(0x66FD9E525E81A082)   /*  138 */,    W64LIT(0x2E0C90CE7F687A49)   /*  139 */,
  W64LIT(0xC2E8BCBEBA973BC5)   /*  140 */,    W64LIT(0x000001BCE509745F)   /*  141 */,
  W64LIT(0x423777BBE6DAB3D6)   /*  142 */,    W64LIT(0xD1661C7EAEF06EB5)   /*  143 */,
  W64LIT(0xA1781F354DAACFD8)   /*  144 */,    W64LIT(0x2D11284A2B16AFFC)   /*  145 */,
  W64LIT(0xF1FC4F67FA891D1F)   /*  146 */,    W64LIT(0x73ECC25DCB920ADA)   /*  147 */,
  W64LIT(0xAE610C22C2A12651)   /*  148 */,    W64LIT(0x96E0A810D356B78A)   /*  149 */,
  W64LIT(0x5A9A381F2FE7870F)   /*  150 */,    W64LIT(0xD5AD62EDE94E5530)   /*  151 */,
  W64LIT(0xD225E5E8368D1427)   /*  152 */,    W64LIT(0x65977B70C7AF4631)   /*  153 */,
  W64LIT(0x99F889B2DE39D74F)   /*  154 */,    W64LIT(0x233F30BF54E1D143)   /*  155 */,
  W64LIT(0x9A9675D3D9A63C97)   /*  156 */,    W64LIT(0x5470554FF334F9A8)   /*  157 */,
  W64LIT(0x166ACB744A4F5688)   /*  158 */,    W64LIT(0x70C74CAAB2E4AEAD)   /*  159 */,
  W64LIT(0xF0D091646F294D12)   /*  160 */,    W64LIT(0x57B82A89684031D1)   /*  161 */,
  W64LIT(0xEFD95A5A61BE0B6B)   /*  162 */,    W64LIT(0x2FBD12E969F2F29A)   /*  163 */,
  W64LIT(0x9BD37013FEFF9FE8)   /*  164 */,    W64LIT(0x3F9B0404D6085A06)   /*  165 */,
  W64LIT(0x4940C1F3166CFE15)   /*  166 */,    W64LIT(0x09542C4DCDF3DEFB)   /*  167 */,
  W64LIT(0xB4C5218385CD5CE3)   /*  168 */,    W64LIT(0xC935B7DC4462A641)   /*  169 */,
  W64LIT(0x3417F8A68ED3B63F)   /*  170 */,    W64LIT(0xB80959295B215B40)   /*  171 */,
  W64LIT(0xF99CDAEF3B8C8572)   /*  172 */,    W64LIT(0x018C0614F8FCB95D)   /*  173 */,
  W64LIT(0x1B14ACCD1A3ACDF3)   /*  174 */,    W64LIT(0x84D471F200BB732D)   /*  175 */,
  W64LIT(0xC1A3110E95E8DA16)   /*  176 */,    W64LIT(0x430A7220BF1A82B8)   /*  177 */,
  W64LIT(0xB77E090D39DF210E)   /*  178 */,    W64LIT(0x5EF4BD9F3CD05E9D)   /*  179 */,
  W64LIT(0x9D4FF6DA7E57A444)   /*  180 */,    W64LIT(0xDA1D60E183D4A5F8)   /*  181 */,
  W64LIT(0xB287C38417998E47)   /*  182 */,    W64LIT(0xFE3EDC121BB31886)   /*  183 */,
  W64LIT(0xC7FE3CCC980CCBEF)   /*  184 */,    W64LIT(0xE46FB590189BFD03)   /*  185 */,
  W64LIT(0x3732FD469A4C57DC)   /*  186 */,    W64LIT(0x7EF700A07CF1AD65)   /*  187 */,
  W64LIT(0x59C64468A31D8859)   /*  188 */,    W64LIT(0x762FB0B4D45B61F6)   /*  189 */,
  W64LIT(0x155BAED099047718)   /*  190 */,    W64LIT(0x68755E4C3D50BAA6)   /*  191 */,
  W64LIT(0xE9214E7F22D8B4DF)   /*  192 */,    W64LIT(0x2ADDBF532EAC95F4)   /*  193 */,
  W64LIT(0x32AE3909B4BD0109)   /*  194 */,    W64LIT(0x834DF537B08E3450)   /*  195 */,
  W64LIT(0xFA209DA84220728D)   /*  196 */,    W64LIT(0x9E691D9B9EFE23F7)   /*  197 */,
  W64LIT(0x0446D288C4AE8D7F)   /*  198 */,    W64LIT(0x7B4CC524E169785B)   /*  199 */,
  W64LIT(0x21D87F0135CA1385)   /*  200 */,    W64LIT(0xCEBB400F137B8AA5)   /*  201 */,
  W64LIT(0x272E2B66580796BE)   /*  202 */,    W64LIT(0x3612264125C2B0DE)   /*  203 */,
  W64LIT(0x057702BDAD1EFBB2)   /*  204 */,    W64LIT(0xD4BABB8EACF84BE9)   /*  205 */,
  W64LIT(0x91583139641BC67B)   /*  206 */,    W64LIT(0x8BDC2DE08036E024)   /*  207 */,
  W64LIT(0x603C8156F49F68ED)   /*  208 */,    W64LIT(0xF7D236F7DBEF5111)   /*  209 */,
  W64LIT(0x9727C4598AD21E80)   /*  210 */,    W64LIT(0xA08A0896670A5FD7)   /*  211 */,
  W64LIT(0xCB4A8F4309EBA9CB)   /*  212 */,    W64LIT(0x81AF564B0F7036A1)   /*  213 */,
  W64LIT(0xC0B99AA778199ABD)   /*  214 */,    W64LIT(0x959F1EC83FC8E952)   /*  215 */,
  W64LIT(0x8C505077794A81B9)   /*  216 */,    W64LIT(0x3ACAAF8F056338F0)   /*  217 */,
  W64LIT(0x07B43F50627A6778)   /*  218 */,    W64LIT(0x4A44AB49F5ECCC77)   /*  219 */,
  W64LIT(0x3BC3D6E4B679EE98)   /*  220 */,    W64LIT(0x9CC0D4D1CF14108C)   /*  221 */,
  W64LIT(0x4406C00B206BC8A0)   /*  222 */,    W64LIT(0x82A18854C8D72D89)   /*  223 */,
  W64LIT(0x67E366B35C3C432C)   /*  224 */,    W64LIT(0xB923DD61102B37F2)   /*  225 */,
  W64LIT(0x56AB2779D884271D)   /*  226 */,    W64LIT(0xBE83E1B0FF1525AF)   /*  227 */,
  W64LIT(0xFB7C65D4217E49A9)   /*  228 */,    W64LIT(0x6BDBE0E76D48E7D4)   /*  229 */,
  W64LIT(0x08DF828745D9179E)   /*  230 */,    W64LIT(0x22EA6A9ADD53BD34)   /*  231 */,
  W64LIT(0xE36E141C5622200A)   /*  232 */,    W64LIT(0x7F805D1B8CB750EE)   /*  233 */,
  W64LIT(0xAFE5C7A59F58E837)   /*  234 */,    W64LIT(0xE27F996A4FB1C23C)   /*  235 */,
  W64LIT(0xD3867DFB0775F0D0)   /*  236 */,    W64LIT(0xD0E673DE6E88891A)   /*  237 */,
  W64LIT(0x123AEB9EAFB86C25)   /*  238 */,    W64LIT(0x30F1D5D5C145B895)   /*  239 */,
  W64LIT(0xBB434A2DEE7269E7)   /*  240 */,    W64LIT(0x78CB67ECF931FA38)   /*  241 */,
  W64LIT(0xF33B0372323BBF9C)   /*  242 */,    W64LIT(0x52D66336FB279C74)   /*  243 */,
  W64LIT(0x505F33AC0AFB4EAA)   /*  244 */,    W64LIT(0xE8A5CD99A2CCE187)   /*  245 */,
  W64LIT(0x534974801E2D30BB)   /*  246 */,    W64LIT(0x8D2D5711D5876D90)   /*  247 */,
  W64LIT(0x1F1A412891BC038E)   /*  248 */,    W64LIT(0xD6E2E71D82E56648)   /*  249 */,
  W64LIT(0x74036C3A497732B7)   /*  250 */,    W64LIT(0x89B67ED96361F5AB)   /*  251 */,
  W64LIT(0xFFED95D8F1EA02A2)   /*  252 */,    W64LIT(0xE72B3BD61464D43D)   /*  253 */,
  W64LIT(0xA6300F170BDC4820)   /*  254 */,    W64LIT(0xEBC18760ED78A77A)   /*  255 */,
  W64LIT(0xE6A6BE5A05A12138)   /*  256 */,    W64LIT(0xB5A122A5B4F87C98)   /*  257 */,
  W64LIT(0x563C6089140B6990)   /*  258 */,    W64LIT(0x4C46CB2E391F5DD5)   /*  259 */,
  W64LIT(0xD932ADDBC9B79434)   /*  260 */,    W64LIT(0x08EA70E42015AFF5)   /*  261 */,
  W64LIT(0xD765A6673E478CF1)   /*  262 */,    W64LIT(0xC4FB757EAB278D99)   /*  263 */,
  W64LIT(0xDF11C6862D6E0692)   /*  264 */,    W64LIT(0xDDEB84F10D7F3B16)   /*  265 */,
  W64LIT(0x6F2EF604A665EA04)   /*  266 */,    W64LIT(0x4A8E0F0FF0E0DFB3)   /*  267 */,
  W64LIT(0xA5EDEEF83DBCBA51)   /*  268 */,    W64LIT(0xFC4F0A2A0EA4371E)   /*  269 */,
  W64LIT(0xE83E1DA85CB38429)   /*  270 */,    W64LIT(0xDC8FF882BA1B1CE2)   /*  271 */,
  W64LIT(0xCD45505E8353E80D)   /*  272 */,    W64LIT(0x18D19A00D4DB0717)   /*  273 */,
  W64LIT(0x34A0CFEDA5F38101)   /*  274 */,    W64LIT(0x0BE77E518887CAF2)   /*  275 */,
  W64LIT(0x1E341438B3C45136)   /*  276 */,    W64LIT(0xE05797F49089CCF9)   /*  277 */,
  W64LIT(0xFFD23F9DF2591D14)   /*  278 */,    W64LIT(0x543DDA228595C5CD)   /*  279 */,
  W64LIT(0x661F81FD99052A33)   /*  280 */,    W64LIT(0x8736E641DB0F7B76)   /*  281 */,
  W64LIT(0x15227725418E5307)   /*  282 */,    W64LIT(0xE25F7F46162EB2FA)   /*  283 */,
  W64LIT(0x48A8B2126C13D9FE)   /*  284 */,    W64LIT(0xAFDC541792E76EEA)   /*  285 */,
  W64LIT(0x03D912BFC6D1898F)   /*  286 */,    W64LIT(0x31B1AAFA1B83F51B)   /*  287 */,
  W64LIT(0xF1AC2796E42AB7D9)   /*  288 */,    W64LIT(0x40A3A7D7FCD2EBAC)   /*  289 */,
  W64LIT(0x1056136D0AFBBCC5)   /*  290 */,    W64LIT(0x7889E1DD9A6D0C85)   /*  291 */,
  W64LIT(0xD33525782A7974AA)   /*  292 */,    W64LIT(0xA7E25D09078AC09B)   /*  293 */,
  W64LIT(0xBD4138B3EAC6EDD0)   /*  294 */,    W64LIT(0x920ABFBE71EB9E70)   /*  295 */,
  W64LIT(0xA2A5D0F54FC2625C)   /*  296 */,    W64LIT(0xC054E36B0B1290A3)   /*  297 */,
  W64LIT(0xF6DD59FF62FE932B)   /*  298 */,    W64LIT(0x3537354511A8AC7D)   /*  299 */,
  W64LIT(0xCA845E9172FADCD4)   /*  300 */,    W64LIT(0x84F82B60329D20DC)   /*  301 */,
  W64LIT(0x79C62CE1CD672F18)   /*  302 */,    W64LIT(0x8B09A2ADD124642C)   /*  303 */,
  W64LIT(0xD0C1E96A19D9E726)   /*  304 */,    W64LIT(0x5A786A9B4BA9500C)   /*  305 */,
  W64LIT(0x0E020336634C43F3)   /*  306 */,    W64LIT(0xC17B474AEB66D822)   /*  307 */,
  W64LIT(0x6A731AE3EC9BAAC2)   /*  308 */,    W64LIT(0x8226667AE0840258)   /*  309 */,
  W64LIT(0x67D4567691CAECA5)   /*  310 */,    W64LIT(0x1D94155C4875ADB5)   /*  311 */,
  W64LIT(0x6D00FD985B813FDF)   /*  312 */,    W64LIT(0x51286EFCB774CD06)   /*  313 */,
  W64LIT(0x5E8834471FA744AF)   /*  314 */,    W64LIT(0xF72CA0AEE761AE2E)   /*  315 */,
  W64LIT(0xBE40E4CDAEE8E09A)   /*  316 */,    W64LIT(0xE9970BBB5118F665)   /*  317 */,
  W64LIT(0x726E4BEB33DF1964)   /*  318 */,    W64LIT(0x703B000729199762)   /*  319 */,
  W64LIT(0x4631D816F5EF30A7)   /*  320 */,    W64LIT(0xB880B5B51504A6BE)   /*  321 */,
  W64LIT(0x641793C37ED84B6C)   /*  322 */,    W64LIT(0x7B21ED77F6E97D96)   /*  323 */,
  W64LIT(0x776306312EF96B73)   /*  324 */,    W64LIT(0xAE528948E86FF3F4)   /*  325 */,
  W64LIT(0x53DBD7F286A3F8F8)   /*  326 */,    W64LIT(0x16CADCE74CFC1063)   /*  327 */,
  W64LIT(0x005C19BDFA52C6DD)   /*  328 */,    W64LIT(0x68868F5D64D46AD3)   /*  329 */,
  W64LIT(0x3A9D512CCF1E186A)   /*  330 */,    W64LIT(0x367E62C2385660AE)   /*  331 */,
  W64LIT(0xE359E7EA77DCB1D7)   /*  332 */,    W64LIT(0x526C0773749ABE6E)   /*  333 */,
  W64LIT(0x735AE5F9D09F734B)   /*  334 */,    W64LIT(0x493FC7CC8A558BA8)   /*  335 */,
  W64LIT(0xB0B9C1533041AB45)   /*  336 */,    W64LIT(0x321958BA470A59BD)   /*  337 */,
  W64LIT(0x852DB00B5F46C393)   /*  338 */,    W64LIT(0x91209B2BD336B0E5)   /*  339 */,
  W64LIT(0x6E604F7D659EF19F)   /*  340 */,    W64LIT(0xB99A8AE2782CCB24)   /*  341 */,
  W64LIT(0xCCF52AB6C814C4C7)   /*  342 */,    W64LIT(0x4727D9AFBE11727B)   /*  343 */,
  W64LIT(0x7E950D0C0121B34D)   /*  344 */,    W64LIT(0x756F435670AD471F)   /*  345 */,
  W64LIT(0xF5ADD442615A6849)   /*  346 */,    W64LIT(0x4E87E09980B9957A)   /*  347 */,
  W64LIT(0x2ACFA1DF50AEE355)   /*  348 */,    W64LIT(0xD898263AFD2FD556)   /*  349 */,
  W64LIT(0xC8F4924DD80C8FD6)   /*  350 */,    W64LIT(0xCF99CA3D754A173A)   /*  351 */,
  W64LIT(0xFE477BACAF91BF3C)   /*  352 */,    W64LIT(0xED5371F6D690C12D)   /*  353 */,
  W64LIT(0x831A5C285E687094)   /*  354 */,    W64LIT(0xC5D3C90A3708A0A4)   /*  355 */,
  W64LIT(0x0F7F903717D06580)   /*  356 */,    W64LIT(0x19F9BB13B8FDF27F)   /*  357 */,
  W64LIT(0xB1BD6F1B4D502843)   /*  358 */,    W64LIT(0x1C761BA38FFF4012)   /*  359 */,
  W64LIT(0x0D1530C4E2E21F3B)   /*  360 */,    W64LIT(0x8943CE69A7372C8A)   /*  361 */,
  W64LIT(0xE5184E11FEB5CE66)   /*  362 */,    W64LIT(0x618BDB80BD736621)   /*  363 */,
  W64LIT(0x7D29BAD68B574D0B)   /*  364 */,    W64LIT(0x81BB613E25E6FE5B)   /*  365 */,
  W64LIT(0x071C9C10BC07913F)   /*  366 */,    W64LIT(0xC7BEEB7909AC2D97)   /*  367 */,
  W64LIT(0xC3E58D353BC5D757)   /*  368 */,    W64LIT(0xEB017892F38F61E8)   /*  369 */,
  W64LIT(0xD4EFFB9C9B1CC21A)   /*  370 */,    W64LIT(0x99727D26F494F7AB)   /*  371 */,
  W64LIT(0xA3E063A2956B3E03)   /*  372 */,    W64LIT(0x9D4A8B9A4AA09C30)   /*  373 */,
  W64LIT(0x3F6AB7D500090FB4)   /*  374 */,    W64LIT(0x9CC0F2A057268AC0)   /*  375 */,
  W64LIT(0x3DEE9D2DEDBF42D1)   /*  376 */,    W64LIT(0x330F49C87960A972)   /*  377 */,
  W64LIT(0xC6B2720287421B41)   /*  378 */,    W64LIT(0x0AC59EC07C00369C)   /*  379 */,
  W64LIT(0xEF4EAC49CB353425)   /*  380 */,    W64LIT(0xF450244EEF0129D8)   /*  381 */,
  W64LIT(0x8ACC46E5CAF4DEB6)   /*  382 */,    W64LIT(0x2FFEAB63989263F7)   /*  383 */,
  W64LIT(0x8F7CB9FE5D7A4578)   /*  384 */,    W64LIT(0x5BD8F7644E634635)   /*  385 */,
  W64LIT(0x427A7315BF2DC900)   /*  386 */,    W64LIT(0x17D0C4AA2125261C)   /*  387 */,
  W64LIT(0x3992486C93518E50)   /*  388 */,    W64LIT(0xB4CBFEE0A2D7D4C3)   /*  389 */,
  W64LIT(0x7C75D6202C5DDD8D)   /*  390 */,    W64LIT(0xDBC295D8E35B6C61)   /*  391 */,
  W64LIT(0x60B369D302032B19)   /*  392 */,    W64LIT(0xCE42685FDCE44132)   /*  393 */,
  W64LIT(0x06F3DDB9DDF65610)   /*  394 */,    W64LIT(0x8EA4D21DB5E148F0)   /*  395 */,
  W64LIT(0x20B0FCE62FCD496F)   /*  396 */,    W64LIT(0x2C1B912358B0EE31)   /*  397 */,
  W64LIT(0xB28317B818F5A308)   /*  398 */,    W64LIT(0xA89C1E189CA6D2CF)   /*  399 */,
  W64LIT(0x0C6B18576AAADBC8)   /*  400 */,    W64LIT(0xB65DEAA91299FAE3)   /*  401 */,
  W64LIT(0xFB2B794B7F1027E7)   /*  402 */,    W64LIT(0x04E4317F443B5BEB)   /*  403 */,
  W64LIT(0x4B852D325939D0A6)   /*  404 */,    W64LIT(0xD5AE6BEEFB207FFC)   /*  405 */,
  W64LIT(0x309682B281C7D374)   /*  406 */,    W64LIT(0xBAE309A194C3B475)   /*  407 */,
  W64LIT(0x8CC3F97B13B49F05)   /*  408 */,    W64LIT(0x98A9422FF8293967)   /*  409 */,
  W64LIT(0x244B16B01076FF7C)   /*  410 */,    W64LIT(0xF8BF571C663D67EE)   /*  411 */,
  W64LIT(0x1F0D6758EEE30DA1)   /*  412 */,    W64LIT(0xC9B611D97ADEB9B7)   /*  413 */,
  W64LIT(0xB7AFD5887B6C57A2)   /*  414 */,    W64LIT(0x6290AE846B984FE1)   /*  415 */,
  W64LIT(0x94DF4CDEACC1A5FD)   /*  416 */,    W64LIT(0x058A5BD1C5483AFF)   /*  417 */,
  W64LIT(0x63166CC142BA3C37)   /*  418 */,    W64LIT(0x8DB8526EB2F76F40)   /*  419 */,
  W64LIT(0xE10880036F0D6D4E)   /*  420 */,    W64LIT(0x9E0523C9971D311D)   /*  421 */,
  W64LIT(0x45EC2824CC7CD691)   /*  422 */,    W64LIT(0x575B8359E62382C9)   /*  423 */,
  W64LIT(0xFA9E400DC4889995)   /*  424 */,    W64LIT(0xD1823ECB45721568)   /*  425 */,
  W64LIT(0xDAFD983B8206082F)   /*  426 */,    W64LIT(0xAA7D29082386A8CB)   /*  427 */,
  W64LIT(0x269FCD4403B87588)   /*  428 */,    W64LIT(0x1B91F5F728BDD1E0)   /*  429 */,
  W64LIT(0xE4669F39040201F6)   /*  430 */,    W64LIT(0x7A1D7C218CF04ADE)   /*  431 */,
  W64LIT(0x65623C29D79CE5CE)   /*  432 */,    W64LIT(0x2368449096C00BB1)   /*  433 */,
  W64LIT(0xAB9BF1879DA503BA)   /*  434 */,    W64LIT(0xBC23ECB1A458058E)   /*  435 */,
  W64LIT(0x9A58DF01BB401ECC)   /*  436 */,    W64LIT(0xA070E868A85F143D)   /*  437 */,
  W64LIT(0x4FF188307DF2239E)   /*  438 */,    W64LIT(0x14D565B41A641183)   /*  439 */,
  W64LIT(0xEE13337452701602)   /*  440 */,    W64LIT(0x950E3DCF3F285E09)   /*  441 */,
  W64LIT(0x59930254B9C80953)   /*  442 */,    W64LIT(0x3BF299408930DA6D)   /*  443 */,
  W64LIT(0xA955943F53691387)   /*  444 */,    W64LIT(0xA15EDECAA9CB8784)   /*  445 */,
  W64LIT(0x29142127352BE9A0)   /*  446 */,    W64LIT(0x76F0371FFF4E7AFB)   /*  447 */,
  W64LIT(0x0239F450274F2228)   /*  448 */,    W64LIT(0xBB073AF01D5E868B)   /*  449 */,
  W64LIT(0xBFC80571C10E96C1)   /*  450 */,    W64LIT(0xD267088568222E23)   /*  451 */,
  W64LIT(0x9671A3D48E80B5B0)   /*  452 */,    W64LIT(0x55B5D38AE193BB81)   /*  453 */,
  W64LIT(0x693AE2D0A18B04B8)   /*  454 */,    W64LIT(0x5C48B4ECADD5335F)   /*  455 */,
  W64LIT(0xFD743B194916A1CA)   /*  456 */,    W64LIT(0x2577018134BE98C4)   /*  457 */,
  W64LIT(0xE77987E83C54A4AD)   /*  458 */,    W64LIT(0x28E11014DA33E1B9)   /*  459 */,
  W64LIT(0x270CC59E226AA213)   /*  460 */,    W64LIT(0x71495F756D1A5F60)   /*  461 */,
  W64LIT(0x9BE853FB60AFEF77)   /*  462 */,    W64LIT(0xADC786A7F7443DBF)   /*  463 */,
  W64LIT(0x0904456173B29A82)   /*  464 */,    W64LIT(0x58BC7A66C232BD5E)   /*  465 */,
  W64LIT(0xF306558C673AC8B2)   /*  466 */,    W64LIT(0x41F639C6B6C9772A)   /*  467 */,
  W64LIT(0x216DEFE99FDA35DA)   /*  468 */,    W64LIT(0x11640CC71C7BE615)   /*  469 */,
  W64LIT(0x93C43694565C5527)   /*  470 */,    W64LIT(0xEA038E6246777839)   /*  471 */,
  W64LIT(0xF9ABF3CE5A3E2469)   /*  472 */,    W64LIT(0x741E768D0FD312D2)   /*  473 */,
  W64LIT(0x0144B883CED652C6)   /*  474 */,    W64LIT(0xC20B5A5BA33F8552)   /*  475 */,
  W64LIT(0x1AE69633C3435A9D)   /*  476 */,    W64LIT(0x97A28CA4088CFDEC)   /*  477 */,
  W64LIT(0x8824A43C1E96F420)   /*  478 */,    W64LIT(0x37612FA66EEEA746)   /*  479 */,
  W64LIT(0x6B4CB165F9CF0E5A)   /*  480 */,    W64LIT(0x43AA1C06A0ABFB4A)   /*  481 */,
  W64LIT(0x7F4DC26FF162796B)   /*  482 */,    W64LIT(0x6CBACC8E54ED9B0F)   /*  483 */,
  W64LIT(0xA6B7FFEFD2BB253E)   /*  484 */,    W64LIT(0x2E25BC95B0A29D4F)   /*  485 */,
  W64LIT(0x86D6A58BDEF1388C)   /*  486 */,    W64LIT(0xDED74AC576B6F054)   /*  487 */,
  W64LIT(0x8030BDBC2B45805D)   /*  488 */,    W64LIT(0x3C81AF70E94D9289)   /*  489 */,
  W64LIT(0x3EFF6DDA9E3100DB)   /*  490 */,    W64LIT(0xB38DC39FDFCC8847)   /*  491 */,
  W64LIT(0x123885528D17B87E)   /*  492 */,    W64LIT(0xF2DA0ED240B1B642)   /*  493 */,
  W64LIT(0x44CEFADCD54BF9A9)   /*  494 */,    W64LIT(0x1312200E433C7EE6)   /*  495 */,
  W64LIT(0x9FFCC84F3A78C748)   /*  496 */,    W64LIT(0xF0CD1F72248576BB)   /*  497 */,
  W64LIT(0xEC6974053638CFE4)   /*  498 */,    W64LIT(0x2BA7B67C0CEC4E4C)   /*  499 */,
  W64LIT(0xAC2F4DF3E5CE32ED)   /*  500 */,    W64LIT(0xCB33D14326EA4C11)   /*  501 */,
  W64LIT(0xA4E9044CC77E58BC)   /*  502 */,    W64LIT(0x5F513293D934FCEF)   /*  503 */,
  W64LIT(0x5DC9645506E55444)   /*  504 */,    W64LIT(0x50DE418F317DE40A)   /*  505 */,
  W64LIT(0x388CB31A69DDE259)   /*  506 */,    W64LIT(0x2DB4A83455820A86)   /*  507 */,
  W64LIT(0x9010A91E84711AE9)   /*  508 */,    W64LIT(0x4DF7F0B7B1498371)   /*  509 */,
  W64LIT(0xD62A2EABC0977179)   /*  510 */,    W64LIT(0x22FAC097AA8D5C0E)   /*  511 */,
  W64LIT(0xF49FCC2FF1DAF39B)   /*  512 */,    W64LIT(0x487FD5C66FF29281)   /*  513 */,
  W64LIT(0xE8A30667FCDCA83F)   /*  514 */,    W64LIT(0x2C9B4BE3D2FCCE63)   /*  515 */,
  W64LIT(0xDA3FF74B93FBBBC2)   /*  516 */,    W64LIT(0x2FA165D2FE70BA66)   /*  517 */,
  W64LIT(0xA103E279970E93D4)   /*  518 */,    W64LIT(0xBECDEC77B0E45E71)   /*  519 */,
  W64LIT(0xCFB41E723985E497)   /*  520 */,    W64LIT(0xB70AAA025EF75017)   /*  521 */,
  W64LIT(0xD42309F03840B8E0)   /*  522 */,    W64LIT(0x8EFC1AD035898579)   /*  523 */,
  W64LIT(0x96C6920BE2B2ABC5)   /*  524 */,    W64LIT(0x66AF4163375A9172)   /*  525 */,
  W64LIT(0x2174ABDCCA7127FB)   /*  526 */,    W64LIT(0xB33CCEA64A72FF41)   /*  527 */,
  W64LIT(0xF04A4933083066A5)   /*  528 */,    W64LIT(0x8D970ACDD7289AF5)   /*  529 */,
  W64LIT(0x8F96E8E031C8C25E)   /*  530 */,    W64LIT(0xF3FEC02276875D47)   /*  531 */,
  W64LIT(0xEC7BF310056190DD)   /*  532 */,    W64LIT(0xF5ADB0AEBB0F1491)   /*  533 */,
  W64LIT(0x9B50F8850FD58892)   /*  534 */,    W64LIT(0x4975488358B74DE8)   /*  535 */,
  W64LIT(0xA3354FF691531C61)   /*  536 */,    W64LIT(0x0702BBE481D2C6EE)   /*  537 */,
  W64LIT(0x89FB24057DEDED98)   /*  538 */,    W64LIT(0xAC3075138596E902)   /*  539 */,
  W64LIT(0x1D2D3580172772ED)   /*  540 */,    W64LIT(0xEB738FC28E6BC30D)   /*  541 */,
  W64LIT(0x5854EF8F63044326)   /*  542 */,    W64LIT(0x9E5C52325ADD3BBE)   /*  543 */,
  W64LIT(0x90AA53CF325C4623)   /*  544 */,    W64LIT(0xC1D24D51349DD067)   /*  545 */,
  W64LIT(0x2051CFEEA69EA624)   /*  546 */,    W64LIT(0x13220F0A862E7E4F)   /*  547 */,
  W64LIT(0xCE39399404E04864)   /*  548 */,    W64LIT(0xD9C42CA47086FCB7)   /*  549 */,
  W64LIT(0x685AD2238A03E7CC)   /*  550 */,    W64LIT(0x066484B2AB2FF1DB)   /*  551 */,
  W64LIT(0xFE9D5D70EFBF79EC)   /*  552 */,    W64LIT(0x5B13B9DD9C481854)   /*  553 */,
  W64LIT(0x15F0D475ED1509AD)   /*  554 */,    W64LIT(0x0BEBCD060EC79851)   /*  555 */,
  W64LIT(0xD58C6791183AB7F8)   /*  556 */,    W64LIT(0xD1187C5052F3EEE4)   /*  557 */,
  W64LIT(0xC95D1192E54E82FF)   /*  558 */,    W64LIT(0x86EEA14CB9AC6CA2)   /*  559 */,
  W64LIT(0x3485BEB153677D5D)   /*  560 */,    W64LIT(0xDD191D781F8C492A)   /*  561 */,
  W64LIT(0xF60866BAA784EBF9)   /*  562 */,    W64LIT(0x518F643BA2D08C74)   /*  563 */,
  W64LIT(0x8852E956E1087C22)   /*  564 */,    W64LIT(0xA768CB8DC410AE8D)   /*  565 */,
  W64LIT(0x38047726BFEC8E1A)   /*  566 */,    W64LIT(0xA67738B4CD3B45AA)   /*  567 */,
  W64LIT(0xAD16691CEC0DDE19)   /*  568 */,    W64LIT(0xC6D4319380462E07)   /*  569 */,
  W64LIT(0xC5A5876D0BA61938)   /*  570 */,    W64LIT(0x16B9FA1FA58FD840)   /*  571 */,
  W64LIT(0x188AB1173CA74F18)   /*  572 */,    W64LIT(0xABDA2F98C99C021F)   /*  573 */,
  W64LIT(0x3E0580AB134AE816)   /*  574 */,    W64LIT(0x5F3B05B773645ABB)   /*  575 */,
  W64LIT(0x2501A2BE5575F2F6)   /*  576 */,    W64LIT(0x1B2F74004E7E8BA9)   /*  577 */,
  W64LIT(0x1CD7580371E8D953)   /*  578 */,    W64LIT(0x7F6ED89562764E30)   /*  579 */,
  W64LIT(0xB15926FF596F003D)   /*  580 */,    W64LIT(0x9F65293DA8C5D6B9)   /*  581 */,
  W64LIT(0x6ECEF04DD690F84C)   /*  582 */,    W64LIT(0x4782275FFF33AF88)   /*  583 */,
  W64LIT(0xE41433083F820801)   /*  584 */,    W64LIT(0xFD0DFE409A1AF9B5)   /*  585 */,
  W64LIT(0x4325A3342CDB396B)   /*  586 */,    W64LIT(0x8AE77E62B301B252)   /*  587 */,
  W64LIT(0xC36F9E9F6655615A)   /*  588 */,    W64LIT(0x85455A2D92D32C09)   /*  589 */,
  W64LIT(0xF2C7DEA949477485)   /*  590 */,    W64LIT(0x63CFB4C133A39EBA)   /*  591 */,
  W64LIT(0x83B040CC6EBC5462)   /*  592 */,    W64LIT(0x3B9454C8FDB326B0)   /*  593 */,
  W64LIT(0x56F56A9E87FFD78C)   /*  594 */,    W64LIT(0x2DC2940D99F42BC6)   /*  595 */,
  W64LIT(0x98F7DF096B096E2D)   /*  596 */,    W64LIT(0x19A6E01E3AD852BF)   /*  597 */,
  W64LIT(0x42A99CCBDBD4B40B)   /*  598 */,    W64LIT(0xA59998AF45E9C559)   /*  599 */,
  W64LIT(0x366295E807D93186)   /*  600 */,    W64LIT(0x6B48181BFAA1F773)   /*  601 */,
  W64LIT(0x1FEC57E2157A0A1D)   /*  602 */,    W64LIT(0x4667446AF6201AD5)   /*  603 */,
  W64LIT(0xE615EBCACFB0F075)   /*  604 */,    W64LIT(0xB8F31F4F68290778)   /*  605 */,
  W64LIT(0x22713ED6CE22D11E)   /*  606 */,    W64LIT(0x3057C1A72EC3C93B)   /*  607 */,
  W64LIT(0xCB46ACC37C3F1F2F)   /*  608 */,    W64LIT(0xDBB893FD02AAF50E)   /*  609 */,
  W64LIT(0x331FD92E600B9FCF)   /*  610 */,    W64LIT(0xA498F96148EA3AD6)   /*  611 */,
  W64LIT(0xA8D8426E8B6A83EA)   /*  612 */,    W64LIT(0xA089B274B7735CDC)   /*  613 */,
  W64LIT(0x87F6B3731E524A11)   /*  614 */,    W64LIT(0x118808E5CBC96749)   /*  615 */,
  W64LIT(0x9906E4C7B19BD394)   /*  616 */,    W64LIT(0xAFED7F7E9B24A20C)   /*  617 */,
  W64LIT(0x6509EADEEB3644A7)   /*  618 */,    W64LIT(0x6C1EF1D3E8EF0EDE)   /*  619 */,
  W64LIT(0xB9C97D43E9798FB4)   /*  620 */,    W64LIT(0xA2F2D784740C28A3)   /*  621 */,
  W64LIT(0x7B8496476197566F)   /*  622 */,    W64LIT(0x7A5BE3E6B65F069D)   /*  623 */,
  W64LIT(0xF96330ED78BE6F10)   /*  624 */,    W64LIT(0xEEE60DE77A076A15)   /*  625 */,
  W64LIT(0x2B4BEE4AA08B9BD0)   /*  626 */,    W64LIT(0x6A56A63EC7B8894E)   /*  627 */,
  W64LIT(0x02121359BA34FEF4)   /*  628 */,    W64LIT(0x4CBF99F8283703FC)   /*  629 */,
  W64LIT(0x398071350CAF30C8)   /*  630 */,    W64LIT(0xD0A77A89F017687A)   /*  631 */,
  W64LIT(0xF1C1A9EB9E423569)   /*  632 */,    W64LIT(0x8C7976282DEE8199)   /*  633 */,
  W64LIT(0x5D1737A5DD1F7ABD)   /*  634 */,    W64LIT(0x4F53433C09A9FA80)   /*  635 */,
  W64LIT(0xFA8B0C53DF7CA1D9)   /*  636 */,    W64LIT(0x3FD9DCBC886CCB77)   /*  637 */,
  W64LIT(0xC040917CA91B4720)   /*  638 */,    W64LIT(0x7DD00142F9D1DCDF)   /*  639 */,
  W64LIT(0x8476FC1D4F387B58)   /*  640 */,    W64LIT(0x23F8E7C5F3316503)   /*  641 */,
  W64LIT(0x032A2244E7E37339)   /*  642 */,    W64LIT(0x5C87A5D750F5A74B)   /*  643 */,
  W64LIT(0x082B4CC43698992E)   /*  644 */,    W64LIT(0xDF917BECB858F63C)   /*  645 */,
  W64LIT(0x3270B8FC5BF86DDA)   /*  646 */,    W64LIT(0x10AE72BB29B5DD76)   /*  647 */,
  W64LIT(0x576AC94E7700362B)   /*  648 */,    W64LIT(0x1AD112DAC61EFB8F)   /*  649 */,
  W64LIT(0x691BC30EC5FAA427)   /*  650 */,    W64LIT(0xFF246311CC327143)   /*  651 */,
  W64LIT(0x3142368E30E53206)   /*  652 */,    W64LIT(0x71380E31E02CA396)   /*  653 */,
  W64LIT(0x958D5C960AAD76F1)   /*  654 */,    W64LIT(0xF8D6F430C16DA536)   /*  655 */,
  W64LIT(0xC8FFD13F1BE7E1D2)   /*  656 */,    W64LIT(0x7578AE66004DDBE1)   /*  657 */,
  W64LIT(0x05833F01067BE646)   /*  658 */,    W64LIT(0xBB34B5AD3BFE586D)   /*  659 */,
  W64LIT(0x095F34C9A12B97F0)   /*  660 */,    W64LIT(0x247AB64525D60CA8)   /*  661 */,
  W64LIT(0xDCDBC6F3017477D1)   /*  662 */,    W64LIT(0x4A2E14D4DECAD24D)   /*  663 */,
  W64LIT(0xBDB5E6D9BE0A1EEB)   /*  664 */,    W64LIT(0x2A7E70F7794301AB)   /*  665 */,
  W64LIT(0xDEF42D8A270540FD)   /*  666 */,    W64LIT(0x01078EC0A34C22C1)   /*  667 */,
  W64LIT(0xE5DE511AF4C16387)   /*  668 */,    W64LIT(0x7EBB3A52BD9A330A)   /*  669 */,
  W64LIT(0x77697857AA7D6435)   /*  670 */,    W64LIT(0x004E831603AE4C32)   /*  671 */,
  W64LIT(0xE7A21020AD78E312)   /*  672 */,    W64LIT(0x9D41A70C6AB420F2)   /*  673 */,
  W64LIT(0x28E06C18EA1141E6)   /*  674 */,    W64LIT(0xD2B28CBD984F6B28)   /*  675 */,
  W64LIT(0x26B75F6C446E9D83)   /*  676 */,    W64LIT(0xBA47568C4D418D7F)   /*  677 */,
  W64LIT(0xD80BADBFE6183D8E)   /*  678 */,    W64LIT(0x0E206D7F5F166044)   /*  679 */,
  W64LIT(0xE258A43911CBCA3E)   /*  680 */,    W64LIT(0x723A1746B21DC0BC)   /*  681 */,
  W64LIT(0xC7CAA854F5D7CDD3)   /*  682 */,    W64LIT(0x7CAC32883D261D9C)   /*  683 */,
  W64LIT(0x7690C26423BA942C)   /*  684 */,    W64LIT(0x17E55524478042B8)   /*  685 */,
  W64LIT(0xE0BE477656A2389F)   /*  686 */,    W64LIT(0x4D289B5E67AB2DA0)   /*  687 */,
  W64LIT(0x44862B9C8FBBFD31)   /*  688 */,    W64LIT(0xB47CC8049D141365)   /*  689 */,
  W64LIT(0x822C1B362B91C793)   /*  690 */,    W64LIT(0x4EB14655FB13DFD8)   /*  691 */,
  W64LIT(0x1ECBBA0714E2A97B)   /*  692 */,    W64LIT(0x6143459D5CDE5F14)   /*  693 */,
  W64LIT(0x53A8FBF1D5F0AC89)   /*  694 */,    W64LIT(0x97EA04D81C5E5B00)   /*  695 */,
  W64LIT(0x622181A8D4FDB3F3)   /*  696 */,    W64LIT(0xE9BCD341572A1208)   /*  697 */,
  W64LIT(0x1411258643CCE58A)   /*  698 */,    W64LIT(0x9144C5FEA4C6E0A4)   /*  699 */,
  W64LIT(0x0D33D06565CF620F)   /*  700 */,    W64LIT(0x54A48D489F219CA1)   /*  701 */,
  W64LIT(0xC43E5EAC6D63C821)   /*  702 */,    W64LIT(0xA9728B3A72770DAF)   /*  703 */,
  W64LIT(0xD7934E7B20DF87EF)   /*  704 */,    W64LIT(0xE35503B61A3E86E5)   /*  705 */,
  W64LIT(0xCAE321FBC819D504)   /*  706 */,    W64LIT(0x129A50B3AC60BFA6)   /*  707 */,
  W64LIT(0xCD5E68EA7E9FB6C3)   /*  708 */,    W64LIT(0xB01C90199483B1C7)   /*  709 */,
  W64LIT(0x3DE93CD5C295376C)   /*  710 */,    W64LIT(0xAED52EDF2AB9AD13)   /*  711 */,
  W64LIT(0x2E60F512C0A07884)   /*  712 */,    W64LIT(0xBC3D86A3E36210C9)   /*  713 */,
  W64LIT(0x35269D9B163951CE)   /*  714 */,    W64LIT(0x0C7D6E2AD0CDB5FA)   /*  715 */,
  W64LIT(0x59E86297D87F5733)   /*  716 */,    W64LIT(0x298EF221898DB0E7)   /*  717 */,
  W64LIT(0x55000029D1A5AA7E)   /*  718 */,    W64LIT(0x8BC08AE1B5061B45)   /*  719 */,
  W64LIT(0xC2C31C2B6C92703A)   /*  720 */,    W64LIT(0x94CC596BAF25EF42)   /*  721 */,
  W64LIT(0x0A1D73DB22540456)   /*  722 */,    W64LIT(0x04B6A0F9D9C4179A)   /*  723 */,
  W64LIT(0xEFFDAFA2AE3D3C60)   /*  724 */,    W64LIT(0xF7C8075BB49496C4)   /*  725 */,
  W64LIT(0x9CC5C7141D1CD4E3)   /*  726 */,    W64LIT(0x78BD1638218E5534)   /*  727 */,
  W64LIT(0xB2F11568F850246A)   /*  728 */,    W64LIT(0xEDFABCFA9502BC29)   /*  729 */,
  W64LIT(0x796CE5F2DA23051B)   /*  730 */,    W64LIT(0xAAE128B0DC93537C)   /*  731 */,
  W64LIT(0x3A493DA0EE4B29AE)   /*  732 */,    W64LIT(0xB5DF6B2C416895D7)   /*  733 */,
  W64LIT(0xFCABBD25122D7F37)   /*  734 */,    W64LIT(0x70810B58105DC4B1)   /*  735 */,
  W64LIT(0xE10FDD37F7882A90)   /*  736 */,    W64LIT(0x524DCAB5518A3F5C)   /*  737 */,
  W64LIT(0x3C9E85878451255B)   /*  738 */,    W64LIT(0x4029828119BD34E2)   /*  739 */,
  W64LIT(0x74A05B6F5D3CECCB)   /*  740 */,    W64LIT(0xB610021542E13ECA)   /*  741 */,
  W64LIT(0x0FF979D12F59E2AC)   /*  742 */,    W64LIT(0x6037DA27E4F9CC50)   /*  743 */,
  W64LIT(0x5E92975A0DF1847D)   /*  744 */,    W64LIT(0xD66DE190D3E623FE)   /*  745 */,
  W64LIT(0x5032D6B87B568048)   /*  746 */,    W64LIT(0x9A36B7CE8235216E)   /*  747 */,
  W64LIT(0x80272A7A24F64B4A)   /*  748 */,    W64LIT(0x93EFED8B8C6916F7)   /*  749 */,
  W64LIT(0x37DDBFF44CCE1555)   /*  750 */,    W64LIT(0x4B95DB5D4B99BD25)   /*  751 */,
  W64LIT(0x92D3FDA169812FC0)   /*  752 */,    W64LIT(0xFB1A4A9A90660BB6)   /*  753 */,
  W64LIT(0x730C196946A4B9B2)   /*  754 */,    W64LIT(0x81E289AA7F49DA68)   /*  755 */,
  W64LIT(0x64669A0F83B1A05F)   /*  756 */,    W64LIT(0x27B3FF7D9644F48B)   /*  757 */,
  W64LIT(0xCC6B615C8DB675B3)   /*  758 */,    W64LIT(0x674F20B9BCEBBE95)   /*  759 */,
  W64LIT(0x6F31238275655982)   /*  760 */,    W64LIT(0x5AE488713E45CF05)   /*  761 */,
  W64LIT(0xBF619F9954C21157)   /*  762 */,    W64LIT(0xEABAC46040A8EAE9)   /*  763 */,
  W64LIT(0x454C6FE9F2C0C1CD)   /*  764 */,    W64LIT(0x419CF6496412691C)   /*  765 */,
  W64LIT(0xD3DC3BEF265B0F70)   /*  766 */,    W64LIT(0x6D0E60F5C3578A9E)   /*  767 */,
  W64LIT(0x5B0E608526323C55)   /*  768 */,    W64LIT(0x1A46C1A9FA1B59F5)   /*  769 */,
  W64LIT(0xA9E245A17C4C8FFA)   /*  770 */,    W64LIT(0x65CA5159DB2955D7)   /*  771 */,
  W64LIT(0x05DB0A76CE35AFC2)   /*  772 */,    W64LIT(0x81EAC77EA9113D45)   /*  773 */,
  W64LIT(0x528EF88AB6AC0A0D)   /*  774 */,    W64LIT(0xA09EA253597BE3FF)   /*  775 */,
  W64LIT(0x430DDFB3AC48CD56)   /*  776 */,    W64LIT(0xC4B3A67AF45CE46F)   /*  777 */,
  W64LIT(0x4ECECFD8FBE2D05E)   /*  778 */,    W64LIT(0x3EF56F10B39935F0)   /*  779 */,
  W64LIT(0x0B22D6829CD619C6)   /*  780 */,    W64LIT(0x17FD460A74DF2069)   /*  781 */,
  W64LIT(0x6CF8CC8E8510ED40)   /*  782 */,    W64LIT(0xD6C824BF3A6ECAA7)   /*  783 */,
  W64LIT(0x61243D581A817049)   /*  784 */,    W64LIT(0x048BACB6BBC163A2)   /*  785 */,
  W64LIT(0xD9A38AC27D44CC32)   /*  786 */,    W64LIT(0x7FDDFF5BAAF410AB)   /*  787 */,
  W64LIT(0xAD6D495AA804824B)   /*  788 */,    W64LIT(0xE1A6A74F2D8C9F94)   /*  789 */,
  W64LIT(0xD4F7851235DEE8E3)   /*  790 */,    W64LIT(0xFD4B7F886540D893)   /*  791 */,
  W64LIT(0x247C20042AA4BFDA)   /*  792 */,    W64LIT(0x096EA1C517D1327C)   /*  793 */,
  W64LIT(0xD56966B4361A6685)   /*  794 */,    W64LIT(0x277DA5C31221057D)   /*  795 */,
  W64LIT(0x94D59893A43ACFF7)   /*  796 */,    W64LIT(0x64F0C51CCDC02281)   /*  797 */,
  W64LIT(0x3D33BCC4FF6189DB)   /*  798 */,    W64LIT(0xE005CB184CE66AF1)   /*  799 */,
  W64LIT(0xFF5CCD1D1DB99BEA)   /*  800 */,    W64LIT(0xB0B854A7FE42980F)   /*  801 */,
  W64LIT(0x7BD46A6A718D4B9F)   /*  802 */,    W64LIT(0xD10FA8CC22A5FD8C)   /*  803 */,
  W64LIT(0xD31484952BE4BD31)   /*  804 */,    W64LIT(0xC7FA975FCB243847)   /*  805 */,
  W64LIT(0x4886ED1E5846C407)   /*  806 */,    W64LIT(0x28CDDB791EB70B04)   /*  807 */,
  W64LIT(0xC2B00BE2F573417F)   /*  808 */,    W64LIT(0x5C9590452180F877)   /*  809 */,
  W64LIT(0x7A6BDDFFF370EB00)   /*  810 */,    W64LIT(0xCE509E38D6D9D6A4)   /*  811 */,
  W64LIT(0xEBEB0F00647FA702)   /*  812 */,    W64LIT(0x1DCC06CF76606F06)   /*  813 */,
  W64LIT(0xE4D9F28BA286FF0A)   /*  814 */,    W64LIT(0xD85A305DC918C262)   /*  815 */,
  W64LIT(0x475B1D8732225F54)   /*  816 */,    W64LIT(0x2D4FB51668CCB5FE)   /*  817 */,
  W64LIT(0xA679B9D9D72BBA20)   /*  818 */,    W64LIT(0x53841C0D912D43A5)   /*  819 */,
  W64LIT(0x3B7EAA48BF12A4E8)   /*  820 */,    W64LIT(0x781E0E47F22F1DDF)   /*  821 */,
  W64LIT(0xEFF20CE60AB50973)   /*  822 */,    W64LIT(0x20D261D19DFFB742)   /*  823 */,
  W64LIT(0x16A12B03062A2E39)   /*  824 */,    W64LIT(0x1960EB2239650495)   /*  825 */,
  W64LIT(0x251C16FED50EB8B8)   /*  826 */,    W64LIT(0x9AC0C330F826016E)   /*  827 */,
  W64LIT(0xED152665953E7671)   /*  828 */,    W64LIT(0x02D63194A6369570)   /*  829 */,
  W64LIT(0x5074F08394B1C987)   /*  830 */,    W64LIT(0x70BA598C90B25CE1)   /*  831 */,
  W64LIT(0x794A15810B9742F6)   /*  832 */,    W64LIT(0x0D5925E9FCAF8C6C)   /*  833 */,
  W64LIT(0x3067716CD868744E)   /*  834 */,    W64LIT(0x910AB077E8D7731B)   /*  835 */,
  W64LIT(0x6A61BBDB5AC42F61)   /*  836 */,    W64LIT(0x93513EFBF0851567)   /*  837 */,
  W64LIT(0xF494724B9E83E9D5)   /*  838 */,    W64LIT(0xE887E1985C09648D)   /*  839 */,
  W64LIT(0x34B1D3C675370CFD)   /*  840 */,    W64LIT(0xDC35E433BC0D255D)   /*  841 */,
  W64LIT(0xD0AAB84234131BE0)   /*  842 */,    W64LIT(0x08042A50B48B7EAF)   /*  843 */,
  W64LIT(0x9997C4EE44A3AB35)   /*  844 */,    W64LIT(0x829A7B49201799D0)   /*  845 */,
  W64LIT(0x263B8307B7C54441)   /*  846 */,    W64LIT(0x752F95F4FD6A6CA6)   /*  847 */,
  W64LIT(0x927217402C08C6E5)   /*  848 */,    W64LIT(0x2A8AB754A795D9EE)   /*  849 */,
  W64LIT(0xA442F7552F72943D)   /*  850 */,    W64LIT(0x2C31334E19781208)   /*  851 */,
  W64LIT(0x4FA98D7CEAEE6291)   /*  852 */,    W64LIT(0x55C3862F665DB309)   /*  853 */,
  W64LIT(0xBD0610175D53B1F3)   /*  854 */,    W64LIT(0x46FE6CB840413F27)   /*  855 */,
  W64LIT(0x3FE03792DF0CFA59)   /*  856 */,    W64LIT(0xCFE700372EB85E8F)   /*  857 */,
  W64LIT(0xA7BE29E7ADBCE118)   /*  858 */,    W64LIT(0xE544EE5CDE8431DD)   /*  859 */,
  W64LIT(0x8A781B1B41F1873E)   /*  860 */,    W64LIT(0xA5C94C78A0D2F0E7)   /*  861 */,
  W64LIT(0x39412E2877B60728)   /*  862 */,    W64LIT(0xA1265EF3AFC9A62C)   /*  863 */,
  W64LIT(0xBCC2770C6A2506C5)   /*  864 */,    W64LIT(0x3AB66DD5DCE1CE12)   /*  865 */,
  W64LIT(0xE65499D04A675B37)   /*  866 */,    W64LIT(0x7D8F523481BFD216)   /*  867 */,
  W64LIT(0x0F6F64FCEC15F389)   /*  868 */,    W64LIT(0x74EFBE618B5B13C8)   /*  869 */,
  W64LIT(0xACDC82B714273E1D)   /*  870 */,    W64LIT(0xDD40BFE003199D17)   /*  871 */,
  W64LIT(0x37E99257E7E061F8)   /*  872 */,    W64LIT(0xFA52626904775AAA)   /*  873 */,
  W64LIT(0x8BBBF63A463D56F9)   /*  874 */,    W64LIT(0xF0013F1543A26E64)   /*  875 */,
  W64LIT(0xA8307E9F879EC898)   /*  876 */,    W64LIT(0xCC4C27A4150177CC)   /*  877 */,
  W64LIT(0x1B432F2CCA1D3348)   /*  878 */,    W64LIT(0xDE1D1F8F9F6FA013)   /*  879 */,
  W64LIT(0x606602A047A7DDD6)   /*  880 */,    W64LIT(0xD237AB64CC1CB2C7)   /*  881 */,
  W64LIT(0x9B938E7225FCD1D3)   /*  882 */,    W64LIT(0xEC4E03708E0FF476)   /*  883 */,
  W64LIT(0xFEB2FBDA3D03C12D)   /*  884 */,    W64LIT(0xAE0BCED2EE43889A)   /*  885 */,
  W64LIT(0x22CB8923EBFB4F43)   /*  886 */,    W64LIT(0x69360D013CF7396D)   /*  887 */,
  W64LIT(0x855E3602D2D4E022)   /*  888 */,    W64LIT(0x073805BAD01F784C)   /*  889 */,
  W64LIT(0x33E17A133852F546)   /*  890 */,    W64LIT(0xDF4874058AC7B638)   /*  891 */,
  W64LIT(0xBA92B29C678AA14A)   /*  892 */,    W64LIT(0x0CE89FC76CFAADCD)   /*  893 */,
  W64LIT(0x5F9D4E0908339E34)   /*  894 */,    W64LIT(0xF1AFE9291F5923B9)   /*  895 */,
  W64LIT(0x6E3480F60F4A265F)   /*  896 */,    W64LIT(0xEEBF3A2AB29B841C)   /*  897 */,
  W64LIT(0xE21938A88F91B4AD)   /*  898 */,    W64LIT(0x57DFEFF845C6D3C3)   /*  899 */,
  W64LIT(0x2F006B0BF62CAAF2)   /*  900 */,    W64LIT(0x62F479EF6F75EE78)   /*  901 */,
  W64LIT(0x11A55AD41C8916A9)   /*  902 */,    W64LIT(0xF229D29084FED453)   /*  903 */,
  W64LIT(0x42F1C27B16B000E6)   /*  904 */,    W64LIT(0x2B1F76749823C074)   /*  905 */,
  W64LIT(0x4B76ECA3C2745360)   /*  906 */,    W64LIT(0x8C98F463B91691BD)   /*  907 */,
  W64LIT(0x14BCC93CF1ADE66A)   /*  908 */,    W64LIT(0x8885213E6D458397)   /*  909 */,
  W64LIT(0x8E177DF0274D4711)   /*  910 */,    W64LIT(0xB49B73B5503F2951)   /*  911 */,
  W64LIT(0x10168168C3F96B6B)   /*  912 */,    W64LIT(0x0E3D963B63CAB0AE)   /*  913 */,
  W64LIT(0x8DFC4B5655A1DB14)   /*  914 */,    W64LIT(0xF789F1356E14DE5C)   /*  915 */,
  W64LIT(0x683E68AF4E51DAC1)   /*  916 */,    W64LIT(0xC9A84F9D8D4B0FD9)   /*  917 */,
  W64LIT(0x3691E03F52A0F9D1)   /*  918 */,    W64LIT(0x5ED86E46E1878E80)   /*  919 */,
  W64LIT(0x3C711A0E99D07150)   /*  920 */,    W64LIT(0x5A0865B20C4E9310)   /*  921 */,
  W64LIT(0x56FBFC1FE4F0682E)   /*  922 */,    W64LIT(0xEA8D5DE3105EDF9B)   /*  923 */,
  W64LIT(0x71ABFDB12379187A)   /*  924 */,    W64LIT(0x2EB99DE1BEE77B9C)   /*  925 */,
  W64LIT(0x21ECC0EA33CF4523)   /*  926 */,    W64LIT(0x59A4D7521805C7A1)   /*  927 */,
  W64LIT(0x3896F5EB56AE7C72)   /*  928 */,    W64LIT(0xAA638F3DB18F75DC)   /*  929 */,
  W64LIT(0x9F39358DABE9808E)   /*  930 */,    W64LIT(0xB7DEFA91C00B72AC)   /*  931 */,
  W64LIT(0x6B5541FD62492D92)   /*  932 */,    W64LIT(0x6DC6DEE8F92E4D5B)   /*  933 */,
  W64LIT(0x353F57ABC4BEEA7E)   /*  934 */,    W64LIT(0x735769D6DA5690CE)   /*  935 */,
  W64LIT(0x0A234AA642391484)   /*  936 */,    W64LIT(0xF6F9508028F80D9D)   /*  937 */,
  W64LIT(0xB8E319A27AB3F215)   /*  938 */,    W64LIT(0x31AD9C1151341A4D)   /*  939 */,
  W64LIT(0x773C22A57BEF5805)   /*  940 */,    W64LIT(0x45C7561A07968633)   /*  941 */,
  W64LIT(0xF913DA9E249DBE36)   /*  942 */,    W64LIT(0xDA652D9B78A64C68)   /*  943 */,
  W64LIT(0x4C27A97F3BC334EF)   /*  944 */,    W64LIT(0x76621220E66B17F4)   /*  945 */,
  W64LIT(0x967743899ACD7D0B)   /*  946 */,    W64LIT(0xF3EE5BCAE0ED6782)   /*  947 */,
  W64LIT(0x409F753600C879FC)   /*  948 */,    W64LIT(0x06D09A39B5926DB6)   /*  949 */,
  W64LIT(0x6F83AEB0317AC588)   /*  950 */,    W64LIT(0x01E6CA4A86381F21)   /*  951 */,
  W64LIT(0x66FF3462D19F3025)   /*  952 */,    W64LIT(0x72207C24DDFD3BFB)   /*  953 */,
  W64LIT(0x4AF6B6D3E2ECE2EB)   /*  954 */,    W64LIT(0x9C994DBEC7EA08DE)   /*  955 */,
  W64LIT(0x49ACE597B09A8BC4)   /*  956 */,    W64LIT(0xB38C4766CF0797BA)   /*  957 */,
  W64LIT(0x131B9373C57C2A75)   /*  958 */,    W64LIT(0xB1822CCE61931E58)   /*  959 */,
  W64LIT(0x9D7555B909BA1C0C)   /*  960 */,    W64LIT(0x127FAFDD937D11D2)   /*  961 */,
  W64LIT(0x29DA3BADC66D92E4)   /*  962 */,    W64LIT(0xA2C1D57154C2ECBC)   /*  963 */,
  W64LIT(0x58C5134D82F6FE24)   /*  964 */,    W64LIT(0x1C3AE3515B62274F)   /*  965 */,
  W64LIT(0xE907C82E01CB8126)   /*  966 */,    W64LIT(0xF8ED091913E37FCB)   /*  967 */,
  W64LIT(0x3249D8F9C80046C9)   /*  968 */,    W64LIT(0x80CF9BEDE388FB63)   /*  969 */,
  W64LIT(0x1881539A116CF19E)   /*  970 */,    W64LIT(0x5103F3F76BD52457)   /*  971 */,
  W64LIT(0x15B7E6F5AE47F7A8)   /*  972 */,    W64LIT(0xDBD7C6DED47E9CCF)   /*  973 */,
  W64LIT(0x44E55C410228BB1A)   /*  974 */,    W64LIT(0xB647D4255EDB4E99)   /*  975 */,
  W64LIT(0x5D11882BB8AAFC30)   /*  976 */,    W64LIT(0xF5098BBB29D3212A)   /*  977 */,
  W64LIT(0x8FB5EA14E90296B3)   /*  978 */,    W64LIT(0x677B942157DD025A)   /*  979 */,
  W64LIT(0xFB58E7C0A390ACB5)   /*  980 */,    W64LIT(0x89D3674C83BD4A01)   /*  981 */,
  W64LIT(0x9E2DA4DF4BF3B93B)   /*  982 */,    W64LIT(0xFCC41E328CAB4829)   /*  983 */,
  W64LIT(0x03F38C96BA582C52)   /*  984 */,    W64LIT(0xCAD1BDBD7FD85DB2)   /*  985 */,
  W64LIT(0xBBB442C16082AE83)   /*  986 */,    W64LIT(0xB95FE86BA5DA9AB0)   /*  987 */,
  W64LIT(0xB22E04673771A93F)   /*  988 */,    W64LIT(0x845358C9493152D8)   /*  989 */,
  W64LIT(0xBE2A488697B4541E)   /*  990 */,    W64LIT(0x95A2DC2DD38E6966)   /*  991 */,
  W64LIT(0xC02C11AC923C852B)   /*  992 */,    W64LIT(0x2388B1990DF2A87B)   /*  993 */,
  W64LIT(0x7C8008FA1B4F37BE)   /*  994 */,    W64LIT(0x1F70D0C84D54E503)   /*  995 */,
  W64LIT(0x5490ADEC7ECE57D4)   /*  996 */,    W64LIT(0x002B3C27D9063A3A)   /*  997 */,
  W64LIT(0x7EAEA3848030A2BF)   /*  998 */,    W64LIT(0xC602326DED2003C0)   /*  999 */,
  W64LIT(0x83A7287D69A94086)   /* 1000 */,    W64LIT(0xC57A5FCB30F57A8A)   /* 1001 */,
  W64LIT(0xB56844E479EBE779)   /* 1002 */,    W64LIT(0xA373B40F05DCBCE9)   /* 1003 */,
  W64LIT(0xD71A786E88570EE2)   /* 1004 */,    W64LIT(0x879CBACDBDE8F6A0)   /* 1005 */,
  W64LIT(0x976AD1BCC164A32F)   /* 1006 */,    W64LIT(0xAB21E25E9666D78B)   /* 1007 */,
  W64LIT(0x901063AAE5E5C33C)   /* 1008 */,    W64LIT(0x9818B34448698D90)   /* 1009 */,
  W64LIT(0xE36487AE3E1E8ABB)   /* 1010 */,    W64LIT(0xAFBDF931893BDCB4)   /* 1011 */,
  W64LIT(0x6345A0DC5FBBD519)   /* 1012 */,    W64LIT(0x8628FE269B9465CA)   /* 1013 */,
  W64LIT(0x1E5D01603F9C51EC)   /* 1014 */,    W64LIT(0x4DE44006A15049B7)   /* 1015 */,
  W64LIT(0xBF6C70E5F776CBB1)   /* 1016 */,    W64LIT(0x411218F2EF552BED)   /* 1017 */,
  W64LIT(0xCB0C0708705A36A3)   /* 1018 */,    W64LIT(0xE74D14754F986044)   /* 1019 */,
  W64LIT(0xCD56D9430EA8280E)   /* 1020 */,    W64LIT(0xC12591D7535F5065)   /* 1021 */,
  W64LIT(0xC83223F1720AEF96)   /* 1022 */,    W64LIT(0xC3A0396F7363A51F)   /* 1023 */
};

//-----------------
static const byte Twofish_q[2*256] =
{
  0xA9, 0x67, 0xB3, 0xE8, 0x04, 0xFD, 0xA3, 0x76, 0x9A, 0x92, 0x80, 0x78,
  0xE4, 0xDD, 0xD1, 0x38, 0x0D, 0xC6, 0x35, 0x98, 0x18, 0xF7, 0xEC, 0x6C,
  0x43, 0x75, 0x37, 0x26, 0xFA, 0x13, 0x94, 0x48, 0xF2, 0xD0, 0x8B, 0x30,
  0x84, 0x54, 0xDF, 0x23, 0x19, 0x5B, 0x3D, 0x59, 0xF3, 0xAE, 0xA2, 0x82,
  0x63, 0x01, 0x83, 0x2E, 0xD9, 0x51, 0x9B, 0x7C, 0xA6, 0xEB, 0xA5, 0xBE,
  0x16, 0x0C, 0xE3, 0x61, 0xC0, 0x8C, 0x3A, 0xF5, 0x73, 0x2C, 0x25, 0x0B,
  0xBB, 0x4E, 0x89, 0x6B, 0x53, 0x6A, 0xB4, 0xF1, 0xE1, 0xE6, 0xBD, 0x45,
  0xE2, 0xF4, 0xB6, 0x66, 0xCC, 0x95, 0x03, 0x56, 0xD4, 0x1C, 0x1E, 0xD7,
  0xFB, 0xC3, 0x8E, 0xB5, 0xE9, 0xCF, 0xBF, 0xBA, 0xEA, 0x77, 0x39, 0xAF,
  0x33, 0xC9, 0x62, 0x71, 0x81, 0x79, 0x09, 0xAD, 0x24, 0xCD, 0xF9, 0xD8,
  0xE5, 0xC5, 0xB9, 0x4D, 0x44, 0x08, 0x86, 0xE7, 0xA1, 0x1D, 0xAA, 0xED,
  0x06, 0x70, 0xB2, 0xD2, 0x41, 0x7B, 0xA0, 0x11, 0x31, 0xC2, 0x27, 0x90,
  0x20, 0xF6, 0x60, 0xFF, 0x96, 0x5C, 0xB1, 0xAB, 0x9E, 0x9C, 0x52, 0x1B,
  0x5F, 0x93, 0x0A, 0xEF, 0x91, 0x85, 0x49, 0xEE, 0x2D, 0x4F, 0x8F, 0x3B,
  0x47, 0x87, 0x6D, 0x46, 0xD6, 0x3E, 0x69, 0x64, 0x2A, 0xCE, 0xCB, 0x2F,
  0xFC, 0x97, 0x05, 0x7A, 0xAC, 0x7F, 0xD5, 0x1A, 0x4B, 0x0E, 0xA7, 0x5A,
  0x28, 0x14, 0x3F, 0x29, 0x88, 0x3C, 0x4C, 0x02, 0xB8, 0xDA, 0xB0, 0x17,
  0x55, 0x1F, 0x8A, 0x7D, 0x57, 0xC7, 0x8D, 0x74, 0xB7, 0xC4, 0x9F, 0x72,
  0x7E, 0x15, 0x22, 0x12, 0x58, 0x07, 0x99, 0x34, 0x6E, 0x50, 0xDE, 0x68,
  0x65, 0xBC, 0xDB, 0xF8, 0xC8, 0xA8, 0x2B, 0x40, 0xDC, 0xFE, 0x32, 0xA4,
  0xCA, 0x10, 0x21, 0xF0, 0xD3, 0x5D, 0x0F, 0x00, 0x6F, 0x9D, 0x36, 0x42,
  0x4A, 0x5E, 0xC1, 0xE0,

  0x75, 0xF3, 0xC6, 0xF4, 0xDB, 0x7B, 0xFB, 0xC8, 0x4A, 0xD3, 0xE6, 0x6B,
  0x45, 0x7D, 0xE8, 0x4B, 0xD6, 0x32, 0xD8, 0xFD, 0x37, 0x71, 0xF1, 0xE1,
  0x30, 0x0F, 0xF8, 0x1B, 0x87, 0xFA, 0x06, 0x3F, 0x5E, 0xBA, 0xAE, 0x5B,
  0x8A, 0x00, 0xBC, 0x9D, 0x6D, 0xC1, 0xB1, 0x0E, 0x80, 0x5D, 0xD2, 0xD5,
  0xA0, 0x84, 0x07, 0x14, 0xB5, 0x90, 0x2C, 0xA3, 0xB2, 0x73, 0x4C, 0x54,
  0x92, 0x74, 0x36, 0x51, 0x38, 0xB0, 0xBD, 0x5A, 0xFC, 0x60, 0x62, 0x96,
  0x6C, 0x42, 0xF7, 0x10, 0x7C, 0x28, 0x27, 0x8C, 0x13, 0x95, 0x9C, 0xC7,
  0x24, 0x46, 0x3B, 0x70, 0xCA, 0xE3, 0x85, 0xCB, 0x11, 0xD0, 0x93, 0xB8,
  0xA6, 0x83, 0x20, 0xFF, 0x9F, 0x77, 0xC3, 0xCC, 0x03, 0x6F, 0x08, 0xBF,
  0x40, 0xE7, 0x2B, 0xE2, 0x79, 0x0C, 0xAA, 0x82, 0x41, 0x3A, 0xEA, 0xB9,
  0xE4, 0x9A, 0xA4, 0x97, 0x7E, 0xDA, 0x7A, 0x17, 0x66, 0x94, 0xA1, 0x1D,
  0x3D, 0xF0, 0xDE, 0xB3, 0x0B, 0x72, 0xA7, 0x1C, 0xEF, 0xD1, 0x53, 0x3E,
  0x8F, 0x33, 0x26, 0x5F, 0xEC, 0x76, 0x2A, 0x49, 0x81, 0x88, 0xEE, 0x21,
  0xC4, 0x1A, 0xEB, 0xD9, 0xC5, 0x39, 0x99, 0xCD, 0xAD, 0x31, 0x8B, 0x01,
  0x18, 0x23, 0xDD, 0x1F, 0x4E, 0x2D, 0xF9, 0x48, 0x4F, 0xF2, 0x65, 0x8E,
  0x78, 0x5C, 0x58, 0x19, 0x8D, 0xE5, 0x98, 0x57, 0x67, 0x7F, 0x05, 0x64,
  0xAF, 0x63, 0xB6, 0xFE, 0xF5, 0xB7, 0x3C, 0xA5, 0xCE, 0xE9, 0x68, 0x44,
  0xE0, 0x4D, 0x43, 0x69, 0x29, 0x2E, 0xAC, 0x15, 0x59, 0xA8, 0x0A, 0x9E,
  0x6E, 0x47, 0xDF, 0x34, 0x35, 0x6A, 0xCF, 0xDC, 0x22, 0xC9, 0xC0, 0x9B,
  0x89, 0xD4, 0xED, 0xAB, 0x12, 0xA2, 0x0D, 0x52, 0xBB, 0x02, 0x2F, 0xA9,
  0xD7, 0x61, 0x1E, 0xB4, 0x50, 0x04, 0xF6, 0xC2, 0x16, 0x25, 0x86, 0x56,
  0x55, 0x09, 0xBE, 0x91
};

static const word32 Twofish_mds[4*256] =
{
  0xbcbc3275, 0xecec21f3, 0x202043c6, 0xb3b3c9f4,
  0xdada03db, 0x02028b7b, 0xe2e22bfb, 0x9e9efac8,
  0xc9c9ec4a, 0xd4d409d3, 0x18186be6, 0x1e1e9f6b,
  0x98980e45, 0xb2b2387d, 0xa6a6d2e8, 0x2626b74b,
  0x3c3c57d6, 0x93938a32, 0x8282eed8, 0x525298fd,
  0x7b7bd437, 0xbbbb3771, 0x5b5b97f1, 0x474783e1,
  0x24243c30, 0x5151e20f, 0xbabac6f8, 0x4a4af31b,
  0xbfbf4887, 0x0d0d70fa, 0xb0b0b306, 0x7575de3f,
  0xd2d2fd5e, 0x7d7d20ba, 0x666631ae, 0x3a3aa35b,
  0x59591c8a, 0x00000000, 0xcdcd93bc, 0x1a1ae09d,
  0xaeae2c6d, 0x7f7fabc1, 0x2b2bc7b1, 0xbebeb90e,
  0xe0e0a080, 0x8a8a105d, 0x3b3b52d2, 0x6464bad5,
  0xd8d888a0, 0xe7e7a584, 0x5f5fe807, 0x1b1b1114,
  0x2c2cc2b5, 0xfcfcb490, 0x3131272c, 0x808065a3,
  0x73732ab2, 0x0c0c8173, 0x79795f4c, 0x6b6b4154,
  0x4b4b0292, 0x53536974, 0x94948f36, 0x83831f51,
  0x2a2a3638, 0xc4c49cb0, 0x2222c8bd, 0xd5d5f85a,
  0xbdbdc3fc, 0x48487860, 0xffffce62, 0x4c4c0796,
  0x4141776c, 0xc7c7e642, 0xebeb24f7, 0x1c1c1410,
  0x5d5d637c, 0x36362228, 0x6767c027, 0xe9e9af8c,
  0x4444f913, 0x1414ea95, 0xf5f5bb9c, 0xcfcf18c7,
  0x3f3f2d24, 0xc0c0e346, 0x7272db3b, 0x54546c70,
  0x29294cca, 0xf0f035e3, 0x0808fe85, 0xc6c617cb,
  0xf3f34f11, 0x8c8ce4d0, 0xa4a45993, 0xcaca96b8,
  0x68683ba6, 0xb8b84d83, 0x38382820, 0xe5e52eff,
  0xadad569f, 0x0b0b8477, 0xc8c81dc3, 0x9999ffcc,
  0x5858ed03, 0x19199a6f, 0x0e0e0a08, 0x95957ebf,
  0x70705040, 0xf7f730e7, 0x6e6ecf2b, 0x1f1f6ee2,
  0xb5b53d79, 0x09090f0c, 0x616134aa, 0x57571682,
  0x9f9f0b41, 0x9d9d803a, 0x111164ea, 0x2525cdb9,
  0xafafdde4, 0x4545089a, 0xdfdf8da4, 0xa3a35c97,
  0xeaead57e, 0x353558da, 0xededd07a, 0x4343fc17,
  0xf8f8cb66, 0xfbfbb194, 0x3737d3a1, 0xfafa401d,
  0xc2c2683d, 0xb4b4ccf0, 0x32325dde, 0x9c9c71b3,
  0x5656e70b, 0xe3e3da72, 0x878760a7, 0x15151b1c,
  0xf9f93aef, 0x6363bfd1, 0x3434a953, 0x9a9a853e,
  0xb1b1428f, 0x7c7cd133, 0x88889b26, 0x3d3da65f,
  0xa1a1d7ec, 0xe4e4df76, 0x8181942a, 0x91910149,
  0x0f0ffb81, 0xeeeeaa88, 0x161661ee, 0xd7d77321,
  0x9797f5c4, 0xa5a5a81a, 0xfefe3feb, 0x6d6db5d9,
  0x7878aec5, 0xc5c56d39, 0x1d1de599, 0x7676a4cd,
  0x3e3edcad, 0xcbcb6731, 0xb6b6478b, 0xefef5b01,
  0x12121e18, 0x6060c523, 0x6a6ab0dd, 0x4d4df61f,
  0xcecee94e, 0xdede7c2d, 0x55559df9, 0x7e7e5a48,
  0x2121b24f, 0x03037af2, 0xa0a02665, 0x5e5e198e,
  0x5a5a6678, 0x65654b5c, 0x62624e58, 0xfdfd4519,
  0x0606f48d, 0x404086e5, 0xf2f2be98, 0x3333ac57,
  0x17179067, 0x05058e7f, 0xe8e85e05, 0x4f4f7d64,
  0x89896aaf, 0x10109563, 0x74742fb6, 0x0a0a75fe,
  0x5c5c92f5, 0x9b9b74b7, 0x2d2d333c, 0x3030d6a5,
  0x2e2e49ce, 0x494989e9, 0x46467268, 0x77775544,
  0xa8a8d8e0, 0x9696044d, 0x2828bd43, 0xa9a92969,
  0xd9d97929, 0x8686912e, 0xd1d187ac, 0xf4f44a15,
  0x8d8d1559, 0xd6d682a8, 0xb9b9bc0a, 0x42420d9e,
  0xf6f6c16e, 0x2f2fb847, 0xdddd06df, 0x23233934,
  0xcccc6235, 0xf1f1c46a, 0xc1c112cf, 0x8585ebdc,
  0x8f8f9e22, 0x7171a1c9, 0x9090f0c0, 0xaaaa539b,
  0x0101f189, 0x8b8be1d4, 0x4e4e8ced, 0x8e8e6fab,
  0xababa212, 0x6f6f3ea2, 0xe6e6540d, 0xdbdbf252,
  0x92927bbb, 0xb7b7b602, 0x6969ca2f, 0x3939d9a9,
  0xd3d30cd7, 0xa7a72361, 0xa2a2ad1e, 0xc3c399b4,
  0x6c6c4450, 0x07070504, 0x04047ff6, 0x272746c2,
  0xacaca716, 0xd0d07625, 0x50501386, 0xdcdcf756,
  0x84841a55, 0xe1e15109, 0x7a7a25be, 0x1313ef91,

  0xa9d93939, 0x67901717, 0xb3719c9c, 0xe8d2a6a6,
  0x04050707, 0xfd985252, 0xa3658080, 0x76dfe4e4,
  0x9a084545, 0x92024b4b, 0x80a0e0e0, 0x78665a5a,
  0xe4ddafaf, 0xddb06a6a, 0xd1bf6363, 0x38362a2a,
  0x0d54e6e6, 0xc6432020, 0x3562cccc, 0x98bef2f2,
  0x181e1212, 0xf724ebeb, 0xecd7a1a1, 0x6c774141,
  0x43bd2828, 0x7532bcbc, 0x37d47b7b, 0x269b8888,
  0xfa700d0d, 0x13f94444, 0x94b1fbfb, 0x485a7e7e,
  0xf27a0303, 0xd0e48c8c, 0x8b47b6b6, 0x303c2424,
  0x84a5e7e7, 0x54416b6b, 0xdf06dddd, 0x23c56060,
  0x1945fdfd, 0x5ba33a3a, 0x3d68c2c2, 0x59158d8d,
  0xf321ecec, 0xae316666, 0xa23e6f6f, 0x82165757,
  0x63951010, 0x015befef, 0x834db8b8, 0x2e918686,
  0xd9b56d6d, 0x511f8383, 0x9b53aaaa, 0x7c635d5d,
  0xa63b6868, 0xeb3ffefe, 0xa5d63030, 0xbe257a7a,
  0x16a7acac, 0x0c0f0909, 0xe335f0f0, 0x6123a7a7,
  0xc0f09090, 0x8cafe9e9, 0x3a809d9d, 0xf5925c5c,
  0x73810c0c, 0x2c273131, 0x2576d0d0, 0x0be75656,
  0xbb7b9292, 0x4ee9cece, 0x89f10101, 0x6b9f1e1e,
  0x53a93434, 0x6ac4f1f1, 0xb499c3c3, 0xf1975b5b,
  0xe1834747, 0xe66b1818, 0xbdc82222, 0x450e9898,
  0xe26e1f1f, 0xf4c9b3b3, 0xb62f7474, 0x66cbf8f8,
  0xccff9999, 0x95ea1414, 0x03ed5858, 0x56f7dcdc,
  0xd4e18b8b, 0x1c1b1515, 0x1eada2a2, 0xd70cd3d3,
  0xfb2be2e2, 0xc31dc8c8, 0x8e195e5e, 0xb5c22c2c,
  0xe9894949, 0xcf12c1c1, 0xbf7e9595, 0xba207d7d,
  0xea641111, 0x77840b0b, 0x396dc5c5, 0xaf6a8989,
  0x33d17c7c, 0xc9a17171, 0x62ceffff, 0x7137bbbb,
  0x81fb0f0f, 0x793db5b5, 0x0951e1e1, 0xaddc3e3e,
  0x242d3f3f, 0xcda47676, 0xf99d5555, 0xd8ee8282,
  0xe5864040, 0xc5ae7878, 0xb9cd2525, 0x4d049696,
  0x44557777, 0x080a0e0e, 0x86135050, 0xe730f7f7,
  0xa1d33737, 0x1d40fafa, 0xaa346161, 0xed8c4e4e,
  0x06b3b0b0, 0x706c5454, 0xb22a7373, 0xd2523b3b,
  0x410b9f9f, 0x7b8b0202, 0xa088d8d8, 0x114ff3f3,
  0x3167cbcb, 0xc2462727, 0x27c06767, 0x90b4fcfc,
  0x20283838, 0xf67f0404, 0x60784848, 0xff2ee5e5,
  0x96074c4c, 0x5c4b6565, 0xb1c72b2b, 0xab6f8e8e,
  0x9e0d4242, 0x9cbbf5f5, 0x52f2dbdb, 0x1bf34a4a,
  0x5fa63d3d, 0x9359a4a4, 0x0abcb9b9, 0xef3af9f9,
  0x91ef1313, 0x85fe0808, 0x49019191, 0xee611616,
  0x2d7cdede, 0x4fb22121, 0x8f42b1b1, 0x3bdb7272,
  0x47b82f2f, 0x8748bfbf, 0x6d2caeae, 0x46e3c0c0,
  0xd6573c3c, 0x3e859a9a, 0x6929a9a9, 0x647d4f4f,
  0x2a948181, 0xce492e2e, 0xcb17c6c6, 0x2fca6969,
  0xfcc3bdbd, 0x975ca3a3, 0x055ee8e8, 0x7ad0eded,
  0xac87d1d1, 0x7f8e0505, 0xd5ba6464, 0x1aa8a5a5,
  0x4bb72626, 0x0eb9bebe, 0xa7608787, 0x5af8d5d5,
  0x28223636, 0x14111b1b, 0x3fde7575, 0x2979d9d9,
  0x88aaeeee, 0x3c332d2d, 0x4c5f7979, 0x02b6b7b7,
  0xb896caca, 0xda583535, 0xb09cc4c4, 0x17fc4343,
  0x551a8484, 0x1ff64d4d, 0x8a1c5959, 0x7d38b2b2,
  0x57ac3333, 0xc718cfcf, 0x8df40606, 0x74695353,
  0xb7749b9b, 0xc4f59797, 0x9f56adad, 0x72dae3e3,
  0x7ed5eaea, 0x154af4f4, 0x229e8f8f, 0x12a2abab,
  0x584e6262, 0x07e85f5f, 0x99e51d1d, 0x34392323,
  0x6ec1f6f6, 0x50446c6c, 0xde5d3232, 0x68724646,
  0x6526a0a0, 0xbc93cdcd, 0xdb03dada, 0xf8c6baba,
  0xc8fa9e9e, 0xa882d6d6, 0x2bcf6e6e, 0x40507070,
  0xdceb8585, 0xfe750a0a, 0x328a9393, 0xa48ddfdf,
  0xca4c2929, 0x10141c1c, 0x2173d7d7, 0xf0ccb4b4,
  0xd309d4d4, 0x5d108a8a, 0x0fe25151, 0x00000000,
  0x6f9a1919, 0x9de01a1a, 0x368f9494, 0x42e6c7c7,
  0x4aecc9c9, 0x5efdd2d2, 0xc1ab7f7f, 0xe0d8a8a8,

  0xbc75bc32, 0xecf3ec21, 0x20c62043, 0xb3f4b3c9,
  0xdadbda03, 0x027b028b, 0xe2fbe22b, 0x9ec89efa,
  0xc94ac9ec, 0xd4d3d409, 0x18e6186b, 0x1e6b1e9f,
  0x9845980e, 0xb27db238, 0xa6e8a6d2, 0x264b26b7,
  0x3cd63c57, 0x9332938a, 0x82d882ee, 0x52fd5298,
  0x7b377bd4, 0xbb71bb37, 0x5bf15b97, 0x47e14783,
  0x2430243c, 0x510f51e2, 0xbaf8bac6, 0x4a1b4af3,
  0xbf87bf48, 0x0dfa0d70, 0xb006b0b3, 0x753f75de,
  0xd25ed2fd, 0x7dba7d20, 0x66ae6631, 0x3a5b3aa3,
  0x598a591c, 0x00000000, 0xcdbccd93, 0x1a9d1ae0,
  0xae6dae2c, 0x7fc17fab, 0x2bb12bc7, 0xbe0ebeb9,
  0xe080e0a0, 0x8a5d8a10, 0x3bd23b52, 0x64d564ba,
  0xd8a0d888, 0xe784e7a5, 0x5f075fe8, 0x1b141b11,
  0x2cb52cc2, 0xfc90fcb4, 0x312c3127, 0x80a38065,
  0x73b2732a, 0x0c730c81, 0x794c795f, 0x6b546b41,
  0x4b924b02, 0x53745369, 0x9436948f, 0x8351831f,
  0x2a382a36, 0xc4b0c49c, 0x22bd22c8, 0xd55ad5f8,
  0xbdfcbdc3, 0x48604878, 0xff62ffce, 0x4c964c07,
  0x416c4177, 0xc742c7e6, 0xebf7eb24, 0x1c101c14,
  0x5d7c5d63, 0x36283622, 0x672767c0, 0xe98ce9af,
  0x441344f9, 0x149514ea, 0xf59cf5bb, 0xcfc7cf18,
  0x3f243f2d, 0xc046c0e3, 0x723b72db, 0x5470546c,
  0x29ca294c, 0xf0e3f035, 0x088508fe, 0xc6cbc617,
  0xf311f34f, 0x8cd08ce4, 0xa493a459, 0xcab8ca96,
  0x68a6683b, 0xb883b84d, 0x38203828, 0xe5ffe52e,
  0xad9fad56, 0x0b770b84, 0xc8c3c81d, 0x99cc99ff,
  0x580358ed, 0x196f199a, 0x0e080e0a, 0x95bf957e,
  0x70407050, 0xf7e7f730, 0x6e2b6ecf, 0x1fe21f6e,
  0xb579b53d, 0x090c090f, 0x61aa6134, 0x57825716,
  0x9f419f0b, 0x9d3a9d80, 0x11ea1164, 0x25b925cd,
  0xafe4afdd, 0x459a4508, 0xdfa4df8d, 0xa397a35c,
  0xea7eead5, 0x35da3558, 0xed7aedd0, 0x431743fc,
  0xf866f8cb, 0xfb94fbb1, 0x37a137d3, 0xfa1dfa40,
  0xc23dc268, 0xb4f0b4cc, 0x32de325d, 0x9cb39c71,
  0x560b56e7, 0xe372e3da, 0x87a78760, 0x151c151b,
  0xf9eff93a, 0x63d163bf, 0x345334a9, 0x9a3e9a85,
  0xb18fb142, 0x7c337cd1, 0x8826889b, 0x3d5f3da6,
  0xa1eca1d7, 0xe476e4df, 0x812a8194, 0x91499101,
  0x0f810ffb, 0xee88eeaa, 0x16ee1661, 0xd721d773,
  0x97c497f5, 0xa51aa5a8, 0xfeebfe3f, 0x6dd96db5,
  0x78c578ae, 0xc539c56d, 0x1d991de5, 0x76cd76a4,
  0x3ead3edc, 0xcb31cb67, 0xb68bb647, 0xef01ef5b,
  0x1218121e, 0x602360c5, 0x6add6ab0, 0x4d1f4df6,
  0xce4ecee9, 0xde2dde7c, 0x55f9559d, 0x7e487e5a,
  0x214f21b2, 0x03f2037a, 0xa065a026, 0x5e8e5e19,
  0x5a785a66, 0x655c654b, 0x6258624e, 0xfd19fd45,
  0x068d06f4, 0x40e54086, 0xf298f2be, 0x335733ac,
  0x17671790, 0x057f058e, 0xe805e85e, 0x4f644f7d,
  0x89af896a, 0x10631095, 0x74b6742f, 0x0afe0a75,
  0x5cf55c92, 0x9bb79b74, 0x2d3c2d33, 0x30a530d6,
  0x2ece2e49, 0x49e94989, 0x46684672, 0x77447755,
  0xa8e0a8d8, 0x964d9604, 0x284328bd, 0xa969a929,
  0xd929d979, 0x862e8691, 0xd1acd187, 0xf415f44a,
  0x8d598d15, 0xd6a8d682, 0xb90ab9bc, 0x429e420d,
  0xf66ef6c1, 0x2f472fb8, 0xdddfdd06, 0x23342339,
  0xcc35cc62, 0xf16af1c4, 0xc1cfc112, 0x85dc85eb,
  0x8f228f9e, 0x71c971a1, 0x90c090f0, 0xaa9baa53,
  0x018901f1, 0x8bd48be1, 0x4eed4e8c, 0x8eab8e6f,
  0xab12aba2, 0x6fa26f3e, 0xe60de654, 0xdb52dbf2,
  0x92bb927b, 0xb702b7b6, 0x692f69ca, 0x39a939d9,
  0xd3d7d30c, 0xa761a723, 0xa21ea2ad, 0xc3b4c399,
  0x6c506c44, 0x07040705, 0x04f6047f, 0x27c22746,
  0xac16aca7, 0xd025d076, 0x50865013, 0xdc56dcf7,
  0x8455841a, 0xe109e151, 0x7abe7a25, 0x139113ef,

  0xd939a9d9, 0x90176790, 0x719cb371, 0xd2a6e8d2,
  0x05070405, 0x9852fd98, 0x6580a365, 0xdfe476df,
  0x08459a08, 0x024b9202, 0xa0e080a0, 0x665a7866,
  0xddafe4dd, 0xb06addb0, 0xbf63d1bf, 0x362a3836,
  0x54e60d54, 0x4320c643, 0x62cc3562, 0xbef298be,
  0x1e12181e, 0x24ebf724, 0xd7a1ecd7, 0x77416c77,
  0xbd2843bd, 0x32bc7532, 0xd47b37d4, 0x9b88269b,
  0x700dfa70, 0xf94413f9, 0xb1fb94b1, 0x5a7e485a,
  0x7a03f27a, 0xe48cd0e4, 0x47b68b47, 0x3c24303c,
  0xa5e784a5, 0x416b5441, 0x06dddf06, 0xc56023c5,
  0x45fd1945, 0xa33a5ba3, 0x68c23d68, 0x158d5915,
  0x21ecf321, 0x3166ae31, 0x3e6fa23e, 0x16578216,
  0x95106395, 0x5bef015b, 0x4db8834d, 0x91862e91,
  0xb56dd9b5, 0x1f83511f, 0x53aa9b53, 0x635d7c63,
  0x3b68a63b, 0x3ffeeb3f, 0xd630a5d6, 0x257abe25,
  0xa7ac16a7, 0x0f090c0f, 0x35f0e335, 0x23a76123,
  0xf090c0f0, 0xafe98caf, 0x809d3a80, 0x925cf592,
  0x810c7381, 0x27312c27, 0x76d02576, 0xe7560be7,
  0x7b92bb7b, 0xe9ce4ee9, 0xf10189f1, 0x9f1e6b9f,
  0xa93453a9, 0xc4f16ac4, 0x99c3b499, 0x975bf197,
  0x8347e183, 0x6b18e66b, 0xc822bdc8, 0x0e98450e,
  0x6e1fe26e, 0xc9b3f4c9, 0x2f74b62f, 0xcbf866cb,
  0xff99ccff, 0xea1495ea, 0xed5803ed, 0xf7dc56f7,
  0xe18bd4e1, 0x1b151c1b, 0xada21ead, 0x0cd3d70c,
  0x2be2fb2b, 0x1dc8c31d, 0x195e8e19, 0xc22cb5c2,
  0x8949e989, 0x12c1cf12, 0x7e95bf7e, 0x207dba20,
  0x6411ea64, 0x840b7784, 0x6dc5396d, 0x6a89af6a,
  0xd17c33d1, 0xa171c9a1, 0xceff62ce, 0x37bb7137,
  0xfb0f81fb, 0x3db5793d, 0x51e10951, 0xdc3eaddc,
  0x2d3f242d, 0xa476cda4, 0x9d55f99d, 0xee82d8ee,
  0x8640e586, 0xae78c5ae, 0xcd25b9cd, 0x04964d04,
  0x55774455, 0x0a0e080a, 0x13508613, 0x30f7e730,
  0xd337a1d3, 0x40fa1d40, 0x3461aa34, 0x8c4eed8c,
  0xb3b006b3, 0x6c54706c, 0x2a73b22a, 0x523bd252,
  0x0b9f410b, 0x8b027b8b, 0x88d8a088, 0x4ff3114f,
  0x67cb3167, 0x4627c246, 0xc06727c0, 0xb4fc90b4,
  0x28382028, 0x7f04f67f, 0x78486078, 0x2ee5ff2e,
  0x074c9607, 0x4b655c4b, 0xc72bb1c7, 0x6f8eab6f,
  0x0d429e0d, 0xbbf59cbb, 0xf2db52f2, 0xf34a1bf3,
  0xa63d5fa6, 0x59a49359, 0xbcb90abc, 0x3af9ef3a,
  0xef1391ef, 0xfe0885fe, 0x01914901, 0x6116ee61,
  0x7cde2d7c, 0xb2214fb2, 0x42b18f42, 0xdb723bdb,
  0xb82f47b8, 0x48bf8748, 0x2cae6d2c, 0xe3c046e3,
  0x573cd657, 0x859a3e85, 0x29a96929, 0x7d4f647d,
  0x94812a94, 0x492ece49, 0x17c6cb17, 0xca692fca,
  0xc3bdfcc3, 0x5ca3975c, 0x5ee8055e, 0xd0ed7ad0,
  0x87d1ac87, 0x8e057f8e, 0xba64d5ba, 0xa8a51aa8,
  0xb7264bb7, 0xb9be0eb9, 0x6087a760, 0xf8d55af8,
  0x22362822, 0x111b1411, 0xde753fde, 0x79d92979,
  0xaaee88aa, 0x332d3c33, 0x5f794c5f, 0xb6b702b6,
  0x96cab896, 0x5835da58, 0x9cc4b09c, 0xfc4317fc,
  0x1a84551a, 0xf64d1ff6, 0x1c598a1c, 0x38b27d38,
  0xac3357ac, 0x18cfc718, 0xf4068df4, 0x69537469,
  0x749bb774, 0xf597c4f5, 0x56ad9f56, 0xdae372da,
  0xd5ea7ed5, 0x4af4154a, 0x9e8f229e, 0xa2ab12a2,
  0x4e62584e, 0xe85f07e8, 0xe51d99e5, 0x39233439,
  0xc1f66ec1, 0x446c5044, 0x5d32de5d, 0x72466872,
  0x26a06526, 0x93cdbc93, 0x03dadb03, 0xc6baf8c6,
  0xfa9ec8fa, 0x82d6a882, 0xcf6e2bcf, 0x50704050,
  0xeb85dceb, 0x750afe75, 0x8a93328a, 0x8ddfa48d,
  0x4c29ca4c, 0x141c1014, 0x73d72173, 0xccb4f0cc,
  0x09d4d309, 0x108a5d10, 0xe2510fe2, 0x00000000,
  0x9a196f9a, 0xe01a9de0, 0x8f94368f, 0xe6c742e6,
  0xecc94aec, 0xfdd25efd, 0xab7fc1ab, 0xd8a8e0d8
};

//-----------------
static const word32 Square_Te[4*256] =
{
  0x97b1b126UL, 0x69cecea7UL, 0x73c3c3b0UL, 0xdf95954aUL,
  0xb45a5aeeUL, 0xafadad02UL, 0x3be7e7dcUL, 0x04020206UL,
  0x9a4d4dd7UL, 0x884444ccUL, 0x03fbfbf8UL, 0xd7919146UL,
  0x180c0c14UL, 0xfb87877cUL, 0xb7a1a116UL, 0xa05050f0UL,
  0x63cbcba8UL, 0xce6767a9UL, 0xa85454fcUL, 0x4fdddd92UL,
  0x8c4646caUL, 0xeb8f8f64UL, 0x37e1e1d6UL, 0x9c4e4ed2UL,
  0x15f0f0e5UL, 0x0ffdfdf2UL, 0x0dfcfcf1UL, 0x23ebebc8UL,
  0x07f9f9feUL, 0x7dc4c4b9UL, 0x341a1a2eUL, 0xdc6e6eb2UL,
  0xbc5e5ee2UL, 0x1ff5f5eaUL, 0x6dcccca1UL, 0xef8d8d62UL,
  0x381c1c24UL, 0xac5656faUL, 0x864343c5UL, 0x09fefef7UL,
  0x0e070709UL, 0xc26161a3UL, 0x05f8f8fdUL, 0xea75759fUL,
  0xb25959ebUL, 0x0bfffff4UL, 0x06030305UL, 0x44222266UL,
  0xe18a8a6bUL, 0x57d1d186UL, 0x26131335UL, 0x29eeeec7UL,
  0xe588886dUL, 0x00000000UL, 0x1c0e0e12UL, 0x6834345cUL,
  0x2a15153fUL, 0xf5808075UL, 0xdd949449UL, 0x33e3e3d0UL,
  0x2fededc2UL, 0x9fb5b52aUL, 0xa65353f5UL, 0x46232365UL,
  0x964b4bddUL, 0x8e4747c9UL, 0x2e171739UL, 0xbba7a71cUL,
  0xd5909045UL, 0x6a35355fUL, 0xa3abab08UL, 0x45d8d89dUL,
  0x85b8b83dUL, 0x4bdfdf94UL, 0x9e4f4fd1UL, 0xae5757f9UL,
  0xc19a9a5bUL, 0xd1929243UL, 0x43dbdb98UL, 0x361b1b2dUL,
  0x783c3c44UL, 0x65c8c8adUL, 0xc799995eUL, 0x0804040cUL,
  0xe98e8e67UL, 0x35e0e0d5UL, 0x5bd7d78cUL, 0xfa7d7d87UL,
  0xff85857aUL, 0x83bbbb38UL, 0x804040c0UL, 0x582c2c74UL,
  0x743a3a4eUL, 0x8a4545cfUL, 0x17f1f1e6UL, 0x844242c6UL,
  0xca6565afUL, 0x40202060UL, 0x824141c3UL, 0x30181828UL,
  0xe4727296UL, 0x4a25256fUL, 0xd3939340UL, 0xe0707090UL,
  0x6c36365aUL, 0x0a05050fUL, 0x11f2f2e3UL, 0x160b0b1dUL,
  0xb3a3a310UL, 0xf279798bUL, 0x2dececc1UL, 0x10080818UL,
  0x4e272769UL, 0x62313153UL, 0x64323256UL, 0x99b6b62fUL,
  0xf87c7c84UL, 0x95b0b025UL, 0x140a0a1eUL, 0xe6737395UL,
  0xb65b5bedUL, 0xf67b7b8dUL, 0x9bb7b72cUL, 0xf7818176UL,
  0x51d2d283UL, 0x1a0d0d17UL, 0xd46a6abeUL, 0x4c26266aUL,
  0xc99e9e57UL, 0xb05858e8UL, 0xcd9c9c51UL, 0xf3838370UL,
  0xe874749cUL, 0x93b3b320UL, 0xadacac01UL, 0x60303050UL,
  0xf47a7a8eUL, 0xd26969bbUL, 0xee777799UL, 0x1e0f0f11UL,
  0xa9aeae07UL, 0x42212163UL, 0x49dede97UL, 0x55d0d085UL,
  0x5c2e2e72UL, 0xdb97974cUL, 0x20101030UL, 0xbda4a419UL,
  0xc598985dUL, 0xa5a8a80dUL, 0x5dd4d489UL, 0xd06868b8UL,
  0x5a2d2d77UL, 0xc46262a6UL, 0x5229297bUL, 0xda6d6db7UL,
  0x2c16163aUL, 0x924949dbUL, 0xec76769aUL, 0x7bc7c7bcUL,
  0x25e8e8cdUL, 0x77c1c1b6UL, 0xd996964fUL, 0x6e373759UL,
  0x3fe5e5daUL, 0x61cacaabUL, 0x1df4f4e9UL, 0x27e9e9ceUL,
  0xc66363a5UL, 0x24121236UL, 0x71c2c2b3UL, 0xb9a6a61fUL,
  0x2814143cUL, 0x8dbcbc31UL, 0x53d3d380UL, 0x50282878UL,
  0xabafaf04UL, 0x5e2f2f71UL, 0x39e6e6dfUL, 0x4824246cUL,
  0xa45252f6UL, 0x79c6c6bfUL, 0xb5a0a015UL, 0x1209091bUL,
  0x8fbdbd32UL, 0xed8c8c61UL, 0x6bcfcfa4UL, 0xba5d5de7UL,
  0x22111133UL, 0xbe5f5fe1UL, 0x02010103UL, 0x7fc5c5baUL,
  0xcb9f9f54UL, 0x7a3d3d47UL, 0xb1a2a213UL, 0xc39b9b58UL,
  0x67c9c9aeUL, 0x763b3b4dUL, 0x89bebe37UL, 0xa25151f3UL,
  0x3219192bUL, 0x3e1f1f21UL, 0x7e3f3f41UL, 0xb85c5ce4UL,
  0x91b2b223UL, 0x2befefc4UL, 0x944a4adeUL, 0x6fcdcda2UL,
  0x8bbfbf34UL, 0x81baba3bUL, 0xde6f6fb1UL, 0xc86464acUL,
  0x47d9d99eUL, 0x13f3f3e0UL, 0x7c3e3e42UL, 0x9db4b429UL,
  0xa1aaaa0bUL, 0x4ddcdc91UL, 0x5fd5d58aUL, 0x0c06060aUL,
  0x75c0c0b5UL, 0xfc7e7e82UL, 0x19f6f6efUL, 0xcc6666aaUL,
  0xd86c6cb4UL, 0xfd848479UL, 0xe2717193UL, 0x70383848UL,
  0x87b9b93eUL, 0x3a1d1d27UL, 0xfe7f7f81UL, 0xcf9d9d52UL,
  0x904848d8UL, 0xe38b8b68UL, 0x542a2a7eUL, 0x41dada9bUL,
  0xbfa5a51aUL, 0x66333355UL, 0xf1828273UL, 0x7239394bUL,
  0x59d6d68fUL, 0xf0787888UL, 0xf986867fUL, 0x01fafafbUL,
  0x3de4e4d9UL, 0x562b2b7dUL, 0xa7a9a90eUL, 0x3c1e1e22UL,
  0xe789896eUL, 0xc06060a0UL, 0xd66b6bbdUL, 0x21eaeacbUL,
  0xaa5555ffUL, 0x984c4cd4UL, 0x1bf7f7ecUL, 0x31e2e2d3UL,

  0x2697b1b1UL, 0xa769ceceUL, 0xb073c3c3UL, 0x4adf9595UL,
  0xeeb45a5aUL, 0x02afadadUL, 0xdc3be7e7UL, 0x06040202UL,
  0xd79a4d4dUL, 0xcc884444UL, 0xf803fbfbUL, 0x46d79191UL,
  0x14180c0cUL, 0x7cfb8787UL, 0x16b7a1a1UL, 0xf0a05050UL,
  0xa863cbcbUL, 0xa9ce6767UL, 0xfca85454UL, 0x924fddddUL,
  0xca8c4646UL, 0x64eb8f8fUL, 0xd637e1e1UL, 0xd29c4e4eUL,
  0xe515f0f0UL, 0xf20ffdfdUL, 0xf10dfcfcUL, 0xc823ebebUL,
  0xfe07f9f9UL, 0xb97dc4c4UL, 0x2e341a1aUL, 0xb2dc6e6eUL,
  0xe2bc5e5eUL, 0xea1ff5f5UL, 0xa16dccccUL, 0x62ef8d8dUL,
  0x24381c1cUL, 0xfaac5656UL, 0xc5864343UL, 0xf709fefeUL,
  0x090e0707UL, 0xa3c26161UL, 0xfd05f8f8UL, 0x9fea7575UL,
  0xebb25959UL, 0xf40bffffUL, 0x05060303UL, 0x66442222UL,
  0x6be18a8aUL, 0x8657d1d1UL, 0x35261313UL, 0xc729eeeeUL,
  0x6de58888UL, 0x00000000UL, 0x121c0e0eUL, 0x5c683434UL,
  0x3f2a1515UL, 0x75f58080UL, 0x49dd9494UL, 0xd033e3e3UL,
  0xc22fededUL, 0x2a9fb5b5UL, 0xf5a65353UL, 0x65462323UL,
  0xdd964b4bUL, 0xc98e4747UL, 0x392e1717UL, 0x1cbba7a7UL,
  0x45d59090UL, 0x5f6a3535UL, 0x08a3ababUL, 0x9d45d8d8UL,
  0x3d85b8b8UL, 0x944bdfdfUL, 0xd19e4f4fUL, 0xf9ae5757UL,
  0x5bc19a9aUL, 0x43d19292UL, 0x9843dbdbUL, 0x2d361b1bUL,
  0x44783c3cUL, 0xad65c8c8UL, 0x5ec79999UL, 0x0c080404UL,
  0x67e98e8eUL, 0xd535e0e0UL, 0x8c5bd7d7UL, 0x87fa7d7dUL,
  0x7aff8585UL, 0x3883bbbbUL, 0xc0804040UL, 0x74582c2cUL,
  0x4e743a3aUL, 0xcf8a4545UL, 0xe617f1f1UL, 0xc6844242UL,
  0xafca6565UL, 0x60402020UL, 0xc3824141UL, 0x28301818UL,
  0x96e47272UL, 0x6f4a2525UL, 0x40d39393UL, 0x90e07070UL,
  0x5a6c3636UL, 0x0f0a0505UL, 0xe311f2f2UL, 0x1d160b0bUL,
  0x10b3a3a3UL, 0x8bf27979UL, 0xc12dececUL, 0x18100808UL,
  0x694e2727UL, 0x53623131UL, 0x56643232UL, 0x2f99b6b6UL,
  0x84f87c7cUL, 0x2595b0b0UL, 0x1e140a0aUL, 0x95e67373UL,
  0xedb65b5bUL, 0x8df67b7bUL, 0x2c9bb7b7UL, 0x76f78181UL,
  0x8351d2d2UL, 0x171a0d0dUL, 0xbed46a6aUL, 0x6a4c2626UL,
  0x57c99e9eUL, 0xe8b05858UL, 0x51cd9c9cUL, 0x70f38383UL,
  0x9ce87474UL, 0x2093b3b3UL, 0x01adacacUL, 0x50603030UL,
  0x8ef47a7aUL, 0xbbd26969UL, 0x99ee7777UL, 0x111e0f0fUL,
  0x07a9aeaeUL, 0x63422121UL, 0x9749dedeUL, 0x8555d0d0UL,
  0x725c2e2eUL, 0x4cdb9797UL, 0x30201010UL, 0x19bda4a4UL,
  0x5dc59898UL, 0x0da5a8a8UL, 0x895dd4d4UL, 0xb8d06868UL,
  0x775a2d2dUL, 0xa6c46262UL, 0x7b522929UL, 0xb7da6d6dUL,
  0x3a2c1616UL, 0xdb924949UL, 0x9aec7676UL, 0xbc7bc7c7UL,
  0xcd25e8e8UL, 0xb677c1c1UL, 0x4fd99696UL, 0x596e3737UL,
  0xda3fe5e5UL, 0xab61cacaUL, 0xe91df4f4UL, 0xce27e9e9UL,
  0xa5c66363UL, 0x36241212UL, 0xb371c2c2UL, 0x1fb9a6a6UL,
  0x3c281414UL, 0x318dbcbcUL, 0x8053d3d3UL, 0x78502828UL,
  0x04abafafUL, 0x715e2f2fUL, 0xdf39e6e6UL, 0x6c482424UL,
  0xf6a45252UL, 0xbf79c6c6UL, 0x15b5a0a0UL, 0x1b120909UL,
  0x328fbdbdUL, 0x61ed8c8cUL, 0xa46bcfcfUL, 0xe7ba5d5dUL,
  0x33221111UL, 0xe1be5f5fUL, 0x03020101UL, 0xba7fc5c5UL,
  0x54cb9f9fUL, 0x477a3d3dUL, 0x13b1a2a2UL, 0x58c39b9bUL,
  0xae67c9c9UL, 0x4d763b3bUL, 0x3789bebeUL, 0xf3a25151UL,
  0x2b321919UL, 0x213e1f1fUL, 0x417e3f3fUL, 0xe4b85c5cUL,
  0x2391b2b2UL, 0xc42befefUL, 0xde944a4aUL, 0xa26fcdcdUL,
  0x348bbfbfUL, 0x3b81babaUL, 0xb1de6f6fUL, 0xacc86464UL,
  0x9e47d9d9UL, 0xe013f3f3UL, 0x427c3e3eUL, 0x299db4b4UL,
  0x0ba1aaaaUL, 0x914ddcdcUL, 0x8a5fd5d5UL, 0x0a0c0606UL,
  0xb575c0c0UL, 0x82fc7e7eUL, 0xef19f6f6UL, 0xaacc6666UL,
  0xb4d86c6cUL, 0x79fd8484UL, 0x93e27171UL, 0x48703838UL,
  0x3e87b9b9UL, 0x273a1d1dUL, 0x81fe7f7fUL, 0x52cf9d9dUL,
  0xd8904848UL, 0x68e38b8bUL, 0x7e542a2aUL, 0x9b41dadaUL,
  0x1abfa5a5UL, 0x55663333UL, 0x73f18282UL, 0x4b723939UL,
  0x8f59d6d6UL, 0x88f07878UL, 0x7ff98686UL, 0xfb01fafaUL,
  0xd93de4e4UL, 0x7d562b2bUL, 0x0ea7a9a9UL, 0x223c1e1eUL,
  0x6ee78989UL, 0xa0c06060UL, 0xbdd66b6bUL, 0xcb21eaeaUL,
  0xffaa5555UL, 0xd4984c4cUL, 0xec1bf7f7UL, 0xd331e2e2UL,

  0xb12697b1UL, 0xcea769ceUL, 0xc3b073c3UL, 0x954adf95UL,
  0x5aeeb45aUL, 0xad02afadUL, 0xe7dc3be7UL, 0x02060402UL,
  0x4dd79a4dUL, 0x44cc8844UL, 0xfbf803fbUL, 0x9146d791UL,
  0x0c14180cUL, 0x877cfb87UL, 0xa116b7a1UL, 0x50f0a050UL,
  0xcba863cbUL, 0x67a9ce67UL, 0x54fca854UL, 0xdd924fddUL,
  0x46ca8c46UL, 0x8f64eb8fUL, 0xe1d637e1UL, 0x4ed29c4eUL,
  0xf0e515f0UL, 0xfdf20ffdUL, 0xfcf10dfcUL, 0xebc823ebUL,
  0xf9fe07f9UL, 0xc4b97dc4UL, 0x1a2e341aUL, 0x6eb2dc6eUL,
  0x5ee2bc5eUL, 0xf5ea1ff5UL, 0xcca16dccUL, 0x8d62ef8dUL,
  0x1c24381cUL, 0x56faac56UL, 0x43c58643UL, 0xfef709feUL,
  0x07090e07UL, 0x61a3c261UL, 0xf8fd05f8UL, 0x759fea75UL,
  0x59ebb259UL, 0xfff40bffUL, 0x03050603UL, 0x22664422UL,
  0x8a6be18aUL, 0xd18657d1UL, 0x13352613UL, 0xeec729eeUL,
  0x886de588UL, 0x00000000UL, 0x0e121c0eUL, 0x345c6834UL,
  0x153f2a15UL, 0x8075f580UL, 0x9449dd94UL, 0xe3d033e3UL,
  0xedc22fedUL, 0xb52a9fb5UL, 0x53f5a653UL, 0x23654623UL,
  0x4bdd964bUL, 0x47c98e47UL, 0x17392e17UL, 0xa71cbba7UL,
  0x9045d590UL, 0x355f6a35UL, 0xab08a3abUL, 0xd89d45d8UL,
  0xb83d85b8UL, 0xdf944bdfUL, 0x4fd19e4fUL, 0x57f9ae57UL,
  0x9a5bc19aUL, 0x9243d192UL, 0xdb9843dbUL, 0x1b2d361bUL,
  0x3c44783cUL, 0xc8ad65c8UL, 0x995ec799UL, 0x040c0804UL,
  0x8e67e98eUL, 0xe0d535e0UL, 0xd78c5bd7UL, 0x7d87fa7dUL,
  0x857aff85UL, 0xbb3883bbUL, 0x40c08040UL, 0x2c74582cUL,
  0x3a4e743aUL, 0x45cf8a45UL, 0xf1e617f1UL, 0x42c68442UL,
  0x65afca65UL, 0x20604020UL, 0x41c38241UL, 0x18283018UL,
  0x7296e472UL, 0x256f4a25UL, 0x9340d393UL, 0x7090e070UL,
  0x365a6c36UL, 0x050f0a05UL, 0xf2e311f2UL, 0x0b1d160bUL,
  0xa310b3a3UL, 0x798bf279UL, 0xecc12decUL, 0x08181008UL,
  0x27694e27UL, 0x31536231UL, 0x32566432UL, 0xb62f99b6UL,
  0x7c84f87cUL, 0xb02595b0UL, 0x0a1e140aUL, 0x7395e673UL,
  0x5bedb65bUL, 0x7b8df67bUL, 0xb72c9bb7UL, 0x8176f781UL,
  0xd28351d2UL, 0x0d171a0dUL, 0x6abed46aUL, 0x266a4c26UL,
  0x9e57c99eUL, 0x58e8b058UL, 0x9c51cd9cUL, 0x8370f383UL,
  0x749ce874UL, 0xb32093b3UL, 0xac01adacUL, 0x30506030UL,
  0x7a8ef47aUL, 0x69bbd269UL, 0x7799ee77UL, 0x0f111e0fUL,
  0xae07a9aeUL, 0x21634221UL, 0xde9749deUL, 0xd08555d0UL,
  0x2e725c2eUL, 0x974cdb97UL, 0x10302010UL, 0xa419bda4UL,
  0x985dc598UL, 0xa80da5a8UL, 0xd4895dd4UL, 0x68b8d068UL,
  0x2d775a2dUL, 0x62a6c462UL, 0x297b5229UL, 0x6db7da6dUL,
  0x163a2c16UL, 0x49db9249UL, 0x769aec76UL, 0xc7bc7bc7UL,
  0xe8cd25e8UL, 0xc1b677c1UL, 0x964fd996UL, 0x37596e37UL,
  0xe5da3fe5UL, 0xcaab61caUL, 0xf4e91df4UL, 0xe9ce27e9UL,
  0x63a5c663UL, 0x12362412UL, 0xc2b371c2UL, 0xa61fb9a6UL,
  0x143c2814UL, 0xbc318dbcUL, 0xd38053d3UL, 0x28785028UL,
  0xaf04abafUL, 0x2f715e2fUL, 0xe6df39e6UL, 0x246c4824UL,
  0x52f6a452UL, 0xc6bf79c6UL, 0xa015b5a0UL, 0x091b1209UL,
  0xbd328fbdUL, 0x8c61ed8cUL, 0xcfa46bcfUL, 0x5de7ba5dUL,
  0x11332211UL, 0x5fe1be5fUL, 0x01030201UL, 0xc5ba7fc5UL,
  0x9f54cb9fUL, 0x3d477a3dUL, 0xa213b1a2UL, 0x9b58c39bUL,
  0xc9ae67c9UL, 0x3b4d763bUL, 0xbe3789beUL, 0x51f3a251UL,
  0x192b3219UL, 0x1f213e1fUL, 0x3f417e3fUL, 0x5ce4b85cUL,
  0xb22391b2UL, 0xefc42befUL, 0x4ade944aUL, 0xcda26fcdUL,
  0xbf348bbfUL, 0xba3b81baUL, 0x6fb1de6fUL, 0x64acc864UL,
  0xd99e47d9UL, 0xf3e013f3UL, 0x3e427c3eUL, 0xb4299db4UL,
  0xaa0ba1aaUL, 0xdc914ddcUL, 0xd58a5fd5UL, 0x060a0c06UL,
  0xc0b575c0UL, 0x7e82fc7eUL, 0xf6ef19f6UL, 0x66aacc66UL,
  0x6cb4d86cUL, 0x8479fd84UL, 0x7193e271UL, 0x38487038UL,
  0xb93e87b9UL, 0x1d273a1dUL, 0x7f81fe7fUL, 0x9d52cf9dUL,
  0x48d89048UL, 0x8b68e38bUL, 0x2a7e542aUL, 0xda9b41daUL,
  0xa51abfa5UL, 0x33556633UL, 0x8273f182UL, 0x394b7239UL,
  0xd68f59d6UL, 0x7888f078UL, 0x867ff986UL, 0xfafb01faUL,
  0xe4d93de4UL, 0x2b7d562bUL, 0xa90ea7a9UL, 0x1e223c1eUL,
  0x896ee789UL, 0x60a0c060UL, 0x6bbdd66bUL, 0xeacb21eaUL,
  0x55ffaa55UL, 0x4cd4984cUL, 0xf7ec1bf7UL, 0xe2d331e2UL,

  0xb1b12697UL, 0xcecea769UL, 0xc3c3b073UL, 0x95954adfUL,
  0x5a5aeeb4UL, 0xadad02afUL, 0xe7e7dc3bUL, 0x02020604UL,
  0x4d4dd79aUL, 0x4444cc88UL, 0xfbfbf803UL, 0x919146d7UL,
  0x0c0c1418UL, 0x87877cfbUL, 0xa1a116b7UL, 0x5050f0a0UL,
  0xcbcba863UL, 0x6767a9ceUL, 0x5454fca8UL, 0xdddd924fUL,
  0x4646ca8cUL, 0x8f8f64ebUL, 0xe1e1d637UL, 0x4e4ed29cUL,
  0xf0f0e515UL, 0xfdfdf20fUL, 0xfcfcf10dUL, 0xebebc823UL,
  0xf9f9fe07UL, 0xc4c4b97dUL, 0x1a1a2e34UL, 0x6e6eb2dcUL,
  0x5e5ee2bcUL, 0xf5f5ea1fUL, 0xcccca16dUL, 0x8d8d62efUL,
  0x1c1c2438UL, 0x5656faacUL, 0x4343c586UL, 0xfefef709UL,
  0x0707090eUL, 0x6161a3c2UL, 0xf8f8fd05UL, 0x75759feaUL,
  0x5959ebb2UL, 0xfffff40bUL, 0x03030506UL, 0x22226644UL,
  0x8a8a6be1UL, 0xd1d18657UL, 0x13133526UL, 0xeeeec729UL,
  0x88886de5UL, 0x00000000UL, 0x0e0e121cUL, 0x34345c68UL,
  0x15153f2aUL, 0x808075f5UL, 0x949449ddUL, 0xe3e3d033UL,
  0xededc22fUL, 0xb5b52a9fUL, 0x5353f5a6UL, 0x23236546UL,
  0x4b4bdd96UL, 0x4747c98eUL, 0x1717392eUL, 0xa7a71cbbUL,
  0x909045d5UL, 0x35355f6aUL, 0xabab08a3UL, 0xd8d89d45UL,
  0xb8b83d85UL, 0xdfdf944bUL, 0x4f4fd19eUL, 0x5757f9aeUL,
  0x9a9a5bc1UL, 0x929243d1UL, 0xdbdb9843UL, 0x1b1b2d36UL,
  0x3c3c4478UL, 0xc8c8ad65UL, 0x99995ec7UL, 0x04040c08UL,
  0x8e8e67e9UL, 0xe0e0d535UL, 0xd7d78c5bUL, 0x7d7d87faUL,
  0x85857affUL, 0xbbbb3883UL, 0x4040c080UL, 0x2c2c7458UL,
  0x3a3a4e74UL, 0x4545cf8aUL, 0xf1f1e617UL, 0x4242c684UL,
  0x6565afcaUL, 0x20206040UL, 0x4141c382UL, 0x18182830UL,
  0x727296e4UL, 0x25256f4aUL, 0x939340d3UL, 0x707090e0UL,
  0x36365a6cUL, 0x05050f0aUL, 0xf2f2e311UL, 0x0b0b1d16UL,
  0xa3a310b3UL, 0x79798bf2UL, 0xececc12dUL, 0x08081810UL,
  0x2727694eUL, 0x31315362UL, 0x32325664UL, 0xb6b62f99UL,
  0x7c7c84f8UL, 0xb0b02595UL, 0x0a0a1e14UL, 0x737395e6UL,
  0x5b5bedb6UL, 0x7b7b8df6UL, 0xb7b72c9bUL, 0x818176f7UL,
  0xd2d28351UL, 0x0d0d171aUL, 0x6a6abed4UL, 0x26266a4cUL,
  0x9e9e57c9UL, 0x5858e8b0UL, 0x9c9c51cdUL, 0x838370f3UL,
  0x74749ce8UL, 0xb3b32093UL, 0xacac01adUL, 0x30305060UL,
  0x7a7a8ef4UL, 0x6969bbd2UL, 0x777799eeUL, 0x0f0f111eUL,
  0xaeae07a9UL, 0x21216342UL, 0xdede9749UL, 0xd0d08555UL,
  0x2e2e725cUL, 0x97974cdbUL, 0x10103020UL, 0xa4a419bdUL,
  0x98985dc5UL, 0xa8a80da5UL, 0xd4d4895dUL, 0x6868b8d0UL,
  0x2d2d775aUL, 0x6262a6c4UL, 0x29297b52UL, 0x6d6db7daUL,
  0x16163a2cUL, 0x4949db92UL, 0x76769aecUL, 0xc7c7bc7bUL,
  0xe8e8cd25UL, 0xc1c1b677UL, 0x96964fd9UL, 0x3737596eUL,
  0xe5e5da3fUL, 0xcacaab61UL, 0xf4f4e91dUL, 0xe9e9ce27UL,
  0x6363a5c6UL, 0x12123624UL, 0xc2c2b371UL, 0xa6a61fb9UL,
  0x14143c28UL, 0xbcbc318dUL, 0xd3d38053UL, 0x28287850UL,
  0xafaf04abUL, 0x2f2f715eUL, 0xe6e6df39UL, 0x24246c48UL,
  0x5252f6a4UL, 0xc6c6bf79UL, 0xa0a015b5UL, 0x09091b12UL,
  0xbdbd328fUL, 0x8c8c61edUL, 0xcfcfa46bUL, 0x5d5de7baUL,
  0x11113322UL, 0x5f5fe1beUL, 0x01010302UL, 0xc5c5ba7fUL,
  0x9f9f54cbUL, 0x3d3d477aUL, 0xa2a213b1UL, 0x9b9b58c3UL,
  0xc9c9ae67UL, 0x3b3b4d76UL, 0xbebe3789UL, 0x5151f3a2UL,
  0x19192b32UL, 0x1f1f213eUL, 0x3f3f417eUL, 0x5c5ce4b8UL,
  0xb2b22391UL, 0xefefc42bUL, 0x4a4ade94UL, 0xcdcda26fUL,
  0xbfbf348bUL, 0xbaba3b81UL, 0x6f6fb1deUL, 0x6464acc8UL,
  0xd9d99e47UL, 0xf3f3e013UL, 0x3e3e427cUL, 0xb4b4299dUL,
  0xaaaa0ba1UL, 0xdcdc914dUL, 0xd5d58a5fUL, 0x06060a0cUL,
  0xc0c0b575UL, 0x7e7e82fcUL, 0xf6f6ef19UL, 0x6666aaccUL,
  0x6c6cb4d8UL, 0x848479fdUL, 0x717193e2UL, 0x38384870UL,
  0xb9b93e87UL, 0x1d1d273aUL, 0x7f7f81feUL, 0x9d9d52cfUL,
  0x4848d890UL, 0x8b8b68e3UL, 0x2a2a7e54UL, 0xdada9b41UL,
  0xa5a51abfUL, 0x33335566UL, 0x828273f1UL, 0x39394b72UL,
  0xd6d68f59UL, 0x787888f0UL, 0x86867ff9UL, 0xfafafb01UL,
  0xe4e4d93dUL, 0x2b2b7d56UL, 0xa9a90ea7UL, 0x1e1e223cUL,
  0x89896ee7UL, 0x6060a0c0UL, 0x6b6bbdd6UL, 0xeaeacb21UL,
  0x5555ffaaUL, 0x4c4cd498UL, 0xf7f7ec1bUL, 0xe2e2d331UL,
};

static const word32 Square_Td[4*256] =
{
  0xe368bc02UL, 0x5585620cUL, 0x2a3f2331UL, 0x61ab13f7UL,
  0x98d46d72UL, 0x21cb9a19UL, 0x3c22a461UL, 0x459d3dcdUL,
  0x05fdb423UL, 0x2bc4075fUL, 0x9b2c01c0UL, 0x3dd9800fUL,
  0x486c5c74UL, 0xf97f7e85UL, 0xf173ab1fUL, 0xb6edde0eUL,
  0x283c6bedUL, 0x4997781aUL, 0x9f2a918dUL, 0xc9579f33UL,
  0xa907a8aaUL, 0xa50ded7dUL, 0x7c422d8fUL, 0x764db0c9UL,
  0x4d91e857UL, 0xcea963ccUL, 0xb4ee96d2UL, 0x3028e1b6UL,
  0x0df161b9UL, 0xbd196726UL, 0x419bad80UL, 0xc0a06ec7UL,
  0x5183f241UL, 0x92dbf034UL, 0x6fa21efcUL, 0x8f32ce4cUL,
  0x13e03373UL, 0x69a7c66dUL, 0xe56d6493UL, 0xbf1a2ffaUL,
  0xbb1cbfb7UL, 0x587403b5UL, 0xe76e2c4fUL, 0x5d89b796UL,
  0xe89c052aUL, 0x446619a3UL, 0x342e71fbUL, 0x0ff22965UL,
  0xfe81827aUL, 0xb11322f1UL, 0xa30835ecUL, 0xcd510f7eUL,
  0xff7aa614UL, 0x5c7293f8UL, 0x2fc29712UL, 0xf370e3c3UL,
  0x992f491cUL, 0xd1431568UL, 0xc2a3261bUL, 0x88cc32b3UL,
  0x8acf7a6fUL, 0xb0e8069fUL, 0x7a47f51eUL, 0xd2bb79daUL,
  0xe6950821UL, 0x4398e55cUL, 0xd0b83106UL, 0x11e37bafUL,
  0x7e416553UL, 0xccaa2b10UL, 0xd8b4e49cUL, 0x6456a7d4UL,
  0xfb7c3659UL, 0x724b2084UL, 0xea9f4df6UL, 0x6a5faadfUL,
  0x2dc1dfceUL, 0x70486858UL, 0xcaaff381UL, 0x0605d891UL,
  0x5a774b69UL, 0x94de28a5UL, 0x39df1042UL, 0x813bc347UL,
  0xfc82caa6UL, 0x23c8d2c5UL, 0x03f86cb2UL, 0x080cd59aUL,
  0xdab7ac40UL, 0x7db909e1UL, 0x3824342cUL, 0xcf5247a2UL,
  0xdcb274d1UL, 0x63a85b2bUL, 0x35d55595UL, 0x479e7511UL,
  0x15e5ebe2UL, 0x4b9430c6UL, 0x4a6f14a8UL, 0x91239c86UL,
  0x4c6acc39UL, 0x5f8aff4aUL, 0x0406904dUL, 0xee99ddbbUL,
  0x1e1152caUL, 0xaaffc418UL, 0xeb646998UL, 0x07fefcffUL,
  0x8b345e01UL, 0x567d0ebeUL, 0xbae79bd9UL, 0x4263c132UL,
  0x75b5dc7bUL, 0x97264417UL, 0x67aecb66UL, 0x95250ccbUL,
  0xec9a9567UL, 0x57862ad0UL, 0x60503799UL, 0xb8e4d305UL,
  0x65ad83baUL, 0x19efae35UL, 0xa4f6c913UL, 0xc15b4aa9UL,
  0x873e1bd6UL, 0xa0f0595eUL, 0x18148a5bUL, 0xaf02703bUL,
  0xab04e076UL, 0xdd4950bfUL, 0xdf4a1863UL, 0xc6a5b656UL,
  0x853d530aUL, 0xfa871237UL, 0x77b694a7UL, 0x4665517fUL,
  0xed61b109UL, 0x1bece6e9UL, 0xd5458525UL, 0xf5753b52UL,
  0x7fba413dUL, 0x27ce4288UL, 0xb2eb4e43UL, 0xd6bde997UL,
  0x527b9ef3UL, 0x62537f45UL, 0x2c3afba0UL, 0x7bbcd170UL,
  0xb91ff76bUL, 0x121b171dUL, 0xfd79eec8UL, 0x3a277cf0UL,
  0x0c0a45d7UL, 0x96dd6079UL, 0x2233f6abUL, 0xacfa1c89UL,
  0xc8acbb5dUL, 0xa10b7d30UL, 0xd4bea14bUL, 0xbee10b94UL,
  0x25cd0a54UL, 0x547e4662UL, 0xa2f31182UL, 0x17e6a33eUL,
  0x263566e6UL, 0xc3580275UL, 0x83388b9bUL, 0x7844bdc2UL,
  0x020348dcUL, 0x4f92a08bUL, 0x2e39b37cUL, 0x4e6984e5UL,
  0xf0888f71UL, 0x362d3927UL, 0x9cd2fd3fUL, 0x01fb246eUL,
  0x893716ddUL, 0x00000000UL, 0xf68d57e0UL, 0xe293986cUL,
  0x744ef815UL, 0x9320d45aUL, 0xad0138e7UL, 0xd3405db4UL,
  0x1a17c287UL, 0xb3106a2dUL, 0x5078d62fUL, 0xf48e1f3cUL,
  0xa70ea5a1UL, 0x71b34c36UL, 0x9ad725aeUL, 0x5e71db24UL,
  0x161d8750UL, 0xef62f9d5UL, 0x8d318690UL, 0x1c121a16UL,
  0xa6f581cfUL, 0x5b8c6f07UL, 0x37d61d49UL, 0x6e593a92UL,
  0x84c67764UL, 0x86c53fb8UL, 0xd746cdf9UL, 0xe090d0b0UL,
  0x29c74f83UL, 0xe49640fdUL, 0x0e090d0bUL, 0x6da15620UL,
  0x8ec9ea22UL, 0xdb4c882eUL, 0xf776738eUL, 0xb515b2bcUL,
  0x10185fc1UL, 0x322ba96aUL, 0x6ba48eb1UL, 0xaef95455UL,
  0x406089eeUL, 0x6655ef08UL, 0xe9672144UL, 0x3e21ecbdUL,
  0x2030be77UL, 0xf28bc7adUL, 0x80c0e729UL, 0x141ecf8cUL,
  0xbce24348UL, 0xc4a6fe8aUL, 0x31d3c5d8UL, 0xb716fa60UL,
  0x5380ba9dUL, 0xd94fc0f2UL, 0x1de93e78UL, 0x24362e3aUL,
  0xe16bf4deUL, 0xcb54d7efUL, 0x09f7f1f4UL, 0x82c3aff5UL,
  0x0bf4b928UL, 0x9d29d951UL, 0xc75e9238UL, 0xf8845aebUL,
  0x90d8b8e8UL, 0xdeb13c0dUL, 0x33d08d04UL, 0x685ce203UL,
  0xc55ddae4UL, 0x3bdc589eUL, 0x0a0f9d46UL, 0x3fdac8d3UL,
  0x598f27dbUL, 0xa8fc8cc4UL, 0x79bf99acUL, 0x6c5a724eUL,
  0x8ccaa2feUL, 0x9ed1b5e3UL, 0x1fea76a4UL, 0x73b004eaUL,

  0x02e368bcUL, 0x0c558562UL, 0x312a3f23UL, 0xf761ab13UL,
  0x7298d46dUL, 0x1921cb9aUL, 0x613c22a4UL, 0xcd459d3dUL,
  0x2305fdb4UL, 0x5f2bc407UL, 0xc09b2c01UL, 0x0f3dd980UL,
  0x74486c5cUL, 0x85f97f7eUL, 0x1ff173abUL, 0x0eb6eddeUL,
  0xed283c6bUL, 0x1a499778UL, 0x8d9f2a91UL, 0x33c9579fUL,
  0xaaa907a8UL, 0x7da50dedUL, 0x8f7c422dUL, 0xc9764db0UL,
  0x574d91e8UL, 0xcccea963UL, 0xd2b4ee96UL, 0xb63028e1UL,
  0xb90df161UL, 0x26bd1967UL, 0x80419badUL, 0xc7c0a06eUL,
  0x415183f2UL, 0x3492dbf0UL, 0xfc6fa21eUL, 0x4c8f32ceUL,
  0x7313e033UL, 0x6d69a7c6UL, 0x93e56d64UL, 0xfabf1a2fUL,
  0xb7bb1cbfUL, 0xb5587403UL, 0x4fe76e2cUL, 0x965d89b7UL,
  0x2ae89c05UL, 0xa3446619UL, 0xfb342e71UL, 0x650ff229UL,
  0x7afe8182UL, 0xf1b11322UL, 0xeca30835UL, 0x7ecd510fUL,
  0x14ff7aa6UL, 0xf85c7293UL, 0x122fc297UL, 0xc3f370e3UL,
  0x1c992f49UL, 0x68d14315UL, 0x1bc2a326UL, 0xb388cc32UL,
  0x6f8acf7aUL, 0x9fb0e806UL, 0x1e7a47f5UL, 0xdad2bb79UL,
  0x21e69508UL, 0x5c4398e5UL, 0x06d0b831UL, 0xaf11e37bUL,
  0x537e4165UL, 0x10ccaa2bUL, 0x9cd8b4e4UL, 0xd46456a7UL,
  0x59fb7c36UL, 0x84724b20UL, 0xf6ea9f4dUL, 0xdf6a5faaUL,
  0xce2dc1dfUL, 0x58704868UL, 0x81caaff3UL, 0x910605d8UL,
  0x695a774bUL, 0xa594de28UL, 0x4239df10UL, 0x47813bc3UL,
  0xa6fc82caUL, 0xc523c8d2UL, 0xb203f86cUL, 0x9a080cd5UL,
  0x40dab7acUL, 0xe17db909UL, 0x2c382434UL, 0xa2cf5247UL,
  0xd1dcb274UL, 0x2b63a85bUL, 0x9535d555UL, 0x11479e75UL,
  0xe215e5ebUL, 0xc64b9430UL, 0xa84a6f14UL, 0x8691239cUL,
  0x394c6accUL, 0x4a5f8affUL, 0x4d040690UL, 0xbbee99ddUL,
  0xca1e1152UL, 0x18aaffc4UL, 0x98eb6469UL, 0xff07fefcUL,
  0x018b345eUL, 0xbe567d0eUL, 0xd9bae79bUL, 0x324263c1UL,
  0x7b75b5dcUL, 0x17972644UL, 0x6667aecbUL, 0xcb95250cUL,
  0x67ec9a95UL, 0xd057862aUL, 0x99605037UL, 0x05b8e4d3UL,
  0xba65ad83UL, 0x3519efaeUL, 0x13a4f6c9UL, 0xa9c15b4aUL,
  0xd6873e1bUL, 0x5ea0f059UL, 0x5b18148aUL, 0x3baf0270UL,
  0x76ab04e0UL, 0xbfdd4950UL, 0x63df4a18UL, 0x56c6a5b6UL,
  0x0a853d53UL, 0x37fa8712UL, 0xa777b694UL, 0x7f466551UL,
  0x09ed61b1UL, 0xe91bece6UL, 0x25d54585UL, 0x52f5753bUL,
  0x3d7fba41UL, 0x8827ce42UL, 0x43b2eb4eUL, 0x97d6bde9UL,
  0xf3527b9eUL, 0x4562537fUL, 0xa02c3afbUL, 0x707bbcd1UL,
  0x6bb91ff7UL, 0x1d121b17UL, 0xc8fd79eeUL, 0xf03a277cUL,
  0xd70c0a45UL, 0x7996dd60UL, 0xab2233f6UL, 0x89acfa1cUL,
  0x5dc8acbbUL, 0x30a10b7dUL, 0x4bd4bea1UL, 0x94bee10bUL,
  0x5425cd0aUL, 0x62547e46UL, 0x82a2f311UL, 0x3e17e6a3UL,
  0xe6263566UL, 0x75c35802UL, 0x9b83388bUL, 0xc27844bdUL,
  0xdc020348UL, 0x8b4f92a0UL, 0x7c2e39b3UL, 0xe54e6984UL,
  0x71f0888fUL, 0x27362d39UL, 0x3f9cd2fdUL, 0x6e01fb24UL,
  0xdd893716UL, 0x00000000UL, 0xe0f68d57UL, 0x6ce29398UL,
  0x15744ef8UL, 0x5a9320d4UL, 0xe7ad0138UL, 0xb4d3405dUL,
  0x871a17c2UL, 0x2db3106aUL, 0x2f5078d6UL, 0x3cf48e1fUL,
  0xa1a70ea5UL, 0x3671b34cUL, 0xae9ad725UL, 0x245e71dbUL,
  0x50161d87UL, 0xd5ef62f9UL, 0x908d3186UL, 0x161c121aUL,
  0xcfa6f581UL, 0x075b8c6fUL, 0x4937d61dUL, 0x926e593aUL,
  0x6484c677UL, 0xb886c53fUL, 0xf9d746cdUL, 0xb0e090d0UL,
  0x8329c74fUL, 0xfde49640UL, 0x0b0e090dUL, 0x206da156UL,
  0x228ec9eaUL, 0x2edb4c88UL, 0x8ef77673UL, 0xbcb515b2UL,
  0xc110185fUL, 0x6a322ba9UL, 0xb16ba48eUL, 0x55aef954UL,
  0xee406089UL, 0x086655efUL, 0x44e96721UL, 0xbd3e21ecUL,
  0x772030beUL, 0xadf28bc7UL, 0x2980c0e7UL, 0x8c141ecfUL,
  0x48bce243UL, 0x8ac4a6feUL, 0xd831d3c5UL, 0x60b716faUL,
  0x9d5380baUL, 0xf2d94fc0UL, 0x781de93eUL, 0x3a24362eUL,
  0xdee16bf4UL, 0xefcb54d7UL, 0xf409f7f1UL, 0xf582c3afUL,
  0x280bf4b9UL, 0x519d29d9UL, 0x38c75e92UL, 0xebf8845aUL,
  0xe890d8b8UL, 0x0ddeb13cUL, 0x0433d08dUL, 0x03685ce2UL,
  0xe4c55ddaUL, 0x9e3bdc58UL, 0x460a0f9dUL, 0xd33fdac8UL,
  0xdb598f27UL, 0xc4a8fc8cUL, 0xac79bf99UL, 0x4e6c5a72UL,
  0xfe8ccaa2UL, 0xe39ed1b5UL, 0xa41fea76UL, 0xea73b004UL,

  0xbc02e368UL, 0x620c5585UL, 0x23312a3fUL, 0x13f761abUL,
  0x6d7298d4UL, 0x9a1921cbUL, 0xa4613c22UL, 0x3dcd459dUL,
  0xb42305fdUL, 0x075f2bc4UL, 0x01c09b2cUL, 0x800f3dd9UL,
  0x5c74486cUL, 0x7e85f97fUL, 0xab1ff173UL, 0xde0eb6edUL,
  0x6bed283cUL, 0x781a4997UL, 0x918d9f2aUL, 0x9f33c957UL,
  0xa8aaa907UL, 0xed7da50dUL, 0x2d8f7c42UL, 0xb0c9764dUL,
  0xe8574d91UL, 0x63cccea9UL, 0x96d2b4eeUL, 0xe1b63028UL,
  0x61b90df1UL, 0x6726bd19UL, 0xad80419bUL, 0x6ec7c0a0UL,
  0xf2415183UL, 0xf03492dbUL, 0x1efc6fa2UL, 0xce4c8f32UL,
  0x337313e0UL, 0xc66d69a7UL, 0x6493e56dUL, 0x2ffabf1aUL,
  0xbfb7bb1cUL, 0x03b55874UL, 0x2c4fe76eUL, 0xb7965d89UL,
  0x052ae89cUL, 0x19a34466UL, 0x71fb342eUL, 0x29650ff2UL,
  0x827afe81UL, 0x22f1b113UL, 0x35eca308UL, 0x0f7ecd51UL,
  0xa614ff7aUL, 0x93f85c72UL, 0x97122fc2UL, 0xe3c3f370UL,
  0x491c992fUL, 0x1568d143UL, 0x261bc2a3UL, 0x32b388ccUL,
  0x7a6f8acfUL, 0x069fb0e8UL, 0xf51e7a47UL, 0x79dad2bbUL,
  0x0821e695UL, 0xe55c4398UL, 0x3106d0b8UL, 0x7baf11e3UL,
  0x65537e41UL, 0x2b10ccaaUL, 0xe49cd8b4UL, 0xa7d46456UL,
  0x3659fb7cUL, 0x2084724bUL, 0x4df6ea9fUL, 0xaadf6a5fUL,
  0xdfce2dc1UL, 0x68587048UL, 0xf381caafUL, 0xd8910605UL,
  0x4b695a77UL, 0x28a594deUL, 0x104239dfUL, 0xc347813bUL,
  0xcaa6fc82UL, 0xd2c523c8UL, 0x6cb203f8UL, 0xd59a080cUL,
  0xac40dab7UL, 0x09e17db9UL, 0x342c3824UL, 0x47a2cf52UL,
  0x74d1dcb2UL, 0x5b2b63a8UL, 0x559535d5UL, 0x7511479eUL,
  0xebe215e5UL, 0x30c64b94UL, 0x14a84a6fUL, 0x9c869123UL,
  0xcc394c6aUL, 0xff4a5f8aUL, 0x904d0406UL, 0xddbbee99UL,
  0x52ca1e11UL, 0xc418aaffUL, 0x6998eb64UL, 0xfcff07feUL,
  0x5e018b34UL, 0x0ebe567dUL, 0x9bd9bae7UL, 0xc1324263UL,
  0xdc7b75b5UL, 0x44179726UL, 0xcb6667aeUL, 0x0ccb9525UL,
  0x9567ec9aUL, 0x2ad05786UL, 0x37996050UL, 0xd305b8e4UL,
  0x83ba65adUL, 0xae3519efUL, 0xc913a4f6UL, 0x4aa9c15bUL,
  0x1bd6873eUL, 0x595ea0f0UL, 0x8a5b1814UL, 0x703baf02UL,
  0xe076ab04UL, 0x50bfdd49UL, 0x1863df4aUL, 0xb656c6a5UL,
  0x530a853dUL, 0x1237fa87UL, 0x94a777b6UL, 0x517f4665UL,
  0xb109ed61UL, 0xe6e91becUL, 0x8525d545UL, 0x3b52f575UL,
  0x413d7fbaUL, 0x428827ceUL, 0x4e43b2ebUL, 0xe997d6bdUL,
  0x9ef3527bUL, 0x7f456253UL, 0xfba02c3aUL, 0xd1707bbcUL,
  0xf76bb91fUL, 0x171d121bUL, 0xeec8fd79UL, 0x7cf03a27UL,
  0x45d70c0aUL, 0x607996ddUL, 0xf6ab2233UL, 0x1c89acfaUL,
  0xbb5dc8acUL, 0x7d30a10bUL, 0xa14bd4beUL, 0x0b94bee1UL,
  0x0a5425cdUL, 0x4662547eUL, 0x1182a2f3UL, 0xa33e17e6UL,
  0x66e62635UL, 0x0275c358UL, 0x8b9b8338UL, 0xbdc27844UL,
  0x48dc0203UL, 0xa08b4f92UL, 0xb37c2e39UL, 0x84e54e69UL,
  0x8f71f088UL, 0x3927362dUL, 0xfd3f9cd2UL, 0x246e01fbUL,
  0x16dd8937UL, 0x00000000UL, 0x57e0f68dUL, 0x986ce293UL,
  0xf815744eUL, 0xd45a9320UL, 0x38e7ad01UL, 0x5db4d340UL,
  0xc2871a17UL, 0x6a2db310UL, 0xd62f5078UL, 0x1f3cf48eUL,
  0xa5a1a70eUL, 0x4c3671b3UL, 0x25ae9ad7UL, 0xdb245e71UL,
  0x8750161dUL, 0xf9d5ef62UL, 0x86908d31UL, 0x1a161c12UL,
  0x81cfa6f5UL, 0x6f075b8cUL, 0x1d4937d6UL, 0x3a926e59UL,
  0x776484c6UL, 0x3fb886c5UL, 0xcdf9d746UL, 0xd0b0e090UL,
  0x4f8329c7UL, 0x40fde496UL, 0x0d0b0e09UL, 0x56206da1UL,
  0xea228ec9UL, 0x882edb4cUL, 0x738ef776UL, 0xb2bcb515UL,
  0x5fc11018UL, 0xa96a322bUL, 0x8eb16ba4UL, 0x5455aef9UL,
  0x89ee4060UL, 0xef086655UL, 0x2144e967UL, 0xecbd3e21UL,
  0xbe772030UL, 0xc7adf28bUL, 0xe72980c0UL, 0xcf8c141eUL,
  0x4348bce2UL, 0xfe8ac4a6UL, 0xc5d831d3UL, 0xfa60b716UL,
  0xba9d5380UL, 0xc0f2d94fUL, 0x3e781de9UL, 0x2e3a2436UL,
  0xf4dee16bUL, 0xd7efcb54UL, 0xf1f409f7UL, 0xaff582c3UL,
  0xb9280bf4UL, 0xd9519d29UL, 0x9238c75eUL, 0x5aebf884UL,
  0xb8e890d8UL, 0x3c0ddeb1UL, 0x8d0433d0UL, 0xe203685cUL,
  0xdae4c55dUL, 0x589e3bdcUL, 0x9d460a0fUL, 0xc8d33fdaUL,
  0x27db598fUL, 0x8cc4a8fcUL, 0x99ac79bfUL, 0x724e6c5aUL,
  0xa2fe8ccaUL, 0xb5e39ed1UL, 0x76a41feaUL, 0x04ea73b0UL,

  0x68bc02e3UL, 0x85620c55UL, 0x3f23312aUL, 0xab13f761UL,
  0xd46d7298UL, 0xcb9a1921UL, 0x22a4613cUL, 0x9d3dcd45UL,
  0xfdb42305UL, 0xc4075f2bUL, 0x2c01c09bUL, 0xd9800f3dUL,
  0x6c5c7448UL, 0x7f7e85f9UL, 0x73ab1ff1UL, 0xedde0eb6UL,
  0x3c6bed28UL, 0x97781a49UL, 0x2a918d9fUL, 0x579f33c9UL,
  0x07a8aaa9UL, 0x0ded7da5UL, 0x422d8f7cUL, 0x4db0c976UL,
  0x91e8574dUL, 0xa963ccceUL, 0xee96d2b4UL, 0x28e1b630UL,
  0xf161b90dUL, 0x196726bdUL, 0x9bad8041UL, 0xa06ec7c0UL,
  0x83f24151UL, 0xdbf03492UL, 0xa21efc6fUL, 0x32ce4c8fUL,
  0xe0337313UL, 0xa7c66d69UL, 0x6d6493e5UL, 0x1a2ffabfUL,
  0x1cbfb7bbUL, 0x7403b558UL, 0x6e2c4fe7UL, 0x89b7965dUL,
  0x9c052ae8UL, 0x6619a344UL, 0x2e71fb34UL, 0xf229650fUL,
  0x81827afeUL, 0x1322f1b1UL, 0x0835eca3UL, 0x510f7ecdUL,
  0x7aa614ffUL, 0x7293f85cUL, 0xc297122fUL, 0x70e3c3f3UL,
  0x2f491c99UL, 0x431568d1UL, 0xa3261bc2UL, 0xcc32b388UL,
  0xcf7a6f8aUL, 0xe8069fb0UL, 0x47f51e7aUL, 0xbb79dad2UL,
  0x950821e6UL, 0x98e55c43UL, 0xb83106d0UL, 0xe37baf11UL,
  0x4165537eUL, 0xaa2b10ccUL, 0xb4e49cd8UL, 0x56a7d464UL,
  0x7c3659fbUL, 0x4b208472UL, 0x9f4df6eaUL, 0x5faadf6aUL,
  0xc1dfce2dUL, 0x48685870UL, 0xaff381caUL, 0x05d89106UL,
  0x774b695aUL, 0xde28a594UL, 0xdf104239UL, 0x3bc34781UL,
  0x82caa6fcUL, 0xc8d2c523UL, 0xf86cb203UL, 0x0cd59a08UL,
  0xb7ac40daUL, 0xb909e17dUL, 0x24342c38UL, 0x5247a2cfUL,
  0xb274d1dcUL, 0xa85b2b63UL, 0xd5559535UL, 0x9e751147UL,
  0xe5ebe215UL, 0x9430c64bUL, 0x6f14a84aUL, 0x239c8691UL,
  0x6acc394cUL, 0x8aff4a5fUL, 0x06904d04UL, 0x99ddbbeeUL,
  0x1152ca1eUL, 0xffc418aaUL, 0x646998ebUL, 0xfefcff07UL,
  0x345e018bUL, 0x7d0ebe56UL, 0xe79bd9baUL, 0x63c13242UL,
  0xb5dc7b75UL, 0x26441797UL, 0xaecb6667UL, 0x250ccb95UL,
  0x9a9567ecUL, 0x862ad057UL, 0x50379960UL, 0xe4d305b8UL,
  0xad83ba65UL, 0xefae3519UL, 0xf6c913a4UL, 0x5b4aa9c1UL,
  0x3e1bd687UL, 0xf0595ea0UL, 0x148a5b18UL, 0x02703bafUL,
  0x04e076abUL, 0x4950bfddUL, 0x4a1863dfUL, 0xa5b656c6UL,
  0x3d530a85UL, 0x871237faUL, 0xb694a777UL, 0x65517f46UL,
  0x61b109edUL, 0xece6e91bUL, 0x458525d5UL, 0x753b52f5UL,
  0xba413d7fUL, 0xce428827UL, 0xeb4e43b2UL, 0xbde997d6UL,
  0x7b9ef352UL, 0x537f4562UL, 0x3afba02cUL, 0xbcd1707bUL,
  0x1ff76bb9UL, 0x1b171d12UL, 0x79eec8fdUL, 0x277cf03aUL,
  0x0a45d70cUL, 0xdd607996UL, 0x33f6ab22UL, 0xfa1c89acUL,
  0xacbb5dc8UL, 0x0b7d30a1UL, 0xbea14bd4UL, 0xe10b94beUL,
  0xcd0a5425UL, 0x7e466254UL, 0xf31182a2UL, 0xe6a33e17UL,
  0x3566e626UL, 0x580275c3UL, 0x388b9b83UL, 0x44bdc278UL,
  0x0348dc02UL, 0x92a08b4fUL, 0x39b37c2eUL, 0x6984e54eUL,
  0x888f71f0UL, 0x2d392736UL, 0xd2fd3f9cUL, 0xfb246e01UL,
  0x3716dd89UL, 0x00000000UL, 0x8d57e0f6UL, 0x93986ce2UL,
  0x4ef81574UL, 0x20d45a93UL, 0x0138e7adUL, 0x405db4d3UL,
  0x17c2871aUL, 0x106a2db3UL, 0x78d62f50UL, 0x8e1f3cf4UL,
  0x0ea5a1a7UL, 0xb34c3671UL, 0xd725ae9aUL, 0x71db245eUL,
  0x1d875016UL, 0x62f9d5efUL, 0x3186908dUL, 0x121a161cUL,
  0xf581cfa6UL, 0x8c6f075bUL, 0xd61d4937UL, 0x593a926eUL,
  0xc6776484UL, 0xc53fb886UL, 0x46cdf9d7UL, 0x90d0b0e0UL,
  0xc74f8329UL, 0x9640fde4UL, 0x090d0b0eUL, 0xa156206dUL,
  0xc9ea228eUL, 0x4c882edbUL, 0x76738ef7UL, 0x15b2bcb5UL,
  0x185fc110UL, 0x2ba96a32UL, 0xa48eb16bUL, 0xf95455aeUL,
  0x6089ee40UL, 0x55ef0866UL, 0x672144e9UL, 0x21ecbd3eUL,
  0x30be7720UL, 0x8bc7adf2UL, 0xc0e72980UL, 0x1ecf8c14UL,
  0xe24348bcUL, 0xa6fe8ac4UL, 0xd3c5d831UL, 0x16fa60b7UL,
  0x80ba9d53UL, 0x4fc0f2d9UL, 0xe93e781dUL, 0x362e3a24UL,
  0x6bf4dee1UL, 0x54d7efcbUL, 0xf7f1f409UL, 0xc3aff582UL,
  0xf4b9280bUL, 0x29d9519dUL, 0x5e9238c7UL, 0x845aebf8UL,
  0xd8b8e890UL, 0xb13c0ddeUL, 0xd08d0433UL, 0x5ce20368UL,
  0x5ddae4c5UL, 0xdc589e3bUL, 0x0f9d460aUL, 0xdac8d33fUL,
  0x8f27db59UL, 0xfc8cc4a8UL, 0xbf99ac79UL, 0x5a724e6cUL,
  0xcaa2fe8cUL, 0xd1b5e39eUL, 0xea76a41fUL, 0xb004ea73UL,
};
//-----------------
static const byte SKIPJACK_fTable[256] =
{
  0xa3,0xd7,0x09,0x83,0xf8,0x48,0xf6,0xf4,0xb3,0x21,0x15,0x78,0x99,0xb1,0xaf,0xf9,
  0xe7,0x2d,0x4d,0x8a,0xce,0x4c,0xca,0x2e,0x52,0x95,0xd9,0x1e,0x4e,0x38,0x44,0x28,
  0x0a,0xdf,0x02,0xa0,0x17,0xf1,0x60,0x68,0x12,0xb7,0x7a,0xc3,0xe9,0xfa,0x3d,0x53,
  0x96,0x84,0x6b,0xba,0xf2,0x63,0x9a,0x19,0x7c,0xae,0xe5,0xf5,0xf7,0x16,0x6a,0xa2,
  0x39,0xb6,0x7b,0x0f,0xc1,0x93,0x81,0x1b,0xee,0xb4,0x1a,0xea,0xd0,0x91,0x2f,0xb8,
  0x55,0xb9,0xda,0x85,0x3f,0x41,0xbf,0xe0,0x5a,0x58,0x80,0x5f,0x66,0x0b,0xd8,0x90,
  0x35,0xd5,0xc0,0xa7,0x33,0x06,0x65,0x69,0x45,0x00,0x94,0x56,0x6d,0x98,0x9b,0x76,
  0x97,0xfc,0xb2,0xc2,0xb0,0xfe,0xdb,0x20,0xe1,0xeb,0xd6,0xe4,0xdd,0x47,0x4a,0x1d,
  0x42,0xed,0x9e,0x6e,0x49,0x3c,0xcd,0x43,0x27,0xd2,0x07,0xd4,0xde,0xc7,0x67,0x18,
  0x89,0xcb,0x30,0x1f,0x8d,0xc6,0x8f,0xaa,0xc8,0x74,0xdc,0xc9,0x5d,0x5c,0x31,0xa4,
  0x70,0x88,0x61,0x2c,0x9f,0x0d,0x2b,0x87,0x50,0x82,0x54,0x64,0x26,0x7d,0x03,0x40,
  0x34,0x4b,0x1c,0x73,0xd1,0xc4,0xfd,0x3b,0xcc,0xfb,0x7f,0xab,0xe6,0x3e,0x5b,0xa5,
  0xad,0x04,0x23,0x9c,0x14,0x51,0x22,0xf0,0x29,0x79,0x71,0x7e,0xff,0x8c,0x0e,0xe2,
  0x0c,0xef,0xbc,0x72,0x75,0x6f,0x37,0xa1,0xec,0xd3,0x8e,0x62,0x8b,0x86,0x10,0xe8,
  0x08,0x77,0x11,0xbe,0x92,0x4f,0x24,0xc5,0x32,0x36,0x9d,0xcf,0xf3,0xa6,0xbb,0xac,
  0x5e,0x6c,0xa9,0x13,0x57,0x25,0xb5,0xe3,0xbd,0xa8,0x3a,0x01,0x05,0x59,0x2a,0x46
};
//-----------------
static const byte Square_Se_or_SHARK_enc_sbox[256] =
{
  177, 206, 195, 149,  90, 173, 231,   2,  77,  68, 251, 145,  12, 135, 161,  80,
  203, 103,  84, 221,  70, 143, 225,  78, 240, 253, 252, 235, 249, 196,  26, 110,
   94, 245, 204, 141,  28,  86,  67, 254,   7,  97, 248, 117,  89, 255,   3,  34,
  138, 209,  19, 238, 136,   0,  14,  52,  21, 128, 148, 227, 237, 181,  83,  35,
   75,  71,  23, 167, 144,  53, 171, 216, 184, 223,  79,  87, 154, 146, 219,  27,
   60, 200, 153,   4, 142, 224, 215, 125, 133, 187,  64,  44,  58,  69, 241,  66,
  101,  32,  65,  24, 114,  37, 147, 112,  54,   5, 242,  11, 163, 121, 236,   8,
   39,  49,  50, 182, 124, 176,  10, 115,  91, 123, 183, 129, 210,  13, 106,  38,
  158,  88, 156, 131, 116, 179, 172,  48, 122, 105, 119,  15, 174,  33, 222, 208,
   46, 151,  16, 164, 152, 168, 212, 104,  45,  98,  41, 109,  22,  73, 118, 199,
  232, 193, 150,  55, 229, 202, 244, 233,  99,  18, 194, 166,  20, 188, 211,  40,
  175,  47, 230,  36,  82, 198, 160,   9, 189, 140, 207,  93,  17,  95,   1, 197,
  159,  61, 162, 155, 201,  59, 190,  81,  25,  31,  63,  92, 178, 239,  74, 205,
  191, 186, 111, 100, 217, 243,  62, 180, 170, 220, 213,   6, 192, 126, 246, 102,
  108, 132, 113,  56, 185,  29, 127, 157,  72, 139,  42, 218, 165,  51, 130,  57,
  214, 120, 134, 250, 228,  43, 169,  30, 137,  96, 107, 234,  85,  76, 247, 226,
};

static const byte Square_Sd_or_SHARK_dec_sbox[256] =
{
   53, 190,   7,  46,  83, 105, 219,  40, 111, 183, 118, 107,  12, 125,  54, 139,
  146, 188, 169,  50, 172,  56, 156,  66,  99, 200,  30,  79,  36, 229, 247, 201,
   97, 141,  47,  63, 179, 101, 127, 112, 175, 154, 234, 245,  91, 152, 144, 177,
  135, 113, 114, 237,  55,  69, 104, 163, 227, 239,  92, 197,  80, 193, 214, 202,
   90,  98,  95,  38,   9,  93,  20,  65, 232, 157, 206,  64, 253,   8,  23,  74,
   15, 199, 180,  62,  18, 252,  37,  75, 129,  44,   4, 120, 203, 187,  32, 189,
  249,  41, 153, 168, 211,  96, 223,  17, 151, 137, 126, 250, 224, 155,  31, 210,
  103, 226, 100, 119, 132,  43, 158, 138, 241, 109, 136, 121, 116,  87, 221, 230,
   57, 123, 238, 131, 225,  88, 242,  13,  52, 248,  48, 233, 185,  35,  84,  21,
   68,  11,  77, 102,  58,   3, 162, 145, 148,  82,  76, 195, 130, 231, 128, 192,
  182,  14, 194, 108, 147, 236, 171,  67, 149, 246, 216,  70, 134,   5, 140, 176,
  117,   0, 204, 133, 215,  61, 115, 122,  72, 228, 209,  89, 173, 184, 198, 208,
  220, 161, 170,   2,  29, 191, 181, 159,  81, 196, 165,  16,  34, 207,   1, 186,
  143,  49, 124, 174, 150, 218, 240,  86,  71, 212, 235,  78, 217,  19, 142,  73,
   85,  22, 255,  59, 244, 164, 178,   6, 160, 167, 251,  27, 110,  60,  51, 205,
   24,  94, 106, 213, 166,  33, 222, 254,  42,  28, 243,  10,  26,  25,  39,  45,
};

static const word64 SHARK_enc_cbox[8*256] =
{
/* box 0 */
W64LIT(0x060d838f16f3a365),
W64LIT(0xa68857ee5cae56f6),
W64LIT(0xebf516353c2c4d89),
W64LIT(0x652174be88e85bdc),
W64LIT(0x0d4e9a8086c17921),
W64LIT(0x27ba7d33cffa58a1),
W64LIT(0x88d9e104a237b530),
W64LIT(0x693b8755a4fbe816),
W64LIT(0xdac9591826b254a0),
W64LIT(0x45c2e369fb336af3),
W64LIT(0xa96e1fb87b3e4ef4),
W64LIT(0xb7578f1435eb7ef0),
W64LIT(0x839af80b32056f74),
W64LIT(0xae37f55cc71f277a),
W64LIT(0xa4208538fdff37d5),
W64LIT(0x35991e74ad3cdb6f),
W64LIT(0xba191594b32a07d1),
W64LIT(0x5344d1772e572b7b),
W64LIT(0xe7efe5de103ffe43),
W64LIT(0xa3796fdc41de5e5b),
W64LIT(0x2cf9643c5fc882e5),
W64LIT(0xffdbf6fd48196d22),
W64LIT(0x33949dfbbbcf780a),
W64LIT(0x7d15679dd0cec8bd),
W64LIT(0x5f5e229c024498b1),
W64LIT(0x1223634762c683ce),
W64LIT(0xdcc4da973041f7c5),
W64LIT(0x0b43190f9032da44),
W64LIT(0xc05598eddfc5a6e2),
W64LIT(0x9e5fd31a7753f4b8),
W64LIT(0x9afa8243c0f136fe),
W64LIT(0xcc4f6b06f3d61528),
W64LIT(0xdf38612a3bc25c0d),
W64LIT(0x43cf60e6edc0c996),
W64LIT(0xcfb3d0bbf855bee0),
W64LIT(0x96e071a8ece28534),
W64LIT(0x21b7febcd909fbc4),
W64LIT(0x8ed4628bb4c41655),
W64LIT(0x30682646b04cd3c2),
W64LIT(0xb5ff5dc294ba1fd3),
W64LIT(0x75aac52f4b7fb931),
W64LIT(0xe809ad8837afe641),
W64LIT(0x0eb2213d8d42d2e9),
W64LIT(0x9852509561a057dd),
W64LIT(0xaa92a40570bde53c),
W64LIT(0x7b18e412c63d6bd8),
W64LIT(0xa7dc3e85f67c9c1d),
W64LIT(0xd8618bce87e33583),
W64LIT(0xe34ab487a79d3c05),
W64LIT(0x20e397d773db312f),
W64LIT(0x05f138321d7008ad),
W64LIT(0x17d25b757fb68b63),
W64LIT(0x8a7133d20366d413),
W64LIT(0x0000000000000000),
W64LIT(0xeaa17f5e96fe8762),
W64LIT(0xc101f18675176c09),
W64LIT(0xbebc44cd0488c597),
W64LIT(0xdb9d30738c609e4b),
W64LIT(0xabc6cd6eda6f2fd7),
W64LIT(0x5aaf1aae1f34901c),
W64LIT(0xb00e65f089ca177e),
W64LIT(0xd47b7825abf08649),
W64LIT(0x924520f15b404772),
W64LIT(0x1686321ed5644188),
W64LIT(0x618425e73f4a999a),
W64LIT(0xe21eddec0d4ff6ee),
W64LIT(0xd787c398a0732d81),
W64LIT(0x1f6df9c7e407faef),
W64LIT(0x79b036c4676c0afb),
W64LIT(0x0fe6485627901802),
W64LIT(0x9cf701ccd602959b),
W64LIT(0xbfe82da6ae5a0f7c),
W64LIT(0x990639fecb729d36),
W64LIT(0xca42e889e525b64d),
W64LIT(0xb3f2de4d8249bcb6),
W64LIT(0x4033db5be643625e),
W64LIT(0x4167b2304c91a8b5),
W64LIT(0x108bb191c397e2ed),
W64LIT(0x1834132358269361),
W64LIT(0x541d3b93927642f5),
W64LIT(0x90edf227fa112651),
W64LIT(0x1dc52b1145569bcc),
W64LIT(0xe6bb8cb5baed34a8),
W64LIT(0xd276fbaabd03252c),
W64LIT(0x313c4f2d1a9e1929),
W64LIT(0xfd73242be9480c01),
W64LIT(0x9baeeb286a23fc15),
W64LIT(0xc9be5334eea61d85),
W64LIT(0xc70c720963e4cf6c),
W64LIT(0x3eda077b3d0e012b),
W64LIT(0x97b418c346304fdf),
W64LIT(0x32c0f490111db2e1),
W64LIT(0x2ba08ed8e3e9eb6b),
W64LIT(0x8b255ab9a9b41ef8),
W64LIT(0x91b99b4c50c3ecba),
W64LIT(0xfe8f9f96e2cba7c9),
W64LIT(0x3a7f56228aacc36d),
W64LIT(0xb15a0c9b2318dd95),
W64LIT(0x5953a11314b73bd4),
W64LIT(0xf3c10516640adee8),
W64LIT(0xedf895ba2adfeeec),
W64LIT(0xadcb4ee1cc9c8cb2),
W64LIT(0xde6c0841911096e6),
W64LIT(0x84c312ef8e2406fa),
W64LIT(0xa83a76d3d1ec841f),
W64LIT(0x1c91427aef845127),
W64LIT(0x3665a5c9a6bf70a7),
W64LIT(0xf6303d24797ad645),
W64LIT(0xcd1b026d5904dfc3),
W64LIT(0x1bc8a89e53a538a9),
W64LIT(0x7ee9dc20db4d6375),
W64LIT(0x51ec03a18f064a58),
W64LIT(0xc4f0c9b4686764a4),
W64LIT(0xdd90b3fc9a933d2e),
W64LIT(0x7a4c8d796cefa133),
W64LIT(0x73a746a05d8c1a54),
W64LIT(0x0759eae4bc21698e),
W64LIT(0xc8ea3a5f4474d76e),
W64LIT(0x38d784f42bfda24e),
W64LIT(0x231f2c6a78589ae7),
W64LIT(0xc3a92350d4460d2a),
W64LIT(0x72f32fcbf75ed0bf),
W64LIT(0xbd40ff700f0b6e5f),
W64LIT(0x157a89a3dee7ea40),
W64LIT(0x873fa95285a7ad32),
W64LIT(0x4d7d41db60821b7f),
W64LIT(0x1e3990ac4ed53004),
W64LIT(0x0a1770643ae010af),
W64LIT(0x9311499af1928d99),
W64LIT(0x64751dd5223a9137),
W64LIT(0xfa2acecf5569658f),
W64LIT(0x7c410ef67a1c0256),
W64LIT(0x56b5e945332723d6),
W64LIT(0x6f3604dab2084b73),
W64LIT(0xe95dc4e39d7d2caa),
W64LIT(0x13770a2cc8144925),
W64LIT(0xbc14961ba5d9a4b4),
W64LIT(0xb9e5ae29b8a9ac19),
W64LIT(0xf169d7c0c55bbfcb),
W64LIT(0x2446c68ec479f369),
W64LIT(0x806643b63986c4bc),
W64LIT(0x7fbdb54b719fa99e),
W64LIT(0x04a55159b7a2c246),
W64LIT(0xee042e07215c4524),
W64LIT(0x5bfb73c5b5e65af7),
W64LIT(0x0c1af3eb2c13b3ca),
W64LIT(0xa22d06b7eb0c94b0),
W64LIT(0xb8b1c742127b66f2),
W64LIT(0x285c3565e86a40a3),
W64LIT(0x3b2b3f49207e0986),
W64LIT(0x3c72d5ad9c5f6008),
W64LIT(0x770217f9ea2ed812),
W64LIT(0xfc274d40439ac6ea),
W64LIT(0x4fd5930dc1d37a5c),
W64LIT(0x2e51b6eafe99e3c6),
W64LIT(0x6b93558305aa8935),
W64LIT(0x19607a48f2f4598a),
W64LIT(0x08bfa2b29bb1718c),
W64LIT(0x3f8e6e1097dccbc0),
W64LIT(0x3983ed9f812f68a5),
W64LIT(0xac9f278a664e4659),
W64LIT(0x82ce916098d7a59f),
W64LIT(0xc2fd4a3b7e94c7c1),
W64LIT(0x66ddcf03836bf014),
W64LIT(0xe1e2665106cc5d26),
W64LIT(0x74feac44e1ad73da),
W64LIT(0x8d28d936bf47bd9d),
W64LIT(0x62789e5a34c93252),
W64LIT(0x81322add93540e57),
W64LIT(0xcb1681e24ff77ca6),
W64LIT(0x2512afe56eab3982),
W64LIT(0xd18a4017b6808ee4),
W64LIT(0x705bfd1d560fb19c),
W64LIT(0x4b70c2547671b81a),
W64LIT(0x49d81082d720d939),
W64LIT(0xe0b60f3aac1e97cd),
W64LIT(0x4e81fa666b01b0b7),
W64LIT(0x951cca15e7612efc),
W64LIT(0x463e58d4f0b0c13b),
W64LIT(0x632cf7319e1bf8b9),
W64LIT(0x5ca2992109c73379),
W64LIT(0xf764544fd3a81cae),
W64LIT(0x6ac73ce8af7843de),
W64LIT(0x9f0bba71dd813e53),
W64LIT(0x85977b8424f6cc11),
W64LIT(0x5807c878be65f13f),
W64LIT(0x686fee3e0e2922fd),
W64LIT(0x78e45fafcdbec010),
W64LIT(0x6ccabf67b98be0bb),
W64LIT(0x11dfd8fa69452806),
W64LIT(0xcee7b9d05287740b),
W64LIT(0x50b86aca25d480b3),
W64LIT(0x5df6f04aa315f992),
W64LIT(0x5e0a4bf7a896525a),
W64LIT(0x03fcbbbd0b83abc8),
W64LIT(0x8f800be01e16dcbe),
W64LIT(0xd32292c117d1efc7),
W64LIT(0xe5473708b16e9f60),
W64LIT(0x224b4501d28a500c),
W64LIT(0xfb7ea7a4ffbbaf64),
W64LIT(0x3d26bcc6368daae3),
W64LIT(0x866bc0392f7567d9),
W64LIT(0x3731cca20c6dba4c),
W64LIT(0xb603e67f9f39b41b),
W64LIT(0xa1d1bd0ae08f3f78),
W64LIT(0xd935e2a52d31ff68),
W64LIT(0xaf639c376dcded91),
W64LIT(0x0154696baad2caeb),
W64LIT(0xecacfcd1800d2407),
W64LIT(0xf03dbeab6f897520),
W64LIT(0x02a8d2d6a1516123),
W64LIT(0xf498eff2d82bb766),
W64LIT(0x710f9476fcdd7b77),
W64LIT(0xf8821c19f43804ac),
W64LIT(0xf9d675725eeace47),
W64LIT(0x1a9cc1f5f977f242),
W64LIT(0x5210b81c8485e190),
W64LIT(0x6d9ed60c13592a50),
W64LIT(0xf2956c7dced81403),
W64LIT(0xbb4d7cff19f8cd3a),
W64LIT(0x4c2928b0ca50d194),
W64LIT(0x6e626db118da8198),
W64LIT(0xe4135e631bbc558b),
W64LIT(0x9da368a77cd05f70),
W64LIT(0xa574ec53572dfd3e),
W64LIT(0x09ebcbd93163bb67),
W64LIT(0x4a24ab3fdca372f1),
W64LIT(0x429b098d4712037d),
W64LIT(0x57e1802e99f5e93d),
W64LIT(0xef50476c8b8e8fcf),
W64LIT(0xa085d4614a5df593),
W64LIT(0x34cd771f07ee1184),
W64LIT(0xc6581b62c9360587),
W64LIT(0x2dad0d57f51a480e),
W64LIT(0x898d886f08e57fdb),
W64LIT(0xd6d3aaf30aa1e76a),
W64LIT(0x76567e9240fc12f9),
W64LIT(0xb4ab34a93e68d538),
W64LIT(0xb2a6b726289b765d),
W64LIT(0x8c7cb05d15957776),
W64LIT(0x554952f838a4881e),
W64LIT(0xd52f114e01224ca2),
W64LIT(0x60d04c8c95985371),
W64LIT(0x6789a66829b93aff),
W64LIT(0x2f05df81544b292d),
W64LIT(0x476a31bf5a620bd0),
W64LIT(0xf5cc869972f97d8d),
W64LIT(0x488c79e97df213d2),
W64LIT(0x44968a0251e1a018),
W64LIT(0x26ee14586528924a),
W64LIT(0xd0de297c1c52440f),
W64LIT(0xc5a4a0dfc2b5ae4f),
W64LIT(0x29085c0e42b88a48),
W64LIT(0x142ee0c8743520ab),
W64LIT(0x2af4e7b3493b2180),
W64LIT(0x9448a37e4db3e417),
/* box 1 */
W64LIT(0xe2795ba105ba30ce),
W64LIT(0x65b5d634f5e0fbdd),
W64LIT(0x2d7d7f1464dd8c55),
W64LIT(0xeefbf778add1c20b),
W64LIT(0x1eb0fbd1f11968e7),
W64LIT(0xe6073f45ce30cd8d),
W64LIT(0x21ffd3cdccb67e90),
W64LIT(0xdf0941cfa750a262),
W64LIT(0xc61df5b1b75ef18a),
W64LIT(0xc5c7defa9dc337c6),
W64LIT(0x2581b729073c83d3),
W64LIT(0xa5e97513167173cf),
W64LIT(0xdd3673bd381526b9),
W64LIT(0xe8baa1eef91ebb93),
W64LIT(0x3b314cf8f625eb34),
W64LIT(0x579d4bc8d5fc5df8),
W64LIT(0xbb598ec2e7681b28),
W64LIT(0xc8a06b1a80708794),
W64LIT(0x1c8fc9a36e5cec3c),
W64LIT(0xf60a5a3f0807d374),
W64LIT(0x1ace9f353a9395a4),
W64LIT(0x7e9e50387aab2cee),
W64LIT(0xb5e41069d0466d36),
W64LIT(0x8cea6ee3b92602d9),
W64LIT(0xf952ddad8af1e7fd),
W64LIT(0xb19a748d1bcc9075),
W64LIT(0x2464ae10b2e4c144),
W64LIT(0xfcc9a070f4a35829),
W64LIT(0xfa88f6e6a06c21b1),
W64LIT(0x2c98662dd105cec2),
W64LIT(0x9065a740d77aeee5),
W64LIT(0xcb7a4051aaed41d8),
W64LIT(0x55a279ba4ab9d923),
W64LIT(0x27be855b98790708),
W64LIT(0xbabc97fb52b059bf),
W64LIT(0xa19711f7ddfb8e8c),
W64LIT(0x047e64e4cb8afd43),
W64LIT(0xc386886cc90c4e5e),
W64LIT(0xc422c7c3281b7551),
W64LIT(0xfb6defdf15b46326),
W64LIT(0x01e51939b5d84297),
W64LIT(0x5cbba8be9c809432),
W64LIT(0x6f762c7b09447080),
W64LIT(0xcee13d8cd4bffe0c),
W64LIT(0x54476083ff619bb4),
W64LIT(0x6e933542bc9c3217),
W64LIT(0x4af79b520e78f353),
W64LIT(0x98996f7db49be163),
W64LIT(0xa07208ce6823cc1b),
W64LIT(0x2b3c29823012f5cd),
W64LIT(0x93bf8c0bfde728a9),
W64LIT(0x2225f886e62bb8dc),
W64LIT(0x7f7b4901cf736e79),
W64LIT(0x0000000000000000),
W64LIT(0x023f32729f4584db),
W64LIT(0xd5cabb805bf4293f),
W64LIT(0x07a44fafe1173b0f),
W64LIT(0xe95fb8d74cc6f904),
W64LIT(0x7b052de504f9933a),
W64LIT(0x6aed51a67716cf54),
W64LIT(0x68d263d4e8534b8f),
W64LIT(0xa96bd9cabe1a810a),
W64LIT(0x1d6ad09adb84aeab),
W64LIT(0x0d67b5e01db3b052),
W64LIT(0x52063615abaee22c),
W64LIT(0x8f3045a893bbc495),
W64LIT(0xd8ad0e604647996d),
W64LIT(0xaf2a8f5cead5f892),
W64LIT(0x3017af8ebf5922fe),
W64LIT(0x4034611df2dc780e),
W64LIT(0x721cfce1d2c0de2b),
W64LIT(0x28e602c91a8f3381),
W64LIT(0xe1a370ea2f27f682),
W64LIT(0x29031bf0af577116),
W64LIT(0x1914b47e100e53e8),
W64LIT(0x567852f160241f6f),
W64LIT(0x793a1f979bbc17e1),
W64LIT(0xef1eee411809809c),
W64LIT(0x6211999b14f7c0d2),
W64LIT(0x059b7ddd7e52bfd4),
W64LIT(0x43ee4a56d841be42),
W64LIT(0xf1ae1590e910e87b),
W64LIT(0x33cd84c595c4e4b2),
W64LIT(0x4b12826bbba0b1c4),
W64LIT(0xeb608aa5d3837ddf),
W64LIT(0x201acaf4796e3c07),
W64LIT(0xbf27ea262ce2e66b),
W64LIT(0x58c5cc5a570a6971),
W64LIT(0x37b3e0215e4e19f1),
W64LIT(0xab54ebb8215f05d1),
W64LIT(0x8ed55c9126638602),
W64LIT(0x9aa65d0f2bde65b8),
W64LIT(0xd7f589f2c4b1ade4),
W64LIT(0x5039046734eb66f7),
W64LIT(0x6cac073023d9b6cc),
W64LIT(0x51dc1d5e81332460),
W64LIT(0x17a92ad5272025f6),
W64LIT(0x47902eb213cb4301),
W64LIT(0x1b2b860c8f4bd733),
W64LIT(0x4f6ce68f702a4c87),
W64LIT(0xcf0424b56167bc9b),
W64LIT(0x997c76440143a3f4),
W64LIT(0x7ae034dcb121d1ad),
W64LIT(0x100d657ac6371ef9),
W64LIT(0x0ac3fa4ffca48b5d),
W64LIT(0xdeec58f61288e0f5),
W64LIT(0x265b9c622da1459f),
W64LIT(0xdcd36a848dcd642e),
W64LIT(0xe4380d3751754956),
W64LIT(0x13d74e31ecaad8b5),
W64LIT(0xfd2cb949417b1abe),
W64LIT(0x9624f1d683b5977d),
W64LIT(0x4675378ba6130196),
W64LIT(0x0b26e376497cc9ca),
W64LIT(0x41d1782447043a99),
W64LIT(0xe39c4298b0627259),
W64LIT(0xcd3b16c7fe223840),
W64LIT(0x7787813cac9261ff),
W64LIT(0x492db01924e5351f),
W64LIT(0x5afafe28c84fedaa),
W64LIT(0x8b4e214c583139d6),
W64LIT(0xccde0ffe4bfa7ad7),
W64LIT(0x76629805194a2368),
W64LIT(0x7ca1624ae5eea835),
W64LIT(0x61cbb2d03e6a069e),
W64LIT(0x48c8a920913d7788),
W64LIT(0x8068c23a114df01c),
W64LIT(0xd38bed160f3b50a7),
W64LIT(0x32289dfc201ca625),
W64LIT(0xc1b9ba1e5649ca85),
W64LIT(0xed21dc33874c0447),
W64LIT(0xa3a8238542be0a57),
W64LIT(0x5b1fe7117d97af3d),
W64LIT(0x3d701a6ea2ea92ac),
W64LIT(0x73f9e5d867189cbc),
W64LIT(0x9ed839ebe05498fb),
W64LIT(0x5920d563e2d22be6),
W64LIT(0xca9f59681f35034f),
W64LIT(0x11e87c4373ef5c6e),
W64LIT(0x97c1e8ef366dd5ea),
W64LIT(0xacf0a417c0483ede),
W64LIT(0xd26ef42fbae31230),
W64LIT(0xbcfdc16d067f2027),
W64LIT(0xbec2f31f993aa4fc),
W64LIT(0x45af1cc08c8ec7da),
W64LIT(0x31f2b6b70a816069),
W64LIT(0xd9481759f39fdbfa),
W64LIT(0xe5dd140ee4ad0bc1),
W64LIT(0xa6335e583cecb583),
W64LIT(0x38eb67b3dcb82d78),
W64LIT(0xf5d07174229a1538),
W64LIT(0x5f6183f5b61d527e),
W64LIT(0x0f58879282f63489),
W64LIT(0x164c33ec92f86761),
W64LIT(0x444a05f93956854d),
W64LIT(0x818ddb03a495b28b),
W64LIT(0x4d53d4fdef6fc85c),
W64LIT(0x8d0f77da0cfe404e),
W64LIT(0x8416a6dedac70d5f),
W64LIT(0x666ffd7fdf7d3d91),
W64LIT(0xb63e3b22fadbab7a),
W64LIT(0xf2743edbc38d2e37),
W64LIT(0xa40c6c2aa3a93158),
W64LIT(0x9f3d20d2558cda6c),
W64LIT(0xfef692026be6dcf2),
W64LIT(0x2ea7545f4e404a19),
W64LIT(0xb2405fc631515639),
W64LIT(0x23c0e1bf53f3fa4b),
W64LIT(0x83b2e9713bd03650),
W64LIT(0x0641569654cf7998),
W64LIT(0xb883a589cdf5dd64),
W64LIT(0x3ad455c143fda9a3),
W64LIT(0x925a9532483f6a3e),
W64LIT(0xaab1f28194874746),
W64LIT(0xf435684d974257af),
W64LIT(0xd1b4df64907ed47c),
W64LIT(0x390e7e8a69606fef),
W64LIT(0xd051c65d25a696eb),
W64LIT(0xb4010950659e2fa1),
W64LIT(0x0c82acd9a86bf2c5),
W64LIT(0x88940a0772acff9a),
W64LIT(0xf39127e276556ca0),
W64LIT(0xaecf96655f0dba05),
W64LIT(0x03da2b4b2a9dc64c),
W64LIT(0x3f4f281c3daf1677),
W64LIT(0x3469cb6a74d3dfbd),
W64LIT(0xf04b0ca95cc8aaec),
W64LIT(0x1f55e2e844c12a70),
W64LIT(0x4cb6cdc45ab78acb),
W64LIT(0xc05ca327e3918812),
W64LIT(0x95feda9da9285131),
W64LIT(0xb966bcb0782d9ff3),
W64LIT(0xa7d647618934f714),
W64LIT(0xd61090cb7169ef73),
W64LIT(0x71c6d7aaf85d1867),
W64LIT(0xecc4c50a329446d0),
W64LIT(0x6450cf0d4038b94a),
W64LIT(0x420b536f6d99fcd5),
W64LIT(0x75b8b34e33d7e524),
W64LIT(0xc26391557cd40cc9),
W64LIT(0xda923c12d9021db6),
W64LIT(0x4e89ffb6c5f20e10),
W64LIT(0x0919d104d6394d11),
W64LIT(0x8aab3875ede97b41),
W64LIT(0xa88ec0f30bc2c39d),
W64LIT(0xb7db221b4f03e9ed),
W64LIT(0xc7f8ec880286b31d),
W64LIT(0x2f424d66fb98088e),
W64LIT(0xe04669d39affb415),
W64LIT(0x3eaa3125887754e0),
W64LIT(0x5e849acc03c510e9),
W64LIT(0x8257f0488e0874c7),
W64LIT(0xbd18d854b3a762b0),
W64LIT(0xb3a546ff848914ae),
W64LIT(0x9ce70b997f111c20),
W64LIT(0x3c9503571732d03b),
W64LIT(0xe7e2267c7be88f1a),
W64LIT(0x63f480a2a12f8245),
W64LIT(0x602eabe98bb24409),
W64LIT(0x941bc3a41cf013a6),
W64LIT(0x678ae4466aa57f06),
W64LIT(0x1232570859729a22),
W64LIT(0x6d491e099601f45b),
W64LIT(0x5d5eb1872958d6a5),
W64LIT(0x1473019e0dbde3ba),
W64LIT(0xa24d3abcf76648c0),
W64LIT(0x85f3bfe76f1f4fc8),
W64LIT(0x08fcc83d63e10f86),
W64LIT(0x745daa77860fa7b3),
W64LIT(0x9180be7962a2ac72),
W64LIT(0x87cc8d95f05acb13),
W64LIT(0x78df06ae2e645576),
W64LIT(0x18f1ad47a5d6117f),
W64LIT(0x358cd253c10b9d2a),
W64LIT(0x0ebd9eab372e761e),
W64LIT(0xf7ef4306bddf91e3),
W64LIT(0x7023ce934d855af0),
W64LIT(0xd42fa2b9ee2c6ba8),
W64LIT(0x3656f918eb965b66),
W64LIT(0x9d0212a0cac95eb7),
W64LIT(0x2ad930bb85cab75a),
W64LIT(0x862994ac45828984),
W64LIT(0x7d447b735036eaa2),
W64LIT(0xb07f6db4ae14d2e2),
W64LIT(0x6b08489fc2ce8dc3),
W64LIT(0x9b4344369e06272f),
W64LIT(0xad15bd2e75907c49),
W64LIT(0xdb77252b6cda5f21),
W64LIT(0xea85939c665b3f48),
W64LIT(0xc945722335a8c503),
W64LIT(0x159618a7b865a12d),
W64LIT(0x69377aed5d8b0918),
W64LIT(0x8971133ec774bd0d),
W64LIT(0x53e32f2c1e76a0bb),
W64LIT(0xf8b7c4943f29a56a),
W64LIT(0xff138b3bde3e9e65),
/* box 2 */
W64LIT(0x7c6a2eb5fdabecc6),
W64LIT(0x401cda0a752bbea0),
W64LIT(0x1925217156dc57c4),
W64LIT(0x56dec6d301d70787),
W64LIT(0x41c751ff73c6ac58),
W64LIT(0xc9067697a92cb5f9),
W64LIT(0x3391c917aaa0bc85),
W64LIT(0xae0a9a4c0e742afe),
W64LIT(0xaa8ca972162a62f4),
W64LIT(0x5aa193912935df99),
W64LIT(0x86fd9135fe27e5ba),
W64LIT(0xffca074b1d3f538e),
W64LIT(0x0e3cb65d24cdfc1b),
W64LIT(0x4384b2e07fe9885d),
W64LIT(0xc73ac0ca8de149e2),
W64LIT(0x48e5bc7645972eb4),
W64LIT(0xbe0d56b46ef9ffd6),
W64LIT(0x200e6d05c0ef5f50),
W64LIT(0xe1f17dee597f7abd),
W64LIT(0x0243e31f0c2f2405),
W64LIT(0xf4ab09dd2741f567),
W64LIT(0xe4acc52547cc204f),
W64LIT(0x348f92c3b83cc272),
W64LIT(0x53837e181f645d75),
W64LIT(0xd8da319acf4c7229),
W64LIT(0x81e3cae1ecbb9b4d),
W64LIT(0xd6e687c7eb818e32),
W64LIT(0x3dad7f4a8e6d409e),
W64LIT(0x28f70b79f053cf44),
W64LIT(0x493e3783437a3c4c),
W64LIT(0xb27203f6461b27c8),
W64LIT(0xd02357e6fff0e23d),
W64LIT(0xe8d390676f2ef851),
W64LIT(0x26cbbd24d49e335f),
W64LIT(0xee1640467b5f945e),
W64LIT(0x4aa65f6949b80ab1),
W64LIT(0xb56c58225487593f),
W64LIT(0x4ffbe7a2570b5043),
W64LIT(0x0aba85633c93b411),
W64LIT(0x78ec1d8be5f5a4cc),
W64LIT(0x501b16f215a66b88),
W64LIT(0x271036d1d27321a7),
W64LIT(0x7ff2465ff769da3b),
W64LIT(0x35541936bed1d08a),
W64LIT(0xb8c886957a8893d9),
W64LIT(0x2fe950ade2cfb1b3),
W64LIT(0xf90fd76a094e3f81),
W64LIT(0x2daab3b2eee095b6),
W64LIT(0x1abd499b5c1e6139),
W64LIT(0x0c7f554228e2d81e),
W64LIT(0x425f391579049aa5),
W64LIT(0xc3bcf3f495bf01e8),
W64LIT(0xb4b7d3d7526a4bc7),
W64LIT(0x0000000000000000),
W64LIT(0xa0362c112ab9d6e5),
W64LIT(0x91e406198c364e65),
W64LIT(0x454162c16b98e452),
W64LIT(0x139fa4126a4fe3d5),
W64LIT(0x01db8bf506ed12f8),
W64LIT(0x9a85088fb648e88c),
W64LIT(0x3ab3249e9cf13e69),
W64LIT(0xd57eef2de143b8cf),
W64LIT(0xb1ea6b1c4cd91135),
W64LIT(0x7aaffe94e9da80c9),
W64LIT(0xad92f2a604b61c03),
W64LIT(0xa3ae44fb207be018),
W64LIT(0xeb4bf88d65ecceac),
W64LIT(0xc0249b1e9f7d3715),
W64LIT(0xa8cf4a6d1a0546f1),
W64LIT(0xc6e14b3f8b0c5b1a),
W64LIT(0xce182d43bbb0cb0e),
W64LIT(0xfc526fa117fd6573),
W64LIT(0x8c471456c2b451ab),
W64LIT(0xac497953025b0efb),
W64LIT(0x0486333e185e480a),
W64LIT(0x18feaa845031453c),
W64LIT(0xa1eda7e42c54c41d),
W64LIT(0x06c5d02114716c0f),
W64LIT(0x055db8cb1eb35af2),
W64LIT(0xe5774ed0412132b7),
W64LIT(0x36cc71dcb413e677),
W64LIT(0x470281de67b7c057),
W64LIT(0x58e2708e251afb9c),
W64LIT(0xa914c1981ce85409),
W64LIT(0xb3a9880340f63530),
W64LIT(0x638adfe5bf06d70d),
W64LIT(0x0b610e963a7ea6e9),
W64LIT(0x927c6ef386f47898),
W64LIT(0xed8e28ac719da2a3),
W64LIT(0x7548c33ccbfa6e2a),
W64LIT(0xf3b5520935dd8b90),
W64LIT(0x8d9c9fa3c4594353),
W64LIT(0x31d22a08a68f9880),
W64LIT(0x0da4deb72e0fcae6),
W64LIT(0x8fdf7cbcc8766756),
W64LIT(0x5dbfc8453ba9a16e),
W64LIT(0x8e04f749ce9b75ae),
W64LIT(0x83a029fee094bf48),
W64LIT(0xa4b01f2f32e79eef),
W64LIT(0x1c7899ba486f0d36),
W64LIT(0x654f0fc4ab77bb02),
W64LIT(0x7db1a540fb46fe3e),
W64LIT(0x51c09d07134b7970),
W64LIT(0xcb459588a50391fc),
W64LIT(0x3fee9c558242649b),
W64LIT(0xfe118cbe1bd24176),
W64LIT(0x76d0abd6c13858d7),
W64LIT(0x5e27a0af316b9793),
W64LIT(0x69305a868395631c),
W64LIT(0x3b68af6b9a1c2c91),
W64LIT(0x6db669b89bcb2b16),
W64LIT(0xa72877c53825a812),
W64LIT(0xd3bb3f0cf532d4c0),
W64LIT(0x6ff58aa797e40f13),
W64LIT(0x96fa5dcd9eaa3092),
W64LIT(0x2c713847e80d874e),
W64LIT(0xc57923d581ce6de7),
W64LIT(0x2b6f6393fa91f9b9),
W64LIT(0x0922ed89365182ec),
W64LIT(0x324a42e2ac4dae7d),
W64LIT(0x16c21cd974fcb927),
W64LIT(0x956235279468066f),
W64LIT(0x7b747561ef379231),
W64LIT(0x449ae9346d75f6aa),
W64LIT(0xf570822821ace79f),
W64LIT(0x5939fb7b23f7e964),
W64LIT(0x7937967ee318b634),
W64LIT(0x84be722af208c1bf),
W64LIT(0x08f9667c30bc9014),
W64LIT(0xefcdcbb37db286a6),
W64LIT(0xa6f3fc303ec8baea),
W64LIT(0xea9073786301dc54),
W64LIT(0x62515410b9ebc5f5),
W64LIT(0xd260b4f9f3dfc638),
W64LIT(0x9e033bb1ae16a086),
W64LIT(0x38f0c78190de1a6c),
W64LIT(0xc267780193521310),
W64LIT(0x80384114ea5689b5),
W64LIT(0x9b5e837ab0a5fa74),
W64LIT(0xf73361372d83c39a),
W64LIT(0x3009a1fda0628a78),
W64LIT(0xd4a564d8e7aeaa37),
W64LIT(0xfb4c347505611b84),
W64LIT(0x5b7a18642fd8cd61),
W64LIT(0x239605efca2d69ad),
W64LIT(0xf8d45c9f0fa32d79),
W64LIT(0xbb50ee7f704aa524),
W64LIT(0x392b4c7496330894),
W64LIT(0x0fe73da82220eee3),
W64LIT(0x3717fa29b2fef48f),
W64LIT(0xf26ed9fc33309968),
W64LIT(0xd73d0c32ed6c9cca),
W64LIT(0xda99d285c363562c),
W64LIT(0xde1fe1bbdb3d1e26),
W64LIT(0x738d131ddf8b0225),
W64LIT(0x292c808cf6beddbc),
W64LIT(0xbc4eb5ab62d6dbd3),
W64LIT(0x039868ea0ac236fd),
W64LIT(0xcc5bce5cb79fef0b),
W64LIT(0xb031e0e94a3403cd),
W64LIT(0xc4a2a82087237f1f),
W64LIT(0xb72fbb3d58a87d3a),
W64LIT(0xafd111b908993806),
W64LIT(0x68ebd173857871e4),
W64LIT(0x9d9b535ba4d4967b),
W64LIT(0xe9081b9269c3eaa9),
W64LIT(0x71cef002d3a42620),
W64LIT(0x93a7e50680196a60),
W64LIT(0x891aac9ddc070b59),
W64LIT(0x155a74337e3e8fda),
W64LIT(0x4e206c5751e642bb),
W64LIT(0x9721d6389847226a),
W64LIT(0x12442fe76ca2f12d),
W64LIT(0x2553d5cede5c05a2),
W64LIT(0xa275cf0e2696f2e0),
W64LIT(0x24885e3bd8b1175a),
W64LIT(0x670cecdba7589f07),
W64LIT(0x749348c9cd177cd2),
W64LIT(0x64948431ad9aa9fa),
W64LIT(0x2ab4e866fc7ceb41),
W64LIT(0xe6ef263a4be3044a),
W64LIT(0xe734adcf4d0e16b2),
W64LIT(0x903f8dec8adb5c9d),
W64LIT(0xf02d3ae33f1fbd6d),
W64LIT(0x725698e8d96610dd),
W64LIT(0x1da3124f4e821fce),
W64LIT(0x1719972c7211abdf),
W64LIT(0x11dc470d6660c7d0),
W64LIT(0xec55a3597770b05b),
W64LIT(0xbfd6dd416814ed2e),
W64LIT(0x57054d26073a157f),
W64LIT(0x1e3b7aa544402933),
W64LIT(0x5ffc2b5a3786856b),
W64LIT(0x61c93cfab329f308),
W64LIT(0x3e3517a084af7663),
W64LIT(0xf6e8eac22b6ed162),
W64LIT(0x1007ccf8608dd528),
W64LIT(0x66d7672ea1b58dff),
W64LIT(0x8b594f82d0282f5c),
W64LIT(0x1fe0f15042ad3bcb),
W64LIT(0x4b7dd49c4f551849),
W64LIT(0x4c638f485dc966be),
W64LIT(0xcfc3a6b6bd5dd9f6),
W64LIT(0x46d90a2b615ad2af),
W64LIT(0x8565f9dff4e5d347),
W64LIT(0x94b9bed292851497),
W64LIT(0xfa97bf80038c097c),
W64LIT(0xb9130d607c658121),
W64LIT(0xdc5c02a4d7123a23),
W64LIT(0x224d8e1accc07b55),
W64LIT(0x87261ac0f8caf742),
W64LIT(0xd901ba6fc9a160d1),
W64LIT(0xab57228710c7700c),
W64LIT(0x21d5e6f0c6024da8),
W64LIT(0x98c6eb90ba67cc89),
W64LIT(0x827ba20be679adb0),
W64LIT(0x991d6065bc8ade71),
W64LIT(0x5546ae390b15317a),
W64LIT(0xa56b94da340a8c17),
W64LIT(0x071e5bd4129c7ef7),
W64LIT(0xe02af61b5f926845),
W64LIT(0x6b73b9998fba4719),
W64LIT(0xdfc46a4eddd00cde),
W64LIT(0x770b2023c7d54a2f),
W64LIT(0x7e29cdaaf184c8c3),
W64LIT(0xba8b658a76a7b7dc),
W64LIT(0x9c40d8aea2398483),
W64LIT(0x9fd8b044a8fbb27e),
W64LIT(0xdb425970c58e44d4),
W64LIT(0xe269150453bd4c40),
W64LIT(0x3c76f4bf88805266),
W64LIT(0xf1f6b11639f2af95),
W64LIT(0x549d25cc0df82382),
W64LIT(0x4db804bd5b247446),
W64LIT(0x8a82c477d6c53da4),
W64LIT(0x5258f5ed19894f8d),
W64LIT(0x6e2e015291091deb),
W64LIT(0xc1ff10eb999025ed),
W64LIT(0xbd953e5e643bc92b),
W64LIT(0xc8ddfd62afc1a701),
W64LIT(0x5c6443b03d44b396),
W64LIT(0x6c6de24d9d2639ee),
W64LIT(0x1481ffc678d39d22),
W64LIT(0xd1f8dc13f91df0c5),
W64LIT(0xca9e1e7da3ee8304),
W64LIT(0xdd878951d1ff28db),
W64LIT(0x6012b70fb5c4e1f0),
W64LIT(0x1b66c26e5af373c1),
W64LIT(0xe3b29ef155505eb8),
W64LIT(0x70157bf7d54934d8),
W64LIT(0x2e32db58e422a34b),
W64LIT(0x6aa8326c895755e1),
W64LIT(0xb6f430c85e456fc2),
W64LIT(0xfd89e4541110778b),
W64LIT(0x88c12768daea19a1),
W64LIT(0xcd8045a9b172fdf3),
/* box 3 */
W64LIT(0x99183e616655b742),
W64LIT(0xb2872032a50d6860),
W64LIT(0x0946f63b060528ef),
W64LIT(0x36612b9a141ef07d),
W64LIT(0x0634da84dd49579b),
W64LIT(0xfc9c9e9b486c8a57),
W64LIT(0xa63fe3c0744e6fd0),
W64LIT(0xf1515758d8b46bf9),
W64LIT(0x3e82559fcd5197ff),
W64LIT(0x92e12d262bc40177),
W64LIT(0xc3bb433a5a7752c5),
W64LIT(0x21c3852a5183267a),
W64LIT(0x39130725cf528f09),
W64LIT(0x9ba7db1d2dc12998),
W64LIT(0xc58f99be873e055e),
W64LIT(0xd9d424498f32656c),
W64LIT(0x27f75fae8cca71e1),
W64LIT(0x59b91019a8fc3430),
W64LIT(0xce768af9caafb36b),
W64LIT(0x9d930199f0887e03),
W64LIT(0x63b07a7ef3706a8e),
W64LIT(0xb5167288a70e7096),
W64LIT(0x40cc1a28e967d22e),
W64LIT(0x4d01d3eb79bf3380),
W64LIT(0x9e896cdb6456afb4),
W64LIT(0x2548bad2c75eef3b),
W64LIT(0xa79a6bfeab0420bd),
W64LIT(0x9f2ce4e5bb1ce0d9),
W64LIT(0x32ea146282c3393c),
W64LIT(0x6d67defff7765a97),
W64LIT(0x83775912b31080eb),
W64LIT(0xf5da68a04e69a2b8),
W64LIT(0x1196743498d4819c),
W64LIT(0x0bf913474d91b635),
W64LIT(0x43d6776a7db90399),
W64LIT(0x444725d07fba1b6f),
W64LIT(0x6584a0fa2e393d15),
W64LIT(0x3f27dda1121bd892),
W64LIT(0xf6c005e2dab7730f),
W64LIT(0x56cb3ca673b04b44),
W64LIT(0x642128c4f1737278),
W64LIT(0xbf4ae9f135d589ce),
W64LIT(0xb038c54eee99f6ba),
W64LIT(0xf47fe09e9123edd5),
W64LIT(0x75b75cf069a7f3e4),
W64LIT(0xd419ed8a1fea84c2),
W64LIT(0x73838674b4eea47f),
W64LIT(0x498aec13ef62fac1),
W64LIT(0x20660d148ec96917),
W64LIT(0xa48006bc3fdaf10a),
W64LIT(0x2f1421ab55851663),
W64LIT(0x0a5c9b7992dbf958),
W64LIT(0xd1375a4c567d02ee),
W64LIT(0x0000000000000000),
W64LIT(0xc842507d17e6e4f0),
W64LIT(0xf3eeb2249320f523),
W64LIT(0xc9e7d843c8acab9d),
W64LIT(0xff86f3d9dcb25be0),
W64LIT(0xb4b3fab678443ffb),
W64LIT(0xb19d4d7031d3b9d7),
W64LIT(0x79df1d0d26355d27),
W64LIT(0x8eba90d123c86145),
W64LIT(0xaa57a23d3bdcc113),
W64LIT(0xcb583d3f83383547),
W64LIT(0xd871ac7750782a01),
W64LIT(0xe162ab529f2aa508),
W64LIT(0x38b68f1b1018c064),
W64LIT(0x237c60561a17b8a0),
W64LIT(0xa31154063dd9e9fc),
W64LIT(0x713c6308ff7a3aa5),
W64LIT(0x1a6f6773d54537a9),
W64LIT(0x08e37e05d94f6782),
W64LIT(0x357b46d880c021ca),
W64LIT(0x6cc256c1283c15fa),
W64LIT(0xcfd302c715e5fc06),
W64LIT(0xbdf50c8d7e411714),
W64LIT(0x7cf1aacb6fa2db0b),
W64LIT(0x5240035ee56d8205),
W64LIT(0x7b60f8716da1c3fd),
W64LIT(0x01a5883edf4a4f6d),
W64LIT(0xdd5f1bb119efac2d),
W64LIT(0x5474d9da3824d59e),
W64LIT(0x0f722cbfdb4c7f74),
W64LIT(0x17a2aeb0459dd607),
W64LIT(0x37c4a3a4cb54bf10),
W64LIT(0xc21ecb04853d1da8),
W64LIT(0x4273ff54a2f34cf4),
W64LIT(0xdace490b1becb4db),
W64LIT(0x6af68c45f5754261),
W64LIT(0x46f8c0ac342e85b5),
W64LIT(0x854383966e59d770),
W64LIT(0x81c8bc6ef8841e31),
W64LIT(0x3bace25984c611d3),
W64LIT(0x1033fc0a479ecef1),
W64LIT(0x1c5bbdf7080c6032),
W64LIT(0x7412d4ceb6edbc89),
W64LIT(0xa8e8474170485fc9),
W64LIT(0xb8dbbb4b37d69138),
W64LIT(0x079152ba020318f6),
W64LIT(0x72260e4a6ba4eb12),
W64LIT(0x905ec85a60509fad),
W64LIT(0x2dabc4d71e1188b9),
W64LIT(0xd092d27289374d83),
W64LIT(0x610f9f02b8e4f454),
W64LIT(0x02bfe57c4b949eda),
W64LIT(0x95707f9c29c71981),
W64LIT(0x6fd83b83bce2c44d),
W64LIT(0x5d322fe13e21fd71),
W64LIT(0x34decee65f8a6ea7),
W64LIT(0xcd6ce7bb5e7162dc),
W64LIT(0xfb0dcc214a6f92a1),
W64LIT(0x2eb1a9958acf590e),
W64LIT(0xdcfa938fc6a5e340),
W64LIT(0x669ecdb8bae7eca2),
W64LIT(0x151d4bcc0e0948dd),
W64LIT(0xfd3916a59726c53a),
W64LIT(0x581c982777b67b5d),
W64LIT(0x1bcaef4d0a0f78c4),
W64LIT(0xdfe0fecd527b32f7),
W64LIT(0x128c19760c0a502b),
W64LIT(0x84e60ba8b113981d),
W64LIT(0x3c3db0e386c50925),
W64LIT(0x7febc789fb7c0abc),
W64LIT(0x7d5422f5b0e89466),
W64LIT(0xd70380c88b345575),
W64LIT(0xbbc1d609a308408f),
W64LIT(0xe278c6100bf474bf),
W64LIT(0x5e2842a3aaff2cc6),
W64LIT(0x6b53047b2a3f0d0c),
W64LIT(0xf7658ddc05fd3c62),
W64LIT(0x9a025323f28b66f5),
W64LIT(0x8c0575ad685cff9f),
W64LIT(0x76ad31b2fd792253),
W64LIT(0x68496939bee1dcbb),
W64LIT(0x7e4e4fb7243645d1),
W64LIT(0xe44c1c94d6bd2324),
W64LIT(0xbeef61cfea9fc6a3),
W64LIT(0x91fb4064bf1ad0c0),
W64LIT(0x052eb7c64997862c),
W64LIT(0x4a9081517bbc2b76),
W64LIT(0x8f1f18effc822e28),
W64LIT(0x3a096a675b8c5ebe),
W64LIT(0xee1087ed4466da7c),
W64LIT(0x2652d79053803e8c),
W64LIT(0x7099eb36203075c8),
W64LIT(0xc7307cc2ccaa9b84),
W64LIT(0x5c97a7dfe16bb21c),
W64LIT(0x50ffe622aef91cdf),
W64LIT(0x8da0fd93b716b0f2),
W64LIT(0x69ece10761ab93d6),
W64LIT(0x31f07920161de88b),
W64LIT(0x13299148d3401f46),
W64LIT(0x031a6d4294ded1b7),
W64LIT(0xccc96f85813b2db1),
W64LIT(0x14b8c3f2d14307b0),
W64LIT(0x8659eed4fa8706c7),
W64LIT(0xba645e377c420fe2),
W64LIT(0x2920fb2f88cc41f8),
W64LIT(0x87fc66ea25cd49aa),
W64LIT(0x1ee4588b4398fee8),
W64LIT(0xecaf62910ff244a6),
W64LIT(0xf817a163deb14316),
W64LIT(0x45e2adeea0f05402),
W64LIT(0x806d345027ce515c),
W64LIT(0x576eb498acfa0429),
W64LIT(0xa5258e82e090be67),
W64LIT(0x892bc26b21cb79b3),
W64LIT(0x6e7db3bd63a88b20),
W64LIT(0x4e1bbea9ed61e237),
W64LIT(0xadc6f08739dfd9e5),
W64LIT(0x8b9427176a5fe769),
W64LIT(0xa1aeb17a764d7726),
W64LIT(0x4b35096fa4f6641b),
W64LIT(0x22d9e868c55df7cd),
W64LIT(0x55d151e4e76e9af3),
W64LIT(0x966a12debd19c836),
W64LIT(0x0dcdc9c390d8e1ae),
W64LIT(0xf24b3a1a4c6aba4e),
W64LIT(0x24ed32ec1814a056),
W64LIT(0xaf7915fb724b473f),
W64LIT(0x2885731157860e95),
W64LIT(0x9c3689a72fc2316e),
W64LIT(0x475d4892eb64cad8),
W64LIT(0xac6378b9e6959688),
W64LIT(0xa00b3944a907384b),
W64LIT(0xc695f4fc13e0d4e9),
W64LIT(0x3055f11ec957a7e6),
W64LIT(0x6215f2402c3a25e3),
W64LIT(0xde4576f38d317d9a),
W64LIT(0x9344a518f48e4e1a),
W64LIT(0x82d2d12c6c5acf86),
W64LIT(0xefb50fd39b2c9511),
W64LIT(0xe981d5574665c28a),
W64LIT(0x5f8dca9d75b563ab),
W64LIT(0xb60c1fca33d0a121),
W64LIT(0xfe237be703f8148d),
W64LIT(0xd6a608f6547e1a18),
W64LIT(0xb97e3375e89cde55),
W64LIT(0xd388bf301de99c34),
W64LIT(0x5b06f565e368aaea),
W64LIT(0xf0f4df6607fe2494),
W64LIT(0x1607268e9ad7996a),
W64LIT(0xaedc9dc5ad010852),
W64LIT(0xe0c7236c4060ea65),
W64LIT(0xea9bb815d2bb133d),
W64LIT(0x888e4a55fe8136de),
W64LIT(0x5aa37d5b3c22e587),
W64LIT(0xc104a64611e3cc1f),
W64LIT(0x515a6e1c71b353b2),
W64LIT(0xc42a118058744a33),
W64LIT(0x7708b98c22336d3e),
W64LIT(0x2a3a966d1c12904f),
W64LIT(0x8a31af29b515a804),
W64LIT(0xed0aeaafd0b80bcb),
W64LIT(0x2c0e4ce9c15bc7d4),
W64LIT(0x0c6841fd4f92aec3),
W64LIT(0x98bdb65fb91ff82f),
W64LIT(0x1f41d0b59cd2b185),
W64LIT(0xb322a80c7a47270d),
W64LIT(0xe6f3f9e89d29bdfe),
W64LIT(0x7ac5704fb2eb8c90),
W64LIT(0xa94dcf7faf0210a4),
W64LIT(0x787a9533f97f124a),
W64LIT(0xdb6bc135c4a6fbb6),
W64LIT(0x048b3ff896ddc941),
W64LIT(0xe8245d69992f8de7),
W64LIT(0xe3dd4e2ed4be3bd2),
W64LIT(0xcafdb5015c727a2a),
W64LIT(0xb7a997f4ec9aee4c),
W64LIT(0xe75671d64263f293),
W64LIT(0x2b9f1e53c358df22),
W64LIT(0x18d0820f9ed1a973),
W64LIT(0xabf22a03e4968e7e),
W64LIT(0xa2b4dc38e293a691),
W64LIT(0x673b458665ada3cf),
W64LIT(0xf9b2295d01fb0c7b),
W64LIT(0xd22d370ec2a3d359),
W64LIT(0x97cf9ae06253875b),
W64LIT(0x0ed7a48104063019),
W64LIT(0x482f642d3028b5ac),
W64LIT(0xc0a12e78cea98372),
W64LIT(0x4fbe3697322bad5a),
W64LIT(0x19750a31419be61e),
W64LIT(0x41699216362d9d43),
W64LIT(0xd5bc65b4c0a0cbaf),
W64LIT(0xe5e994aa09f76c49),
W64LIT(0xeb3e302b0df15c50),
W64LIT(0x94d5f7a2f68d56ec),
W64LIT(0x53e58b603a27cd68),
W64LIT(0x3d9838dd598f4648),
W64LIT(0x60aa173c67aebb39),
W64LIT(0x1dfe35c9d7462f5f),
W64LIT(0x4ca45bd5a6f57ced),
W64LIT(0xbc5084b3a10b5879),
W64LIT(0xfaa8441f9525ddcc),
W64LIT(0x334f9c5c5d897651),
/* box 4 */
W64LIT(0xda1687a883adf27e),
W64LIT(0xe35c9378578d9f22),
W64LIT(0x303ca4531637fa40),
W64LIT(0xa088321f74b20375),
W64LIT(0xc9863f3a9acb95e9),
W64LIT(0x5fcf47c57d0b0ed4),
W64LIT(0x4aa211e4e1280b4b),
W64LIT(0xe1a4c9ba871d1289),
W64LIT(0x4926664759f03a4f),
W64LIT(0xadfb36ede3707bca),
W64LIT(0xcf7bd1891f8ef7e1),
W64LIT(0x9735559e8f882792),
W64LIT(0x5932a976f84e6cdc),
W64LIT(0x9dc792bef547818a),
W64LIT(0x06fdeeb385456208),
W64LIT(0x46ad38771ea2cf5b),
W64LIT(0x5eb36aa41543b27b),
W64LIT(0x8b2eb33cd1bcb511),
W64LIT(0x71105ff6e598ebbc),
W64LIT(0x5441ad846f8c1463),
W64LIT(0x4c5fff57646d6943),
W64LIT(0xf3485c49f633c9b1),
W64LIT(0x9cbbbfdf9d0f3d25),
W64LIT(0x22d031a067192178),
W64LIT(0xca0248992213a4ed),
W64LIT(0x19627fb263a9c18f),
W64LIT(0x9330e1efda5dc831),
W64LIT(0x1390b89219666797),
W64LIT(0x2edf18339893e568),
W64LIT(0x6c779435d3e4c590),
W64LIT(0x53c06e568281cac4),
W64LIT(0x6ff3e3966b3cf494),
W64LIT(0xfe3b58bb61f1b10e),
W64LIT(0x77edb14560dd89b4),
W64LIT(0x02f85ac2d0908dab),
W64LIT(0x12ec95f3712edb38),
W64LIT(0x85d9c06dfea6fcaa),
W64LIT(0x90b4964c6285f935),
W64LIT(0xf1b0068b26a3441a),
W64LIT(0x729428555d40dab8),
W64LIT(0x5c4b3066c5d33fd0),
W64LIT(0x5d371d07ad9b837f),
W64LIT(0xa48d866e2167ecd6),
W64LIT(0xb661139d504937ee),
W64LIT(0xa27068dda4228ede),
W64LIT(0xf8c6b608e4b4d306),
W64LIT(0x6bf657e73ee91b37),
W64LIT(0xac871b8c8b38c765),
W64LIT(0x4ea7a595b4fde4e8),
W64LIT(0x0d7304f297c278bf),
W64LIT(0xb71d3efc38018b41),
W64LIT(0xae7f414e5ba84ace),
W64LIT(0xaf036c2f33e0f661),
W64LIT(0x0000000000000000),
W64LIT(0xb89660cc7f537e55),
W64LIT(0xa675dcacf1f7617d),
W64LIT(0x610490c74426bd2f),
W64LIT(0xc18ca2d83094be5a),
W64LIT(0x2adaac42cd460acb),
W64LIT(0x7d1f76651a122fac),
W64LIT(0xc58916a9654151f9),
W64LIT(0xedabe0297897d699),
W64LIT(0x2d5b6f90204bd46c),
W64LIT(0x26d585d132cccedb),
W64LIT(0x9f3fc87c25d70c21),
W64LIT(0xc60d610add9960fd),
W64LIT(0x80a0597dc33bafa6),
W64LIT(0xd0e44088f9625466),
W64LIT(0x1d67cbc3367c2e2c),
W64LIT(0x2c2742f1480368c3),
W64LIT(0x89d6e9fe012c38ba),
W64LIT(0xe9ae54582d42393a),
W64LIT(0x3ecbd702392db3fb),
W64LIT(0xb5e5643ee89106ea),
W64LIT(0xa882affddeed28c6),
W64LIT(0x1ae60811db71f08b),
W64LIT(0x924ccc8eb215749e),
W64LIT(0xfcc30279b1613ca5),
W64LIT(0x825803bf13ab220d),
W64LIT(0xd992f00b3b75c37a),
W64LIT(0xc8fa125bf2832946),
W64LIT(0x35453d432baaa94c),
W64LIT(0xf9ba9b698cfc6fa9),
W64LIT(0x37bd6781fb3a24e7),
W64LIT(0x791ac2144fc7c00f),
W64LIT(0x16e9218224fb349b),
W64LIT(0xdb6aaac9ebe54ed1),
W64LIT(0xd8eedd6a533d7fd5),
W64LIT(0x7c635b04725a9303),
W64LIT(0x553d80e507c4a8cc),
W64LIT(0x9a46516c184a5f2d),
W64LIT(0x14117b40f46bb930),
W64LIT(0x1ee3bc608ea41f28),
W64LIT(0x27a9a8b05a847274),
W64LIT(0x4050d6c49be7ad53),
W64LIT(0x7be298d69f574da4),
W64LIT(0x6a8a7a8656a1a798),
W64LIT(0x4d23d2360c25d5ec),
W64LIT(0x1014cf31a1be5693),
W64LIT(0xb264a7ec059cd84d),
W64LIT(0xea2a23fb959a083e),
W64LIT(0xf0cc2bea4eebf8b5),
W64LIT(0x76919c240895351b),
W64LIT(0x0b8eea4112871ab7),
W64LIT(0x47d1151676ea73f4),
W64LIT(0xbdeff9dc42ce2d59),
W64LIT(0x2ba68123a50eb664),
W64LIT(0x057999103d9d530c),
W64LIT(0xe759270902587081),
W64LIT(0xef53baeba8075b32),
W64LIT(0x4fdb88f4dcb55847),
W64LIT(0x6e8fcef70374483b),
W64LIT(0x1168e250c9f6ea3c),
W64LIT(0x1b9a2570b3394c24),
W64LIT(0x706c72978dd05713),
W64LIT(0x865db7ce467ecdae),
W64LIT(0x52bc4337eac9766b),
W64LIT(0x504419f53a59fbc0),
W64LIT(0x8f2b074d84695ab2),
W64LIT(0x6078bda62c6e0180),
W64LIT(0x43d4a167233f9c57),
W64LIT(0x0ef773512f1a49bb),
W64LIT(0x0c0f2993ff8ac410),
W64LIT(0x4bde3c858960b7e4),
W64LIT(0x66855315a92b6388),
W64LIT(0xd360372b41ba6562),
W64LIT(0x584e84179006d073),
W64LIT(0x9b3a7c0d7002e382),
W64LIT(0xa5f1ab0f492f5079),
W64LIT(0x2822f6801dd68760),
W64LIT(0x445562b5ce3242f0),
W64LIT(0xaa7af53f0e7da56d),
W64LIT(0x3c338dc0e9bd3e50),
W64LIT(0x3bb24e1204b0e0f7),
W64LIT(0xd59dd998c4ff076a),
W64LIT(0x91c8bb2d0acd459a),
W64LIT(0x84a5ed0c96ee4005),
W64LIT(0x33b8d3f0aeefcb44),
W64LIT(0x57c5da27d7542567),
W64LIT(0x32c4fe91c6a777eb),
W64LIT(0x3439102243e215e3),
W64LIT(0xc7714c6bb5d1dc52),
W64LIT(0x3fb7fa6351650f54),
W64LIT(0x87219aaf2e367101),
W64LIT(0xf5b5b2fa7376abb9),
W64LIT(0x412cfba5f3af11fc),
W64LIT(0xdceb691b06e89076),
W64LIT(0xbb12176fc78b4f51),
W64LIT(0x73e8053435086617),
W64LIT(0xe220be193fc5238d),
W64LIT(0xb09cfd2ed50c55e6),
W64LIT(0xb9ea4dad171bc2fa),
W64LIT(0x9e43e51d4d9fb08e),
W64LIT(0x36c14ae093729848),
W64LIT(0xa9fe829cb6a59469),
W64LIT(0x0405b47155d5efa3),
W64LIT(0x0af2c7207acfa618),
W64LIT(0x7e9b01c6a2ca1ea8),
W64LIT(0xdd97447a6ea02cd9),
W64LIT(0x0781c3d2ed0ddea7),
W64LIT(0x7866ef75278f7ca0),
W64LIT(0xd1986de9912ae8c9),
W64LIT(0xcb7e65f84a5b1842),
W64LIT(0xcd838b4bcf1e7a4a),
W64LIT(0xab06d85e663519c2),
W64LIT(0xd4e1f4f9acb7bbc5),
W64LIT(0xfdbf2f18d929800a),
W64LIT(0xf23471289e7b751e),
W64LIT(0xbc93d4bd2a8691f6),
W64LIT(0x3d4fa0a181f582ff),
W64LIT(0xba6e3a0eafc3f3fe),
W64LIT(0x5ab6ded540965dd8),
W64LIT(0xeb560e9afdd2b491),
W64LIT(0x0976b083c217971c),
W64LIT(0xecd7cd4810df6a36),
W64LIT(0x23ac1cc10f519dd7),
W64LIT(0xbe6b8e7ffa161c5d),
W64LIT(0x7fe72ca7ca82a207),
W64LIT(0xc0f08fb958dc02f5),
W64LIT(0x7a9eb5b7f71ff10b),
W64LIT(0xa709f1cd99bfddd2),
W64LIT(0x8dd35d8f54f9d719),
W64LIT(0x8caf70ee3cb16bb6),
W64LIT(0xe4dd50aaba804185),
W64LIT(0x83242ede7be39ea2),
W64LIT(0x98be0baec8dad286),
W64LIT(0x690e0d25ee79969c),
W64LIT(0x95cd0f5c5f18aa39),
W64LIT(0x56b9f746bf1c99c8),
W64LIT(0x7469c6e6d805b8b0),
W64LIT(0x8a529e5db9f409be),
W64LIT(0xe6250a686a10cc2e),
W64LIT(0x2fa33552f0db59c7),
W64LIT(0x42a88c064b7720f8),
W64LIT(0x6d0bb954bbac793f),
W64LIT(0x181e52d30be17d20),
W64LIT(0xbf17a31e925ea0f2),
W64LIT(0x94b1223d37501696),
W64LIT(0xe8d27939450a8595),
W64LIT(0xccffa62aa756c6e5),
W64LIT(0x383639b1bc68d1f3),
W64LIT(0xee2f978ac04fe79d),
W64LIT(0xa30c45bccc6a3271),
W64LIT(0x1f9f9101e6eca387),
W64LIT(0xb1e0d04fbd44e949),
W64LIT(0x242ddf13e25c4370),
W64LIT(0x156d56219c23059f),
W64LIT(0x88aac49f69648415),
W64LIT(0x6280e764fcfe8c2b),
W64LIT(0xdf6f1eb8be30a172),
W64LIT(0xe5a17dcbd2c8fd2a),
W64LIT(0xe0d8e4dbef55ae26),
W64LIT(0x63fcca0594b63084),
W64LIT(0xa1f41f7e1cfabfda),
W64LIT(0x295edbe1759e3bcf),
W64LIT(0x67f97e74c163df27),
W64LIT(0x038477a3b8d83104),
W64LIT(0xde1333d9d6781ddd),
W64LIT(0x3ace63736cf85c58),
W64LIT(0xd619ae3b7c27366e),
W64LIT(0x5bcaf3b428dee177),
W64LIT(0xb3188a8d6dd464e2),
W64LIT(0x1c1be6a25e349283),
W64LIT(0x017c2d616848bcaf),
W64LIT(0x8e572a2cec21e61d),
W64LIT(0xf631c559cbae9abd),
W64LIT(0x81dc741cab731309),
W64LIT(0xff4775da09b90da1),
W64LIT(0xb499495f80d9ba45),
W64LIT(0x0f8b5e304752f514),
W64LIT(0x394a14d0d4206d5c),
W64LIT(0xce07fce877c64b4e),
W64LIT(0xf4c99f9b1b3e1716),
W64LIT(0xc4f53bc80d09ed56),
W64LIT(0xc208d57b884c8f5e),
W64LIT(0x080a9de2aa5f2bb3),
W64LIT(0x314089327e7f46ef),
W64LIT(0xfa3eecca34245ead),
W64LIT(0x20286b62b789acd3),
W64LIT(0x7515eb87b04d041f),
W64LIT(0x513834945211476f),
W64LIT(0x650124b611f3528c),
W64LIT(0x17950ce34cb38834),
W64LIT(0x45294fd4a67afe5f),
W64LIT(0x21544603dfc1107c),
W64LIT(0x485a4b2631b886e0),
W64LIT(0x6872204486312a33),
W64LIT(0x647d09d779bbee23),
W64LIT(0x2551f2728a14ffdf),
W64LIT(0xd765835a146f8ac1),
W64LIT(0xd21c1a4a29f2d9cd),
W64LIT(0x99c226cfa0926e29),
W64LIT(0xfb42c1ab5c6ce202),
W64LIT(0xc374f81ae00433f1),
W64LIT(0x964978ffe7c09b3d),
W64LIT(0xf74de838a3e62612),
/* box 5 */
W64LIT(0x74b87b36b0592c6a),
W64LIT(0x3d82d75dffb4b81c),
W64LIT(0x8884246715267825),
W64LIT(0xdaf2d8a77ed4e5de),
W64LIT(0xfeb118650e53f9c7),
W64LIT(0xbd2d1aea59226b06),
W64LIT(0x26ce87f6dbabb191),
W64LIT(0x32772ecbeb66bd0a),
W64LIT(0xd4bbf82bc5104c8c),
W64LIT(0x055357720c4e03a1),
W64LIT(0xef5be62a32d0f6fd),
W64LIT(0xbe1c84c45d186aca),
W64LIT(0xacc7e4a565a1643c),
W64LIT(0x8dd7731519687b84),
W64LIT(0x11eafe4f3c830f3a),
W64LIT(0x04ef8e68a358afe5),
W64LIT(0x40ad9ca1534b930d),
W64LIT(0xe44191d4855a5c0e),
W64LIT(0x6001d20b809420f1),
W64LIT(0x73666b70173b8243),
W64LIT(0x372479b9e728beab),
W64LIT(0x45fecbd35f0590ac),
W64LIT(0x7057f55e1301838f),
W64LIT(0xff0dc17fa1455583),
W64LIT(0x0cc467b810e804da),
W64LIT(0xb9c29482fa7ac4e3),
W64LIT(0xa003831d754960e6),
W64LIT(0x8a096353be0ad5ad),
W64LIT(0xdd2cc8e1d9b64bf7),
W64LIT(0xc7dc415052bfee3e),
W64LIT(0x9f0c137421d17572),
W64LIT(0x35a93e8d4c041323),
W64LIT(0x9a5f44062d9f76d3),
W64LIT(0x71eb2c44bc172fcb),
W64LIT(0x0ff5f99614d20516),
W64LIT(0x7789e518b4632da6),
W64LIT(0xc99561dce97b476c),
W64LIT(0x5276fcc06bf29dfb),
W64LIT(0x4a0b32454bd795ba),
W64LIT(0x9274add69e2fddec),
W64LIT(0x4f5865374799961b),
W64LIT(0xb2d8e37c4df06e10),
W64LIT(0xc4eddf7e5685eff2),
W64LIT(0xb3643a66e2e6c254),
W64LIT(0xd50721316a06e0c8),
W64LIT(0x8bb5ba49111c79e9),
W64LIT(0x2bb639546455190f),
W64LIT(0xf8d3d1390627fbaa),
W64LIT(0x38d1802ff3fabbbd),
W64LIT(0xdfa18fd5729ae67f),
W64LIT(0x4ee4bc2de88f3a5f),
W64LIT(0xf72628af12f5febc),
W64LIT(0x0aa6aee4189c06b7),
W64LIT(0x0000000000000000),
W64LIT(0x9eb0ca6e8ec7d936),
W64LIT(0xcb1826e84257eae4),
W64LIT(0x187dce8520250841),
W64LIT(0xc28f16225ef1ed9f),
W64LIT(0xc333cf38f1e741db),
W64LIT(0x4220db95f8673e85),
W64LIT(0xdc9011fb76a0e7b3),
W64LIT(0x105627559395a37e),
W64LIT(0x2f59b73cc70db6ea),
W64LIT(0xe112c6a689145faf),
W64LIT(0x82228a830dba7e92),
W64LIT(0x2ee56e26681b1aae),
W64LIT(0x2a0ae04ecb43b54b),
W64LIT(0x47738ce7f4293d24),
W64LIT(0xa7dd935bd22bcecf),
W64LIT(0xd2d93177cd644ee1),
W64LIT(0xebb4684291885918),
W64LIT(0x0e49208cbbc4a952),
W64LIT(0xa550d46f79076347),
W64LIT(0x411145bbfc5d3f49),
W64LIT(0xe6ccd6e02e76f186),
W64LIT(0x4bb7eb5fe4c139fe),
W64LIT(0x5d8305567f2098ed),
W64LIT(0x95aabd90394d73c5),
W64LIT(0x25ff19d8df91b05d),
W64LIT(0x86cd04ebaee2d177),
W64LIT(0x03319e2e043a01cc),
W64LIT(0x6b1ba5f5371e8a02),
W64LIT(0x76353c021b7581e2),
W64LIT(0x64ee5c6323cc8f14),
W64LIT(0x5c3fdc4cd03634a9),
W64LIT(0x6996e2c19c32278a),
W64LIT(0x8938fd7dba30d461),
W64LIT(0x7b4d82a0a48b297c),
W64LIT(0xbfa05ddef20ec68e),
W64LIT(0x8ee6ed3b1d527a48),
W64LIT(0x61bd0b112f828cb5),
W64LIT(0x66631b5788e0229c),
W64LIT(0x55a8ec86cc9033d2),
W64LIT(0x1c9240ed837da7a4),
W64LIT(0x150570279fdba0df),
W64LIT(0x53ca25dac4e431bf),
W64LIT(0xd636bf1f6e3ce104),
W64LIT(0xcaa4fff2ed4146a0),
W64LIT(0x787c1c8ea0b128b0),
W64LIT(0xad7b3dbfcab7c878),
W64LIT(0xfc3c5f51a57f544f),
W64LIT(0xb78bb40e41be6db1),
W64LIT(0x8c6baa0fb67ed7c0),
W64LIT(0xce4b719a4e19e945),
W64LIT(0xf96f0823a93157ee),
W64LIT(0x7d2f4bfcacff2b11),
W64LIT(0x3eb34973fb8eb9d0),
W64LIT(0xe39f81922238f227),
W64LIT(0x239dd084d7e5b230),
W64LIT(0x1fa3dec38747a668),
W64LIT(0xc5510664f99343b6),
W64LIT(0xc829b8c6466deb28),
W64LIT(0x85fc9ac5aad8d0bb),
W64LIT(0xb6376d14eea8c1f5),
W64LIT(0x9d8154408afdd8fa),
W64LIT(0x3be01e01f7c0ba71),
W64LIT(0x628c953f2bb88d79),
W64LIT(0x6d796ca93f6a886f),
W64LIT(0xfa5e960dad0b5622),
W64LIT(0xe5fd48ce2a4cf04a),
W64LIT(0xe7700ffa81605dc2),
W64LIT(0x2dd4f0086c211b62),
W64LIT(0x2221099e78f31e74),
W64LIT(0xdb4e01bdd1c2499a),
W64LIT(0xf417b68116cfff70),
W64LIT(0xb506f33aea92c039),
W64LIT(0x514762ee6fc89c37),
W64LIT(0x9c3d8d5a25eb74be),
W64LIT(0x396d59355cec17f9),
W64LIT(0xccc636aee53544cd),
W64LIT(0x0b1a77feb78aaaf3),
W64LIT(0xe9392f763aa4f490),
W64LIT(0xaaa52df96dd56651),
W64LIT(0x46cf55fd5b3f9160),
W64LIT(0xa4ec0d75d611cf03),
W64LIT(0xaff67a8b619b65f0),
W64LIT(0x3415e797e312bf67),
W64LIT(0x7af15bba0b9d8538),
W64LIT(0x811314ad09807f5e),
W64LIT(0x8771ddf101f47d33),
W64LIT(0x969b23be3d777209),
W64LIT(0xd365e86d6272e2a5),
W64LIT(0x58d05224736e9b4c),
W64LIT(0xc660984afda9427a),
W64LIT(0x5414359c63869f96),
W64LIT(0xe885f66c95b258d4),
W64LIT(0x655285798cda2350),
W64LIT(0x6cc5b5b3907c242b),
W64LIT(0x6ff42b9d944625e7),
W64LIT(0xc0025116f5dd4017),
W64LIT(0xa28ec429de65cd6e),
W64LIT(0x63304c2584ae213d),
W64LIT(0x7fa20cc807d38699),
W64LIT(0x996eda2829a5771f),
W64LIT(0x1b4c50ab241f098d),
W64LIT(0x1e1f07d928510a2c),
W64LIT(0x33cbf7d14470114e),
W64LIT(0xb055a448e6dcc398),
W64LIT(0x98d2033286b3db5b),
W64LIT(0xec6a780436eaf731),
W64LIT(0xa1bf5a07da5fcca2),
W64LIT(0xbaf30aacfe40c52f),
W64LIT(0xf144e1f31a81fcd1),
W64LIT(0xe0ae1fbc2602f3eb),
W64LIT(0x14b9a93d30cd0c9b),
W64LIT(0x596c8b3edc783708),
W64LIT(0x682a3bdb33248bce),
W64LIT(0xb87e4d98556c68a7),
W64LIT(0x80afcdb7a696d31a),
W64LIT(0x5725abb267bc9e5a),
W64LIT(0x914533f89a15dc20),
W64LIT(0x5eb29b787b1a9921),
W64LIT(0x01bcd91aaf16ac44),
W64LIT(0xc1be880c5acbec53),
W64LIT(0xedd6a11e99fc5b75),
W64LIT(0x028d4734ab2cad88),
W64LIT(0x8f5a3421b244d60c),
W64LIT(0x4dd52203ecb53b93),
W64LIT(0x3f0f906954981594),
W64LIT(0xae4aa391ce8dc9b4),
W64LIT(0x3698a0a3483e12ef),
W64LIT(0xf5ab6f9bb9d95334),
W64LIT(0x082be9d0b3b0ab3f),
W64LIT(0xd1e8af59c95e4f2d),
W64LIT(0xd87f9f93d5f84856),
W64LIT(0x6e48f2873b5089a3),
W64LIT(0x2443c0c270871c19),
W64LIT(0xb1e97d5249ca6fdc),
W64LIT(0x7c9392e603e98755),
W64LIT(0x839e5399a2acd2d6),
W64LIT(0x19c1179f8f33a405),
W64LIT(0xde1d56cfdd8c4a3b),
W64LIT(0x20ac4eaad3dfb3fc),
W64LIT(0x1af089b18b09a5c9),
W64LIT(0x3a5cc71b58d61635),
W64LIT(0x444212c9f0133ce8),
W64LIT(0x72dab26ab82d2e07),
W64LIT(0x4c69fb1943a397d7),
W64LIT(0xf3c9a6c7b1ad5159),
W64LIT(0x1d2e99f72c6b0be0),
W64LIT(0xb4ba2a2045846c7d),
W64LIT(0xe22358888d2e5e63),
W64LIT(0x2887a77a606f18c3),
W64LIT(0xa8286acdc6f9cbd9),
W64LIT(0x5f0e4262d40c3565),
W64LIT(0xeee73f309dc65ab9),
W64LIT(0x9be39d1c8289da97),
W64LIT(0x1634ee099be1a113),
W64LIT(0xea08b1583e9ef55c),
W64LIT(0x9727faa49261de4d),
W64LIT(0x2c682912c337b726),
W64LIT(0xcff7a880e10f4501),
W64LIT(0x1788371334f70d57),
W64LIT(0x27725eec74bd1dd5),
W64LIT(0x3146b0e5ef5cbcc6),
W64LIT(0x099730ca1ca6077b),
W64LIT(0xf2757fdd1ebbfd1d),
W64LIT(0x6aa77cef98082646),
W64LIT(0xbb4fd3b65156696b),
W64LIT(0x569972a8c8aa321e),
W64LIT(0xa3321d337173612a),
W64LIT(0x50fbbbf4c0de3073),
W64LIT(0x5a5d1510d84236c4),
W64LIT(0xfd80864b0a69f80b),
W64LIT(0x07de1046a762ae29),
W64LIT(0xa6614a417d3d628b),
W64LIT(0xd78a6605c12a4d40),
W64LIT(0x67dfc24d27f68ed8),
W64LIT(0xbc91c3f0f634c742),
W64LIT(0xd05476436648e369),
W64LIT(0x493aac6b4fed9476),
W64LIT(0x12db606138b90ef6),
W64LIT(0xa994b3d769ef679d),
W64LIT(0x211097b07cc91fb8),
W64LIT(0x30fa69ff404a1082),
W64LIT(0x3c3e0e4750a21458),
W64LIT(0x7504a22c1f4f802e),
W64LIT(0x844043df05ce7cff),
W64LIT(0xf0f838e9b5975095),
W64LIT(0x7e1ed5d2a8c52add),
W64LIT(0x90f9eae235037064),
W64LIT(0x0662c95c0874026d),
W64LIT(0x9416648a965bdf81),
W64LIT(0xf69af1b5bde352f8),
W64LIT(0x0d78bea2bffea89e),
W64LIT(0x293b7e60cf79b487),
W64LIT(0xd9c346897aeee412),
W64LIT(0xfbe24f17021dfa66),
W64LIT(0x1367b97b97afa2b2),
W64LIT(0xab19f4e3c2c3ca15),
W64LIT(0x48867571e0fb3832),
W64LIT(0x93c874cc313971a8),
W64LIT(0x79c0c5940fa784f4),
W64LIT(0xcd7aefb44a23e889),
W64LIT(0x439c028f577192c1),
W64LIT(0x5be1cc0a77549a80),
/* box 6 */
W64LIT(0x714d28d778656928),
W64LIT(0xc88a7c6b84f64f7c),
W64LIT(0xec43cac5ab89aaca),
W64LIT(0x777fa38110dc16a3),
W64LIT(0x0f7d5c87e4213b5c),
W64LIT(0x73f051e5f3a1ef51),
W64LIT(0xea714193c330d541),
W64LIT(0x95e5f3dae016c4f3),
W64LIT(0x63d3738095a0e173),
W64LIT(0x9825d66f8ff379d6),
W64LIT(0xe8cc38a148f45338),
W64LIT(0xa840b0c025f06bb0),
W64LIT(0x944135c35f748735),
W64LIT(0x74661caa247ad31c),
W64LIT(0xe7b16426acd56864),
W64LIT(0xd1e689df6e6f0589),
W64LIT(0xa73dec47c1d150ec),
W64LIT(0x64453ecf427bdd3e),
W64LIT(0x0ed99a9e5b43789a),
W64LIT(0x7b1b402dc05be840),
W64LIT(0x0dc025b56fe5bd25),
W64LIT(0x3f183a284e22293a),
W64LIT(0xa0aba108160a6ca1),
W64LIT(0x46be033705bd4703),
W64LIT(0x86df6e94b2b10f6e),
W64LIT(0xa216d83a9dceead8),
W64LIT(0x129e5b57edc5885b),
W64LIT(0x7e3074509c445274),
W64LIT(0x7d29cb7ba8e297cb),
W64LIT(0x1611a9330eb871a9),
W64LIT(0x486799a95efe3f99),
W64LIT(0x9fb39b205828459b),
W64LIT(0xd0424fc6d10d464f),
W64LIT(0xe968feb8f79610fe),
W64LIT(0x5d6f8fb164e08b8f),
W64LIT(0xaafdc9f2ae34edc9),
W64LIT(0x02bd79328bc48679),
W64LIT(0x9b3c6944bb55bc69),
W64LIT(0x6277b5992ac2a2b5),
W64LIT(0x877ba88d0dd34ca8),
W64LIT(0xfa5263f6a531db63),
W64LIT(0x2e9fde54974164de),
W64LIT(0xcda14816d8e9f548),
W64LIT(0x675c81e476dd1881),
W64LIT(0x2a102c30743c9d2c),
W64LIT(0x37f32be07dd82e2b),
W64LIT(0x256d70b7901da670),
W64LIT(0x4ce86bcdbd83c66b),
W64LIT(0x50afaa040b0536aa),
W64LIT(0xef5a75ee9f2f6f75),
W64LIT(0xb3913c4644ada73c),
W64LIT(0x1187e47cd9634de4),
W64LIT(0xc54a59deeb13f259),
W64LIT(0x0000000000000000),
W64LIT(0x01a4c619bf6243c6),
W64LIT(0x90cec7a7bc097ec7),
W64LIT(0xf94bdcdd91971edc),
W64LIT(0x8e347f5c814b087f),
W64LIT(0xc7f720ec60d77420),
W64LIT(0x354e52d2f61ca852),
W64LIT(0x34ea94cb497eeb94),
W64LIT(0xae723b964d49143b),
W64LIT(0xf48bf968fe72a3f9),
W64LIT(0xfc60e8a0cd88a4e8),
W64LIT(0x2909931b409a5893),
W64LIT(0xbd48a6d81feedfa6),
W64LIT(0x6cae2f077181da2f),
W64LIT(0xad6b84bd79efd184),
W64LIT(0x18c833ad55fb0933),
W64LIT(0x204644cacc021c44),
W64LIT(0x392ab17e269b56b1),
W64LIT(0x14acd001857cf7d0),
W64LIT(0x8abb8d386236f18d),
W64LIT(0xeefeb3f7204d2cb3),
W64LIT(0xf636805a75b62580),
W64LIT(0x2bb4ea29cb5edeea),
W64LIT(0xc653e6f5dfb537e6),
W64LIT(0x8d2dc077b5edcdc0),
W64LIT(0x31c1a0b6156151a0),
W64LIT(0xf8ef1ac42ef55d1a),
W64LIT(0xdbb0e125d65184e1),
W64LIT(0x82509cf051ccf69c),
W64LIT(0xe33e96424fa89196),
W64LIT(0xdf3f1341352c7d13),
W64LIT(0x8f90b9453e294bb9),
W64LIT(0x1023226566010e22),
W64LIT(0xa58095754a15d695),
W64LIT(0x2c22a7661c85e2a7),
W64LIT(0xe183ef70c46c17ef),
W64LIT(0xafd6fd8ff22b57fd),
W64LIT(0x471ac52ebadf04c5),
W64LIT(0x4d4cadd402e185ad),
W64LIT(0x916a01be036b3d01),
W64LIT(0x28ad5502fff81b55),
W64LIT(0x3657edf9c2ba6ded),
W64LIT(0xd2ff36f45ac9c036),
W64LIT(0xf1a0cd15a26d19cd),
W64LIT(0xd90d98175d950298),
W64LIT(0xf7924643cad46646),
W64LIT(0xdd826a73bee8fb6a),
W64LIT(0x9d0ee212d3ecc3e2),
W64LIT(0xb6ba083b18b21d08),
W64LIT(0x3da5431ac5e6af43),
W64LIT(0x08eb11c833fa0711),
W64LIT(0x052b347d5c1fba34),
W64LIT(0x6fb7902c45271f90),
W64LIT(0x133a9d4e52a7cb9d),
W64LIT(0x6e135635fa455c56),
W64LIT(0x725497fc4cc3ac97),
W64LIT(0xf31db42729a99fb4),
W64LIT(0x846217a639758917),
W64LIT(0x4b7e26826a58fa26),
W64LIT(0x235ffbe1f8a4d9fb),
W64LIT(0xff79578bf92e6157),
W64LIT(0xda14273c6933c727),
W64LIT(0x8b1f4b21dd54b24b),
W64LIT(0x9caa240b6c8e8024),
W64LIT(0xc1c5abba086e0bab),
W64LIT(0xde9bd5588a4e3ed5),
W64LIT(0x2d86617fa3e7a161),
W64LIT(0xbff5dfea942a59df),
W64LIT(0x66f847fdc9bf5b47),
W64LIT(0x3b97c84cad5fd0c8),
W64LIT(0x3ebcfc31f1406afc),
W64LIT(0xca3705590f32c905),
W64LIT(0x24c9b6ae2f7fe5b6),
W64LIT(0x408c88616d043888),
W64LIT(0x93d7788c88afbb78),
W64LIT(0x196cf5b4ea994af5),
W64LIT(0x9a98af5d0437ffaf),
W64LIT(0x8c89066e0a8f8e06),
W64LIT(0xab590feb1156ae0f),
W64LIT(0xd7d4028906d67a02),
W64LIT(0xe4a8db0d9873addb),
W64LIT(0xc378d28883aa8dd2),
W64LIT(0x4ff1d4e6892503d4),
W64LIT(0xd670c490b9b439c4),
W64LIT(0x65e1f8d6fd199ef8),
W64LIT(0xf2b9723e96cbdc72),
W64LIT(0xb12c4574cf692145),
W64LIT(0x569d215263bc4921),
W64LIT(0x69851b7a2d9e601b),
W64LIT(0x5e76309a50464e30),
W64LIT(0x5fd2f683ef240df6),
W64LIT(0xd8a95e0ee2f7415e),
W64LIT(0xe29a505bf0cad250),
W64LIT(0x96fc4cf1d4b0014c),
W64LIT(0x8806f40ae9f277f4),
W64LIT(0x53b6152f3fa3f315),
W64LIT(0x1c47c1c9b686f0c1),
W64LIT(0x80ede5c2da0870e5),
W64LIT(0xd5697bbb8d12fc7b),
W64LIT(0xfdc42eb972eae72e),
W64LIT(0x0bf2aee3075cc2ae),
W64LIT(0x22fb3df847c69a3d),
W64LIT(0xbadeeb97c835e3eb),
W64LIT(0xdc26ac6a018ab8ac),
W64LIT(0xbcec60c1a08c9c60),
W64LIT(0x4231f153e6c0bef1),
W64LIT(0x337cd9849ea5d7d9),
W64LIT(0x5b5d04e70c59f404),
W64LIT(0x79a6391f4b9f6e39),
W64LIT(0x5212d33680c1b0d3),
W64LIT(0xb5a3b7102c14d8b7),
W64LIT(0x7f94b249232611b2),
W64LIT(0x17b56f2ab1da326f),
W64LIT(0x59e07dd5879d727d),
W64LIT(0xebd5878a7c529687),
W64LIT(0xbb7a2d8e7757a02d),
W64LIT(0x0319bf2b34a6c5bf),
W64LIT(0x5ccb49a8db82c849),
W64LIT(0x1de307d009e4b307),
W64LIT(0x49c35fb0e19c7c5f),
W64LIT(0x55849e79571a8c9e),
W64LIT(0x7abf86347f39ab86),
W64LIT(0x9273be9537cdf8be),
W64LIT(0xe615a23f13b72ba2),
W64LIT(0x6821dd6392fc23dd),
W64LIT(0x5af9c2feb33bb7c2),
W64LIT(0x06328b5668b97f8b),
W64LIT(0x44037a058e79c17a),
W64LIT(0x83f45ae9eeaeb55a),
W64LIT(0x5739e74bdcde0ae7),
W64LIT(0xfbf6a5ef1a5398a5),
W64LIT(0xe50c1d142711ee1d),
W64LIT(0x1a754a9fde3f8f4a),
W64LIT(0x7802ff06f4fd2dff),
W64LIT(0xf52f3f714110e03f),
W64LIT(0x2674cf9ca4bb63cf),
W64LIT(0x60caccaba10624cc),
W64LIT(0xb088836d700b6283),
W64LIT(0xa6992a5e7eb3132a),
W64LIT(0xa9e476d99a922876),
W64LIT(0x6b386248a65ae662),
W64LIT(0xc2dc14913cc8ce14),
W64LIT(0x76db6598afbe5565),
W64LIT(0x32d81f9d21c7941f),
W64LIT(0x21e282d373605f82),
W64LIT(0xc0616da3b70c486d),
W64LIT(0x616e0ab21e64670a),
W64LIT(0x6d0ae91ecee399e9),
W64LIT(0x27d009851bd92009),
W64LIT(0xfedd9192464c2291),
W64LIT(0x45a7bc1c311b82bc),
W64LIT(0x54205860e878cf58),
W64LIT(0xa10f6711a9682f67),
W64LIT(0x9981107630913a10),
W64LIT(0xede70cdc14ebe90c),
W64LIT(0x70e9eecec7072aee),
W64LIT(0x1f5e7ee28220357e),
W64LIT(0x2f3b184d28232718),
W64LIT(0x41284e78d2667b4e),
W64LIT(0xa424536cf5779553),
W64LIT(0xa3b21e2322aca91e),
W64LIT(0x4e5512ff36474012),
W64LIT(0x1efab8fb3d4276b8),
W64LIT(0x89a2321356903432),
W64LIT(0xcb93c340b0508ac3),
W64LIT(0x306566afaa031266),
W64LIT(0x4adae09bd53ab9e0),
W64LIT(0xc92eba723b940cba),
W64LIT(0x094fd7d18c9844d7),
W64LIT(0xcc058e0f678bb68e),
W64LIT(0xd4cdbda23270bfbd),
W64LIT(0x0a5668fab83e8168),
W64LIT(0x510b6c1db467756c),
W64LIT(0xb86392a543f16592),
W64LIT(0x048ff264e37df9f2),
W64LIT(0x3a330e55123d930e),
W64LIT(0xb235fa5ffbcfe4fa),
W64LIT(0xb9c754bcfc932654),
W64LIT(0x3c0185037a84ec85),
W64LIT(0x0c64e3acd087fee3),
W64LIT(0xe02729697b0e5429),
W64LIT(0x07964d4fd7db3c4d),
W64LIT(0x814923db656a3323),
W64LIT(0x388e776799f91577),
W64LIT(0x6a9ca4511938a5a4),
W64LIT(0x1bd18c86615dcc8c),
W64LIT(0xb407710993769b71),
W64LIT(0x150816183a1eb416),
W64LIT(0x4395374a59a2fd37),
W64LIT(0xc4ee9fc75471b19f),
W64LIT(0x5844bbcc38ff31bb),
W64LIT(0xcf1c3124532d7331),
W64LIT(0xb71ece22a7d05ece),
W64LIT(0xaccf42a4c68d9242),
W64LIT(0x97588ae86bd2428a),
W64LIT(0x75c2dab39b1890da),
W64LIT(0x9e175d39e74a065d),
W64LIT(0xf0040b0c1d0f5a0b),
W64LIT(0xceb8f73dec4f30f7),
W64LIT(0xbe5119f32b481a19),
W64LIT(0xd35bf0ede5ab83f0),
W64LIT(0x7c8d0d621780d40d),
W64LIT(0x85c6d1bf8617cad1),
/* box 7 */
W64LIT(0xb1c742127b66f2a4),
W64LIT(0xce916098d7a59fc1),
W64LIT(0xc312ef8e2406fa70),
W64LIT(0x956c7dced81403d5),
W64LIT(0x5a0c9b2318dd9520),
W64LIT(0xad0d57f51a480e8b),
W64LIT(0xe7b9d05287740b01),
W64LIT(0x0217f9ea2ed81268),
W64LIT(0x4d7cff19f8cd3a06),
W64LIT(0x44d1772e572b7b67),
W64LIT(0xfb73c5b5e65af72e),
W64LIT(0x91427aef84512705),
W64LIT(0x0c720963e4cf6c85),
W64LIT(0x87c398a0732d8117),
W64LIT(0xa17f5e96fe87620e),
W64LIT(0x50476c8b8e8fcf1d),
W64LIT(0xcb4ee1cc9c8cb225),
W64LIT(0x67b2304c91a8b59a),
W64LIT(0x54696baad2caebcd),
W64LIT(0xddcf03836bf01437),
W64LIT(0x46c68ec479f3690f),
W64LIT(0x8f9f96e2cba7c942),
W64LIT(0xe1802e99f5e93db9),
W64LIT(0x4e9a8086c179215a),
W64LIT(0xf0c9b4686764a427),
W64LIT(0xfd4a3b7e94c7c196),
W64LIT(0xfcbbbd0b83abc8a2),
W64LIT(0xebcbd93163bb6784),
W64LIT(0xf9643c5fc882e546),
W64LIT(0xc4da973041f7c5fc),
W64LIT(0x1af3eb2c13b3ca97),
W64LIT(0x6e1fb87b3e4ef4fb),
W64LIT(0x5e229c024498b1f0),
W64LIT(0xf516353c2c4d89c3),
W64LIT(0xcc869972f97d8da9),
W64LIT(0x8d886f08e57fdb2a),
W64LIT(0x1cca15e7612efc2f),
W64LIT(0x567e9240fc12f9a5),
W64LIT(0x43190f9032da44eb),
W64LIT(0xfeac44e1ad73daca),
W64LIT(0x07c878be65f13f8c),
W64LIT(0x618bce87e3358322),
W64LIT(0xf895ba2adfeeec72),
W64LIT(0x751dd5223a913758),
W64LIT(0x59eae4bc21698e7c),
W64LIT(0xff5dc294ba1fd3fe),
W64LIT(0x03e67f9f39b41b5c),
W64LIT(0x2292c117d1efc7c9),
W64LIT(0x8a4017b6808ee4a6),
W64LIT(0xd1bd0ae08f3f78b2),
W64LIT(0x135e631bbc558bf6),
W64LIT(0xee14586528924a60),
W64LIT(0x8857ee5cae56f6ce),
W64LIT(0x0000000000000000),
W64LIT(0x0e65f089ca177eed),
W64LIT(0x34132358269361db),
W64LIT(0x15679dd0cec8bd4e),
W64LIT(0x800be01e16dcbe9b),
W64LIT(0x949dfbbbcf780ae1),
W64LIT(0xe397d773db312fd1),
W64LIT(0xedf227fa1126513c),
W64LIT(0xb5e945332723d674),
W64LIT(0x53a11314b73bd441),
W64LIT(0x23634762c683cefd),
W64LIT(0x4b4501d28a500cbe),
W64LIT(0x473708b16e9f603b),
W64LIT(0x1770643ae010af26),
W64LIT(0xa746a05d8c1a54b6),
W64LIT(0x90b3fc9a933d2e31),
W64LIT(0x35e2a52d31ff68ef),
W64LIT(0xab34a93e68d53833),
W64LIT(0xd81082d720d939d3),
W64LIT(0xb86aca25d480b3c5),
W64LIT(0xdfd8fa694528065f),
W64LIT(0x4f6b06f3d615286e),
W64LIT(0x578f1435eb7ef091),
W64LIT(0x9af80b32056f740c),
W64LIT(0x92a40570bde53c59),
W64LIT(0xdbf6fd48196d228f),
W64LIT(0x1b026d5904dfc3a3),
W64LIT(0x3c4f2d1a9e19298e),
W64LIT(0xc8a89e53a538a979),
W64LIT(0x991e74ad3cdb6f50),
W64LIT(0x042e07215c4524d0),
W64LIT(0x8e6e1097dccbc076),
W64LIT(0xe071a8ece285348d),
W64LIT(0xd784f42bfda24e0a),
W64LIT(0x7d41db60821b7f0d),
W64LIT(0x85d4614a5df5937f),
W64LIT(0xbb8cb5baed34a899),
W64LIT(0x40ff700f0b6e5fb7),
W64LIT(0x2cf7319e1bf8b924),
W64LIT(0x3a76d3d1ec841f36),
W64LIT(0x4520f15b40477253),
W64LIT(0xf138321d7008ad13),
W64LIT(0x42e889e525b64ddf),
W64LIT(0x65a5c9a6bf70a7f2),
W64LIT(0x208538fdff37d5a1),
W64LIT(0x410ef67a1c025683),
W64LIT(0x18e412c63d6bd8ff),
W64LIT(0x72d5ad9c5f6008d4),
W64LIT(0x255ab9a9b41ef845),
W64LIT(0x93558305aa89356d),
W64LIT(0x70c2547671b81abc),
W64LIT(0x3604dab2084b73b3),
W64LIT(0x05df81544b292de4),
W64LIT(0xf2de4d8249bcb64f),
W64LIT(0x0bba71dd813e5309),
W64LIT(0xa368a77cd05f7066),
W64LIT(0x796fdc41de5e5bdd),
W64LIT(0xec03a18f064a5808),
W64LIT(0x085c0e42b88a4855),
W64LIT(0x274d40439ac6ea2d),
W64LIT(0x31cca20c6dba4c3f),
W64LIT(0x322add93540e5763),
W64LIT(0xb60f3aac1e97cd28),
W64LIT(0x7cb05d1595777639),
W64LIT(0xb036c4676c0afb90),
W64LIT(0x0a4bf7a896525a3d),
W64LIT(0x73242be9480c01e0),
W64LIT(0x5bfd1d560fb19c14),
W64LIT(0x7b7825abf08649b5),
W64LIT(0xb7febcd909fbc41c),
W64LIT(0x81fa666b01b0b7af),
W64LIT(0xd25b757fb68b63ee),
W64LIT(0x0d838f16f3a365b1),
W64LIT(0x6a31bf5a620bd02b),
W64LIT(0x26bcc6368daae319),
W64LIT(0x9ed60c13592a50dc),
W64LIT(0x581b62c936058748),
W64LIT(0x9cc1f5f977f242b4),
W64LIT(0x83ed9f812f68a5c7),
W64LIT(0x74ec53572dfd3e6c),
W64LIT(0xb3d0bbf855bee0cc),
W64LIT(0xacfcd1800d2407bf),
W64LIT(0x303d24797ad6450b),
W64LIT(0x7a89a3dee7ea4081),
W64LIT(0x69d7c0c55bbfcb77),
W64LIT(0x770a2cc814492530),
W64LIT(0x0f9476fcdd7b77d9),
W64LIT(0xaeeb286a23fc15d7),
W64LIT(0x2174be88e85bdc95),
W64LIT(0xde297c1c52440f6b),
W64LIT(0xd04c8c9598537186),
W64LIT(0x2ee0c8743520ab4c),
W64LIT(0x977b8424f6cc11bd),
W64LIT(0x10b81c8485e190aa),
W64LIT(0xa4a0dfc2b5ae4fea),
W64LIT(0x98eff2d82bb76664),
W64LIT(0xa8d2d6a15161236f),
W64LIT(0xd4628bb4c4165556),
W64LIT(0x682646b04cd3c243),
W64LIT(0x2d06b7eb0c94b010),
W64LIT(0x626db118da81987e),
W64LIT(0x2928b0ca50d194c0),
W64LIT(0x6df9c7e407faefa7),
W64LIT(0x1681e24ff77ca612),
W64LIT(0x4952f838a4881ed6),
W64LIT(0x76fbaabd03252c04),
W64LIT(0xc73ce8af7843dea0),
W64LIT(0xe82da6ae5a0f7cd8),
W64LIT(0xc10516640adee818),
W64LIT(0x968a0251e1a01889),
W64LIT(0x37f55cc71f277a87),
W64LIT(0xe5ae29b8a9ac1969),
W64LIT(0xcabf67b98be0bb11),
W64LIT(0xf4e7b3493b2180f7),
W64LIT(0xe9dc20db4d6375ec),
W64LIT(0x639c376dcded914a),
W64LIT(0x12afe56eab3982c2),
W64LIT(0xc2e369fb336af344),
W64LIT(0xa6b726289b765d82),
W64LIT(0x14961ba5d9a4b47a),
W64LIT(0xbc44cd0488c59715),
W64LIT(0xd3aaf30aa1e76ada),
W64LIT(0x28d936bf47bd9df4),
W64LIT(0xaf1aae1f34901ce3),
W64LIT(0x2f114e01224ca278),
W64LIT(0xe648562790180235),
W64LIT(0x24ab3fdca372f171),
W64LIT(0x52509561a057dd75),
W64LIT(0xc6cd6eda6f2fd794),
W64LIT(0xa08ed8e3e9eb6b3a),
W64LIT(0x09ad8837afe64161),
W64LIT(0xbdb54b719fa99e21),
W64LIT(0x8c79e97df213d21e),
W64LIT(0xcf60e6edc0c996f5),
W64LIT(0x5dc4e39d7d2caaac),
W64LIT(0x11499af1928d999e),
W64LIT(0x5fd31a7753f4b8c4),
W64LIT(0x01f18675176c0934),
W64LIT(0xc52b1145569bccc8),
W64LIT(0x9f278a664e4659e8),
W64LIT(0x3dbeab6f897520ba),
W64LIT(0xa2992109c7337952),
W64LIT(0x9b098d4712037d38),
W64LIT(0xc9591826b254a04d),
W64LIT(0x3b8755a4fbe81602),
W64LIT(0xbe5334eea61d857d),
W64LIT(0x51b6eafe99e3c629),
W64LIT(0x191594b32a07d1cb),
W64LIT(0x1f2c6a78589ae773),
W64LIT(0x3fa95285a7ad32d2),
W64LIT(0x5c3565e86a40a398),
W64LIT(0xb2213d8d42d2e9f8),
W64LIT(0xefe5de103ffe4354),
W64LIT(0x4ab487a79d3c058a),
W64LIT(0xcd771f07ee11849d),
W64LIT(0xbfa2b29bb1718c49),
W64LIT(0xba7d33cffa58a1ad),
W64LIT(0x6fee3e0e2922fdcf),
W64LIT(0x64544fd3a81caec6),
W64LIT(0xd9e104a237b530e7),
W64LIT(0xf32fcbf75ed0bf7b),
W64LIT(0x3e58d4f0b0c13be6),
W64LIT(0xb418c346304fdf40),
W64LIT(0xaac52f4b7fb93107),
W64LIT(0xdc3e85f67c9c1d03),
W64LIT(0xd5930dc1d37a5c62),
W64LIT(0x0639fecb729d36b8),
W64LIT(0xc0f490111db2e12c),
W64LIT(0x7ea7a4ffbbaf6451),
W64LIT(0xf6f04aa315f9929f),
W64LIT(0x6643b63986c4bcae),
W64LIT(0x6c0841911096e693),
W64LIT(0x8425e73f4a999a4b),
W64LIT(0x7133d20366d41388),
W64LIT(0x38612a3bc25c0d5e),
W64LIT(0xb99b4c50c3ecbaf1),
W64LIT(0x1d3b93927642f51b),
W64LIT(0x7f56228aacc36d65),
W64LIT(0x9d30738c609e4b80),
W64LIT(0x48a37e4db3e417e2),
W64LIT(0x8bb191c397e2ed92),
W64LIT(0x2acecf5569658f9c),
W64LIT(0xda077b3d0e012bbb),
W64LIT(0xa55159b7a2c246de),
W64LIT(0x33db5be643625e57),
W64LIT(0x821c19f43804acf3),
W64LIT(0x3990ac4ed530046a),
W64LIT(0xd675725eeace473e),
W64LIT(0x789e5a34c93252e9),
W64LIT(0x86321ed564418823),
W64LIT(0xfa8243c0f136fe1a),
W64LIT(0xe45fafcdbec0105d),
W64LIT(0x2b3f49207e0986a8),
W64LIT(0xa92350d4460d2a5b),
W64LIT(0x1eddec0d4ff6ee47),
W64LIT(0x89a66829b93afffa),
W64LIT(0x607a48f2f4598a16),
W64LIT(0x6bc0392f7567d91f),
W64LIT(0xea3a5f4474d76eb0),
W64LIT(0x5598eddfc5a6e2f9),
W64LIT(0x4c8d796cefa13332),
W64LIT(0xf701ccd602959bab),
W64LIT(0xe2665106cc5d26e5),
};

static const word64 SHARK_dec_cbox[8*256] =
{
/* box 0 */
W64LIT(0xe6126af05e55aff3),
W64LIT(0x4b6c893f310b0835),
W64LIT(0xaa4c0e84ebfc8d57),
W64LIT(0xfb9b5c7bf3b3090d),
W64LIT(0x4508a6a9ccba5ce2),
W64LIT(0xe5d1d2064dc6bde9),
W64LIT(0x348343755288edde),
W64LIT(0xb684505de46b250c),
W64LIT(0xa8cede205a1e91e8),
W64LIT(0x40b89b46f9fa6acc),
W64LIT(0x8ee1ec1afab080ba),
W64LIT(0xde77d6b7408e0a45),
W64LIT(0x9a3e184c2e455802),
W64LIT(0xbe93fad23f0955ef),
W64LIT(0x3ae76ce3af39b909),
W64LIT(0xad7ee3cf6f5ea7c6),
W64LIT(0x8b51d1f5cff0b694),
W64LIT(0x70ca8d8e3c43bf99),
W64LIT(0xccdba7f8b2a8f6c9),
W64LIT(0x4c5e6474b5a922a4),
W64LIT(0x5d31adcd541ccc32),
W64LIT(0x9b7f701e8c3456a7),
W64LIT(0x2ac9cd08ecfd593a),
W64LIT(0x8fa0844858c18e1f),
W64LIT(0x32f0c66c745bc9ea),
W64LIT(0xc58d6525cbbb888f),
W64LIT(0x8c633cbe4b529c05),
W64LIT(0xf2cd9ea68aa0774b),
W64LIT(0x2cba4811ca2e7d0e),
W64LIT(0xe2e33f4dc9649778),
W64LIT(0xf4be1bbfac73537f),
W64LIT(0x22de6787379f29d9),
W64LIT(0x0956c2dd79137e46),
W64LIT(0xe061efe978868bc7),
W64LIT(0x1cc85ed90f97a85b),
W64LIT(0x31337e9a67c8dbf0),
W64LIT(0x360193d1e36af161),
W64LIT(0x7fefca4a6383e5eb),
W64LIT(0x8535fe633241e243),
W64LIT(0xc3fee03ced68acbb),
W64LIT(0x81c4abdea570dac8),
W64LIT(0x67d6c12efb25753b),
W64LIT(0xa4282112164dd980),
W64LIT(0xcf181f0ea13be4d3),
W64LIT(0xa98fb672f86f9f4d),
W64LIT(0x5c70c59ff66dc297),
W64LIT(0xb0f7d544c2b80138),
W64LIT(0x0da79760ee2246cd),
W64LIT(0x3740fb83411bffc4),
W64LIT(0x24ade29e114c0ded),
W64LIT(0xf858e48de0201b17),
W64LIT(0x0e642f96fdb154d7),
W64LIT(0xddb46e41531d185f),
W64LIT(0x25ec8accb33d0348),
W64LIT(0x0282d0a4b1e21cbf),
W64LIT(0x1bfab3928b3582ca),
W64LIT(0xaffc336bdebcbb79),
W64LIT(0x35c22b27f0f9e37b),
W64LIT(0x03c3b8f61393121a),
W64LIT(0xb8e07fcb19da71db),
W64LIT(0x99fda0ba3dd64a18),
W64LIT(0xce59775c034aea76),
W64LIT(0x49ee599b80e9148a),
W64LIT(0xfe2b6194c6f33f23),
W64LIT(0x4edcb4d0044b3e1b),
W64LIT(0xd5a3c4ce887f68bc),
W64LIT(0xdf36bee5e2ff04e0),
W64LIT(0x171c4ca0c766caa2),
W64LIT(0x0bd41279c8f162f9),
W64LIT(0xe490ba54efb7b34c),
W64LIT(0x5b4228d472cfe806),
W64LIT(0x5355825ba9ad98e5),
W64LIT(0x9f8e25a31b056e2c),
W64LIT(0xcd9acfaa10d9f86c),
W64LIT(0x88926903dc63a48e),
W64LIT(0xb40680f9558939b3),
W64LIT(0x239f0fd595ee277c),
W64LIT(0xec8710db34d5c3af),
W64LIT(0x87b72ec783a3fefc),
W64LIT(0x632794936c144db0),
W64LIT(0x46cb1e5fdf294ef8),
W64LIT(0x83467b7a1492c677),
W64LIT(0x9c4d9d5508967c36),
W64LIT(0xd6607c389bec7aa6),
W64LIT(0x165d24f26517c407),
W64LIT(0xc4cc0d7769ca862a),
W64LIT(0xcbe94ab3360adc58),
W64LIT(0x847496319030ece6),
W64LIT(0x7a5ff7a556c3d3c5),
W64LIT(0xc03d58cafefbbea1),
W64LIT(0x76b908971a909bad),
W64LIT(0x2f79f0e7d9bd6f14),
W64LIT(0x197863363ad79e75),
W64LIT(0xda86830ad7bf32ce),
W64LIT(0x5a034086d0bee6a3),
W64LIT(0x97998f2cc0671ecf),
W64LIT(0x552607428f7ebcd1),
W64LIT(0x51d752ff184f845a),
W64LIT(0xbb23c73d0a4963c1),
W64LIT(0x2b88a55a4e8c579f),
W64LIT(0xd80453ae665d2e71),
W64LIT(0xee05c07f8537df10),
W64LIT(0x423a4be248187673),
W64LIT(0xcaa822e1947bd2fd),
W64LIT(0x1abbdbc029448c6f),
W64LIT(0x96d8e77e6216106a),
W64LIT(0x6266fcc1ce654315),
W64LIT(0x89d301517e12aa2b),
W64LIT(0x730935782fd0ad83),
W64LIT(0x8085c38c0701d46d),
W64LIT(0x6b303e1cb7763d53),
W64LIT(0x3f57510c9a798f27),
W64LIT(0x4449cefb6ecb5247),
W64LIT(0x48af31c922981a2f),
W64LIT(0x98bcc8e89fa744bd),
W64LIT(0x69b2eeb8069421ec),
W64LIT(0xebb5fd90b077e93e),
W64LIT(0x6a71564e150733f6),
W64LIT(0x116fc9b9e1b5ee96),
W64LIT(0x4a2de16d937a0690),
W64LIT(0xb9a11799bbab7f7e),
W64LIT(0x9368da9157562644),
W64LIT(0x718be5dc9e32b13c),
W64LIT(0xc82af2452599ce42),
W64LIT(0xb547e8abf7f83716),
W64LIT(0x33b1ae3ed62ac74f),
W64LIT(0x799c4f534550c1df),
W64LIT(0x3e16395e38088182),
W64LIT(0x7c2c72bc7010f7f1),
W64LIT(0xf38cf6f428d179ee),
W64LIT(0xd29129850cdd422d),
W64LIT(0x41f9f3145b8b6469),
W64LIT(0x945a37dad3f40cd5),
W64LIT(0x757ab061090389b7),
W64LIT(0x6554118a4ac76984),
W64LIT(0x7d6d1aeed261f954),
W64LIT(0x01416852a2710ea5),
W64LIT(0xb27505e0735a1d87),
W64LIT(0x77f860c5b8e19508),
W64LIT(0x78dd2701e721cf7a),
W64LIT(0xe12087bbdaf78562),
W64LIT(0x86f6469521d2f059),
W64LIT(0xef44a82d2746d1b5),
W64LIT(0xbc112a768eeb4950),
W64LIT(0xc2bf886e4f19a21e),
W64LIT(0x307216c8c5b9d555),
W64LIT(0xc96b9a1787e8c0e7),
W64LIT(0xa31acc5992eff311),
W64LIT(0xa0d974af817ce10b),
W64LIT(0xdcf50613f16c16fa),
W64LIT(0xfca9b1307711239c),
W64LIT(0x57a4d7e63e9ca06e),
W64LIT(0xc64eddd3d8289a95),
W64LIT(0xa25ba40b309efdb4),
W64LIT(0x2e3898b57bcc61b1),
W64LIT(0xf5ff73ed0e025dda),
W64LIT(0xa6aaf1b6a7afc53f),
W64LIT(0xd9453bfcc42c20d4),
W64LIT(0x9d0cf507aae77293),
W64LIT(0x290a75feff6e4b20),
W64LIT(0xa7eb99e405decb9a),
W64LIT(0xa1981cfd230defae),
W64LIT(0x12ac714ff226fc8c),
W64LIT(0x743bd833ab728712),
W64LIT(0x6c02d35733d417c2),
W64LIT(0xe9372d340195f581),
W64LIT(0xf77da349bfe04165),
W64LIT(0x68f386eaa4e52f49),
W64LIT(0x211ddf71240c3bc3),
W64LIT(0x13ed191d5057f229),
W64LIT(0xe8764566a3e4fb24),
W64LIT(0xf9198cdf425115b2),
W64LIT(0xd013f921bd3f5e92),
W64LIT(0x91ea0a35e6b43afb),
W64LIT(0x0732ed4b84a22a91),
W64LIT(0xeaf495c21206e79b),
W64LIT(0x5214ea090bdc9640),
W64LIT(0x0000000000000000),
W64LIT(0xb3346db2d12b1322),
W64LIT(0x0ce6ff324c534868),
W64LIT(0xaebd5b397ccdb5dc),
W64LIT(0x0a957a2b6a806c5c),
W64LIT(0x1f0be62f1c04ba41),
W64LIT(0x14dff456d4f5d8b8),
W64LIT(0x58819022615cfa1c),
W64LIT(0x05b03def3540362e),
W64LIT(0xe3a2571f6b1599dd),
W64LIT(0x9229b2c3f52728e1),
W64LIT(0xba62af6fa8386d64),
W64LIT(0x0673851926d32434),
W64LIT(0x641579d8e8b66721),
W64LIT(0x04f155bd9731388b),
W64LIT(0x9ecf4df1b9746089),
W64LIT(0x205cb723867d3566),
W64LIT(0x102ea1eb43c4e033),
W64LIT(0x3ba604b10d48b7ac),
W64LIT(0x50963aadba3e8aff),
W64LIT(0xac3f8b9dcd2fa963),
W64LIT(0x7b1e9ff7f4b2dd60),
W64LIT(0xf63ccb1b1d914fc0),
W64LIT(0x7eaea218c1f2eb4e),
W64LIT(0x5fb37d69e5fed08d),
W64LIT(0x56e5bfb49cedaecb),
W64LIT(0x2dfb2043685f73ab),
W64LIT(0x61a54437ddf6510f),
W64LIT(0x6fc16ba1204705d8),
W64LIT(0xe75302a2fc24a156),
W64LIT(0x3dd581a82b9b9398),
W64LIT(0xdbc7eb5875ce3c6b),
W64LIT(0x90ab626744c5345e),
W64LIT(0x59c0f870c32df4b9),
W64LIT(0x6697a97c59547b9e),
W64LIT(0xfde8d962d5602d39),
W64LIT(0xd3d041d7aeac4c88),
W64LIT(0x5ef2153b478fde28),
W64LIT(0xd4e2ac9c2a0e6619),
W64LIT(0x1e4a8e7dbe75b4e4),
W64LIT(0x72485d2a8da1a326),
W64LIT(0x437b23b0ea6978d6),
W64LIT(0x159e9c047684d61d),
W64LIT(0x0f2547c45fc05a72),
W64LIT(0xf10e265099336551),
W64LIT(0x3c94e9fa89ea9d3d),
W64LIT(0xbfd292809d785b4a),
W64LIT(0x0817aa8fdb6270e3),
W64LIT(0x60e42c657f875faa),
W64LIT(0x18390b6498a690d0),
W64LIT(0x478a760d7d58405d),
W64LIT(0x284b1dac5d1f4585),
W64LIT(0xb1b6bd1660c90f9d),
W64LIT(0xd15291731f4e5037),
W64LIT(0x4d1f0c2617d82c01),
W64LIT(0xc70fb5817a599430),
W64LIT(0x6d43bb0591a51967),
W64LIT(0x6e8003f382360b7d),
W64LIT(0x1d89368bade6a6fe),
W64LIT(0x4f9ddc82a63a30be),
W64LIT(0xedc6788996a4cd0a),
W64LIT(0xab0d66d6498d83f2),
W64LIT(0x54676f102d0fb274),
W64LIT(0xc17c30985c8ab004),
W64LIT(0x3865bc471edba5b6),
W64LIT(0x3924d415bcaaab13),
W64LIT(0x951b5f8871850270),
W64LIT(0x8a10b9a76d81b831),
W64LIT(0xbd5042242c9a47f5),
W64LIT(0xa5694940b43cd725),
W64LIT(0xff6a09c664823186),
W64LIT(0x8d2254ece92392a0),
W64LIT(0xb7c5380f461a2ba9),
W64LIT(0x82071328b6e3c8d2),
W64LIT(0xd721146a399d7403),
W64LIT(0xfada342951c207a8),
W64LIT(0x262f323aa0ae1152),
W64LIT(0xf04f4e023b426bf4),
W64LIT(0x276e5a6802df1ff7),
/* box 1 */
W64LIT(0x3b4016dbfd16e203),
W64LIT(0x9a7574c51174530a),
W64LIT(0x90012e69c02ec8d3),
W64LIT(0xf44580e3d780e076),
W64LIT(0xf81dec2b49eca14b),
W64LIT(0x26cae3e8a6e3d7ef),
W64LIT(0x0962419e0c41f6ab),
W64LIT(0x54d1eb4070ebd951),
W64LIT(0x865e884b0188eec8),
W64LIT(0xdf76067ea406fe8a),
W64LIT(0x29849412e594fba0),
W64LIT(0x461569896869c0f2),
W64LIT(0xb5ddd6b3bbd6724e),
W64LIT(0x0c586cc89e6c413d),
W64LIT(0x6b0ad97054d904ea),
W64LIT(0xa135621eec62b109),
W64LIT(0x0eef7e47087ea461),
W64LIT(0xfaaafea4dffe4417),
W64LIT(0xe0ad344e80342331),
W64LIT(0xab4138b23d382ad0),
W64LIT(0x107390468e90fcff),
W64LIT(0xbe0885a2218561b9),
W64LIT(0xdbed22957d22c132),
W64LIT(0x2251c7037fc7e857),
W64LIT(0x33835ef8ba5e9c86),
W64LIT(0xb3f1e0d7f4e0a8aa),
W64LIT(0x3fdb32302432ddbb),
W64LIT(0xa719547aa3546bed),
W64LIT(0xe10c3df3cb3dab1f),
W64LIT(0x17feaf9f8aafae35),
W64LIT(0x9df84b1c154b01c0),
W64LIT(0x8364a51d93a5595e),
W64LIT(0x535cd49974d48b9b),
W64LIT(0x01a109bd4b09882e),
W64LIT(0xc4d0c529b0c51182),
W64LIT(0x2e09abcbe1aba96a),
W64LIT(0x1f3de7bccde7d0b0),
W64LIT(0x9317355b1d35a5a1),
W64LIT(0x6c87e6a950e65620),
W64LIT(0x8910ffb142ffc287),
W64LIT(0x40395fed275f1a16),
W64LIT(0x7b794936da49f815),
W64LIT(0xf269b68798b63a92),
W64LIT(0xfd27c17ddbc116dd),
W64LIT(0x8d8bdb5a9bdbfd3f),
W64LIT(0x1ba6c35714c3ef08),
W64LIT(0x6e30f426c6f4b37c),
W64LIT(0x7fe26ddd036dc7ad),
W64LIT(0x14e8b4ad57b4c347),
W64LIT(0xb985ba7b25ba3373),
W64LIT(0xe9cf75d08c75d59a),
W64LIT(0x626898ee5898f241),
W64LIT(0x5b9f9cba339cf51e),
W64LIT(0xb250e96abfe92084),
W64LIT(0x165fa622c1a6261b),
W64LIT(0xf5e4895e9c896858),
W64LIT(0xb76ac43c2dc49712),
W64LIT(0x02b7128f9612e55c),
W64LIT(0x1d8af5335bf535ec),
W64LIT(0x36b973ae28732b10),
W64LIT(0xa8572380e02347a2),
W64LIT(0xf6f2926c4192052a),
W64LIT(0x8c2ad2e7d0d27511),
W64LIT(0xd32e6ab63a6abfb7),
W64LIT(0xbd1e9e90fc9e0ccb),
W64LIT(0x03161b32dd1b6d72),
W64LIT(0x4dc03a98f23ad305),
W64LIT(0x81d3b79205b7bc02),
W64LIT(0x450372bbb572ad80),
W64LIT(0x2d1fb0f93cb0c418),
W64LIT(0x2a928f20388f96d2),
W64LIT(0x721b08a8d6080ebe),
W64LIT(0x92b63ce6563c2d8f),
W64LIT(0xeb78675f1a6730c6),
W64LIT(0x13658b74538b918d),
W64LIT(0x428e4d62b14dff4a),
W64LIT(0x88b1f60c09f64aa9),
W64LIT(0x75963771d2375c74),
W64LIT(0x7ad8408b9140703b),
W64LIT(0x57c7f072adf0b423),
W64LIT(0xe5971918121994a7),
W64LIT(0x5666f9cfe6f93c0d),
W64LIT(0x8f3cc9d50dc91863),
W64LIT(0x1e9cee0186ee589e),
W64LIT(0x8a06e4839fe4aff5),
W64LIT(0xb824b3c66eb3bb5d),
W64LIT(0xd1997839ac785aeb),
W64LIT(0x6752b5b8cab545d7),
W64LIT(0xb47cdf0ef0dffa60),
W64LIT(0x949a0a82190af76b),
W64LIT(0xc04be1c269e12e3a),
W64LIT(0xfc86c8c090c89ef3),
W64LIT(0xe3bb2f7c5d2f4e43),
W64LIT(0x6aabd0cd1fd08cc4),
W64LIT(0x2147dc31a2dc8525),
W64LIT(0xca3fbb6eb8bbb5e3),
W64LIT(0x48fa17ce60176493),
W64LIT(0x6444ae8a17ae28a5),
W64LIT(0x2b33869d73861efc),
W64LIT(0xd0387184e771d2c5),
W64LIT(0x7cf476efde76aadf),
W64LIT(0x63c9915313917a6f),
W64LIT(0xc929a05c65a0d891),
W64LIT(0xda4c2b28362b491c),
W64LIT(0xfe31da4f06da7baf),
W64LIT(0xc1eae87f22e8a614),
W64LIT(0x5c12a36337a3a7d4),
W64LIT(0x18b0d865c9d8827a),
W64LIT(0xe7200b97840b71fb),
W64LIT(0x4bec0cfcbd0c09e1),
W64LIT(0x0f4e77fa43772c4f),
W64LIT(0x4c613325b9335b2b),
W64LIT(0xf3c8bf3ad3bfb2bc),
W64LIT(0x87ff81f64a8166e6),
W64LIT(0xa38270917a705455),
W64LIT(0x1911d1d882d10a54),
W64LIT(0x44a27b06fe7b25ae),
W64LIT(0x049b24ebd9243fb8),
W64LIT(0xbb32a8f4b3a8d62f),
W64LIT(0x91a027d48b2740fd),
W64LIT(0x3d6c20bfb22038e7),
W64LIT(0xe681022acf02f9d5),
W64LIT(0xf17fadb545ad57e0),
W64LIT(0xcc138d0af78d6f07),
W64LIT(0x495b1e732b1eecbd),
W64LIT(0x38560de9200d8f71),
W64LIT(0xa9f62a3dab2acf8c),
W64LIT(0x47b46034236048dc),
W64LIT(0x8e9dc06846c0904d),
W64LIT(0xaccc076b3907781a),
W64LIT(0x32225745f15714a8),
W64LIT(0xd4a3556f3e55ed7d),
W64LIT(0xd7b54e5de34e800f),
W64LIT(0xddc114f132141bd6),
W64LIT(0x6d26ef141befde0e),
W64LIT(0x85489379dc9383ba),
W64LIT(0x0bd553119a5313f7),
W64LIT(0x786f520407529567),
W64LIT(0xcb9eb2d3f3b23dcd),
W64LIT(0xa223792c3179dc7b),
W64LIT(0x0a745aacd15a9bd9),
W64LIT(0x710d139a0b1363cc),
W64LIT(0x681cc24289c26998),
W64LIT(0x1a07caea5fca6726),
W64LIT(0x82c5aca0d8acd170),
W64LIT(0x25dcf8da7bf8ba9d),
W64LIT(0xc7c6de1b6dde7cf0),
W64LIT(0xc35dfaf0b4fa4348),
W64LIT(0xded70fc3ef0f76a4),
W64LIT(0x504acfaba9cfe6e9),
W64LIT(0xc571cc94fbcc99ac),
W64LIT(0x5ea5b1eca1b14288),
W64LIT(0xae7b15e4af159d46),
W64LIT(0xc888a9e12ea950bf),
W64LIT(0xf7539bd10a9b8d04),
W64LIT(0x962d180d8f181237),
W64LIT(0xe43610a559101c89),
W64LIT(0x772125fe4425b928),
W64LIT(0x84e99ac4979a0b94),
W64LIT(0xc667d7a626d7f4de),
W64LIT(0xefe343b4c3430f7e),
W64LIT(0xd5025cd2755c6553),
W64LIT(0xa6b85dc7e85de3c3),
W64LIT(0xd61447e0a8470821),
W64LIT(0x3e7a3b8d6f3b5595),
W64LIT(0x52fddd243fdd03b5),
W64LIT(0x8072be2f4ebe342c),
W64LIT(0x12c482c9188219a3),
W64LIT(0x9eee502ec8506cb2),
W64LIT(0xad6d0ed6720ef034),
W64LIT(0x59288e35a58e1042),
W64LIT(0xe21a26c11626c66d),
W64LIT(0x247df16730f132b3),
W64LIT(0xf0dea4080ea4dfce),
W64LIT(0x31344c772c4c79da),
W64LIT(0x4f77281764283659),
W64LIT(0x79ce5bb94c5b1d49),
W64LIT(0x0000000000000000),
W64LIT(0x73ba01159d018690),
W64LIT(0x74373ecc993ed45a),
W64LIT(0xbcbf972db79784e5),
W64LIT(0x4ed621aa2f21be77),
W64LIT(0xd95a301aeb30246e),
W64LIT(0x9c5942a15e4289ee),
W64LIT(0x37187a13637aa33e),
W64LIT(0x276bea55edea5fc1),
W64LIT(0x1c2bfc8e10fcbdc2),
W64LIT(0xed54513b5551ea22),
W64LIT(0x20e6d58ce9d50d0b),
W64LIT(0x3ae11f66b61f6a2d),
W64LIT(0x66f3bc0581bccdf9),
W64LIT(0x2cbeb94477b94c36),
W64LIT(0x99636ff7cc6f3e78),
W64LIT(0x953b033f52037f45),
W64LIT(0xb0e7fbe529fbc5d8),
W64LIT(0x60df8a61ce8a171d),
W64LIT(0x6f91fd9b8dfd3b52),
W64LIT(0xaae0310f7631a2fe),
W64LIT(0xbfa98c1f6a8ce997),
W64LIT(0x8ba7ed3ed4ed27db),
W64LIT(0x98c2664a8766b656),
W64LIT(0x062c36644f36dae4),
W64LIT(0x5570e2fd3be2517f),
W64LIT(0xead96ee2516eb8e8),
W64LIT(0x419856506c569238),
W64LIT(0x23f0cebe34ce6079),
W64LIT(0x309545ca6745f1f4),
W64LIT(0x5a3e950778957d30),
W64LIT(0x617e83dc85839f33),
W64LIT(0xfb0bf71994f7cc39),
W64LIT(0x3ccd2902f929b0c9),
W64LIT(0x70ac1a27401aebe2),
W64LIT(0xcea49f85619f8a5b),
W64LIT(0x39f704546b04075f),
W64LIT(0x0df96575d565c913),
W64LIT(0x08c3482347487e85),
W64LIT(0xd28f630b71633799),
W64LIT(0xecf558861e58620c),
W64LIT(0xc2fcf34dfff3cb66),
W64LIT(0x978c11b0c4119a19),
W64LIT(0x69bdcbffc2cbe1b6),
W64LIT(0xba93a149f8a15e01),
W64LIT(0x51ebc616e2c66ec7),
W64LIT(0x078d3fd9043f52ca),
W64LIT(0x58898788ee87986c),
W64LIT(0x4a4d0541f60581cf),
W64LIT(0xe86e7c6dc77c5db4),
W64LIT(0xee424a09884a8750),
W64LIT(0xcdb284b7bc84e729),
W64LIT(0x65e5a7375ca7a08b),
W64LIT(0x2fa8a276aaa22144),
W64LIT(0xa0946ba3a76b3927),
W64LIT(0xa5ae46f535468eb1),
W64LIT(0x35af689cf5684662),
W64LIT(0x28259dafae9d738e),
W64LIT(0xcf0596382a960275),
W64LIT(0xb6cbcd8166cd1f3c),
W64LIT(0x7e43646048644f83),
W64LIT(0x9bd47d785a7ddb24),
W64LIT(0x432f44dffa447764),
W64LIT(0x9f4f59938359e49c),
W64LIT(0x7d557f52957f22f1),
W64LIT(0x76802c430f2c3106),
W64LIT(0xdc601d4c791d93f8),
W64LIT(0x053a2d56922db796),
W64LIT(0x11d299fbc59974d1),
W64LIT(0xf9bce59602e52965),
W64LIT(0xd8fb39a7a039ac40),
W64LIT(0x340e6121be61ce4c),
W64LIT(0x5f04b851eab8caa6),
W64LIT(0x5db3aade7caa2ffa),
W64LIT(0x1549bd101cbd4b69),
W64LIT(0xff90d3f24dd3f381),
W64LIT(0xafda1c59e41c1568),
W64LIT(0xb146f25862f24df6),
W64LIT(0xa40f4f487e4f069f),
/* box 2 */
W64LIT(0xa1a35cebf8f0f94c),
W64LIT(0x2c203d650f3f095d),
W64LIT(0x1a2bdaee4084a2a7),
W64LIT(0xd32404574d7bcc68),
W64LIT(0xf785bea594a9adc4),
W64LIT(0xf2eb54456206949c),
W64LIT(0x3f5e334d0475ced1),
W64LIT(0x5994299b835d1f60),
W64LIT(0x785b7989ac204794),
W64LIT(0x025da6a2cf461a41),
W64LIT(0xdf1f3a71f01a901b),
W64LIT(0x27284f018bb77637),
W64LIT(0xe1955a6d694c5310),
W64LIT(0x24a1baf2d9d261ac),
W64LIT(0xe4fbb08d9fe36a48),
W64LIT(0x8d83618ef7cff011),
W64LIT(0x2ac72276abf5279e),
W64LIT(0xf9e32621e68eebf6),
W64LIT(0xbf323fb4d3f86f69),
W64LIT(0xbb888605b8745beb),
W64LIT(0x70dafe1e7acd2f65),
W64LIT(0xd0adf1a41f1edbf3),
W64LIT(0x1e91635f2b089625),
W64LIT(0xee2791b8864818f8),
W64LIT(0x99ce23e4c56c1484),
W64LIT(0xf33f0714ff259946),
W64LIT(0xbd6f99161cbe7528),
W64LIT(0x9f293cf761a63a47),
W64LIT(0xb80173f6ea114c70),
W64LIT(0x6543ef25d54dc62a),
W64LIT(0x39b92c5ea0bfe012),
W64LIT(0x63a4f0367187e8e9),
W64LIT(0x4c0d38a02cddf62f),
W64LIT(0x07334c4239e92319),
W64LIT(0x43bff375c3d9bdc7),
W64LIT(0xca862b4a5f9a7954),
W64LIT(0x5d2e902ae8d12be2),
W64LIT(0x137e0e280b4ac78c),
W64LIT(0xf162a1b630638307),
W64LIT(0x55af17bd3e3c4313),
W64LIT(0x358212781ddebc61),
W64LIT(0x94214e93e52e452d),
W64LIT(0xc18e592edb12063e),
W64LIT(0xec7a371a490e02b9),
W64LIT(0x4963d240da72cf77),
W64LIT(0x41e255d70c9fa786),
W64LIT(0xff0439324244c535),
W64LIT(0x88ed8b6e0160c949),
W64LIT(0x6c163be39e83a301),
W64LIT(0xc534e09fb09e32bc),
W64LIT(0x806c0cf9d78da1b8),
W64LIT(0xdba583c09b96a499),
W64LIT(0x746047af11411be7),
W64LIT(0xf40c4b56c6ccba5f),
W64LIT(0x6270a367eca4e533),
W64LIT(0xd41748157492ef71),
W64LIT(0xeff3c2e91b6b1522),
W64LIT(0x0e66988472274632),
W64LIT(0x534808ae9af66dd0),
W64LIT(0x8231aa5b18cbbbf9),
W64LIT(0xb2dd52c3f3ba3ec0),
W64LIT(0xdd429cd33f5c8a5a),
W64LIT(0x4e509e02e39bec6e),
W64LIT(0x26fc1c5016947bed),
W64LIT(0xd9f8256254d0bed8),
W64LIT(0x0955d4c64bce652b),
W64LIT(0x1610e4c8fde5fed4),
W64LIT(0x6dc268b203a0aedb),
W64LIT(0x2e7d9bc7c079131c),
W64LIT(0xc3d3ff8c14541c7f),
W64LIT(0xd64aeeb7bbd4f530),
W64LIT(0xab7f7ddee15b8bfc),
W64LIT(0x144d426a32a3e495),
W64LIT(0x8e0a947da5aae78a),
W64LIT(0x798f2ad831034a4e),
W64LIT(0x3be48afc6ff9fa53),
W64LIT(0x529c5bff07d5600a),
W64LIT(0xbee66ce54edb62b3),
W64LIT(0x931202d1dcc76634),
W64LIT(0x50c1fd5dc8937a4b),
W64LIT(0xa4cdb60b0e5fc014),
W64LIT(0x57f2b11ff17a5952),
W64LIT(0x47054ac4a8558945),
W64LIT(0x5a1ddc68d13808fb),
W64LIT(0x5cfac37b75f22638),
W64LIT(0xc207acdd897711a5),
W64LIT(0x289a84d464b33ddf),
W64LIT(0xc05a0a7f46310be4),
W64LIT(0xe6a6162f50a57009),
W64LIT(0x06e71f13a4ca2ec3),
W64LIT(0x5f733688279731a3),
W64LIT(0xeb497b5870e721a0),
W64LIT(0xb667eb7298360a42),
W64LIT(0xe3c8fccfa60a4951),
W64LIT(0xe772457ecd867dd3),
W64LIT(0x6978d103682c9a59),
W64LIT(0x0def6d77204251a9),
W64LIT(0xc90fdeb90dff6ecf),
W64LIT(0xd179a2f5823dd629),
W64LIT(0x2fa9c8965d5a1ec6),
W64LIT(0x81b85fa84aaeac62),
W64LIT(0xdc96cf82a27f8780),
W64LIT(0x602d05c523e2ff72),
W64LIT(0x19a22f1d12e1b53c),
W64LIT(0xe52fe3dc02c06792),
W64LIT(0x58407aca1e7e12ba),
W64LIT(0x61f95694bec1f2a8),
W64LIT(0x48b781114751c2ad),
W64LIT(0xaaab2e8f7c788626),
W64LIT(0x04bab9b16b8c3482),
W64LIT(0x2df46e34921c0487),
W64LIT(0x1123a88ac40cddcd),
W64LIT(0xc6bd156ce2fb2527),
W64LIT(0x7f6835cb95c9648d),
W64LIT(0x83e5f90a85e8b623),
W64LIT(0x4f84cd537eb8e1b4),
W64LIT(0x294ed785f9903005),
W64LIT(0x1cccc5fde44e8c64),
W64LIT(0xcb52781bc2b9748e),
W64LIT(0x1d1896ac796d81be),
W64LIT(0xb30901926e99331a),
W64LIT(0xad9862cd4591a53f),
W64LIT(0xc8db8de890dc6315),
W64LIT(0x7bd28c7afe45500f),
W64LIT(0x0adc213519ab72b0),
W64LIT(0xa8f6882db33e9c67),
W64LIT(0xb5ee1e81ca531dd9),
W64LIT(0x201b0343b25e552e),
W64LIT(0x4036068691bcaa5c),
W64LIT(0xae11973e17f4b2a4),
W64LIT(0x9efd6fa6fc85379d),
W64LIT(0x33650d6bb91492a2),
W64LIT(0x3a30d9adf2daf789),
W64LIT(0x0c3b3e26bd615c73),
W64LIT(0xf651edf4098aa01e),
W64LIT(0x710ead4fe7ee22bf),
W64LIT(0x3138abc9765288e3),
W64LIT(0x9d749a55aee02006),
W64LIT(0x6e4b9d4151c5b940),
W64LIT(0x84d6b548bc01953a),
W64LIT(0x360be78b4fbbabfa),
W64LIT(0xa22aa918aa95eed7),
W64LIT(0xedae644bd42d0f63),
W64LIT(0x46d119953576849f),
W64LIT(0x6497bc74486ecbf0),
W64LIT(0xfbbe808329c8f1b7),
W64LIT(0x4aea27b38817d8ec),
W64LIT(0x5626e24e6c595488),
W64LIT(0x056eeae0f6af3958),
W64LIT(0x4558ec6667139304),
W64LIT(0x448cbf37fa309ede),
W64LIT(0x6f9fce10cce6b49a),
W64LIT(0xa0770fba65d3f496),
W64LIT(0x671e49871a0bdc6b),
W64LIT(0xda71d09106b5a943),
W64LIT(0x08818797d6ed68f1),
W64LIT(0xa3fefa4937b6e30d),
W64LIT(0xb080f4613cfc2481),
W64LIT(0x763de10dde0701a6),
W64LIT(0x4dd96bf1b1fefbf5),
W64LIT(0x92c6518041e46bee),
W64LIT(0x3456412980fdb1bb),
W64LIT(0x981a70b5584f195e),
W64LIT(0x3d0395efcb33d490),
W64LIT(0xba5cd55425575631),
W64LIT(0x4b3e74e21534d536),
W64LIT(0x6af124f03a498dc2),
W64LIT(0x7ebc669a08ea6957),
W64LIT(0x30ecf898eb718539),
W64LIT(0xa922db7c2e1d91bd),
W64LIT(0x7a06df2b63665dd5),
W64LIT(0xb154a730a1df295b),
W64LIT(0xfc8dccc11021d2ae),
W64LIT(0xcfe8c1aaa935400c),
W64LIT(0x97a8bb60b74b52b6),
W64LIT(0x18767c4c8fc2b8e6),
W64LIT(0x9a47d6179709031f),
W64LIT(0x0000000000000000),
W64LIT(0xac4c319cd8b2a8e5),
W64LIT(0xb9d520a7773241aa),
W64LIT(0xdecb69206d399dc1),
W64LIT(0x1f45300eb62b9bff),
W64LIT(0x10f7fbdb592fd017),
W64LIT(0x3e8a601c9956c30b),
W64LIT(0x8502e619212298e0),
W64LIT(0xf5d818075befb785),
W64LIT(0x547b44eca31f4ec9),
W64LIT(0x9ca0c90433c32ddc),
W64LIT(0xe041093cf46f5eca),
W64LIT(0xa69010a9c119da55),
W64LIT(0xc769463d7fd828fd),
W64LIT(0xc4e0b3ce2dbd3f66),
W64LIT(0x2575e9a344f16c76),
W64LIT(0x01d453519d230dda),
W64LIT(0xfa6ad3d2b4ebfc6d),
W64LIT(0xd5c31b44e9b1e2ab),
W64LIT(0xf83775707bade62c),
W64LIT(0xbcbbca47819d78f2),
W64LIT(0xd79ebde626f7f8ea),
W64LIT(0x5bc98f394c1b0521),
W64LIT(0x2246a5e17d184f6f),
W64LIT(0x12aa5d799669ca56),
W64LIT(0x5ea765d9bab43c79),
W64LIT(0x8939d83f9c43c493),
W64LIT(0x32b15e3a24379f78),
W64LIT(0xe914ddfabfa13be1),
W64LIT(0x909bf7228ea271af),
W64LIT(0x73530bed28a838fe),
W64LIT(0xd2f05706d058c1b2),
W64LIT(0xfed06a63df67c8ef),
W64LIT(0xb43a4dd057701003),
W64LIT(0xa519e55a937ccdce),
W64LIT(0x75b414fe8c62163d),
W64LIT(0xafc5c46f8ad7bf7e),
W64LIT(0x2392f6b0e03b42b5),
W64LIT(0x386d7f0f3d9cedc8),
W64LIT(0x21cf50122f7d58f4),
W64LIT(0x9b9385460a2a0ec5),
W64LIT(0x5115ae0c55b07791),
W64LIT(0x0fb2cbd5ef044be8),
W64LIT(0xea9d2809edc42c7a),
W64LIT(0xcc613459fb505797),
W64LIT(0x426ba0245efab01d),
W64LIT(0x1599113baf80e94f),
W64LIT(0x7d3593695a8f7ecc),
W64LIT(0x0389f5f35265179b),
W64LIT(0x875f40bbee6482a1),
W64LIT(0x95f51dc2780d48f7),
W64LIT(0x7ce1c038c7ac7316),
W64LIT(0xce3c92fb34164dd6),
W64LIT(0xcdb5670866735a4d),
W64LIT(0x8ab02dccce26d308),
W64LIT(0x914fa47313817c75),
W64LIT(0x8b647e9d5305ded2),
W64LIT(0xd82c7633c9f3b302),
W64LIT(0x728758bcb58b3524),
W64LIT(0xe8c08eab2282363b),
W64LIT(0x8fdec72c3889ea50),
W64LIT(0x2b13712736d62a44),
W64LIT(0x3cd7c6be5610d94a),
W64LIT(0x37dfb4dad298a620),
W64LIT(0x868b13ea73478f7b),
W64LIT(0xb7b3b82305150798),
W64LIT(0x0b08726484887f6a),
W64LIT(0x1bff89bfdda7af7d),
W64LIT(0x77e9b25c43240c7c),
W64LIT(0xf0b6f2e7ad408edd),
W64LIT(0x17c4b79960c6f30e),
W64LIT(0x8c5732df6aecfdcb),
W64LIT(0x68ac8252f50f9783),
W64LIT(0x66ca1ad68728d1b1),
W64LIT(0x6b2577a1a76a8018),
W64LIT(0xe21caf9e3b29448b),
W64LIT(0xa74443f85c3ad78f),
W64LIT(0xfd599f908d02df74),
W64LIT(0x967ce8312a685f6c),
/* box 3 */
W64LIT(0xfa7b9775ba3af751),
W64LIT(0x03ef98cb769c2d13),
W64LIT(0x7191ce067072359e),
W64LIT(0xbab18b6bff7516a8),
W64LIT(0xe6e5ef4efbc1065e),
W64LIT(0x7bec74a3b1d0dbf4),
W64LIT(0x656b4fb907c31c4a),
W64LIT(0x4e8520f99fc86304),
W64LIT(0x8fd8df31d16dae58),
W64LIT(0x90a93fc1e60a7244),
W64LIT(0x30ad09f2b449cfc5),
W64LIT(0x8453be7e91bb5b90),
W64LIT(0x1d68a3d1c08feaad),
W64LIT(0x5c54642504b410f6),
W64LIT(0x8061383c8a9e3707),
W64LIT(0xf9940fbecca6da42),
W64LIT(0x46e1d97da982bbdf),
W64LIT(0xfc50521656f7ad77),
W64LIT(0x5e4d2704f35c2647),
W64LIT(0x8bea5973ca48c2cf),
W64LIT(0xd06323dfa34593bd),
W64LIT(0x62b651306a7a5dce),
W64LIT(0xa436b0714966d116),
W64LIT(0x4f73fb131ebc78a6),
W64LIT(0x92b07ce011e244f5),
W64LIT(0x33429139c2d5e2d6),
W64LIT(0xcee418c515565403),
W64LIT(0xd7be3d56cefcd239),
W64LIT(0x53ed83285f4789a9),
W64LIT(0xf3e9b51b0d043428),
W64LIT(0x20650e0fd8dd8a86),
W64LIT(0xb6e7f4add21aa2e4),
W64LIT(0x6d0fb63d3189c491),
W64LIT(0x0da0a42cac1bafee),
W64LIT(0x3f14eeffefba569a),
W64LIT(0x13279f361a086850),
W64LIT(0x9b225e8ea6dc878c),
W64LIT(0x6684d772715f3159),
W64LIT(0xa3ebaef824df9092),
W64LIT(0xc499a260d4f4ba69),
W64LIT(0xaa798c9693e153eb),
W64LIT(0x50021be329dba4ba),
W64LIT(0x949bb983fd2f1ed3),
W64LIT(0xdfdac4d2f8b60ae2),
W64LIT(0xf0062dd07b98193b),
W64LIT(0xafbdd13e09b024de),
W64LIT(0xb95e13a089e93bbb),
W64LIT(0x649d945386b707e8),
W64LIT(0xe4fcac6f0c2930ef),
W64LIT(0x413cc7f4c43bfa5b),
W64LIT(0x3b2668bdf49f3a0d),
W64LIT(0xe50a77858d5d2b4d),
W64LIT(0x05c45da89a517735),
W64LIT(0x3ee235156ece4d38),
W64LIT(0xfe491137a11f9bc6),
W64LIT(0xb7112f47536eb946),
W64LIT(0x07dd1e896db94184),
W64LIT(0x1ab5bd58ad36ab29),
W64LIT(0x8197e3d60bea2ca5),
W64LIT(0xab8f577c12954849),
W64LIT(0x9cff4007cb65c608),
W64LIT(0xa00436335243bd81),
W64LIT(0xfda689fcd783b6d5),
W64LIT(0xccfd5be4e2be62b2),
W64LIT(0x75a348446b575909),
W64LIT(0x17151974012d04c7),
W64LIT(0xfb8d4c9f3b4eecf3),
W64LIT(0xac5249f57f2c09cd),
W64LIT(0x9346a70a90965f57),
W64LIT(0x043286421b256c97),
W64LIT(0x27b81086b564cb02),
W64LIT(0x3569545a2e18b8f0),
W64LIT(0x6b24735edd449eb7),
W64LIT(0x2193d5e559a99124),
W64LIT(0xc7763aaba268977a),
W64LIT(0xb0cc31ce3ed7f8c2),
W64LIT(0xc939064c78ef1587),
W64LIT(0x16e3c29e80591f65),
W64LIT(0x5da2bfcf85c00b54),
W64LIT(0x5990398d9ee567c3),
W64LIT(0x67720c98f02b2afb),
W64LIT(0x54309da132fec82d),
W64LIT(0xeab39088d6aeb212),
W64LIT(0x9682faa20ac72862),
W64LIT(0xd38cbb14d5d9beae),
W64LIT(0x4c9c63d8682055b5),
W64LIT(0xd648e6bc4f88c99b),
W64LIT(0xdc355c198e2a27f1),
W64LIT(0x10c807fd6c944543),
W64LIT(0x450e41b6df1e96cc),
W64LIT(0x0b8b614f40d6f5c8),
W64LIT(0xd27a60fe54ada50c),
W64LIT(0x49583e70f2712280),
W64LIT(0x8dc19c10268598e9),
W64LIT(0x5866e2671f917c61),
W64LIT(0x79f537824638ed45),
W64LIT(0xc2b267033839e04f),
W64LIT(0xcb20456d8f072336),
W64LIT(0x2a18b4aa197f64ec),
W64LIT(0xdbe84290e3936675),
W64LIT(0x73888d27879a032f),
W64LIT(0xe8aad3a9214684a3),
W64LIT(0x6ee02ef64715e982),
W64LIT(0xa996145de57d7ef8),
W64LIT(0xc8cfdda6f99b0e25),
W64LIT(0x062bc563eccd5a26),
W64LIT(0x264ecb6c3410d0a0),
W64LIT(0xb8a8c84a089d2019),
W64LIT(0x7dc7b1c05d1d81d2),
W64LIT(0xd5a77e773914e488),
W64LIT(0x4b417d5105991431),
W64LIT(0xf62de8b39755431d),
W64LIT(0x993b1daf5134b13d),
W64LIT(0x82787b1d7d7601b6),
W64LIT(0xe321b2e66190716b),
W64LIT(0xb5086c66a4868ff7),
W64LIT(0x9ee603263c8df0b9),
W64LIT(0x349f8fb0af6ca352),
W64LIT(0x5b897aac690d5172),
W64LIT(0x7c316a2adc699a70),
W64LIT(0xd451a59db860ff2a),
W64LIT(0x706715ecf1062e3c),
W64LIT(0x838ea0f7fc021a14),
W64LIT(0x57df056a4462e53e),
W64LIT(0xcf12c32f94224fa1),
W64LIT(0xed6e8e01bb17f396),
W64LIT(0x915fe42b677e69e6),
W64LIT(0x89f31a523da0f47e),
W64LIT(0xe71334a47ab51dfc),
W64LIT(0xa860cfb76409655a),
W64LIT(0x9f10d8ccbdf9eb1b),
W64LIT(0xef77cd204cffc527),
W64LIT(0xf862d4544dd2c1e0),
W64LIT(0x8a1c82994b3cd96d),
W64LIT(0xae4b0ad488c43f7c),
W64LIT(0x98cdc645d040aa9f),
W64LIT(0x7fdef2e1aaf5b763),
W64LIT(0x4717029728f6a07d),
W64LIT(0x745593aeea2342ab),
W64LIT(0xee8116cacd8bde85),
W64LIT(0x727e56cd06ee188d),
W64LIT(0x227c4d2e2f35bc37),
W64LIT(0x977421488bb333c0),
W64LIT(0xa21d7512a5ab8b30),
W64LIT(0xbb4750817e010d0a),
W64LIT(0x6cf96dd7b0fddf33),
W64LIT(0x2801f78bee97525d),
W64LIT(0x1c9e783b41fbf10f),
W64LIT(0x9d099bed4a11ddaa),
W64LIT(0x7a1aaf4930a4c056),
W64LIT(0x32b44ad343a1f974),
W64LIT(0x3cfb763499267b89),
W64LIT(0xb2d572efc93fce73),
W64LIT(0x63408adaeb0e466c),
W64LIT(0xada4921ffe58126f),
W64LIT(0x5fbbfcee72283de5),
W64LIT(0x6ad2a8b45c308515),
W64LIT(0x0c567fc62d6fb44c),
W64LIT(0x956d62697c5b0571),
W64LIT(0x25a153a7428cfdb3),
W64LIT(0x150c5a55f6c53276),
W64LIT(0xe2d7690ce0e46ac9),
W64LIT(0xda1e997a62e77dd7),
W64LIT(0xf5c27078e1c96e0e),
W64LIT(0xc344bce9b94dfbed),
W64LIT(0x60af12119d926b7f),
W64LIT(0xa1f2edd9d337a623),
W64LIT(0xcad69e870e733894),
W64LIT(0x3770177bd9f08e41),
W64LIT(0xa5c06b9bc812cab4),
W64LIT(0x1f71e0f03767dc1c),
W64LIT(0x44f89a5c5e6a8d6e),
W64LIT(0x6159c9fb1ce670dd),
W64LIT(0x8e2e04db5019b5fa),
W64LIT(0x8805c1b8bcd4efdc),
W64LIT(0xe138f1c7967847da),
W64LIT(0x4ab7a6bb84ed0f93),
W64LIT(0x0000000000000000),
W64LIT(0x38c9f0768203171e),
W64LIT(0x1b4366b22c42b08b),
W64LIT(0x7803ec68c74cf6e7),
W64LIT(0xec9855eb3a63e834),
W64LIT(0xbe830d29e4507a3f),
W64LIT(0x2dc5aa2374c62568),
W64LIT(0xa62ff350be8ee7a7),
W64LIT(0x764cd08f1dcb741a),
W64LIT(0x8c3747faa7f1834b),
W64LIT(0x0fb9e70d5bf3995f),
W64LIT(0x55c6464bb38ad38f),
W64LIT(0xf7db3359162158bf),
W64LIT(0xd195f8352231881f),
W64LIT(0x0992226eb73ec379),
W64LIT(0x14fa81bf77b129d4),
W64LIT(0x48aee59a73053922),
W64LIT(0x2457884dc3f8e611),
W64LIT(0xffbfcadd206b8064),
W64LIT(0xb4feb78c25f29455),
W64LIT(0x864afd5f66536d21),
W64LIT(0x6f16f51cc661f220),
W64LIT(0xde2c1f3879c21140),
W64LIT(0x195a2593dbaa863a),
W64LIT(0x2e2a32e8025a087b),
W64LIT(0x432584d533d3ccea),
W64LIT(0x2c3371c9f5b23eca),
W64LIT(0xa7d928ba3ffafc05),
W64LIT(0x42d35f3fb2a7d748),
W64LIT(0x85a5659410cf4032),
W64LIT(0x0864f984364ad8db),
W64LIT(0xf21f6ef18c702f8a),
W64LIT(0xf1f0f63afaec0299),
W64LIT(0xd9f101b1147b50c4),
W64LIT(0x2fdce902832e13d9),
W64LIT(0x4d6ab832e9544e17),
W64LIT(0xe0ce2a2d170c5c78),
W64LIT(0x51f4c009a8afbf18),
W64LIT(0x68cbeb95abd8b3a4),
W64LIT(0xc15dffc84ea5cd5c),
W64LIT(0x02194321f7e836b1),
W64LIT(0x113edc17ede05ee1),
W64LIT(0x521b58c2de33920b),
W64LIT(0x9ad4856427a89c2e),
W64LIT(0x5629de80c516fe9c),
W64LIT(0x77ba0b659cbf6fb8),
W64LIT(0x238a96c4ae41a795),
W64LIT(0x12d144dc9b7c73f2),
W64LIT(0xd807da5b950f4b66),
W64LIT(0x3686cc91588495e3),
W64LIT(0x18acfe795ade9d98),
W64LIT(0x5a7fa146e8794ad0),
W64LIT(0xc680e141231c8cd8),
W64LIT(0x1e873b1ab613c7be),
W64LIT(0xf434ab9260bd75ac),
W64LIT(0xcd0b800e63ca7910),
W64LIT(0xbc9a4e0813b84c8e),
W64LIT(0x3d0dadde1852602b),
W64LIT(0x40ca1c1e454fe1f9),
W64LIT(0x0a7dbaa5c1a2ee6a),
W64LIT(0x693d307f2aaca806),
W64LIT(0x0e4f3ce7da8782fd),
W64LIT(0xbd6c95e292cc572c),
W64LIT(0x3ad0b35775eb21af),
W64LIT(0x7e28290b2b81acc1),
W64LIT(0x01f6dbea81741ba2),
W64LIT(0x87bc26b5e7277683),
W64LIT(0x393f2b9c03770cbc),
W64LIT(0xddc387f30f5e3c53),
W64LIT(0xeb454b6257daa9b0),
W64LIT(0xb323a905484bd5d1),
W64LIT(0xb13aea24bfa3e360),
W64LIT(0x315bd218353dd467),
W64LIT(0x2bee6f40980b7f4e),
W64LIT(0xe95c0843a0329f01),
W64LIT(0xc56f798a5580a1cb),
W64LIT(0xbf75d6c36524619d),
W64LIT(0x29f72c616fe349ff),
W64LIT(0xc0ab2422cfd1d6fe),
/* box 4 */
W64LIT(0x561fc423e957943c),
W64LIT(0x014287ca69079288),
W64LIT(0x2f086129dfcd1d21),
W64LIT(0xc537d4aea044fd99),
W64LIT(0xf1e8c3bfd7c8a457),
W64LIT(0x2971998a5cdf9bfb),
W64LIT(0x23fa649a2ce9e460),
W64LIT(0x3aa9e9c356a6716a),
W64LIT(0xd6efa4e7aa3d1708),
W64LIT(0x705a24b1fda5b5eb),
W64LIT(0x101e0ce2b170a9fc),
W64LIT(0x7ca821020e814caa),
W64LIT(0x0bc97ada1931ed13),
W64LIT(0x34df1711778c59ce),
W64LIT(0xd35020ef9226d2bf),
W64LIT(0x575d43e9805006b4),
W64LIT(0x91acebec9b1db840),
W64LIT(0x549b3f423b5945d9),
W64LIT(0x99a3ed9d3925163e),
W64LIT(0x7917a50a369a891d),
W64LIT(0xe372343cb4b6dc4e),
W64LIT(0x8d40e2bdd949e8fd),
W64LIT(0xcfbc29bed0728202),
W64LIT(0x969794857108ac12),
W64LIT(0xdd26de3db30cfa1b),
W64LIT(0x115c8b28d8773b74),
W64LIT(0xe9f9c92cc480a3d5),
W64LIT(0x4dc8b21b4116d0d3),
W64LIT(0x316093194f979c79),
W64LIT(0x5124bb4a0342806e),
W64LIT(0xb31408bcdef3cea8),
W64LIT(0xc1cad76cf158aaa6),
W64LIT(0x88ff66b5e1522d4a),
W64LIT(0xa8c37e8476b28a47),
W64LIT(0x15a188ea896b6c4b),
W64LIT(0xa24883940684f5dc),
W64LIT(0xda1da1545919ee49),
W64LIT(0x22b8e35045ee76e8),
W64LIT(0x6106af9925d28e9f),
W64LIT(0xef80318f4792250f),
W64LIT(0x663dd0f0cfc79acd),
W64LIT(0x302214d326900ef1),
W64LIT(0xdfa2255c61022bfe),
W64LIT(0xe6cdb0348cad19f9),
W64LIT(0x50663c806a4512e6),
W64LIT(0x65fbac5b74ced9a0),
W64LIT(0xc4755364c9436f11),
W64LIT(0x8fc419dc0b473918),
W64LIT(0x5c9439339961eba7),
W64LIT(0x3f166dcb6ebdb4dd),
W64LIT(0xba59890715ccf25e),
W64LIT(0xf0aa4475becf36df),
W64LIT(0x03c67cabbb09436d),
W64LIT(0xb99ff5acaec5b133),
W64LIT(0xf9e7c5ce75f00a29),
W64LIT(0x6df4aa2ad6f677de),
W64LIT(0xaeba8627f5a00c9d),
W64LIT(0xa573fcfdec91e18e),
W64LIT(0x7f6e5da9b5880fc7),
W64LIT(0xca03adb6e86947b5),
W64LIT(0x74a72773acb9e2d4),
W64LIT(0x604428534cd51c17),
W64LIT(0xf8a542041cf798a1),
W64LIT(0x448533a08a29ec25),
W64LIT(0x80f060c4436a8334),
W64LIT(0x0db082799a236bc9),
W64LIT(0xfa21b965cef94944),
W64LIT(0x64b92b911dc94b28),
W64LIT(0x7118a37b94a22763),
W64LIT(0xaff801ed9ca79e15),
W64LIT(0x1dae8e9b2b53c235),
W64LIT(0x13d870490a79ea91),
W64LIT(0x8a7b9dd4335cfcaf),
W64LIT(0x1f2a75faf95d13d0),
W64LIT(0xeec2b6452e95b787),
W64LIT(0xc34e2c0d23567b43),
W64LIT(0x47434f0b3120af48),
W64LIT(0xa18eff3fbd8db6b1),
W64LIT(0x98e16a57502284b6),
W64LIT(0x37196bbacc851aa3),
W64LIT(0x8e869e166240ab90),
W64LIT(0x9fda153eba3790e4),
W64LIT(0xf515c07d86d4f368),
W64LIT(0x72dedfd02fab640e),
W64LIT(0xe230b3f6ddb14ec6),
W64LIT(0x97d5134f180f3e9a),
W64LIT(0xe1f6cf5d66b80dab),
W64LIT(0xe78f37fee5aa8b71),
W64LIT(0xa30a045e6f836754),
W64LIT(0x90ee6c26f21a2ac8),
W64LIT(0xaa4785e5a4bc5ba2),
W64LIT(0x4e0eceb0fa1f93be),
W64LIT(0x94136fe4a3067df7),
W64LIT(0x7b935e6be49458f8),
W64LIT(0x9b2716fceb2bc7db),
W64LIT(0x840d63061276d40b),
W64LIT(0xed04caee959cf4ea),
W64LIT(0xea3fb5877f89e0b8),
W64LIT(0xb56df01f5de14872),
W64LIT(0x4935b1d9100a87ec),
W64LIT(0x82749ba5916452d1),
W64LIT(0x58693af1c87dbc98),
W64LIT(0x89bde17f8855bfc2),
W64LIT(0x677f573aa6c00845),
W64LIT(0xeb7d324d168e7230),
W64LIT(0x0284fb61d20ed1e5),
W64LIT(0xb190f3dd0cfd1f4d),
W64LIT(0x684b2e22eeedb269),
W64LIT(0x2bf562eb8ed14a1e),
W64LIT(0xe0b448970fbf9f23),
W64LIT(0x396f9568edaf3207),
W64LIT(0x52e2c7e1b84bc303),
W64LIT(0x77615bd817b0a1b9),
W64LIT(0x7e2cda63dc8f9d4f),
W64LIT(0xf22ebf146cc1e73a),
W64LIT(0xc08850a6985f382e),
W64LIT(0xd9dbddffe210ad24),
W64LIT(0xbfe60d0f2dd737e9),
W64LIT(0x9a659136822c5553),
W64LIT(0x87cb1fada97f9766),
W64LIT(0x4c8a35d12811425b),
W64LIT(0x83361c6ff863c059),
W64LIT(0xd212a725fb214037),
W64LIT(0x9e9892f4d330026c),
W64LIT(0x45c7b46ae32e7ead),
W64LIT(0x5baf465a7374fff5),
W64LIT(0xdc6459f7da0b6893),
W64LIT(0xd46b5f867833c6ed),
W64LIT(0x5dd6bef9f066792f),
W64LIT(0xcb412a7c816ed53d),
W64LIT(0x75e5a0b9c5be705c),
W64LIT(0xf6d3bcd63dddb005),
W64LIT(0xfb633eafa7fedbcc),
W64LIT(0xd529d84c11345465),
W64LIT(0xc9c5d11d536004d8),
W64LIT(0xdb5f269e301e7cc1),
W64LIT(0x86899867c07805ee),
W64LIT(0x3d9296aabcb36538),
W64LIT(0x2cce1d8264c45e4c),
W64LIT(0x5aedc1901a736d7d),
W64LIT(0x2e4ae6e3b6ca8fa9),
W64LIT(0x1e68f230905a8158),
W64LIT(0xdee0a2960805b976),
W64LIT(0xcd38d2df027c53e7),
W64LIT(0x6909a9e887ea20e1),
W64LIT(0x24c11bf3c6fcf032),
W64LIT(0x18110a9313480782),
W64LIT(0xa7f7079c3e9f306b),
W64LIT(0xd8995a358b173fac),
W64LIT(0x854fe4cc7b714683),
W64LIT(0xbd62f66effd9e60c),
W64LIT(0x14e30f20e06cfec3),
W64LIT(0x6e32d6816dff34b3),
W64LIT(0x217e9ffbfee73585),
W64LIT(0xc88756d73a679650),
W64LIT(0x359d90db1e8bcb46),
W64LIT(0x2645e09214f221d7),
W64LIT(0x04fd03c2511c573f),
W64LIT(0x739c581a46acf686),
W64LIT(0xb0d2741765fa8dc5),
W64LIT(0xa0cc78f5d48a2439),
W64LIT(0x5e10c2524b6f3a42),
W64LIT(0xe50bcc9f37a45a94),
W64LIT(0x53a0402bd14c518b),
W64LIT(0x413ab7a8b2322992),
W64LIT(0x203c183197e0a70d),
W64LIT(0xcc7a55156b7bc16f),
W64LIT(0x4601c8c158273dc0),
W64LIT(0xbea48ac544d0a561),
W64LIT(0x638254f8f7dc5f7a),
W64LIT(0xa6b580565798a2e3),
W64LIT(0x3cd01160d5b4f7b0),
W64LIT(0x8c026577b04e7a75),
W64LIT(0x7ad1d9a18d93ca70),
W64LIT(0x785522c05f9d1b95),
W64LIT(0x5f5245982268a8ca),
W64LIT(0x9551e82eca01ef7f),
W64LIT(0x0000000000000000),
W64LIT(0xbb1b0ecd7ccb60d6),
W64LIT(0x094d81bbcb3f3cf6),
W64LIT(0x28331e4035d80973),
W64LIT(0xf7913b1c54da228d),
W64LIT(0x6acfd5433ce3638c),
W64LIT(0x1bd77638a84144ef),
W64LIT(0x62c0d3329edbcdf2),
W64LIT(0x81b2e70e2a6d11bc),
W64LIT(0xd7ad232dc33a8580),
W64LIT(0x05bf8408381bc5b7),
W64LIT(0x33e468789d994d9c),
W64LIT(0xfedcbaa79fe51e7b),
W64LIT(0x4f4c497a93180136),
W64LIT(0x073b7f69ea151452),
W64LIT(0x0cf205b3f324f941),
W64LIT(0x382d12a284a8a08f),
W64LIT(0x1cec0951425450bd),
W64LIT(0x55d9b888525ed751),
W64LIT(0x6cb62de0bff1e556),
W64LIT(0xd1d4db8e4028035a),
W64LIT(0x25839c39affb62ba),
W64LIT(0x4af3cd72ab03c481),
W64LIT(0xa4317b3785967306),
W64LIT(0x1a95f1f2c146d667),
W64LIT(0x926a97472014fb2d),
W64LIT(0xb7e90b7e8fef9997),
W64LIT(0xcefeae74b975108a),
W64LIT(0x3e54ea0107ba2655),
W64LIT(0xd0965c44292f91d2),
W64LIT(0xab05022fcdbbc92a),
W64LIT(0xfd1ac60c24ec5d16),
W64LIT(0xfc5841c64debcf9e),
W64LIT(0xe4494b555ea3c81c),
W64LIT(0xb6ab8cb4e6e80b1f),
W64LIT(0x3beb6e093fa1e3e2),
W64LIT(0xf36c38de05c675b2),
W64LIT(0x9c1c6995013ed389),
W64LIT(0x8b391a1e5a5b6e27),
W64LIT(0xec464d24fc9b6662),
W64LIT(0xad7cfa8c4ea94ff0),
W64LIT(0x0f347918482dba2c),
W64LIT(0x9d5eee5f68394101),
W64LIT(0x7623dc127eb73331),
W64LIT(0x32a6efb2f49edf14),
W64LIT(0x2d8c9a480dc3ccc4),
W64LIT(0xb2568f76b7f45c20),
W64LIT(0x0e76fed2212a28a4),
W64LIT(0x48773613790d1564),
W64LIT(0x129af783637e7819),
W64LIT(0x080f0671a238ae7e),
W64LIT(0x365bec70a582882b),
W64LIT(0x42fccb03093b6aff),
W64LIT(0x0a8bfd1070367f9b),
W64LIT(0xff9e3d6df6e28cf3),
W64LIT(0xe8bb4ee6ad87315d),
W64LIT(0xc7b32fcf724a2c7c),
W64LIT(0xb8dd7266c7c223bb),
W64LIT(0x9328108d491369a5),
W64LIT(0x0679f8a3831286da),
W64LIT(0x270767587df5b35f),
W64LIT(0xa981f94e1fb518cf),
W64LIT(0x6b8d528955e4f104),
W64LIT(0x1667f44132622f26),
W64LIT(0x2ab7e521e7d6d896),
W64LIT(0xac3e7d4627aedd78),
W64LIT(0x7deaa6c86786de22),
W64LIT(0x1725738b5b65bdae),
W64LIT(0x4bb14ab8c2045609),
W64LIT(0x592bbd3ba17a2e10),
W64LIT(0xc20cabc74a51e9cb),
W64LIT(0x6f70514b04f8a63b),
W64LIT(0xbc2071a496de7484),
W64LIT(0x19538d597a4f950a),
W64LIT(0xf45747b7efd361e0),
W64LIT(0x43be4cc9603cf877),
W64LIT(0xc6f1a8051b4dbef4),
W64LIT(0xb42f77d534e6dafa),
W64LIT(0x40783062db35bb1a),
/* box 5 */
W64LIT(0xf5a96c292deb0a4e),
W64LIT(0x211c9df6ee653c51),
W64LIT(0x04de5ddcbeeef596),
W64LIT(0xe1e5b06f7457c19f),
W64LIT(0x74ca30f014a54fb6),
W64LIT(0xc296f9f7c5457d85),
W64LIT(0x7d4ee08a484d10b0),
W64LIT(0xae87f2d0bf9b13ad),
W64LIT(0x8df4bb480e89afb7),
W64LIT(0x2d8b7a67d9a2d61e),
W64LIT(0x0f3559c8bd712adb),
W64LIT(0x541bc7312f013338),
W64LIT(0x9ec4848b636d5164),
W64LIT(0x952f809f60f28e29),
W64LIT(0x28984d8cb28d6357),
W64LIT(0xd4b5f1dfc38e361f),
W64LIT(0x5674135f7076b373),
W64LIT(0xb791a330042172ec),
W64LIT(0xab94c53bd4b4a6e4),
W64LIT(0xf17731f59305ffd8),
W64LIT(0x39c7a621801e1dcf),
W64LIT(0x20d1f7c13ba47c8e),
W64LIT(0x5e3da912f95facaa),
W64LIT(0xb1202a82e5b80731),
W64LIT(0x13303fc36de4fed3),
W64LIT(0x2e29c43e5314168a),
W64LIT(0x861fbf5c0d1670fa),
W64LIT(0x6458b16af3f771f1),
W64LIT(0x3043765bdcf642c9),
W64LIT(0x12fd55f4b825be0c),
W64LIT(0x0a266e23d65e9f92),
W64LIT(0x6595db5d2636312e),
W64LIT(0x85bd010587a0b06e),
W64LIT(0x9bd7b3600842e42d),
W64LIT(0xaa59af0c0175e63b),
W64LIT(0x240faa1d854a8918),
W64LIT(0xf464061ef82a4a91),
W64LIT(0x5c527d7ca6282ce1),
W64LIT(0x03a2be598ab6c094),
W64LIT(0x40571b7776bdf8e9),
W64LIT(0xe4f687841f7874d6),
W64LIT(0x115febad32937e98),
W64LIT(0x5108f0da442e8671),
W64LIT(0x9cab50e53c1ad12f),
W64LIT(0x33e1c8025640825d),
W64LIT(0x87d2d56bd8d73025),
W64LIT(0xc0f92d999a32fdce),
W64LIT(0x62e938d8126e042c),
W64LIT(0x4a717554a0e3677b),
W64LIT(0x0beb0414039fdf4d),
W64LIT(0xd6da25b19cf9b654),
W64LIT(0x55d6ad06fac073e7),
W64LIT(0x632452efc7af44f3),
W64LIT(0xb5fe775e5b56f2a7),
W64LIT(0x892ae694b0675a21),
W64LIT(0x7a32030f7c1525b2),
W64LIT(0x5d9f174b73e96c3e),
W64LIT(0xc35b93c010843d5a),
W64LIT(0x373f95dee8ae77cb),
W64LIT(0xfb515fd6455b604a),
W64LIT(0xa9fb11558bc326af),
W64LIT(0x22be23af64d3fcc5),
W64LIT(0xa8367b625e026670),
W64LIT(0xb8a4faf8b9505837),
W64LIT(0x785dd7612362a5f9),
W64LIT(0x588c20a018c6d977),
W64LIT(0xea0eb47b77c81ed2),
W64LIT(0xa6ce489d36b20c74),
W64LIT(0x0c97e79137c7ea4f),
W64LIT(0x7c838abd9d8c506f),
W64LIT(0x57b97968a5b7f3ac),
W64LIT(0x6c110b277ade6e28),
W64LIT(0xc785ce1cae6ac8cc),
W64LIT(0x1581b6718c7d8b0e),
W64LIT(0x614b868198d8c4b8),
W64LIT(0x27ad14440ffc498c),
W64LIT(0xdb80a8177eff1cc4),
W64LIT(0x472bf8f242e5cdeb),
W64LIT(0x8a8858cd3ad19ab5),
W64LIT(0xf60bd270a75dcada),
W64LIT(0x43f5a52efc0b387d),
W64LIT(0x6ddc6110af1f2ef7),
W64LIT(0xf0ba5bc246c4bf07),
W64LIT(0x6fb3b57ef068aebc),
W64LIT(0x18db3bd76e7b219e),
W64LIT(0x903cb7740bdd3b60),
W64LIT(0x7bff6938a9d4656d),
W64LIT(0xbdb7cd13d27fed7e),
W64LIT(0x051337eb6b2fb549),
W64LIT(0x77688ea99e138f22),
W64LIT(0xd9ef7c7921889c8f),
W64LIT(0x077ce38534583502),
W64LIT(0xf318e59bcc727f93),
W64LIT(0xb34ffeecbacf877a),
W64LIT(0xe9ac0a22fd7ede46),
W64LIT(0xfc2dbc5371035548),
W64LIT(0x026fd46e5f77804b),
W64LIT(0xe53bedb3cab93409),
W64LIT(0xcc6eca08adf51781),
W64LIT(0xe028da58a1968140),
W64LIT(0x3a6518780aa8dd5b),
W64LIT(0xce011e66f28297ca),
W64LIT(0xa4a19cf369c58c3f),
W64LIT(0xc5ea1a72f11d4887),
W64LIT(0xc427704524dc0858),
W64LIT(0x4238cf1929ca78a2),
W64LIT(0x481ea13aff94e730),
W64LIT(0xdf5ef5cbc011e952),
W64LIT(0x80ae36eeec8f0527),
W64LIT(0x5ae3f4ce47b1593c),
W64LIT(0xcda3a03f7834575e),
W64LIT(0x71d9071b7f8afaff),
W64LIT(0xcadf43ba4c6c625c),
W64LIT(0x1623082806cb4b9a),
W64LIT(0x17ee621fd30a0b45),
W64LIT(0x448946abc8530d7f),
W64LIT(0x974054f13f850e62),
W64LIT(0x73b6d37520fd7ab4),
W64LIT(0xc8b097d4131be217),
W64LIT(0x9f09eebcb6ac11bb),
W64LIT(0x45442c9c1d924da0),
W64LIT(0x1b79858ee4cde10a),
W64LIT(0x0984d07a5ce85f06),
W64LIT(0x4cc0fce6417a12a6),
W64LIT(0x99b8670e57356466),
W64LIT(0xad254c89352dd339),
W64LIT(0x322ca2358381c282),
W64LIT(0xcfcc74512743d715),
W64LIT(0x6b6de8a24e865b2a),
W64LIT(0xda4dc220ab3e5c1b),
W64LIT(0x88e78ca365a61afe),
W64LIT(0x939e092d816bfbf4),
W64LIT(0xcb12298d99ad2283),
W64LIT(0xeed0e9a7c926eb44),
W64LIT(0x98750d3982f424b9),
W64LIT(0xd5789be8164f76c0),
W64LIT(0xbe15734a58c92dea),
W64LIT(0x49d3cb0d2a55a7ef),
W64LIT(0x67fa0f337941b165),
W64LIT(0x8c39d17fdb48ef68),
W64LIT(0x25c2c02a508bc9c7),
W64LIT(0x349d2b876218b75f),
W64LIT(0x70146d2caa4bba20),
W64LIT(0x1c05660bd095d408),
W64LIT(0xfe42683d2e74d503),
W64LIT(0x9a1ad957dd83a4f2),
W64LIT(0xf2d58fac19b33f4c),
W64LIT(0x81635cd9394e45f8),
W64LIT(0xb65cc907d1e03233),
W64LIT(0xdd3121a59f666919),
W64LIT(0x318e1c6c09370216),
W64LIT(0x8b4532faef10da6a),
W64LIT(0x191651e0bbba6141),
W64LIT(0x3f762f9361876812),
W64LIT(0xb96990cf6c9118e8),
W64LIT(0xb4331d698e97b278),
W64LIT(0xd822164ef449dc50),
W64LIT(0x84706b325261f0b1),
W64LIT(0x4eaf28881e0d92ed),
W64LIT(0x69023ccc11f1db61),
W64LIT(0x66376504ac80f1ba),
W64LIT(0x0849ba4d89291fd9),
W64LIT(0xff8f020afbb595dc),
W64LIT(0x50c59aed91efc6ae),
W64LIT(0x1dc80c3c055494d7),
W64LIT(0x1e6ab2658fe25443),
W64LIT(0x3d19fbfd3ef0e859),
W64LIT(0xfa9c35e1909a2095),
W64LIT(0x52aa4e83ce9846e5),
W64LIT(0x419a7140a37cb836),
W64LIT(0xa07fc12fd72b79a9),
W64LIT(0x68cf56fbc4309bbe),
W64LIT(0x01cd6a37d5c140df),
W64LIT(0x9253631a54aabb2b),
W64LIT(0xd06bac037d60c389),
W64LIT(0x295527bb674c2388),
W64LIT(0xd204786d221743c2),
W64LIT(0x0000000000000000),
W64LIT(0xf7c6b847729c8a05),
W64LIT(0xdcfc4b924aa729c6),
W64LIT(0xe38a64012b2041d4),
W64LIT(0xb28294db6f0ec7a5),
W64LIT(0x9d663ad2e9db91f0),
W64LIT(0x91f1dd43de1c7bbf),
W64LIT(0x6086ecb64d198467),
W64LIT(0x59414a97cd0799a8),
W64LIT(0xace826bee0ec93e6),
W64LIT(0xa56cf6c4bc04cce0),
W64LIT(0x727bb942f53c3a6b),
W64LIT(0x6e7edf4925a9ee63),
W64LIT(0x26607e73da3d0953),
W64LIT(0xe75439dd95ceb442),
W64LIT(0x7990bd56f6a3e526),
W64LIT(0xecbf3dc996516b0f),
W64LIT(0x76a5e49e4bd2cffd),
W64LIT(0x968d3ec6ea444ebd),
W64LIT(0x5b2e9ef9927019e3),
W64LIT(0x6aa082959b471bf5),
W64LIT(0xbb0644a133e698a3),
W64LIT(0x830c88b76639c5b3),
W64LIT(0xe2470e36fee1010b),
W64LIT(0xb0ed40b5307947ee),
W64LIT(0x355041b0b7d9f780),
W64LIT(0x8e560511843f6f23),
W64LIT(0x7f2134e4173a90fb),
W64LIT(0x2af799e2edfae31c),
W64LIT(0x4bbc1f63752227a4),
W64LIT(0xf8f3e18fcfeda0de),
W64LIT(0x0d5a8da6e206aa90),
W64LIT(0x2c4610500c6396c1),
W64LIT(0xde939ffc15d0a98d),
W64LIT(0xaf4a98e76a5a5372),
W64LIT(0x8f9b6f2651fe2ffc),
W64LIT(0x36f2ffe93d6f3714),
W64LIT(0x0ef833ff68b06a04),
W64LIT(0xe69953ea400ff49d),
W64LIT(0x23734998b112bc1a),
W64LIT(0x3ebb45a4b44628cd),
W64LIT(0x1ab4efb9310ca1d5),
W64LIT(0x2fe4ae0986d55655),
W64LIT(0xebc3de4ca2095e0d),
W64LIT(0x536724b41b59063a),
W64LIT(0x46e692c597248d34),
W64LIT(0x2b3af3d5383ba3c3),
W64LIT(0x3ba8724fdf699d84),
W64LIT(0xc13447ae4ff3bd11),
W64LIT(0x4d0d96d194bb5279),
W64LIT(0xfde0d664a4c21597),
W64LIT(0xd7174f864938f68b),
W64LIT(0x7eec5ed3c2fbd024),
W64LIT(0xbfd8197d8d086d35),
W64LIT(0x4f6242bfcbccd232),
W64LIT(0xa70322aae3734cab),
W64LIT(0xa3dd7f765d9db93d),
W64LIT(0x94e2eaa8b533cef6),
W64LIT(0x144cdc4659bccbd1),
W64LIT(0xc648a42b7bab8813),
W64LIT(0xf93e8bb81a2ce001),
W64LIT(0xbacb2e96e627d87c),
W64LIT(0xbc7aa72407beada1),
W64LIT(0xc97dfde3c6daa2c8),
W64LIT(0xa1b2ab1802ea3976),
W64LIT(0x1fa7d8525a23149c),
W64LIT(0x75075ac7c1640f69),
W64LIT(0xe861601528bf9e99),
W64LIT(0xa2101541885cf9e2),
W64LIT(0xef1d83901ce7ab9b),
W64LIT(0x06b189b2e19975dd),
W64LIT(0x380acc1655df5d10),
W64LIT(0x1092819ae7523e47),
W64LIT(0xd3c9125af7d6031d),
W64LIT(0xd1a6c634a8a18356),
W64LIT(0x5ff0c3252c9eec75),
W64LIT(0x82c1e280b3f8856c),
W64LIT(0xed7257fe43902bd0),
W64LIT(0x3cd491caeb31a886),
/* box 6 */
W64LIT(0x94af9eb6fad9e7df),
W64LIT(0x9208ae5e03c94ddd),
W64LIT(0x1d8de8d67158480b),
W64LIT(0xfd093cd2ba147af8),
W64LIT(0xa45ceb22e6597ccf),
W64LIT(0x9bbde6e77bf113da),
W64LIT(0xe4edf4b465fffe5c),
W64LIT(0x7125622e4e8d2a2f),
W64LIT(0x1791b81b8f68430d),
W64LIT(0xb56a63d1902195c0),
W64LIT(0xa980832b30d2ee67),
W64LIT(0x4c0a7fb384862397),
W64LIT(0xed58bc0d1dc7a05b),
W64LIT(0x5955d7f05c4d0637),
W64LIT(0xd2b9b1c8806fcf4e),
W64LIT(0x06a730e8f910aa02),
W64LIT(0xb8b60bd846aa0768),
W64LIT(0x45bf370afcbe7d90),
W64LIT(0x16f6b0375ec370a1),
W64LIT(0x892276608b81afd4),
W64LIT(0xdcccc1b5d0ec08e7),
W64LIT(0xe856949162df5f58),
W64LIT(0x82592e81a41a977e),
W64LIT(0xac8eabb74fca1164),
W64LIT(0xfac9041692afe356),
W64LIT(0x3b882d75331ba3ba),
W64LIT(0xa39cd3e6cee2e561),
W64LIT(0xd077a190d7cca9e3),
W64LIT(0x9c7dde23534a8a74),
W64LIT(0x80973ed9f3b9f1d3),
W64LIT(0xce535132209cb4e9),
W64LIT(0xaa299b5fb6dabb66),
W64LIT(0x2d7e9d426dd8d31b),
W64LIT(0x8a8b6e140d89fad5),
W64LIT(0x6ca88af83fd56224),
W64LIT(0xf5db7c4713871753),
W64LIT(0xeef1a4799bcff55a),
W64LIT(0x76e55aea6636b381),
W64LIT(0x8ee24ea4a33a367a),
W64LIT(0x25acddd7c44bbeb0),
W64LIT(0x9adaeecbaa5a2076),
W64LIT(0x0e75707d5083c7a9),
W64LIT(0x2bd9adaa94c87919),
W64LIT(0x19e4c866dfeb84a4),
W64LIT(0x129f9087f070bc0e),
W64LIT(0xd9c2e929aff4f7e4),
W64LIT(0x6f01928cb9dd3725),
W64LIT(0x39463d2d64b8c517),
W64LIT(0xebff8ce5e4d70a59),
W64LIT(0xb40d6bfd418aa66c),
W64LIT(0xf21b44833b3c8efd),
W64LIT(0x3654457ce5903112),
W64LIT(0x431807e205aed792),
W64LIT(0xb10343613e92596f),
W64LIT(0x0a1c50cdfe300b06),
W64LIT(0x778252c6b79d802d),
W64LIT(0x0cbb60250720a104),
W64LIT(0xe1e3dc281ae7015f),
W64LIT(0x0f1278518128f405),
W64LIT(0x47712752ab1d1b3d),
W64LIT(0xe24ac45c9cef545e),
W64LIT(0x1ceae0faa0f37ba7),
W64LIT(0x9814fe93fdf946db),
W64LIT(0xec3fb421cc6c93f7),
W64LIT(0x833e26ad75b1a4d2),
W64LIT(0x6b68b23c176efb8a),
W64LIT(0x4904572ffb9edc94),
W64LIT(0x4bca4777ac3dba39),
W64LIT(0x2762cd8f93e8d81d),
W64LIT(0x9eb3ce7b04e9ecd9),
W64LIT(0xc2e8311727bc15ed),
W64LIT(0xea9884c9357c39f5),
W64LIT(0xfc6e34fe6bbf4954),
W64LIT(0x13f898ab21db8fa2),
W64LIT(0xb7a47389c782f36d),
W64LIT(0x7b3932e3b0bd2129),
W64LIT(0xaf27b3c3c9c24465),
W64LIT(0xb6c37ba51629c0c1),
W64LIT(0x84fe1e695d0a3d7c),
W64LIT(0x1a4dd01259e3d1a5),
W64LIT(0xab4e9373677188ca),
W64LIT(0x90c6be06546a2b70),
W64LIT(0xf37c4cafea97bd51),
W64LIT(0x647aca6d96460f8f),
W64LIT(0x4ec46febd325453a),
W64LIT(0x3e8605e94c035cb9),
W64LIT(0x0ddc6809d68b92a8),
W64LIT(0x8bec6638dc22c979),
W64LIT(0x67d3d219104e5a8e),
W64LIT(0x2abea58645634ab5),
W64LIT(0x5b9bc7a80bee609a),
W64LIT(0x936fa672d2627e71),
W64LIT(0x7d9e020b49ad8b2b),
W64LIT(0x5832dfdc8de6359b),
W64LIT(0xc7e6198b58a4eaee),
W64LIT(0xd41e8120797f654c),
W64LIT(0xf4bc746bc22c24ff),
W64LIT(0xe084d404cb4c32f3),
W64LIT(0x48635f032a35ef38),
W64LIT(0x8757061ddb02687d),
W64LIT(0x522e8f1173d63e9d),
W64LIT(0xbcdf2b68e819cbc7),
W64LIT(0xbf76331c6e119ec6),
W64LIT(0x08d24095a9936dab),
W64LIT(0x728c7a5ac8857f2e),
W64LIT(0xd110a9bc06679a4f),
W64LIT(0x1f43f88e26fb2ea6),
W64LIT(0xb2aa5b15b89a0c6e),
W64LIT(0x4aad4f5b7d968995),
W64LIT(0x9fd4c657d542df75),
W64LIT(0x323d65cc4b23fdbd),
W64LIT(0xc38f393bf6172641),
W64LIT(0xa152c3be994183cc),
W64LIT(0x9d1ad60f82e1b9d8),
W64LIT(0xe744ecc0e3f7ab5d),
W64LIT(0x38213501b513f6bb),
W64LIT(0xade9a39b9e6122c8),
W64LIT(0x37334d50343b02be),
W64LIT(0x55eeb7d55b6da733),
W64LIT(0x970686c27cd1b2de),
W64LIT(0x427f0fced405e43e),
W64LIT(0xc026214f701f7340),
W64LIT(0x40b11f9683a68293),
W64LIT(0x02ce105857a366ad),
W64LIT(0x7e371a7fcfa5de2a),
W64LIT(0xffc72c8aedb71c55),
W64LIT(0x68c1aa489166ae8b),
W64LIT(0xc68111a7890fd942),
W64LIT(0x79f722bbe71e4784),
W64LIT(0xd579890ca8d456e0),
W64LIT(0x70426a029f261983),
W64LIT(0xb0644b4def396ac3),
W64LIT(0xdb0cf971f8579149),
W64LIT(0x5489bff98ac6949f),
W64LIT(0x046920b0aeb3ccaf),
W64LIT(0x7cf90a279806b887),
W64LIT(0x050e289c7f18ff03),
W64LIT(0x651dc24147ed3c23),
W64LIT(0x5e95ef3474f69f99),
W64LIT(0x6dcf82d4ee7e5188),
W64LIT(0x8f854688729105d6),
W64LIT(0x81f036f52212c27f),
W64LIT(0xb9d103f4970134c4),
W64LIT(0x5349873da27d0d31),
W64LIT(0x20a2f54bbb5341b3),
W64LIT(0xf0d554db6c9fe850),
W64LIT(0x07c038c428bb99ae),
W64LIT(0x30f375941c809b10),
W64LIT(0x3fe10dc59da86f15),
W64LIT(0x46162f7e7ab62891),
W64LIT(0xe623e4ec325c98f1),
W64LIT(0xfea024a63c1c2ff9),
W64LIT(0x349a5524b23357bf),
W64LIT(0x35fd5d0863986413),
W64LIT(0x96618eeead7a8172),
W64LIT(0xcb5d79ae5f844bea),
W64LIT(0x21c5fd676af8721f),
W64LIT(0x5720a78d0ccec19e),
W64LIT(0xf6726433958f4252),
W64LIT(0x8d4b56d02532637b),
W64LIT(0x24cbd5fb15e08d1c),
W64LIT(0x3aef2559e2b09016),
W64LIT(0x5afccf84da455336),
W64LIT(0x51879765f5de6b9c),
W64LIT(0x2917bdf2c36b1fb4),
W64LIT(0xa7f5f356605129ce),
W64LIT(0xc1412963a1b440ec),
W64LIT(0x3d2f1d9dca0b09b8),
W64LIT(0xa53be30e37f24f63),
W64LIT(0x5ff2e718a55dac35),
W64LIT(0xa2fbdbca1f49d6cd),
W64LIT(0xf7156c1f442471fe),
W64LIT(0x7a5e3acf61161285),
W64LIT(0xca3a71828e2f7846),
W64LIT(0x1b2ad83e8848e209),
W64LIT(0xa8e78b07e179ddcb),
W64LIT(0xef96ac554a64c6f6),
W64LIT(0x0000000000000000),
W64LIT(0x6013eadd38f5c320),
W64LIT(0x3c4815b11ba03a14),
W64LIT(0x09b548b978385e07),
W64LIT(0x226ce513ecf0271e),
W64LIT(0x63baf2a9befd9621),
W64LIT(0x44d83f262d154e3c),
W64LIT(0xcdfa4946a694e1e8),
W64LIT(0x113688f37678e90f),
W64LIT(0x859916458ca10ed0),
W64LIT(0xc52809d30f078c43),
W64LIT(0x4d6d779f552d103b),
W64LIT(0x1e24f0a2f7501d0a),
W64LIT(0x0167082cd1ab33ac),
W64LIT(0x1438a06f0960160c),
W64LIT(0xf9601c6214a7b657),
W64LIT(0xa035cb9248eab060),
W64LIT(0x50e09f4924755830),
W64LIT(0xd7b79954ff77304d),
W64LIT(0xe58afc98b454cdf0),
W64LIT(0x03a9187486085501),
W64LIT(0x62ddfa856f56a58d),
W64LIT(0xc44f01ffdeacbfef),
W64LIT(0x73eb7276192e4c82),
W64LIT(0xd6d091782edc03e1),
W64LIT(0xfbae0c3a4304d0fa),
W64LIT(0x9973f6bf2c527577),
W64LIT(0x105180dfa7d3daa3),
W64LIT(0x2605c5a34243ebb1),
W64LIT(0x91a1b62a85c118dc),
W64LIT(0xc99369f608272d47),
W64LIT(0x5d3cf740f2feca98),
W64LIT(0xcf34591ef1378745),
W64LIT(0xc8f461dad98c1eeb),
W64LIT(0x0b7b58e12f9b38aa),
W64LIT(0xe32dcc704d4467f2),
W64LIT(0x754c429ee03ee680),
W64LIT(0xd3deb9e451c4fce2),
W64LIT(0x6e669aa068760489),
W64LIT(0x66b4da35c1e56922),
W64LIT(0x4fa367c7028e7696),
W64LIT(0xba781b80110961c5),
W64LIT(0x41d617ba520db13f),
W64LIT(0x335a6de09a88ce11),
W64LIT(0xdf65d9c156e45de6),
W64LIT(0xcc9d416a773fd244),
W64LIT(0x5c5bff6c2355f934),
W64LIT(0x2870b5de12c02c18),
W64LIT(0x155fa843d8cb25a0),
W64LIT(0x78902a9736b57428),
W64LIT(0xae40bbef186977c9),
W64LIT(0x88457e4c5a2a9c78),
W64LIT(0x6a0fba10c6c5c826),
W64LIT(0x7f5012531e0eed86),
W64LIT(0x8c2c5efcf49950d7),
W64LIT(0x31947db8cd2ba8bc),
W64LIT(0x2c19956ebc73e0b7),
W64LIT(0x230bed3f3d5b14b2),
W64LIT(0x69a6a26440cd9d27),
W64LIT(0x86300e310aa95bd1),
W64LIT(0xb3cd533969313fc2),
W64LIT(0x1883c04a0e40b708),
W64LIT(0xf1b25cf7bd34dbfc),
W64LIT(0x2fb08d1a3a7bb5b6),
W64LIT(0xd8a5e1057e5fc448),
W64LIT(0xddabc99901473b4b),
W64LIT(0xde02d1ed874f6e4a),
W64LIT(0xbdb8234439b2f86b),
W64LIT(0x5647afa1dd65f232),
W64LIT(0x2ed78536ebd0861a),
W64LIT(0xe9319cbdb3746cf4),
W64LIT(0xa692fb7ab1fa1a62),
W64LIT(0x742b4ab23195d52c),
W64LIT(0x95c8969a2b72d473),
W64LIT(0x6174e2f1e95ef08c),
W64LIT(0xf807144ec50c85fb),
W64LIT(0xbe113b30bfbaad6a),
W64LIT(0xda6bf15d29fca2e5),
W64LIT(0xbb1f13acc0a25269),
/* box 7 */
W64LIT(0xc22b27f0f9e37bf9),
W64LIT(0x93fad23f0955ef09),
W64LIT(0x32ed4b84a22a91a2),
W64LIT(0x3898b57bcc61b1cc),
W64LIT(0x55825ba9ad98e5ad),
W64LIT(0xb2eeb8069421ec94),
W64LIT(0xc7eb5875ce3c6bce),
W64LIT(0x4b1dac5d1f45851f),
W64LIT(0xc16ba1204705d847),
W64LIT(0xc5380f461a2ba91a),
W64LIT(0xb908971a909bad90),
W64LIT(0x303e1cb7763d5376),
W64LIT(0xe6ff324c53486853),
W64LIT(0x6d1aeed261f95461),
W64LIT(0x0193d1e36af1616a),
W64LIT(0x51d1f5cff0b694f0),
W64LIT(0x29b2c3f52728e127),
W64LIT(0x112a768eeb4950eb),
W64LIT(0x8fb672f86f9f4d6f),
W64LIT(0xf0c66c745bc9ea5b),
W64LIT(0x3f8b9dcd2fa9632f),
W64LIT(0x65bc471edba5b6db),
W64LIT(0x4d9d5508967c3696),
W64LIT(0x3a4be24818767318),
W64LIT(0x2794936c144db014),
W64LIT(0x2af2452599ce4299),
W64LIT(0x4a8e7dbe75b4e475),
W64LIT(0x9ddc82a63a30be3a),
W64LIT(0xade29e114c0ded4c),
W64LIT(0xd1d2064dc6bde9c6),
W64LIT(0x7da349bfe04165e0),
W64LIT(0x6b9a1787e8c0e7e8),
W64LIT(0xa54437ddf6510ff6),
W64LIT(0x2254ece92392a023),
W64LIT(0x79f0e7d9bd6f14bd),
W64LIT(0x57510c9a798f2779),
W64LIT(0x346db2d12b13222b),
W64LIT(0x54118a4ac76984c7),
W64LIT(0xefca4a6383e5eb83),
W64LIT(0xca8d8e3c43bf9943),
W64LIT(0xfc336bdebcbb79bc),
W64LIT(0x3e184c2e45580245),
W64LIT(0xf495c21206e79b06),
W64LIT(0xff73ed0e025dda02),
W64LIT(0x4228d472cfe806cf),
W64LIT(0xbcc8e89fa744bda7),
W64LIT(0xab626744c5345ec5),
W64LIT(0xb6bd1660c90f9dc9),
W64LIT(0xb72ec783a3fefca3),
W64LIT(0x8be5dc9e32b13c32),
W64LIT(0x485d2a8da1a326a1),
W64LIT(0xc6788996a4cd0aa4),
W64LIT(0x40fb83411bffc41b),
W64LIT(0x08a6a9ccba5ce2ba),
W64LIT(0xf386eaa4e52f49e5),
W64LIT(0x1acc5992eff311ef),
W64LIT(0xa2571f6b1599dd15),
W64LIT(0x44a82d2746d1b546),
W64LIT(0x70c59ff66dc2976d),
W64LIT(0x8d6525cbbb888fbb),
W64LIT(0x963aadba3e8aff3e),
W64LIT(0x7c30985c8ab0048a),
W64LIT(0x607c389bec7aa6ec),
W64LIT(0xa822e1947bd2fd7b),
W64LIT(0x034086d0bee6a3be),
W64LIT(0x66fcc1ce65431565),
W64LIT(0xb37d69e5fed08dfe),
W64LIT(0x2f323aa0ae1152ae),
W64LIT(0x56c2dd79137e4613),
W64LIT(0x31adcd541ccc321c),
W64LIT(0xdff456d4f5d8b8f5),
W64LIT(0xf9f3145b8b64698b),
W64LIT(0x764566a3e4fb24e4),
W64LIT(0x0cf507aae77293e7),
W64LIT(0x59775c034aea764a),
W64LIT(0xb89b46f9fa6accfa),
W64LIT(0xe8d962d5602d3960),
W64LIT(0x17aa8fdb6270e362),
W64LIT(0x1c4ca0c766caa266),
W64LIT(0x2de16d937a06907a),
W64LIT(0x2547c45fc05a72c0),
W64LIT(0x0fb5817a59943059),
W64LIT(0x0680f9558939b389),
W64LIT(0x16395e3808818208),
W64LIT(0xac714ff226fc8c26),
W64LIT(0xa9b1307711239c11),
W64LIT(0xec8accb33d03483d),
W64LIT(0x6c893f310b08350b),
W64LIT(0xc4abdea570dac870),
W64LIT(0xba4811ca2e7d0e2e),
W64LIT(0xf155bd9731388b31),
W64LIT(0xdd2701e721cf7a21),
W64LIT(0xe94ab3360adc580a),
W64LIT(0x23c73d0a4963c149),
W64LIT(0x5cb723867d35667d),
W64LIT(0x5042242c9a47f59a),
W64LIT(0x198cdf425115b251),
W64LIT(0x0a75feff6e4b206e),
W64LIT(0xfda0ba3dd64a18d6),
W64LIT(0xcede205a1e91e81e),
W64LIT(0xd041d7aeac4c88ac),
W64LIT(0xe42c657f875faa87),
W64LIT(0x36bee5e2ff04e0ff),
W64LIT(0x6fc9b9e1b5ee96b5),
W64LIT(0x998f2cc0671ecf67),
W64LIT(0xd301517e12aa2b12),
W64LIT(0xaea218c1f2eb4ef2),
W64LIT(0xda342951c207a8c2),
W64LIT(0x61efe978868bc786),
W64LIT(0x7f701e8c3456a734),
W64LIT(0x0be62f1c04ba4104),
W64LIT(0x9129850cdd422ddd),
W64LIT(0xd6c12efb25753b25),
W64LIT(0xe33f4dc964977864),
W64LIT(0x1579d8e8b66721b6),
W64LIT(0xf860c5b8e19508e1),
W64LIT(0x7496319030ece630),
W64LIT(0x88a55a4e8c579f8c),
W64LIT(0xcf4df1b974608974),
W64LIT(0x10b9a76d81b83181),
W64LIT(0x0e26509933655133),
W64LIT(0x43bb0591a51967a5),
W64LIT(0x926903dc63a48e63),
W64LIT(0x9c4f534550c1df50),
W64LIT(0x3bd833ab72871272),
W64LIT(0xa4d7e63e9ca06e9c),
W64LIT(0xb46e41531d185f1d),
W64LIT(0x126af05e55aff355),
W64LIT(0x24d415bcaaab13aa),
W64LIT(0x1e9ff7f4b2dd60b2),
W64LIT(0x05c07f8537df1037),
W64LIT(0x467b7a1492c67792),
W64LIT(0x2087bbdaf78562f7),
W64LIT(0x819022615cfa1c5c),
W64LIT(0xcd9ea68aa0774ba0),
W64LIT(0xa79760ee2246cd22),
W64LIT(0x8343755288edde88),
W64LIT(0x58e48de0201b1720),
W64LIT(0x7216c8c5b9d555b9),
W64LIT(0x372d340195f58195),
W64LIT(0xa11799bbab7f7eab),
W64LIT(0x9f0fd595ee277cee),
W64LIT(0x676f102d0fb2740f),
W64LIT(0x9e9c047684d61d84),
W64LIT(0x49cefb6ecb5247cb),
W64LIT(0xd41279c8f162f9f1),
W64LIT(0x1f0c2617d82c01d8),
W64LIT(0x97a97c59547b9e54),
W64LIT(0xe76ce3af39b90939),
W64LIT(0xc3b8f61393121a93),
W64LIT(0x5ba40b309efdb49e),
W64LIT(0xea0a35e6b43afbb4),
W64LIT(0x5a37dad3f40cd5f4),
W64LIT(0x14ea090bdc9640dc),
W64LIT(0x5e6474b5a922a4a9),
W64LIT(0xfee03ced68acbb68),
W64LIT(0x071328b6e3c8d2e3),
W64LIT(0x5302a2fc24a15624),
W64LIT(0x85c38c0701d46d01),
W64LIT(0x3d58cafefbbea1fb),
W64LIT(0x84505de46b250c6b),
W64LIT(0x642f96fdb154d7b1),
W64LIT(0xbf886e4f19a21e19),
W64LIT(0x02d35733d417c2d4),
W64LIT(0x68da915756264456),
W64LIT(0x8710db34d5c3afd5),
W64LIT(0x0d66d6498d83f28d),
W64LIT(0x7b23b0ea6978d669),
W64LIT(0x1b5f887185027085),
W64LIT(0x3ccb1b1d914fc091),
W64LIT(0x0453ae665d2e715d),
W64LIT(0xcb1e5fdf294ef829),
W64LIT(0xf6469521d2f059d2),
W64LIT(0xb03def3540362e40),
W64LIT(0x633cbe4b529c0552),
W64LIT(0xf7d544c2b80138b8),
W64LIT(0x7ab061090389b703),
W64LIT(0x0000000000000000),
W64LIT(0xdba7f8b2a8f6c9a8),
W64LIT(0x35fe633241e24341),
W64LIT(0x21146a399d74039d),
W64LIT(0xd581a82b9b93989b),
W64LIT(0x0935782fd0ad83d0),
W64LIT(0x5ff7a556c3d3c5c3),
W64LIT(0xaf31c922981a2f98),
W64LIT(0x90ba54efb7b34cb7),
W64LIT(0x5291731f4e50374e),
W64LIT(0xc0f870c32df4b92d),
W64LIT(0x7ee3cf6f5ea7c65e),
W64LIT(0xe07fcb19da71dbda),
W64LIT(0x4eddd3d8289a9528),
W64LIT(0x13f921bd3f5e923f),
W64LIT(0xf50613f16c16fa6c),
W64LIT(0x981cfd230defae0d),
W64LIT(0x4c0e84ebfc8d57fc),
W64LIT(0x82d0a4b1e21cbfe2),
W64LIT(0x89368bade6a6fee6),
W64LIT(0xd292809d785b4a78),
W64LIT(0x47e8abf7f83716f8),
W64LIT(0x8e25a31b056e2c05),
W64LIT(0xd752ff184f845a4f),
W64LIT(0xcc0d7769ca862aca),
W64LIT(0x694940b43cd7253c),
W64LIT(0x2ea1eb43c4e033c4),
W64LIT(0xde6787379f29d99f),
W64LIT(0x181f0ea13be4d33b),
W64LIT(0x416852a2710ea571),
W64LIT(0x62af6fa8386d6438),
W64LIT(0xa0844858c18e1fc1),
W64LIT(0x337e9a67c8dbf0c8),
W64LIT(0x2c72bc7010f7f110),
W64LIT(0xbd5b397ccdb5dccd),
W64LIT(0xd8e77e6216106a16),
W64LIT(0x86830ad7bf32cebf),
W64LIT(0x4f4e023b426bf442),
W64LIT(0xe5bfb49cedaecbed),
W64LIT(0x8a760d7d58405d58),
W64LIT(0xe2ac9c2a0e66190e),
W64LIT(0xb5fd90b077e93e77),
W64LIT(0xdcb4d0044b3e1b4b),
W64LIT(0x453bfcc42c20d42c),
W64LIT(0xed191d5057f22957),
W64LIT(0xe1ec1afab080bab0),
W64LIT(0xee599b80e9148ae9),
W64LIT(0x2607428f7ebcd17e),
W64LIT(0x5d24f26517c40717),
W64LIT(0x6a09c66482318682),
W64LIT(0xa604b10d48b7ac48),
W64LIT(0xbe1bbfac73537f73),
W64LIT(0x282112164dd9804d),
W64LIT(0x7505e0735a1d875a),
W64LIT(0x73851926d32434d3),
W64LIT(0xd974af817ce10b7c),
W64LIT(0xeb99e405decb9ade),
W64LIT(0x9b5c7bf3b3090db3),
W64LIT(0xfab3928b3582ca35),
W64LIT(0x8003f382360b7d36),
W64LIT(0x94e9fa89ea9d3dea),
W64LIT(0xb1ae3ed62ac74f2a),
W64LIT(0x9acfaa10d9f86cd9),
W64LIT(0x390b6498a690d0a6),
W64LIT(0xf2153b478fde288f),
W64LIT(0x71564e150733f607),
W64LIT(0xa3c4ce887f68bc7f),
W64LIT(0xaaf1b6a7afc53faf),
W64LIT(0x1ddf71240c3bc30c),
W64LIT(0x77d6b7408e0a458e),
W64LIT(0x2b6194c6f33f23f3),
W64LIT(0xc9cd08ecfd593afd),
W64LIT(0xc85ed90f97a85b97),
W64LIT(0x8cf6f428d179eed1),
W64LIT(0x957a2b6a806c5c80),
W64LIT(0xbbdbc029448c6f44),
W64LIT(0x7863363ad79e75d7),
W64LIT(0x6e5a6802df1ff7df),
W64LIT(0xfb2043685f73ab5f),
};

static const byte SHARK_iG[8*8] =
{
  0xe7, 0x30, 0x90, 0x85, 0xd0, 0x4b, 0x91, 0x41,
  0x53, 0x95, 0x9b, 0xa5, 0x96, 0xbc, 0xa1, 0x68,
  0x02, 0x45, 0xf7, 0x65, 0x5c, 0x1f, 0xb6, 0x52,
  0xa2, 0xca, 0x22, 0x94, 0x44, 0x63, 0x2a, 0xa2,
  0xfc, 0x67, 0x8e, 0x10, 0x29, 0x75, 0x85, 0x71,
  0x24, 0x45, 0xa2, 0xcf, 0x2f, 0x22, 0xc1, 0x0e,
  0xa1, 0xf1, 0x71, 0x40, 0x91, 0x27, 0x18, 0xa5,
  0x56, 0xf4, 0xaf, 0x32, 0xd2, 0xa4, 0xdc, 0x71,
};
//-----------------
static const word32 SHA256_K[64] =
{
  0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5,
  0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
  0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3,
  0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
  0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc,
  0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
  0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7,
  0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
  0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13,
  0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
  0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3,
  0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
  0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5,
  0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
  0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208,
  0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2
};

static const word64 SHA512_K[80] =
{
  W64LIT(0x428a2f98d728ae22), W64LIT(0x7137449123ef65cd),
  W64LIT(0xb5c0fbcfec4d3b2f), W64LIT(0xe9b5dba58189dbbc),
  W64LIT(0x3956c25bf348b538), W64LIT(0x59f111f1b605d019),
  W64LIT(0x923f82a4af194f9b), W64LIT(0xab1c5ed5da6d8118),
  W64LIT(0xd807aa98a3030242), W64LIT(0x12835b0145706fbe),
  W64LIT(0x243185be4ee4b28c), W64LIT(0x550c7dc3d5ffb4e2),
  W64LIT(0x72be5d74f27b896f), W64LIT(0x80deb1fe3b1696b1),
  W64LIT(0x9bdc06a725c71235), W64LIT(0xc19bf174cf692694),
  W64LIT(0xe49b69c19ef14ad2), W64LIT(0xefbe4786384f25e3),
  W64LIT(0x0fc19dc68b8cd5b5), W64LIT(0x240ca1cc77ac9c65),
  W64LIT(0x2de92c6f592b0275), W64LIT(0x4a7484aa6ea6e483),
  W64LIT(0x5cb0a9dcbd41fbd4), W64LIT(0x76f988da831153b5),
  W64LIT(0x983e5152ee66dfab), W64LIT(0xa831c66d2db43210),
  W64LIT(0xb00327c898fb213f), W64LIT(0xbf597fc7beef0ee4),
  W64LIT(0xc6e00bf33da88fc2), W64LIT(0xd5a79147930aa725),
  W64LIT(0x06ca6351e003826f), W64LIT(0x142929670a0e6e70),
  W64LIT(0x27b70a8546d22ffc), W64LIT(0x2e1b21385c26c926),
  W64LIT(0x4d2c6dfc5ac42aed), W64LIT(0x53380d139d95b3df),
  W64LIT(0x650a73548baf63de), W64LIT(0x766a0abb3c77b2a8),
  W64LIT(0x81c2c92e47edaee6), W64LIT(0x92722c851482353b),
  W64LIT(0xa2bfe8a14cf10364), W64LIT(0xa81a664bbc423001),
  W64LIT(0xc24b8b70d0f89791), W64LIT(0xc76c51a30654be30),
  W64LIT(0xd192e819d6ef5218), W64LIT(0xd69906245565a910),
  W64LIT(0xf40e35855771202a), W64LIT(0x106aa07032bbd1b8),
  W64LIT(0x19a4c116b8d2d0c8), W64LIT(0x1e376c085141ab53),
  W64LIT(0x2748774cdf8eeb99), W64LIT(0x34b0bcb5e19b48a8),
  W64LIT(0x391c0cb3c5c95a63), W64LIT(0x4ed8aa4ae3418acb),
  W64LIT(0x5b9cca4f7763e373), W64LIT(0x682e6ff3d6b2b8a3),
  W64LIT(0x748f82ee5defb2fc), W64LIT(0x78a5636f43172f60),
  W64LIT(0x84c87814a1f0ab72), W64LIT(0x8cc702081a6439ec),
  W64LIT(0x90befffa23631e28), W64LIT(0xa4506cebde82bde9),
  W64LIT(0xbef9a3f7b2c67915), W64LIT(0xc67178f2e372532b),
  W64LIT(0xca273eceea26619c), W64LIT(0xd186b8c721c0c207),
  W64LIT(0xeada7dd6cde0eb1e), W64LIT(0xf57d4f7fee6ed178),
  W64LIT(0x06f067aa72176fba), W64LIT(0x0a637dc5a2c898a6),
  W64LIT(0x113f9804bef90dae), W64LIT(0x1b710b35131c471b),
  W64LIT(0x28db77f523047d84), W64LIT(0x32caab7b40c72493),
  W64LIT(0x3c9ebe0a15c9bebc), W64LIT(0x431d67c49c100d4c),
  W64LIT(0x4cc5d4becb3e42b6), W64LIT(0x597f299cfc657e2a),
  W64LIT(0x5fcb6fab3ad6faec), W64LIT(0x6c44198c4a475817)
};

//-----------------
static const byte SAFER_exp_tab[256] =
{
  1, 45, 226, 147, 190, 69, 21, 174, 120, 3, 135, 164, 184, 56, 207, 63,
  8, 103, 9, 148, 235, 38, 168, 107, 189, 24, 52, 27, 187, 191, 114, 247,
  64, 53, 72, 156, 81, 47, 59, 85, 227, 192, 159, 216, 211, 243, 141, 177,
  255, 167, 62, 220, 134, 119, 215, 166, 17, 251, 244, 186, 146, 145, 100, 131,
  241, 51, 239, 218, 44, 181, 178, 43, 136, 209, 153, 203, 140, 132, 29, 20,
  129, 151, 113, 202, 95, 163, 139, 87, 60, 130, 196, 82, 92, 28, 232, 160,
  4, 180, 133, 74, 246, 19, 84, 182, 223, 12, 26, 142, 222, 224, 57, 252,
  32, 155, 36, 78, 169, 152, 158, 171, 242, 96, 208, 108, 234, 250, 199, 217,
  0, 212, 31, 110, 67, 188, 236, 83, 137, 254, 122, 93, 73, 201, 50, 194,
  249, 154, 248, 109, 22, 219, 89, 150, 68, 233, 205, 230, 70, 66, 143, 10,
  193, 204, 185, 101, 176, 210, 198, 172, 30, 65, 98, 41, 46, 14, 116, 80,
  2, 90, 195, 37, 123, 138, 42, 91, 240, 6, 13, 71, 111, 112, 157, 126,
  16, 206, 18, 39, 213, 76, 79, 214, 121, 48, 104, 54, 117, 125, 228, 237,
  128, 106, 144, 55, 162, 94, 118, 170, 197, 127, 61, 175, 165, 229, 25, 97,
  253, 77, 124, 183, 11, 238, 173, 75, 34, 245, 231, 115, 35, 33, 200, 5,
  225, 102, 221, 179, 88, 105, 99, 86, 15, 161, 49, 149, 23, 7, 58, 40
};

static const byte SAFER_log_tab[256] =
{
  128, 0, 176, 9, 96, 239, 185, 253, 16, 18, 159, 228, 105, 186, 173, 248,
  192, 56, 194, 101, 79, 6, 148, 252, 25, 222, 106, 27, 93, 78, 168, 130,
  112, 237, 232, 236, 114, 179, 21, 195, 255, 171, 182, 71, 68, 1, 172, 37,
  201, 250, 142, 65, 26, 33, 203, 211, 13, 110, 254, 38, 88, 218, 50, 15,
  32, 169, 157, 132, 152, 5, 156, 187, 34, 140, 99, 231, 197, 225, 115, 198,
  175, 36, 91, 135, 102, 39, 247, 87, 244, 150, 177, 183, 92, 139, 213, 84,
  121, 223, 170, 246, 62, 163, 241, 17, 202, 245, 209, 23, 123, 147, 131, 188,
  189, 82, 30, 235, 174, 204, 214, 53, 8, 200, 138, 180, 226, 205, 191, 217,
  208, 80, 89, 63, 77, 98, 52, 10, 72, 136, 181, 86, 76, 46, 107, 158,
  210, 61, 60, 3, 19, 251, 151, 81, 117, 74, 145, 113, 35, 190, 118, 42,
  95, 249, 212, 85, 11, 220, 55, 49, 22, 116, 215, 119, 167, 230, 7, 219,
  164, 47, 70, 243, 97, 69, 103, 227, 12, 162, 59, 28, 133, 24, 4, 29,
  41, 160, 143, 178, 90, 216, 166, 126, 238, 141, 83, 75, 161, 154, 193, 14,
  122, 73, 165, 44, 129, 196, 199, 54, 43, 127, 67, 149, 51, 242, 108, 104,
  109, 240, 2, 40, 206, 221, 155, 234, 94, 153, 124, 20, 134, 207, 229, 66,
  184, 64, 120, 45, 58, 233, 100, 31, 146, 144, 125, 57, 111, 224, 137, 48
};


//-----------------
static const word32 Rijndael_Te0[256] =
{
  0xc66363a5U, 0xf87c7c84U, 0xee777799U, 0xf67b7b8dU,
  0xfff2f20dU, 0xd66b6bbdU, 0xde6f6fb1U, 0x91c5c554U,
  0x60303050U, 0x02010103U, 0xce6767a9U, 0x562b2b7dU,
  0xe7fefe19U, 0xb5d7d762U, 0x4dababe6U, 0xec76769aU,
  0x8fcaca45U, 0x1f82829dU, 0x89c9c940U, 0xfa7d7d87U,
  0xeffafa15U, 0xb25959ebU, 0x8e4747c9U, 0xfbf0f00bU,
  0x41adadecU, 0xb3d4d467U, 0x5fa2a2fdU, 0x45afafeaU,
  0x239c9cbfU, 0x53a4a4f7U, 0xe4727296U, 0x9bc0c05bU,
  0x75b7b7c2U, 0xe1fdfd1cU, 0x3d9393aeU, 0x4c26266aU,
  0x6c36365aU, 0x7e3f3f41U, 0xf5f7f702U, 0x83cccc4fU,
  0x6834345cU, 0x51a5a5f4U, 0xd1e5e534U, 0xf9f1f108U,
  0xe2717193U, 0xabd8d873U, 0x62313153U, 0x2a15153fU,
  0x0804040cU, 0x95c7c752U, 0x46232365U, 0x9dc3c35eU,
  0x30181828U, 0x379696a1U, 0x0a05050fU, 0x2f9a9ab5U,
  0x0e070709U, 0x24121236U, 0x1b80809bU, 0xdfe2e23dU,
  0xcdebeb26U, 0x4e272769U, 0x7fb2b2cdU, 0xea75759fU,
  0x1209091bU, 0x1d83839eU, 0x582c2c74U, 0x341a1a2eU,
  0x361b1b2dU, 0xdc6e6eb2U, 0xb45a5aeeU, 0x5ba0a0fbU,
  0xa45252f6U, 0x763b3b4dU, 0xb7d6d661U, 0x7db3b3ceU,
  0x5229297bU, 0xdde3e33eU, 0x5e2f2f71U, 0x13848497U,
  0xa65353f5U, 0xb9d1d168U, 0x00000000U, 0xc1eded2cU,
  0x40202060U, 0xe3fcfc1fU, 0x79b1b1c8U, 0xb65b5bedU,
  0xd46a6abeU, 0x8dcbcb46U, 0x67bebed9U, 0x7239394bU,
  0x944a4adeU, 0x984c4cd4U, 0xb05858e8U, 0x85cfcf4aU,
  0xbbd0d06bU, 0xc5efef2aU, 0x4faaaae5U, 0xedfbfb16U,
  0x864343c5U, 0x9a4d4dd7U, 0x66333355U, 0x11858594U,
  0x8a4545cfU, 0xe9f9f910U, 0x04020206U, 0xfe7f7f81U,
  0xa05050f0U, 0x783c3c44U, 0x259f9fbaU, 0x4ba8a8e3U,
  0xa25151f3U, 0x5da3a3feU, 0x804040c0U, 0x058f8f8aU,
  0x3f9292adU, 0x219d9dbcU, 0x70383848U, 0xf1f5f504U,
  0x63bcbcdfU, 0x77b6b6c1U, 0xafdada75U, 0x42212163U,
  0x20101030U, 0xe5ffff1aU, 0xfdf3f30eU, 0xbfd2d26dU,
  0x81cdcd4cU, 0x180c0c14U, 0x26131335U, 0xc3ecec2fU,
  0xbe5f5fe1U, 0x359797a2U, 0x884444ccU, 0x2e171739U,
  0x93c4c457U, 0x55a7a7f2U, 0xfc7e7e82U, 0x7a3d3d47U,
  0xc86464acU, 0xba5d5de7U, 0x3219192bU, 0xe6737395U,
  0xc06060a0U, 0x19818198U, 0x9e4f4fd1U, 0xa3dcdc7fU,
  0x44222266U, 0x542a2a7eU, 0x3b9090abU, 0x0b888883U,
  0x8c4646caU, 0xc7eeee29U, 0x6bb8b8d3U, 0x2814143cU,
  0xa7dede79U, 0xbc5e5ee2U, 0x160b0b1dU, 0xaddbdb76U,
  0xdbe0e03bU, 0x64323256U, 0x743a3a4eU, 0x140a0a1eU,
  0x924949dbU, 0x0c06060aU, 0x4824246cU, 0xb85c5ce4U,
  0x9fc2c25dU, 0xbdd3d36eU, 0x43acacefU, 0xc46262a6U,
  0x399191a8U, 0x319595a4U, 0xd3e4e437U, 0xf279798bU,
  0xd5e7e732U, 0x8bc8c843U, 0x6e373759U, 0xda6d6db7U,
  0x018d8d8cU, 0xb1d5d564U, 0x9c4e4ed2U, 0x49a9a9e0U,
  0xd86c6cb4U, 0xac5656faU, 0xf3f4f407U, 0xcfeaea25U,
  0xca6565afU, 0xf47a7a8eU, 0x47aeaee9U, 0x10080818U,
  0x6fbabad5U, 0xf0787888U, 0x4a25256fU, 0x5c2e2e72U,
  0x381c1c24U, 0x57a6a6f1U, 0x73b4b4c7U, 0x97c6c651U,
  0xcbe8e823U, 0xa1dddd7cU, 0xe874749cU, 0x3e1f1f21U,
  0x964b4bddU, 0x61bdbddcU, 0x0d8b8b86U, 0x0f8a8a85U,
  0xe0707090U, 0x7c3e3e42U, 0x71b5b5c4U, 0xcc6666aaU,
  0x904848d8U, 0x06030305U, 0xf7f6f601U, 0x1c0e0e12U,
  0xc26161a3U, 0x6a35355fU, 0xae5757f9U, 0x69b9b9d0U,
  0x17868691U, 0x99c1c158U, 0x3a1d1d27U, 0x279e9eb9U,
  0xd9e1e138U, 0xebf8f813U, 0x2b9898b3U, 0x22111133U,
  0xd26969bbU, 0xa9d9d970U, 0x078e8e89U, 0x339494a7U,
  0x2d9b9bb6U, 0x3c1e1e22U, 0x15878792U, 0xc9e9e920U,
  0x87cece49U, 0xaa5555ffU, 0x50282878U, 0xa5dfdf7aU,
  0x038c8c8fU, 0x59a1a1f8U, 0x09898980U, 0x1a0d0d17U,
  0x65bfbfdaU, 0xd7e6e631U, 0x844242c6U, 0xd06868b8U,
  0x824141c3U, 0x299999b0U, 0x5a2d2d77U, 0x1e0f0f11U,
  0x7bb0b0cbU, 0xa85454fcU, 0x6dbbbbd6U, 0x2c16163aU,
};
static const word32 Rijndael_Te1[256] =
{
  0xa5c66363U, 0x84f87c7cU, 0x99ee7777U, 0x8df67b7bU,
  0x0dfff2f2U, 0xbdd66b6bU, 0xb1de6f6fU, 0x5491c5c5U,
  0x50603030U, 0x03020101U, 0xa9ce6767U, 0x7d562b2bU,
  0x19e7fefeU, 0x62b5d7d7U, 0xe64dababU, 0x9aec7676U,
  0x458fcacaU, 0x9d1f8282U, 0x4089c9c9U, 0x87fa7d7dU,
  0x15effafaU, 0xebb25959U, 0xc98e4747U, 0x0bfbf0f0U,
  0xec41adadU, 0x67b3d4d4U, 0xfd5fa2a2U, 0xea45afafU,
  0xbf239c9cU, 0xf753a4a4U, 0x96e47272U, 0x5b9bc0c0U,
  0xc275b7b7U, 0x1ce1fdfdU, 0xae3d9393U, 0x6a4c2626U,
  0x5a6c3636U, 0x417e3f3fU, 0x02f5f7f7U, 0x4f83ccccU,
  0x5c683434U, 0xf451a5a5U, 0x34d1e5e5U, 0x08f9f1f1U,
  0x93e27171U, 0x73abd8d8U, 0x53623131U, 0x3f2a1515U,
  0x0c080404U, 0x5295c7c7U, 0x65462323U, 0x5e9dc3c3U,
  0x28301818U, 0xa1379696U, 0x0f0a0505U, 0xb52f9a9aU,
  0x090e0707U, 0x36241212U, 0x9b1b8080U, 0x3ddfe2e2U,
  0x26cdebebU, 0x694e2727U, 0xcd7fb2b2U, 0x9fea7575U,
  0x1b120909U, 0x9e1d8383U, 0x74582c2cU, 0x2e341a1aU,
  0x2d361b1bU, 0xb2dc6e6eU, 0xeeb45a5aU, 0xfb5ba0a0U,
  0xf6a45252U, 0x4d763b3bU, 0x61b7d6d6U, 0xce7db3b3U,
  0x7b522929U, 0x3edde3e3U, 0x715e2f2fU, 0x97138484U,
  0xf5a65353U, 0x68b9d1d1U, 0x00000000U, 0x2cc1ededU,
  0x60402020U, 0x1fe3fcfcU, 0xc879b1b1U, 0xedb65b5bU,
  0xbed46a6aU, 0x468dcbcbU, 0xd967bebeU, 0x4b723939U,
  0xde944a4aU, 0xd4984c4cU, 0xe8b05858U, 0x4a85cfcfU,
  0x6bbbd0d0U, 0x2ac5efefU, 0xe54faaaaU, 0x16edfbfbU,
  0xc5864343U, 0xd79a4d4dU, 0x55663333U, 0x94118585U,
  0xcf8a4545U, 0x10e9f9f9U, 0x06040202U, 0x81fe7f7fU,
  0xf0a05050U, 0x44783c3cU, 0xba259f9fU, 0xe34ba8a8U,
  0xf3a25151U, 0xfe5da3a3U, 0xc0804040U, 0x8a058f8fU,
  0xad3f9292U, 0xbc219d9dU, 0x48703838U, 0x04f1f5f5U,
  0xdf63bcbcU, 0xc177b6b6U, 0x75afdadaU, 0x63422121U,
  0x30201010U, 0x1ae5ffffU, 0x0efdf3f3U, 0x6dbfd2d2U,
  0x4c81cdcdU, 0x14180c0cU, 0x35261313U, 0x2fc3ececU,
  0xe1be5f5fU, 0xa2359797U, 0xcc884444U, 0x392e1717U,
  0x5793c4c4U, 0xf255a7a7U, 0x82fc7e7eU, 0x477a3d3dU,
  0xacc86464U, 0xe7ba5d5dU, 0x2b321919U, 0x95e67373U,
  0xa0c06060U, 0x98198181U, 0xd19e4f4fU, 0x7fa3dcdcU,
  0x66442222U, 0x7e542a2aU, 0xab3b9090U, 0x830b8888U,
  0xca8c4646U, 0x29c7eeeeU, 0xd36bb8b8U, 0x3c281414U,
  0x79a7dedeU, 0xe2bc5e5eU, 0x1d160b0bU, 0x76addbdbU,
  0x3bdbe0e0U, 0x56643232U, 0x4e743a3aU, 0x1e140a0aU,
  0xdb924949U, 0x0a0c0606U, 0x6c482424U, 0xe4b85c5cU,
  0x5d9fc2c2U, 0x6ebdd3d3U, 0xef43acacU, 0xa6c46262U,
  0xa8399191U, 0xa4319595U, 0x37d3e4e4U, 0x8bf27979U,
  0x32d5e7e7U, 0x438bc8c8U, 0x596e3737U, 0xb7da6d6dU,
  0x8c018d8dU, 0x64b1d5d5U, 0xd29c4e4eU, 0xe049a9a9U,
  0xb4d86c6cU, 0xfaac5656U, 0x07f3f4f4U, 0x25cfeaeaU,
  0xafca6565U, 0x8ef47a7aU, 0xe947aeaeU, 0x18100808U,
  0xd56fbabaU, 0x88f07878U, 0x6f4a2525U, 0x725c2e2eU,
  0x24381c1cU, 0xf157a6a6U, 0xc773b4b4U, 0x5197c6c6U,
  0x23cbe8e8U, 0x7ca1ddddU, 0x9ce87474U, 0x213e1f1fU,
  0xdd964b4bU, 0xdc61bdbdU, 0x860d8b8bU, 0x850f8a8aU,
  0x90e07070U, 0x427c3e3eU, 0xc471b5b5U, 0xaacc6666U,
  0xd8904848U, 0x05060303U, 0x01f7f6f6U, 0x121c0e0eU,
  0xa3c26161U, 0x5f6a3535U, 0xf9ae5757U, 0xd069b9b9U,
  0x91178686U, 0x5899c1c1U, 0x273a1d1dU, 0xb9279e9eU,
  0x38d9e1e1U, 0x13ebf8f8U, 0xb32b9898U, 0x33221111U,
  0xbbd26969U, 0x70a9d9d9U, 0x89078e8eU, 0xa7339494U,
  0xb62d9b9bU, 0x223c1e1eU, 0x92158787U, 0x20c9e9e9U,
  0x4987ceceU, 0xffaa5555U, 0x78502828U, 0x7aa5dfdfU,
  0x8f038c8cU, 0xf859a1a1U, 0x80098989U, 0x171a0d0dU,
  0xda65bfbfU, 0x31d7e6e6U, 0xc6844242U, 0xb8d06868U,
  0xc3824141U, 0xb0299999U, 0x775a2d2dU, 0x111e0f0fU,
  0xcb7bb0b0U, 0xfca85454U, 0xd66dbbbbU, 0x3a2c1616U,
};
static const word32 Rijndael_Te2[256] =
{
  0x63a5c663U, 0x7c84f87cU, 0x7799ee77U, 0x7b8df67bU,
  0xf20dfff2U, 0x6bbdd66bU, 0x6fb1de6fU, 0xc55491c5U,
  0x30506030U, 0x01030201U, 0x67a9ce67U, 0x2b7d562bU,
  0xfe19e7feU, 0xd762b5d7U, 0xabe64dabU, 0x769aec76U,
  0xca458fcaU, 0x829d1f82U, 0xc94089c9U, 0x7d87fa7dU,
  0xfa15effaU, 0x59ebb259U, 0x47c98e47U, 0xf00bfbf0U,
  0xadec41adU, 0xd467b3d4U, 0xa2fd5fa2U, 0xafea45afU,
  0x9cbf239cU, 0xa4f753a4U, 0x7296e472U, 0xc05b9bc0U,
  0xb7c275b7U, 0xfd1ce1fdU, 0x93ae3d93U, 0x266a4c26U,
  0x365a6c36U, 0x3f417e3fU, 0xf702f5f7U, 0xcc4f83ccU,
  0x345c6834U, 0xa5f451a5U, 0xe534d1e5U, 0xf108f9f1U,
  0x7193e271U, 0xd873abd8U, 0x31536231U, 0x153f2a15U,
  0x040c0804U, 0xc75295c7U, 0x23654623U, 0xc35e9dc3U,
  0x18283018U, 0x96a13796U, 0x050f0a05U, 0x9ab52f9aU,
  0x07090e07U, 0x12362412U, 0x809b1b80U, 0xe23ddfe2U,
  0xeb26cdebU, 0x27694e27U, 0xb2cd7fb2U, 0x759fea75U,
  0x091b1209U, 0x839e1d83U, 0x2c74582cU, 0x1a2e341aU,
  0x1b2d361bU, 0x6eb2dc6eU, 0x5aeeb45aU, 0xa0fb5ba0U,
  0x52f6a452U, 0x3b4d763bU, 0xd661b7d6U, 0xb3ce7db3U,
  0x297b5229U, 0xe33edde3U, 0x2f715e2fU, 0x84971384U,
  0x53f5a653U, 0xd168b9d1U, 0x00000000U, 0xed2cc1edU,
  0x20604020U, 0xfc1fe3fcU, 0xb1c879b1U, 0x5bedb65bU,
  0x6abed46aU, 0xcb468dcbU, 0xbed967beU, 0x394b7239U,
  0x4ade944aU, 0x4cd4984cU, 0x58e8b058U, 0xcf4a85cfU,
  0xd06bbbd0U, 0xef2ac5efU, 0xaae54faaU, 0xfb16edfbU,
  0x43c58643U, 0x4dd79a4dU, 0x33556633U, 0x85941185U,
  0x45cf8a45U, 0xf910e9f9U, 0x02060402U, 0x7f81fe7fU,
  0x50f0a050U, 0x3c44783cU, 0x9fba259fU, 0xa8e34ba8U,
  0x51f3a251U, 0xa3fe5da3U, 0x40c08040U, 0x8f8a058fU,
  0x92ad3f92U, 0x9dbc219dU, 0x38487038U, 0xf504f1f5U,
  0xbcdf63bcU, 0xb6c177b6U, 0xda75afdaU, 0x21634221U,
  0x10302010U, 0xff1ae5ffU, 0xf30efdf3U, 0xd26dbfd2U,
  0xcd4c81cdU, 0x0c14180cU, 0x13352613U, 0xec2fc3ecU,
  0x5fe1be5fU, 0x97a23597U, 0x44cc8844U, 0x17392e17U,
  0xc45793c4U, 0xa7f255a7U, 0x7e82fc7eU, 0x3d477a3dU,
  0x64acc864U, 0x5de7ba5dU, 0x192b3219U, 0x7395e673U,
  0x60a0c060U, 0x81981981U, 0x4fd19e4fU, 0xdc7fa3dcU,
  0x22664422U, 0x2a7e542aU, 0x90ab3b90U, 0x88830b88U,
  0x46ca8c46U, 0xee29c7eeU, 0xb8d36bb8U, 0x143c2814U,
  0xde79a7deU, 0x5ee2bc5eU, 0x0b1d160bU, 0xdb76addbU,
  0xe03bdbe0U, 0x32566432U, 0x3a4e743aU, 0x0a1e140aU,
  0x49db9249U, 0x060a0c06U, 0x246c4824U, 0x5ce4b85cU,
  0xc25d9fc2U, 0xd36ebdd3U, 0xacef43acU, 0x62a6c462U,
  0x91a83991U, 0x95a43195U, 0xe437d3e4U, 0x798bf279U,
  0xe732d5e7U, 0xc8438bc8U, 0x37596e37U, 0x6db7da6dU,
  0x8d8c018dU, 0xd564b1d5U, 0x4ed29c4eU, 0xa9e049a9U,
  0x6cb4d86cU, 0x56faac56U, 0xf407f3f4U, 0xea25cfeaU,
  0x65afca65U, 0x7a8ef47aU, 0xaee947aeU, 0x08181008U,
  0xbad56fbaU, 0x7888f078U, 0x256f4a25U, 0x2e725c2eU,
  0x1c24381cU, 0xa6f157a6U, 0xb4c773b4U, 0xc65197c6U,
  0xe823cbe8U, 0xdd7ca1ddU, 0x749ce874U, 0x1f213e1fU,
  0x4bdd964bU, 0xbddc61bdU, 0x8b860d8bU, 0x8a850f8aU,
  0x7090e070U, 0x3e427c3eU, 0xb5c471b5U, 0x66aacc66U,
  0x48d89048U, 0x03050603U, 0xf601f7f6U, 0x0e121c0eU,
  0x61a3c261U, 0x355f6a35U, 0x57f9ae57U, 0xb9d069b9U,
  0x86911786U, 0xc15899c1U, 0x1d273a1dU, 0x9eb9279eU,
  0xe138d9e1U, 0xf813ebf8U, 0x98b32b98U, 0x11332211U,
  0x69bbd269U, 0xd970a9d9U, 0x8e89078eU, 0x94a73394U,
  0x9bb62d9bU, 0x1e223c1eU, 0x87921587U, 0xe920c9e9U,
  0xce4987ceU, 0x55ffaa55U, 0x28785028U, 0xdf7aa5dfU,
  0x8c8f038cU, 0xa1f859a1U, 0x89800989U, 0x0d171a0dU,
  0xbfda65bfU, 0xe631d7e6U, 0x42c68442U, 0x68b8d068U,
  0x41c38241U, 0x99b02999U, 0x2d775a2dU, 0x0f111e0fU,
  0xb0cb7bb0U, 0x54fca854U, 0xbbd66dbbU, 0x163a2c16U,
};

static const word32 Rijndael_Te3[256] =
{
  0x6363a5c6U, 0x7c7c84f8U, 0x777799eeU, 0x7b7b8df6U,
  0xf2f20dffU, 0x6b6bbdd6U, 0x6f6fb1deU, 0xc5c55491U,
  0x30305060U, 0x01010302U, 0x6767a9ceU, 0x2b2b7d56U,
  0xfefe19e7U, 0xd7d762b5U, 0xababe64dU, 0x76769aecU,
  0xcaca458fU, 0x82829d1fU, 0xc9c94089U, 0x7d7d87faU,
  0xfafa15efU, 0x5959ebb2U, 0x4747c98eU, 0xf0f00bfbU,
  0xadadec41U, 0xd4d467b3U, 0xa2a2fd5fU, 0xafafea45U,
  0x9c9cbf23U, 0xa4a4f753U, 0x727296e4U, 0xc0c05b9bU,
  0xb7b7c275U, 0xfdfd1ce1U, 0x9393ae3dU, 0x26266a4cU,
  0x36365a6cU, 0x3f3f417eU, 0xf7f702f5U, 0xcccc4f83U,
  0x34345c68U, 0xa5a5f451U, 0xe5e534d1U, 0xf1f108f9U,
  0x717193e2U, 0xd8d873abU, 0x31315362U, 0x15153f2aU,
  0x04040c08U, 0xc7c75295U, 0x23236546U, 0xc3c35e9dU,
  0x18182830U, 0x9696a137U, 0x05050f0aU, 0x9a9ab52fU,
  0x0707090eU, 0x12123624U, 0x80809b1bU, 0xe2e23ddfU,
  0xebeb26cdU, 0x2727694eU, 0xb2b2cd7fU, 0x75759feaU,
  0x09091b12U, 0x83839e1dU, 0x2c2c7458U, 0x1a1a2e34U,
  0x1b1b2d36U, 0x6e6eb2dcU, 0x5a5aeeb4U, 0xa0a0fb5bU,
  0x5252f6a4U, 0x3b3b4d76U, 0xd6d661b7U, 0xb3b3ce7dU,
  0x29297b52U, 0xe3e33eddU, 0x2f2f715eU, 0x84849713U,
  0x5353f5a6U, 0xd1d168b9U, 0x00000000U, 0xeded2cc1U,
  0x20206040U, 0xfcfc1fe3U, 0xb1b1c879U, 0x5b5bedb6U,
  0x6a6abed4U, 0xcbcb468dU, 0xbebed967U, 0x39394b72U,
  0x4a4ade94U, 0x4c4cd498U, 0x5858e8b0U, 0xcfcf4a85U,
  0xd0d06bbbU, 0xefef2ac5U, 0xaaaae54fU, 0xfbfb16edU,
  0x4343c586U, 0x4d4dd79aU, 0x33335566U, 0x85859411U,
  0x4545cf8aU, 0xf9f910e9U, 0x02020604U, 0x7f7f81feU,
  0x5050f0a0U, 0x3c3c4478U, 0x9f9fba25U, 0xa8a8e34bU,
  0x5151f3a2U, 0xa3a3fe5dU, 0x4040c080U, 0x8f8f8a05U,
  0x9292ad3fU, 0x9d9dbc21U, 0x38384870U, 0xf5f504f1U,
  0xbcbcdf63U, 0xb6b6c177U, 0xdada75afU, 0x21216342U,
  0x10103020U, 0xffff1ae5U, 0xf3f30efdU, 0xd2d26dbfU,
  0xcdcd4c81U, 0x0c0c1418U, 0x13133526U, 0xecec2fc3U,
  0x5f5fe1beU, 0x9797a235U, 0x4444cc88U, 0x1717392eU,
  0xc4c45793U, 0xa7a7f255U, 0x7e7e82fcU, 0x3d3d477aU,
  0x6464acc8U, 0x5d5de7baU, 0x19192b32U, 0x737395e6U,
  0x6060a0c0U, 0x81819819U, 0x4f4fd19eU, 0xdcdc7fa3U,
  0x22226644U, 0x2a2a7e54U, 0x9090ab3bU, 0x8888830bU,
  0x4646ca8cU, 0xeeee29c7U, 0xb8b8d36bU, 0x14143c28U,
  0xdede79a7U, 0x5e5ee2bcU, 0x0b0b1d16U, 0xdbdb76adU,
  0xe0e03bdbU, 0x32325664U, 0x3a3a4e74U, 0x0a0a1e14U,
  0x4949db92U, 0x06060a0cU, 0x24246c48U, 0x5c5ce4b8U,
  0xc2c25d9fU, 0xd3d36ebdU, 0xacacef43U, 0x6262a6c4U,
  0x9191a839U, 0x9595a431U, 0xe4e437d3U, 0x79798bf2U,
  0xe7e732d5U, 0xc8c8438bU, 0x3737596eU, 0x6d6db7daU,
  0x8d8d8c01U, 0xd5d564b1U, 0x4e4ed29cU, 0xa9a9e049U,
  0x6c6cb4d8U, 0x5656faacU, 0xf4f407f3U, 0xeaea25cfU,
  0x6565afcaU, 0x7a7a8ef4U, 0xaeaee947U, 0x08081810U,
  0xbabad56fU, 0x787888f0U, 0x25256f4aU, 0x2e2e725cU,
  0x1c1c2438U, 0xa6a6f157U, 0xb4b4c773U, 0xc6c65197U,
  0xe8e823cbU, 0xdddd7ca1U, 0x74749ce8U, 0x1f1f213eU,
  0x4b4bdd96U, 0xbdbddc61U, 0x8b8b860dU, 0x8a8a850fU,
  0x707090e0U, 0x3e3e427cU, 0xb5b5c471U, 0x6666aaccU,
  0x4848d890U, 0x03030506U, 0xf6f601f7U, 0x0e0e121cU,
  0x6161a3c2U, 0x35355f6aU, 0x5757f9aeU, 0xb9b9d069U,
  0x86869117U, 0xc1c15899U, 0x1d1d273aU, 0x9e9eb927U,
  0xe1e138d9U, 0xf8f813ebU, 0x9898b32bU, 0x11113322U,
  0x6969bbd2U, 0xd9d970a9U, 0x8e8e8907U, 0x9494a733U,
  0x9b9bb62dU, 0x1e1e223cU, 0x87879215U, 0xe9e920c9U,
  0xcece4987U, 0x5555ffaaU, 0x28287850U, 0xdfdf7aa5U,
  0x8c8c8f03U, 0xa1a1f859U, 0x89898009U, 0x0d0d171aU,
  0xbfbfda65U, 0xe6e631d7U, 0x4242c684U, 0x6868b8d0U,
  0x4141c382U, 0x9999b029U, 0x2d2d775aU, 0x0f0f111eU,
  0xb0b0cb7bU, 0x5454fca8U, 0xbbbbd66dU, 0x16163a2cU,
};

static const word32 Rijndael_Te4[256] =
{
  0x63636363U, 0x7c7c7c7cU, 0x77777777U, 0x7b7b7b7bU,
  0xf2f2f2f2U, 0x6b6b6b6bU, 0x6f6f6f6fU, 0xc5c5c5c5U,
  0x30303030U, 0x01010101U, 0x67676767U, 0x2b2b2b2bU,
  0xfefefefeU, 0xd7d7d7d7U, 0xababababU, 0x76767676U,
  0xcacacacaU, 0x82828282U, 0xc9c9c9c9U, 0x7d7d7d7dU,
  0xfafafafaU, 0x59595959U, 0x47474747U, 0xf0f0f0f0U,
  0xadadadadU, 0xd4d4d4d4U, 0xa2a2a2a2U, 0xafafafafU,
  0x9c9c9c9cU, 0xa4a4a4a4U, 0x72727272U, 0xc0c0c0c0U,
  0xb7b7b7b7U, 0xfdfdfdfdU, 0x93939393U, 0x26262626U,
  0x36363636U, 0x3f3f3f3fU, 0xf7f7f7f7U, 0xccccccccU,
  0x34343434U, 0xa5a5a5a5U, 0xe5e5e5e5U, 0xf1f1f1f1U,
  0x71717171U, 0xd8d8d8d8U, 0x31313131U, 0x15151515U,
  0x04040404U, 0xc7c7c7c7U, 0x23232323U, 0xc3c3c3c3U,
  0x18181818U, 0x96969696U, 0x05050505U, 0x9a9a9a9aU,
  0x07070707U, 0x12121212U, 0x80808080U, 0xe2e2e2e2U,
  0xebebebebU, 0x27272727U, 0xb2b2b2b2U, 0x75757575U,
  0x09090909U, 0x83838383U, 0x2c2c2c2cU, 0x1a1a1a1aU,
  0x1b1b1b1bU, 0x6e6e6e6eU, 0x5a5a5a5aU, 0xa0a0a0a0U,
  0x52525252U, 0x3b3b3b3bU, 0xd6d6d6d6U, 0xb3b3b3b3U,
  0x29292929U, 0xe3e3e3e3U, 0x2f2f2f2fU, 0x84848484U,
  0x53535353U, 0xd1d1d1d1U, 0x00000000U, 0xededededU,
  0x20202020U, 0xfcfcfcfcU, 0xb1b1b1b1U, 0x5b5b5b5bU,
  0x6a6a6a6aU, 0xcbcbcbcbU, 0xbebebebeU, 0x39393939U,
  0x4a4a4a4aU, 0x4c4c4c4cU, 0x58585858U, 0xcfcfcfcfU,
  0xd0d0d0d0U, 0xefefefefU, 0xaaaaaaaaU, 0xfbfbfbfbU,
  0x43434343U, 0x4d4d4d4dU, 0x33333333U, 0x85858585U,
  0x45454545U, 0xf9f9f9f9U, 0x02020202U, 0x7f7f7f7fU,
  0x50505050U, 0x3c3c3c3cU, 0x9f9f9f9fU, 0xa8a8a8a8U,
  0x51515151U, 0xa3a3a3a3U, 0x40404040U, 0x8f8f8f8fU,
  0x92929292U, 0x9d9d9d9dU, 0x38383838U, 0xf5f5f5f5U,
  0xbcbcbcbcU, 0xb6b6b6b6U, 0xdadadadaU, 0x21212121U,
  0x10101010U, 0xffffffffU, 0xf3f3f3f3U, 0xd2d2d2d2U,
  0xcdcdcdcdU, 0x0c0c0c0cU, 0x13131313U, 0xececececU,
  0x5f5f5f5fU, 0x97979797U, 0x44444444U, 0x17171717U,
  0xc4c4c4c4U, 0xa7a7a7a7U, 0x7e7e7e7eU, 0x3d3d3d3dU,
  0x64646464U, 0x5d5d5d5dU, 0x19191919U, 0x73737373U,
  0x60606060U, 0x81818181U, 0x4f4f4f4fU, 0xdcdcdcdcU,
  0x22222222U, 0x2a2a2a2aU, 0x90909090U, 0x88888888U,
  0x46464646U, 0xeeeeeeeeU, 0xb8b8b8b8U, 0x14141414U,
  0xdedededeU, 0x5e5e5e5eU, 0x0b0b0b0bU, 0xdbdbdbdbU,
  0xe0e0e0e0U, 0x32323232U, 0x3a3a3a3aU, 0x0a0a0a0aU,
  0x49494949U, 0x06060606U, 0x24242424U, 0x5c5c5c5cU,
  0xc2c2c2c2U, 0xd3d3d3d3U, 0xacacacacU, 0x62626262U,
  0x91919191U, 0x95959595U, 0xe4e4e4e4U, 0x79797979U,
  0xe7e7e7e7U, 0xc8c8c8c8U, 0x37373737U, 0x6d6d6d6dU,
  0x8d8d8d8dU, 0xd5d5d5d5U, 0x4e4e4e4eU, 0xa9a9a9a9U,
  0x6c6c6c6cU, 0x56565656U, 0xf4f4f4f4U, 0xeaeaeaeaU,
  0x65656565U, 0x7a7a7a7aU, 0xaeaeaeaeU, 0x08080808U,
  0xbabababaU, 0x78787878U, 0x25252525U, 0x2e2e2e2eU,
  0x1c1c1c1cU, 0xa6a6a6a6U, 0xb4b4b4b4U, 0xc6c6c6c6U,
  0xe8e8e8e8U, 0xddddddddU, 0x74747474U, 0x1f1f1f1fU,
  0x4b4b4b4bU, 0xbdbdbdbdU, 0x8b8b8b8bU, 0x8a8a8a8aU,
  0x70707070U, 0x3e3e3e3eU, 0xb5b5b5b5U, 0x66666666U,
  0x48484848U, 0x03030303U, 0xf6f6f6f6U, 0x0e0e0e0eU,
  0x61616161U, 0x35353535U, 0x57575757U, 0xb9b9b9b9U,
  0x86868686U, 0xc1c1c1c1U, 0x1d1d1d1dU, 0x9e9e9e9eU,
  0xe1e1e1e1U, 0xf8f8f8f8U, 0x98989898U, 0x11111111U,
  0x69696969U, 0xd9d9d9d9U, 0x8e8e8e8eU, 0x94949494U,
  0x9b9b9b9bU, 0x1e1e1e1eU, 0x87878787U, 0xe9e9e9e9U,
  0xcecececeU, 0x55555555U, 0x28282828U, 0xdfdfdfdfU,
  0x8c8c8c8cU, 0xa1a1a1a1U, 0x89898989U, 0x0d0d0d0dU,
  0xbfbfbfbfU, 0xe6e6e6e6U, 0x42424242U, 0x68686868U,
  0x41414141U, 0x99999999U, 0x2d2d2d2dU, 0x0f0f0f0fU,
  0xb0b0b0b0U, 0x54545454U, 0xbbbbbbbbU, 0x16161616U,
};

static const word32 Rijndael_Td0[256] =
{
  0x51f4a750U, 0x7e416553U, 0x1a17a4c3U, 0x3a275e96U,
  0x3bab6bcbU, 0x1f9d45f1U, 0xacfa58abU, 0x4be30393U,
  0x2030fa55U, 0xad766df6U, 0x88cc7691U, 0xf5024c25U,
  0x4fe5d7fcU, 0xc52acbd7U, 0x26354480U, 0xb562a38fU,
  0xdeb15a49U, 0x25ba1b67U, 0x45ea0e98U, 0x5dfec0e1U,
  0xc32f7502U, 0x814cf012U, 0x8d4697a3U, 0x6bd3f9c6U,
  0x038f5fe7U, 0x15929c95U, 0xbf6d7aebU, 0x955259daU,
  0xd4be832dU, 0x587421d3U, 0x49e06929U, 0x8ec9c844U,
  0x75c2896aU, 0xf48e7978U, 0x99583e6bU, 0x27b971ddU,
  0xbee14fb6U, 0xf088ad17U, 0xc920ac66U, 0x7dce3ab4U,
  0x63df4a18U, 0xe51a3182U, 0x97513360U, 0x62537f45U,
  0xb16477e0U, 0xbb6bae84U, 0xfe81a01cU, 0xf9082b94U,
  0x70486858U, 0x8f45fd19U, 0x94de6c87U, 0x527bf8b7U,
  0xab73d323U, 0x724b02e2U, 0xe31f8f57U, 0x6655ab2aU,
  0xb2eb2807U, 0x2fb5c203U, 0x86c57b9aU, 0xd33708a5U,
  0x302887f2U, 0x23bfa5b2U, 0x02036abaU, 0xed16825cU,
  0x8acf1c2bU, 0xa779b492U, 0xf307f2f0U, 0x4e69e2a1U,
  0x65daf4cdU, 0x0605bed5U, 0xd134621fU, 0xc4a6fe8aU,
  0x342e539dU, 0xa2f355a0U, 0x058ae132U, 0xa4f6eb75U,
  0x0b83ec39U, 0x4060efaaU, 0x5e719f06U, 0xbd6e1051U,
  0x3e218af9U, 0x96dd063dU, 0xdd3e05aeU, 0x4de6bd46U,
  0x91548db5U, 0x71c45d05U, 0x0406d46fU, 0x605015ffU,
  0x1998fb24U, 0xd6bde997U, 0x894043ccU, 0x67d99e77U,
  0xb0e842bdU, 0x07898b88U, 0xe7195b38U, 0x79c8eedbU,
  0xa17c0a47U, 0x7c420fe9U, 0xf8841ec9U, 0x00000000U,
  0x09808683U, 0x322bed48U, 0x1e1170acU, 0x6c5a724eU,
  0xfd0efffbU, 0x0f853856U, 0x3daed51eU, 0x362d3927U,
  0x0a0fd964U, 0x685ca621U, 0x9b5b54d1U, 0x24362e3aU,
  0x0c0a67b1U, 0x9357e70fU, 0xb4ee96d2U, 0x1b9b919eU,
  0x80c0c54fU, 0x61dc20a2U, 0x5a774b69U, 0x1c121a16U,
  0xe293ba0aU, 0xc0a02ae5U, 0x3c22e043U, 0x121b171dU,
  0x0e090d0bU, 0xf28bc7adU, 0x2db6a8b9U, 0x141ea9c8U,
  0x57f11985U, 0xaf75074cU, 0xee99ddbbU, 0xa37f60fdU,
  0xf701269fU, 0x5c72f5bcU, 0x44663bc5U, 0x5bfb7e34U,
  0x8b432976U, 0xcb23c6dcU, 0xb6edfc68U, 0xb8e4f163U,
  0xd731dccaU, 0x42638510U, 0x13972240U, 0x84c61120U,
  0x854a247dU, 0xd2bb3df8U, 0xaef93211U, 0xc729a16dU,
  0x1d9e2f4bU, 0xdcb230f3U, 0x0d8652ecU, 0x77c1e3d0U,
  0x2bb3166cU, 0xa970b999U, 0x119448faU, 0x47e96422U,
  0xa8fc8cc4U, 0xa0f03f1aU, 0x567d2cd8U, 0x223390efU,
  0x87494ec7U, 0xd938d1c1U, 0x8ccaa2feU, 0x98d40b36U,
  0xa6f581cfU, 0xa57ade28U, 0xdab78e26U, 0x3fadbfa4U,
  0x2c3a9de4U, 0x5078920dU, 0x6a5fcc9bU, 0x547e4662U,
  0xf68d13c2U, 0x90d8b8e8U, 0x2e39f75eU, 0x82c3aff5U,
  0x9f5d80beU, 0x69d0937cU, 0x6fd52da9U, 0xcf2512b3U,
  0xc8ac993bU, 0x10187da7U, 0xe89c636eU, 0xdb3bbb7bU,
  0xcd267809U, 0x6e5918f4U, 0xec9ab701U, 0x834f9aa8U,
  0xe6956e65U, 0xaaffe67eU, 0x21bccf08U, 0xef15e8e6U,
  0xbae79bd9U, 0x4a6f36ceU, 0xea9f09d4U, 0x29b07cd6U,
  0x31a4b2afU, 0x2a3f2331U, 0xc6a59430U, 0x35a266c0U,
  0x744ebc37U, 0xfc82caa6U, 0xe090d0b0U, 0x33a7d815U,
  0xf104984aU, 0x41ecdaf7U, 0x7fcd500eU, 0x1791f62fU,
  0x764dd68dU, 0x43efb04dU, 0xccaa4d54U, 0xe49604dfU,
  0x9ed1b5e3U, 0x4c6a881bU, 0xc12c1fb8U, 0x4665517fU,
  0x9d5eea04U, 0x018c355dU, 0xfa877473U, 0xfb0b412eU,
  0xb3671d5aU, 0x92dbd252U, 0xe9105633U, 0x6dd64713U,
  0x9ad7618cU, 0x37a10c7aU, 0x59f8148eU, 0xeb133c89U,
  0xcea927eeU, 0xb761c935U, 0xe11ce5edU, 0x7a47b13cU,
  0x9cd2df59U, 0x55f2733fU, 0x1814ce79U, 0x73c737bfU,
  0x53f7cdeaU, 0x5ffdaa5bU, 0xdf3d6f14U, 0x7844db86U,
  0xcaaff381U, 0xb968c43eU, 0x3824342cU, 0xc2a3405fU,
  0x161dc372U, 0xbce2250cU, 0x283c498bU, 0xff0d9541U,
  0x39a80171U, 0x080cb3deU, 0xd8b4e49cU, 0x6456c190U,
  0x7bcb8461U, 0xd532b670U, 0x486c5c74U, 0xd0b85742U,
};

static const word32 Rijndael_Td1[256] =
{
  0x5051f4a7U, 0x537e4165U, 0xc31a17a4U, 0x963a275eU,
  0xcb3bab6bU, 0xf11f9d45U, 0xabacfa58U, 0x934be303U,
  0x552030faU, 0xf6ad766dU, 0x9188cc76U, 0x25f5024cU,
  0xfc4fe5d7U, 0xd7c52acbU, 0x80263544U, 0x8fb562a3U,
  0x49deb15aU, 0x6725ba1bU, 0x9845ea0eU, 0xe15dfec0U,
  0x02c32f75U, 0x12814cf0U, 0xa38d4697U, 0xc66bd3f9U,
  0xe7038f5fU, 0x9515929cU, 0xebbf6d7aU, 0xda955259U,
  0x2dd4be83U, 0xd3587421U, 0x2949e069U, 0x448ec9c8U,
  0x6a75c289U, 0x78f48e79U, 0x6b99583eU, 0xdd27b971U,
  0xb6bee14fU, 0x17f088adU, 0x66c920acU, 0xb47dce3aU,
  0x1863df4aU, 0x82e51a31U, 0x60975133U, 0x4562537fU,
  0xe0b16477U, 0x84bb6baeU, 0x1cfe81a0U, 0x94f9082bU,
  0x58704868U, 0x198f45fdU, 0x8794de6cU, 0xb7527bf8U,
  0x23ab73d3U, 0xe2724b02U, 0x57e31f8fU, 0x2a6655abU,
  0x07b2eb28U, 0x032fb5c2U, 0x9a86c57bU, 0xa5d33708U,
  0xf2302887U, 0xb223bfa5U, 0xba02036aU, 0x5ced1682U,
  0x2b8acf1cU, 0x92a779b4U, 0xf0f307f2U, 0xa14e69e2U,
  0xcd65daf4U, 0xd50605beU, 0x1fd13462U, 0x8ac4a6feU,
  0x9d342e53U, 0xa0a2f355U, 0x32058ae1U, 0x75a4f6ebU,
  0x390b83ecU, 0xaa4060efU, 0x065e719fU, 0x51bd6e10U,
  0xf93e218aU, 0x3d96dd06U, 0xaedd3e05U, 0x464de6bdU,
  0xb591548dU, 0x0571c45dU, 0x6f0406d4U, 0xff605015U,
  0x241998fbU, 0x97d6bde9U, 0xcc894043U, 0x7767d99eU,
  0xbdb0e842U, 0x8807898bU, 0x38e7195bU, 0xdb79c8eeU,
  0x47a17c0aU, 0xe97c420fU, 0xc9f8841eU, 0x00000000U,
  0x83098086U, 0x48322bedU, 0xac1e1170U, 0x4e6c5a72U,
  0xfbfd0effU, 0x560f8538U, 0x1e3daed5U, 0x27362d39U,
  0x640a0fd9U, 0x21685ca6U, 0xd19b5b54U, 0x3a24362eU,
  0xb10c0a67U, 0x0f9357e7U, 0xd2b4ee96U, 0x9e1b9b91U,
  0x4f80c0c5U, 0xa261dc20U, 0x695a774bU, 0x161c121aU,
  0x0ae293baU, 0xe5c0a02aU, 0x433c22e0U, 0x1d121b17U,
  0x0b0e090dU, 0xadf28bc7U, 0xb92db6a8U, 0xc8141ea9U,
  0x8557f119U, 0x4caf7507U, 0xbbee99ddU, 0xfda37f60U,
  0x9ff70126U, 0xbc5c72f5U, 0xc544663bU, 0x345bfb7eU,
  0x768b4329U, 0xdccb23c6U, 0x68b6edfcU, 0x63b8e4f1U,
  0xcad731dcU, 0x10426385U, 0x40139722U, 0x2084c611U,
  0x7d854a24U, 0xf8d2bb3dU, 0x11aef932U, 0x6dc729a1U,
  0x4b1d9e2fU, 0xf3dcb230U, 0xec0d8652U, 0xd077c1e3U,
  0x6c2bb316U, 0x99a970b9U, 0xfa119448U, 0x2247e964U,
  0xc4a8fc8cU, 0x1aa0f03fU, 0xd8567d2cU, 0xef223390U,
  0xc787494eU, 0xc1d938d1U, 0xfe8ccaa2U, 0x3698d40bU,
  0xcfa6f581U, 0x28a57adeU, 0x26dab78eU, 0xa43fadbfU,
  0xe42c3a9dU, 0x0d507892U, 0x9b6a5fccU, 0x62547e46U,
  0xc2f68d13U, 0xe890d8b8U, 0x5e2e39f7U, 0xf582c3afU,
  0xbe9f5d80U, 0x7c69d093U, 0xa96fd52dU, 0xb3cf2512U,
  0x3bc8ac99U, 0xa710187dU, 0x6ee89c63U, 0x7bdb3bbbU,
  0x09cd2678U, 0xf46e5918U, 0x01ec9ab7U, 0xa8834f9aU,
  0x65e6956eU, 0x7eaaffe6U, 0x0821bccfU, 0xe6ef15e8U,
  0xd9bae79bU, 0xce4a6f36U, 0xd4ea9f09U, 0xd629b07cU,
  0xaf31a4b2U, 0x312a3f23U, 0x30c6a594U, 0xc035a266U,
  0x37744ebcU, 0xa6fc82caU, 0xb0e090d0U, 0x1533a7d8U,
  0x4af10498U, 0xf741ecdaU, 0x0e7fcd50U, 0x2f1791f6U,
  0x8d764dd6U, 0x4d43efb0U, 0x54ccaa4dU, 0xdfe49604U,
  0xe39ed1b5U, 0x1b4c6a88U, 0xb8c12c1fU, 0x7f466551U,
  0x049d5eeaU, 0x5d018c35U, 0x73fa8774U, 0x2efb0b41U,
  0x5ab3671dU, 0x5292dbd2U, 0x33e91056U, 0x136dd647U,
  0x8c9ad761U, 0x7a37a10cU, 0x8e59f814U, 0x89eb133cU,
  0xeecea927U, 0x35b761c9U, 0xede11ce5U, 0x3c7a47b1U,
  0x599cd2dfU, 0x3f55f273U, 0x791814ceU, 0xbf73c737U,
  0xea53f7cdU, 0x5b5ffdaaU, 0x14df3d6fU, 0x867844dbU,
  0x81caaff3U, 0x3eb968c4U, 0x2c382434U, 0x5fc2a340U,
  0x72161dc3U, 0x0cbce225U, 0x8b283c49U, 0x41ff0d95U,
  0x7139a801U, 0xde080cb3U, 0x9cd8b4e4U, 0x906456c1U,
  0x617bcb84U, 0x70d532b6U, 0x74486c5cU, 0x42d0b857U,
};

static const word32 Rijndael_Td2[256] =
{
  0xa75051f4U, 0x65537e41U, 0xa4c31a17U, 0x5e963a27U,
  0x6bcb3babU, 0x45f11f9dU, 0x58abacfaU, 0x03934be3U,
  0xfa552030U, 0x6df6ad76U, 0x769188ccU, 0x4c25f502U,
  0xd7fc4fe5U, 0xcbd7c52aU, 0x44802635U, 0xa38fb562U,
  0x5a49deb1U, 0x1b6725baU, 0x0e9845eaU, 0xc0e15dfeU,
  0x7502c32fU, 0xf012814cU, 0x97a38d46U, 0xf9c66bd3U,
  0x5fe7038fU, 0x9c951592U, 0x7aebbf6dU, 0x59da9552U,
  0x832dd4beU, 0x21d35874U, 0x692949e0U, 0xc8448ec9U,
  0x896a75c2U, 0x7978f48eU, 0x3e6b9958U, 0x71dd27b9U,
  0x4fb6bee1U, 0xad17f088U, 0xac66c920U, 0x3ab47dceU,
  0x4a1863dfU, 0x3182e51aU, 0x33609751U, 0x7f456253U,
  0x77e0b164U, 0xae84bb6bU, 0xa01cfe81U, 0x2b94f908U,
  0x68587048U, 0xfd198f45U, 0x6c8794deU, 0xf8b7527bU,
  0xd323ab73U, 0x02e2724bU, 0x8f57e31fU, 0xab2a6655U,
  0x2807b2ebU, 0xc2032fb5U, 0x7b9a86c5U, 0x08a5d337U,
  0x87f23028U, 0xa5b223bfU, 0x6aba0203U, 0x825ced16U,
  0x1c2b8acfU, 0xb492a779U, 0xf2f0f307U, 0xe2a14e69U,
  0xf4cd65daU, 0xbed50605U, 0x621fd134U, 0xfe8ac4a6U,
  0x539d342eU, 0x55a0a2f3U, 0xe132058aU, 0xeb75a4f6U,
  0xec390b83U, 0xefaa4060U, 0x9f065e71U, 0x1051bd6eU,

  0x8af93e21U, 0x063d96ddU, 0x05aedd3eU, 0xbd464de6U,
  0x8db59154U, 0x5d0571c4U, 0xd46f0406U, 0x15ff6050U,
  0xfb241998U, 0xe997d6bdU, 0x43cc8940U, 0x9e7767d9U,
  0x42bdb0e8U, 0x8b880789U, 0x5b38e719U, 0xeedb79c8U,
  0x0a47a17cU, 0x0fe97c42U, 0x1ec9f884U, 0x00000000U,
  0x86830980U, 0xed48322bU, 0x70ac1e11U, 0x724e6c5aU,
  0xfffbfd0eU, 0x38560f85U, 0xd51e3daeU, 0x3927362dU,
  0xd9640a0fU, 0xa621685cU, 0x54d19b5bU, 0x2e3a2436U,
  0x67b10c0aU, 0xe70f9357U, 0x96d2b4eeU, 0x919e1b9bU,
  0xc54f80c0U, 0x20a261dcU, 0x4b695a77U, 0x1a161c12U,
  0xba0ae293U, 0x2ae5c0a0U, 0xe0433c22U, 0x171d121bU,
  0x0d0b0e09U, 0xc7adf28bU, 0xa8b92db6U, 0xa9c8141eU,
  0x198557f1U, 0x074caf75U, 0xddbbee99U, 0x60fda37fU,
  0x269ff701U, 0xf5bc5c72U, 0x3bc54466U, 0x7e345bfbU,
  0x29768b43U, 0xc6dccb23U, 0xfc68b6edU, 0xf163b8e4U,
  0xdccad731U, 0x85104263U, 0x22401397U, 0x112084c6U,
  0x247d854aU, 0x3df8d2bbU, 0x3211aef9U, 0xa16dc729U,
  0x2f4b1d9eU, 0x30f3dcb2U, 0x52ec0d86U, 0xe3d077c1U,
  0x166c2bb3U, 0xb999a970U, 0x48fa1194U, 0x642247e9U,
  0x8cc4a8fcU, 0x3f1aa0f0U, 0x2cd8567dU, 0x90ef2233U,
  0x4ec78749U, 0xd1c1d938U, 0xa2fe8ccaU, 0x0b3698d4U,
  0x81cfa6f5U, 0xde28a57aU, 0x8e26dab7U, 0xbfa43fadU,
  0x9de42c3aU, 0x920d5078U, 0xcc9b6a5fU, 0x4662547eU,
  0x13c2f68dU, 0xb8e890d8U, 0xf75e2e39U, 0xaff582c3U,
  0x80be9f5dU, 0x937c69d0U, 0x2da96fd5U, 0x12b3cf25U,
  0x993bc8acU, 0x7da71018U, 0x636ee89cU, 0xbb7bdb3bU,
  0x7809cd26U, 0x18f46e59U, 0xb701ec9aU, 0x9aa8834fU,
  0x6e65e695U, 0xe67eaaffU, 0xcf0821bcU, 0xe8e6ef15U,
  0x9bd9bae7U, 0x36ce4a6fU, 0x09d4ea9fU, 0x7cd629b0U,
  0xb2af31a4U, 0x23312a3fU, 0x9430c6a5U, 0x66c035a2U,
  0xbc37744eU, 0xcaa6fc82U, 0xd0b0e090U, 0xd81533a7U,
  0x984af104U, 0xdaf741ecU, 0x500e7fcdU, 0xf62f1791U,
  0xd68d764dU, 0xb04d43efU, 0x4d54ccaaU, 0x04dfe496U,
  0xb5e39ed1U, 0x881b4c6aU, 0x1fb8c12cU, 0x517f4665U,
  0xea049d5eU, 0x355d018cU, 0x7473fa87U, 0x412efb0bU,
  0x1d5ab367U, 0xd25292dbU, 0x5633e910U, 0x47136dd6U,
  0x618c9ad7U, 0x0c7a37a1U, 0x148e59f8U, 0x3c89eb13U,
  0x27eecea9U, 0xc935b761U, 0xe5ede11cU, 0xb13c7a47U,
  0xdf599cd2U, 0x733f55f2U, 0xce791814U, 0x37bf73c7U,
  0xcdea53f7U, 0xaa5b5ffdU, 0x6f14df3dU, 0xdb867844U,
  0xf381caafU, 0xc43eb968U, 0x342c3824U, 0x405fc2a3U,
  0xc372161dU, 0x250cbce2U, 0x498b283cU, 0x9541ff0dU,
  0x017139a8U, 0xb3de080cU, 0xe49cd8b4U, 0xc1906456U,
  0x84617bcbU, 0xb670d532U, 0x5c74486cU, 0x5742d0b8U,
};

static const word32 Rijndael_Td3[256] =
{
  0xf4a75051U, 0x4165537eU, 0x17a4c31aU, 0x275e963aU,
  0xab6bcb3bU, 0x9d45f11fU, 0xfa58abacU, 0xe303934bU,
  0x30fa5520U, 0x766df6adU, 0xcc769188U, 0x024c25f5U,
  0xe5d7fc4fU, 0x2acbd7c5U, 0x35448026U, 0x62a38fb5U,
  0xb15a49deU, 0xba1b6725U, 0xea0e9845U, 0xfec0e15dU,
  0x2f7502c3U, 0x4cf01281U, 0x4697a38dU, 0xd3f9c66bU,
  0x8f5fe703U, 0x929c9515U, 0x6d7aebbfU, 0x5259da95U,
  0xbe832dd4U, 0x7421d358U, 0xe0692949U, 0xc9c8448eU,
  0xc2896a75U, 0x8e7978f4U, 0x583e6b99U, 0xb971dd27U,
  0xe14fb6beU, 0x88ad17f0U, 0x20ac66c9U, 0xce3ab47dU,
  0xdf4a1863U, 0x1a3182e5U, 0x51336097U, 0x537f4562U,
  0x6477e0b1U, 0x6bae84bbU, 0x81a01cfeU, 0x082b94f9U,
  0x48685870U, 0x45fd198fU, 0xde6c8794U, 0x7bf8b752U,
  0x73d323abU, 0x4b02e272U, 0x1f8f57e3U, 0x55ab2a66U,
  0xeb2807b2U, 0xb5c2032fU, 0xc57b9a86U, 0x3708a5d3U,
  0x2887f230U, 0xbfa5b223U, 0x036aba02U, 0x16825cedU,
  0xcf1c2b8aU, 0x79b492a7U, 0x07f2f0f3U, 0x69e2a14eU,
  0xdaf4cd65U, 0x05bed506U, 0x34621fd1U, 0xa6fe8ac4U,
  0x2e539d34U, 0xf355a0a2U, 0x8ae13205U, 0xf6eb75a4U,
  0x83ec390bU, 0x60efaa40U, 0x719f065eU, 0x6e1051bdU,
  0x218af93eU, 0xdd063d96U, 0x3e05aeddU, 0xe6bd464dU,
  0x548db591U, 0xc45d0571U, 0x06d46f04U, 0x5015ff60U,
  0x98fb2419U, 0xbde997d6U, 0x4043cc89U, 0xd99e7767U,
  0xe842bdb0U, 0x898b8807U, 0x195b38e7U, 0xc8eedb79U,
  0x7c0a47a1U, 0x420fe97cU, 0x841ec9f8U, 0x00000000U,
  0x80868309U, 0x2bed4832U, 0x1170ac1eU, 0x5a724e6cU,
  0x0efffbfdU, 0x8538560fU, 0xaed51e3dU, 0x2d392736U,
  0x0fd9640aU, 0x5ca62168U, 0x5b54d19bU, 0x362e3a24U,
  0x0a67b10cU, 0x57e70f93U, 0xee96d2b4U, 0x9b919e1bU,
  0xc0c54f80U, 0xdc20a261U, 0x774b695aU, 0x121a161cU,
  0x93ba0ae2U, 0xa02ae5c0U, 0x22e0433cU, 0x1b171d12U,
  0x090d0b0eU, 0x8bc7adf2U, 0xb6a8b92dU, 0x1ea9c814U,
  0xf1198557U, 0x75074cafU, 0x99ddbbeeU, 0x7f60fda3U,
  0x01269ff7U, 0x72f5bc5cU, 0x663bc544U, 0xfb7e345bU,
  0x4329768bU, 0x23c6dccbU, 0xedfc68b6U, 0xe4f163b8U,
  0x31dccad7U, 0x63851042U, 0x97224013U, 0xc6112084U,
  0x4a247d85U, 0xbb3df8d2U, 0xf93211aeU, 0x29a16dc7U,
  0x9e2f4b1dU, 0xb230f3dcU, 0x8652ec0dU, 0xc1e3d077U,
  0xb3166c2bU, 0x70b999a9U, 0x9448fa11U, 0xe9642247U,
  0xfc8cc4a8U, 0xf03f1aa0U, 0x7d2cd856U, 0x3390ef22U,
  0x494ec787U, 0x38d1c1d9U, 0xcaa2fe8cU, 0xd40b3698U,
  0xf581cfa6U, 0x7ade28a5U, 0xb78e26daU, 0xadbfa43fU,
  0x3a9de42cU, 0x78920d50U, 0x5fcc9b6aU, 0x7e466254U,
  0x8d13c2f6U, 0xd8b8e890U, 0x39f75e2eU, 0xc3aff582U,
  0x5d80be9fU, 0xd0937c69U, 0xd52da96fU, 0x2512b3cfU,
  0xac993bc8U, 0x187da710U, 0x9c636ee8U, 0x3bbb7bdbU,
  0x267809cdU, 0x5918f46eU, 0x9ab701ecU, 0x4f9aa883U,
  0x956e65e6U, 0xffe67eaaU, 0xbccf0821U, 0x15e8e6efU,
  0xe79bd9baU, 0x6f36ce4aU, 0x9f09d4eaU, 0xb07cd629U,
  0xa4b2af31U, 0x3f23312aU, 0xa59430c6U, 0xa266c035U,
  0x4ebc3774U, 0x82caa6fcU, 0x90d0b0e0U, 0xa7d81533U,
  0x04984af1U, 0xecdaf741U, 0xcd500e7fU, 0x91f62f17U,
  0x4dd68d76U, 0xefb04d43U, 0xaa4d54ccU, 0x9604dfe4U,
  0xd1b5e39eU, 0x6a881b4cU, 0x2c1fb8c1U, 0x65517f46U,
  0x5eea049dU, 0x8c355d01U, 0x877473faU, 0x0b412efbU,
  0x671d5ab3U, 0xdbd25292U, 0x105633e9U, 0xd647136dU,
  0xd7618c9aU, 0xa10c7a37U, 0xf8148e59U, 0x133c89ebU,
  0xa927eeceU, 0x61c935b7U, 0x1ce5ede1U, 0x47b13c7aU,
  0xd2df599cU, 0xf2733f55U, 0x14ce7918U, 0xc737bf73U,
  0xf7cdea53U, 0xfdaa5b5fU, 0x3d6f14dfU, 0x44db8678U,
  0xaff381caU, 0x68c43eb9U, 0x24342c38U, 0xa3405fc2U,
  0x1dc37216U, 0xe2250cbcU, 0x3c498b28U, 0x0d9541ffU,
  0xa8017139U, 0x0cb3de08U, 0xb4e49cd8U, 0x56c19064U,
  0xcb84617bU, 0x32b670d5U, 0x6c5c7448U, 0xb85742d0U,
};

static const word32 Rijndael_Td4[256] =
{
  0x52525252U, 0x09090909U, 0x6a6a6a6aU, 0xd5d5d5d5U,
  0x30303030U, 0x36363636U, 0xa5a5a5a5U, 0x38383838U,
  0xbfbfbfbfU, 0x40404040U, 0xa3a3a3a3U, 0x9e9e9e9eU,
  0x81818181U, 0xf3f3f3f3U, 0xd7d7d7d7U, 0xfbfbfbfbU,
  0x7c7c7c7cU, 0xe3e3e3e3U, 0x39393939U, 0x82828282U,
  0x9b9b9b9bU, 0x2f2f2f2fU, 0xffffffffU, 0x87878787U,
  0x34343434U, 0x8e8e8e8eU, 0x43434343U, 0x44444444U,
  0xc4c4c4c4U, 0xdedededeU, 0xe9e9e9e9U, 0xcbcbcbcbU,
  0x54545454U, 0x7b7b7b7bU, 0x94949494U, 0x32323232U,
  0xa6a6a6a6U, 0xc2c2c2c2U, 0x23232323U, 0x3d3d3d3dU,
  0xeeeeeeeeU, 0x4c4c4c4cU, 0x95959595U, 0x0b0b0b0bU,
  0x42424242U, 0xfafafafaU, 0xc3c3c3c3U, 0x4e4e4e4eU,
  0x08080808U, 0x2e2e2e2eU, 0xa1a1a1a1U, 0x66666666U,
  0x28282828U, 0xd9d9d9d9U, 0x24242424U, 0xb2b2b2b2U,
  0x76767676U, 0x5b5b5b5bU, 0xa2a2a2a2U, 0x49494949U,
  0x6d6d6d6dU, 0x8b8b8b8bU, 0xd1d1d1d1U, 0x25252525U,
  0x72727272U, 0xf8f8f8f8U, 0xf6f6f6f6U, 0x64646464U,
  0x86868686U, 0x68686868U, 0x98989898U, 0x16161616U,
  0xd4d4d4d4U, 0xa4a4a4a4U, 0x5c5c5c5cU, 0xccccccccU,
  0x5d5d5d5dU, 0x65656565U, 0xb6b6b6b6U, 0x92929292U,
  0x6c6c6c6cU, 0x70707070U, 0x48484848U, 0x50505050U,
  0xfdfdfdfdU, 0xededededU, 0xb9b9b9b9U, 0xdadadadaU,
  0x5e5e5e5eU, 0x15151515U, 0x46464646U, 0x57575757U,
  0xa7a7a7a7U, 0x8d8d8d8dU, 0x9d9d9d9dU, 0x84848484U,
  0x90909090U, 0xd8d8d8d8U, 0xababababU, 0x00000000U,
  0x8c8c8c8cU, 0xbcbcbcbcU, 0xd3d3d3d3U, 0x0a0a0a0aU,
  0xf7f7f7f7U, 0xe4e4e4e4U, 0x58585858U, 0x05050505U,
  0xb8b8b8b8U, 0xb3b3b3b3U, 0x45454545U, 0x06060606U,
  0xd0d0d0d0U, 0x2c2c2c2cU, 0x1e1e1e1eU, 0x8f8f8f8fU,
  0xcacacacaU, 0x3f3f3f3fU, 0x0f0f0f0fU, 0x02020202U,
  0xc1c1c1c1U, 0xafafafafU, 0xbdbdbdbdU, 0x03030303U,
  0x01010101U, 0x13131313U, 0x8a8a8a8aU, 0x6b6b6b6bU,
  0x3a3a3a3aU, 0x91919191U, 0x11111111U, 0x41414141U,
  0x4f4f4f4fU, 0x67676767U, 0xdcdcdcdcU, 0xeaeaeaeaU,
  0x97979797U, 0xf2f2f2f2U, 0xcfcfcfcfU, 0xcecececeU,
  0xf0f0f0f0U, 0xb4b4b4b4U, 0xe6e6e6e6U, 0x73737373U,
  0x96969696U, 0xacacacacU, 0x74747474U, 0x22222222U,
  0xe7e7e7e7U, 0xadadadadU, 0x35353535U, 0x85858585U,
  0xe2e2e2e2U, 0xf9f9f9f9U, 0x37373737U, 0xe8e8e8e8U,
  0x1c1c1c1cU, 0x75757575U, 0xdfdfdfdfU, 0x6e6e6e6eU,
  0x47474747U, 0xf1f1f1f1U, 0x1a1a1a1aU, 0x71717171U,
  0x1d1d1d1dU, 0x29292929U, 0xc5c5c5c5U, 0x89898989U,
  0x6f6f6f6fU, 0xb7b7b7b7U, 0x62626262U, 0x0e0e0e0eU,
  0xaaaaaaaaU, 0x18181818U, 0xbebebebeU, 0x1b1b1b1bU,
  0xfcfcfcfcU, 0x56565656U, 0x3e3e3e3eU, 0x4b4b4b4bU,
  0xc6c6c6c6U, 0xd2d2d2d2U, 0x79797979U, 0x20202020U,
  0x9a9a9a9aU, 0xdbdbdbdbU, 0xc0c0c0c0U, 0xfefefefeU,
  0x78787878U, 0xcdcdcdcdU, 0x5a5a5a5aU, 0xf4f4f4f4U,
  0x1f1f1f1fU, 0xddddddddU, 0xa8a8a8a8U, 0x33333333U,
  0x88888888U, 0x07070707U, 0xc7c7c7c7U, 0x31313131U,
  0xb1b1b1b1U, 0x12121212U, 0x10101010U, 0x59595959U,
  0x27272727U, 0x80808080U, 0xececececU, 0x5f5f5f5fU,
  0x60606060U, 0x51515151U, 0x7f7f7f7fU, 0xa9a9a9a9U,
  0x19191919U, 0xb5b5b5b5U, 0x4a4a4a4aU, 0x0d0d0d0dU,
  0x2d2d2d2dU, 0xe5e5e5e5U, 0x7a7a7a7aU, 0x9f9f9f9fU,
  0x93939393U, 0xc9c9c9c9U, 0x9c9c9c9cU, 0xefefefefU,
  0xa0a0a0a0U, 0xe0e0e0e0U, 0x3b3b3b3bU, 0x4d4d4d4dU,
  0xaeaeaeaeU, 0x2a2a2a2aU, 0xf5f5f5f5U, 0xb0b0b0b0U,
  0xc8c8c8c8U, 0xebebebebU, 0xbbbbbbbbU, 0x3c3c3c3cU,
  0x83838383U, 0x53535353U, 0x99999999U, 0x61616161U,
  0x17171717U, 0x2b2b2b2bU, 0x04040404U, 0x7e7e7e7eU,
  0xbabababaU, 0x77777777U, 0xd6d6d6d6U, 0x26262626U,
  0xe1e1e1e1U, 0x69696969U, 0x14141414U, 0x63636363U,
  0x55555555U, 0x21212121U, 0x0c0c0c0cU, 0x7d7d7d7dU,
};
//-----------------------
static const unsigned char rc2_PITABLE[256] =
{
        217,120,249,196, 25,221,181,237, 40,233,253,121, 74,160,216,157,
        198,126, 55,131, 43,118, 83,142, 98, 76,100,136, 68,139,251,162,
         23,154, 89,245,135,179, 79, 19, 97, 69,109,141,  9,129,125, 50,
        189,143, 64,235,134,183,123, 11,240,149, 33, 34, 92,107, 78,130,
         84,214,101,147,206, 96,178, 28,115, 86,192, 20,167,140,241,220,
         18,117,202, 31, 59,190,228,209, 66, 61,212, 48,163, 60,182, 38,
        111,191, 14,218, 70,105,  7, 87, 39,242, 29,155,188,148, 67,  3,
        248, 17,199,246,144,239, 62,231,  6,195,213, 47,200,102, 30,215,
          8,232,234,222,128, 82,238,247,132,170,114,172, 53, 77,106, 42,
        150, 26,210,113, 90, 21, 73,116, 75,159,208, 94,  4, 24,164,236,
        194,224, 65,110, 15, 81,203,204, 36,145,175, 80,161,244,112, 57,
        153,124, 58,133, 35,184,180,122,252,  2, 54, 91, 37, 85,151, 49,
         45, 93,250,152,227,138,146,174,  5,223, 41, 16,103,108,186,201,
        211,  0,230,207,225,158,168, 44, 99, 22,  1, 63, 88,226,137,169,
         13, 56, 52, 27,171, 51,255,176,187, 72, 12, 95,185,177,205, 46,
        197,243,219, 71,229,165,156,119, 10,166, 32,104,254,127,193,173
};
//-----------------------

static const byte PKCS_DigestDecoration_MD2[] = { 0x30,0x20,0x30,0x0c,0x06,0x08,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x02,0x05,0x00,0x04,0x10 };
static const byte PKCS_DigestDecoration_MD5[] = { 0x30,0x20,0x30,0x0c,0x06,0x08,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x02,0x05,0x05,0x00,0x04,0x10 };
static const byte PKCS_DigestDecoration_RIPEMD160[] = { 0x30,0x21,0x30,0x09,0x06,0x05,0x2b,0x24,0x03,0x02,0x01,0x05,0x00,0x04,0x14 };
static const byte PKCS_DigestDecoration_Tiger[] = { 0x30,0x29,0x30,0x0D,0x06,0x09,0x2B,0x06,0x01,0x04,0x01,0xDA,0x47,0x0C,0x02,0x05,0x00,0x04,0x18 };
static const byte PKCS_DigestDecoration_SHA256[] = { 0x30,0x31,0x30,0x0d,0x06,0x09,0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x01,0x05,0x00,0x04,0x20 };
static const byte PKCS_DigestDecoration_SHA384[] = { 0x30,0x41,0x30,0x0d,0x06,0x09,0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x02,0x05,0x00,0x04,0x30 };
static const byte PKCS_DigestDecoration_SHA512[] = { 0x30,0x51,0x30,0x0d,0x06,0x09,0x60,0x86,0x48,0x01,0x65,0x03,0x04,0x02,0x03,0x05,0x00,0x04,0x40 };
//--------------------
static const word32 MD5MAC_T[12] =
        { 0xac45ef97,0xcd430f29,0x551b7e45,0x3411801c,
          0x96ce77b1,0x7c8e722e,0x0aab5a5f,0x18be4336,
          0x21b4219d,0x4db987bc,0xbd279da2,0xc3d75bc7 };
//-----------------
static const byte MD2_S[256] =
{
        41, 46, 67, 201, 162, 216, 124, 1, 61, 54, 84, 161, 236, 240, 6,
        19, 98, 167, 5, 243, 192, 199, 115, 140, 152, 147, 43, 217, 188,
        76, 130, 202, 30, 155, 87, 60, 253, 212, 224, 22, 103, 66, 111, 24,
        138, 23, 229, 18, 190, 78, 196, 214, 218, 158, 222, 73, 160, 251,
        245, 142, 187, 47, 238, 122, 169, 104, 121, 145, 21, 178, 7, 63,
        148, 194, 16, 137, 11, 34, 95, 33, 128, 127, 93, 154, 90, 144, 50,
        39, 53, 62, 204, 231, 191, 247, 151, 3, 255, 25, 48, 179, 72, 165,
        181, 209, 215, 94, 146, 42, 172, 86, 170, 198, 79, 184, 56, 210,
        150, 164, 125, 182, 118, 252, 107, 226, 156, 116, 4, 241, 69, 157,
        112, 89, 100, 113, 135, 32, 134, 91, 207, 101, 230, 45, 168, 2, 27,
        96, 37, 173, 174, 176, 185, 246, 28, 70, 97, 105, 52, 64, 126, 15,
        85, 71, 163, 35, 221, 81, 175, 58, 195, 92, 249, 206, 186, 197,
        234, 38, 44, 83, 13, 110, 133, 40, 132, 9, 211, 223, 205, 244, 65,
        129, 77, 82, 106, 220, 55, 200, 108, 193, 171, 250, 36, 225, 123,
        8, 12, 189, 177, 74, 120, 136, 149, 139, 227, 99, 232, 109, 233,
        203, 213, 254, 59, 0, 29, 57, 242, 239, 183, 14, 102, 88, 208, 228,
        166, 119, 114, 248, 235, 117, 75, 10, 49, 68, 80, 180, 143, 237,
        31, 26, 219, 153, 141, 51, 159, 17, 131, 20
};

//-----------------
static const word32 MARS_Sbox[512] =
{
  0x09d0c479, 0x28c8ffe0, 0x84aa6c39, 0x9dad7287,
  0x7dff9be3, 0xd4268361, 0xc96da1d4, 0x7974cc93,
  0x85d0582e, 0x2a4b5705, 0x1ca16a62, 0xc3bd279d,
  0x0f1f25e5, 0x5160372f, 0xc695c1fb, 0x4d7ff1e4,
  0xae5f6bf4, 0x0d72ee46, 0xff23de8a, 0xb1cf8e83,
  0xf14902e2, 0x3e981e42, 0x8bf53eb6, 0x7f4bf8ac,
  0x83631f83, 0x25970205, 0x76afe784, 0x3a7931d4,
  0x4f846450, 0x5c64c3f6, 0x210a5f18, 0xc6986a26,
  0x28f4e826, 0x3a60a81c, 0xd340a664, 0x7ea820c4,
  0x526687c5, 0x7eddd12b, 0x32a11d1d, 0x9c9ef086,
  0x80f6e831, 0xab6f04ad, 0x56fb9b53, 0x8b2e095c,
  0xb68556ae, 0xd2250b0d, 0x294a7721, 0xe21fb253,
  0xae136749, 0xe82aae86, 0x93365104, 0x99404a66,
  0x78a784dc, 0xb69ba84b, 0x04046793, 0x23db5c1e,
  0x46cae1d6, 0x2fe28134, 0x5a223942, 0x1863cd5b,
  0xc190c6e3, 0x07dfb846, 0x6eb88816, 0x2d0dcc4a,
  0xa4ccae59, 0x3798670d, 0xcbfa9493, 0x4f481d45,
  0xeafc8ca8, 0xdb1129d6, 0xb0449e20, 0x0f5407fb,
  0x6167d9a8, 0xd1f45763, 0x4daa96c3, 0x3bec5958,
  0xababa014, 0xb6ccd201, 0x38d6279f, 0x02682215,
  0x8f376cd5, 0x092c237e, 0xbfc56593, 0x32889d2c,
  0x854b3e95, 0x05bb9b43, 0x7dcd5dcd, 0xa02e926c,
  0xfae527e5, 0x36a1c330, 0x3412e1ae, 0xf257f462,
  0x3c4f1d71, 0x30a2e809, 0x68e5f551, 0x9c61ba44,
  0x5ded0ab8, 0x75ce09c8, 0x9654f93e, 0x698c0cca,
  0x243cb3e4, 0x2b062b97, 0x0f3b8d9e, 0x00e050df,
  0xfc5d6166, 0xe35f9288, 0xc079550d, 0x0591aee8,
  0x8e531e74, 0x75fe3578, 0x2f6d829a, 0xf60b21ae,
  0x95e8eb8d, 0x6699486b, 0x901d7d9b, 0xfd6d6e31,
  0x1090acef, 0xe0670dd8, 0xdab2e692, 0xcd6d4365,
  0xe5393514, 0x3af345f0, 0x6241fc4d, 0x460da3a3,
  0x7bcf3729, 0x8bf1d1e0, 0x14aac070, 0x1587ed55,
  0x3afd7d3e, 0xd2f29e01, 0x29a9d1f6, 0xefb10c53,
  0xcf3b870f, 0xb414935c, 0x664465ed, 0x024acac7,
  0x59a744c1, 0x1d2936a7, 0xdc580aa6, 0xcf574ca8,
  0x040a7a10, 0x6cd81807, 0x8a98be4c, 0xaccea063,
  0xc33e92b5, 0xd1e0e03d, 0xb322517e, 0x2092bd13,
  0x386b2c4a, 0x52e8dd58, 0x58656dfb, 0x50820371,
  0x41811896, 0xe337ef7e, 0xd39fb119, 0xc97f0df6,
  0x68fea01b, 0xa150a6e5, 0x55258962, 0xeb6ff41b,
  0xd7c9cd7a, 0xa619cd9e, 0xbcf09576, 0x2672c073,
  0xf003fb3c, 0x4ab7a50b, 0x1484126a, 0x487ba9b1,
  0xa64fc9c6, 0xf6957d49, 0x38b06a75, 0xdd805fcd,
  0x63d094cf, 0xf51c999e, 0x1aa4d343, 0xb8495294,
  0xce9f8e99, 0xbffcd770, 0xc7c275cc, 0x378453a7,
  0x7b21be33, 0x397f41bd, 0x4e94d131, 0x92cc1f98,
  0x5915ea51, 0x99f861b7, 0xc9980a88, 0x1d74fd5f,
  0xb0a495f8, 0x614deed0, 0xb5778eea, 0x5941792d,
  0xfa90c1f8, 0x33f824b4, 0xc4965372, 0x3ff6d550,
  0x4ca5fec0, 0x8630e964, 0x5b3fbbd6, 0x7da26a48,
  0xb203231a, 0x04297514, 0x2d639306, 0x2eb13149,
  0x16a45272, 0x532459a0, 0x8e5f4872, 0xf966c7d9,
  0x07128dc0, 0x0d44db62, 0xafc8d52d, 0x06316131,
  0xd838e7ce, 0x1bc41d00, 0x3a2e8c0f, 0xea83837e,
  0xb984737d, 0x13ba4891, 0xc4f8b949, 0xa6d6acb3,
  0xa215cdce, 0x8359838b, 0x6bd1aa31, 0xf579dd52,
  0x21b93f93, 0xf5176781, 0x187dfdde, 0xe94aeb76,
  0x2b38fd54, 0x431de1da, 0xab394825, 0x9ad3048f,
  0xdfea32aa, 0x659473e3, 0x623f7863, 0xf3346c59,
  0xab3ab685, 0x3346a90b, 0x6b56443e, 0xc6de01f8,
  0x8d421fc0, 0x9b0ed10c, 0x88f1a1e9, 0x54c1f029,
  0x7dead57b, 0x8d7ba426, 0x4cf5178a, 0x551a7cca,
  0x1a9a5f08, 0xfcd651b9, 0x25605182, 0xe11fc6c3,
  0xb6fd9676, 0x337b3027, 0xb7c8eb14, 0x9e5fd030,
  0x6b57e354, 0xad913cf7, 0x7e16688d, 0x58872a69,
  0x2c2fc7df, 0xe389ccc6, 0x30738df1, 0x0824a734,
  0xe1797a8b, 0xa4a8d57b, 0x5b5d193b, 0xc8a8309b,
  0x73f9a978, 0x73398d32, 0x0f59573e, 0xe9df2b03,
  0xe8a5b6c8, 0x848d0704, 0x98df93c2, 0x720a1dc3,
  0x684f259a, 0x943ba848, 0xa6370152, 0x863b5ea3,
  0xd17b978b, 0x6d9b58ef, 0x0a700dd4, 0xa73d36bf,
  0x8e6a0829, 0x8695bc14, 0xe35b3447, 0x933ac568,
  0x8894b022, 0x2f511c27, 0xddfbcc3c, 0x006662b6,
  0x117c83fe, 0x4e12b414, 0xc2bca766, 0x3a2fec10,
  0xf4562420, 0x55792e2a, 0x46f5d857, 0xceda25ce,
  0xc3601d3b, 0x6c00ab46, 0xefac9c28, 0xb3c35047,
  0x611dfee3, 0x257c3207, 0xfdd58482, 0x3b14d84f,
  0x23becb64, 0xa075f3a3, 0x088f8ead, 0x07adf158,
  0x7796943c, 0xfacabf3d, 0xc09730cd, 0xf7679969,
  0xda44e9ed, 0x2c854c12, 0x35935fa3, 0x2f057d9f,
  0x690624f8, 0x1cb0bafd, 0x7b0dbdc6, 0x810f23bb,
  0xfa929a1a, 0x6d969a17, 0x6742979b, 0x74ac7d05,
  0x010e65c4, 0x86a3d963, 0xf907b5a0, 0xd0042bd3,
  0x158d7d03, 0x287a8255, 0xbba8366f, 0x096edc33,
  0x21916a7b, 0x77b56b86, 0x951622f9, 0xa6c5e650,
  0x8cea17d1, 0xcd8c62bc, 0xa3d63433, 0x358a68fd,
  0x0f9b9d3c, 0xd6aa295b, 0xfe33384a, 0xc000738e,
  0xcd67eb2f, 0xe2eb6dc2, 0x97338b02, 0x06c9f246,
  0x419cf1ad, 0x2b83c045, 0x3723f18a, 0xcb5b3089,
  0x160bead7, 0x5d494656, 0x35f8a74b, 0x1e4e6c9e,
  0x000399bd, 0x67466880, 0xb4174831, 0xacf423b2,
  0xca815ab3, 0x5a6395e7, 0x302a67c5, 0x8bdb446b,
  0x108f8fa4, 0x10223eda, 0x92b8b48b, 0x7f38d0ee,
  0xab2701d4, 0x0262d415, 0xaf224a30, 0xb3d88aba,
  0xf8b2c3af, 0xdaf7ef70, 0xcc97d3b7, 0xe9614b6c,
  0x2baebff4, 0x70f687cf, 0x386c9156, 0xce092ee5,
  0x01e87da6, 0x6ce91e6a, 0xbb7bcc84, 0xc7922c20,
  0x9d3b71fd, 0x060e41c6, 0xd7590f15, 0x4e03bb47,
  0x183c198e, 0x63eeb240, 0x2ddbf49a, 0x6d5cba54,
  0x923750af, 0xf9e14236, 0x7838162b, 0x59726c72,
  0x81b66760, 0xbb2926c1, 0x48a0ce0d, 0xa6c0496d,
  0xad43507b, 0x718d496a, 0x9df057af, 0x44b1bde6,
  0x054356dc, 0xde7ced35, 0xd51a138b, 0x62088cc9,
  0x35830311, 0xc96efca2, 0x686f86ec, 0x8e77cb68,
  0x63e1d6b8, 0xc80f9778, 0x79c491fd, 0x1b4c67f2,
  0x72698d7d, 0x5e368c31, 0xf7d95e2e, 0xa1d3493f,
  0xdcd9433e, 0x896f1552, 0x4bc4ca7a, 0xa6d1baf4,
  0xa5a96dcc, 0x0bef8b46, 0xa169fda7, 0x74df40b7,
  0x4e208804, 0x9a756607, 0x038e87c8, 0x20211e44,
  0x8b7ad4bf, 0xc6403f35, 0x1848e36d, 0x80bdb038,
  0x1e62891c, 0x643d2107, 0xbf04d6f8, 0x21092c8c,
  0xf644f389, 0x0778404e, 0x7b78adb8, 0xa2c52d53,
  0x42157abe, 0xa2253e2e, 0x7bf3f4ae, 0x80f594f9,
  0x953194e7, 0x77eb92ed, 0xb3816930, 0xda8d9336,
  0xbf447469, 0xf26d9483, 0xee6faed5, 0x71371235,
  0xde425f73, 0xb4e59f43, 0x7dbe2d4e, 0x2d37b185,
  0x49dc9a63, 0x98c39d98, 0x1301c9a2, 0x389b1bbf,
  0x0c18588d, 0xa421c1ba, 0x7aa3865c, 0x71e08558,
  0x3c5cfcaa, 0x7d239ca4, 0x0297d9dd, 0xd7dc2830,
  0x4b37802b, 0x7428ab54, 0xaeee0347, 0x4b3fbb85,
  0x692f2f08, 0x134e578e, 0x36d9e0bf, 0xae8b5fcf,
  0xedb93ecf, 0x2b27248e, 0x170eb1ef, 0x7dc57fd6,
  0x1e760f16, 0xb1136601, 0x864e1b9b, 0xd7ea7319,
  0x3ab871bd, 0xcfa4d76f, 0xe31bd782, 0x0dbeb469,
  0xabb96061, 0x5370f85d, 0xffb07e37, 0xda30d0fb,
  0xebc977b6, 0x0b98b40f, 0x3a4d0fe6, 0xdf4fc26b,
  0x159cf22a, 0xc298d6e2, 0x2b78ef6a, 0x61a94ac0,
  0xab561187, 0x14eea0f0, 0xdf0d4164, 0x19af70ee
};
//--------------

static const unsigned int HAVAL_wi2[32] = {  5,14,26,18,11,28, 7,16, 0,23,20,22, 1,10, 4, 8,30, 3,21, 9,17,24,29, 6,19,12,15,13, 2,25,31,27 };
static const unsigned int HAVAL_wi3[32] = { 19, 9, 4,20,28,17, 8,22,29,14,25,12,24,30,16,26,31,15, 7, 3, 1, 0,18,27,13, 6,21,10,23,11, 5, 2 };
static const unsigned int HAVAL_wi4[32] = { 24, 4, 0,14, 2, 7,28,23,26, 6,30,20,18,25,19, 3,22,11,31,21, 8,27,12, 9, 1,29, 5,15,17,10,16,13 };
static const unsigned int HAVAL_wi5[32] = { 27, 3,21,26,17,11,20,29,19, 0,12, 7,13, 8,31,10, 5, 9,14,30,18, 6,28,24, 2,23,16,22, 4, 1,25,15 };

static const word32 HAVAL_mc2[32] =
{
  0x452821E6, 0x38D01377, 0xBE5466CF, 0x34E90C6C, 0xC0AC29B7, 0xC97C50DD, 0x3F84D5B5, 0xB5470917,
  0x9216D5D9, 0x8979FB1B, 0xD1310BA6, 0x98DFB5AC, 0x2FFD72DB, 0xD01ADFB7, 0xB8E1AFED, 0x6A267E96,
  0xBA7C9045, 0xF12C7F99, 0x24A19947, 0xB3916CF7, 0x0801F2E2, 0x858EFC16, 0x636920D8, 0x71574E69,
  0xA458FEA3, 0xF4933D7E, 0x0D95748F, 0x728EB658, 0x718BCD58, 0x82154AEE, 0x7B54A41D, 0xC25A59B5
};

static const word32 HAVAL_mc3[32] =
{
  0x9C30D539,0x2AF26013,0xC5D1B023,0x286085F0,0xCA417918,0xB8DB38EF,0x8E79DCB0,0x603A180E,
  0x6C9E0E8B,0xB01E8A3E,0xD71577C1,0xBD314B27,0x78AF2FDA,0x55605C60,0xE65525F3,0xAA55AB94,
  0x57489862,0x63E81440,0x55CA396A,0x2AAB10B6,0xB4CC5C34,0x1141E8CE,0xA15486AF,0x7C72E993,
  0xB3EE1411,0x636FBC2A,0x2BA9C55D,0x741831F6,0xCE5C3E16,0x9B87931E,0xAFD6BA33,0x6C24CF5C
};

static const word32 HAVAL_mc4[32] =
{
  0x7A325381,0x28958677,0x3B8F4898,0x6B4BB9AF,0xC4BFE81B,0x66282193,0x61D809CC,0xFB21A991,
  0x487CAC60,0x5DEC8032,0xEF845D5D,0xE98575B1,0xDC262302,0xEB651B88,0x23893E81,0xD396ACC5,
  0x0F6D6FF3,0x83F44239,0x2E0B4482,0xA4842004,0x69C8F04A,0x9E1F9B5E,0x21C66842,0xF6E96C9A,
  0x670C9C61,0xABD388F0,0x6A51A0D2,0xD8542F68,0x960FA728,0xAB5133A3,0x6EEF0B6C,0x137A3BE4
};

static const word32 HAVAL_mc5[32] =
{
  0xBA3BF050,0x7EFB2A98,0xA1F1651D,0x39AF0176,0x66CA593E,0x82430E88,0x8CEE8619,0x456F9FB4,
  0x7D84A5C3,0x3B8B5EBE,0xE06F75D8,0x85C12073,0x401A449F,0x56C16AA6,0x4ED3AA62,0x363F7706,
  0x1BFEDF72,0x429B023D,0x37D0D724,0xD00A1248,0xDB0FEAD3,0x49F1C09B,0x075372C9,0x80991B7B,
  0x25D479D8,0xF6E8DEF7,0xE3FE501A,0xB6794C3B,0x976CE0BD,0x04C006BA,0xC1A94FB6,0x409F60C4
};

//----------------
static const byte GOST_sBox[8*16] =
{
  4, 10, 9, 2, 13, 8, 0, 14, 6, 11, 1, 12, 7, 15, 5, 3,
  14, 11, 4, 12, 6, 13, 15, 10, 2, 3, 8, 1, 0, 7, 5, 9,
  5, 8, 1, 13, 10, 3, 4, 2, 14, 15, 12, 7, 6, 0, 9, 11,
  7, 13, 10, 1, 0, 8, 9, 15, 14, 4, 6, 12, 11, 2, 5, 3,
  6, 12, 7, 1, 5, 15, 13, 8, 4, 10, 9, 14, 0, 3, 11, 2,
  4, 11, 10, 0, 7, 2, 1, 13, 3, 6, 8, 5, 9, 12, 15, 14,
  13, 11, 4, 1, 3, 15, 5, 9, 0, 10, 14, 7, 6, 8, 2, 12,
  1, 15, 13, 0, 5, 7, 10, 4, 9, 2, 3, 14, 6, 11, 8, 12
};

//------------
static const word32 RawDES_Spbox[8*64] =
{

0x01010400,0x00000000,0x00010000,0x01010404, 0x01010004,0x00010404,0x00000004,0x00010000,
0x00000400,0x01010400,0x01010404,0x00000400, 0x01000404,0x01010004,0x01000000,0x00000004,
0x00000404,0x01000400,0x01000400,0x00010400, 0x00010400,0x01010000,0x01010000,0x01000404,
0x00010004,0x01000004,0x01000004,0x00010004, 0x00000000,0x00000404,0x00010404,0x01000000,
0x00010000,0x01010404,0x00000004,0x01010000, 0x01010400,0x01000000,0x01000000,0x00000400,
0x01010004,0x00010000,0x00010400,0x01000004, 0x00000400,0x00000004,0x01000404,0x00010404,
0x01010404,0x00010004,0x01010000,0x01000404, 0x01000004,0x00000404,0x00010404,0x01010400,
0x00000404,0x01000400,0x01000400,0x00000000, 0x00010004,0x00010400,0x00000000,0x01010004,

0x80108020,0x80008000,0x00008000,0x00108020, 0x00100000,0x00000020,0x80100020,0x80008020,
0x80000020,0x80108020,0x80108000,0x80000000, 0x80008000,0x00100000,0x00000020,0x80100020,
0x00108000,0x00100020,0x80008020,0x00000000, 0x80000000,0x00008000,0x00108020,0x80100000,
0x00100020,0x80000020,0x00000000,0x00108000, 0x00008020,0x80108000,0x80100000,0x00008020,
0x00000000,0x00108020,0x80100020,0x00100000, 0x80008020,0x80100000,0x80108000,0x00008000,
0x80100000,0x80008000,0x00000020,0x80108020, 0x00108020,0x00000020,0x00008000,0x80000000,
0x00008020,0x80108000,0x00100000,0x80000020, 0x00100020,0x80008020,0x80000020,0x00100020,
0x00108000,0x00000000,0x80008000,0x00008020, 0x80000000,0x80100020,0x80108020,0x00108000,

0x00000208,0x08020200,0x00000000,0x08020008, 0x08000200,0x00000000,0x00020208,0x08000200,
0x00020008,0x08000008,0x08000008,0x00020000, 0x08020208,0x00020008,0x08020000,0x00000208,
0x08000000,0x00000008,0x08020200,0x00000200, 0x00020200,0x08020000,0x08020008,0x00020208,
0x08000208,0x00020200,0x00020000,0x08000208, 0x00000008,0x08020208,0x00000200,0x08000000,
0x08020200,0x08000000,0x00020008,0x00000208, 0x00020000,0x08020200,0x08000200,0x00000000,
0x00000200,0x00020008,0x08020208,0x08000200, 0x08000008,0x00000200,0x00000000,0x08020008,
0x08000208,0x00020000,0x08000000,0x08020208, 0x00000008,0x00020208,0x00020200,0x08000008,
0x08020000,0x08000208,0x00000208,0x08020000, 0x00020208,0x00000008,0x08020008,0x00020200,

0x00802001,0x00002081,0x00002081,0x00000080, 0x00802080,0x00800081,0x00800001,0x00002001,
0x00000000,0x00802000,0x00802000,0x00802081, 0x00000081,0x00000000,0x00800080,0x00800001,
0x00000001,0x00002000,0x00800000,0x00802001, 0x00000080,0x00800000,0x00002001,0x00002080,
0x00800081,0x00000001,0x00002080,0x00800080, 0x00002000,0x00802080,0x00802081,0x00000081,
0x00800080,0x00800001,0x00802000,0x00802081, 0x00000081,0x00000000,0x00000000,0x00802000,
0x00002080,0x00800080,0x00800081,0x00000001, 0x00802001,0x00002081,0x00002081,0x00000080,
0x00802081,0x00000081,0x00000001,0x00002000, 0x00800001,0x00002001,0x00802080,0x00800081,
0x00002001,0x00002080,0x00800000,0x00802001, 0x00000080,0x00800000,0x00002000,0x00802080,

0x00000100,0x02080100,0x02080000,0x42000100, 0x00080000,0x00000100,0x40000000,0x02080000,
0x40080100,0x00080000,0x02000100,0x40080100, 0x42000100,0x42080000,0x00080100,0x40000000,
0x02000000,0x40080000,0x40080000,0x00000000, 0x40000100,0x42080100,0x42080100,0x02000100,
0x42080000,0x40000100,0x00000000,0x42000000, 0x02080100,0x02000000,0x42000000,0x00080100,
0x00080000,0x42000100,0x00000100,0x02000000, 0x40000000,0x02080000,0x42000100,0x40080100,
0x02000100,0x40000000,0x42080000,0x02080100, 0x40080100,0x00000100,0x02000000,0x42080000,
0x42080100,0x00080100,0x42000000,0x42080100, 0x02080000,0x00000000,0x40080000,0x42000000,
0x00080100,0x02000100,0x40000100,0x00080000, 0x00000000,0x40080000,0x02080100,0x40000100,

0x20000010,0x20400000,0x00004000,0x20404010, 0x20400000,0x00000010,0x20404010,0x00400000,
0x20004000,0x00404010,0x00400000,0x20000010, 0x00400010,0x20004000,0x20000000,0x00004010,
0x00000000,0x00400010,0x20004010,0x00004000, 0x00404000,0x20004010,0x00000010,0x20400010,
0x20400010,0x00000000,0x00404010,0x20404000, 0x00004010,0x00404000,0x20404000,0x20000000,
0x20004000,0x00000010,0x20400010,0x00404000, 0x20404010,0x00400000,0x00004010,0x20000010,
0x00400000,0x20004000,0x20000000,0x00004010, 0x20000010,0x20404010,0x00404000,0x20400000,
0x00404010,0x20404000,0x00000000,0x20400010, 0x00000010,0x00004000,0x20400000,0x00404010,
0x00004000,0x00400010,0x20004010,0x00000000, 0x20404000,0x20000000,0x00400010,0x20004010,

0x00200000,0x04200002,0x04000802,0x00000000, 0x00000800,0x04000802,0x00200802,0x04200800,
0x04200802,0x00200000,0x00000000,0x04000002, 0x00000002,0x04000000,0x04200002,0x00000802,
0x04000800,0x00200802,0x00200002,0x04000800, 0x04000002,0x04200000,0x04200800,0x00200002,
0x04200000,0x00000800,0x00000802,0x04200802, 0x00200800,0x00000002,0x04000000,0x00200800,
0x04000000,0x00200800,0x00200000,0x04000802, 0x04000802,0x04200002,0x04200002,0x00000002,
0x00200002,0x04000000,0x04000800,0x00200000, 0x04200800,0x00000802,0x00200802,0x04200800,
0x00000802,0x04000002,0x04200802,0x04200000, 0x00200800,0x00000000,0x00000002,0x04200802,
0x00000000,0x00200802,0x04200000,0x00000800, 0x04000002,0x04000800,0x00000800,0x00200002,

0x10001040,0x00001000,0x00040000,0x10041040, 0x10000000,0x10001040,0x00000040,0x10000000,
0x00040040,0x10040000,0x10041040,0x00041000, 0x10041000,0x00041040,0x00001000,0x00000040,
0x10040000,0x10000040,0x10001000,0x00001040, 0x00041000,0x00040040,0x10040040,0x10041000,
0x00001040,0x00000000,0x00000000,0x10040040, 0x10000040,0x10001000,0x00041040,0x00040000,
0x00041040,0x00040000,0x10041000,0x00001000, 0x00000040,0x10040040,0x00001000,0x00041040,
0x10001000,0x00000040,0x10000040,0x10040000, 0x10040040,0x10000000,0x00040000,0x10001040,
0x00000000,0x10041040,0x00040040,0x10000040, 0x10040000,0x10001000,0x10001040,0x00000000,
0x10041040,0x00041000,0x00041000,0x00001040, 0x00001040,0x00040040,0x10000000,0x10041000
};
//------------------
static const byte DES_ip[] =
{
           58, 50, 42, 34, 26, 18, 10,  2,
           60, 52, 44, 36, 28, 20, 12,  4,
           62, 54, 46, 38, 30, 22, 14,  6,
           64, 56, 48, 40, 32, 24, 16,  8,
           57, 49, 41, 33, 25, 17,  9,  1,
           59, 51, 43, 35, 27, 19, 11,  3,
           61, 53, 45, 37, 29, 21, 13,  5,
           63, 55, 47, 39, 31, 23, 15,  7
};

/* final permutation IP^-1 */
static const byte DES_fp[] =
{
           40,  8, 48, 16, 56, 24, 64, 32,
           39,  7, 47, 15, 55, 23, 63, 31,
           38,  6, 46, 14, 54, 22, 62, 30,
           37,  5, 45, 13, 53, 21, 61, 29,
           36,  4, 44, 12, 52, 20, 60, 28,
           35,  3, 43, 11, 51, 19, 59, 27,
           34,  2, 42, 10, 50, 18, 58, 26,
           33,  1, 41,  9, 49, 17, 57, 25
};
/* expansion operation matrix */
static const byte DES_ei[] =
{
           32,  1,  2,  3,  4,  5,
            4,  5,  6,  7,  8,  9,
            8,  9, 10, 11, 12, 13,
           12, 13, 14, 15, 16, 17,
           16, 17, 18, 19, 20, 21,
           20, 21, 22, 23, 24, 25,
           24, 25, 26, 27, 28, 29,
           28, 29, 30, 31, 32,  1
};
/* The (in)famous S-boxes */
static const byte DES_sbox[8*64] =
{
  /* S1 */
  14,  4, 13,  1,  2, 15, 11,  8,  3, 10,  6, 12,  5,  9,  0,  7,
       0, 15,  7,  4, 14,  2, 13,  1, 10,  6, 12, 11,  9,  5,  3,  8,
       4,  1, 14,  8, 13,  6,  2, 11, 15, 12,  9,  7,  3, 10,  5,  0,
  15, 12,  8,  2,  4,  9,  1,  7,  5, 11,  3, 14, 10,  0,  6, 13,

  /* S2 */
  15,  1,  8, 14,  6, 11,  3,  4,  9,  7,  2, 13, 12,  0,  5, 10,
       3, 13,  4,  7, 15,  2,  8, 14, 12,  0,  1, 10,  6,  9, 11,  5,
       0, 14,  7, 11, 10,  4, 13,  1,  5,  8, 12,  6,  9,  3,  2, 15,
  13,  8, 10,  1,  3, 15,  4,  2, 11,  6,  7, 12,  0,  5, 14,  9,

  /* S3 */
  10,  0,  9, 14,  6,  3, 15,  5,  1, 13, 12,  7, 11,  4,  2,  8,
  13,  7,  0,  9,  3,  4,  6, 10,  2,  8,  5, 14, 12, 11, 15,  1,
  13,  6,  4,  9,  8, 15,  3,  0, 11,  1,  2, 12,  5, 10, 14,  7,
       1, 10, 13,  0,  6,  9,  8,  7,  4, 15, 14,  3, 11,  5,  2, 12,

  /* S4 */
       7, 13, 14,  3,  0,  6,  9, 10,  1,  2,  8,  5, 11, 12,  4, 15,
  13,  8, 11,  5,  6, 15,  0,  3,  4,  7,  2, 12,  1, 10, 14,  9,
  10,  6,  9,  0, 12, 11,  7, 13, 15,  1,  3, 14,  5,  2,  8,  4,
       3, 15,  0,  6, 10,  1, 13,  8,  9,  4,  5, 11, 12,  7,  2, 14,

  /* S5 */
       2, 12,  4,  1,  7, 10, 11,  6,  8,  5,  3, 15, 13,  0, 14,  9,
  14, 11,  2, 12,  4,  7, 13,  1,  5,  0, 15, 10,  3,  9,  8,  6,
       4,  2,  1, 11, 10, 13,  7,  8, 15,  9, 12,  5,  6,  3,  0, 14,
  11,  8, 12,  7,  1, 14,  2, 13,  6, 15,  0,  9, 10,  4,  5,  3,

  /* S6 */
  12,  1, 10, 15,  9,  2,  6,  8,  0, 13,  3,  4, 14,  7,  5, 11,
  10, 15,  4,  2,  7, 12,  9,  5,  6,  1, 13, 14,  0, 11,  3,  8,
       9, 14, 15,  5,  2,  8, 12,  3,  7,  0,  4, 10,  1, 13, 11,  6,
       4,  3,  2, 12,  9,  5, 15, 10, 11, 14,  1,  7,  6,  0,  8, 13,

  /* S7 */
       4, 11,  2, 14, 15,  0,  8, 13,  3, 12,  9,  7,  5, 10,  6,  1,
  13,  0, 11,  7,  4,  9,  1, 10, 14,  3,  5, 12,  2, 15,  8,  6,
       1,  4, 11, 13, 12,  3,  7, 14, 10, 15,  6,  8,  0,  5,  9,  2,
       6, 11, 13,  8,  1,  4, 10,  7,  9,  5,  0, 15, 14,  2,  3, 12,

  /* S8 */
  13,  2,  8,  4,  6, 15, 11,  1, 10,  9,  3, 14,  5,  0, 12,  7,
       1, 15, 13,  8, 10,  3,  7,  4, 12,  5,  6, 11,  0, 14,  9,  2,
       7, 11,  4,  1,  9, 12, 14,  2,  0,  6, 10, 13, 15,  3,  5,  8,
       2,  1, 14,  7,  4, 10,  8, 13, 15, 12,  9,  0,  3,  5,  6, 11
};

/* 32-bit permutation function P used on the output of the S-boxes */
static const byte DES_p32i[] =
{
  16,  7, 20, 21,
  29, 12, 28, 17,
       1, 15, 23, 26,
       5, 18, 31, 10,
       2,  8, 24, 14,
  32, 27,  3,  9,
  19, 13, 30,  6,
  22, 11,  4, 25
};

/* permuted choice table (key) */
static const byte DES_pc1[] =
{
  57, 49, 41, 33, 25, 17,  9,
       1, 58, 50, 42, 34, 26, 18,
  10,  2, 59, 51, 43, 35, 27,
  19, 11,  3, 60, 52, 44, 36,

  63, 55, 47, 39, 31, 23, 15,
       7, 62, 54, 46, 38, 30, 22,
  14,  6, 61, 53, 45, 37, 29,
  21, 13,  5, 28, 20, 12,  4
};

/* permuted choice key (table) */
static const byte DES_pc2[] =
{
  14, 17, 11, 24,  1,  5,
   3, 28, 15,  6, 21, 10,
  23, 19, 12,  4, 26,  8,
  16,  7, 27, 20, 13,  2,
  41, 52, 31, 37, 47, 55,
  30, 40, 51, 45, 33, 48,
  44, 49, 39, 56, 34, 53,
  46, 42, 50, 36, 29, 32
};
//-----------------
static const word32 CRC32_m_tab[] =
{
#ifdef IS_LITTLE_ENDIAN
        0x00000000L, 0x77073096L, 0xee0e612cL, 0x990951baL, 0x076dc419L,
        0x706af48fL, 0xe963a535L, 0x9e6495a3L, 0x0edb8832L, 0x79dcb8a4L,
        0xe0d5e91eL, 0x97d2d988L, 0x09b64c2bL, 0x7eb17cbdL, 0xe7b82d07L,
        0x90bf1d91L, 0x1db71064L, 0x6ab020f2L, 0xf3b97148L, 0x84be41deL,
        0x1adad47dL, 0x6ddde4ebL, 0xf4d4b551L, 0x83d385c7L, 0x136c9856L,
        0x646ba8c0L, 0xfd62f97aL, 0x8a65c9ecL, 0x14015c4fL, 0x63066cd9L,
        0xfa0f3d63L, 0x8d080df5L, 0x3b6e20c8L, 0x4c69105eL, 0xd56041e4L,
        0xa2677172L, 0x3c03e4d1L, 0x4b04d447L, 0xd20d85fdL, 0xa50ab56bL,
        0x35b5a8faL, 0x42b2986cL, 0xdbbbc9d6L, 0xacbcf940L, 0x32d86ce3L,
        0x45df5c75L, 0xdcd60dcfL, 0xabd13d59L, 0x26d930acL, 0x51de003aL,
        0xc8d75180L, 0xbfd06116L, 0x21b4f4b5L, 0x56b3c423L, 0xcfba9599L,
        0xb8bda50fL, 0x2802b89eL, 0x5f058808L, 0xc60cd9b2L, 0xb10be924L,
        0x2f6f7c87L, 0x58684c11L, 0xc1611dabL, 0xb6662d3dL, 0x76dc4190L,
        0x01db7106L, 0x98d220bcL, 0xefd5102aL, 0x71b18589L, 0x06b6b51fL,
        0x9fbfe4a5L, 0xe8b8d433L, 0x7807c9a2L, 0x0f00f934L, 0x9609a88eL,
        0xe10e9818L, 0x7f6a0dbbL, 0x086d3d2dL, 0x91646c97L, 0xe6635c01L,
        0x6b6b51f4L, 0x1c6c6162L, 0x856530d8L, 0xf262004eL, 0x6c0695edL,
        0x1b01a57bL, 0x8208f4c1L, 0xf50fc457L, 0x65b0d9c6L, 0x12b7e950L,
        0x8bbeb8eaL, 0xfcb9887cL, 0x62dd1ddfL, 0x15da2d49L, 0x8cd37cf3L,
        0xfbd44c65L, 0x4db26158L, 0x3ab551ceL, 0xa3bc0074L, 0xd4bb30e2L,
        0x4adfa541L, 0x3dd895d7L, 0xa4d1c46dL, 0xd3d6f4fbL, 0x4369e96aL,
        0x346ed9fcL, 0xad678846L, 0xda60b8d0L, 0x44042d73L, 0x33031de5L,
        0xaa0a4c5fL, 0xdd0d7cc9L, 0x5005713cL, 0x270241aaL, 0xbe0b1010L,
        0xc90c2086L, 0x5768b525L, 0x206f85b3L, 0xb966d409L, 0xce61e49fL,
        0x5edef90eL, 0x29d9c998L, 0xb0d09822L, 0xc7d7a8b4L, 0x59b33d17L,
        0x2eb40d81L, 0xb7bd5c3bL, 0xc0ba6cadL, 0xedb88320L, 0x9abfb3b6L,
        0x03b6e20cL, 0x74b1d29aL, 0xead54739L, 0x9dd277afL, 0x04db2615L,
        0x73dc1683L, 0xe3630b12L, 0x94643b84L, 0x0d6d6a3eL, 0x7a6a5aa8L,
        0xe40ecf0bL, 0x9309ff9dL, 0x0a00ae27L, 0x7d079eb1L, 0xf00f9344L,
        0x8708a3d2L, 0x1e01f268L, 0x6906c2feL, 0xf762575dL, 0x806567cbL,
        0x196c3671L, 0x6e6b06e7L, 0xfed41b76L, 0x89d32be0L, 0x10da7a5aL,
        0x67dd4accL, 0xf9b9df6fL, 0x8ebeeff9L, 0x17b7be43L, 0x60b08ed5L,
        0xd6d6a3e8L, 0xa1d1937eL, 0x38d8c2c4L, 0x4fdff252L, 0xd1bb67f1L,
        0xa6bc5767L, 0x3fb506ddL, 0x48b2364bL, 0xd80d2bdaL, 0xaf0a1b4cL,
        0x36034af6L, 0x41047a60L, 0xdf60efc3L, 0xa867df55L, 0x316e8eefL,
        0x4669be79L, 0xcb61b38cL, 0xbc66831aL, 0x256fd2a0L, 0x5268e236L,
        0xcc0c7795L, 0xbb0b4703L, 0x220216b9L, 0x5505262fL, 0xc5ba3bbeL,
        0xb2bd0b28L, 0x2bb45a92L, 0x5cb36a04L, 0xc2d7ffa7L, 0xb5d0cf31L,
        0x2cd99e8bL, 0x5bdeae1dL, 0x9b64c2b0L, 0xec63f226L, 0x756aa39cL,
        0x026d930aL, 0x9c0906a9L, 0xeb0e363fL, 0x72076785L, 0x05005713L,
        0x95bf4a82L, 0xe2b87a14L, 0x7bb12baeL, 0x0cb61b38L, 0x92d28e9bL,
        0xe5d5be0dL, 0x7cdcefb7L, 0x0bdbdf21L, 0x86d3d2d4L, 0xf1d4e242L,
        0x68ddb3f8L, 0x1fda836eL, 0x81be16cdL, 0xf6b9265bL, 0x6fb077e1L,
        0x18b74777L, 0x88085ae6L, 0xff0f6a70L, 0x66063bcaL, 0x11010b5cL,
        0x8f659effL, 0xf862ae69L, 0x616bffd3L, 0x166ccf45L, 0xa00ae278L,
        0xd70dd2eeL, 0x4e048354L, 0x3903b3c2L, 0xa7672661L, 0xd06016f7L,
        0x4969474dL, 0x3e6e77dbL, 0xaed16a4aL, 0xd9d65adcL, 0x40df0b66L,
        0x37d83bf0L, 0xa9bcae53L, 0xdebb9ec5L, 0x47b2cf7fL, 0x30b5ffe9L,
        0xbdbdf21cL, 0xcabac28aL, 0x53b39330L, 0x24b4a3a6L, 0xbad03605L,
        0xcdd70693L, 0x54de5729L, 0x23d967bfL, 0xb3667a2eL, 0xc4614ab8L,
        0x5d681b02L, 0x2a6f2b94L, 0xb40bbe37L, 0xc30c8ea1L, 0x5a05df1bL,
        0x2d02ef8dL
#else
        0x00000000L, 0x96300777L, 0x2c610eeeL, 0xba510999L, 0x19c46d07L,
        0x8ff46a70L, 0x35a563e9L, 0xa395649eL, 0x3288db0eL, 0xa4b8dc79L,
        0x1ee9d5e0L, 0x88d9d297L, 0x2b4cb609L, 0xbd7cb17eL, 0x072db8e7L,
        0x911dbf90L, 0x6410b71dL, 0xf220b06aL, 0x4871b9f3L, 0xde41be84L,
        0x7dd4da1aL, 0xebe4dd6dL, 0x51b5d4f4L, 0xc785d383L, 0x56986c13L,
        0xc0a86b64L, 0x7af962fdL, 0xecc9658aL, 0x4f5c0114L, 0xd96c0663L,
        0x633d0ffaL, 0xf50d088dL, 0xc8206e3bL, 0x5e10694cL, 0xe44160d5L,
        0x727167a2L, 0xd1e4033cL, 0x47d4044bL, 0xfd850dd2L, 0x6bb50aa5L,
        0xfaa8b535L, 0x6c98b242L, 0xd6c9bbdbL, 0x40f9bcacL, 0xe36cd832L,
        0x755cdf45L, 0xcf0dd6dcL, 0x593dd1abL, 0xac30d926L, 0x3a00de51L,
        0x8051d7c8L, 0x1661d0bfL, 0xb5f4b421L, 0x23c4b356L, 0x9995bacfL,
        0x0fa5bdb8L, 0x9eb80228L, 0x0888055fL, 0xb2d90cc6L, 0x24e90bb1L,
        0x877c6f2fL, 0x114c6858L, 0xab1d61c1L, 0x3d2d66b6L, 0x9041dc76L,
        0x0671db01L, 0xbc20d298L, 0x2a10d5efL, 0x8985b171L, 0x1fb5b606L,
        0xa5e4bf9fL, 0x33d4b8e8L, 0xa2c90778L, 0x34f9000fL, 0x8ea80996L,
        0x18980ee1L, 0xbb0d6a7fL, 0x2d3d6d08L, 0x976c6491L, 0x015c63e6L,
        0xf4516b6bL, 0x62616c1cL, 0xd8306585L, 0x4e0062f2L, 0xed95066cL,
        0x7ba5011bL, 0xc1f40882L, 0x57c40ff5L, 0xc6d9b065L, 0x50e9b712L,
        0xeab8be8bL, 0x7c88b9fcL, 0xdf1ddd62L, 0x492dda15L, 0xf37cd38cL,
        0x654cd4fbL, 0x5861b24dL, 0xce51b53aL, 0x7400bca3L, 0xe230bbd4L,
        0x41a5df4aL, 0xd795d83dL, 0x6dc4d1a4L, 0xfbf4d6d3L, 0x6ae96943L,
        0xfcd96e34L, 0x468867adL, 0xd0b860daL, 0x732d0444L, 0xe51d0333L,
        0x5f4c0aaaL, 0xc97c0dddL, 0x3c710550L, 0xaa410227L, 0x10100bbeL,
        0x86200cc9L, 0x25b56857L, 0xb3856f20L, 0x09d466b9L, 0x9fe461ceL,
        0x0ef9de5eL, 0x98c9d929L, 0x2298d0b0L, 0xb4a8d7c7L, 0x173db359L,
        0x810db42eL, 0x3b5cbdb7L, 0xad6cbac0L, 0x2083b8edL, 0xb6b3bf9aL,
        0x0ce2b603L, 0x9ad2b174L, 0x3947d5eaL, 0xaf77d29dL, 0x1526db04L,
        0x8316dc73L, 0x120b63e3L, 0x843b6494L, 0x3e6a6d0dL, 0xa85a6a7aL,
        0x0bcf0ee4L, 0x9dff0993L, 0x27ae000aL, 0xb19e077dL, 0x44930ff0L,
        0xd2a30887L, 0x68f2011eL, 0xfec20669L, 0x5d5762f7L, 0xcb676580L,
        0x71366c19L, 0xe7066b6eL, 0x761bd4feL, 0xe02bd389L, 0x5a7ada10L,
        0xcc4add67L, 0x6fdfb9f9L, 0xf9efbe8eL, 0x43beb717L, 0xd58eb060L,
        0xe8a3d6d6L, 0x7e93d1a1L, 0xc4c2d838L, 0x52f2df4fL, 0xf167bbd1L,
        0x6757bca6L, 0xdd06b53fL, 0x4b36b248L, 0xda2b0dd8L, 0x4c1b0aafL,
        0xf64a0336L, 0x607a0441L, 0xc3ef60dfL, 0x55df67a8L, 0xef8e6e31L,
        0x79be6946L, 0x8cb361cbL, 0x1a8366bcL, 0xa0d26f25L, 0x36e26852L,
        0x95770cccL, 0x03470bbbL, 0xb9160222L, 0x2f260555L, 0xbe3bbac5L,
        0x280bbdb2L, 0x925ab42bL, 0x046ab35cL, 0xa7ffd7c2L, 0x31cfd0b5L,
        0x8b9ed92cL, 0x1daede5bL, 0xb0c2649bL, 0x26f263ecL, 0x9ca36a75L,
        0x0a936d02L, 0xa906099cL, 0x3f360eebL, 0x85670772L, 0x13570005L,
        0x824abf95L, 0x147ab8e2L, 0xae2bb17bL, 0x381bb60cL, 0x9b8ed292L,
        0x0dbed5e5L, 0xb7efdc7cL, 0x21dfdb0bL, 0xd4d2d386L, 0x42e2d4f1L,
        0xf8b3dd68L, 0x6e83da1fL, 0xcd16be81L, 0x5b26b9f6L, 0xe177b06fL,
        0x7747b718L, 0xe65a0888L, 0x706a0fffL, 0xca3b0666L, 0x5c0b0111L,
        0xff9e658fL, 0x69ae62f8L, 0xd3ff6b61L, 0x45cf6c16L, 0x78e20aa0L,
        0xeed20dd7L, 0x5483044eL, 0xc2b30339L, 0x612667a7L, 0xf71660d0L,
        0x4d476949L, 0xdb776e3eL, 0x4a6ad1aeL, 0xdc5ad6d9L, 0x660bdf40L,
        0xf03bd837L, 0x53aebca9L, 0xc59ebbdeL, 0x7fcfb247L, 0xe9ffb530L,
        0x1cf2bdbdL, 0x8ac2bacaL, 0x3093b353L, 0xa6a3b424L, 0x0536d0baL,
        0x9306d7cdL, 0x2957de54L, 0xbf67d923L, 0x2e7a66b3L, 0xb84a61c4L,
        0x021b685dL, 0x942b6f2aL, 0x37be0bb4L, 0xa18e0cc3L, 0x1bdf055aL,
        0x8def022dL
#endif
};

//-----------------

static const word32 CAST_S[8*256] =
{
  0x30FB40D4UL, 0x9FA0FF0BUL, 0x6BECCD2FUL, 0x3F258C7AUL,
  0x1E213F2FUL, 0x9C004DD3UL, 0x6003E540UL, 0xCF9FC949UL,
  0xBFD4AF27UL, 0x88BBBDB5UL, 0xE2034090UL, 0x98D09675UL,
  0x6E63A0E0UL, 0x15C361D2UL, 0xC2E7661DUL, 0x22D4FF8EUL,
  0x28683B6FUL, 0xC07FD059UL, 0xFF2379C8UL, 0x775F50E2UL,
  0x43C340D3UL, 0xDF2F8656UL, 0x887CA41AUL, 0xA2D2BD2DUL,
  0xA1C9E0D6UL, 0x346C4819UL, 0x61B76D87UL, 0x22540F2FUL,
  0x2ABE32E1UL, 0xAA54166BUL, 0x22568E3AUL, 0xA2D341D0UL,
  0x66DB40C8UL, 0xA784392FUL, 0x004DFF2FUL, 0x2DB9D2DEUL,
  0x97943FACUL, 0x4A97C1D8UL, 0x527644B7UL, 0xB5F437A7UL,
  0xB82CBAEFUL, 0xD751D159UL, 0x6FF7F0EDUL, 0x5A097A1FUL,
  0x827B68D0UL, 0x90ECF52EUL, 0x22B0C054UL, 0xBC8E5935UL,
  0x4B6D2F7FUL, 0x50BB64A2UL, 0xD2664910UL, 0xBEE5812DUL,
  0xB7332290UL, 0xE93B159FUL, 0xB48EE411UL, 0x4BFF345DUL,
  0xFD45C240UL, 0xAD31973FUL, 0xC4F6D02EUL, 0x55FC8165UL,
  0xD5B1CAADUL, 0xA1AC2DAEUL, 0xA2D4B76DUL, 0xC19B0C50UL,
  0x882240F2UL, 0x0C6E4F38UL, 0xA4E4BFD7UL, 0x4F5BA272UL,
  0x564C1D2FUL, 0xC59C5319UL, 0xB949E354UL, 0xB04669FEUL,
  0xB1B6AB8AUL, 0xC71358DDUL, 0x6385C545UL, 0x110F935DUL,
  0x57538AD5UL, 0x6A390493UL, 0xE63D37E0UL, 0x2A54F6B3UL,
  0x3A787D5FUL, 0x6276A0B5UL, 0x19A6FCDFUL, 0x7A42206AUL,
  0x29F9D4D5UL, 0xF61B1891UL, 0xBB72275EUL, 0xAA508167UL,
  0x38901091UL, 0xC6B505EBUL, 0x84C7CB8CUL, 0x2AD75A0FUL,
  0x874A1427UL, 0xA2D1936BUL, 0x2AD286AFUL, 0xAA56D291UL,
  0xD7894360UL, 0x425C750DUL, 0x93B39E26UL, 0x187184C9UL,
  0x6C00B32DUL, 0x73E2BB14UL, 0xA0BEBC3CUL, 0x54623779UL,
  0x64459EABUL, 0x3F328B82UL, 0x7718CF82UL, 0x59A2CEA6UL,
  0x04EE002EUL, 0x89FE78E6UL, 0x3FAB0950UL, 0x325FF6C2UL,
  0x81383F05UL, 0x6963C5C8UL, 0x76CB5AD6UL, 0xD49974C9UL,
  0xCA180DCFUL, 0x380782D5UL, 0xC7FA5CF6UL, 0x8AC31511UL,
  0x35E79E13UL, 0x47DA91D0UL, 0xF40F9086UL, 0xA7E2419EUL,
  0x31366241UL, 0x051EF495UL, 0xAA573B04UL, 0x4A805D8DUL,
  0x548300D0UL, 0x00322A3CUL, 0xBF64CDDFUL, 0xBA57A68EUL,
  0x75C6372BUL, 0x50AFD341UL, 0xA7C13275UL, 0x915A0BF5UL,
  0x6B54BFABUL, 0x2B0B1426UL, 0xAB4CC9D7UL, 0x449CCD82UL,
  0xF7FBF265UL, 0xAB85C5F3UL, 0x1B55DB94UL, 0xAAD4E324UL,
  0xCFA4BD3FUL, 0x2DEAA3E2UL, 0x9E204D02UL, 0xC8BD25ACUL,
  0xEADF55B3UL, 0xD5BD9E98UL, 0xE31231B2UL, 0x2AD5AD6CUL,
  0x954329DEUL, 0xADBE4528UL, 0xD8710F69UL, 0xAA51C90FUL,
  0xAA786BF6UL, 0x22513F1EUL, 0xAA51A79BUL, 0x2AD344CCUL,
  0x7B5A41F0UL, 0xD37CFBADUL, 0x1B069505UL, 0x41ECE491UL,
  0xB4C332E6UL, 0x032268D4UL, 0xC9600ACCUL, 0xCE387E6DUL,
  0xBF6BB16CUL, 0x6A70FB78UL, 0x0D03D9C9UL, 0xD4DF39DEUL,
  0xE01063DAUL, 0x4736F464UL, 0x5AD328D8UL, 0xB347CC96UL,
  0x75BB0FC3UL, 0x98511BFBUL, 0x4FFBCC35UL, 0xB58BCF6AUL,
  0xE11F0ABCUL, 0xBFC5FE4AUL, 0xA70AEC10UL, 0xAC39570AUL,
  0x3F04442FUL, 0x6188B153UL, 0xE0397A2EUL, 0x5727CB79UL,
  0x9CEB418FUL, 0x1CACD68DUL, 0x2AD37C96UL, 0x0175CB9DUL,
  0xC69DFF09UL, 0xC75B65F0UL, 0xD9DB40D8UL, 0xEC0E7779UL,
  0x4744EAD4UL, 0xB11C3274UL, 0xDD24CB9EUL, 0x7E1C54BDUL,
  0xF01144F9UL, 0xD2240EB1UL, 0x9675B3FDUL, 0xA3AC3755UL,
  0xD47C27AFUL, 0x51C85F4DUL, 0x56907596UL, 0xA5BB15E6UL,
  0x580304F0UL, 0xCA042CF1UL, 0x011A37EAUL, 0x8DBFAADBUL,
  0x35BA3E4AUL, 0x3526FFA0UL, 0xC37B4D09UL, 0xBC306ED9UL,
  0x98A52666UL, 0x5648F725UL, 0xFF5E569DUL, 0x0CED63D0UL,
  0x7C63B2CFUL, 0x700B45E1UL, 0xD5EA50F1UL, 0x85A92872UL,
  0xAF1FBDA7UL, 0xD4234870UL, 0xA7870BF3UL, 0x2D3B4D79UL,
  0x42E04198UL, 0x0CD0EDE7UL, 0x26470DB8UL, 0xF881814CUL,
  0x474D6AD7UL, 0x7C0C5E5CUL, 0xD1231959UL, 0x381B7298UL,
  0xF5D2F4DBUL, 0xAB838653UL, 0x6E2F1E23UL, 0x83719C9EUL,
  0xBD91E046UL, 0x9A56456EUL, 0xDC39200CUL, 0x20C8C571UL,
  0x962BDA1CUL, 0xE1E696FFUL, 0xB141AB08UL, 0x7CCA89B9UL,
  0x1A69E783UL, 0x02CC4843UL, 0xA2F7C579UL, 0x429EF47DUL,
  0x427B169CUL, 0x5AC9F049UL, 0xDD8F0F00UL, 0x5C8165BFUL
,


  0x1F201094UL, 0xEF0BA75BUL, 0x69E3CF7EUL, 0x393F4380UL,
  0xFE61CF7AUL, 0xEEC5207AUL, 0x55889C94UL, 0x72FC0651UL,
  0xADA7EF79UL, 0x4E1D7235UL, 0xD55A63CEUL, 0xDE0436BAUL,
  0x99C430EFUL, 0x5F0C0794UL, 0x18DCDB7DUL, 0xA1D6EFF3UL,
  0xA0B52F7BUL, 0x59E83605UL, 0xEE15B094UL, 0xE9FFD909UL,
  0xDC440086UL, 0xEF944459UL, 0xBA83CCB3UL, 0xE0C3CDFBUL,
  0xD1DA4181UL, 0x3B092AB1UL, 0xF997F1C1UL, 0xA5E6CF7BUL,
  0x01420DDBUL, 0xE4E7EF5BUL, 0x25A1FF41UL, 0xE180F806UL,
  0x1FC41080UL, 0x179BEE7AUL, 0xD37AC6A9UL, 0xFE5830A4UL,
  0x98DE8B7FUL, 0x77E83F4EUL, 0x79929269UL, 0x24FA9F7BUL,
  0xE113C85BUL, 0xACC40083UL, 0xD7503525UL, 0xF7EA615FUL,
  0x62143154UL, 0x0D554B63UL, 0x5D681121UL, 0xC866C359UL,
  0x3D63CF73UL, 0xCEE234C0UL, 0xD4D87E87UL, 0x5C672B21UL,
  0x071F6181UL, 0x39F7627FUL, 0x361E3084UL, 0xE4EB573BUL,
  0x602F64A4UL, 0xD63ACD9CUL, 0x1BBC4635UL, 0x9E81032DUL,
  0x2701F50CUL, 0x99847AB4UL, 0xA0E3DF79UL, 0xBA6CF38CUL,
  0x10843094UL, 0x2537A95EUL, 0xF46F6FFEUL, 0xA1FF3B1FUL,
  0x208CFB6AUL, 0x8F458C74UL, 0xD9E0A227UL, 0x4EC73A34UL,
  0xFC884F69UL, 0x3E4DE8DFUL, 0xEF0E0088UL, 0x3559648DUL,
  0x8A45388CUL, 0x1D804366UL, 0x721D9BFDUL, 0xA58684BBUL,
  0xE8256333UL, 0x844E8212UL, 0x128D8098UL, 0xFED33FB4UL,
  0xCE280AE1UL, 0x27E19BA5UL, 0xD5A6C252UL, 0xE49754BDUL,
  0xC5D655DDUL, 0xEB667064UL, 0x77840B4DUL, 0xA1B6A801UL,
  0x84DB26A9UL, 0xE0B56714UL, 0x21F043B7UL, 0xE5D05860UL,
  0x54F03084UL, 0x066FF472UL, 0xA31AA153UL, 0xDADC4755UL,
  0xB5625DBFUL, 0x68561BE6UL, 0x83CA6B94UL, 0x2D6ED23BUL,
  0xECCF01DBUL, 0xA6D3D0BAUL, 0xB6803D5CUL, 0xAF77A709UL,
  0x33B4A34CUL, 0x397BC8D6UL, 0x5EE22B95UL, 0x5F0E5304UL,
  0x81ED6F61UL, 0x20E74364UL, 0xB45E1378UL, 0xDE18639BUL,
  0x881CA122UL, 0xB96726D1UL, 0x8049A7E8UL, 0x22B7DA7BUL,
  0x5E552D25UL, 0x5272D237UL, 0x79D2951CUL, 0xC60D894CUL,
  0x488CB402UL, 0x1BA4FE5BUL, 0xA4B09F6BUL, 0x1CA815CFUL,
  0xA20C3005UL, 0x8871DF63UL, 0xB9DE2FCBUL, 0x0CC6C9E9UL,
  0x0BEEFF53UL, 0xE3214517UL, 0xB4542835UL, 0x9F63293CUL,
  0xEE41E729UL, 0x6E1D2D7CUL, 0x50045286UL, 0x1E6685F3UL,
  0xF33401C6UL, 0x30A22C95UL, 0x31A70850UL, 0x60930F13UL,
  0x73F98417UL, 0xA1269859UL, 0xEC645C44UL, 0x52C877A9UL,
  0xCDFF33A6UL, 0xA02B1741UL, 0x7CBAD9A2UL, 0x2180036FUL,
  0x50D99C08UL, 0xCB3F4861UL, 0xC26BD765UL, 0x64A3F6ABUL,
  0x80342676UL, 0x25A75E7BUL, 0xE4E6D1FCUL, 0x20C710E6UL,
  0xCDF0B680UL, 0x17844D3BUL, 0x31EEF84DUL, 0x7E0824E4UL,
  0x2CCB49EBUL, 0x846A3BAEUL, 0x8FF77888UL, 0xEE5D60F6UL,
  0x7AF75673UL, 0x2FDD5CDBUL, 0xA11631C1UL, 0x30F66F43UL,
  0xB3FAEC54UL, 0x157FD7FAUL, 0xEF8579CCUL, 0xD152DE58UL,
  0xDB2FFD5EUL, 0x8F32CE19UL, 0x306AF97AUL, 0x02F03EF8UL,
  0x99319AD5UL, 0xC242FA0FUL, 0xA7E3EBB0UL, 0xC68E4906UL,
  0xB8DA230CUL, 0x80823028UL, 0xDCDEF3C8UL, 0xD35FB171UL,
  0x088A1BC8UL, 0xBEC0C560UL, 0x61A3C9E8UL, 0xBCA8F54DUL,
  0xC72FEFFAUL, 0x22822E99UL, 0x82C570B4UL, 0xD8D94E89UL,
  0x8B1C34BCUL, 0x301E16E6UL, 0x273BE979UL, 0xB0FFEAA6UL,
  0x61D9B8C6UL, 0x00B24869UL, 0xB7FFCE3FUL, 0x08DC283BUL,
  0x43DAF65AUL, 0xF7E19798UL, 0x7619B72FUL, 0x8F1C9BA4UL,
  0xDC8637A0UL, 0x16A7D3B1UL, 0x9FC393B7UL, 0xA7136EEBUL,
  0xC6BCC63EUL, 0x1A513742UL, 0xEF6828BCUL, 0x520365D6UL,
  0x2D6A77ABUL, 0x3527ED4BUL, 0x821FD216UL, 0x095C6E2EUL,
  0xDB92F2FBUL, 0x5EEA29CBUL, 0x145892F5UL, 0x91584F7FUL,
  0x5483697BUL, 0x2667A8CCUL, 0x85196048UL, 0x8C4BACEAUL,
  0x833860D4UL, 0x0D23E0F9UL, 0x6C387E8AUL, 0x0AE6D249UL,
  0xB284600CUL, 0xD835731DUL, 0xDCB1C647UL, 0xAC4C56EAUL,
  0x3EBD81B3UL, 0x230EABB0UL, 0x6438BC87UL, 0xF0B5B1FAUL,
  0x8F5EA2B3UL, 0xFC184642UL, 0x0A036B7AUL, 0x4FB089BDUL,
  0x649DA589UL, 0xA345415EUL, 0x5C038323UL, 0x3E5D3BB9UL,
  0x43D79572UL, 0x7E6DD07CUL, 0x06DFDF1EUL, 0x6C6CC4EFUL,
  0x7160A539UL, 0x73BFBE70UL, 0x83877605UL, 0x4523ECF1UL
,


  0x8DEFC240UL, 0x25FA5D9FUL, 0xEB903DBFUL, 0xE810C907UL,
  0x47607FFFUL, 0x369FE44BUL, 0x8C1FC644UL, 0xAECECA90UL,
  0xBEB1F9BFUL, 0xEEFBCAEAUL, 0xE8CF1950UL, 0x51DF07AEUL,
  0x920E8806UL, 0xF0AD0548UL, 0xE13C8D83UL, 0x927010D5UL,
  0x11107D9FUL, 0x07647DB9UL, 0xB2E3E4D4UL, 0x3D4F285EUL,
  0xB9AFA820UL, 0xFADE82E0UL, 0xA067268BUL, 0x8272792EUL,
  0x553FB2C0UL, 0x489AE22BUL, 0xD4EF9794UL, 0x125E3FBCUL,
  0x21FFFCEEUL, 0x825B1BFDUL, 0x9255C5EDUL, 0x1257A240UL,
  0x4E1A8302UL, 0xBAE07FFFUL, 0x528246E7UL, 0x8E57140EUL,
  0x3373F7BFUL, 0x8C9F8188UL, 0xA6FC4EE8UL, 0xC982B5A5UL,
  0xA8C01DB7UL, 0x579FC264UL, 0x67094F31UL, 0xF2BD3F5FUL,
  0x40FFF7C1UL, 0x1FB78DFCUL, 0x8E6BD2C1UL, 0x437BE59BUL,
  0x99B03DBFUL, 0xB5DBC64BUL, 0x638DC0E6UL, 0x55819D99UL,
  0xA197C81CUL, 0x4A012D6EUL, 0xC5884A28UL, 0xCCC36F71UL,
  0xB843C213UL, 0x6C0743F1UL, 0x8309893CUL, 0x0FEDDD5FUL,
  0x2F7FE850UL, 0xD7C07F7EUL, 0x02507FBFUL, 0x5AFB9A04UL,
  0xA747D2D0UL, 0x1651192EUL, 0xAF70BF3EUL, 0x58C31380UL,
  0x5F98302EUL, 0x727CC3C4UL, 0x0A0FB402UL, 0x0F7FEF82UL,
  0x8C96FDADUL, 0x5D2C2AAEUL, 0x8EE99A49UL, 0x50DA88B8UL,
  0x8427F4A0UL, 0x1EAC5790UL, 0x796FB449UL, 0x8252DC15UL,
  0xEFBD7D9BUL, 0xA672597DUL, 0xADA840D8UL, 0x45F54504UL,
  0xFA5D7403UL, 0xE83EC305UL, 0x4F91751AUL, 0x925669C2UL,
  0x23EFE941UL, 0xA903F12EUL, 0x60270DF2UL, 0x0276E4B6UL,
  0x94FD6574UL, 0x927985B2UL, 0x8276DBCBUL, 0x02778176UL,
  0xF8AF918DUL, 0x4E48F79EUL, 0x8F616DDFUL, 0xE29D840EUL,
  0x842F7D83UL, 0x340CE5C8UL, 0x96BBB682UL, 0x93B4B148UL,
  0xEF303CABUL, 0x984FAF28UL, 0x779FAF9BUL, 0x92DC560DUL,
  0x224D1E20UL, 0x8437AA88UL, 0x7D29DC96UL, 0x2756D3DCUL,
  0x8B907CEEUL, 0xB51FD240UL, 0xE7C07CE3UL, 0xE566B4A1UL,
  0xC3E9615EUL, 0x3CF8209DUL, 0x6094D1E3UL, 0xCD9CA341UL,
  0x5C76460EUL, 0x00EA983BUL, 0xD4D67881UL, 0xFD47572CUL,
  0xF76CEDD9UL, 0xBDA8229CUL, 0x127DADAAUL, 0x438A074EUL,
  0x1F97C090UL, 0x081BDB8AUL, 0x93A07EBEUL, 0xB938CA15UL,
  0x97B03CFFUL, 0x3DC2C0F8UL, 0x8D1AB2ECUL, 0x64380E51UL,
  0x68CC7BFBUL, 0xD90F2788UL, 0x12490181UL, 0x5DE5FFD4UL,
  0xDD7EF86AUL, 0x76A2E214UL, 0xB9A40368UL, 0x925D958FUL,
  0x4B39FFFAUL, 0xBA39AEE9UL, 0xA4FFD30BUL, 0xFAF7933BUL,
  0x6D498623UL, 0x193CBCFAUL, 0x27627545UL, 0x825CF47AUL,
  0x61BD8BA0UL, 0xD11E42D1UL, 0xCEAD04F4UL, 0x127EA392UL,
  0x10428DB7UL, 0x8272A972UL, 0x9270C4A8UL, 0x127DE50BUL,
  0x285BA1C8UL, 0x3C62F44FUL, 0x35C0EAA5UL, 0xE805D231UL,
  0x428929FBUL, 0xB4FCDF82UL, 0x4FB66A53UL, 0x0E7DC15BUL,
  0x1F081FABUL, 0x108618AEUL, 0xFCFD086DUL, 0xF9FF2889UL,
  0x694BCC11UL, 0x236A5CAEUL, 0x12DECA4DUL, 0x2C3F8CC5UL,
  0xD2D02DFEUL, 0xF8EF5896UL, 0xE4CF52DAUL, 0x95155B67UL,
  0x494A488CUL, 0xB9B6A80CUL, 0x5C8F82BCUL, 0x89D36B45UL,
  0x3A609437UL, 0xEC00C9A9UL, 0x44715253UL, 0x0A874B49UL,
  0xD773BC40UL, 0x7C34671CUL, 0x02717EF6UL, 0x4FEB5536UL,
  0xA2D02FFFUL, 0xD2BF60C4UL, 0xD43F03C0UL, 0x50B4EF6DUL,
  0x07478CD1UL, 0x006E1888UL, 0xA2E53F55UL, 0xB9E6D4BCUL,
  0xA2048016UL, 0x97573833UL, 0xD7207D67UL, 0xDE0F8F3DUL,
  0x72F87B33UL, 0xABCC4F33UL, 0x7688C55DUL, 0x7B00A6B0UL,
  0x947B0001UL, 0x570075D2UL, 0xF9BB88F8UL, 0x8942019EUL,
  0x4264A5FFUL, 0x856302E0UL, 0x72DBD92BUL, 0xEE971B69UL,
  0x6EA22FDEUL, 0x5F08AE2BUL, 0xAF7A616DUL, 0xE5C98767UL,
  0xCF1FEBD2UL, 0x61EFC8C2UL, 0xF1AC2571UL, 0xCC8239C2UL,
  0x67214CB8UL, 0xB1E583D1UL, 0xB7DC3E62UL, 0x7F10BDCEUL,
  0xF90A5C38UL, 0x0FF0443DUL, 0x606E6DC6UL, 0x60543A49UL,
  0x5727C148UL, 0x2BE98A1DUL, 0x8AB41738UL, 0x20E1BE24UL,
  0xAF96DA0FUL, 0x68458425UL, 0x99833BE5UL, 0x600D457DUL,
  0x282F9350UL, 0x8334B362UL, 0xD91D1120UL, 0x2B6D8DA0UL,
  0x642B1E31UL, 0x9C305A00UL, 0x52BCE688UL, 0x1B03588AUL,
  0xF7BAEFD5UL, 0x4142ED9CUL, 0xA4315C11UL, 0x83323EC5UL,
  0xDFEF4636UL, 0xA133C501UL, 0xE9D3531CUL, 0xEE353783UL
,


  0x9DB30420UL, 0x1FB6E9DEUL, 0xA7BE7BEFUL, 0xD273A298UL,
  0x4A4F7BDBUL, 0x64AD8C57UL, 0x85510443UL, 0xFA020ED1UL,
  0x7E287AFFUL, 0xE60FB663UL, 0x095F35A1UL, 0x79EBF120UL,
  0xFD059D43UL, 0x6497B7B1UL, 0xF3641F63UL, 0x241E4ADFUL,
  0x28147F5FUL, 0x4FA2B8CDUL, 0xC9430040UL, 0x0CC32220UL,
  0xFDD30B30UL, 0xC0A5374FUL, 0x1D2D00D9UL, 0x24147B15UL,
  0xEE4D111AUL, 0x0FCA5167UL, 0x71FF904CUL, 0x2D195FFEUL,
  0x1A05645FUL, 0x0C13FEFEUL, 0x081B08CAUL, 0x05170121UL,
  0x80530100UL, 0xE83E5EFEUL, 0xAC9AF4F8UL, 0x7FE72701UL,
  0xD2B8EE5FUL, 0x06DF4261UL, 0xBB9E9B8AUL, 0x7293EA25UL,
  0xCE84FFDFUL, 0xF5718801UL, 0x3DD64B04UL, 0xA26F263BUL,
  0x7ED48400UL, 0x547EEBE6UL, 0x446D4CA0UL, 0x6CF3D6F5UL,
  0x2649ABDFUL, 0xAEA0C7F5UL, 0x36338CC1UL, 0x503F7E93UL,
  0xD3772061UL, 0x11B638E1UL, 0x72500E03UL, 0xF80EB2BBUL,
  0xABE0502EUL, 0xEC8D77DEUL, 0x57971E81UL, 0xE14F6746UL,
  0xC9335400UL, 0x6920318FUL, 0x081DBB99UL, 0xFFC304A5UL,
  0x4D351805UL, 0x7F3D5CE3UL, 0xA6C866C6UL, 0x5D5BCCA9UL,
  0xDAEC6FEAUL, 0x9F926F91UL, 0x9F46222FUL, 0x3991467DUL,
  0xA5BF6D8EUL, 0x1143C44FUL, 0x43958302UL, 0xD0214EEBUL,
  0x022083B8UL, 0x3FB6180CUL, 0x18F8931EUL, 0x281658E6UL,
  0x26486E3EUL, 0x8BD78A70UL, 0x7477E4C1UL, 0xB506E07CUL,
  0xF32D0A25UL, 0x79098B02UL, 0xE4EABB81UL, 0x28123B23UL,
  0x69DEAD38UL, 0x1574CA16UL, 0xDF871B62UL, 0x211C40B7UL,
  0xA51A9EF9UL, 0x0014377BUL, 0x041E8AC8UL, 0x09114003UL,
  0xBD59E4D2UL, 0xE3D156D5UL, 0x4FE876D5UL, 0x2F91A340UL,
  0x557BE8DEUL, 0x00EAE4A7UL, 0x0CE5C2ECUL, 0x4DB4BBA6UL,
  0xE756BDFFUL, 0xDD3369ACUL, 0xEC17B035UL, 0x06572327UL,
  0x99AFC8B0UL, 0x56C8C391UL, 0x6B65811CUL, 0x5E146119UL,
  0x6E85CB75UL, 0xBE07C002UL, 0xC2325577UL, 0x893FF4ECUL,
  0x5BBFC92DUL, 0xD0EC3B25UL, 0xB7801AB7UL, 0x8D6D3B24UL,
  0x20C763EFUL, 0xC366A5FCUL, 0x9C382880UL, 0x0ACE3205UL,
  0xAAC9548AUL, 0xECA1D7C7UL, 0x041AFA32UL, 0x1D16625AUL,
  0x6701902CUL, 0x9B757A54UL, 0x31D477F7UL, 0x9126B031UL,
  0x36CC6FDBUL, 0xC70B8B46UL, 0xD9E66A48UL, 0x56E55A79UL,
  0x026A4CEBUL, 0x52437EFFUL, 0x2F8F76B4UL, 0x0DF980A5UL,
  0x8674CDE3UL, 0xEDDA04EBUL, 0x17A9BE04UL, 0x2C18F4DFUL,
  0xB7747F9DUL, 0xAB2AF7B4UL, 0xEFC34D20UL, 0x2E096B7CUL,
  0x1741A254UL, 0xE5B6A035UL, 0x213D42F6UL, 0x2C1C7C26UL,
  0x61C2F50FUL, 0x6552DAF9UL, 0xD2C231F8UL, 0x25130F69UL,
  0xD8167FA2UL, 0x0418F2C8UL, 0x001A96A6UL, 0x0D1526ABUL,
  0x63315C21UL, 0x5E0A72ECUL, 0x49BAFEFDUL, 0x187908D9UL,
  0x8D0DBD86UL, 0x311170A7UL, 0x3E9B640CUL, 0xCC3E10D7UL,
  0xD5CAD3B6UL, 0x0CAEC388UL, 0xF73001E1UL, 0x6C728AFFUL,
  0x71EAE2A1UL, 0x1F9AF36EUL, 0xCFCBD12FUL, 0xC1DE8417UL,
  0xAC07BE6BUL, 0xCB44A1D8UL, 0x8B9B0F56UL, 0x013988C3UL,
  0xB1C52FCAUL, 0xB4BE31CDUL, 0xD8782806UL, 0x12A3A4E2UL,
  0x6F7DE532UL, 0x58FD7EB6UL, 0xD01EE900UL, 0x24ADFFC2UL,
  0xF4990FC5UL, 0x9711AAC5UL, 0x001D7B95UL, 0x82E5E7D2UL,
  0x109873F6UL, 0x00613096UL, 0xC32D9521UL, 0xADA121FFUL,
  0x29908415UL, 0x7FBB977FUL, 0xAF9EB3DBUL, 0x29C9ED2AUL,
  0x5CE2A465UL, 0xA730F32CUL, 0xD0AA3FE8UL, 0x8A5CC091UL,
  0xD49E2CE7UL, 0x0CE454A9UL, 0xD60ACD86UL, 0x015F1919UL,
  0x77079103UL, 0xDEA03AF6UL, 0x78A8565EUL, 0xDEE356DFUL,
  0x21F05CBEUL, 0x8B75E387UL, 0xB3C50651UL, 0xB8A5C3EFUL,
  0xD8EEB6D2UL, 0xE523BE77UL, 0xC2154529UL, 0x2F69EFDFUL,
  0xAFE67AFBUL, 0xF470C4B2UL, 0xF3E0EB5BUL, 0xD6CC9876UL,
  0x39E4460CUL, 0x1FDA8538UL, 0x1987832FUL, 0xCA007367UL,
  0xA99144F8UL, 0x296B299EUL, 0x492FC295UL, 0x9266BEABUL,
  0xB5676E69UL, 0x9BD3DDDAUL, 0xDF7E052FUL, 0xDB25701CUL,
  0x1B5E51EEUL, 0xF65324E6UL, 0x6AFCE36CUL, 0x0316CC04UL,
  0x8644213EUL, 0xB7DC59D0UL, 0x7965291FUL, 0xCCD6FD43UL,
  0x41823979UL, 0x932BCDF6UL, 0xB657C34DUL, 0x4EDFD282UL,
  0x7AE5290CUL, 0x3CB9536BUL, 0x851E20FEUL, 0x9833557EUL,
  0x13ECF0B0UL, 0xD3FFB372UL, 0x3F85C5C1UL, 0x0AEF7ED2UL
,


  0x7EC90C04UL, 0x2C6E74B9UL, 0x9B0E66DFUL, 0xA6337911UL,
  0xB86A7FFFUL, 0x1DD358F5UL, 0x44DD9D44UL, 0x1731167FUL,
  0x08FBF1FAUL, 0xE7F511CCUL, 0xD2051B00UL, 0x735ABA00UL,
  0x2AB722D8UL, 0x386381CBUL, 0xACF6243AUL, 0x69BEFD7AUL,
  0xE6A2E77FUL, 0xF0C720CDUL, 0xC4494816UL, 0xCCF5C180UL,
  0x38851640UL, 0x15B0A848UL, 0xE68B18CBUL, 0x4CAADEFFUL,
  0x5F480A01UL, 0x0412B2AAUL, 0x259814FCUL, 0x41D0EFE2UL,
  0x4E40B48DUL, 0x248EB6FBUL, 0x8DBA1CFEUL, 0x41A99B02UL,
  0x1A550A04UL, 0xBA8F65CBUL, 0x7251F4E7UL, 0x95A51725UL,
  0xC106ECD7UL, 0x97A5980AUL, 0xC539B9AAUL, 0x4D79FE6AUL,
  0xF2F3F763UL, 0x68AF8040UL, 0xED0C9E56UL, 0x11B4958BUL,
  0xE1EB5A88UL, 0x8709E6B0UL, 0xD7E07156UL, 0x4E29FEA7UL,
  0x6366E52DUL, 0x02D1C000UL, 0xC4AC8E05UL, 0x9377F571UL,
  0x0C05372AUL, 0x578535F2UL, 0x2261BE02UL, 0xD642A0C9UL,
  0xDF13A280UL, 0x74B55BD2UL, 0x682199C0UL, 0xD421E5ECUL,
  0x53FB3CE8UL, 0xC8ADEDB3UL, 0x28A87FC9UL, 0x3D959981UL,
  0x5C1FF900UL, 0xFE38D399UL, 0x0C4EFF0BUL, 0x062407EAUL,
  0xAA2F4FB1UL, 0x4FB96976UL, 0x90C79505UL, 0xB0A8A774UL,
  0xEF55A1FFUL, 0xE59CA2C2UL, 0xA6B62D27UL, 0xE66A4263UL,
  0xDF65001FUL, 0x0EC50966UL, 0xDFDD55BCUL, 0x29DE0655UL,
  0x911E739AUL, 0x17AF8975UL, 0x32C7911CUL, 0x89F89468UL,
  0x0D01E980UL, 0x524755F4UL, 0x03B63CC9UL, 0x0CC844B2UL,
  0xBCF3F0AAUL, 0x87AC36E9UL, 0xE53A7426UL, 0x01B3D82BUL,
  0x1A9E7449UL, 0x64EE2D7EUL, 0xCDDBB1DAUL, 0x01C94910UL,
  0xB868BF80UL, 0x0D26F3FDUL, 0x9342EDE7UL, 0x04A5C284UL,
  0x636737B6UL, 0x50F5B616UL, 0xF24766E3UL, 0x8ECA36C1UL,
  0x136E05DBUL, 0xFEF18391UL, 0xFB887A37UL, 0xD6E7F7D4UL,
  0xC7FB7DC9UL, 0x3063FCDFUL, 0xB6F589DEUL, 0xEC2941DAUL,
  0x26E46695UL, 0xB7566419UL, 0xF654EFC5UL, 0xD08D58B7UL,
  0x48925401UL, 0xC1BACB7FUL, 0xE5FF550FUL, 0xB6083049UL,
  0x5BB5D0E8UL, 0x87D72E5AUL, 0xAB6A6EE1UL, 0x223A66CEUL,
  0xC62BF3CDUL, 0x9E0885F9UL, 0x68CB3E47UL, 0x086C010FUL,
  0xA21DE820UL, 0xD18B69DEUL, 0xF3F65777UL, 0xFA02C3F6UL,
  0x407EDAC3UL, 0xCBB3D550UL, 0x1793084DUL, 0xB0D70EBAUL,
  0x0AB378D5UL, 0xD951FB0CUL, 0xDED7DA56UL, 0x4124BBE4UL,
  0x94CA0B56UL, 0x0F5755D1UL, 0xE0E1E56EUL, 0x6184B5BEUL,
  0x580A249FUL, 0x94F74BC0UL, 0xE327888EUL, 0x9F7B5561UL,
  0xC3DC0280UL, 0x05687715UL, 0x646C6BD7UL, 0x44904DB3UL,
  0x66B4F0A3UL, 0xC0F1648AUL, 0x697ED5AFUL, 0x49E92FF6UL,
  0x309E374FUL, 0x2CB6356AUL, 0x85808573UL, 0x4991F840UL,
  0x76F0AE02UL, 0x083BE84DUL, 0x28421C9AUL, 0x44489406UL,
  0x736E4CB8UL, 0xC1092910UL, 0x8BC95FC6UL, 0x7D869CF4UL,
  0x134F616FUL, 0x2E77118DUL, 0xB31B2BE1UL, 0xAA90B472UL,
  0x3CA5D717UL, 0x7D161BBAUL, 0x9CAD9010UL, 0xAF462BA2UL,
  0x9FE459D2UL, 0x45D34559UL, 0xD9F2DA13UL, 0xDBC65487UL,
  0xF3E4F94EUL, 0x176D486FUL, 0x097C13EAUL, 0x631DA5C7UL,
  0x445F7382UL, 0x175683F4UL, 0xCDC66A97UL, 0x70BE0288UL,
  0xB3CDCF72UL, 0x6E5DD2F3UL, 0x20936079UL, 0x459B80A5UL,
  0xBE60E2DBUL, 0xA9C23101UL, 0xEBA5315CUL, 0x224E42F2UL,
  0x1C5C1572UL, 0xF6721B2CUL, 0x1AD2FFF3UL, 0x8C25404EUL,
  0x324ED72FUL, 0x4067B7FDUL, 0x0523138EUL, 0x5CA3BC78UL,
  0xDC0FD66EUL, 0x75922283UL, 0x784D6B17UL, 0x58EBB16EUL,
  0x44094F85UL, 0x3F481D87UL, 0xFCFEAE7BUL, 0x77B5FF76UL,
  0x8C2302BFUL, 0xAAF47556UL, 0x5F46B02AUL, 0x2B092801UL,
  0x3D38F5F7UL, 0x0CA81F36UL, 0x52AF4A8AUL, 0x66D5E7C0UL,
  0xDF3B0874UL, 0x95055110UL, 0x1B5AD7A8UL, 0xF61ED5ADUL,
  0x6CF6E479UL, 0x20758184UL, 0xD0CEFA65UL, 0x88F7BE58UL,
  0x4A046826UL, 0x0FF6F8F3UL, 0xA09C7F70UL, 0x5346ABA0UL,
  0x5CE96C28UL, 0xE176EDA3UL, 0x6BAC307FUL, 0x376829D2UL,
  0x85360FA9UL, 0x17E3FE2AUL, 0x24B79767UL, 0xF5A96B20UL,
  0xD6CD2595UL, 0x68FF1EBFUL, 0x7555442CUL, 0xF19F06BEUL,
  0xF9E0659AUL, 0xEEB9491DUL, 0x34010718UL, 0xBB30CAB8UL,
  0xE822FE15UL, 0x88570983UL, 0x750E6249UL, 0xDA627E55UL,
  0x5E76FFA8UL, 0xB1534546UL, 0x6D47DE08UL, 0xEFE9E7D4UL
,


  0xF6FA8F9DUL, 0x2CAC6CE1UL, 0x4CA34867UL, 0xE2337F7CUL,
  0x95DB08E7UL, 0x016843B4UL, 0xECED5CBCUL, 0x325553ACUL,
  0xBF9F0960UL, 0xDFA1E2EDUL, 0x83F0579DUL, 0x63ED86B9UL,
  0x1AB6A6B8UL, 0xDE5EBE39UL, 0xF38FF732UL, 0x8989B138UL,
  0x33F14961UL, 0xC01937BDUL, 0xF506C6DAUL, 0xE4625E7EUL,
  0xA308EA99UL, 0x4E23E33CUL, 0x79CBD7CCUL, 0x48A14367UL,
  0xA3149619UL, 0xFEC94BD5UL, 0xA114174AUL, 0xEAA01866UL,
  0xA084DB2DUL, 0x09A8486FUL, 0xA888614AUL, 0x2900AF98UL,
  0x01665991UL, 0xE1992863UL, 0xC8F30C60UL, 0x2E78EF3CUL,
  0xD0D51932UL, 0xCF0FEC14UL, 0xF7CA07D2UL, 0xD0A82072UL,
  0xFD41197EUL, 0x9305A6B0UL, 0xE86BE3DAUL, 0x74BED3CDUL,
  0x372DA53CUL, 0x4C7F4448UL, 0xDAB5D440UL, 0x6DBA0EC3UL,
  0x083919A7UL, 0x9FBAEED9UL, 0x49DBCFB0UL, 0x4E670C53UL,
  0x5C3D9C01UL, 0x64BDB941UL, 0x2C0E636AUL, 0xBA7DD9CDUL,
  0xEA6F7388UL, 0xE70BC762UL, 0x35F29ADBUL, 0x5C4CDD8DUL,
  0xF0D48D8CUL, 0xB88153E2UL, 0x08A19866UL, 0x1AE2EAC8UL,
  0x284CAF89UL, 0xAA928223UL, 0x9334BE53UL, 0x3B3A21BFUL,
  0x16434BE3UL, 0x9AEA3906UL, 0xEFE8C36EUL, 0xF890CDD9UL,
  0x80226DAEUL, 0xC340A4A3UL, 0xDF7E9C09UL, 0xA694A807UL,
  0x5B7C5ECCUL, 0x221DB3A6UL, 0x9A69A02FUL, 0x68818A54UL,
  0xCEB2296FUL, 0x53C0843AUL, 0xFE893655UL, 0x25BFE68AUL,
  0xB4628ABCUL, 0xCF222EBFUL, 0x25AC6F48UL, 0xA9A99387UL,
  0x53BDDB65UL, 0xE76FFBE7UL, 0xE967FD78UL, 0x0BA93563UL,
  0x8E342BC1UL, 0xE8A11BE9UL, 0x4980740DUL, 0xC8087DFCUL,
  0x8DE4BF99UL, 0xA11101A0UL, 0x7FD37975UL, 0xDA5A26C0UL,
  0xE81F994FUL, 0x9528CD89UL, 0xFD339FEDUL, 0xB87834BFUL,
  0x5F04456DUL, 0x22258698UL, 0xC9C4C83BUL, 0x2DC156BEUL,
  0x4F628DAAUL, 0x57F55EC5UL, 0xE2220ABEUL, 0xD2916EBFUL,
  0x4EC75B95UL, 0x24F2C3C0UL, 0x42D15D99UL, 0xCD0D7FA0UL,
  0x7B6E27FFUL, 0xA8DC8AF0UL, 0x7345C106UL, 0xF41E232FUL,
  0x35162386UL, 0xE6EA8926UL, 0x3333B094UL, 0x157EC6F2UL,
  0x372B74AFUL, 0x692573E4UL, 0xE9A9D848UL, 0xF3160289UL,
  0x3A62EF1DUL, 0xA787E238UL, 0xF3A5F676UL, 0x74364853UL,
  0x20951063UL, 0x4576698DUL, 0xB6FAD407UL, 0x592AF950UL,
  0x36F73523UL, 0x4CFB6E87UL, 0x7DA4CEC0UL, 0x6C152DAAUL,
  0xCB0396A8UL, 0xC50DFE5DUL, 0xFCD707ABUL, 0x0921C42FUL,
  0x89DFF0BBUL, 0x5FE2BE78UL, 0x448F4F33UL, 0x754613C9UL,
  0x2B05D08DUL, 0x48B9D585UL, 0xDC049441UL, 0xC8098F9BUL,
  0x7DEDE786UL, 0xC39A3373UL, 0x42410005UL, 0x6A091751UL,
  0x0EF3C8A6UL, 0x890072D6UL, 0x28207682UL, 0xA9A9F7BEUL,
  0xBF32679DUL, 0xD45B5B75UL, 0xB353FD00UL, 0xCBB0E358UL,
  0x830F220AUL, 0x1F8FB214UL, 0xD372CF08UL, 0xCC3C4A13UL,
  0x8CF63166UL, 0x061C87BEUL, 0x88C98F88UL, 0x6062E397UL,
  0x47CF8E7AUL, 0xB6C85283UL, 0x3CC2ACFBUL, 0x3FC06976UL,
  0x4E8F0252UL, 0x64D8314DUL, 0xDA3870E3UL, 0x1E665459UL,
  0xC10908F0UL, 0x513021A5UL, 0x6C5B68B7UL, 0x822F8AA0UL,
  0x3007CD3EUL, 0x74719EEFUL, 0xDC872681UL, 0x073340D4UL,
  0x7E432FD9UL, 0x0C5EC241UL, 0x8809286CUL, 0xF592D891UL,
  0x08A930F6UL, 0x957EF305UL, 0xB7FBFFBDUL, 0xC266E96FUL,
  0x6FE4AC98UL, 0xB173ECC0UL, 0xBC60B42AUL, 0x953498DAUL,
  0xFBA1AE12UL, 0x2D4BD736UL, 0x0F25FAABUL, 0xA4F3FCEBUL,
  0xE2969123UL, 0x257F0C3DUL, 0x9348AF49UL, 0x361400BCUL,
  0xE8816F4AUL, 0x3814F200UL, 0xA3F94043UL, 0x9C7A54C2UL,
  0xBC704F57UL, 0xDA41E7F9UL, 0xC25AD33AUL, 0x54F4A084UL,
  0xB17F5505UL, 0x59357CBEUL, 0xEDBD15C8UL, 0x7F97C5ABUL,
  0xBA5AC7B5UL, 0xB6F6DEAFUL, 0x3A479C3AUL, 0x5302DA25UL,
  0x653D7E6AUL, 0x54268D49UL, 0x51A477EAUL, 0x5017D55BUL,
  0xD7D25D88UL, 0x44136C76UL, 0x0404A8C8UL, 0xB8E5A121UL,
  0xB81A928AUL, 0x60ED5869UL, 0x97C55B96UL, 0xEAEC991BUL,
  0x29935913UL, 0x01FDB7F1UL, 0x088E8DFAUL, 0x9AB6F6F5UL,
  0x3B4CBF9FUL, 0x4A5DE3ABUL, 0xE6051D35UL, 0xA0E1D855UL,
  0xD36B4CF1UL, 0xF544EDEBUL, 0xB0E93524UL, 0xBEBB8FBDUL,
  0xA2D762CFUL, 0x49C92F54UL, 0x38B5F331UL, 0x7128A454UL,
  0x48392905UL, 0xA65B1DB8UL, 0x851C97BDUL, 0xD675CF2FUL
,


  0x85E04019UL, 0x332BF567UL, 0x662DBFFFUL, 0xCFC65693UL,
  0x2A8D7F6FUL, 0xAB9BC912UL, 0xDE6008A1UL, 0x2028DA1FUL,
  0x0227BCE7UL, 0x4D642916UL, 0x18FAC300UL, 0x50F18B82UL,
  0x2CB2CB11UL, 0xB232E75CUL, 0x4B3695F2UL, 0xB28707DEUL,
  0xA05FBCF6UL, 0xCD4181E9UL, 0xE150210CUL, 0xE24EF1BDUL,
  0xB168C381UL, 0xFDE4E789UL, 0x5C79B0D8UL, 0x1E8BFD43UL,
  0x4D495001UL, 0x38BE4341UL, 0x913CEE1DUL, 0x92A79C3FUL,
  0x089766BEUL, 0xBAEEADF4UL, 0x1286BECFUL, 0xB6EACB19UL,
  0x2660C200UL, 0x7565BDE4UL, 0x64241F7AUL, 0x8248DCA9UL,
  0xC3B3AD66UL, 0x28136086UL, 0x0BD8DFA8UL, 0x356D1CF2UL,
  0x107789BEUL, 0xB3B2E9CEUL, 0x0502AA8FUL, 0x0BC0351EUL,
  0x166BF52AUL, 0xEB12FF82UL, 0xE3486911UL, 0xD34D7516UL,
  0x4E7B3AFFUL, 0x5F43671BUL, 0x9CF6E037UL, 0x4981AC83UL,
  0x334266CEUL, 0x8C9341B7UL, 0xD0D854C0UL, 0xCB3A6C88UL,
  0x47BC2829UL, 0x4725BA37UL, 0xA66AD22BUL, 0x7AD61F1EUL,
  0x0C5CBAFAUL, 0x4437F107UL, 0xB6E79962UL, 0x42D2D816UL,
  0x0A961288UL, 0xE1A5C06EUL, 0x13749E67UL, 0x72FC081AUL,
  0xB1D139F7UL, 0xF9583745UL, 0xCF19DF58UL, 0xBEC3F756UL,
  0xC06EBA30UL, 0x07211B24UL, 0x45C28829UL, 0xC95E317FUL,
  0xBC8EC511UL, 0x38BC46E9UL, 0xC6E6FA14UL, 0xBAE8584AUL,
  0xAD4EBC46UL, 0x468F508BUL, 0x7829435FUL, 0xF124183BUL,
  0x821DBA9FUL, 0xAFF60FF4UL, 0xEA2C4E6DUL, 0x16E39264UL,
  0x92544A8BUL, 0x009B4FC3UL, 0xABA68CEDUL, 0x9AC96F78UL,
  0x06A5B79AUL, 0xB2856E6EUL, 0x1AEC3CA9UL, 0xBE838688UL,
  0x0E0804E9UL, 0x55F1BE56UL, 0xE7E5363BUL, 0xB3A1F25DUL,
  0xF7DEBB85UL, 0x61FE033CUL, 0x16746233UL, 0x3C034C28UL,
  0xDA6D0C74UL, 0x79AAC56CUL, 0x3CE4E1ADUL, 0x51F0C802UL,
  0x98F8F35AUL, 0x1626A49FUL, 0xEED82B29UL, 0x1D382FE3UL,
  0x0C4FB99AUL, 0xBB325778UL, 0x3EC6D97BUL, 0x6E77A6A9UL,
  0xCB658B5CUL, 0xD45230C7UL, 0x2BD1408BUL, 0x60C03EB7UL,
  0xB9068D78UL, 0xA33754F4UL, 0xF430C87DUL, 0xC8A71302UL,
  0xB96D8C32UL, 0xEBD4E7BEUL, 0xBE8B9D2DUL, 0x7979FB06UL,
  0xE7225308UL, 0x8B75CF77UL, 0x11EF8DA4UL, 0xE083C858UL,
  0x8D6B786FUL, 0x5A6317A6UL, 0xFA5CF7A0UL, 0x5DDA0033UL,
  0xF28EBFB0UL, 0xF5B9C310UL, 0xA0EAC280UL, 0x08B9767AUL,
  0xA3D9D2B0UL, 0x79D34217UL, 0x021A718DUL, 0x9AC6336AUL,
  0x2711FD60UL, 0x438050E3UL, 0x069908A8UL, 0x3D7FEDC4UL,
  0x826D2BEFUL, 0x4EEB8476UL, 0x488DCF25UL, 0x36C9D566UL,
  0x28E74E41UL, 0xC2610ACAUL, 0x3D49A9CFUL, 0xBAE3B9DFUL,
  0xB65F8DE6UL, 0x92AEAF64UL, 0x3AC7D5E6UL, 0x9EA80509UL,
  0xF22B017DUL, 0xA4173F70UL, 0xDD1E16C3UL, 0x15E0D7F9UL,
  0x50B1B887UL, 0x2B9F4FD5UL, 0x625ABA82UL, 0x6A017962UL,
  0x2EC01B9CUL, 0x15488AA9UL, 0xD716E740UL, 0x40055A2CUL,
  0x93D29A22UL, 0xE32DBF9AUL, 0x058745B9UL, 0x3453DC1EUL,
  0xD699296EUL, 0x496CFF6FUL, 0x1C9F4986UL, 0xDFE2ED07UL,
  0xB87242D1UL, 0x19DE7EAEUL, 0x053E561AUL, 0x15AD6F8CUL,
  0x66626C1CUL, 0x7154C24CUL, 0xEA082B2AUL, 0x93EB2939UL,
  0x17DCB0F0UL, 0x58D4F2AEUL, 0x9EA294FBUL, 0x52CF564CUL,
  0x9883FE66UL, 0x2EC40581UL, 0x763953C3UL, 0x01D6692EUL,
  0xD3A0C108UL, 0xA1E7160EUL, 0xE4F2DFA6UL, 0x693ED285UL,
  0x74904698UL, 0x4C2B0EDDUL, 0x4F757656UL, 0x5D393378UL,
  0xA132234FUL, 0x3D321C5DUL, 0xC3F5E194UL, 0x4B269301UL,
  0xC79F022FUL, 0x3C997E7EUL, 0x5E4F9504UL, 0x3FFAFBBDUL,
  0x76F7AD0EUL, 0x296693F4UL, 0x3D1FCE6FUL, 0xC61E45BEUL,
  0xD3B5AB34UL, 0xF72BF9B7UL, 0x1B0434C0UL, 0x4E72B567UL,
  0x5592A33DUL, 0xB5229301UL, 0xCFD2A87FUL, 0x60AEB767UL,
  0x1814386BUL, 0x30BCC33DUL, 0x38A0C07DUL, 0xFD1606F2UL,
  0xC363519BUL, 0x589DD390UL, 0x5479F8E6UL, 0x1CB8D647UL,
  0x97FD61A9UL, 0xEA7759F4UL, 0x2D57539DUL, 0x569A58CFUL,
  0xE84E63ADUL, 0x462E1B78UL, 0x6580F87EUL, 0xF3817914UL,
  0x91DA55F4UL, 0x40A230F3UL, 0xD1988F35UL, 0xB6E318D2UL,
  0x3FFA50BCUL, 0x3D40F021UL, 0xC3C0BDAEUL, 0x4958C24CUL,
  0x518F36B2UL, 0x84B1D370UL, 0x0FEDCE83UL, 0x878DDADAUL,
  0xF2A279C7UL, 0x94E01BE8UL, 0x90716F4BUL, 0x954B8AA3UL
,


  0xE216300DUL, 0xBBDDFFFCUL, 0xA7EBDABDUL, 0x35648095UL,
  0x7789F8B7UL, 0xE6C1121BUL, 0x0E241600UL, 0x052CE8B5UL,
  0x11A9CFB0UL, 0xE5952F11UL, 0xECE7990AUL, 0x9386D174UL,
  0x2A42931CUL, 0x76E38111UL, 0xB12DEF3AUL, 0x37DDDDFCUL,
  0xDE9ADEB1UL, 0x0A0CC32CUL, 0xBE197029UL, 0x84A00940UL,
  0xBB243A0FUL, 0xB4D137CFUL, 0xB44E79F0UL, 0x049EEDFDUL,
  0x0B15A15DUL, 0x480D3168UL, 0x8BBBDE5AUL, 0x669DED42UL,
  0xC7ECE831UL, 0x3F8F95E7UL, 0x72DF191BUL, 0x7580330DUL,
  0x94074251UL, 0x5C7DCDFAUL, 0xABBE6D63UL, 0xAA402164UL,
  0xB301D40AUL, 0x02E7D1CAUL, 0x53571DAEUL, 0x7A3182A2UL,
  0x12A8DDECUL, 0xFDAA335DUL, 0x176F43E8UL, 0x71FB46D4UL,
  0x38129022UL, 0xCE949AD4UL, 0xB84769ADUL, 0x965BD862UL,
  0x82F3D055UL, 0x66FB9767UL, 0x15B80B4EUL, 0x1D5B47A0UL,
  0x4CFDE06FUL, 0xC28EC4B8UL, 0x57E8726EUL, 0x647A78FCUL,
  0x99865D44UL, 0x608BD593UL, 0x6C200E03UL, 0x39DC5FF6UL,
  0x5D0B00A3UL, 0xAE63AFF2UL, 0x7E8BD632UL, 0x70108C0CUL,
  0xBBD35049UL, 0x2998DF04UL, 0x980CF42AUL, 0x9B6DF491UL,
  0x9E7EDD53UL, 0x06918548UL, 0x58CB7E07UL, 0x3B74EF2EUL,
  0x522FFFB1UL, 0xD24708CCUL, 0x1C7E27CDUL, 0xA4EB215BUL,
  0x3CF1D2E2UL, 0x19B47A38UL, 0x424F7618UL, 0x35856039UL,
  0x9D17DEE7UL, 0x27EB35E6UL, 0xC9AFF67BUL, 0x36BAF5B8UL,
  0x09C467CDUL, 0xC18910B1UL, 0xE11DBF7BUL, 0x06CD1AF8UL,
  0x7170C608UL, 0x2D5E3354UL, 0xD4DE495AUL, 0x64C6D006UL,
  0xBCC0C62CUL, 0x3DD00DB3UL, 0x708F8F34UL, 0x77D51B42UL,
  0x264F620FUL, 0x24B8D2BFUL, 0x15C1B79EUL, 0x46A52564UL,
  0xF8D7E54EUL, 0x3E378160UL, 0x7895CDA5UL, 0x859C15A5UL,
  0xE6459788UL, 0xC37BC75FUL, 0xDB07BA0CUL, 0x0676A3ABUL,
  0x7F229B1EUL, 0x31842E7BUL, 0x24259FD7UL, 0xF8BEF472UL,
  0x835FFCB8UL, 0x6DF4C1F2UL, 0x96F5B195UL, 0xFD0AF0FCUL,
  0xB0FE134CUL, 0xE2506D3DUL, 0x4F9B12EAUL, 0xF215F225UL,
  0xA223736FUL, 0x9FB4C428UL, 0x25D04979UL, 0x34C713F8UL,
  0xC4618187UL, 0xEA7A6E98UL, 0x7CD16EFCUL, 0x1436876CUL,
  0xF1544107UL, 0xBEDEEE14UL, 0x56E9AF27UL, 0xA04AA441UL,
  0x3CF7C899UL, 0x92ECBAE6UL, 0xDD67016DUL, 0x151682EBUL,
  0xA842EEDFUL, 0xFDBA60B4UL, 0xF1907B75UL, 0x20E3030FUL,
  0x24D8C29EUL, 0xE139673BUL, 0xEFA63FB8UL, 0x71873054UL,
  0xB6F2CF3BUL, 0x9F326442UL, 0xCB15A4CCUL, 0xB01A4504UL,
  0xF1E47D8DUL, 0x844A1BE5UL, 0xBAE7DFDCUL, 0x42CBDA70UL,
  0xCD7DAE0AUL, 0x57E85B7AUL, 0xD53F5AF6UL, 0x20CF4D8CUL,
  0xCEA4D428UL, 0x79D130A4UL, 0x3486EBFBUL, 0x33D3CDDCUL,
  0x77853B53UL, 0x37EFFCB5UL, 0xC5068778UL, 0xE580B3E6UL,
  0x4E68B8F4UL, 0xC5C8B37EUL, 0x0D809EA2UL, 0x398FEB7CUL,
  0x132A4F94UL, 0x43B7950EUL, 0x2FEE7D1CUL, 0x223613BDUL,
  0xDD06CAA2UL, 0x37DF932BUL, 0xC4248289UL, 0xACF3EBC3UL,
  0x5715F6B7UL, 0xEF3478DDUL, 0xF267616FUL, 0xC148CBE4UL,
  0x9052815EUL, 0x5E410FABUL, 0xB48A2465UL, 0x2EDA7FA4UL,
  0xE87B40E4UL, 0xE98EA084UL, 0x5889E9E1UL, 0xEFD390FCUL,
  0xDD07D35BUL, 0xDB485694UL, 0x38D7E5B2UL, 0x57720101UL,
  0x730EDEBCUL, 0x5B643113UL, 0x94917E4FUL, 0x503C2FBAUL,
  0x646F1282UL, 0x7523D24AUL, 0xE0779695UL, 0xF9C17A8FUL,
  0x7A5B2121UL, 0xD187B896UL, 0x29263A4DUL, 0xBA510CDFUL,
  0x81F47C9FUL, 0xAD1163EDUL, 0xEA7B5965UL, 0x1A00726EUL,
  0x11403092UL, 0x00DA6D77UL, 0x4A0CDD61UL, 0xAD1F4603UL,
  0x605BDFB0UL, 0x9EEDC364UL, 0x22EBE6A8UL, 0xCEE7D28AUL,
  0xA0E736A0UL, 0x5564A6B9UL, 0x10853209UL, 0xC7EB8F37UL,
  0x2DE705CAUL, 0x8951570FUL, 0xDF09822BUL, 0xBD691A6CUL,
  0xAA12E4F2UL, 0x87451C0FUL, 0xE0F6A27AUL, 0x3ADA4819UL,
  0x4CF1764FUL, 0x0D771C2BUL, 0x67CDB156UL, 0x350D8384UL,
  0x5938FA0FUL, 0x42399EF3UL, 0x36997B07UL, 0x0E84093DUL,
  0x4AA93E61UL, 0x8360D87BUL, 0x1FA98B0CUL, 0x1149382CUL,
  0xE97625A5UL, 0x0614D1B7UL, 0x0E25244BUL, 0x0C768347UL,
  0x589E8D82UL, 0x0D2059D1UL, 0xA466BB1EUL, 0xF8DA0A82UL,
  0x04F19130UL, 0xBA6E4EC0UL, 0x99265164UL, 0x1EE7230DUL,
  0x50B2AD80UL, 0xEAEE6801UL, 0x8DB2A283UL, 0xEA8BF59EUL
};

//-----------------
// The following CAST-256 implementation was contributed by Leonard Janke

static const word32 CAST256_t_m[8*24] =
{
        0x5a827999, 0xd151d6a1, 0x482133a9, 0xbef090b1, 0x35bfedb9, 0xac8f4ac1,
        0x235ea7c9, 0x9a2e04d1, 0x10fd61d9, 0x87ccbee1, 0xfe9c1be9, 0x756b78f1,
        0xec3ad5f9, 0x630a3301, 0xd9d99009, 0x50a8ed11, 0xc7784a19, 0x3e47a721,
        0xb5170429, 0x2be66131, 0xa2b5be39, 0x19851b41, 0x90547849, 0x0723d551,
        0xc95c653a, 0x402bc242, 0xb6fb1f4a, 0x2dca7c52, 0xa499d95a, 0x1b693662,
        0x9238936a, 0x0907f072, 0x7fd74d7a, 0xf6a6aa82, 0x6d76078a, 0xe4456492,
        0x5b14c19a, 0xd1e41ea2, 0x48b37baa, 0xbf82d8b2, 0x365235ba, 0xad2192c2,
        0x23f0efca, 0x9ac04cd2, 0x118fa9da, 0x885f06e2, 0xff2e63ea, 0x75fdc0f2,
        0x383650db, 0xaf05ade3, 0x25d50aeb, 0x9ca467f3, 0x1373c4fb, 0x8a432203,
        0x01127f0b, 0x77e1dc13, 0xeeb1391b, 0x65809623, 0xdc4ff32b, 0x531f5033,
        0xc9eead3b, 0x40be0a43, 0xb78d674b, 0x2e5cc453, 0xa52c215b, 0x1bfb7e63,
        0x92cadb6b, 0x099a3873, 0x8069957b, 0xf738f283, 0x6e084f8b, 0xe4d7ac93,
        0xa7103c7c, 0x1ddf9984, 0x94aef68c, 0x0b7e5394, 0x824db09c, 0xf91d0da4,
        0x6fec6aac, 0xe6bbc7b4, 0x5d8b24bc, 0xd45a81c4, 0x4b29decc, 0xc1f93bd4,
        0x38c898dc, 0xaf97f5e4, 0x266752ec, 0x9d36aff4, 0x14060cfc, 0x8ad56a04,
        0x01a4c70c, 0x78742414, 0xef43811c, 0x6612de24, 0xdce23b2c, 0x53b19834,
        0x15ea281d, 0x8cb98525, 0x0388e22d, 0x7a583f35, 0xf1279c3d, 0x67f6f945,
        0xdec6564d, 0x5595b355, 0xcc65105d, 0x43346d65, 0xba03ca6d, 0x30d32775,
        0xa7a2847d, 0x1e71e185, 0x95413e8d, 0x0c109b95, 0x82dff89d, 0xf9af55a5,
        0x707eb2ad, 0xe74e0fb5, 0x5e1d6cbd, 0xd4ecc9c5, 0x4bbc26cd, 0xc28b83d5,
        0x84c413be, 0xfb9370c6, 0x7262cdce, 0xe9322ad6, 0x600187de, 0xd6d0e4e6,
        0x4da041ee, 0xc46f9ef6, 0x3b3efbfe, 0xb20e5906, 0x28ddb60e, 0x9fad1316,
        0x167c701e, 0x8d4bcd26, 0x041b2a2e, 0x7aea8736, 0xf1b9e43e, 0x68894146,
        0xdf589e4e, 0x5627fb56, 0xccf7585e, 0x43c6b566, 0xba96126e, 0x31656f76,
        0xf39dff5f, 0x6a6d5c67, 0xe13cb96f, 0x580c1677, 0xcedb737f, 0x45aad087,
        0xbc7a2d8f, 0x33498a97, 0xaa18e79f, 0x20e844a7, 0x97b7a1af, 0x0e86feb7,
        0x85565bbf, 0xfc25b8c7, 0x72f515cf, 0xe9c472d7, 0x6093cfdf, 0xd7632ce7,
        0x4e3289ef, 0xc501e6f7, 0x3bd143ff, 0xb2a0a107, 0x296ffe0f, 0xa03f5b17,
        0x6277eb00, 0xd9474808, 0x5016a510, 0xc6e60218, 0x3db55f20, 0xb484bc28,
        0x2b541930, 0xa2237638, 0x18f2d340, 0x8fc23048, 0x06918d50, 0x7d60ea58,
        0xf4304760, 0x6affa468, 0xe1cf0170, 0x589e5e78, 0xcf6dbb80, 0x463d1888,
        0xbd0c7590, 0x33dbd298, 0xaaab2fa0, 0x217a8ca8, 0x9849e9b0, 0x0f1946b8
};

static const unsigned int CAST256_t_r[8*24] =
{
  19, 27, 3, 11, 19, 27, 3, 11, 19, 27, 3, 11, 19, 27, 3, 11, 19, 27, 3, 11, 19, 27, 3, 11,
  4, 12, 20, 28, 4, 12, 20, 28, 4, 12, 20, 28, 4, 12, 20, 28, 4, 12, 20, 28, 4, 12, 20, 28,
  21, 29, 5, 13, 21, 29, 5, 13, 21, 29, 5, 13, 21, 29, 5, 13, 21, 29, 5, 13, 21, 29, 5, 13,
  6, 14, 22, 30, 6, 14, 22, 30, 6, 14, 22, 30, 6, 14, 22, 30, 6, 14, 22, 30, 6, 14, 22, 30,
  23, 31, 7, 15, 23, 31, 7, 15, 23, 31, 7, 15, 23, 31, 7, 15, 23, 31, 7, 15, 23, 31, 7, 15,
  8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0, 8, 16, 24, 0,
  25, 1, 9, 17, 25, 1, 9, 17, 25, 1, 9, 17, 25, 1, 9, 17, 25, 1, 9, 17, 25, 1, 9, 17,
  10, 18, 26, 2, 10, 18, 26, 2, 10, 18, 26, 2, 10, 18, 26, 2, 10, 18, 26, 2, 10, 18, 26, 2
};
//-----------------
// The Camellia s-boxes

static const byte Camellia_s1[256] =
{
  112,130,44,236,179,39,192,229,228,133,87,53,234,12,174,65,
  35,239,107,147,69,25,165,33,237,14,79,78,29,101,146,189,
  134,184,175,143,124,235,31,206,62,48,220,95,94,197,11,26,
  166,225,57,202,213,71,93,61,217,1,90,214,81,86,108,77,
  139,13,154,102,251,204,176,45,116,18,43,32,240,177,132,153,
  223,76,203,194,52,126,118,5,109,183,169,49,209,23,4,215,
  20,88,58,97,222,27,17,28,50,15,156,22,83,24,242,34,
  254,68,207,178,195,181,122,145,36,8,232,168,96,252,105,80,
  170,208,160,125,161,137,98,151,84,91,30,149,224,255,100,210,
  16,196,0,72,163,247,117,219,138,3,230,218,9,63,221,148,
  135,92,131,2,205,74,144,51,115,103,246,243,157,127,191,226,
  82,155,216,38,200,55,198,59,129,150,111,75,19,190,99,46,
  233,121,167,140,159,110,188,142,41,245,249,182,47,253,180,89,
  120,152,6,106,231,70,113,186,212,37,171,66,136,162,141,250,
  114,7,185,85,248,238,172,10,54,73,42,104,60,56,241,164,
  64,40,211,123,187,201,67,193,21,227,173,244,119,199,128,158
};

static const byte Camellia_s2[256] =
{
  224,5,88,217,103,78,129,203,201,11,174,106,213,24,93,130,
  70,223,214,39,138,50,75,66,219,28,158,156,58,202,37,123,
  13,113,95,31,248,215,62,157,124,96,185,190,188,139,22,52,
  77,195,114,149,171,142,186,122,179,2,180,173,162,172,216,154,
  23,26,53,204,247,153,97,90,232,36,86,64,225,99,9,51,
  191,152,151,133,104,252,236,10,218,111,83,98,163,46,8,175,
  40,176,116,194,189,54,34,56,100,30,57,44,166,48,229,68,
  253,136,159,101,135,107,244,35,72,16,209,81,192,249,210,160,
  85,161,65,250,67,19,196,47,168,182,60,43,193,255,200,165,
  32,137,0,144,71,239,234,183,21,6,205,181,18,126,187,41,
  15,184,7,4,155,148,33,102,230,206,237,231,59,254,127,197,
  164,55,177,76,145,110,141,118,3,45,222,150,38,125,198,92,
  211,242,79,25,63,220,121,29,82,235,243,109,94,251,105,178,
  240,49,12,212,207,140,226,117,169,74,87,132,17,69,27,245,
  228,14,115,170,241,221,89,20,108,146,84,208,120,112,227,73,
  128,80,167,246,119,147,134,131,42,199,91,233,238,143,1,61
};

static const byte Camellia_s3[256] =
{
  56,65,22,118,217,147,96,242,114,194,171,154,117,6,87,160,
  145,247,181,201,162,140,210,144,246,7,167,39,142,178,73,222,
  67,92,215,199,62,245,143,103,31,24,110,175,47,226,133,13,
  83,240,156,101,234,163,174,158,236,128,45,107,168,43,54,166,
  197,134,77,51,253,102,88,150,58,9,149,16,120,216,66,204,
  239,38,229,97,26,63,59,130,182,219,212,152,232,139,2,235,
  10,44,29,176,111,141,136,14,25,135,78,11,169,12,121,17,
  127,34,231,89,225,218,61,200,18,4,116,84,48,126,180,40,
  85,104,80,190,208,196,49,203,42,173,15,202,112,255,50,105,
  8,98,0,36,209,251,186,237,69,129,115,109,132,159,238,74,
  195,46,193,1,230,37,72,153,185,179,123,249,206,191,223,113,
  41,205,108,19,100,155,99,157,192,75,183,165,137,95,177,23,
  244,188,211,70,207,55,94,71,148,250,252,91,151,254,90,172,
  60,76,3,53,243,35,184,93,106,146,213,33,68,81,198,125,
  57,131,220,170,124,119,86,5,27,164,21,52,30,28,248,82,
  32,20,233,189,221,228,161,224,138,241,214,122,187,227,64,79
};

static const byte Camellia_s4[256] =
{
  112,44,179,192,228,87,234,174,35,107,69,165,237,79,29,146,
  134,175,124,31,62,220,94,11,166,57,213,93,217,90,81,108,
  139,154,251,176,116,43,240,132,223,203,52,118,109,169,209,4,
  20,58,222,17,50,156,83,242,254,207,195,122,36,232,96,105,
  170,160,161,98,84,30,224,100,16,0,163,117,138,230,9,221,
  135,131,205,144,115,246,157,191,82,216,200,198,129,111,19,99,
  233,167,159,188,41,249,47,180,120,6,231,113,212,171,136,141,
  114,185,248,172,54,42,60,241,64,211,187,67,21,173,119,128,
  130,236,39,229,133,53,12,65,239,147,25,33,14,78,101,189,
  184,143,235,206,48,95,197,26,225,202,71,61,1,214,86,77,
  13,102,204,45,18,32,177,153,76,194,126,5,183,49,23,215,
  88,97,27,28,15,22,24,34,68,178,181,145,8,168,252,80,
  208,125,137,151,91,149,255,210,196,72,247,219,3,218,63,148,
  92,2,74,51,103,243,127,226,155,38,55,59,150,75,190,46,
  121,140,110,142,245,182,253,89,152,106,70,186,37,66,162,250,
  7,85,238,10,73,104,56,164,40,123,201,193,227,244,199,158
};
//-------------------

static const word32 Blowfish_p_init[] =
{
  608135816U, 2242054355U,  320440878U,   57701188U,
 2752067618U,  698298832U,  137296536U, 3964562569U,
 1160258022U,  953160567U, 3193202383U,  887688300U,
 3232508343U, 3380367581U, 1065670069U, 3041331479U,
 2450970073U, 2306472731U
};

static const word32 Blowfish_s_init[4*256] =
{
  3509652390U, 2564797868U,  805139163U, 3491422135U,
  3101798381U, 1780907670U, 3128725573U, 4046225305U,
   614570311U, 3012652279U,  134345442U, 2240740374U,
  1667834072U, 1901547113U, 2757295779U, 4103290238U,
   227898511U, 1921955416U, 1904987480U, 2182433518U,
  2069144605U, 3260701109U, 2620446009U,  720527379U,
  3318853667U,  677414384U, 3393288472U, 3101374703U,
  2390351024U, 1614419982U, 1822297739U, 2954791486U,
  3608508353U, 3174124327U, 2024746970U, 1432378464U,
  3864339955U, 2857741204U, 1464375394U, 1676153920U,
  1439316330U,  715854006U, 3033291828U,  289532110U,
  2706671279U, 2087905683U, 3018724369U, 1668267050U,
   732546397U, 1947742710U, 3462151702U, 2609353502U,
  2950085171U, 1814351708U, 2050118529U,  680887927U,
   999245976U, 1800124847U, 3300911131U, 1713906067U,
  1641548236U, 4213287313U, 1216130144U, 1575780402U,
  4018429277U, 3917837745U, 3693486850U, 3949271944U,
   596196993U, 3549867205U,  258830323U, 2213823033U,
   772490370U, 2760122372U, 1774776394U, 2652871518U,
   566650946U, 4142492826U, 1728879713U, 2882767088U,
  1783734482U, 3629395816U, 2517608232U, 2874225571U,
  1861159788U,  326777828U, 3124490320U, 2130389656U,
  2716951837U,  967770486U, 1724537150U, 2185432712U,
  2364442137U, 1164943284U, 2105845187U,  998989502U,
  3765401048U, 2244026483U, 1075463327U, 1455516326U,
  1322494562U,  910128902U,  469688178U, 1117454909U,
   936433444U, 3490320968U, 3675253459U, 1240580251U,
   122909385U, 2157517691U,  634681816U, 4142456567U,
  3825094682U, 3061402683U, 2540495037U,   79693498U,
  3249098678U, 1084186820U, 1583128258U,  426386531U,
  1761308591U, 1047286709U,  322548459U,  995290223U,
  1845252383U, 2603652396U, 3431023940U, 2942221577U,
  3202600964U, 3727903485U, 1712269319U,  422464435U,
  3234572375U, 1170764815U, 3523960633U, 3117677531U,
  1434042557U,  442511882U, 3600875718U, 1076654713U,
  1738483198U, 4213154764U, 2393238008U, 3677496056U,
  1014306527U, 4251020053U,  793779912U, 2902807211U,
   842905082U, 4246964064U, 1395751752U, 1040244610U,
  2656851899U, 3396308128U,  445077038U, 3742853595U,
  3577915638U,  679411651U, 2892444358U, 2354009459U,
  1767581616U, 3150600392U, 3791627101U, 3102740896U,
   284835224U, 4246832056U, 1258075500U,  768725851U,
  2589189241U, 3069724005U, 3532540348U, 1274779536U,
  3789419226U, 2764799539U, 1660621633U, 3471099624U,
  4011903706U,  913787905U, 3497959166U,  737222580U,
  2514213453U, 2928710040U, 3937242737U, 1804850592U,
  3499020752U, 2949064160U, 2386320175U, 2390070455U,
  2415321851U, 4061277028U, 2290661394U, 2416832540U,
  1336762016U, 1754252060U, 3520065937U, 3014181293U,
   791618072U, 3188594551U, 3933548030U, 2332172193U,
  3852520463U, 3043980520U,  413987798U, 3465142937U,
  3030929376U, 4245938359U, 2093235073U, 3534596313U,
   375366246U, 2157278981U, 2479649556U,  555357303U,
  3870105701U, 2008414854U, 3344188149U, 4221384143U,
  3956125452U, 2067696032U, 3594591187U, 2921233993U,
     2428461U,  544322398U,  577241275U, 1471733935U,
   610547355U, 4027169054U, 1432588573U, 1507829418U,
  2025931657U, 3646575487U,  545086370U,   48609733U,
  2200306550U, 1653985193U,  298326376U, 1316178497U,
  3007786442U, 2064951626U,  458293330U, 2589141269U,
  3591329599U, 3164325604U,  727753846U, 2179363840U,
   146436021U, 1461446943U, 4069977195U,  705550613U,
  3059967265U, 3887724982U, 4281599278U, 3313849956U,
  1404054877U, 2845806497U,  146425753U, 1854211946U,

  1266315497U, 3048417604U, 3681880366U, 3289982499U,
  2909710000U, 1235738493U, 2632868024U, 2414719590U,
  3970600049U, 1771706367U, 1449415276U, 3266420449U,
   422970021U, 1963543593U, 2690192192U, 3826793022U,
  1062508698U, 1531092325U, 1804592342U, 2583117782U,
  2714934279U, 4024971509U, 1294809318U, 4028980673U,
  1289560198U, 2221992742U, 1669523910U,   35572830U,
   157838143U, 1052438473U, 1016535060U, 1802137761U,
  1753167236U, 1386275462U, 3080475397U, 2857371447U,
  1040679964U, 2145300060U, 2390574316U, 1461121720U,
  2956646967U, 4031777805U, 4028374788U,   33600511U,
  2920084762U, 1018524850U,  629373528U, 3691585981U,
  3515945977U, 2091462646U, 2486323059U,  586499841U,
   988145025U,  935516892U, 3367335476U, 2599673255U,
  2839830854U,  265290510U, 3972581182U, 2759138881U,
  3795373465U, 1005194799U,  847297441U,  406762289U,
  1314163512U, 1332590856U, 1866599683U, 4127851711U,
   750260880U,  613907577U, 1450815602U, 3165620655U,
  3734664991U, 3650291728U, 3012275730U, 3704569646U,
  1427272223U,  778793252U, 1343938022U, 2676280711U,
  2052605720U, 1946737175U, 3164576444U, 3914038668U,
  3967478842U, 3682934266U, 1661551462U, 3294938066U,
  4011595847U,  840292616U, 3712170807U,  616741398U,
   312560963U,  711312465U, 1351876610U,  322626781U,
  1910503582U,  271666773U, 2175563734U, 1594956187U,
    70604529U, 3617834859U, 1007753275U, 1495573769U,
  4069517037U, 2549218298U, 2663038764U,  504708206U,
  2263041392U, 3941167025U, 2249088522U, 1514023603U,
  1998579484U, 1312622330U,  694541497U, 2582060303U,
  2151582166U, 1382467621U,  776784248U, 2618340202U,
  3323268794U, 2497899128U, 2784771155U,  503983604U,
  4076293799U,  907881277U,  423175695U,  432175456U,
  1378068232U, 4145222326U, 3954048622U, 3938656102U,
  3820766613U, 2793130115U, 2977904593U,   26017576U,
  3274890735U, 3194772133U, 1700274565U, 1756076034U,
  4006520079U, 3677328699U,  720338349U, 1533947780U,
   354530856U,  688349552U, 3973924725U, 1637815568U,
   332179504U, 3949051286U,   53804574U, 2852348879U,
  3044236432U, 1282449977U, 3583942155U, 3416972820U,
  4006381244U, 1617046695U, 2628476075U, 3002303598U,
  1686838959U,  431878346U, 2686675385U, 1700445008U,
  1080580658U, 1009431731U,  832498133U, 3223435511U,
  2605976345U, 2271191193U, 2516031870U, 1648197032U,
  4164389018U, 2548247927U,  300782431U,  375919233U,
   238389289U, 3353747414U, 2531188641U, 2019080857U,
  1475708069U,  455242339U, 2609103871U,  448939670U,
  3451063019U, 1395535956U, 2413381860U, 1841049896U,
  1491858159U,  885456874U, 4264095073U, 4001119347U,
  1565136089U, 3898914787U, 1108368660U,  540939232U,
  1173283510U, 2745871338U, 3681308437U, 4207628240U,
  3343053890U, 4016749493U, 1699691293U, 1103962373U,
  3625875870U, 2256883143U, 3830138730U, 1031889488U,
  3479347698U, 1535977030U, 4236805024U, 3251091107U,
  2132092099U, 1774941330U, 1199868427U, 1452454533U,
   157007616U, 2904115357U,  342012276U,  595725824U,
  1480756522U,  206960106U,  497939518U,  591360097U,
   863170706U, 2375253569U, 3596610801U, 1814182875U,
  2094937945U, 3421402208U, 1082520231U, 3463918190U,
  2785509508U,  435703966U, 3908032597U, 1641649973U,
  2842273706U, 3305899714U, 1510255612U, 2148256476U,
  2655287854U, 3276092548U, 4258621189U,  236887753U,
  3681803219U,  274041037U, 1734335097U, 3815195456U,
  3317970021U, 1899903192U, 1026095262U, 4050517792U,
   356393447U, 2410691914U, 3873677099U, 3682840055U,

  3913112168U, 2491498743U, 4132185628U, 2489919796U,
  1091903735U, 1979897079U, 3170134830U, 3567386728U,
  3557303409U,  857797738U, 1136121015U, 1342202287U,
   507115054U, 2535736646U,  337727348U, 3213592640U,
  1301675037U, 2528481711U, 1895095763U, 1721773893U,
  3216771564U,   62756741U, 2142006736U,  835421444U,
  2531993523U, 1442658625U, 3659876326U, 2882144922U,
   676362277U, 1392781812U,  170690266U, 3921047035U,
  1759253602U, 3611846912U, 1745797284U,  664899054U,
  1329594018U, 3901205900U, 3045908486U, 2062866102U,
  2865634940U, 3543621612U, 3464012697U, 1080764994U,
   553557557U, 3656615353U, 3996768171U,  991055499U,
   499776247U, 1265440854U,  648242737U, 3940784050U,
   980351604U, 3713745714U, 1749149687U, 3396870395U,
  4211799374U, 3640570775U, 1161844396U, 3125318951U,
  1431517754U,  545492359U, 4268468663U, 3499529547U,
  1437099964U, 2702547544U, 3433638243U, 2581715763U,
  2787789398U, 1060185593U, 1593081372U, 2418618748U,
  4260947970U,   69676912U, 2159744348U,   86519011U,
  2512459080U, 3838209314U, 1220612927U, 3339683548U,
   133810670U, 1090789135U, 1078426020U, 1569222167U,
   845107691U, 3583754449U, 4072456591U, 1091646820U,
   628848692U, 1613405280U, 3757631651U,  526609435U,
   236106946U,   48312990U, 2942717905U, 3402727701U,
  1797494240U,  859738849U,  992217954U, 4005476642U,
  2243076622U, 3870952857U, 3732016268U,  765654824U,
  3490871365U, 2511836413U, 1685915746U, 3888969200U,
  1414112111U, 2273134842U, 3281911079U, 4080962846U,
   172450625U, 2569994100U,  980381355U, 4109958455U,
  2819808352U, 2716589560U, 2568741196U, 3681446669U,
  3329971472U, 1835478071U,  660984891U, 3704678404U,
  4045999559U, 3422617507U, 3040415634U, 1762651403U,
  1719377915U, 3470491036U, 2693910283U, 3642056355U,
  3138596744U, 1364962596U, 2073328063U, 1983633131U,
   926494387U, 3423689081U, 2150032023U, 4096667949U,
  1749200295U, 3328846651U,  309677260U, 2016342300U,
  1779581495U, 3079819751U,  111262694U, 1274766160U,
   443224088U,  298511866U, 1025883608U, 3806446537U,
  1145181785U,  168956806U, 3641502830U, 3584813610U,
  1689216846U, 3666258015U, 3200248200U, 1692713982U,
  2646376535U, 4042768518U, 1618508792U, 1610833997U,
  3523052358U, 4130873264U, 2001055236U, 3610705100U,
  2202168115U, 4028541809U, 2961195399U, 1006657119U,
  2006996926U, 3186142756U, 1430667929U, 3210227297U,
  1314452623U, 4074634658U, 4101304120U, 2273951170U,
  1399257539U, 3367210612U, 3027628629U, 1190975929U,
  2062231137U, 2333990788U, 2221543033U, 2438960610U,
  1181637006U,  548689776U, 2362791313U, 3372408396U,
  3104550113U, 3145860560U,  296247880U, 1970579870U,
  3078560182U, 3769228297U, 1714227617U, 3291629107U,
  3898220290U,  166772364U, 1251581989U,  493813264U,
   448347421U,  195405023U, 2709975567U,  677966185U,
  3703036547U, 1463355134U, 2715995803U, 1338867538U,
  1343315457U, 2802222074U, 2684532164U,  233230375U,
  2599980071U, 2000651841U, 3277868038U, 1638401717U,
  4028070440U, 3237316320U,    6314154U,  819756386U,
   300326615U,  590932579U, 1405279636U, 3267499572U,
  3150704214U, 2428286686U, 3959192993U, 3461946742U,
  1862657033U, 1266418056U,  963775037U, 2089974820U,
  2263052895U, 1917689273U,  448879540U, 3550394620U,
  3981727096U,  150775221U, 3627908307U, 1303187396U,
   508620638U, 2975983352U, 2726630617U, 1817252668U,
  1876281319U, 1457606340U,  908771278U, 3720792119U,
  3617206836U, 2455994898U, 1729034894U, 1080033504U,

   976866871U, 3556439503U, 2881648439U, 1522871579U,
  1555064734U, 1336096578U, 3548522304U, 2579274686U,
  3574697629U, 3205460757U, 3593280638U, 3338716283U,
  3079412587U,  564236357U, 2993598910U, 1781952180U,
  1464380207U, 3163844217U, 3332601554U, 1699332808U,
  1393555694U, 1183702653U, 3581086237U, 1288719814U,
   691649499U, 2847557200U, 2895455976U, 3193889540U,
  2717570544U, 1781354906U, 1676643554U, 2592534050U,
  3230253752U, 1126444790U, 2770207658U, 2633158820U,
  2210423226U, 2615765581U, 2414155088U, 3127139286U,
   673620729U, 2805611233U, 1269405062U, 4015350505U,
  3341807571U, 4149409754U, 1057255273U, 2012875353U,
  2162469141U, 2276492801U, 2601117357U,  993977747U,
  3918593370U, 2654263191U,  753973209U,   36408145U,
  2530585658U,   25011837U, 3520020182U, 2088578344U,
   530523599U, 2918365339U, 1524020338U, 1518925132U,
  3760827505U, 3759777254U, 1202760957U, 3985898139U,
  3906192525U,  674977740U, 4174734889U, 2031300136U,
  2019492241U, 3983892565U, 4153806404U, 3822280332U,
   352677332U, 2297720250U,   60907813U,   90501309U,
  3286998549U, 1016092578U, 2535922412U, 2839152426U,
   457141659U,  509813237U, 4120667899U,  652014361U,
  1966332200U, 2975202805U,   55981186U, 2327461051U,
   676427537U, 3255491064U, 2882294119U, 3433927263U,
  1307055953U,  942726286U,  933058658U, 2468411793U,
  3933900994U, 4215176142U, 1361170020U, 2001714738U,
  2830558078U, 3274259782U, 1222529897U, 1679025792U,
  2729314320U, 3714953764U, 1770335741U,  151462246U,
  3013232138U, 1682292957U, 1483529935U,  471910574U,
  1539241949U,  458788160U, 3436315007U, 1807016891U,
  3718408830U,  978976581U, 1043663428U, 3165965781U,
  1927990952U, 4200891579U, 2372276910U, 3208408903U,
  3533431907U, 1412390302U, 2931980059U, 4132332400U,
  1947078029U, 3881505623U, 4168226417U, 2941484381U,
  1077988104U, 1320477388U,  886195818U,   18198404U,
  3786409000U, 2509781533U,  112762804U, 3463356488U,
  1866414978U,  891333506U,   18488651U,  661792760U,
  1628790961U, 3885187036U, 3141171499U,  876946877U,
  2693282273U, 1372485963U,  791857591U, 2686433993U,
  3759982718U, 3167212022U, 3472953795U, 2716379847U,
   445679433U, 3561995674U, 3504004811U, 3574258232U,
    54117162U, 3331405415U, 2381918588U, 3769707343U,
  4154350007U, 1140177722U, 4074052095U,  668550556U,
  3214352940U,  367459370U,  261225585U, 2610173221U,
  4209349473U, 3468074219U, 3265815641U,  314222801U,
  3066103646U, 3808782860U,  282218597U, 3406013506U,
  3773591054U,  379116347U, 1285071038U,  846784868U,
  2669647154U, 3771962079U, 3550491691U, 2305946142U,
   453669953U, 1268987020U, 3317592352U, 3279303384U,
  3744833421U, 2610507566U, 3859509063U,  266596637U,
  3847019092U,  517658769U, 3462560207U, 3443424879U,
   370717030U, 4247526661U, 2224018117U, 4143653529U,
  4112773975U, 2788324899U, 2477274417U, 1456262402U,
  2901442914U, 1517677493U, 1846949527U, 2295493580U,
  3734397586U, 2176403920U, 1280348187U, 1908823572U,
  3871786941U,  846861322U, 1172426758U, 3287448474U,
  3383383037U, 1655181056U, 3139813346U,  901632758U,
  1897031941U, 2986607138U, 3066810236U, 3447102507U,
  1393639104U,  373351379U,  950779232U,  625454576U,
  3124240540U, 4148612726U, 2007998917U,  544563296U,
  2244738638U, 2330496472U, 2058025392U, 1291430526U,
   424198748U,   50039436U,   29584100U, 3605783033U,
  2429876329U, 2791104160U, 1057563949U, 3255363231U,
  3075367218U, 3463963227U, 1469046755U,  985887462U
};
//----------------

const array_info_t non_sparse_consts[] =
{
  { ARR(Blowfish_p_init),                 "Blowfish"       },
  { ARR(Blowfish_s_init),                 "Blowfish"       },
  { ARR(Camellia_s1),                     "Camellia"       },
  { ARR(Camellia_s2),                     "Camellia"       },
  { ARR(Camellia_s3),                     "Camellia"       },
  { ARR(Camellia_s4),                     "Camellia"       },
  { ARR(CAST_S),                          "CAST"           },
  { ARR(CAST256_t_m),                     "CAST256"        },
  { ARR(CAST256_t_r),                     "CAST256"        },
  { ARR(CRC32_m_tab),                     "CRC32"          },
  { ARR(DES_ei),                          "DES"            },
  { ARR(DES_fp),                          "DES"            },
  { ARR(DES_ip),                          "DES"            },
  { ARR(DES_p32i),                        "DES"            },
  { ARR(DES_pc1),                         "DES"            },
  { ARR(DES_pc2),                         "DES"            },
  { ARR(DES_sbox),                        "DES"            },
  { ARR(GOST_sBox),                       "GOST"           },
  { ARR(HAVAL_mc2),                       "HAVAL"          },
  { ARR(HAVAL_mc3),                       "HAVAL"          },
  { ARR(HAVAL_mc4),                       "HAVAL"          },
  { ARR(HAVAL_mc5),                       "HAVAL"          },
  { ARR(HAVAL_wi2),                       "HAVAL"          },
  { ARR(HAVAL_wi3),                       "HAVAL"          },
  { ARR(HAVAL_wi4),                       "HAVAL"          },
  { ARR(HAVAL_wi5),                       "HAVAL"          },
  { ARR(MARS_Sbox),                       "MARS"           },
  { ARR(MD2_S),                           "MD2"            },
  { ARR(MD5MAC_T),                        "MD5"            },
  { ARR(PKCS_DigestDecoration_MD2),       "PKCS_MD2"       },
  { ARR(PKCS_DigestDecoration_MD5),       "PKCS_MD5"       },
  { ARR(PKCS_DigestDecoration_RIPEMD160), "PKCS_RIPEMD160" },
  { ARR(PKCS_DigestDecoration_SHA256),    "PKCS_SHA256"    },
  { ARR(PKCS_DigestDecoration_SHA384),    "PKCS_SHA384"    },
  { ARR(PKCS_DigestDecoration_SHA512),    "PKCS_SHA512"    },
  { ARR(PKCS_DigestDecoration_Tiger),     "PKCS_Tiger"     },
  { ARR(RawDES_Spbox),                    "RawDES"         },
  { ARR(rc2_PITABLE),                     "RC2"            },
  { ARR(Rijndael_Td0),                    "Rijndael"       },
  { ARR(Rijndael_Td1),                    "Rijndael"       },
  { ARR(Rijndael_Td2),                    "Rijndael"       },
  { ARR(Rijndael_Td3),                    "Rijndael"       },
  { ARR(Rijndael_Td4),                    "Rijndael"       },
  { ARR(Rijndael_Te0),                    "Rijndael"       },
  { ARR(Rijndael_Te1),                    "Rijndael"       },
  { ARR(Rijndael_Te2),                    "Rijndael"       },
  { ARR(Rijndael_Te3),                    "Rijndael"       },
  { ARR(Rijndael_Te4),                    "Rijndael"       },
  { ARR(SAFER_exp_tab),                   "SAFER"          },
  { ARR(SAFER_log_tab),                   "SAFER"          },
  { ARR(SHA256_K),                        "SHA256"         },
  { ARR(SHA512_K),                        "SHA512"         },
  { ARR(SHARK_dec_cbox),                  "SHARK"          },
  { ARR(SHARK_enc_cbox),                  "SHARK"          },
  { ARR(SHARK_iG),                        "SHARK"          },
  { ARR(SKIPJACK_fTable),                 "SKIPJACK"       },
  { ARR(Square_Sd_or_SHARK_dec_sbox),     "Square/SHARK"   },
  { ARR(Square_Se_or_SHARK_enc_sbox),     "Square/SHARK"   },
  { ARR(Square_Td),                       "Square"         },
  { ARR(Square_Te),                       "Square"         },
  { ARR(Tiger_table),                     "Tiger"          },
  { ARR(Twofish_mds),                     "Twofish"        },
  { ARR(Twofish_q),                       "Twofish"        },
  { ARR(WAKE_tt),                         "WAKE"           },
  { ARR(Whirlpool_C0),                    "Whirlpool"      },
  { ARR(Whirlpool_C1),                    "Whirlpool"      },
  { ARR(Whirlpool_C2),                    "Whirlpool"      },
  { ARR(Whirlpool_C3),                    "Whirlpool"      },
  { ARR(Whirlpool_rc),                    "Whirlpool"      },
  { ARR(zdeflate_lengthCodes),            "zlib"           },
  { ARR(zinflate_distanceExtraBits),      "zlib"           },
  { ARR(zinflate_distanceStarts),         "zlib"           },
  { ARR(zinflate_lengthExtraBits),        "zlib"           },
  { ARR(zinflate_lengthStarts),           "zlib"           },
  { NULL, 0, 0, NULL, NULL }
};
