---
title: Hue 4.7 とその改善点が公開されました!
author: Hue Team
type: post
date: 2020-04-10T02:36:35+00:00
url: /blog/hue-4-7-and-its-improvements-are-out/
sf_thumbnail_type:
  - none
sf_thumbnail_link_type:
  - link_to_post
sf_detail_type:
  - none
sf_page_title:
  - 1
sf_page_title_style:
  - standard
sf_no_breadcrumbs:
  - 1
sf_page_title_bg:
  - none
sf_page_title_text_style:
  - light
sf_background_image_size:
  - cover
sf_social_sharing:
  - 1
sf_related_articles:
  - 1
sf_sidebar_config:
  - left-sidebar
sf_left_sidebar:
  - Sidebar-2
sf_right_sidebar:
  - Sidebar-1
sf_caption_position:
  - caption-right
sf_remove_promo_bar:
  - 1
ampforwp-amp-on-off:
  - default
categories:
  - Version 4.7
  - Release

---
データ探検家の皆さん、

&nbsp;

Hue チームは全ての貢献者に感謝し、Hue 4.7 のリリースを喜ばしく思っています。

<img class="" src="https://cdn.gethue.com/uploads/2015/08/hue-logo-copy.png" alt="hue-logo" width="85" height="63" />

&nbsp;

今回のリリースは[ver 4.6](https://gethue.com/hue-4-6-and-its-improvements-are-out/) の上に構築し続けており、技術スタックをモジュール化し、SQL の統合を改善し、Hue 5 の主要機能の準備に焦点を当てました。いくつかのハイライトを紹介します。

* 一番上の青色のボタンを左側のメニューに変換
* 10周年: [10 years of Hue!](https://gethue.com/blog/2020-01-28-ten-years-data-querying-ux-evolution/)
* 独自または[SQL パーサー](https://docs.gethue.com/developer/parsers/)の改善
* 日本語ブログが復活 https://jp.gethue.com/
* [データウェアハウスのUX](https://gethue.com/blog/2020-02-10-sql-query-experience-of-your-cloud-data-warehouse/) の概要を公開


このリリースには650以上のコミットと100以上のバグ修正が含まれています。全ての変更点は[リリースノート](https://docs.gethue.com/releases/release-notes-4.7.0/) をご確認ください。

是非手にとって試してみてください！

* Docker
    ```
    docker run -it -p 8888:8888 gethue/4.7.0
    ```
* Kubernetes :
    ```
    helm repo add gethue https://helm.gethue.com
    helm repo update
    helm install gethue/hue
    ```
* [demo.gethue.com](demo.gethue.com)
* [Tarball](https://cdn.gethue.com/downloads/hue-4.7.0.tgz) または [source](https://github.com/cloudera/hue/archive/release-4.7.0.zip)

<a href="https://cdn.gethue.com/uploads/2020/04/hue-4.7.png">
  <img src="https://cdn.gethue.com/uploads/2020/04/hue-4.7.png" />
</a>

</br>
</br>
</br>

以下、改善点の一部をご紹介します。

## SQL

* SQL の左側のアシストに[外部キー](https://gethue.com/2019-11-13-sql-column-assist-icons/) を表示
* 自動補完の構文を更新: INTEGER, CTAS, STREAM keyword, EXPLAIN, LOAD, SHOW MATERIALIZED VIEW, ALTER MATERIALIZED VIEW,  DROP MATERIALIZED VIEW
* マテリアライズドビューは「目」のアイコンで適切に表示
* 複数クエリの同時実行をサポートするためにHive LLAP/Tez のセッション管理を刷新
* SQL の左側のアシストからのドラッグ＆ドロップの不具合を修正
* SQL のサンプルがミュータブルなテーブル(INSERT, DELETE, UPDATE.. などのORC形式のテーブル)でも動作するように
* [SQL 自動補完のチュートリアル](https://docs.gethue.com/developer/parsers/) を更新
* SQL 自動補完のパーサーは、従来の`npm install` でプラグイン可能な[JavaScript コンポーネント](https://jp.gethue.com/blog/2020-02-27-using-sql-parser-module/) として利用できるように

![Foreign Keys](https://cdn.gethue.com/uploads/2019/11/sql_columns_assist_keys.png)

## コラボレーション

* クエリのスニペットは独自のSlackのプレビューを使用して[Gist](https://jp.gethue.com/blog/2020-03-04-datawarehouse-database-sql-collaboration-and-sharing-with-link-and-gist/#sql-snippet---gist) 経由で共有可能に
* クエリは[公開リンク](https://jp.gethue.com/blog/2020-03-04-datawarehouse-database-sql-collaboration-and-sharing-with-link-and-gist/#public-links)で共有可能に
* リンク共有モーダルを[親しみやすい](https://cdn.gethue.com/uploads/2020/04/4.7_sharing_popup.png)ものに変更

![Query Gist](https://cdn.gethue.com/uploads/2020/03/editor_gist_slack.png)

![Query Sharing](https://cdn.gethue.com/uploads/2020/03/editor_sharing_popup.png)

## インフラ

* [Azure ABFS filesystem](https://gethue.com/integration-with-microsoft-azure-data-lake-store-gen2/) を正式にサポート
* 継続的統合(CI)は[docs.gethue.com](https://docs.gethue.com/)の[リンク切れをチェック](https://jp.gethue.com/checking-dead-links-automatically-continuous-integration/) 
* Python 3: 対応作業が進行中。コンパイルとフィードバックの送信方法:
  ```
  export PYTHON_VER=python3.6
  make apps
  ```

![ABFS connector](https://cdn.gethue.com/uploads/2020/04/4.7_filebrowser_abfs.png)

## 管理、運用

* [フィルタを使用](https://cdn.gethue.com/uploads/2020/04/4.7_admin_config_filter.png)して設定を検索
* ユーザーの削除フローを削除ではなく無効化するように変更(保存されたドキュメントやクエリを失わないようにするため)
* ユーザー管理ページに[ACTIVEとSUPERUSER](https://cdn.gethue.com/uploads/2020/04/4.7_admin_users_status.png) のステータスが表示されるように変更
* API インスタンスごとの[アクティブユーザー数](https://jp.gethue.com/hue-active-users-metric-improvements/) を改訂

![Active user](https://cdn.gethue.com/uploads/2020/04/cm_active_users.png)

## 進捗

* [HUE-8768](https://issues.cloudera.org/browse/HUE-8768) 複数の実行コンテキストとロバスト性を備えた新バージョンのエディターは200回以上のコミットを獲得しました
* [HUE-8758](https://issues.cloudera.org/browse/HUE-8758) hue.ini を使わないSQL コネクタの設定がMVPに近くなりました
* [HUE-8824](https://issues.cloudera.org/browse/HUE-8824) 最適かとカタログのAPIを公開
* [HUE-8738](https://issues.cloudera.org/browse/HUE-8738) Celery Task Server と SQL task が Python3 用に更新


フィードバックやご質問はありますか？こちら、または<a href="https://discourse.gethue.com/">フォーラム</a> and <a href="https://docs.gethue.com/quickstart/">quick start</a> で気軽にコメントして、SQLクエリのクイックスタートをしましょう！


さらに前に！
