---
title: Hue 4.6 とその改善点が公開されました!
author: Hue Team
type: post
date: 2019-12-05T02:36:35+00:00
url: /hue-4-6-and-its-improvements-are-out/
sf_thumbnail_type:
  - none
sf_thumbnail_link_type:
  - link_to_post
sf_detail_type:
  - none
sf_page_title:
  - 1
sf_page_title_style:
  - standard
sf_no_breadcrumbs:
  - 1
sf_page_title_bg:
  - none
sf_page_title_text_style:
  - light
sf_background_image_size:
  - cover
sf_social_sharing:
  - 1
sf_related_articles:
  - 1
sf_sidebar_config:
  - left-sidebar
sf_left_sidebar:
  - Sidebar-2
sf_right_sidebar:
  - Sidebar-1
sf_caption_position:
  - caption-right
sf_remove_promo_bar:
  - 1
ampforwp-amp-on-off:
  - default
categories:
  - Version 4
# - Version 4.6
  - Release

---
データ探検家の皆さん、

&nbsp;

Hue チームはすべての貢献者に感謝し、Hue 4.6 をリリースします!

<img class="" src="https://cdn.gethue.com/uploads/2015/08/hue-logo-copy.png" alt="hue-logo" width="85" height="63" />

&nbsp;

今回のリリースで集中的に行ったのは、ver 4.5 上での開発を続け、技術スタックをモジュール化し、SQL の統合を改善し、Hue 5 での今後の主要な機能を準備することでした。特に、今回は以下の点に集中しています。

* Python 3 サポートのテストができる
* 新しいバージョンの [gethue.com](https://jp.gethue.com) と、[docs.gethue.com](https://docs.gethue.com) の内容が刷新されました
* 複数の実行コンテキストとさらなる堅牢性を備えた、新しいバージョンのエディタが 66% ほど完了
* 独自パーサーまたは改善された [SQL parsers with highlighter](https://docs.gethue.com/developer/parsers/)


このリリースには、650 件以上のコミットと 100 以上のバグ修正が含まれています。すべての変更については [リリースノート](https://docs.gethue.com/releases/release-notes-4.6.0/) をご覧ください。

入手して試してください！

* Docker
    ```
    docker run -it -p 8888:8888 gethue/4.6.0
    ```
* Kubernetes :
    ```
    helm repo add gethue https://helm.gethue.com
    helm repo update
    helm install gethue/hue
    ```
* [demo.gethue.com](https://demo.gethue.com)
* [Tarball](https://cdn.gethue.com/downloads/hue-4.6.0.tgz) または [source](https://github.com/cloudera/hue/archive/release-4.6.0.zip)

<a href="https://cdn.gethue.com/uploads/2019/12/hue4.6.png">
  <img src="https://cdn.gethue.com/uploads/2019/12/hue4.6.png" />
</a>

改善点の一部を次に示します。

## SQL

* Apache Hive Tez の改善
* Apache Hive LLAP の改善
* Apache Atlas の[検索とカタログ情報](https://gethue.com/realtime-catalog-search-with-hue-and-apache-atlas/)が組み込みでプラグイン可能に
<!-- /realtime-catalog-search-with-hue-and-apache-atlas/ -->
* 自動補完
  * [Highlighter](https://gethue.com/how-to-improve-or-add-your-own-sql-syntax-highlighter/) による[新しい SQL パーサーを改善、作成する方法](https://docs.gethue.com/developer/parsers/) のチュートリアル
<!-- /how-to-improve-or-add-your-own-sql-syntax-highlighter/ -->
  * Apache Druid, Phoenix, Elastic Serch, Presto, KSQL, Calcite 用の専用パーサーのスケルトンを提供
* [アシストで表示される主キーとパーティションキーのアイコン](https://gethue.com/2019-11-13-sql-column-assist-icons/)
<!-- /2019-11-13-sql-column-assist-icons/ -->
* [SQL クエリトレーシング](https://gethue.com/introducing-request-tracing-with-opentracing-and-jaeger-in-kubernetes/)
<!--/introducing-request-tracing-with-opentracing-and-jaeger-in-kubernetes/ -->
* importer/サンプルでの[トランザクションテーブル](https://gethue.com/2019-11-13-sql-column-assist-icons/) のサポート
<-- /2019-11-13-sql-column-assist-icons/ -->
* [HUE-9055](https://issues.cloudera.org/browse/HUE-9055) 2.2 で INT の同義語として INTEGER を導入

## コラボレーション

* 共有アイコンと共有アクションが左側のアシスタントに表示されるようになった
* 結果のクリップボードへのコピーは、テーブルのフォーマットを適切に保持するようになった

## クラウド

* 以下の基本的な取得方法に関する 3 つのブログ記事:
  * [Tracing calls](https://gethue.com/introducing-request-tracing-with-opentracing-and-jaeger-in-kubernetes/)
  * [Retrieving and searching Logs](https://gethue.com/collecting-hue-metrics-with-prometheus-in-kubernetes/)
  * [Collecting health and performance Metrics](https://gethue.com/collecting-hue-metrics-with-prometheus-in-kubernetes/)
* Apache Knox と IdBroker の統合
* [Azure ADLS v2 / ABFS v1](http://localhost:1314/integration-with-microsoft-azure-data-lake-store-gen2/) の統合
* Google Storage コネクターのスケルトン
* [HUE-8983](https://issues.cloudera.org/browse/HUE-8983) S3 の ListAllMyBuckets 拒否の処理

<!-- /introducing-request-tracing-with-opentracing-and-jaeger-in-kubernetes/
/collecting-and-querying-hue-logs-with-fluentd-in-kubernetes/
https://gethue.com/collecting-hue-metrics-with-prometheus-in-kubernetes//integration-with-microsoft-azure-data-lake-store-gen2/
-->
## インフラ

* Python 3 の対応は進捗しており、ベータテストができるようになりました。py3-ci [CI ブランチ](https://circleci.com/gh/cloudera/hue/tree/py3-ci)。コンパイル方法とフィードバックの送り方:
  ```
  export PYTHON_VER=python3.6
  make apps
  ```
* Javascript のテストが Jest に切り替わり、ヘッドレスをサポートするようになった
* [docs.gethue.com](https://docs.gethue.com) を刷新
* [HUE-9023](https://issues.cloudera.org/browse/HUE-9023) [core] HTTP リクエストのコードとサイズを個別にロギング
* Oozie: コーディネータの同期アクションがプッシュされた
* Ko.js が最新の 3.5.1 に更新された

## バグ

* SQL エディタでの水平方向の結果スクロールバーの不安定な挙動の修正
* LDAP sync コマンドのパラメータの修正
* いくつかのダッシュボードのレイアウトの問題と IE 11 対応の修正
* [HUE-8727](https://issues.cloudera.org/browse/HUE-8727) ドキュメント支援で Chrome が自動補完するのを防ぐ
* [HUE-8983](https://issues.cloudera.org/browse/HUE-8983) S3 の ListAllMyBuckets 拒否の処理
* 'INVALIDATE METADATA' を使用するマルチクエリのステートメントを修正
* Impala のGRANT と REVOKE の構文を更新
* SQL エディタで、複数クエリ実行内の以前の 'USE database' ステートメントを尊重するように


フィードバックや質問は、ブログへのコメントや<a href="https://discourse.gethue.com/">フォーラム</a>まで。<a href="https://docs.gethue.com/quickstart/">クィックスタート</a> でSQLのクエリを！


その先へ!
