---
title: 10分でHadoopクラスタを作成するには?
author: Hue Team
type: post
date: 2014-04-23T01:47:23+00:00
url: /10分でhadoopクラスタを作成するには/
sf_thumbnail_type:
  - none
sf_thumbnail_link_type:
  - link_to_post
sf_detail_type:
  - none
sf_page_title:
  - 1
sf_page_title_style:
  - standard
sf_no_breadcrumbs:
  - 1
sf_page_title_bg:
  - none
sf_page_title_text_style:
  - light
sf_background_image_size:
  - cover
sf_custom_excerpt:
  - 私たちは、最近、1クリックで実際のHadoopクラスタを試すことができるdemo.cloudera.comを開始しました。下記は私たちがそれをどのように行ったかについて書いたものです。
sf_social_sharing:
  - 1
sf_sidebar_config:
  - left-sidebar
sf_left_sidebar:
  - Sidebar-2
sf_right_sidebar:
  - Sidebar-1
sf_caption_position:
  - caption-right
slide_template:
  - default
categories:
  - Administration
  - Enterprise
  - Tutorial
  - Video

---
<p id="docs-internal-guid-5f9e143b-5ded-3474-e3cb-2476b7aedb36" dir="ltr">
  私たちは、最近、<a href="https://gethue.com/hadoop-tutorial-live-demo-hadoop-directly-from-your-browser">1クリック</a>で実際のHadoopクラスタを試すことができる<a href="http://demo.gethue.com">demo.cloudera.com</a>を開始しました。下記は私たちがそれをどのように行ったかについて書いたものです。
</p>

<p dir="ltr">
  始める前に、あなたは何台かのマシンを入手する必要があります。Hadoopはコモディティハードウェアで実行されるので、メジャーなLinuxディストリビューションが動く普通のコンピュータで動作するはずです。デモを続けるために、Amazon Cloud Computing Serviceをちょっと見てみましょう。既にサーバーを1〜2台に持っている、あるいはローカルのLinuxマシンでHadoopを実行することなど気にしない場合は、そのままマシンのセットアップを行って下さい！
</p>

<p dir="ltr">
  これは、クラスタをブートし、データの演算を始めるのがいかに簡単であることかを示しているデモンストレーションビデオです!
</p>

{{< youtube MJYeiPt3r_0 >}}

<h1 dir="ltr">
  マシンのセットアップ
</h1>

<p dir="ltr">
  私たちは <a href="http://aws.amazon.com/">AWS</a> を選んで、OSにはUbuntu 12.04、100GBのストレージを持つ4つの<a href="https://aws.amazon.com/ec2/pricing/">m3.large</a> インスタンスを開始しました（デフォルトの8GBではなく）。低いパフォーマンスで良い場合は、一つのxlargeインスタンスで十分であり、またはさらに小さなインスタンスに少ないサービスをインストールすることができます。
</p>

<p dir="ltr">
  続いて以下のようにセキュリティグループを設定します。私たちはインスタンス間で全てを許可し（複数のマシンのクラスタであることを忘れないで下さい！）、外部にCloudera ManagerとHueのポートを解放しました。
</p>

<div dir="ltr">
  <table>
    <colgroup> <col width="163" /> <col width="103" /> <col width="89" /> <col width="269" /></colgroup> <tr>
      <td>
        <p dir="ltr">
          All TCP
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          TCP
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          0 &#8211; 65535
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          sg-e2db7777 (hue-demo)
        </p>
      </td>
    </tr>
    
    <tr>
      <td>
        <p dir="ltr">
          SSH
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          TCP
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          22
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          0.0.0.0/0
        </p>
      </td>
    </tr>
    
    <tr>
      <td>
        <p dir="ltr">
          Custom TCP Rule
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          TCP
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          7180
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          0.0.0.0/0
        </p>
      </td>
    </tr>
    
    <tr>
      <td>
        <p dir="ltr">
          Custom TCP Rule
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          TCP
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          8888
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          0.0.0.0/0
        </p>
      </td>
    </tr>
    
    <tr>
      <td>
        <p dir="ltr">
          Custom ICMP Rule
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          Echo Reply
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          N/A
        </p>
      </td>
      
      <td>
        <p dir="ltr">
          0.0.0.0/0
        </p>
      </td>
    </tr>
  </table>
</div>

<h1 dir="ltr">
  Hadoopのセットアップ
</h1>

<p dir="ltr">
  この時点で私たちは既に複数のマシンを手にしているので、Hadoopをインストールしましょう。私たちは全てのインストールにCloudera Managerを使用して、この<a href="http://www.cloudera.com/content/cloudera-content/cloudera-docs/CM5/latest/Cloudera-Manager-Installation-Guide/cm5ig_install_on_ec2.html#cmig_topic_8_1_unique_1">ガイド（英語）</a>に従いました。さらには、インストール後のモニタリングと設定も、管理インタフェースにより簡易化されています。
</p>

<p dir="ltr">
  最初にマシンの一つに接続することから始めます:
</p>

<pre><code class="bash">ssh -i ~/demo.pem ubuntu@ec2-11-222-333-444.compute-1.amazonaws.com</pre>

<p dir="ltr">
  Cloudera Managerを取得して開始します:
</p>

<pre><code class="bash">wget http://archive.cloudera.com/cm5/installer/latest/cloudera-manager-installer.bin
chmod +x ./cloudera-manager.bin
sudo ./cloudera-manager.bin</pre>

<p dir="ltr">
  デフォルトの資格である admin/admin でログインします。
</p>

<p dir="ltr">
  その後、インストールウィザードであなたのマシンの全てのパブリック DNS IP(例: ec2-11-222-333-444.compute-1.amazonaws.com) を入力し、Go!をクリックします。おめでとうございます。あなたのために、Cloudera Managerがクラスタ全体を自動的にセットアップしてくれるでしょう!
</p>

<p dir="ltr">
  dynamic IPをHueのマシンに割り当ててそのIPアドレスのポート番号8888にアクセスします。完全に機能しているHadoop クラスタで<a href="https://gethue.com/tutorials/">チュートリアル（英語）</a>と<a href="https://gethue.com/tutorial-live-demo-of-search-on-hadoop/">サンプル（英語）</a>を始めましょう！
</p>

<p dir="ltr">
  いつものように、<a href="http://groups.google.com/a/cloudera.org/group/hue-user">hue-user</a> メーリングリスト、または<a href="https://twitter.com/gethue"> @gethue</a>までお気軽にコメントして下さい！
</p>

<p dir="ltr">
  <strong>注意</strong>
</p>

<p dir="ltr">
  あなたが複数のマシンを持っている場合、メモリ/CPUの使用量が均一になるようにサービスを異動することを推奨します。例えば、HBase、Oozie、Hive、Solrを異なるホストに分けるようにします。
</p>

<p dir="ltr">
  <strong>注意</strong>
</p>

<p dir="ltr">
  YARNでいくつかのMapReduceジョブを実行する際、全てのジョブがACCEPTEDあるいはREADYステータスでデッドロックする場合、YARNのバグにヒットしているかもしれません。
</p>

<p dir="ltr">
  回避方法は、2〜3ぐらいの少ない数の動的リソース管理プール(Dynamic Resource manager Pool)を使用することです。 CM → Clusters → Other → Dynamic Resource Pools → Configuration → Edit → YARNに異動し、‘Max Running Apps’ を2に設定します。
</p>

<p style="text-align: center;">
  <a href="https://cdn.gethue.com/uploads/2014/04/cm-yarn-pool.png"><img class=" wp-image-1143 aligncenter" src="https://cdn.gethue.com/uploads/2014/04/cm-yarn-pool.png" alt="cm-yarn-pool" width="690" height="348" data-wp-pid="1143" /></a>
</p>

<p style="text-align: left;">
  同様に、yarn.nodemanager.resource.memory-mbとタスクのメモリを減らし、yarn.app.mapreduce.am.resource.mbを増やしてみることもできます。
</p>