---
title: チュートリアル：Impala用の優れたファイルフォーマットとHadoopの高速なSQL
author: Hue Team
type: post
date: 2013-10-23T23:59:45+00:00
url: /チュートリアル：impala用の優れたファイルフォーマ/
sf_thumbnail_type:
  - none
sf_thumbnail_link_type:
  - link_to_post
sf_detail_type:
  - none
sf_page_title:
  - 1
sf_page_title_style:
  - standard
sf_page_title_bg:
  - none
sf_page_title_text_style:
  - light
sf_background_image_size:
  - cover
sf_social_sharing:
  - 1
sf_sidebar_config:
  - left-sidebar
sf_left_sidebar:
  - Sidebar-2
sf_right_sidebar:
  - Sidebar-1
sf_caption_position:
  - caption-right
slide_template:
  - default
sf_custom_excerpt:
  - |
    Impalaのファイルフォーマット
    最適なファイルフォーマットを使用することは、優れたパフォーマンスを得るためには極めて重要です。これは、Impala アプリケーション...
categories:
  - Impala
  - Tutorial
  - カテゴリーなし

---
<div class="post_title">
  （<a href="https://gethue.tumblr.com/tagged/impala">原文</a>）
</div>

<div class="post_body">
</div>

<div class="post_body">
  <h1>
    Impalaのファイルフォーマット
  </h1>
  
  <p>
    最適なファイルフォーマットを使用することは、優れたパフォーマンスを得るためには極めて重要です。これは、<a href="https://gethue.com/fast-sql-with-the-impala-query-editor">Impala アプリケーション</a>（英語）でJSONがサポートされていない理由の一つです。実際に、1レコードでさえ全てのテキストレコードの構文解析や取得をすることは、パフォーマンスにひどいダメージを与えます。Impalaでは別の一連の<a href="http://www.cloudera.com/content/cloudera-content/cloudera-docs/Impala/latest/Installing-and-Using-Impala/ciiu_file_formats.html">フォーマット</a>を推奨しています。
  </p>
  
  <p>
    ここではjsonデータを含んだAvroフォーマットのHiveテーブルと、新しいParquetフォーマットのテーブルをどのようにして作成するのかを紹介しています。Hadoopチュートリアルシリーズの<a href="https://gethue.com/hadoop-tutorials-ii-2-execute-hive-queries-and">Episode</a><a href="https://gethue.com/hadoop-tutorials-ii-2-execute-hive-queries-and"> 2 of the Season 2</a> （英語）の同じYelpデータを使用しています。
  </p>
  
  <h2>
    Avro
  </h2>
  
  <p>
    最初の手順はPigスクリプトの支援によりデータをJSONに変換することです。<a href="https://gethue.tumblr.com/tagged/pig">Pig Editor</a> をオープンして実行します:
  </p>
  
  <pre class="code"><code class="sql">REGISTER piggybank.jar

data = load '/user/hive/warehouse/review/yelp_academic_dataset_review_clean.json'
    AS (funny:INT, useful:INT, cool:INT, user_id:CHARARRAY, review_id:CHARARRAY, text:CHARARRAY, business_id:CHARARRAY, stars:INT, date:CHARARRAY, type:CHARARRAY);

data_clean = FILTER data BY business_id IS NOT NULL AND text IS NOT NULL;    

STORE data_clean INTO 'impala/reviews_avro'
USING org.apache.pig.piggybank.storage.avro.AvroStorage(
'{
"schema": {
  "name": "review",
  "type": "record",
  "fields": [
     {"name":"funny", "type":"int"},
     {"name":"useful", "type":"int"},
     {"name":"cool", "type":"int"},
     {"name":"user_id", "type":"string"}
     {"name":"review_id", "type":"string"},
     {"name":"text", "type":"string"},
     {"name":"business_id", "type":"string"},
     {"name":"stars", "type":"int"},
     {"name":"date", "type":"string"},      
     {"name":"type", "type":"string"},
  ]}
}');</code></pre>
  
  <p>
    続いて、<a href="https://gethue.tumblr.com/tagged/hive">Hive Editor</a>で、以下のようにしてテーブルを作成します:
  </p>
  
  <pre><code class="sql">CREATE TABLE review_avro
ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'
STORED AS
inputformat 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'
outputformat 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'
LOCATION '/user/romain/impala/reviews_avro'
tblproperties ('avro.schema.literal'='{
  "name": "review",
  "type": "record",
  "fields": [
     {"name":"business_id", "type":"string"},
     {"name":"cool", "type":"int"},
     {"name":"date", "type":"string"},
     {"name":"funny", "type":"int"},
     {"name":"review_id", "type":"string"},
     {"name":"stars", "type":"int"},
     {"name":"text", "type":"string"},
     {"name":"type", "type":"string"},
     {"name":"useful", "type":"int"},
     {"name":"user_id", "type":"string"}]}'
);</code></pre>
  
  <p>
    ここでImpalaに戻り、以下のようにメタデータをリフレッシュした後にテーブルを使用することができます:
  </p>
  
  <pre><code class="sql">REFRESH avro_table</code></pre>
  
  <h2>
    Parquet
  </h2>
  
  <p>
    Parquetは、新しい列指向のバイナリーファイルフォーマットで、特にImpalaには効率が良いです。これはImpalaアプリからテーブルを作成する方法です:
  </p>
  
  <pre><code class="sql">CREATE TABLE review_parquet LIKE review STORED AS PARQUETFILE;</code></pre>
  
  <p>
    その後データをロードします:
  </p>
  
  <pre><code class="sql">INSERT OVERWRITE review_parquet  SELECT * FROM review;</code></pre>
  
  <p>
    時間をかけて、それぞれのフォーマットの目的についてと、圧縮を有効にする方法を読んでみて下さい。より詳しく知りたければ、<a href="http://www.cloudera.com/content/cloudera-content/cloudera-docs/Impala/latest/Installing-and-Using-Impala/ciiu_performance.html">Impala tuning guide</a>も良い参考資料です。
  </p>
  
  <p>
    いつものように、何かあれば<a href="http://groups.google.com/a/cloudera.org/group/hue-user">hue-user</a>メーリングリスト（英語）や、<a href="https://twitter.com/gethue">@gethue</a>に気軽にコメントして下さい！
  </p>
</div>