// Licensed to Cloudera, Inc. under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  Cloudera, Inc. licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/* parser generated by jison 0.4.17 */
/*
  Returns a Parser object of the following structure:

  Parser: {
    yy: {}
  }

  Parser.prototype: {
    yy: {},
    trace: function(),
    symbols_: {associative list: name ==> number},
    terminals_: {associative list: number ==> name},
    productions_: [...],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$),
    table: [...],
    defaultActions: {...},
    parseError: function(str, hash),
    parse: function(input),

    lexer: {
        EOF: 1,
        parseError: function(str, hash),
        setInput: function(input),
        input: function(),
        unput: function(str),
        more: function(),
        less: function(n),
        pastInput: function(),
        upcomingInput: function(),
        showPosition: function(),
        test_match: function(regex_match_array, rule_index),
        next: function(),
        lex: function(),
        begin: function(condition),
        popState: function(),
        _currentRules: function(),
        topState: function(),
        pushState: function(condition),

        options: {
            ranges: boolean           (optional: true ==> token location info will include a .range[] member)
            flex: boolean             (optional: true ==> flex-like lexing behaviour where the rules are tested exhaustively to find the longest match)
            backtrack_lexer: boolean  (optional: true ==> lexer regexes are tested in order and for each matching regex the action code is invoked; the lexer terminates the scan when a token is returned by the action code)
        },

        performAction: function(yy, yy_, $avoiding_name_collisions, YY_START),
        rules: [...],
        conditions: {associative list: name ==> set},
    }
  }


  token location info (@$, _$, etc.): {
    first_line: n,
    last_line: n,
    first_column: n,
    last_column: n,
    range: [start_number, end_number]       (where the numbers are indexes into the input string, regular zero-based)
  }


  the parseError function receives a 'hash' object with these members for lexer and parser errors: {
    text:        (matched text)
    token:       (the produced terminal token, if any)
    line:        (yylineno)
  }
  while parser (grammar) errors will also provide these members, i.e. parser errors deliver a superset of attributes: {
    loc:         (yylloc)
    expected:    (string describing the set of expected tokens)
    recoverable: (boolean: TRUE when the parser has a error recovery rule available for this particular error)
  }
*/
import SqlParseSupport from 'parse/sql/calcite/sqlParseSupport';

var calciteSyntaxParser = (function(){
var o=function(k,v,o,l){for(o=o||{},l=k.length;l--;o[k[l]]=v);return o},$V0=[4,8,12,16,164,176,243,274,324,340,343,347,510],$V1=[2,628],$V2=[343,347],$V3=[2,629],$V4=[1,37],$V5=[1,28],$V6=[1,29],$V7=[1,18],$V8=[1,38],$V9=[1,35],$Va=[1,36],$Vb=[1,30],$Vc=[1,34],$Vd=[1,31],$Ve=[1,32],$Vf=[1,47],$Vg=[1,49],$Vh=[1,45],$Vi=[1,48],$Vj=[1,44],$Vk=[83,343,347],$Vl=[2,455],$Vm=[1,55],$Vn=[1,63],$Vo=[1,64],$Vp=[1,74],$Vq=[56,57,65,81,97,98,109,114,115,230,256,270,272,273,274,297,298,299,300,301,302,303,304,305,306,307,309,310,351,352,354,355,358,361,365,373,392,393],$Vr=[2,417],$Vs=[1,85],$Vt=[1,86],$Vu=[33,270],$Vv=[16,33,45,52,56,57,65,79,81,83,87,97,109,110,111,114,115,122,127,131,142,144,156,184,192,203,216,217,218,219,220,221,222,223,224,228,230,234,241,242,256,265,267,270,343,347,351,352,355,359,360,361,362,363,364,366,369,370,371,372,374,377,378,379,380,382,383,385,387,388,389,390,391,394,395,408,442],$Vw=[83,265,343,347],$Vx=[65,115,230,343,347,351,352],$Vy=[2,785],$Vz=[1,100],$VA=[65,115,230,351,352,361],$VB=[65,115,230,309,343,347,351,352,361],$VC=[2,782],$VD=[1,105],$VE=[2,832],$VF=[16,65,115,230,351,352,361],$VG=[81,87,243],$VH=[1,172],$VI=[1,173],$VJ=[1,128],$VK=[1,123],$VL=[1,134],$VM=[1,136],$VN=[1,138],$VO=[1,121],$VP=[1,170],$VQ=[1,174],$VR=[1,175],$VS=[1,139],$VT=[1,161],$VU=[1,162],$VV=[1,163],$VW=[1,164],$VX=[1,165],$VY=[1,166],$VZ=[1,167],$V_=[1,168],$V$=[1,154],$V01=[1,155],$V11=[1,148],$V21=[1,137],$V31=[1,149],$V41=[1,124],$V51=[1,126],$V61=[1,125],$V71=[1,129],$V81=[1,127],$V91=[1,169],$Va1=[1,171],$Vb1=[56,57,65,81,83,97,98,109,114,115,230,243,256,270,272,273,274,297,298,299,300,301,302,303,304,305,306,307,309,310,351,352,354,355,358,361,365,373,392,393],$Vc1=[1,225],$Vd1=[83,87,184,265,343,347],$Ve1=[2,1104],$Vf1=[1,230],$Vg1=[1,245],$Vh1=[1,246],$Vi1=[1,234],$Vj1=[1,231],$Vk1=[1,232],$Vl1=[1,233],$Vm1=[1,240],$Vn1=[1,239],$Vo1=[1,238],$Vp1=[1,241],$Vq1=[1,236],$Vr1=[1,235],$Vs1=[1,229],$Vt1=[1,237],$Vu1=[1,248],$Vv1=[1,247],$Vw1=[33,45,56,57,65,79,83,87,97,110,111,115,131,144,184,192,203,216,217,218,219,220,221,222,223,228,230,234,241,242,256,265,267,343,347,351,352,355,359,360,361,362,371,372,377,379,380,382,383,385,389,395,442],$Vx1=[1,254],$Vy1=[1,260],$Vz1=[1,262],$VA1=[33,45,56,57,65,79,81,83,87,97,110,111,115,131,144,184,192,203,216,217,218,219,220,221,222,223,228,230,234,241,242,256,265,267,343,347,351,352,355,359,360,361,362,371,372,377,379,380,382,383,385,389,395,442],$VB1=[1,267],$VC1=[33,45,52,56,57,65,79,81,83,87,97,110,111,115,131,144,184,192,203,216,217,218,219,220,221,222,223,228,230,234,241,242,256,265,267,270,343,347,351,352,355,359,360,361,362,371,372,377,379,380,382,383,385,389,395,442],$VD1=[33,45,56,57,65,79,83,87,97,110,111,115,131,144,184,192,203,216,217,218,219,220,221,222,223,228,230,234,241,242,256,265,267,321,343,347,351,352,355,359,360,361,362,371,372,377,379,380,382,383,385,389,395,442],$VE1=[45,56,57,65,83,87,115,127,142,156,192,203,216,217,218,219,220,221,222,223,224,228,230,234,265,267,343,347,351,352,361],$VF1=[1,283],$VG1=[45,52,83,87,97,98,111,184,192,203,216,217,218,219,220,221,222,223,224,228,234,265,267,343,347],$VH1=[83,87],$VI1=[2,48],$VJ1=[1,296],$VK1=[45,343,347],$VL1=[45,127,343,347],$VM1=[45,52,79,81,127,343,347],$VN1=[45,52],$VO1=[2,833],$VP1=[267,343,347],$VQ1=[87,184,267,343,347],$VR1=[33,52,83,87],$VS1=[176,243],$VT1=[2,1082],$VU1=[83,192,203,228,234,265,343,347],$VV1=[2,468],$VW1=[1,324],$VX1=[98,250,272,273],$VY1=[83,87,184,192,203,216,217,218,219,220,221,222,223,224,228,234,265,267,343,347],$VZ1=[45,56,57,65,83,87,97,115,131,184,192,203,216,217,218,219,220,221,222,223,228,230,234,241,242,265,267,343,347,351,352,359,361,362,371,372,380,385,389,395,442],$V_1=[33,45,56,57,65,83,87,97,110,111,115,131,144,184,192,203,216,217,218,219,220,221,222,223,228,230,234,241,242,256,265,267,343,347,351,352,355,359,360,361,362,371,372,380,385,389,395,442],$V$1=[371,372,395],$V02=[56,57,65,81,97,98,109,114,115,230,270,272,273,274,297,298,299,300,301,302,303,304,305,306,307,309,310,351,352,354,355,358,361,365,373,392,393],$V12=[33,45,52,56,57,65,79,83,87,97,98,110,111,115,131,144,184,192,203,216,217,218,219,220,221,222,223,224,228,230,234,241,242,256,265,267,343,347,351,352,355,359,360,361,362,371,372,377,379,380,382,383,385,389,395,442],$V22=[83,203,228,234,265,343,347],$V32=[83,87,192,203,228,234,265,267,343,347],$V42=[1,425],$V52=[1,428],$V62=[1,426],$V72=[1,430],$V82=[1,427],$V92=[1,429],$Va2=[1,432],$Vb2=[1,431],$Vc2=[83,87,192,203,216,217,218,219,220,221,222,223,224,228,234,265,267,343,347],$Vd2=[45,56,57,65,83,87,115,192,203,216,217,218,219,220,221,222,223,224,228,230,234,265,267,343,347,351,352,361],$Ve2=[33,45,56,57,65,83,87,97,110,111,115,131,144,184,192,203,216,217,218,219,220,221,222,223,228,230,234,241,242,265,267,343,347,351,352,359,361,362,371,372,380,385,389,395,442],$Vf2=[45,56,57,65,83,87,115,131,184,192,203,216,217,218,219,220,221,222,223,228,230,234,241,242,265,267,343,347,351,352,359,361,371,372,380,385,389,395,442],$Vg2=[1,450],$Vh2=[83,234],$Vi2=[1,464],$Vj2=[1,490],$Vk2=[1,491],$Vl2=[1,492],$Vm2=[1,478],$Vn2=[1,479],$Vo2=[1,480],$Vp2=[1,481],$Vq2=[1,482],$Vr2=[1,483],$Vs2=[1,484],$Vt2=[1,485],$Vu2=[1,486],$Vv2=[1,487],$Vw2=[1,488],$Vx2=[1,489],$Vy2=[83,228,234,265,343,347],$Vz2=[65,81,115,230,351,352,361],$VA2=[1,524],$VB2=[83,87,234],$VC2=[33,45,56,57,65,79,83,87,97,110,111,115,131,144,184,192,203,216,217,218,219,220,221,222,223,224,228,230,234,241,242,256,265,267,343,347,351,352,355,359,360,361,362,371,372,377,379,380,382,383,385,389,395,442],$VD2=[1,532],$VE2=[87,343,347],$VF2=[1,548],$VG2=[1,549],$VH2=[52,83,87,97,98,111],$VI2=[2,894],$VJ2=[1,552],$VK2=[83,228,265,343,347],$VL2=[83,87,192,203,216,217,218,219,220,221,222,223,228,234,265,267,343,347],$VM2=[2,374],$VN2=[1,568],$VO2=[52,83,87,97,98],$VP2=[83,87,203,228,234,265,343,347],$VQ2=[362,497],$VR2=[1,624],$VS2=[87,111],$VT2=[83,359,367,392,497],$VU2=[2,1140],$VV2=[83,87,131,228,265,343,347,385],$VW2=[83,359],$VX2=[2,1150],$VY2=[1,657],$VZ2=[1,658],$V_2=[1,659],$V$2=[1,667],$V03=[1,668],$V13=[2,1155],$V23=[1,675],$V33=[375,381],$V43=[2,198],$V53=[2,199];
var parser = {trace: function trace () { },
yy: {},
symbols_: {"error":2,"DataDefinition_EDIT":3,"ALTER":4,"CURSOR":5,"AlterTable_EDIT":6,"AlterView_EDIT":7,"CREATE":8,"DatabaseDefinition_EDIT":9,"TableDefinition_EDIT":10,"ViewDefinition_EDIT":11,"DROP":12,"DropDatabaseStatement_EDIT":13,"DropTableStatement_EDIT":14,"DropViewStatement_EDIT":15,"SET":16,"TruncateTableStatement_EDIT":17,"UseStatement_EDIT":18,"DescribeStatement_EDIT":19,"DataDefinition":20,"AlterTable":21,"AlterView":22,"DatabaseDefinition":23,"RoleDefinition":24,"TableDefinition":25,"ViewDefinition":26,"DropDatabaseStatement":27,"DropRoleStatement":28,"DropTableStatement":29,"DropViewStatement":30,"ALL":31,"SetOption":32,"=":33,"SetValue":34,"TruncateTableStatement":35,"UseStatement":36,"DescribeStatement":37,"AlterTableLeftSide":38,"PartitionSpec":39,"AlterTableLeftSide_EDIT":40,"TABLE":41,"SchemaQualifiedTableIdentifier":42,"SchemaQualifiedTableIdentifier_EDIT":43,"AlterViewLeftSide":44,"AS":45,"QuerySpecification":46,"AlterViewLeftSide_EDIT":47,"QuerySpecification_EDIT":48,"VIEW":49,"OptionalComment":50,"Comment":51,"COMMENT":52,"QuotedValue":53,"OptionalComment_INVALID":54,"Comment_INVALID":55,"SINGLE_QUOTE":56,"DOUBLE_QUOTE":57,"VALUE":58,"DatabaseOrSchema":59,"OptionalIfNotExists":60,"RegularIdentifier":61,"DatabaseDefinitionOptionals":62,"OptionalIfNotExists_EDIT":63,"DatabaseDefinitionOptionals_EDIT":64,"ROLE":65,"TableDefinitionRightPart":66,"TableDefinitionRightPart_EDIT":67,"TableIdentifierAndOptionalColumnSpecification":68,"OptionalPartitionedBy":69,"OptionalAsSelectStatement":70,"TableIdentifierAndOptionalColumnSpecification_EDIT":71,"PartitionedBy_EDIT":72,"OptionalAsSelectStatement_EDIT":73,"SchemaQualifiedIdentifier":74,"OptionalColumnSpecificationsOrLike":75,"OptionalColumnSpecificationsOrLike_EDIT":76,"SchemaQualifiedIdentifier_EDIT":77,"ParenthesizedColumnSpecificationList":78,"LIKE":79,"ParenthesizedColumnSpecificationList_EDIT":80,"(":81,"ColumnSpecificationList":82,")":83,"ColumnSpecificationList_EDIT":84,"RightParenthesisOrError":85,"ColumnSpecification":86,",":87,"ColumnSpecification_EDIT":88,"ColumnIdentifier":89,"ColumnDataType":90,"OptionalColumnOptions":91,"ColumnDataType_EDIT":92,"ColumnOptions_EDIT":93,"ColumnOptions":94,"ColumnOption":95,"ColumnOption_EDIT":96,"NOT":97,"NULL":98,"PrimitiveType":99,"ArrayType":100,"MapType":101,"StructType":102,"ArrayType_INVALID":103,"MapType_INVALID":104,"StructType_INVALID":105,"ArrayType_EDIT":106,"MapType_EDIT":107,"StructType_EDIT":108,"ARRAY":109,"<":110,">":111,"AnyCursor":112,"GreaterThanOrError":113,"MAP":114,"STRUCT":115,"StructDefinitionList":116,"StructDefinitionList_EDIT":117,"StructDefinition":118,"StructDefinition_EDIT":119,"Commas":120,"RegularOrBacktickedIdentifier":121,":":122,"ColumnDataTypeList":123,"ColumnDataTypeList_EDIT":124,"ColumnDataTypeListInner_EDIT":125,"PartitionedBy":126,"PARTITION":127,"BY":128,"RangeClause":129,"RangeClause_EDIT":130,"RANGE":131,"ParenthesizedColumnList":132,"ParenthesizedPartitionValuesList":133,"ParenthesizedColumnList_EDIT":134,"ParenthesizedPartitionValuesList_EDIT":135,"PartitionValueList":136,"PartitionValueList_EDIT":137,"PartitionValue":138,"PartitionValue_EDIT":139,"ValueExpression":140,"LessThanOrEqualTo":141,"VALUES":142,"ValueExpression_EDIT":143,"COMPARISON_OPERATOR":144,"CommitLocations":145,"OptionalParenthesizedViewColumnList":146,"ParenthesizedViewColumnList_EDIT":147,"ParenthesizedViewColumnList":148,"ViewColumnList":149,"ViewColumnList_EDIT":150,"ColumnReference":151,"OptionalIfExists":152,"OptionalCascade":153,"OptionalIfExists_EDIT":154,"OptionalPurge":155,"PURGE":156,"DataManipulation":157,"InsertStatement":158,"UpdateStatement":159,"InsertValuesStatement":160,"DataManipulation_EDIT":161,"InsertValuesStatement_EDIT":162,"UpdateStatement_EDIT":163,"INSERT":164,"INTO":165,"OptionalTable":166,"InsertValuesList":167,"ParenthesizedRowValuesList":168,"InValueList":169,"CommonTableExpression":170,"SelectStatement":171,"OptionalUnions":172,"SelectStatement_EDIT":173,"OptionalUnions_EDIT":174,"CommonTableExpression_EDIT":175,"WITH":176,"WithQueries":177,"WithQueries_EDIT":178,"WithQuery":179,"WithQuery_EDIT":180,"TableSubQueryInner":181,"TableSubQueryInner_EDIT":182,"FromClause":183,"FROM":184,"TableReferenceList":185,"FromClause_EDIT":186,"TableReferenceList_EDIT":187,"TableReference":188,"TableReference_EDIT":189,"OptionalGroupByClause":190,"GroupByClause":191,"GROUP":192,"GroupByColumnList":193,"GroupByClause_EDIT":194,"GroupByColumnList_EDIT":195,"ColumnGroupingSets":196,"ColumnGroupingSets_EDIT":197,"ColumnGroupingSet_EDIT":198,"ColumnReference_EDIT":199,"GroupByColumnListPartTwo_EDIT":200,"OptionalHavingClause":201,"HavingClause":202,"HAVING":203,"HavingClause_EDIT":204,"OptionalJoins":205,"Joins":206,"Joins_INVALID":207,"JoinType":208,"TablePrimary":209,"OptionalJoinCondition":210,"Join_EDIT":211,"JoinType_EDIT":212,"TablePrimary_EDIT":213,"JoinCondition_EDIT":214,"Joins_EDIT":215,"CROSS":216,"JOIN":217,"FULL":218,"OUTER":219,"INNER":220,"LEFT":221,"SEMI":222,"RIGHT":223,"ON":224,"UsingColList":225,"OptionalLimitClause":226,"LimitClause":227,"LIMIT":228,"UnsignedNumericLiteral":229,"VARIABLE_REFERENCE":230,"LimitClause_EDIT":231,"OptionalOrderByClause":232,"OrderByClause":233,"ORDER":234,"OrderByColumnList":235,"OrderByClause_EDIT":236,"OrderByColumnList_EDIT":237,"OrderByIdentifier":238,"OrderByIdentifier_EDIT":239,"OptionalAscOrDesc":240,"ASC":241,"DESC":242,"SELECT":243,"OptionalAllOrDistinct":244,"SelectList":245,"TableExpression":246,"STREAM":247,"SelectList_EDIT":248,"TableExpression_EDIT":249,"DISTINCT":250,"OptionalSelectConditions":251,"OptionalSelectConditions_EDIT":252,"SelectSpecification":253,"SelectSpecification_EDIT":254,"OptionalCorrelationName":255,"*":256,"OptionalCorrelationName_EDIT":257,"OptionalWhereClause":258,"WhereClause_EDIT":259,"WhereClause":260,"Unions":261,"Unions_EDIT":262,"UnionClause":263,"UnionClause_EDIT":264,"UNION":265,"NewStatement":266,"WHERE":267,"SearchCondition":268,"SearchCondition_EDIT":269,".":270,"SignedInteger":271,"TRUE":272,"FALSE":273,"TRUNCATE":274,"OptionalPartitionSpec":275,"UserDefinedFunction":276,"AggregateFunction":277,"OptionalOverClause":278,"AnalyticFunction":279,"OverClause":280,"CastFunction":281,"UserDefinedFunction_EDIT":282,"AggregateFunction_EDIT":283,"OptionalOverClause_EDIT":284,"AnalyticFunction_EDIT":285,"OverClause_EDIT":286,"CastFunction_EDIT":287,"OtherAggregateFunction":288,"CountFunction":289,"SumFunction":290,"OtherAggregateFunction_EDIT":291,"CountFunction_EDIT":292,"SumFunction_EDIT":293,"OtherAggregateFunction_Type":294,"UdfArgumentList":295,"UdfArgumentList_EDIT":296,"AVG":297,"MAX":298,"MIN":299,"STDDEV_POP":300,"STDDEV_SAMP":301,"VAR_POP":302,"VAR_SAMP":303,"VARIANCE":304,"COUNT":305,"SUM":306,"ANALYTIC":307,"ArbitraryFunctionName":308,"IF":309,"CAST":310,"NonParenthesizedValueExpressionPrimary":311,"ColumnOrArbitraryFunctionRef":312,"ArbitraryFunctionRightPart":313,"UnsignedValueSpecification":314,"NonParenthesizedValueExpressionPrimary_EDIT":315,"ArbitraryFunctionRightPart_EDIT":316,"UnsignedValueSpecification_EDIT":317,"ColumnOrArbitraryFunctionRef_EDIT":318,"ArbitraryFunction":319,"ArbitraryFunction_EDIT":320,"OVER":321,"WindowExpression":322,"WindowExpression_EDIT":323,"UPDATE":324,"TargetTable":325,"SetClauseList":326,"OptionalFromJoinedTable":327,"TargetTable_EDIT":328,"SetClauseList_EDIT":329,"FromJoinedTable_EDIT":330,"TableName":331,"TableName_EDIT":332,"LocalOrSchemaQualifiedName":333,"LocalOrSchemaQualifiedName_EDIT":334,"SetClause":335,"SetClause_EDIT":336,"SetTarget":337,"UpdateSource":338,"UpdateSource_EDIT":339,"USE":340,"SqlSyntax":341,"SqlStatements":342,"EOF":343,"SqlAutocomplete":344,"SqlStatements_EDIT":345,"SqlStatement":346,";":347,"SqlStatement_EDIT":348,"SetSpecification_EDIT":349,"NonReservedKeyword":350,"OPTION":351,"REGULAR_IDENTIFIER":352,"NonStartingToken":353,"!":354,"-":355,"[":356,"]":357,"~":358,"AND":359,"ARITHMETIC_OPERATOR":360,"BACKTICK":361,"BETWEEN":362,"BIGINT":363,"BOOLEAN":364,"CASE":365,"CHAR":366,"CURRENT":367,"DATABASE":368,"DECIMAL":369,"DOUBLE":370,"ELSE":371,"END":372,"EXISTS":373,"FLOAT":374,"FOLLOWING":375,"HDFS_START_QUOTE":376,"IN":377,"INT":378,"IS":379,"OR":380,"PRECEDING":381,"REGEXP":382,"RLIKE":383,"ROW":384,"ROWS":385,"SCHEMA":386,"SMALLINT":387,"STRING":388,"THEN":389,"TIMESTAMP":390,"TINYINT":391,"UNSIGNED_INTEGER":392,"UNSIGNED_INTEGER_E":393,"VARCHAR":394,"WHEN":395,"PARTIAL_CURSOR":396,"FromOrIn":397,"SingleQuotedValue":398,"SingleQuotedValue_EDIT":399,"PARTIAL_VALUE":400,"DoubleQuotedValue":401,"DoubleQuotedValue_EDIT":402,"QuotedValue_EDIT":403,"OptionalFromDatabase":404,"DatabaseIdentifier":405,"OptionalFromDatabase_EDIT":406,"DatabaseIdentifier_EDIT":407,"CASCADE":408,"OptionalInDatabase":409,"OptionalPartitionSpec_EDIT":410,"PartitionSpec_EDIT":411,"PartitionSpecList":412,"PartitionSpecList_EDIT":413,"RangePartitionSpec":414,"RangePartitionComparisonOperator":415,"RangePartitionSpec_EDIT":416,"ConfigurationName":417,"PartialBacktickedOrAnyCursor":418,"PartialBacktickedIdentifier":419,"PartialBacktickedOrCursor":420,"PartialBacktickedOrPartialCursor":421,"OptionalParenthesizedColumnList":422,"OptionalParenthesizedColumnList_EDIT":423,"ColumnList":424,"ColumnList_EDIT":425,"ParenthesizedSimpleValueList":426,"SimpleValueList":427,"PartitionExpression":428,"PartitionExpression_EDIT":429,"RegularOrBackTickedSchemaQualifiedName":430,"RegularOrBackTickedSchemaQualifiedName_EDIT":431,"BasicIdentifierChain":432,"BasicIdentifierChain_EDIT":433,"DerivedColumnChain":434,"DerivedColumnChain_EDIT":435,"PartialBacktickedIdentifierOrPartialCursor":436,"OptionalTypeLength":437,"OptionalTypePrecision":438,"OptionalNot":439,"TableSubQuery":440,"ValueExpressionList":441,"BETWEEN_AND":442,"LikeRightPart":443,"CaseRightPart":444,"TableSubQuery_EDIT":445,"ValueExpressionInSecondPart_EDIT":446,"LikeRightPart_EDIT":447,"CaseRightPart_EDIT":448,"EndOrError":449,"ValueExpressionList_EDIT":450,"+":451,"UnsignedLiteral":452,"UnsignedLiteral_EDIT":453,"GeneralLiteral":454,"GeneralLiteral_EDIT":455,"ExactNumericLiteral":456,"ApproximateNumericLiteral":457,"TruthValue":458,"TablePrimaryOrJoinedTable":459,"TablePrimaryOrJoinedTable_EDIT":460,"JoinedTable":461,"JoinedTable_EDIT":462,"TableOrQueryName":463,"DerivedTable":464,"TableOrQueryName_EDIT":465,"DerivedTable_EDIT":466,"OptionalOnColumn":467,"OptionalOnColumn_EDIT":468,"PushQueryState":469,"PopQueryState":470,"SubQuery":471,"SubQuery_EDIT":472,"QueryExpression":473,"QueryExpression_EDIT":474,"QueryExpressionBody":475,"QueryExpressionBody_EDIT":476,"NonJoinQueryExpression":477,"NonJoinQueryExpression_EDIT":478,"NonJoinQueryTerm":479,"NonJoinQueryTerm_EDIT":480,"NonJoinQueryPrimary":481,"NonJoinQueryPrimary_EDIT":482,"SimpleTable":483,"SimpleTable_EDIT":484,"OptionalPartitionBy":485,"OptionalOrderByAndWindow":486,"PartitionBy_EDIT":487,"OptionalOrderByAndWindow_EDIT":488,"PartitionBy":489,"OptionalWindowSpec":490,"WindowSpec_EDIT":491,"WindowSpec":492,"RowsOrRange":493,"PopLexerState":494,"OptionalCurrentOrPreceding":495,"OptionalAndFollowing":496,"UNBOUNDED":497,"OptionalCurrentOrPreceding_EDIT":498,"OptionalAndFollowing_EDIT":499,"PushHdfsLexerState":500,"HdfsPath":501,"HDFS_PATH":502,"HDFS_END_QUOTE":503,"HdfsPath_EDIT":504,"IntegerOrUnbounded":505,"CaseWhenThenList":506,"CaseWhenThenList_EDIT":507,"CaseWhenThenListPartTwo":508,"CaseWhenThenListPartTwo_EDIT":509,"DESCRIBE":510,"$accept":0,"$end":1},
terminals_: {2:"error",4:"ALTER",5:"CURSOR",8:"CREATE",12:"DROP",16:"SET",31:"ALL",33:"=",41:"TABLE",45:"AS",49:"VIEW",52:"COMMENT",56:"SINGLE_QUOTE",57:"DOUBLE_QUOTE",58:"VALUE",65:"ROLE",79:"LIKE",81:"(",83:")",87:",",97:"NOT",98:"NULL",109:"ARRAY",110:"<",111:">",114:"MAP",115:"STRUCT",122:":",127:"PARTITION",128:"BY",131:"RANGE",142:"VALUES",144:"COMPARISON_OPERATOR",156:"PURGE",164:"INSERT",165:"INTO",176:"WITH",184:"FROM",192:"GROUP",203:"HAVING",216:"CROSS",217:"JOIN",218:"FULL",219:"OUTER",220:"INNER",221:"LEFT",222:"SEMI",223:"RIGHT",224:"ON",228:"LIMIT",230:"VARIABLE_REFERENCE",234:"ORDER",241:"ASC",242:"DESC",243:"SELECT",247:"STREAM",250:"DISTINCT",256:"*",265:"UNION",267:"WHERE",270:".",272:"TRUE",273:"FALSE",274:"TRUNCATE",297:"AVG",298:"MAX",299:"MIN",300:"STDDEV_POP",301:"STDDEV_SAMP",302:"VAR_POP",303:"VAR_SAMP",304:"VARIANCE",305:"COUNT",306:"SUM",307:"ANALYTIC",309:"IF",310:"CAST",321:"OVER",324:"UPDATE",340:"USE",343:"EOF",347:";",349:"SetSpecification_EDIT",351:"OPTION",352:"REGULAR_IDENTIFIER",354:"!",355:"-",356:"[",357:"]",358:"~",359:"AND",360:"ARITHMETIC_OPERATOR",361:"BACKTICK",362:"BETWEEN",363:"BIGINT",364:"BOOLEAN",365:"CASE",366:"CHAR",367:"CURRENT",368:"DATABASE",369:"DECIMAL",370:"DOUBLE",371:"ELSE",372:"END",373:"EXISTS",374:"FLOAT",375:"FOLLOWING",376:"HDFS_START_QUOTE",377:"IN",378:"INT",379:"IS",380:"OR",381:"PRECEDING",382:"REGEXP",383:"RLIKE",384:"ROW",385:"ROWS",386:"SCHEMA",387:"SMALLINT",388:"STRING",389:"THEN",390:"TIMESTAMP",391:"TINYINT",392:"UNSIGNED_INTEGER",393:"UNSIGNED_INTEGER_E",394:"VARCHAR",395:"WHEN",396:"PARTIAL_CURSOR",400:"PARTIAL_VALUE",408:"CASCADE",442:"BETWEEN_AND",451:"+",497:"UNBOUNDED",502:"HDFS_PATH",503:"HDFS_END_QUOTE",510:"DESCRIBE"},
productions_: [0,[3,2],[3,1],[3,1],[3,2],[3,1],[3,1],[3,1],[3,2],[3,1],[3,1],[3,1],[3,2],[3,1],[3,1],[3,1],[20,1],[20,1],[20,1],[20,1],[20,1],[20,1],[20,1],[20,1],[20,1],[20,1],[20,2],[20,4],[20,1],[20,1],[20,1],[21,2],[6,1],[6,2],[6,2],[6,3],[38,3],[40,3],[40,3],[22,3],[7,1],[7,2],[7,3],[7,3],[7,3],[44,3],[47,3],[47,3],[50,0],[50,1],[51,2],[54,1],[55,2],[55,2],[55,3],[55,3],[23,3],[23,5],[9,4],[9,3],[9,5],[9,4],[9,6],[62,1],[64,1],[24,3],[25,4],[10,4],[10,4],[10,3],[66,3],[67,3],[67,3],[67,3],[67,3],[68,2],[71,2],[71,2],[75,0],[75,1],[75,2],[76,1],[76,2],[76,2],[78,3],[80,3],[82,1],[82,3],[84,1],[84,3],[84,3],[84,5],[84,2],[84,4],[84,4],[84,6],[86,3],[88,3],[88,3],[88,3],[91,0],[91,1],[94,1],[94,2],[93,1],[93,2],[93,2],[93,3],[95,2],[95,1],[95,1],[96,2],[90,1],[90,1],[90,1],[90,1],[90,1],[90,1],[90,1],[92,1],[92,1],[92,1],[100,4],[103,3],[106,4],[106,4],[101,6],[104,3],[107,6],[107,4],[107,6],[107,5],[102,4],[105,3],[108,4],[116,1],[116,3],[117,1],[117,2],[117,3],[117,3],[117,5],[118,4],[119,5],[119,4],[119,4],[119,4],[119,3],[119,3],[123,1],[123,3],[124,1],[124,2],[124,3],[124,3],[124,5],[125,2],[125,2],[125,1],[125,1],[113,1],[113,1],[69,0],[69,1],[126,3],[72,2],[72,3],[72,3],[129,3],[130,2],[130,2],[130,3],[130,3],[130,3],[133,3],[135,3],[135,3],[136,1],[136,3],[137,1],[137,3],[137,5],[137,3],[137,5],[138,6],[138,4],[138,4],[139,2],[139,2],[139,3],[139,4],[139,4],[139,5],[139,6],[139,6],[139,3],[139,4],[139,4],[141,1],[141,1],[70,0],[70,3],[73,3],[73,3],[145,0],[26,8],[11,4],[11,9],[11,3],[11,6],[11,7],[11,8],[11,8],[11,8],[146,0],[146,1],[148,3],[147,3],[149,2],[149,4],[150,3],[150,5],[150,5],[150,7],[27,5],[13,3],[13,3],[13,4],[13,5],[13,5],[13,6],[28,3],[29,5],[14,3],[14,4],[14,5],[14,5],[14,6],[155,0],[155,1],[30,4],[15,4],[15,5],[15,3],[15,4],[15,4],[157,1],[157,1],[158,1],[161,1],[161,1],[160,6],[162,2],[162,4],[162,4],[162,5],[162,6],[167,1],[167,3],[168,3],[166,0],[166,1],[46,3],[46,5],[46,2],[48,4],[48,3],[48,3],[48,1],[48,4],[48,3],[48,2],[48,2],[170,2],[175,2],[177,1],[177,3],[178,1],[178,3],[178,3],[178,5],[179,5],[180,2],[180,5],[180,5],[183,2],[186,2],[186,2],[185,1],[185,3],[187,1],[187,3],[187,3],[187,5],[187,3],[190,0],[190,1],[191,3],[194,3],[194,3],[194,2],[196,0],[196,1],[196,3],[196,3],[197,1],[197,3],[197,3],[197,5],[197,3],[198,1],[198,1],[193,1],[193,3],[195,1],[195,2],[195,3],[195,3],[195,3],[195,4],[195,5],[200,1],[200,2],[200,1],[201,0],[201,1],[202,2],[204,2],[204,2],[205,0],[205,1],[205,1],[206,3],[206,4],[207,1],[207,2],[211,3],[211,1],[211,3],[211,3],[211,3],[215,1],[215,2],[215,2],[215,3],[208,2],[208,2],[208,3],[208,2],[208,1],[208,3],[208,2],[208,3],[208,3],[208,2],[208,3],[208,2],[208,3],[208,3],[208,2],[212,2],[212,3],[212,3],[212,2],[212,3],[212,3],[212,3],[212,3],[212,2],[212,3],[212,3],[212,3],[212,3],[212,2],[210,0],[210,2],[225,1],[225,3],[214,2],[214,2],[226,0],[226,1],[227,2],[227,4],[227,2],[227,4],[231,2],[232,0],[232,1],[233,3],[236,3],[236,2],[235,1],[235,3],[237,1],[237,2],[237,3],[237,4],[237,5],[238,2],[239,2],[239,2],[240,0],[240,1],[240,1],[171,3],[171,4],[171,4],[173,3],[173,3],[173,4],[173,4],[173,4],[173,5],[173,6],[173,4],[173,4],[244,0],[244,1],[244,1],[246,2],[249,2],[249,4],[249,3],[245,1],[245,3],[248,1],[248,2],[248,3],[248,3],[248,3],[248,4],[248,3],[248,3],[248,4],[248,4],[248,4],[248,5],[248,5],[253,2],[253,1],[254,2],[254,3],[254,2],[251,5],[252,5],[252,5],[252,5],[252,5],[252,5],[252,6],[252,6],[252,6],[252,6],[252,6],[172,0],[172,1],[174,1],[261,1],[261,2],[262,1],[262,2],[262,2],[262,3],[263,4],[264,3],[264,4],[264,4],[258,0],[258,1],[260,2],[259,2],[259,2],[268,1],[269,1],[32,1],[32,3],[34,1],[34,1],[34,2],[34,1],[34,1],[34,1],[34,1],[35,4],[17,2],[17,4],[17,3],[17,4],[17,5],[17,5],[17,5],[276,2],[276,2],[276,1],[282,1],[282,2],[282,1],[282,2],[282,2],[282,2],[282,1],[277,1],[277,1],[277,1],[283,1],[283,1],[283,1],[288,4],[288,5],[291,5],[291,6],[291,5],[294,1],[294,1],[294,1],[294,1],[294,1],[294,1],[294,1],[294,1],[289,4],[289,3],[289,5],[292,5],[292,6],[292,5],[290,5],[290,3],[293,5],[293,6],[293,5],[279,3],[279,4],[285,4],[285,5],[285,4],[308,1],[308,1],[308,1],[308,1],[281,6],[281,3],[287,6],[287,5],[287,4],[287,6],[287,5],[287,4],[287,6],[287,5],[287,6],[287,5],[311,2],[311,2],[311,1],[311,1],[311,1],[311,1],[315,2],[315,2],[315,1],[315,1],[315,1],[319,2],[319,2],[320,2],[320,2],[313,2],[313,3],[316,3],[316,4],[316,3],[295,1],[295,3],[296,1],[296,3],[296,3],[296,5],[296,3],[296,5],[296,4],[296,3],[296,2],[296,2],[296,4],[278,0],[278,1],[284,1],[280,2],[280,2],[286,2],[159,6],[163,6],[163,6],[163,6],[163,6],[163,7],[163,3],[163,2],[163,2],[163,2],[325,1],[328,1],[331,1],[332,1],[326,1],[326,3],[329,1],[329,3],[329,3],[329,5],[335,3],[336,3],[336,2],[336,1],[337,1],[338,1],[339,1],[327,0],[327,2],[330,2],[330,2],[36,2],[18,2],[341,3],[344,3],[344,3],[266,0],[342,0],[342,1],[342,4],[345,1],[345,4],[345,4],[345,7],[346,1],[346,1],[346,1],[348,1],[348,2],[348,1],[348,1],[348,1],[348,1],[350,1],[350,1],[350,1],[61,1],[61,1],[61,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[353,1],[120,1],[120,2],[112,1],[112,1],[397,1],[397,1],[59,1],[59,1],[398,3],[398,2],[399,2],[401,3],[401,2],[402,2],[53,1],[53,1],[403,1],[403,1],[404,0],[404,2],[406,2],[153,0],[153,1],[152,0],[152,2],[154,2],[60,0],[60,3],[63,2],[63,3],[409,0],[409,2],[409,2],[275,0],[275,1],[410,1],[39,4],[411,4],[414,5],[416,2],[416,3],[416,4],[416,5],[416,5],[416,5],[415,1],[415,1],[415,1],[415,1],[417,1],[417,1],[418,1],[418,1],[420,1],[420,1],[421,1],[421,1],[419,2],[85,1],[85,1],[422,0],[422,1],[423,1],[132,3],[134,3],[134,3],[424,1],[424,3],[425,3],[425,5],[426,3],[427,1],[427,3],[42,1],[42,3],[43,1],[43,3],[43,3],[74,1],[74,3],[77,1],[77,3],[77,3],[405,1],[407,1],[412,1],[412,3],[413,1],[413,3],[413,3],[413,5],[428,3],[429,3],[429,3],[429,3],[429,1],[121,1],[121,3],[121,2],[430,1],[430,3],[431,1],[431,3],[333,1],[333,2],[334,1],[334,2],[151,1],[151,3],[199,1],[432,1],[432,3],[433,3],[433,5],[434,1],[434,3],[435,1],[435,3],[435,5],[435,3],[89,1],[436,1],[436,1],[99,1],[99,1],[99,2],[99,2],[99,1],[99,1],[99,1],[99,1],[99,1],[99,1],[99,1],[99,2],[437,0],[437,3],[438,0],[438,3],[438,5],[140,1],[140,2],[140,2],[140,2],[140,2],[140,4],[140,4],[140,4],[140,6],[140,2],[140,3],[140,3],[140,3],[140,3],[140,3],[140,6],[140,6],[140,5],[140,5],[140,6],[140,5],[140,3],[140,3],[140,3],[140,3],[140,3],[140,2],[140,3],[140,2],[140,3],[143,1],[143,3],[143,2],[143,2],[143,2],[143,2],[143,2],[143,2],[143,2],[143,2],[143,3],[143,4],[143,5],[143,4],[143,4],[143,4],[143,6],[143,6],[143,2],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,4],[143,3],[143,6],[143,6],[143,5],[143,5],[143,6],[143,6],[143,6],[143,6],[143,5],[143,4],[143,5],[143,5],[143,5],[143,5],[143,4],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,3],[143,2],[143,3],[143,2],[143,3],[143,2],[143,3],[143,2],[143,3],[143,3],[143,4],[143,3],[143,3],[143,3],[441,1],[441,3],[450,1],[450,3],[450,3],[450,5],[450,3],[450,5],[450,4],[450,3],[450,2],[450,2],[450,4],[169,1],[169,3],[312,1],[312,3],[318,1],[271,1],[271,2],[271,2],[314,1],[317,1],[452,1],[452,1],[453,1],[229,1],[229,1],[456,1],[456,2],[456,3],[456,2],[457,2],[457,3],[457,4],[454,1],[454,1],[454,1],[455,1],[455,1],[458,1],[458,1],[439,0],[439,1],[188,1],[189,1],[459,1],[459,1],[460,1],[460,1],[461,2],[462,2],[462,2],[209,2],[209,2],[213,2],[213,2],[213,2],[463,1],[465,1],[464,1],[466,1],[467,0],[467,2],[468,2],[468,2],[469,0],[470,0],[440,3],[440,4],[445,3],[445,3],[181,2],[182,3],[471,1],[472,1],[473,1],[474,1],[475,1],[476,1],[477,1],[478,1],[479,1],[480,1],[481,1],[482,1],[483,1],[484,1],[255,0],[255,1],[255,1],[255,2],[255,2],[257,1],[257,1],[257,2],[257,2],[257,2],[322,4],[323,4],[323,4],[323,5],[323,7],[485,0],[485,1],[489,3],[487,2],[487,3],[487,3],[486,0],[486,2],[488,1],[488,3],[488,2],[490,0],[490,1],[492,5],[492,5],[491,2],[491,6],[491,5],[491,5],[491,5],[491,4],[494,0],[500,0],[501,3],[504,5],[504,4],[504,3],[504,3],[504,2],[493,1],[493,1],[495,0],[495,2],[495,2],[498,2],[498,2],[496,0],[496,3],[496,3],[499,2],[499,3],[499,3],[505,1],[505,1],[446,3],[446,3],[446,3],[443,2],[443,2],[443,2],[447,2],[447,2],[447,2],[447,2],[447,2],[447,2],[444,2],[444,4],[448,2],[448,4],[448,4],[448,3],[448,4],[448,3],[448,4],[448,4],[448,3],[448,4],[448,3],[449,1],[449,1],[506,1],[506,2],[507,1],[507,2],[507,3],[507,3],[507,2],[508,4],[509,2],[509,3],[509,4],[509,4],[509,3],[509,3],[509,4],[509,2],[509,3],[509,2],[509,3],[509,3],[509,4],[509,3],[509,4],[509,4],[509,5],[509,4],[509,3],[37,2],[37,4],[19,2],[19,2],[19,3],[19,4]],
performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate /* action[1] */, $$ /* vstack */, _$ /* lstack */) {
/* this == yyval */

var $0 = $$.length - 1;
switch (yystate) {
case 1:

     parser.suggestKeywords(['TABLE', 'VIEW']);
   
break;
case 4: case 8:

     parser.suggestKeywords(['DATABASE', 'ROLE', 'SCHEMA', 'TABLE', 'VIEW']);
   
break;
case 12:

     parser.suggestSetOptions();
   
break;
case 36: case 45: case 240: case 244: case 484: case 604: case 1217: case 1218: case 1221: case 1222:

     parser.addTablePrimary($$[$0]);
   
break;
case 37: case 235:

     if (parser.yy.result.suggestTables) {
       parser.yy.result.suggestTables.onlyTables = true;
     }
   
break;
case 38:

     parser.suggestTables({ onlyTables: true });
     parser.suggestDatabases({ appendDot: true });
   
break;
case 41: case 282:

     parser.suggestKeywords(['AS']);
   
break;
case 43: case 202: case 211: case 283: case 640: case 1087:

     parser.suggestKeywords(['SELECT']);
   
break;
case 46: case 245:

     if (parser.yy.result.suggestTables) {
       parser.yy.result.suggestTables.onlyViews = true;
     }
   
break;
case 47:

     parser.suggestTables({ onlyViews: true });
     parser.suggestDatabases({ appendDot: true });
   
break;
case 57:

     parser.addNewDatabaseLocation(_$[$0-1], [{ name: $$[$0-1] }]);
   
break;
case 58: case 68:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
   
break;
case 60:

     if (!$$[$0-2]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
     parser.addNewDatabaseLocation(_$[$0], [{ name: $$[$0] }]);
   
break;
case 61:

     parser.addNewDatabaseLocation(_$[$0], [{ name: $$[$0] }]);
   
break;
case 62:

     parser.addNewDatabaseLocation(_$[$0-2], [{ name: $$[$0-2] }]);
   
break;
case 63:

     if (!$$[$0]) {
       parser.suggestKeywords(['COMMENT']);
     }
   
break;
case 74:

     var keywords = [];
     if (!$$[$0-2] && !$$[$0-1]) {
       keywords.push({ value: 'LIKE', weight: 1 });
     } else {
       if (!$$[$0-1]) {
         keywords.push({ value: 'PARTITIONED BY', weight: 12 });
       }
       keywords.push({ value: 'AS', weight: 1 });
     }

     if (keywords.length > 0) {
       parser.suggestKeywords(keywords);
     }
   
break;
case 75:

     parser.addNewTableLocation(_$[$0-1], $$[$0-1], $$[$0]);
     this.$ = $$[$0];
   
break;
case 80:
this.$ = [];
break;
case 82: case 601: case 621: case 834: case 1219:

     parser.suggestTables();
     parser.suggestDatabases({ appendDot: true });
   
break;
case 84: case 220: case 222: case 264: case 436: case 569: case 572: case 767: case 770: case 856: case 909: case 1084:
this.$ = $$[$0-1];
break;
case 86: case 275:
this.$ = [$$[$0]];
break;
case 87:
this.$ = $$[$0-2].concat($$[$0]);
break;
case 92: case 94:

     parser.checkForKeywords($$[$0-1]);
   
break;
case 93: case 95:

     parser.checkForKeywords($$[$0-3]);
   
break;
case 96:

     this.$ = $$[$0-2];
     this.$.type = $$[$0-1];
     var keywords = [];
     if (!$$[$0]['comment']) {
       keywords.push('COMMENT');
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 97: case 124: case 130: case 131: case 144: case 147: case 156: case 158:

     parser.suggestKeywords(parser.getColumnDataTypeKeywords());
   
break;
case 100:
this.$ = {};
break;
case 102:

     this.$ = {};
     this.$[$$[$0]] = true;
   
break;
case 103:

     $$[$0-1][$$[$0]] = true;
   
break;
case 108: case 109:
this.$ = 'null';
break;
case 110:
this.$ = 'comment';
break;
case 111:

     parser.suggestKeywords(['NULL']);
   
break;
case 129:

     parser.suggestKeywords(parser.getTypeKeywords());
   
break;
case 143: case 146:

     parser.suggestKeywords(['COMMENT']);
   
break;
case 165: case 1122:

     parser.suggestKeywords(['BY']);
   
break;
case 166:

     parser.suggestKeywords(['RANGE']);
   
break;
case 175: case 180: case 181:

     parser.suggestKeywords(['PARTITION']);
   
break;
case 187:

     parser.suggestKeywords(['VALUE', 'VALUES']);
   
break;
case 188:

     if ($$[$0].endsWithLessThanOrEqual) {
      parser.suggestKeywords(['VALUES']);
     }
   
break;
case 189: case 192: case 195:

     parser.suggestKeywords(['<', '<=']);
   
break;
case 190: case 799: case 802:

     parser.suggestKeywords(['VALUES']);
   
break;
case 193: case 196:

     parser.suggestFunctions();
   
break;
case 204:

     parser.commitLocations();
   
break;
case 206:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
     parser.suggestDatabases({ appendDot: true });
   
break;
case 207:

     if (!$$[$0-6]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
   
break;
case 210:

     var keywords = [{value: 'AS', weight: 1 }];
     if (!$$[$0-1]) {
       keywords.push({ value: 'COMMENT', weight: 3 });
     }
     parser.suggestKeywords(keywords);
   
break;
case 217:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['COMMENT']);
     }
   
break;
case 221: case 223:
this.$ = $$[$0-3];
break;
case 227:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
     parser.suggestDatabases();
   
break;
case 228:

     parser.suggestKeywords(['CASCADE']);
   
break;
case 230:

     if (!$$[$0-3]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 232: case 489:

     parser.addTablePrimary($$[$0-1]);
   
break;
case 234:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
     parser.suggestTables({ onlyTables: true });
     parser.suggestDatabases({
       appendDot: true
     });
   
break;
case 237:

     parser.addTablePrimary($$[$0-2]);
     if (!$$[$0-1]) {
       parser.suggestKeywords(['PURGE']);
     }
   
break;
case 241:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
     parser.suggestTables({ onlyViews: true });
     parser.suggestDatabases({ appendDot: true });
   
break;
case 242:

     parser.addTablePrimary($$[$0]);
     if (!$$[$0-2]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 251:

     $$[$0-2].owner = 'insert';
     parser.addTablePrimary($$[$0-2]);
   
break;
case 252:

     parser.suggestKeywords(['INTO']);
   
break;
case 253:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['TABLE']);
     }
     parser.suggestTables();
     parser.suggestDatabases({ appendDot: true });
   
break;
case 255:

     $$[$0-1].owner = 'insert';
     parser.addTablePrimary($$[$0-1]);
     parser.suggestKeywords(['VALUES']);
   
break;
case 263: case 438:
this.$ = $$[$0-2];
break;
case 265:

     parser.addCommonTableExpressions($$[$0-3]);
   
break;
case 266: case 267: case 278:

     parser.addCommonTableExpressions($$[$0-2]);
   
break;
case 273: case 289: case 313: case 389: case 393: case 433: case 443: case 470: case 620: case 1009: case 1011: case 1066: case 1121: case 1196:
this.$ = $$[$0];
break;
case 276:
this.$ = $$[$0-2].concat([$$[$0]]);
break;
case 280:

     parser.addCommonTableExpressions($$[$0-4]);
   
break;
case 281:

     parser.addCteAliasLocation(_$[$0-4], $$[$0-4]);
     $$[$0-1].alias = $$[$0-4];
     this.$ = $$[$0-1];
   
break;
case 285:

     this.$ = { tableReferenceList : $$[$0] }
   
break;
case 286: case 294:

       parser.suggestTables();
       parser.suggestDatabases({ appendDot: true });
   
break;
case 297:

     this.$ = { valueExpression: $$[$0] };
   
break;
case 298: case 400:

     parser.suggestSelectListAliases();
   
break;
case 299:

     parser.valueExpressionSuggest();
     parser.suggestSelectListAliases();
     parser.suggestGroupBys({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 300:

     parser.suggestKeywords(['BY']);
     parser.suggestGroupBys({ prefix: 'BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 310: case 615: case 824: case 827: case 828: case 853: case 854: case 875: case 878:

     parser.suggestColumns();
   
break;
case 315: case 316: case 322: case 323: case 852: case 1080: case 1123:

     parser.valueExpressionSuggest();
   
break;
case 327:

     parser.valueExpressionSuggest();
     parser.suggestAggregateFunctions();
     parser.suggestSelectListAliases(true);
   
break;
case 328:

     parser.suggestAggregateFunctions();
     parser.suggestSelectListAliases(true);
   
break;
case 332:

     if ($$[$0] && $$[$0].valueExpression) {
       this.$ = $$[$0].valueExpression;
     } else {
       this.$ = {};
     }
     this.$.joinType = $$[$0-2];
     if ($$[$0].noJoinCondition) {
       this.$.suggestJoinConditions = { prependOn: true, tablePrimaries: parser.yy.latestTablePrimaries.concat() }
     }
     if ($$[$0].suggestKeywords) {
       this.$.suggestKeywords = $$[$0].suggestKeywords;
     }
     if (parser.yy.latestTablePrimaries.length > 0) {
        parser.yy.latestTablePrimaries[parser.yy.latestTablePrimaries.length - 1].join = true;
     }
   
break;
case 333:

     if ($$[$0] && $$[$0].valueExpression) {
       this.$ = $$[$0].valueExpression;
     } else {
       this.$ = {};
     }
     this.$.joinType = $$[$0-3];
     if ($$[$0].noJoinCondition) {
       this.$.suggestJoinConditions = { prependOn: true, tablePrimaries: parser.yy.latestTablePrimaries.concat() }
     }
     if ($$[$0].suggestKeywords) {
       this.$.suggestKeywords = $$[$0].suggestKeywords;
     }
     if (parser.yy.latestTablePrimaries.length > 0) {
       parser.yy.latestTablePrimaries[parser.yy.latestTablePrimaries.length - 1].join = true;
     }
   
break;
case 334:
this.$ = { joinType: $$[$0] };
break;
case 335:
this.$ = { joinType: $$[$0-1] };
break;
case 336:

     if ($$[$0-2].suggestKeywords) {
       parser.suggestKeywords($$[$0-2].suggestKeywords);
     }
   
break;
case 337:

     if ($$[$0].suggestKeywords) {
       parser.suggestKeywords($$[$0].suggestKeywords);
     }
   
break;
case 340:

     if (parser.yy.latestTablePrimaries.length > 0) {
       var idx = parser.yy.latestTablePrimaries.length - 1;
       var tables = [];
       do {
         var tablePrimary = parser.yy.latestTablePrimaries[idx];
         if (!tablePrimary.subQueryAlias) {
           tables.unshift(tablePrimary.alias ? { identifierChain: tablePrimary.identifierChain, alias: tablePrimary.alias } : { identifierChain: tablePrimary.identifierChain })
         }
         idx--;
       } while (idx >= 0 && tablePrimary.join && !tablePrimary.subQueryAlias)

       if (tables.length > 0) {
         parser.suggestJoins({
           prependJoin: false,
           joinType: $$[$0-2],
           tables: tables
         })
       }
     }
     parser.suggestTables();
     parser.suggestDatabases({
       appendDot: true
     });
   
break;
case 345:
this.$ = 'CROSS JOIN';
break;
case 346:
this.$ = 'FULL JOIN';
break;
case 347:
this.$ = 'FULL OUTER JOIN';
break;
case 348:
this.$ = 'INNER JOIN';
break;
case 349:
this.$ = 'JOIN';
break;
case 350:
this.$ = 'LEFT INNER JOIN';
break;
case 351:
this.$ = 'LEFT JOIN';
break;
case 352:
this.$ = 'LEFT OUTER JOIN';
break;
case 353:
this.$ = 'LEFT SEMI JOIN';
break;
case 354:
this.$ = 'OUTER JOIN';
break;
case 355: case 357:
this.$ = 'RIGHT OUTER JOIN';
break;
case 356:
this.$ = 'RIGHT JOIN';
break;
case 358:
this.$ = 'RIGHT SEMI JOIN';
break;
case 359:
this.$ = 'SEMI JOIN';
break;
case 360: case 362: case 363: case 365: case 366: case 367: case 368: case 370: case 371: case 372: case 373:
this.$ = { suggestKeywords: ['JOIN'] };
break;
case 361: case 364: case 369:
this.$ = { suggestKeywords: ['OUTER'] };
break;
case 374:
this.$ = { noJoinCondition: true, suggestKeywords: ['ON'] };
break;
case 375:
this.$ = { valueExpression: $$[$0] };
break;
case 379:

     parser.valueExpressionSuggest();
     parser.suggestJoinConditions({ prependOn: false });
   
break;
case 386:

     parser.suggestKeywords([{ value: '10', weight: 10000 }, { value: '100', weight: 10000 }, { value: '1000', weight: 10000 }, { value: '5000', weight: 10000 }, { value: '10000', weight: 10000 }])
   
break;
case 390:

     if ($$[$0].emptyOrderBy) {
       parser.suggestOrderBys({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
   
break;
case 391:

     parser.suggestKeywords(['BY']);
     parser.suggestOrderBys({ prefix: 'BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 395:

     this.$ = { emptyOrderBy: false }
     parser.valueExpressionSuggest();
     parser.suggestAnalyticFunctions();
     parser.suggestSelectListAliases();
   
break;
case 396: case 397: case 398:
this.$ = { emptyOrderBy: false };
break;
case 399:
this.$ = parser.mergeSuggestKeywords($$[$0]);
break;
case 401:

     this.$ = { emptyOrderBy: true }
     parser.valueExpressionSuggest();
     parser.suggestAnalyticFunctions();
     parser.suggestSelectListAliases();
   
break;
case 402:
this.$ = { suggestKeywords: ['ASC', 'DESC'] };;
break;
case 405:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0]);
     this.$ = { selectList: $$[$0] };
   
break;
case 406:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     this.$ = { selectList: $$[$0-1], tableExpression: $$[$0] }
   
break;
case 408:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0]);
     if ($$[$0].cursorAtStart) {
       var keywords = parser.getSelectListKeywords();
       if (!$$[$0-1]) {
         keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
       }
       parser.suggestKeywords(keywords);
     } else {
       parser.checkForSelectListKeywords($$[$0]);
     }
     if ($$[$0].suggestFunctions) {
       parser.suggestFunctions();
     }
     if ($$[$0].suggestColumns) {
       parser.suggestColumns({ identifierChain: [], source: 'select' });
     }
     if ($$[$0].suggestTables) {
       parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     }
     if ($$[$0].suggestDatabases) {
       parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
     }
     if ($$[$0].suggestAggregateFunctions && (!$$[$0-1] || $$[$0-1] === 'ALL')) {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
   
break;
case 409:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0], true);
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-1] || $$[$0-1] === 'ALL') {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
     if (!$$[$0-1]) {
       keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
     }
     parser.suggestKeywords(keywords);
     parser.suggestFunctions();
     parser.suggestColumns({ identifierChain: [], source: 'select' });
     parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
   
break;
case 410:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
   
break;
case 411:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     parser.selectListNoTableSuggest($$[$0-1], $$[$0-2]);
     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'select';
     }
   
break;
case 412:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1], true);
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-2] || $$[$0-2] === 'ALL') {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
     if (!$$[$0-2]) {
       keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
     }
     parser.suggestKeywords(keywords);
     parser.suggestFunctions();
     parser.suggestColumns({ identifierChain: [], source: 'select' });
     parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
   
break;
case 413:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4]), _$[$0-2]);
     parser.checkForSelectListKeywords($$[$0-2]);
   
break;
case 414:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-4], _$[$0-4], $$[$0-5], _$[$0-5]), _$[$0-3]);
     parser.checkForSelectListKeywords($$[$0-3]);
   
break;
case 415:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     parser.checkForSelectListKeywords($$[$0-1]);
     var keywords = ['FROM'];
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     parser.suggestTables({ prependFrom: true });
     parser.suggestDatabases({ prependFrom: true, appendDot: true });
   
break;
case 416:

   if (!$$[$0-1]) {
     parser.suggestKeywords(['ALL', 'DISTINCT']);
   }
 
break;
case 420: case 421:

     parser.addClauseLocation('whereClause', _$[$0-1], $$[$0].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0].limitClausePreceding || _$[$0-1], $$[$0].limitClauseLocation);
   
break;
case 422:

     var keywords = [];

     parser.addClauseLocation('whereClause', _$[$0-3], $$[$0-1].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0-2].limitClausePreceding || _$[$0-3], $$[$0-2].limitClauseLocation);

     if ($$[$0-3]) {
       if (typeof $$[$0-3].tableReferenceList.hasJoinCondition !== 'undefined' && !$$[$0-3].tableReferenceList.hasJoinCondition) {
         keywords.push({ value: 'ON', weight: 3 });
       }
       if ($$[$0-3].suggestKeywords) {
         keywords = parser.createWeightedKeywords($$[$0-3].suggestKeywords, 3);
       }
       if ($$[$0-3].tableReferenceList.suggestJoinConditions) {
         parser.suggestJoinConditions($$[$0-3].tableReferenceList.suggestJoinConditions);
       }
       if ($$[$0-3].tableReferenceList.suggestJoins) {
         parser.suggestJoins($$[$0-3].tableReferenceList.suggestJoins);
       }
       if ($$[$0-3].tableReferenceList.suggestKeywords) {
         keywords = keywords.concat(parser.createWeightedKeywords($$[$0-3].tableReferenceList.suggestKeywords, 3));
       }

       // Lower the weights for 'TABLESAMPLE'
       keywords.forEach(function (keyword) {
         if (keyword.value === 'TABLESAMPLE') {
           keyword.weight = 1.1;
         }
       });

       if ($$[$0-3].tableReferenceList.types) {
         var veKeywords = parser.getValueExpressionKeywords($$[$0-3].tableReferenceList);
         keywords = keywords.concat(veKeywords.suggestKeywords);
         if (veKeywords.suggestColRefKeywords) {
           parser.suggestColRefKeywords(veKeywords.suggestColRefKeywords);
           parser.addColRefIfExists($$[$0-3].tableReferenceList);
         }
       }
     }

     if ($$[$0-1].empty && $$[$0] && $$[$0].joinType.toUpperCase() === 'JOIN') {
       keywords = keywords.concat(['FULL', 'FULL OUTER', 'INNER', 'LEFT', 'LEFT OUTER', 'RIGHT', 'RIGHT OUTER']);
       parser.suggestKeywords(keywords);
       return;
     }

     if ($$[$0-1].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-1].suggestKeywords, 2));
     }

     if ($$[$0-1].suggestFilters) {
       parser.suggestFilters($$[$0-1].suggestFilters);
     }
     if ($$[$0-1].suggestGroupBys) {
       parser.suggestGroupBys($$[$0-1].suggestGroupBys);
     }
     if ($$[$0-1].suggestOrderBys) {
       parser.suggestOrderBys($$[$0-1].suggestOrderBys);
     }

     if ($$[$0-1].empty) {
       keywords.push({ value: 'UNION', weight: 2.11 });
     }

     keywords = keywords.concat([
       { value: 'FULL JOIN', weight: 1 },
       { value: 'FULL OUTER JOIN', weight: 1 },
       { value: 'INNER JOIN', weight: 1 },
       { value: 'JOIN', weight: 1 },
       { value: 'LEFT JOIN', weight: 1 },
       { value: 'LEFT OUTER JOIN', weight: 1 },
       { value: 'RIGHT JOIN', weight: 1 },
       { value: 'RIGHT OUTER JOIN', weight: 1 }
     ]);
     parser.suggestKeywords(keywords);
  
break;
case 423:

     // A couple of things are going on here:
     // - If there are no SelectConditions (WHERE, GROUP BY, etc.) we should suggest complete join options
     // - If there's an OptionalJoin at the end, i.e. 'SELECT * FROM foo | JOIN ...' we should suggest
     //   different join types
     // - The FromClause could end with a valueExpression, in which case we should suggest keywords like '='
     //   or 'AND' based on type

     if (!$$[$0-1]) {
       parser.addClauseLocation('whereClause', _$[$0-2]);
       parser.addClauseLocation('limitClause', _$[$0-2]);
       return;
     }
     parser.addClauseLocation('whereClause', _$[$0-2], $$[$0-1].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0-1].limitClausePreceding || _$[$0-2], $$[$0-1].limitClauseLocation);
     var keywords = [];

     if ($$[$0-1].suggestColRefKeywords) {
       parser.suggestColRefKeywords($$[$0-1].suggestColRefKeywords);
       parser.addColRefIfExists($$[$0-1]);
     }

     if ($$[$0-1].suggestKeywords && $$[$0-1].suggestKeywords.length) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-1].suggestKeywords, 2));
     }

     if ($$[$0-1].cursorAtEnd) {
       keywords.push({ value: 'UNION', weight: 2.11 });
     }
     parser.suggestKeywords(keywords);
   
break;
case 424:
this.$ = [ $$[$0] ];
break;
case 425:

     $$[$0-2].push($$[$0]);
   
break;
case 427: case 428:

     this.$ = { cursorAtStart : true, suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true };
   
break;
case 430:

     parser.checkForSelectListKeywords($$[$0-2]);
   
break;
case 431:

     parser.checkForSelectListKeywords($$[$0-3]);
   
break;
case 432:

     this.$ = { suggestKeywords: parser.getSelectListKeywords(), suggestTables: true, suggestDatabases: true, suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true };
   
break;
case 434: case 435: case 437:

     this.$ = { suggestKeywords: parser.getSelectListKeywords(), suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true,  };
   
break;
case 439:

     if ($$[$0]) {
       parser.addColumnAliasLocation($$[$0].location, $$[$0].alias, _$[$0-1]);
       this.$ = { valueExpression: $$[$0-1], alias: $$[$0].alias };
       if (!parser.yy.selectListAliases) {
         parser.yy.selectListAliases = [];
       }
       parser.yy.selectListAliases.push($$[$0-1].function && $$[$0-1].types && $$[$0-1].types.length && $$[$0-1].types[0] === 'UDFREF' ? { name: $$[$0].alias, udfRef: $$[$0-1].function, types: $$[$0-1].types } : { name: $$[$0].alias, types: $$[$0-1].types || ['T'] });
     } else {
       this.$ = { valueExpression: $$[$0-1] }
     }
   
break;
case 440:

     parser.addAsteriskLocation(_$[$0], [{ asterisk: true }]);
     this.$ = { asterisk: true }
   
break;
case 441:

     if ($$[$0]) {
       parser.addColumnAliasLocation($$[$0].location, $$[$0].alias, _$[$0-1]);
     }
   
break;
case 442:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.addColumnAliasLocation(_$[$0], $$[$0], _$[$0-2]);
     this.$ = { suggestAggregateFunctions: true };
   
break;
case 444:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'WHERE', weight: 7 }, { value: 'GROUP BY', weight: 6 }, { value: 'HAVING', weight: 5 }, { value: 'ORDER BY', weight: 4 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true, true, true]);

     if (keywords.length > 0) {
       this.$ = { suggestKeywords: keywords, empty: !$$[$0-4] && !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0] };
     } else {
       this.$ = {};
     }

     this.$.whereClauseLocation = $$[$0-4] ? _$[$0-4] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;

     if (!$$[$0-4] && !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0]) {
       this.$.suggestFilters = { prefix: 'WHERE', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
     if (!$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0]) {
       this.$.suggestGroupBys = { prefix: 'GROUP BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
     if (!$$[$0-1] && !$$[$0]) {
       this.$.suggestOrderBys = { prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
   
break;
case 445:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'where';
     }
   
break;
case 446:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'group by';
     }
   
break;
case 448:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'order by';
     }
   
break;
case 450:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-3], $$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'GROUP BY', weight: 8 }, { value: 'HAVING', weight: 7 }, { value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true, true]);
     if ($$[$0-5].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-5].suggestKeywords, 1));
     }
     this.$ = parser.getValueExpressionKeywords($$[$0-5], keywords);
     this.$.cursorAtEnd = !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0];
     if ($$[$0-5].columnReference) {
       this.$.columnReference = $$[$0-5].columnReference;
     }
     if (!$$[$0-3]) {
       parser.suggestGroupBys({ prefix: 'GROUP BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     if (!$$[$0-3] && !$$[$0-2] && !$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-5], _$[$0-5]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 451:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'HAVING', weight: 7 }, { value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true]);
     if ($$[$0-4].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-4].suggestKeywords, 8));
     }
     if ($$[$0-4].valueExpression) {
       this.$ = parser.getValueExpressionKeywords($$[$0-4].valueExpression, keywords);
       if ($$[$0-4].valueExpression.columnReference) {
         this.$.columnReference = $$[$0-4].valueExpression.columnReference;
       }
     } else {
       this.$ = { suggestKeywords: keywords };
     }
     this.$.cursorAtEnd = !$$[$0-2] && !$$[$0-1] && !$$[$0];
     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-4], _$[$0-4]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 452:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-1], $$[$0]],
       [{ value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true]);
     this.$ = { suggestKeywords: keywords, cursorAtEnd: !$$[$0-1] && !$$[$0] };
     if (!$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-3], _$[$0-3]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 453:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0]],
       [{ value: 'LIMIT', weight: 3 }],
       [true]);
     if ($$[$0-2].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-2].suggestKeywords, 4));
     }
     this.$ = { suggestKeywords: keywords, cursorAtEnd: !$$[$0] };
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-2], _$[$0-2]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 454:

     this.$ = { suggestKeywords: [], cursorAtEnd: true };
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4], $$[$0-5], _$[$0-5]);
     this.$.limitClauseLocation = _$[$0-1];
   
break;
case 465:

     parser.suggestKeywords(['ALL', 'DISTINCT', 'SELECT']);
   
break;
case 466:

     parser.suggestKeywords(['ALL', 'DISTINCT']);
   
break;
case 471:

     if ($$[$0].suggestFilters) {
       parser.suggestFilters({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
   
break;
case 472:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.suggestKeywords(['EXISTS', 'NOT EXISTS']);
     parser.suggestFilters({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 485:

     parser.suggestKeywords(['TABLE']);
   
break;
case 486:

     parser.suggestTables();
     parser.suggestDatabases({ appendDot: true });
     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 490:

     parser.addTablePrimary($$[$0-1]);
     if (!$$[$0-2]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 492:

     if (!$$[$0]) {
       $$[$0-1].suggestKeywords = ['OVER'];
     }
   
break;
case 499:

     parser.suggestKeywords(['OVER']);
   
break;
case 508:

     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 509: case 527:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-1].expressions);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 510:

     parser.valueExpressionSuggest();
     var keywords = parser.getSelectListKeywords(true);
     if (!$$[$0-2]) {
       if ($$[$0-4].toLowerCase() === 'group_concat') {
         keywords.push('ALL');
       } else {
         keywords.push('DISTINCT');
       }
     }
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 511: case 525:

     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = { function: $$[$0-5], types: ['UDFREF'] };
   
break;
case 512:

     if ($$[$0-1].cursorAtStart) {
       var keywords = parser.getSelectListKeywords(true);
       if (!$$[$0-2]) {
         if ($$[$0-4].toLowerCase() === 'group_concat') {
           keywords.push('ALL');
         } else {
           keywords.push('DISTINCT');
         }
       }
       if (parser.yy.result.suggestKeywords) {
         keywords = parser.yy.result.suggestKeywords.concat(keywords);
       }
       parser.suggestKeywords(keywords);
     }
     if (parser.yy.result.suggestFunctions && !parser.yy.result.suggestFunctions.types) {
       parser.applyArgumentTypesToSuggestions($$[$0-4], $$[$0-1].activePosition);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 521:

     parser.addFunctionArgumentLocations($$[$0-3], [{
       expression: { text: $$[$0-1] },
       location: _$[$0-1]
     }]);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] }
   
break;
case 522: case 528:

     this.$ = { function: $$[$0-2], types: ['UDFREF'] }
   
break;
case 523:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-1].expressions);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] }
   
break;
case 524:

     parser.valueExpressionSuggest();
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-2]) {
       keywords.push('DISTINCT');
       if (parser.yy.result.suggestKeywords) {
         keywords = parser.yy.result.suggestKeywords.concat(keywords);
       }
     }
     parser.suggestKeywords(keywords);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 526:

     if ($$[$0-1].cursorAtStart) {
       var keywords = parser.getSelectListKeywords();
       if (!$$[$0-2]) {
         keywords.push('DISTINCT');
       }
       parser.suggestKeywords(keywords);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 529:

     parser.valueExpressionSuggest();
     parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     var keywords = parser.getSelectListKeywords(true);
     if (!$$[$0-2]) {
       keywords.push('DISTINCT');
     }
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 530:

     parser.suggestValueExpressionKeywords($$[$0-2]);
     this.$ = { function: $$[$0-5], types: ['UDFREF'] };
   
break;
case 531:

     if (parser.yy.result.suggestFunctions && !parser.yy.result.suggestFunctions.types) {
       parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 532:

    this.$ = { function: $$[$0-2], types: ['UDFREF'] }
  
break;
case 533:

     parser.addFunctionArgumentLocations($$[$0-3], $$[$0-1].expressions);
     this.$ = {
       function: $$[$0-3],
       expression: $$[$0-1].expressions[$$[$0-1].expressions.length - 1].expression,
       types: ['UDFREF']
     }
   
break;
case 534:

     parser.valueExpressionSuggest();
     parser.applyArgumentTypesToSuggestions($$[$0-3], 1);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 535:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-2].expressions);
     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 536:

     parser.addFunctionArgumentLocations($$[$0-3], $$[$0-1].expressions);
     parser.applyArgumentTypesToSuggestions($$[$0-3], $$[$0-1].activePosition);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 541:

     var expression = $$[$0-3];
     parser.extractExpressionText(expression, $$[$0-3], $$[$0-2], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-5], [{
       expression: expression,
       location: {
         first_line: _$[$0-3].first_line,
         last_line: _$[$0-1].last_line,
         first_column: _$[$0-3].first_column,
         last_column: _$[$0-1].last_column
       }
     }]);
     this.$ = { types: [ $$[$0-1].toUpperCase() ] }
   
break;
case 542: case 547: case 548: case 1015:
this.$ = { types: [ 'T' ] };
break;
case 543:

     parser.valueExpressionSuggest();
     this.$ = { types: [ $$[$0-1].toUpperCase() ] };
   
break;
case 544: case 545:

     parser.valueExpressionSuggest();
     this.$ = { types: [ 'T' ] };
   
break;
case 546:
this.$ = { types: [ $$[$0-1].toUpperCase() ] };
break;
case 549:

     parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'AS', weight: 2 }]);
     this.$ =  { types: [ $$[$0-1].toUpperCase() ] };
   
break;
case 550:

     parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'AS', weight: 2 }]);
     this.$ = { types: [ 'T' ] };
   
break;
case 551: case 552:

     parser.suggestKeywords(parser.getTypeKeywords());
     this.$ = { types: [ 'T' ] };
   
break;
case 553:

     // We need to handle arbitrary UDFs here instead of inside UserDefinedFunction or there will be a conflict
     // with columnReference for functions like: db.udf(foo)
     var fn = $$[$0-1].chain[$$[$0-1].chain.length - 1].name.toLowerCase();
     parser.addFunctionArgumentLocations(fn, $$[$0].expressions, $$[$0-1].chain);
     if ($$[$0-1].lastLoc && $$[$0-1].lastLoc.location) {
       $$[$0-1].lastLoc.type = 'function';
       $$[$0-1].lastLoc.function = fn;
       $$[$0-1].lastLoc.location = {
         first_line: $$[$0-1].lastLoc.location.first_line,
         last_line: $$[$0-1].lastLoc.location.last_line,
         first_column: $$[$0-1].lastLoc.location.first_column,
         last_column: $$[$0-1].lastLoc.location.last_column - 1
       }
       if ($$[$0-1].lastLoc !== $$[$0-1].firstLoc) {
          $$[$0-1].firstLoc.type = 'database';
       } else {
         delete $$[$0-1].lastLoc.identifierChain;
       }
     }
     if ($$[$0].expressions && $$[$0].expressions.length) {
       this.$ = { function: fn, expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
     } else {
       this.$ = { function: fn, types: ['UDFREF'] }
     }
   
break;
case 554:

    parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
    if ($$[$0].expressions && $$[$0].expressions.length) {
      this.$ = { function: $$[$0-1], expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
    } else {
      this.$ = { function: $$[$0-1], types: ['UDFREF'] }
    }
  
break;
case 557:
this.$ = { types: ['COLREF'], columnReference: $$[$0].chain };
break;
case 558:
this.$ = { types: [ 'NULL' ], text: $$[$0] };
break;
case 559:

     var fn = $$[$0-1].chain[$$[$0-1].chain.length - 1].name.toLowerCase();
     parser.addFunctionArgumentLocations(fn, $$[$0].expressions, $$[$0-1].chain);
     $$[$0-1].lastLoc.type = 'function';
     $$[$0-1].lastLoc.function = fn;
     $$[$0-1].lastLoc.location = {
       first_line: $$[$0-1].lastLoc.location.first_line,
       last_line: $$[$0-1].lastLoc.location.last_line,
       first_column: $$[$0-1].lastLoc.location.first_column,
       last_column: $$[$0-1].lastLoc.location.last_column - 1
     }
     if ($$[$0-1].lastLoc !== $$[$0-1].firstLoc) {
        $$[$0-1].firstLoc.type = 'database';
     } else {
       delete $$[$0-1].lastLoc.identifierChain;
     }
     if ($$[$0].activePosition) {
       parser.applyArgumentTypesToSuggestions(fn, $$[$0].activePosition);
     }
     this.$ = { function: fn, types: ['UDFREF'] };
   
break;
case 560: case 566: case 567:

     parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-1], $$[$0].expressions);
     if ($$[$0].activePosition) {
       parser.applyArgumentTypesToSuggestions($$[$0-1], $$[$0].activePosition);
     }
     this.$ = { function: $$[$0-1], types: ['UDFREF'] };
   
break;
case 563:

     if ($$[$0].suggestKeywords) {
       this.$ = { types: ['COLREF'], columnReference: $$[$0], suggestKeywords: $$[$0].suggestKeywords };
     } else {
       this.$ = { types: ['COLREF'], columnReference: $$[$0] };
     }
   
break;
case 564: case 565:

     parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-1], $$[$0].expressions);
     if ($$[$0].expressions && $$[$0].expressions.length) {
       this.$ = { function: $$[$0-1], expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
     } else {
       this.$ = { function: $$[$0-1], types: ['UDFREF'] }
     }
   
break;
case 570:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }]
     }
   
break;
case 571:

     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = $$[$0-3];
   
break;
case 573: case 575:

     this.$ = {
       activePosition: 1,
       expressions: [{ expression: $$[$0], location: _$[$0] }]
     }
   
break;
case 574: case 576:

     this.$ = {
       activePosition: $$[$0-2].activePosition + 1,
       expressions: $$[$0-2].expressions.concat([{ expression: $$[$0], location: _$[$0] }])
     }
   
break;
case 577:

     this.$ = {
       activePosition: 1,
       expressions: [{ expression: $$[$0-2], location: _$[$0-2] }].concat($$[$0].expressions)
     }
   
break;
case 578:

     this.$ = {
       activePosition: $$[$0-4].activePosition + 1,
       expressions: $$[$0-4].expressions.concat([{ expression: $$[$0-2], location: _$[$0-2] }]).concat($$[$0].expressions)
     }
   
break;
case 579:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: $$[$0-2].activePosition + 1,
       expressions: $$[$0-2].expressions.concat([{ expression: { text: '' }, location: _$[$0] }])
     }
   
break;
case 580:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: $$[$0-4].activePosition + 1,
       expressions: $$[$0-4].expressions.concat([{ expression: { text: '' }, location: _$[$0-2] }]).concat($$[$0].expressions)
     }
   
break;
case 581:

     parser.suggestValueExpressionKeywords($$[$0-3].expressions[$$[$0-3].expressions.length - 1].expression);
     this.$ = {
       activePosition: $$[$0-3].activePosition,
       expressions: $$[$0-3].expressions.concat($$[$0].expressions)
     }
   
break;
case 582:

     parser.valueExpressionSuggest();
     this.$ = {
       cursorAtStart : true,
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-2] }].concat($$[$0].expressions)
     };
   
break;
case 583:

     parser.valueExpressionSuggest();
     this.$ = {
       cursorAtStart : true,
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }, { expression: { text: '' }, location: _$[$0] }]
     };
   
break;
case 584:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 2,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }, { expression: { text: '' }, location: _$[$0] }]
     };
   
break;
case 585:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 2,
       expressions: [{ expression: { text: '' }, location: _$[$0-3] }, { expression: { text: '' }, location: _$[$0-2] }].concat($$[$0].expressions)
     };
   
break;
case 597:

     parser.suggestKeywords([ 'WHERE' ]);
   
break;
case 598:

     parser.suggestKeywords([ 'SET' ]);
   
break;
case 614:

     parser.suggestKeywords([ '=' ]);
   
break;
case 623:

     if (! parser.yy.cursorFound) {
       parser.yy.result.useDatabase = $$[$0];
     }
   
break;
case 624: case 843:

     parser.suggestDatabases();
   
break;
case 626: case 627:

     return parser.yy.result;
   
break;
case 628:

     parser.prepareNewStatement();
   
break;
case 630: case 632: case 634:

     parser.addStatementLocation(_$[$0]);
   
break;
case 633: case 635:

     parser.addStatementLocation(_$[$0-3]);
   
break;
case 639:

     parser.suggestDdlAndDmlKeywords();
   
break;
case 768: case 771: case 857:
this.$ = '';
break;
case 783: case 786:

     parser.yy.correlatedSubQuery = false;
   
break;
case 784: case 788:

     parser.suggestKeywords(['EXISTS']);
   
break;
case 787:

     parser.suggestKeywords(['NOT EXISTS']);
   
break;
case 798: case 800: case 801: case 803:

     parser.suggestKeywords(['<', '<=', '<>', '=', '>', '>=']);
   
break;
case 832: case 858:

     parser.addTableLocation(_$[$0], [ { name: $$[$0] } ]);
     this.$ = { identifierChain: [ { name: $$[$0] } ] };
   
break;
case 833: case 859:

     parser.addDatabaseLocation(_$[$0-2], [ { name: $$[$0-2] } ]);
     parser.addTableLocation(_$[$0], [ { name: $$[$0-2] }, { name: $$[$0] } ]);
     this.$ = { identifierChain: [ { name: $$[$0-2] }, { name: $$[$0] } ] };
   
break;
case 835: case 840:

     parser.suggestDatabases();
     this.$ = { identifierChain: [{ name: $$[$0-2] }] };
   
break;
case 836: case 861:

     parser.suggestTablesOrColumns($$[$0-2]);
   
break;
case 837:
this.$ = [{ name: $$[$0] }];
break;
case 838:
this.$ = [{ name: $$[$0-2] }, { name: $$[$0-1] }];
break;
case 839:

     parser.suggestDatabases({ appendDot: true });
   
break;
case 860:

     parser.suggestTables();
     parser.suggestDatabases({ prependDot: true });
   
break;
case 863:
this.$ = { identifierChain: $$[$0-1].identifierChain, alias: $$[$0] };
break;
case 866:

     parser.yy.locations[parser.yy.locations.length - 1].type = 'column';
   
break;
case 867: case 1032:

     parser.addAsteriskLocation(_$[$0], $$[$0-2].concat({ asterisk: true }));
   
break;
case 869:

     this.$ = [ $$[$0].identifier ];
     parser.yy.firstChainLocation = parser.addUnknownLocation($$[$0].location, [ $$[$0].identifier ]);
   
break;
case 870:

     if (parser.yy.firstChainLocation) {
       parser.yy.firstChainLocation.firstInChain = true;
       delete parser.yy.firstChainLocation;
     }
     $$[$0-2].push($$[$0].identifier);
     parser.addUnknownLocation($$[$0].location, $$[$0-2].concat());
   
break;
case 871:

     parser.suggestColumns({
       identifierChain: $$[$0-2]
     });
     this.$ = { suggestKeywords: [{ value: '*', weight: 10000 }] };
   
break;
case 872:

     parser.suggestColumns({
       identifierChain: $$[$0-4]
     });
     this.$ = { suggestKeywords: [{ value: '*', weight: 10000 }] };
   
break;
case 873:
this.$ = [ $$[$0].identifier ];
break;
case 874:

     $$[$0-2].push($$[$0].identifier);
   
break;
case 876:

     parser.suggestColumns({ identifierChain: $$[$0-2] });
   
break;
case 877:

     parser.suggestColumns({ identifierChain: $$[$0-4] });
   
break;
case 879:
this.$ = { identifier: { name: $$[$0] }, location: _$[$0] };
break;
case 900: case 901:

     // verifyType($$[$0], 'BOOLEAN');
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 902: case 927:

     this.$ = $$[$0];
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 903:

     // verifyType($$[$0], 'NUMBER');
     this.$ = $$[$0];
     $$[$0].types = ['NUMBER'];
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 904: case 905: case 906:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 907:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-5], $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 908:

     this.$ = { types: [ 'BOOLEAN' ] };
     // clear correlated flag after completed sub-query (set by lexer)
     parser.yy.correlatedSubQuery = false;
   
break;
case 910: case 911: case 912: case 913:

     parser.addColRefToVariableIfExists($$[$0-2], $$[$0]);
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 914: case 915: case 916: case 917: case 947: case 1005: case 1006:
this.$ = { types: [ 'BOOLEAN' ] };
break;
case 918:

     this.$ = { types: [ 'BOOLEAN' ] }
     parser.extractExpressionText(this.$, $$[$0-5], $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 919:

     this.$ = { types: [ 'BOOLEAN' ] }
     parser.extractExpressionText(this.$, $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 920: case 921:

     // verifyType($$[$0-2], 'BOOLEAN');
     // verifyType($$[$0], 'BOOLEAN');
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 922: case 923: case 924:

     // verifyType($$[$0-2], 'NUMBER');
     // verifyType($$[$0], 'NUMBER');
     this.$ = { types: [ 'NUMBER' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 925:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 926:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 928:

     this.$ = $$[$0];
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 930:

     parser.suggestKeywords(['BETWEEN', 'EXISTS', 'IN', 'LIKE', 'REGEXP', 'RLIKE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 931: case 933:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
break;
case 932:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.suggestKeywords(['EXISTS']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 934:

     parser.suggestFunctions({ types: [ 'BOOLEAN' ] });
     parser.suggestColumns({ types: [ 'BOOLEAN' ] });
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 935:
this.$ = { types: [ 'T' ], suggestFilters: $$[$0].suggestFilters };
break;
case 936:

     parser.suggestFunctions();
     parser.suggestColumns();
     this.$ = { types: [ 'T' ] };
   
break;
case 937:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 938:

     parser.suggestFunctions({ types: [ 'NUMBER' ] });
     parser.suggestColumns({ types: [ 'NUMBER' ] });
     this.$ = { types: [ 'NUMBER' ] };
   
break;
case 939:

     parser.suggestKeywords(['FALSE', 'NOT NULL', 'NOT TRUE', 'NOT FALSE', 'NULL', 'TRUE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 940:

     parser.suggestKeywords(['FALSE', 'NULL', 'TRUE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 941:

     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 942: case 943: case 944:

     parser.suggestKeywords(['NOT']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 945:

     parser.valueExpressionSuggest($$[$0-5], $$[$0-3] ? 'IS NOT DISTINCT FROM' : 'IS DISTINCT FROM');
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 946:

     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 948:

     this.$ = $$[$0-1];
   
break;
case 949:

     parser.valueExpressionSuggest();
     this.$ = { types: ['T'], typeSet: true };
   
break;
case 950:

     parser.valueExpressionSuggest($$[$0], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 951: case 952: case 953:

     parser.valueExpressionSuggest($$[$0], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 954: case 955: case 956: case 957:

     if (!$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0]);
       parser.addColRefIfExists($$[$0]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 958: case 960:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 959:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ] , typeSet: true, endsWithLessThanOrEqual: true };
   
break;
case 961:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true, endsWithLessThanOrEqual: $$[$0-1] === '<='  };
   
break;
case 962: case 963: case 964: case 965:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-2]);
       parser.addColRefIfExists($$[$0-2]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 966:

     if ($$[$0].inValueEdit) {
       parser.valueExpressionSuggest($$[$0-3], $$[$0-2] + ' ' + $$[$0-1]);
       parser.applyTypeToSuggestions($$[$0-3]);
     }
     if ($$[$0].cursorAtStart) {
       parser.suggestKeywords(['SELECT']);
     }
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 967:

     if ($$[$0].inValueEdit) {
       parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
       parser.applyTypeToSuggestions($$[$0-2]);
     }
     if ($$[$0].cursorAtStart) {
       parser.suggestKeywords(['SELECT']);
     }
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 968: case 969:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-5].suggestFilters };
break;
case 970: case 971:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-4].suggestFilters };
break;
case 972:

     if ($$[$0-2].types[0] === $$[$0].types[0] && !$$[$0-5].typeSet) {
       parser.applyTypeToSuggestions($$[$0-2]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-5].suggestFilters };
   
break;
case 973:

     if ($$[$0-5].types[0] === $$[$0].types[0] && !$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0-5]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
   
break;
case 974:

     if ($$[$0-5].types[0] === $$[$0-2].types[0] && !$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-5]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 975:

     parser.valueExpressionSuggest($$[$0-5], $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 976: case 982:

     parser.suggestValueExpressionKeywords($$[$0-1], ['AND']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 977:

     parser.valueExpressionSuggest($$[$0-3], $$[$0-2] + ' ' + $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 978:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0-4].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-4].suggestFilters };
   
break;
case 979:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
   
break;
case 980:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 981:

     parser.valueExpressionSuggest($$[$0-4], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-4]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 983:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 984: case 986: case 988: case 990:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true, suggestFilters: true };
   
break;
case 985: case 989:

     parser.addColRefIfExists($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 987: case 991:

     parser.addColRefIfExists($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 992: case 993:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     parser.applyTypeToSuggestions({ types: [ 'NUMBER' ] });
     this.$ = { types: [ 'NUMBER' ], typeSet: true };
   
break;
case 994: case 995: case 996:

     if (!$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
       parser.addColRefIfExists($$[$0]);
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 997: case 998: case 999:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     parser.applyTypeToSuggestions({ types: ['NUMBER'] });
     this.$ = { types: [ 'NUMBER' ], typeSet: true };
   
break;
case 1000: case 1001: case 1002:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
       parser.addColRefIfExists($$[$0-2]);
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 1003:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-1].suggestFilters };
break;
case 1004:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
break;
case 1007:

     parser.valueExpressionSuggest(undefined, $$[$0]);
     parser.applyTypeToSuggestions({ types: [ 'STRING' ] });
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 1008:

     parser.valueExpressionSuggest(undefined, $$[$0-1] + ' ' + $$[$0]);
     parser.applyTypeToSuggestions({ types: [ 'STRING' ] });
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 1010:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 1012:

     parser.suggestValueExpressionKeywords($$[$0-2], ['WHEN']);
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 1013:

      this.$ = $$[$0];
      this.$.suggestFilters = $$[$0-1].suggestFilters;
    
break;
case 1014:
this.$ = { types: [ 'T' ], suggestFilters: $$[$0-1].suggestFilters };
break;
case 1016: case 1018:

     $$[$0].position = 1;
   
break;
case 1017:

     $$[$0].position = $$[$0-2].position + 1;
     this.$ = $$[$0];
   
break;
case 1019:

     $$[$0-2].position += 1;
   
break;
case 1020:

     $$[$0-2].position = 1;
   
break;
case 1021:

     $$[$0-4].position += 1;
   
break;
case 1022:

     parser.valueExpressionSuggest();
     $$[$0-2].position += 1;
   
break;
case 1023:

     parser.valueExpressionSuggest();
     $$[$0-4].position += 1;
   
break;
case 1024:

     parser.suggestValueExpressionKeywords($$[$0-3]);
   
break;
case 1025: case 1026:

     parser.valueExpressionSuggest();
     this.$ = { cursorAtStart : true, position: 1 };
   
break;
case 1027: case 1028:

     parser.valueExpressionSuggest();
     this.$ = { position: 2 };
   
break;
case 1031:

     var lastLoc = parser.yy.locations[parser.yy.locations.length - 1];
     if (lastLoc.type !== 'variable') {
       lastLoc.type = 'column';
     }
     // used for function references with db prefix
     var firstLoc = parser.yy.locations[parser.yy.locations.length - $$[$0].length];
     this.$ = { chain: $$[$0], firstLoc: firstLoc, lastLoc: lastLoc }
   
break;
case 1038:

     parser.suggestValues($$[$0]);
   
break;
case 1039:
this.$ = { types: [ 'NUMBER' ], text: $$[$0] };
break;
case 1045: case 1047: case 1048:
this.$ = $$[$0-1] + $$[$0];
break;
case 1046: case 1049:
this.$ = $$[$0-2] + $$[$0-1] + $$[$0];
break;
case 1050:
this.$ = $$[$0-3] + $$[$0-2] + $$[$0-1] + $$[$0];
break;
case 1051:

     if (/\$\{[^}]*\}/.test($$[$0])) {
       parser.addVariableLocation(_$[$0], $$[$0]);
       this.$ = { types: [ 'STRING' ], columnReference: [{ name: $$[$0] }], text: "'" + $$[$0] + "'" }
     } else {
       this.$ = { types: [ 'STRING' ] }
     }
   
break;
case 1052:

     if (/\$\{[^}]*\}/.test($$[$0])) {
       parser.addVariableLocation(_$[$0], $$[$0]);
       this.$ = { types: [ 'STRING' ], columnReference: [{ name: $$[$0] }], text: '"' + $$[$0] + '"' }
     } else {
       this.$ = { types: [ 'STRING' ], text: '"' + $$[$0] + '"' }
     }
   
break;
case 1053:
this.$ = { types: [ 'BOOLEAN' ], text: $$[$0] };
break;
case 1054:

    this.$ = { partialQuote: '\'', missingEndQuote: parser.yy.missingEndQuote };
  
break;
case 1055:

    this.$ = { partialQuote: '"', missingEndQuote: parser.yy.missingEndQuote };
  
break;
case 1062:

     this.$ = $$[$0];

     if (parser.yy.latestTablePrimaries.length > 0) {
       var idx = parser.yy.latestTablePrimaries.length - 1;
       var tables = [];
       do {
         var tablePrimary = parser.yy.latestTablePrimaries[idx];
         if (!tablePrimary.subQueryAlias) {
           tables.unshift(tablePrimary.alias ? { identifierChain: tablePrimary.identifierChain, alias: tablePrimary.alias } : { identifierChain: tablePrimary.identifierChain })
         }
         idx--;
       } while (idx >= 0 && tablePrimary.join && !tablePrimary.subQueryAlias)

       if (tables.length > 0) {
         this.$.suggestJoins = {
           prependJoin: true,
           tables: tables
         };
       }
      }
   
break;
case 1069:

     this.$ = {
       primary: $$[$0-1]
     }
     if ($$[$0-1].identifierChain) {
       if ($$[$0]) {
         $$[$0-1].alias = $$[$0].alias
         parser.addTableAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
       }
       parser.addTablePrimary($$[$0-1]);
     }

     var keywords = [];
     if (!$$[$0]) {
       keywords = ['AS'];
     } else if ($$[$0].suggestKeywords) {
       keywords = $$[$0].suggestKeywords;
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 1070:

     this.$ = {
       primary: $$[$0-1]
     };

     if ($$[$0]) {
       this.$.primary.alias = $$[$0].alias;
       parser.addTablePrimary({ subQueryAlias: $$[$0].alias });
       parser.addSubqueryAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
     }

     var keywords = [];
     if (!$$[$0]) {
       keywords = ['AS'];
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 1071:

     if ($$[$0]) {
       parser.addTableAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
     }
   
break;
case 1072:

     if ($$[$0]) {
       parser.addTablePrimary({ subQueryAlias: $$[$0].alias });
       parser.addSubqueryAliasLocation($$[$0].location, $$[$0].alias);
     }
   
break;
case 1082:

     parser.pushQueryState();
   
break;
case 1083:

     parser.popQueryState();
   
break;
case 1085:

     if ($$[$0-1]) {
       $$[$0-2].alias = $$[$0-1].alias;
       parser.addTablePrimary({ subQueryAlias: $$[$0-1].alias });
       parser.addSubqueryAliasLocation($$[$0-1].location, $$[$0-1].alias, $$[$0-2].identifierChain);
     }
     this.$ = $$[$0-2];
   
break;
case 1088:

     var subQuery = parser.getSubQuery($$[$0]);
     subQuery.columns.forEach(function (column) {
       parser.expandIdentifierChain({ wrapper: column });
       delete column.linked;
     });
     parser.popQueryState(subQuery);
     this.$ = subQuery;
   
break;
case 1105: case 1106: case 1107: case 1108:
this.$ = { alias: $$[$0], location: _$[$0] };
break;
case 1115: case 1116:

     if (parser.yy.result.suggestFunctions) {
       parser.suggestAggregateFunctions();
     }
   
break;
case 1117:

     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestKeywords([{ value: 'PARTITION BY', weight: 2 }, { value: 'ORDER BY', weight: 1 }]);
     } else if (!$$[$0-2]) {
       parser.suggestKeywords(['PARTITION BY']);
     }
   
break;
case 1118:

      if (!$$[$0-1]) {
        parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'ORDER BY', weight: 2 }]);
      } else {
        parser.suggestValueExpressionKeywords($$[$0-3]);
      }
    
break;
case 1127:

      // Only allowed in last order by
      delete parser.yy.result.suggestAnalyticFunctions;
    
break;
case 1128:

      var keywords = [];
      if ($$[$0-2].suggestKeywords) {
        keywords = parser.createWeightedKeywords($$[$0-2].suggestKeywords, 2);
      }
      if (!$$[$0]) {
        keywords = keywords.concat([{ value: 'RANGE BETWEEN', weight: 1 }, { value: 'ROWS BETWEEN', weight: 1 }]);
      }
      parser.suggestKeywords(keywords);
    
break;
case 1134:

     parser.suggestKeywords(['BETWEEN']);
   
break;
case 1135:

     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestKeywords(['CURRENT ROW', 'UNBOUNDED PRECEDING']);
     } else if (!$$[$0-1]) {
       parser.suggestKeywords(['AND']);
     }
   
break;
case 1140:

    lexer.popState();
  
break;
case 1141:

    lexer.begin('hdfs');
  
break;
case 1143:

      parser.suggestHdfs({ path: $$[$0-3] });
    
break;
case 1144:

     parser.suggestHdfs({ path: $$[$0-2] });
   
break;
case 1145:

      parser.suggestHdfs({ path: $$[$0-1] });
    
break;
case 1146:

     parser.suggestHdfs({ path: '' });
   
break;
case 1147:

      parser.suggestHdfs({ path: '' });
    
break;
case 1153:

     parser.suggestKeywords(['PRECEDING']);
   
break;
case 1154: case 1159:

     parser.suggestKeywords(['ROW']);
   
break;
case 1158:

     parser.suggestKeywords(['CURRENT ROW', 'UNBOUNDED FOLLOWING']);
   
break;
case 1160:

     parser.suggestKeywords(['FOLLOWING']);
   
break;
case 1164:
this.$ = { inValueEdit: true };
break;
case 1165:
this.$ = { inValueEdit: true, cursorAtStart: true };
break;
case 1166: case 1167: case 1168:

     this.$ = { suggestKeywords: ['NOT'] }
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 1172: case 1173: case 1174:

     parser.suggestFunctions({ types: [ 'STRING' ] });
     parser.suggestColumns({ types: [ 'STRING' ] });
     this.$ = { types: ['BOOLEAN'] }
   
break;
case 1175:

     this.$ = parser.findCaseType($$[$0-1])
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 1176:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 1177:
this.$ = parser.findCaseType($$[$0-1]);
break;
case 1178:

     parser.suggestValueExpressionKeywords($$[$0-1], ['END']);
     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1179:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1180:
this.$ = parser.findCaseType($$[$0-2]);
break;
case 1181:

     if ($$[$0].toLowerCase() !== 'end') {
       parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'END', weight: 3 }, { value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     } else {
       parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     }
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1182:

     if ($$[$0].toLowerCase() !== 'end') {
       parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'END', weight: 3 }, { value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     } else {
       parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     }
     this.$ = parser.findCaseType($$[$0-2]);
   
break;
case 1183:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
     this.$.suggestFilters = $$[$0-1].suggestFilters
   
break;
case 1184:

     parser.valueExpressionSuggest();
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1185:

     parser.valueExpressionSuggest();
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 1186:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = $$[$0-1];
   
break;
case 1187:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { types: [ 'T' ] };
   
break;
case 1190:

     this.$ = { caseTypes: [ $$[$0] ], lastType: $$[$0] }
     parser.extractExpressionText(this.$, $$[$0]);
   
break;
case 1191:

     $$[$0-1].caseTypes.push($$[$0]);
     this.$ = { caseTypes: $$[$0-1].caseTypes, lastType: $$[$0] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 1195:

     parser.suggestValueExpressionKeywords($$[$0-2], ['WHEN']);
   
break;
case 1197:

     this.$ = $$[$0]
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 1198:
this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: $$[$0].suggestFilters };
break;
case 1199:
this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: $$[$0-1].suggestFilters };
break;
case 1200:
this.$ = { caseTypes: [$$[$0]], suggestFilters: $$[$0-2].suggestFilters };
break;
case 1201: case 1202:
this.$ = { caseTypes: [$$[$0]], suggestFilters: $$[$0].suggestFilters };
break;
case 1203:

     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1204:

     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [$$[$0]] };
   
break;
case 1205:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1206:

      parser.valueExpressionSuggest();
      parser.suggestKeywords(['WHEN']);
      this.$ = { caseTypes: [{ types: ['T'] }] };
    
break;
case 1207: case 1209:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: true };
   
break;
case 1208:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: true };
   
break;
case 1210:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [$$[$0]], suggestFilters: true };
   
break;
case 1211:

     parser.suggestValueExpressionKeywords($$[$0-1], ['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1212:

     parser.suggestValueExpressionKeywords($$[$0-2], ['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1213: case 1214: case 1215: case 1216:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
}
},
table: [o($V0,$V1,{341:1,266:2}),{1:[3]},o($V2,$V3,{342:3,346:4,20:5,157:6,46:7,21:8,22:9,23:10,24:11,25:12,26:13,27:14,28:15,29:16,30:17,35:19,36:20,37:21,158:22,159:23,170:24,171:25,38:26,44:27,160:33,4:$V4,8:$V5,12:$V6,16:$V7,164:$V8,176:$V9,243:$Va,274:$Vb,324:$Vc,340:$Vd,510:$Ve}),{343:[1,39],347:[1,40]},o($V2,[2,630]),o($V2,[2,636]),o($V2,[2,637]),o($V2,[2,638]),o($V2,[2,16]),o($V2,[2,17]),o($V2,[2,18]),o($V2,[2,19]),o($V2,[2,20]),o($V2,[2,21]),o($V2,[2,22]),o($V2,[2,23]),o($V2,[2,24]),o($V2,[2,25]),{31:[1,41],32:42,61:43,65:$Vf,115:$Vg,230:$Vh,350:46,351:$Vi,352:$Vj},o($V2,[2,28]),o($V2,[2,29]),o($V2,[2,30]),o($V2,[2,246]),o($V2,[2,247]),{81:[1,51],171:50,243:$Va},o($Vk,$Vl,{172:52,261:53,263:54,265:$Vm}),{39:56,127:[1,57]},{45:[1,58]},{41:[1,61],49:[1,62],59:59,65:[1,60],368:$Vn,386:$Vo},{41:[1,67],49:[1,68],59:65,65:[1,66],368:$Vn,386:$Vo},{41:[1,69]},{61:70,65:$Vf,115:$Vg,230:$Vh,350:46,351:$Vi,352:$Vj},{42:71,61:73,65:$Vf,115:$Vg,121:72,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},o($V2,[2,248]),{61:73,65:$Vf,115:$Vg,121:79,230:$Vh,325:75,331:76,333:77,350:46,351:$Vi,352:$Vj,361:$Vp,430:78},{61:73,65:$Vf,115:$Vg,121:82,177:80,179:81,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},o($Vq,$Vr,{244:83,31:$Vs,247:[1,84],250:$Vt}),{41:[1,87],49:[1,88]},{165:[1,89]},{1:[2,625]},o($V0,$V1,{266:90}),o($V2,[2,26]),{33:[1,91],270:[1,92]},o($Vu,[2,475]),o($Vv,[2,648]),o($Vv,[2,649]),o($Vv,[2,650]),o($Vv,[2,645]),o($Vv,[2,646]),o($Vv,[2,647]),o($Vk,$Vl,{261:53,263:54,172:93,265:$Vm}),{46:94,170:24,171:25,176:$V9,243:$Va},o($Vk,[2,264]),o($Vk,[2,456],{263:95,265:$Vm}),o($Vw,[2,458]),o([31,243,250],$V1,{266:96}),o($V2,[2,31]),{81:[1,97]},{46:98,170:24,171:25,176:$V9,243:$Va},o($Vx,$Vy,{60:99,309:$Vz}),{61:101,65:$Vf,115:$Vg,230:$Vh,350:46,351:$Vi,352:$Vj},o($VA,$Vy,{60:102,309:$Vz}),o($VA,$Vy,{60:103,309:$Vz}),o($VB,[2,765]),o($VB,[2,766]),o($VA,$VC,{152:104,309:$VD}),{61:106,65:$Vf,115:$Vg,230:$Vh,350:46,351:$Vi,352:$Vj},o($VA,$VC,{152:107,309:$VD}),o($VA,$VC,{152:108,309:$VD}),o($VA,$VC,{152:109,309:$VD}),o($V2,[2,623]),o($V2,[2,1217]),o($V2,$VE,{270:[1,110]}),o($Vv,[2,855]),{58:[1,111],361:[1,112]},{16:[1,113]},{16:[2,602]},{16:[2,604]},{16:[2,862],61:73,65:$Vf,115:$Vg,121:114,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},o($VF,[2,858],{270:[1,115]}),o([81,243],[2,273],{87:[1,116]}),o($VG,[2,275]),{45:[1,117]},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:120,229:150,230:$Vh,245:118,253:119,256:$VO,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($Vq,$Vr,{244:176,31:$Vs,250:$Vt}),o($Vb1,[2,418]),o($Vb1,[2,419]),{42:177,61:73,65:$Vf,115:$Vg,121:178,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{42:179,61:73,65:$Vf,115:$Vg,121:178,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},o($VA,[2,260],{166:180,41:[1,181]}),o($V2,$V3,{346:4,20:5,157:6,46:7,21:8,22:9,23:10,24:11,25:12,26:13,27:14,28:15,29:16,30:17,35:19,36:20,37:21,158:22,159:23,170:24,171:25,38:26,44:27,160:33,342:182,4:$V4,8:$V5,12:$V6,16:$V7,164:$V8,176:$V9,243:$Va,274:$Vb,324:$Vc,340:$Vd,510:$Ve}),{34:183,53:186,56:$VH,57:$VI,61:184,65:$Vf,98:[1,189],115:$Vg,229:190,230:$Vh,270:$VP,271:185,272:[1,187],273:[1,188],350:46,351:$Vi,352:$Vj,355:[1,191],392:$V91,393:$Va1,398:193,401:194,451:[1,192],456:156,457:157},{61:195,65:$Vf,115:$Vg,230:$Vh,350:46,351:$Vi,352:$Vj},o($Vk,[2,262]),{83:[1,196]},o($Vw,[2,459]),{31:$Vs,243:$Vr,244:197,250:$Vt},{61:73,65:$Vf,89:200,115:$Vg,121:152,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp,412:198,428:199},o($V2,[2,39]),o($V2,[2,56],{350:46,61:201,65:$Vf,115:$Vg,230:$Vh,351:$Vi,352:$Vj}),{97:[1,202]},o($V2,[2,65]),{61:73,65:$Vf,66:203,68:204,74:205,115:$Vg,121:206,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{61:73,65:$Vf,74:207,115:$Vg,121:206,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{61:73,65:$Vf,115:$Vg,121:208,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{373:[1,209]},o($V2,[2,231]),{42:210,61:73,65:$Vf,115:$Vg,121:178,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{42:211,61:73,65:$Vf,115:$Vg,121:178,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{42:212,61:73,65:$Vf,115:$Vg,121:178,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{42:213,61:73,65:$Vf,115:$Vg,121:214,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{361:[1,215]},o($Vv,[2,857]),{61:73,65:$Vf,89:144,115:$Vg,121:152,151:219,230:$Vh,326:216,335:217,337:218,350:46,351:$Vi,352:$Vj,361:$Vp,432:220},{16:[2,863]},{61:73,65:$Vf,115:$Vg,121:221,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{61:73,65:$Vf,115:$Vg,121:82,179:222,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{81:[1,223]},o($Vw,[2,405],{246:224,183:226,87:$Vc1,184:[1,227]}),o($Vd1,[2,424]),o($Vd1,$Ve1,{350:46,61:73,398:193,401:194,255:228,443:242,121:243,53:244,33:$Vf1,45:$Vg1,56:$VH,57:$VI,65:$Vf,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,115:$Vg,144:$Vl1,230:$Vh,256:$Vm1,351:$Vi,352:$Vj,355:$Vn1,359:$Vo1,360:$Vp1,361:$Vp,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),o($Vd1,[2,440]),o($Vw1,[2,899]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:249,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:250,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:251,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:252,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{81:$Vx1,440:253},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:255,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:257,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,395:$Vy1,398:158,401:159,432:135,444:256,452:143,454:151,456:156,457:157,458:160,506:258,508:259},o($Vw1,[2,557],{313:261,81:$Vz1}),{81:$Vz1,313:263},o($Vw1,[2,555]),o($Vw1,[2,556]),o($Vw1,[2,558]),o($VA1,[2,1031],{270:[1,264]}),{81:[2,537]},{81:[2,538]},{81:[2,539]},{81:[2,540]},o($Vw1,[2,586],{278:265,280:266,321:$VB1}),{280:268,321:$VB1},o($Vw1,[2,494]),o($Vw1,[2,1037]),o($VC1,[2,869]),o($VD1,[2,502]),o($VD1,[2,503]),o($VD1,[2,504]),{81:[1,269]},{81:[1,270]},o($Vw1,[2,1039]),o($Vw1,[2,1040]),o([33,45,52,56,57,65,79,81,83,87,97,109,110,111,114,115,131,144,184,192,203,216,217,218,219,220,221,222,223,228,230,234,241,242,256,265,267,270,343,347,351,352,355,359,360,361,362,363,364,366,369,370,371,372,374,377,378,379,380,382,383,385,387,388,389,390,391,394,395,442],[2,879]),{81:[1,271]},{81:[1,272]},{81:[1,273]},o($Vw1,[2,1042]),o($Vw1,[2,1043]),o($Vw1,[2,1051]),o($Vw1,[2,1052]),o($Vw1,[2,1053]),{81:[2,513]},{81:[2,514]},{81:[2,515]},{81:[2,516]},{81:[2,517]},{81:[2,518]},{81:[2,519]},{81:[2,520]},o($Vw1,[2,1044],{270:[1,274]}),{392:[1,275],393:[1,276]},{392:[1,277]},{56:[1,279],58:[1,278]},{57:[1,281],58:[1,280]},o($Vw1,[2,1056]),o($Vw1,[2,1057]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:120,229:150,230:$Vh,245:282,253:119,256:$VO,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{127:[2,36]},o($VE1,$VE,{270:$VF1}),{45:[2,45]},{42:284,61:73,65:$Vf,115:$Vg,121:178,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},o($VA,[2,261]),o($V2,[2,631]),o($V2,[2,27]),o($V2,[2,477]),o($V2,[2,478],{350:46,61:285,65:$Vf,115:$Vg,230:$Vh,351:$Vi,352:$Vj}),o($V2,[2,480]),o($V2,[2,481]),o($V2,[2,482]),o($V2,[2,483]),o($Vx,[2,1034]),{229:286,270:$VP,392:$V91,393:$Va1,456:156,457:157},{229:287,270:$VP,392:$V91,393:$Va1,456:156,457:157},o($VG1,[2,773]),o($VG1,[2,774]),o($Vu,[2,476]),o($Vk,$Vl,{261:53,263:54,172:288,265:$Vm}),{171:289,243:$Va},{83:[1,290],87:[1,291]},o($VH1,[2,844]),{33:[1,292]},o($V2,$VI1,{62:293,50:294,51:295,52:$VJ1}),{373:[1,297]},o($V2,[2,66]),o($VK1,[2,162],{69:298,126:299,127:[1,300]}),o($VL1,[2,78],{75:301,78:302,79:[1,303],81:[1,304]}),o($VM1,[2,837],{270:[1,305]}),o($VN1,[2,214],{146:306,148:307,81:[1,308]}),o($V2,[2,780],{153:309,408:[1,310]}),o($VA,[2,783]),o($V2,[2,238],{155:311,156:[1,312]}),o($V2,[2,240]),o($V2,[2,484]),o($V2,[2,1218]),o($V2,$VO1,{270:$VF1}),o($Vv,[2,856]),o($VP1,[2,619],{327:313,87:[1,314],184:[1,315]}),o($VQ1,[2,606]),{33:[1,316]},{33:[2,616]},o($VR1,[2,866],{270:[1,317]}),o($VF,[2,859]),o($VG,[2,276]),o($VS1,$VT1,{181:318,469:319}),o($Vw,[2,406]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:120,229:150,230:$Vh,253:320,256:$VO,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($VU1,$VV1,{251:321,258:322,260:323,267:$VW1}),{42:332,61:73,65:$Vf,81:$Vx1,115:$Vg,121:178,185:325,188:326,209:328,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp,440:333,459:327,461:329,463:330,464:331},o($Vd1,[2,439]),o($VX1,[2,1058],{439:334,97:[1,335]}),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:336,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:337,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:338,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:339,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{79:$Vh1,362:[1,341],377:[1,340],382:$Vu1,383:$Vv1,443:342},{81:[1,343]},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:344,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:345,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:346,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:347,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:348,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:349,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($Vw1,[2,925]),o($VY1,[2,1105]),o($VY1,[2,1106]),{53:351,56:$VH,57:$VI,61:73,65:$Vf,115:$Vg,121:350,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp,398:193,401:194},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:352,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:353,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:354,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($VZ1,[2,900],{443:242,33:$Vf1,79:$Vh1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,360:$Vp1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),o($VZ1,[2,901],{443:242,33:$Vf1,79:$Vh1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,360:$Vp1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),o($VZ1,[2,902],{443:242,33:$Vf1,79:$Vh1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,360:$Vp1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),o($V_1,[2,903],{443:242}),o($Vw1,[2,908]),o($VS1,$VT1,{469:319,440:333,181:355,464:356,81:$Vx1}),{33:$Vf1,79:$Vh1,83:[1,357],97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1,443:242},o($Vw1,[2,927]),{33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1,395:$Vy1,443:242,444:358,506:258,508:259},{371:[1,360],372:[1,359],395:$Vy1,508:361},o($V$1,[2,1190]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:362,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($Vw1,[2,553]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,83:[1,363],89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:365,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,295:364,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($Vw1,[2,554]),{61:73,65:$Vf,89:367,115:$Vg,121:152,230:$Vh,256:[1,366],350:46,351:$Vi,352:$Vj,361:$Vp},o($Vw1,[2,492]),o($Vw1,[2,587]),{61:73,65:$Vf,81:[1,370],115:$Vg,121:368,230:$Vh,322:369,350:46,351:$Vi,352:$Vj,361:$Vp},o($Vw1,[2,493]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,83:[1,371],89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:365,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,295:372,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,83:[1,374],89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:373,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o([56,57,65,81,83,97,98,109,114,115,230,270,272,273,274,297,298,299,300,301,302,303,304,305,306,307,309,310,351,352,354,355,358,361,365,373,392,393],$Vr,{244:375,31:$Vs,250:$Vt}),o($V02,$Vr,{244:378,31:$Vs,83:[1,377],250:$Vt,256:[1,376]}),o($V02,$Vr,{244:379,31:$Vs,83:[1,380],250:$Vt}),o($Vw1,[2,1045],{392:[1,381],393:[1,382]}),o($Vw1,[2,1047]),{392:[1,383]},o($Vw1,[2,1048]),{56:[1,384]},o($V12,[2,768]),{57:[1,385]},o($V12,[2,771]),o($Vw,[2,407],{87:$Vc1}),{61:73,65:$Vf,115:$Vg,121:386,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{142:[1,387]},o($V2,[2,479]),o($Vx,[2,1035]),o($Vx,[2,1036]),o($Vk,[2,263]),o($Vw,[2,464]),o($V2,[2,795]),{61:73,65:$Vf,89:200,115:$Vg,121:152,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp,428:388},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:389,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($V2,[2,57]),o($V2,[2,63]),o([45,83,87,111,343,347],[2,49]),{53:390,56:$VH,57:$VI,398:193,401:194},o([65,115,230,343,347,351,352,361],[2,786]),o($V2,[2,200],{70:391,45:[1,392]}),o($VK1,[2,163]),{128:[1,393]},o($VL1,[2,75]),o($VL1,[2,79]),{42:394,61:73,65:$Vf,115:$Vg,121:178,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{61:73,65:$Vf,82:395,86:396,89:397,115:$Vg,121:152,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{61:73,65:$Vf,115:$Vg,121:398,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{45:$VI1,50:399,51:295,52:$VJ1},o($VN1,[2,215]),{61:73,65:$Vf,89:144,115:$Vg,121:152,149:400,151:401,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp,432:220},o($V2,[2,224]),o($V2,[2,781]),o($V2,[2,232]),o($V2,[2,239]),o($V2,$VV1,{260:323,258:402,267:$VW1}),{61:73,65:$Vf,89:144,115:$Vg,121:152,151:219,230:$Vh,335:403,337:218,350:46,351:$Vi,352:$Vj,361:$Vp,432:220},{42:332,61:73,65:$Vf,81:$Vx1,115:$Vg,121:178,188:404,209:328,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp,440:333,459:327,461:329,463:330,464:331},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:406,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,338:405,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{61:73,65:$Vf,89:367,115:$Vg,121:152,230:$Vh,256:[1,407],350:46,351:$Vi,352:$Vj,361:$Vp},{83:[1,408]},{46:416,170:24,171:25,176:$V9,243:$Va,471:409,473:410,475:411,477:412,479:413,481:414,483:415},o($Vd1,[2,425]),o($Vw,[2,420]),o($V22,[2,295],{190:417,191:418,192:[1,419]}),o($VU1,[2,469]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:421,229:150,230:$Vh,268:420,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o([83,192,203,228,234,265,267,343,347],[2,285],{87:[1,422]}),o($V32,[2,288]),o($V32,[2,1060]),o($V32,[2,1062],{206:423,208:424,216:$V42,217:$V52,218:$V62,219:$V72,220:$V82,221:$V92,222:$Va2,223:$Vb2}),o($V32,[2,1063]),o($Vc2,$Ve1,{350:46,61:73,398:193,401:194,121:243,53:244,255:433,45:$Vg1,56:$VH,57:$VI,65:$Vf,115:$Vg,230:$Vh,351:$Vi,352:$Vj,361:$Vp}),o($Vc2,$Ve1,{350:46,61:73,398:193,401:194,121:243,53:244,255:434,45:$Vg1,56:$VH,57:$VI,65:$Vf,115:$Vg,230:$Vh,351:$Vi,352:$Vj,361:$Vp}),o($Vd2,[2,1074]),o($Vd2,[2,1076]),{98:[1,435],250:[1,438],272:[1,436],273:[1,437]},o($VX1,[2,1059]),o($Ve2,[2,910],{443:242,79:$Vh1,256:$Vm1,355:$Vn1,360:$Vp1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),o($Ve2,[2,911],{443:242,79:$Vh1,256:$Vm1,355:$Vn1,360:$Vp1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),o($Ve2,[2,912],{443:242,79:$Vh1,256:$Vm1,355:$Vn1,360:$Vp1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),o($Ve2,[2,913],{443:242,79:$Vh1,256:$Vm1,355:$Vn1,360:$Vp1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),{81:[1,439]},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:440,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($Vw1,[2,926]),o($VS1,$VT1,{350:46,61:73,311:122,312:130,308:131,276:132,314:133,432:135,277:140,279:141,281:142,452:143,89:144,288:145,289:146,290:147,229:150,454:151,121:152,294:153,456:156,457:157,398:158,401:159,458:160,469:319,181:441,441:442,140:443,56:$VH,57:$VI,65:$Vf,81:$VJ,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,309:$V21,310:$V31,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1}),{33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1,442:[1,444],443:242},o($Vf2,[2,920],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),o($Vf2,[2,921],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),o($V_1,[2,922],{443:242,79:$Vh1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),o($V_1,[2,923],{443:242,79:$Vh1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),o($V_1,[2,924],{443:242,79:$Vh1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),o($VY1,[2,1107]),o($VY1,[2,1108]),o($V_1,[2,1166],{443:242}),o($V_1,[2,1167],{443:242}),o($V_1,[2,1168],{443:242}),{83:[1,445]},{45:$Vg1,53:244,56:$VH,57:$VI,61:73,65:$Vf,83:$Ve1,115:$Vg,121:243,230:$Vh,255:446,350:46,351:$Vi,352:$Vj,361:$Vp,398:193,401:194},o($Vw1,[2,909]),o($Vw1,[2,928]),o($Vw1,[2,1175]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:447,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($V$1,[2,1191]),{33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1,389:[1,448],443:242},o($Vw1,[2,568]),{83:[1,449],87:$Vg2},o($VH1,[2,573],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),o($VA1,[2,1032]),o($VC1,[2,870]),o($Vw1,[2,589]),o($Vw1,[2,590]),o($Vh2,[2,1119],{485:451,489:452,127:[1,453]}),{321:[2,532]},{83:[1,454],87:$Vg2},{33:$Vf1,45:[1,455],79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1,443:242},o($Vw1,[2,542]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,83:[1,456],89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:365,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,295:457,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{83:[1,458]},o($VD1,[2,522]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:365,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,295:459,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:460,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($VD1,[2,528]),o($Vw1,[2,1046]),{392:[1,461]},o($Vw1,[2,1049]),o($V12,[2,767]),o($V12,[2,770]),o($VE1,$VO1),{81:$Vi2,167:462,168:463},o($VH1,[2,845]),o($VH1,[2,850],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),o([45,52,83,87,97,98,111,343,347],[2,50]),o($V2,[2,70]),o($VS1,[2,204],{145:465}),{129:466,131:[1,467]},o($VL1,[2,80]),{83:[1,468],87:[1,469]},o($VH1,[2,86]),{90:470,99:471,100:472,101:473,102:474,103:475,104:476,105:477,109:$Vj2,114:$Vk2,115:$Vl2,363:$Vm2,364:$Vn2,366:$Vo2,369:$Vp2,370:$Vq2,374:$Vr2,378:$Vs2,387:$Vt2,388:$Vu2,390:$Vv2,391:$Vw2,394:$Vx2},o($VM1,[2,838]),{45:[1,493]},{83:[1,494],87:[1,495]},o($VH1,$VI1,{51:295,50:496,52:$VJ1}),o($V2,[2,592]),o($VQ1,[2,607]),o($VP1,[2,620]),o($VQ1,[2,612]),o($VQ1,[2,617],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),o($VR1,[2,867]),o($VG,[2,281]),{83:[2,1088]},{83:[2,1090]},{83:[2,1092]},{83:[2,1094]},{83:[2,1096]},{83:[2,1098]},{83:[2,1100]},{83:[2,1102]},o($Vy2,[2,324],{201:497,202:498,203:[1,499]}),o($V22,[2,296]),{128:[1,500]},o($VU1,[2,470]),o($VU1,[2,473],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),{42:332,61:73,65:$Vf,81:$Vx1,115:$Vg,121:178,188:501,209:328,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp,440:333,459:327,461:329,463:330,464:331},o($V32,[2,1066],{208:502,216:$V42,217:$V52,218:$V62,219:$V72,220:$V82,221:$V92,222:$Va2,223:$Vb2}),{42:332,61:73,65:$Vf,81:$Vx1,115:$Vg,121:178,209:503,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp,440:333,463:330,464:331},{217:[1,504]},{217:[1,505],219:[1,506]},{217:[1,507]},o($Vz2,[2,349]),{217:[1,509],219:[1,510],220:[1,508],222:[1,511]},{217:[1,512]},{217:[1,514],219:[1,515],220:[1,513],222:[1,516]},{217:[1,517]},o($Vc2,[2,1069]),o($Vc2,[2,1070]),o($Vw1,[2,904]),o($Vw1,[2,905]),o($Vw1,[2,906]),{184:[1,518]},o($VS1,$VT1,{350:46,61:73,311:122,312:130,308:131,276:132,314:133,432:135,277:140,279:141,281:142,452:143,89:144,288:145,289:146,290:147,229:150,454:151,121:152,294:153,456:156,457:157,398:158,401:159,458:160,469:319,140:443,181:519,441:520,56:$VH,57:$VI,65:$Vf,81:$VJ,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,309:$V21,310:$V31,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1}),{33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1,442:[1,521],443:242},{83:[1,522]},{83:[1,523],87:$VA2},o($VB2,[2,1016],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:525,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($VC2,[2,1084]),{83:[1,526]},{33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,372:[1,527],377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1,443:242},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:528,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($Vw1,[2,569]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:529,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{83:[2,1125],233:531,234:$VD2,486:530},o($Vh2,[2,1120]),{128:[1,533]},{321:[2,533]},{99:534,363:$Vm2,364:$Vn2,366:$Vo2,369:$Vp2,370:$Vq2,374:$Vr2,378:$Vs2,387:$Vt2,388:$Vu2,390:$Vv2,391:$Vw2,394:$Vx2},o($VD1,[2,508]),{83:[1,535],87:$Vg2},o($VD1,[2,521]),{83:[1,536],87:$Vg2},{33:$Vf1,79:$Vh1,83:[1,537],97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1,443:242},o($Vw1,[2,1050]),o($V2,[2,251],{87:[1,538]}),o($VE2,[2,257]),{56:$VH,57:$VI,61:73,65:$Vf,89:144,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,169:539,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:540,312:130,314:133,350:46,351:$Vi,352:$Vj,361:$Vp,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{46:541,170:24,171:25,176:$V9,243:$Va},o($VK1,[2,164]),{81:[1,543],132:542},o($VL1,[2,84]),{61:73,65:$Vf,86:544,89:397,115:$Vg,121:152,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},o($VH1,[2,100],{91:545,94:546,95:547,51:550,52:$VJ1,97:$VF2,98:$VG2}),o($VH2,[2,112]),o($VH2,[2,113]),o($VH2,[2,114]),o($VH2,[2,115]),o($VH2,[2,116]),o($VH2,[2,117]),o($VH2,[2,118]),o($VH2,[2,882]),o($VH2,[2,883]),o($VH2,$VI2,{437:551,81:$VJ2}),o($VH2,[2,896],{438:553,81:[1,554]}),o($VH2,[2,886]),o($VH2,[2,887]),o($VH2,[2,888]),o($VH2,[2,889]),o($VH2,[2,890]),o($VH2,[2,891]),o($VH2,[2,892]),o($VH2,$VI2,{437:555,81:$VJ2}),{110:[1,556]},{110:[1,557]},{110:[1,558]},{46:559,170:24,171:25,176:$V9,243:$Va},o($VN1,[2,216]),{61:73,65:$Vf,89:144,115:$Vg,121:152,151:560,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp,432:220},o($VH1,[2,218]),o($VK2,[2,387],{232:561,233:562,234:$VD2}),o($Vy2,[2,325]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:563,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:565,193:564,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($V32,[2,289]),{42:332,61:73,65:$Vf,81:$Vx1,115:$Vg,121:178,209:566,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp,440:333,463:330,464:331},o($VL2,$VM2,{210:567,224:$VN2}),o($Vz2,[2,345]),o($Vz2,[2,346]),{217:[1,569]},o($Vz2,[2,348]),{217:[1,570]},o($Vz2,[2,351]),{217:[1,571]},{217:[1,572]},o($Vz2,[2,354]),{217:[1,573]},o($Vz2,[2,356]),{217:[1,574]},{217:[1,575]},o($Vz2,[2,359]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:576,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{83:[1,577]},{83:[1,578],87:$VA2},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:579,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($Vw1,[2,916]),o($Vw1,[2,917]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:580,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o([45,56,57,65,83,87,115,131,184,192,203,216,217,218,219,220,221,222,223,228,230,234,241,242,265,267,343,347,351,352,359,361,362,371,372,380,385,389,395,442],[2,919],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,360:$Vp1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),o($VC2,[2,1085]),o($Vw1,[2,1176]),o($V$1,[2,1197],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),o($VH1,[2,574],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),{83:[1,581]},{83:[2,1130],131:[1,586],385:[1,585],490:582,492:583,493:584},{128:[1,587]},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:443,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,441:588,452:143,454:151,456:156,457:157,458:160},{83:[1,589]},o($VD1,[2,509]),o($VD1,[2,523]),o($VD1,[2,527]),{81:$Vi2,168:590},{83:[1,591],87:[1,592]},o($VH1,[2,1029]),o($V2,[2,201]),{81:[1,594],133:593},{61:73,65:$Vf,89:596,115:$Vg,121:152,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp,424:595},o($VH1,[2,87]),o($VH1,[2,96]),o($VH1,[2,101],{51:550,95:597,52:$VJ1,97:$VF2,98:$VG2}),o($VO2,[2,102]),{98:[1,598]},o($VO2,[2,109]),o($VO2,[2,110]),o($VH2,[2,884]),{392:[1,599]},o($VH2,[2,885]),{392:[1,600]},o($VH2,[2,893]),{90:601,99:471,100:472,101:473,102:474,103:475,104:476,105:477,109:$Vj2,111:[1,602],114:$Vk2,115:$Vl2,363:$Vm2,364:$Vn2,366:$Vo2,369:$Vp2,370:$Vq2,374:$Vr2,378:$Vs2,387:$Vt2,388:$Vu2,390:$Vv2,391:$Vw2,394:$Vx2},{99:603,111:[1,604],363:$Vm2,364:$Vn2,366:$Vo2,369:$Vp2,370:$Vq2,374:$Vr2,378:$Vs2,387:$Vt2,388:$Vu2,390:$Vv2,391:$Vw2,394:$Vx2},{61:73,65:$Vf,111:[1,606],115:$Vg,116:605,118:607,121:608,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},o($V2,[2,205]),o($VH1,$VI1,{51:295,50:609,52:$VJ1}),o($Vw,[2,380],{226:610,227:611,228:[1,612]}),o($VK2,[2,388]),o($Vy2,[2,326],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),o($V22,[2,297],{87:[1,613]}),o($VP2,[2,312],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),o($VL2,$VM2,{210:614,224:$VN2}),o($VL2,[2,332]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:615,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($Vz2,[2,347]),o($Vz2,[2,350]),o($Vz2,[2,352]),o($Vz2,[2,353]),o($Vz2,[2,355]),o($Vz2,[2,357]),o($Vz2,[2,358]),o($V_1,[2,907],{443:242}),o($Vw1,[2,914]),o($Vw1,[2,915]),o($VZ1,[2,918],{443:242,33:$Vf1,79:$Vh1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,360:$Vp1,377:$Vr1,379:$Vs1,382:$Vu1,383:$Vv1}),o($VB2,[2,1017],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),o($Vw1,[2,1114]),{83:[2,1126]},{83:[2,1131]},{362:[1,616],497:[1,617]},o($VQ2,[2,1148]),o($VQ2,[2,1149]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:620,229:150,230:$Vh,235:618,238:619,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($Vh2,[2,1121],{87:$VA2}),o($Vw1,[2,541]),o($VE2,[2,258]),o($VE2,[2,259]),{56:$VH,57:$VI,61:73,65:$Vf,89:144,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:621,312:130,314:133,350:46,351:$Vi,352:$Vj,361:$Vp,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($VK1,[2,168]),{127:$VR2,136:622,138:623},{83:[1,625],87:[1,626]},o($VH1,[2,825]),o($VO2,[2,103]),o($VO2,[2,108]),{83:[1,627]},{83:[1,628],87:[1,629]},{111:[1,630]},o($VH2,[2,123]),{87:[1,631]},o($VH2,[2,127]),{87:[1,633],111:[1,632]},o($VH2,[2,133]),o($VS2,[2,135]),{122:[1,634]},o($VH1,[2,219]),o($Vw,[2,444]),o($Vw,[2,381]),{229:635,230:[1,636],270:$VP,392:$V91,393:$Va1,456:156,457:157},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:637,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($VL2,[2,333]),o($VL2,[2,375],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),o($VT2,$VU2,{494:638}),o($VT2,$VU2,{494:639}),o([83,131,228,265,343,347,385],[2,389],{87:[1,640]}),o($VV2,[2,392]),o($VV2,[2,402],{443:242,240:641,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,241:[1,642],242:[1,643],256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),o($VH1,[2,1030]),{83:[1,644],87:[1,645]},o($VH1,[2,177]),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:646,142:[1,647],229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{81:[2,822]},{61:73,65:$Vf,89:648,115:$Vg,121:152,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},o($VH2,[2,895]),o($VH2,[2,897]),{392:[1,649]},o($VH2,[2,122]),{90:650,99:471,100:472,101:473,102:474,103:475,104:476,105:477,109:$Vj2,114:$Vk2,115:$Vl2,363:$Vm2,364:$Vn2,366:$Vo2,369:$Vp2,370:$Vq2,374:$Vr2,378:$Vs2,387:$Vt2,388:$Vu2,390:$Vv2,391:$Vw2,394:$Vx2},o($VH2,[2,132]),{61:73,65:$Vf,115:$Vg,118:651,121:608,230:$Vh,350:46,351:$Vi,352:$Vj,361:$Vp},{90:652,99:471,100:472,101:473,102:474,103:475,104:476,105:477,109:$Vj2,114:$Vk2,115:$Vl2,363:$Vm2,364:$Vn2,366:$Vo2,369:$Vp2,370:$Vq2,374:$Vr2,378:$Vs2,387:$Vt2,388:$Vu2,390:$Vv2,391:$Vw2,394:$Vx2},o($Vw,[2,382],{87:[1,653]}),o($Vw,[2,384],{87:[1,654]}),o($VP2,[2,313],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),o($VW2,$VX2,{495:655,505:656,367:$VY2,392:$VZ2,497:$V_2}),o($VW2,$VX2,{505:656,495:660,367:$VY2,392:$VZ2,497:$V_2}),{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:620,229:150,230:$Vh,238:661,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($VV2,[2,399]),o($VV2,[2,403]),o($VV2,[2,404]),o($VK1,[2,174]),{127:$VR2,138:662},{33:$Vf1,79:$Vh1,97:$Vi1,110:[1,664],111:$Vk1,141:663,144:[1,665],256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1,443:242},{110:$V$2,141:666,144:$V03},o($VH1,[2,826]),{83:[1,669]},{111:[1,670]},o($VS2,[2,136]),o($VS2,$VI1,{51:295,50:671,52:$VJ1}),{229:672,270:$VP,392:$V91,393:$Va1,456:156,457:157},{230:[1,673]},{83:$V13,359:$V23,496:674},{381:[1,676]},{384:[1,677]},o($V33,[2,1161]),o($V33,[2,1162]),{83:$V13,359:$V23,496:678},o($VV2,[2,393]),o($VH1,[2,178]),{142:[1,679]},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:337,142:$V43,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:339,142:$V53,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:680,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},o($V02,$V43),o($V02,$V53),o($VH2,[2,898]),o($VH2,[2,126]),o($VS2,[2,142]),o($Vw,[2,383]),o($Vw,[2,385]),{83:[2,1132]},{367:[1,681],392:$VZ2,497:$V_2,505:682},o($VW2,[2,1151]),o($VW2,[2,1152]),{83:[2,1133]},o($VH1,[2,186],{141:683,110:$V$2,144:$V03}),o($VH1,[2,185],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1}),{384:[1,684]},{375:[1,685]},{56:$VH,57:$VI,61:73,65:$Vf,81:$VJ,89:144,97:$VK,98:$VL,109:$VM,114:$VN,115:$Vg,121:152,140:686,229:150,230:$Vh,270:$VP,272:$VQ,273:$VR,274:$VS,276:132,277:140,279:141,281:142,288:145,289:146,290:147,294:153,297:$VT,298:$VU,299:$VV,300:$VW,301:$VX,302:$VY,303:$VZ,304:$V_,305:$V$,306:$V01,307:$V11,308:131,309:$V21,310:$V31,311:122,312:130,314:133,350:46,351:$Vi,352:$Vj,354:$V41,355:$V51,358:$V61,361:$Vp,365:$V71,373:$V81,392:$V91,393:$Va1,398:158,401:159,432:135,452:143,454:151,456:156,457:157,458:160},{83:[2,1156]},{83:[2,1157]},o($VH1,[2,184],{443:242,33:$Vf1,79:$Vh1,97:$Vi1,110:$Vj1,111:$Vk1,144:$Vl1,256:$Vm1,355:$Vn1,359:$Vo1,360:$Vp1,362:$Vq1,377:$Vr1,379:$Vs1,380:$Vt1,382:$Vu1,383:$Vv1})],
defaultActions: {39:[2,625],76:[2,602],77:[2,604],114:[2,863],136:[2,537],137:[2,538],138:[2,539],139:[2,540],161:[2,513],162:[2,514],163:[2,515],164:[2,516],165:[2,517],166:[2,518],167:[2,519],168:[2,520],177:[2,36],179:[2,45],219:[2,616],371:[2,532],409:[2,1088],410:[2,1090],411:[2,1092],412:[2,1094],413:[2,1096],414:[2,1098],415:[2,1100],416:[2,1102],454:[2,533],582:[2,1126],583:[2,1131],625:[2,822],674:[2,1132],678:[2,1133],684:[2,1156],685:[2,1157]},
parseError: function parseError (str, hash) {
    if (hash.recoverable) {
        this.trace(str);
    } else {
        var error = new Error(str);
        error.hash = hash;
        throw error;
    }
},
parse: function parse (input) {
    var self = this,
        stack = [0],
        tstack = [], // token stack
        vstack = [null], // semantic value stack
        lstack = [], // location stack
        table = this.table,
        yytext = '',
        yylineno = 0,
        yyleng = 0,
        recovering = 0,
        TERROR = 2,
        EOF = 1;

    var args = lstack.slice.call(arguments, 1);

    //this.reductionCount = this.shiftCount = 0;

    var lexer = Object.create(this.lexer);
    var sharedState = { yy: {} };
    // copy state
    for (var k in this.yy) {
      if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
        sharedState.yy[k] = this.yy[k];
      }
    }

    lexer.setInput(input, sharedState.yy);
    sharedState.yy.lexer = lexer;
    sharedState.yy.parser = this;
    if (typeof lexer.yylloc == 'undefined') {
        lexer.yylloc = {};
    }
    var yyloc = lexer.yylloc;
    lstack.push(yyloc);

    var ranges = lexer.options && lexer.options.ranges;

    if (typeof sharedState.yy.parseError === 'function') {
        this.parseError = sharedState.yy.parseError;
    } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
    }

    function popStack (n) {
        stack.length = stack.length - 2 * n;
        vstack.length = vstack.length - n;
        lstack.length = lstack.length - n;
    }

_token_stack:
    var lex = function () {
        var token;
        token = lexer.lex() || EOF;
        // if token isn't its numeric value, convert
        if (typeof token !== 'number') {
            token = self.symbols_[token] || token;
        }
        return token;
    }

    var symbol, preErrorSymbol, state, action, a, r, yyval = {}, p, len, newState, expected;
    while (true) {
        // retreive state number from top of stack
        state = stack[stack.length - 1];

        // use default actions if available
        if (this.defaultActions[state]) {
            action = this.defaultActions[state];
        } else {
            if (symbol === null || typeof symbol == 'undefined') {
                symbol = lex();
            }
            // read action for current state and first input
            action = table[state] && table[state][symbol];
        }

_handle_error:
        // handle parse error
        if (typeof action === 'undefined' || !action.length || !action[0]) {
            var error_rule_depth;
            var errStr = '';

            // Return the rule stack depth where the nearest error rule can be found.
            // Return FALSE when no error recovery rule was found.
            function locateNearestErrorRecoveryRule(state) {
                var stack_probe = stack.length - 1;
                var depth = 0;

                // try to recover from error
                for(;;) {
                    // check for error recovery rule in this state
                    if ((TERROR.toString()) in table[state]) {
                        return depth;
                    }
                    if (state === 0 || stack_probe < 2) {
                        return false; // No suitable error recovery rule available.
                    }
                    stack_probe -= 2; // popStack(1): [symbol, action]
                    state = stack[stack_probe];
                    ++depth;
                }
            }

            if (!recovering) {
                // first see if there's any chance at hitting an error recovery rule:
                error_rule_depth = locateNearestErrorRecoveryRule(state);

                // Report error
                expected = [];
                for (p in table[state]) {
                    if (this.terminals_[p] && p > TERROR) {
                        expected.push("'"+this.terminals_[p]+"'");
                    }
                }
                if (lexer.showPosition) {
                    errStr = 'Parse error on line '+(yylineno+1)+":\n"+lexer.showPosition()+"\nExpecting "+expected.join(', ') + ", got '" + (this.terminals_[symbol] || symbol)+ "'";
                } else {
                    errStr = 'Parse error on line '+(yylineno+1)+": Unexpected " +
                                  (symbol == EOF ? "end of input" :
                                              ("'"+(this.terminals_[symbol] || symbol)+"'"));
                }
                this.parseError(errStr, {
                    text: lexer.match,
                    token: this.terminals_[symbol] || symbol,
                    line: lexer.yylineno,
                    loc: lexer.yylloc,
                    ruleId: stack.slice(stack.length - 2, stack.length).join('_'),
                    expected: expected,
                    recoverable: (error_rule_depth !== false)
                });
            } else if (preErrorSymbol !== EOF) {
                error_rule_depth = locateNearestErrorRecoveryRule(state);
            }

            // just recovered from another error
            if (recovering == 3) {
                if (symbol === EOF || preErrorSymbol === EOF) {
                    throw new Error(errStr || 'Parsing halted while starting to recover from another error.');
                }

                // discard current lookahead and grab another
                yyleng = lexer.yyleng;
                yytext = lexer.yytext;
                yylineno = lexer.yylineno;
                yyloc = lexer.yylloc;
                symbol = lex();
            }

            // try to recover from error
            if (error_rule_depth === false) {
                throw new Error(errStr || 'Parsing halted. No suitable error recovery rule available.');
            }
            popStack(error_rule_depth);

            preErrorSymbol = (symbol == TERROR ? null : symbol); // save the lookahead token
            symbol = TERROR;         // insert generic error symbol as new lookahead
            state = stack[stack.length-1];
            action = table[state] && table[state][TERROR];
            recovering = 3; // allow 3 real symbols to be shifted before reporting a new error
        }

        // this shouldn't happen, unless resolve defaults are off
        if (action[0] instanceof Array && action.length > 1) {
            throw new Error('Parse Error: multiple actions possible at state: '+state+', token: '+symbol);
        }

        switch (action[0]) {
            case 1: // shift
                //this.shiftCount++;

                stack.push(symbol);
                vstack.push(lexer.yytext);
                lstack.push(lexer.yylloc);
                stack.push(action[1]); // push state
                symbol = null;
                if (!preErrorSymbol) { // normal execution/no error
                    yyleng = lexer.yyleng;
                    yytext = lexer.yytext;
                    yylineno = lexer.yylineno;
                    yyloc = lexer.yylloc;
                    if (recovering > 0) {
                        recovering--;
                    }
                } else {
                    // error just occurred, resume old lookahead f/ before error
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                }
                break;

            case 2:
                // reduce
                //this.reductionCount++;

                len = this.productions_[action[1]][1];

                // perform semantic action
                yyval.$ = vstack[vstack.length-len]; // default to $$ = $1
                // default location, uses first token for firsts, last for lasts
                yyval._$ = {
                    first_line: lstack[lstack.length-(len||1)].first_line,
                    last_line: lstack[lstack.length-1].last_line,
                    first_column: lstack[lstack.length-(len||1)].first_column,
                    last_column: lstack[lstack.length-1].last_column
                };
                if (ranges) {
                  yyval._$.range = [lstack[lstack.length-(len||1)].range[0], lstack[lstack.length-1].range[1]];
                }
                r = this.performAction.apply(yyval, [yytext, yyleng, yylineno, sharedState.yy, action[1], vstack, lstack].concat(args));

                if (typeof r !== 'undefined') {
                    return r;
                }

                // pop off stack
                if (len) {
                    stack = stack.slice(0,-1*len*2);
                    vstack = vstack.slice(0, -1*len);
                    lstack = lstack.slice(0, -1*len);
                }

                stack.push(this.productions_[action[1]][0]);    // push nonterminal (reduce)
                vstack.push(yyval.$);
                lstack.push(yyval._$);
                // goto new state = table[STATE][NONTERMINAL]
                newState = table[stack[stack.length-2]][stack[stack.length-1]];
                stack.push(newState);
                break;

            case 3:
                // accept
                return true;
        }

    }

    return true;
}};


SqlParseSupport.initSyntaxParser(parser);/* generated by jison-lex 0.3.4 */
var lexer = (function(){
var lexer = ({

EOF:1,

parseError:function parseError(str, hash) {
        if (this.yy.parser) {
            this.yy.parser.parseError(str, hash);
        } else {
            throw new Error(str);
        }
    },

// resets the lexer, sets new input
setInput:function (input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = '';
        this.conditionStack = ['INITIAL'];
        this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
        };
        if (this.options.ranges) {
            this.yylloc.range = [0,0];
        }
        this.offset = 0;
        return this;
    },

// consumes and returns one char from the input
input:function () {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
        } else {
            this.yylloc.last_column++;
        }
        if (this.options.ranges) {
            this.yylloc.range[1]++;
        }

        this._input = this._input.slice(1);
        return ch;
    },

// unshifts one char (or a string) into the input
unput:function (ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);

        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        //this.yyleng -= len;
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);

        if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;

        this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ?
                (lines.length === oldLines.length ? this.yylloc.first_column : 0)
                 + oldLines[oldLines.length - lines.length].length - lines[0].length :
              this.yylloc.first_column - len
        };

        if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
    },

// When called from action, caches matched text and appends it on next action
more:function () {
        this._more = true;
        return this;
    },

// When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
reject:function () {
        if (this.options.backtrack_lexer) {
            this._backtrack = true;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });

        }
        return this;
    },

// retain first n characters of the match
less:function (n) {
        this.unput(this.match.slice(n));
    },

// displays already matched input, i.e. for error messages
pastInput:function () {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
    },

// displays upcoming input, i.e. for error messages
upcomingInput:function () {
        var next = this.match;
        if (next.length < 20) {
            next += this._input.substr(0, 20-next.length);
        }
        return (next.substr(0,20) + (next.length > 20 ? '...' : '')).replace(/\n/g, "");
    },

// displays the character position where the lexing error occurred, i.e. for error messages
showPosition:function () {
        var pre = this.pastInput();
        var c = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c + "^";
    },

// test the lexed token: return FALSE when not a match, otherwise return token
test_match:function(match, indexed_rule) {
        var token,
            lines,
            backup;

        if (this.options.backtrack_lexer) {
            // save context
            backup = {
                yylineno: this.yylineno,
                yylloc: {
                    first_line: this.yylloc.first_line,
                    last_line: this.last_line,
                    first_column: this.yylloc.first_column,
                    last_column: this.yylloc.last_column
                },
                yytext: this.yytext,
                match: this.match,
                matches: this.matches,
                matched: this.matched,
                yyleng: this.yyleng,
                offset: this.offset,
                _more: this._more,
                _input: this._input,
                yy: this.yy,
                conditionStack: this.conditionStack.slice(0),
                done: this.done
            };
            if (this.options.ranges) {
                backup.yylloc.range = this.yylloc.range.slice(0);
            }
        }

        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno += lines.length;
        }
        this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ?
                         lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length :
                         this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
            this.done = false;
        }
        if (token) {
            return token;
        } else if (this._backtrack) {
            // recover context
            for (var k in backup) {
                this[k] = backup[k];
            }
            return false; // rule action called reject() implying the next rule should be tested instead.
        }
        return false;
    },

// return next match in input
next:function () {
        if (this.done) {
            return this.EOF;
        }
        if (!this._input) {
            this.done = true;
        }

        var token,
            match,
            tempMatch,
            index;
        if (!this._more) {
            this.yytext = '';
            this.match = '';
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
            tempMatch = this._input.match(this.rules[rules[i]]);
            if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
                match = tempMatch;
                index = i;
                if (this.options.backtrack_lexer) {
                    token = this.test_match(tempMatch, rules[i]);
                    if (token !== false) {
                        return token;
                    } else if (this._backtrack) {
                        match = false;
                        continue; // rule action called reject() implying a rule MISmatch.
                    } else {
                        // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
                        return false;
                    }
                } else if (!this.options.flex) {
                    break;
                }
            }
        }
        if (match) {
            token = this.test_match(match, rules[index]);
            if (token !== false) {
                return token;
            }
            // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
            return false;
        }
        if (this._input === "") {
            return this.EOF;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. Unrecognized text.\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });
        }
    },

// return next match that has a token
lex:function lex () {
        var r = this.next();
        if (r) {
            return r;
        } else {
            return this.lex();
        }
    },

// activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
begin:function begin (condition) {
        this.conditionStack.push(condition);
    },

// pop the previously active lexer condition state off the condition stack
popState:function popState () {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
            return this.conditionStack.pop();
        } else {
            return this.conditionStack[0];
        }
    },

// produce the lexer rule set which is active for the currently active lexer condition state
_currentRules:function _currentRules () {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
            return this.conditions["INITIAL"].rules;
        }
    },

// return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
topState:function topState (n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
            return this.conditionStack[n];
        } else {
            return "INITIAL";
        }
    },

// alias for begin(condition)
pushState:function pushState (condition) {
        this.begin(condition);
    },

// return the number of states currently on the stack
stateStackSize:function stateStackSize() {
        return this.conditionStack.length;
    },
options: {"case-insensitive":true,"flex":true},
performAction: function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {
var YYSTATE=YY_START;
switch($avoiding_name_collisions) {
case 0: /* skip whitespace */ 
break;
case 1: /* skip comments */ 
break;
case 2: /* skip comments */ 
break;
case 3: parser.yy.partialCursor = false; parser.yy.cursorFound = yy_.yylloc; return 5; 
break;
case 4: parser.yy.partialCursor = true; parser.yy.cursorFound = yy_.yylloc; return 396; 
break;
case 5: this.popState(); return 442; 
break;
case 6: return 31; 
break;
case 7: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('ALTER', yy_.yylloc, yy.lexer.upcomingInput()); return 4; 
break;
case 8: return 359; 
break;
case 9: return 45; 
break;
case 10: return 241; 
break;
case 11: this.begin('between'); return 362; 
break;
case 12: return 363; 
break;
case 13: return 364; 
break;
case 14: return 128; 
break;
case 15: return 408; 
break;
case 16: return 365; 
break;
case 17: return 366; 
break;
case 18: return 52; 
break;
case 19: parser.determineCase(yy_.yytext); return 8; 
break;
case 20: return 216; 
break;
case 21: return 367; 
break;
case 22: return 368; 
break;
case 23: return 369; 
break;
case 24: return 242; 
break;
case 25: return 250; 
break;
case 26: return 360; 
break;
case 27: return 370; 
break;
case 28: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('DROP', yy_.yylloc, yy.lexer.upcomingInput()); return 12; 
break;
case 29: return 371; 
break;
case 30: return 372; 
break;
case 31: parser.yy.correlatedSubQuery = true; return 373; 
break;
case 32: return 273; 
break;
case 33: return 374; 
break;
case 34: return 375; 
break;
case 35: parser.determineCase(yy_.yytext); return 184; 
break;
case 36: return 218; 
break;
case 37: return 192; 
break;
case 38: return 203; 
break;
case 39: return 309; 
break;
case 40: return 377; 
break;
case 41: return 220; 
break;
case 42: return 164; 
break;
case 43: return 378; 
break;
case 44: return 165; 
break;
case 45: return 379; 
break;
case 46: return 217; 
break;
case 47: return 221; 
break;
case 48: return 79; 
break;
case 49: return 228; 
break;
case 50: return 97; 
break;
case 51: return 98; 
break;
case 52: return 224; 
break;
case 53: return 351; 
break;
case 54: return 380; 
break;
case 55: return 234; 
break;
case 56: return 219; 
break;
case 57: return 127; 
break;
case 58: return 381; 
break;
case 59: return 156; 
break;
case 60: return 131; 
break;
case 61: return 382; 
break;
case 62: return 223; 
break;
case 63: return 383; 
break;
case 64: return 384; 
break;
case 65: return 65; 
break;
case 66: return 385; 
break;
case 67: return 386; 
break;
case 68: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SELECT', yy_.yylloc); return 243; 
break;
case 69: return 222; 
break;
case 70: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SET', yy_.yylloc); return 16; 
break;
case 71: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SHOW', yy_.yylloc); return 'SHOW'; 
break;
case 72: return 387; 
break;
case 73: return 388; 
break;
case 74: return 41; 
break;
case 75: return 389; 
break;
case 76: return 390; 
break;
case 77: return 391; 
break;
case 78: return 'TO'; 
break;
case 79: return 272; 
break;
case 80: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('TRUNCATE', yy_.yylloc, yy.lexer.upcomingInput()); return 274; 
break;
case 81: return 497; 
break;
case 82: return 265; 
break;
case 83: parser.determineCase(yy_.yytext); return 324; 
break;
case 84: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('USE', yy_.yylloc); return 340; 
break;
case 85: return 142; 
break;
case 86: return 394; 
break;
case 87: return 49; 
break;
case 88: return 395; 
break;
case 89: return 267; 
break;
case 90: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('WITH', yy_.yylloc); return 176; 
break;
case 91: return 321; 
break;
case 92: return 65; 
break;
case 93: yy.lexer.unput('('); yy_.yytext = 'avg'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 297; 
break;
case 94: yy.lexer.unput('('); yy_.yytext = 'cast'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 310; 
break;
case 95: yy.lexer.unput('('); yy_.yytext = 'count'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 305; 
break;
case 96: yy.lexer.unput('('); yy_.yytext = 'max'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 298; 
break;
case 97: yy.lexer.unput('('); yy_.yytext = 'min'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 299; 
break;
case 98: yy.lexer.unput('('); yy_.yytext = 'stddev_pop'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 300; 
break;
case 99: yy.lexer.unput('('); yy_.yytext = 'stddev_samp'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 301; 
break;
case 100: yy.lexer.unput('('); yy_.yytext = 'sum'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 306; 
break;
case 101: yy.lexer.unput('('); yy_.yytext = 'var_pop'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 302; 
break;
case 102: yy.lexer.unput('('); yy_.yytext = 'var_samp'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 303; 
break;
case 103: yy.lexer.unput('('); yy_.yytext = 'variance'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 304; 
break;
case 104: yy.lexer.unput('('); yy_.yytext = 'cume_dist'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 307; 
break;
case 105: yy.lexer.unput('('); yy_.yytext = 'dense_rank'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 307; 
break;
case 106: yy.lexer.unput('('); yy_.yytext = 'first_value'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 307; 
break;
case 107: yy.lexer.unput('('); yy_.yytext = 'lag'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 307; 
break;
case 108: yy.lexer.unput('('); yy_.yytext = 'last_value'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 307; 
break;
case 109: yy.lexer.unput('('); yy_.yytext = 'lead'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 307; 
break;
case 110: yy.lexer.unput('('); yy_.yytext = 'rank'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 307; 
break;
case 111: yy.lexer.unput('('); yy_.yytext = 'row_number'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 307; 
break;
case 112: return 392; 
break;
case 113: return 392; 
break;
case 114: return 393; 
break;
case 115: return 352; 
break;
case 116: parser.yy.cursorFound = true; return 5; 
break;
case 117: parser.yy.cursorFound = true; return 396; 
break;
case 118: return 376; 
break;
case 119: parser.addFileLocation(yy_.yylloc, yy_.yytext); return 502; 
break;
case 120: this.popState(); return 503; 
break;
case 121: return 343; 
break;
case 122: return 359; 
break;
case 123: return 380; 
break;
case 124: return 33; 
break;
case 125: return 110; 
break;
case 126: return 111; 
break;
case 127: return 144; 
break;
case 128: return 144; 
break;
case 129: return 144; 
break;
case 130: return 144; 
break;
case 131: return 144; 
break;
case 132: return 355; 
break;
case 133: return 256; 
break;
case 134: return 360; 
break;
case 135: return 360; 
break;
case 136: return 360; 
break;
case 137: return 360; 
break;
case 138: return 360; 
break;
case 139: return 360; 
break;
case 140: return 87; 
break;
case 141: return 270; 
break;
case 142: return 122; 
break;
case 143: return 347; 
break;
case 144: return 358; 
break;
case 145: return 354; 
break;
case 146: return 81; 
break;
case 147: return 83; 
break;
case 148: return 356; 
break;
case 149: return 357; 
break;
case 150: return 230; 
break;
case 151: this.begin('backtickedValue'); return 361; 
break;
case 152:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '`')) {
                                               return 400;
                                             }
                                             return 58;
                                           
break;
case 153: this.popState(); return 361; 
break;
case 154: this.begin('singleQuotedValue'); return 56; 
break;
case 155:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '\'')) {
                                               return 400;
                                             }
                                             return 58;
                                           
break;
case 156: this.popState(); return 56; 
break;
case 157: this.begin('doubleQuotedValue'); return 57; 
break;
case 158:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '"')) {
                                               return 400;
                                             }
                                             return 58;
                                           
break;
case 159: this.popState(); return 57; 
break;
case 160: return 343; 
break;
case 161: /* To prevent console logging of unknown chars */ 
break;
case 162: 
break;
case 163: 
break;
case 164: 
break;
case 165: 
break;
case 166: 
break;
case 167:console.log(yy_.yytext);
break;
}
},
rules: [/^(?:\s)/i,/^(?:--.*)/i,/^(?:[/][*][^*]*[*]+([^/*][^*]*[*]+)*[/])/i,/^(?:\u2020)/i,/^(?:\u2021)/i,/^(?:AND)/i,/^(?:ALL)/i,/^(?:ALTER)/i,/^(?:AND)/i,/^(?:AS)/i,/^(?:ASC)/i,/^(?:BETWEEN)/i,/^(?:BIGINT)/i,/^(?:BOOLEAN)/i,/^(?:BY)/i,/^(?:CASCADE)/i,/^(?:CASE)/i,/^(?:CHAR)/i,/^(?:COMMENT)/i,/^(?:CREATE)/i,/^(?:CROSS)/i,/^(?:CURRENT)/i,/^(?:DATABASE)/i,/^(?:DECIMAL)/i,/^(?:DESC)/i,/^(?:DISTINCT)/i,/^(?:DIV)/i,/^(?:DOUBLE)/i,/^(?:DROP)/i,/^(?:ELSE)/i,/^(?:END)/i,/^(?:EXISTS)/i,/^(?:FALSE)/i,/^(?:FLOAT)/i,/^(?:FOLLOWING)/i,/^(?:FROM)/i,/^(?:FULL)/i,/^(?:GROUP)/i,/^(?:HAVING)/i,/^(?:IF)/i,/^(?:IN)/i,/^(?:INNER)/i,/^(?:INSERT)/i,/^(?:INT)/i,/^(?:INTO)/i,/^(?:IS)/i,/^(?:JOIN)/i,/^(?:LEFT)/i,/^(?:LIKE)/i,/^(?:LIMIT)/i,/^(?:NOT)/i,/^(?:NULL)/i,/^(?:ON)/i,/^(?:OPTION)/i,/^(?:OR)/i,/^(?:ORDER)/i,/^(?:OUTER)/i,/^(?:PARTITION)/i,/^(?:PRECEDING)/i,/^(?:PURGE)/i,/^(?:RANGE)/i,/^(?:REGEXP)/i,/^(?:RIGHT)/i,/^(?:RLIKE)/i,/^(?:ROW)/i,/^(?:ROLE)/i,/^(?:ROWS)/i,/^(?:SCHEMA)/i,/^(?:SELECT)/i,/^(?:SEMI)/i,/^(?:SET)/i,/^(?:SHOW)/i,/^(?:SMALLINT)/i,/^(?:STRING)/i,/^(?:TABLE)/i,/^(?:THEN)/i,/^(?:TIMESTAMP)/i,/^(?:TINYINT)/i,/^(?:TO)/i,/^(?:TRUE)/i,/^(?:TRUNCATE)/i,/^(?:UNBOUNDED)/i,/^(?:UNION)/i,/^(?:UPDATE)/i,/^(?:USE)/i,/^(?:VALUES)/i,/^(?:VARCHAR)/i,/^(?:VIEW)/i,/^(?:WHEN)/i,/^(?:WHERE)/i,/^(?:WITH)/i,/^(?:OVER)/i,/^(?:ROLE)/i,/^(?:AVG\s*\()/i,/^(?:CAST\s*\()/i,/^(?:COUNT\s*\()/i,/^(?:MAX\s*\()/i,/^(?:MIN\s*\()/i,/^(?:STDDEV_POP\s*\()/i,/^(?:STDDEV_SAMP\s*\()/i,/^(?:SUM\s*\()/i,/^(?:VAR_POP\s*\()/i,/^(?:VAR_SAMP\s*\()/i,/^(?:VARIANCE\s*\()/i,/^(?:CUME_DIST\s*\()/i,/^(?:DENSE_RANK\s*\()/i,/^(?:FIRST_VALUE\s*\()/i,/^(?:LAG\s*\()/i,/^(?:LAST_VALUE\s*\()/i,/^(?:LEAD\s*\()/i,/^(?:RANK\s*\()/i,/^(?:ROW_NUMBER\s*\()/i,/^(?:[0-9]+)/i,/^(?:[0-9]+(?:[YSL]|BD)?)/i,/^(?:[0-9]+E)/i,/^(?:[A-Za-z0-9_]+)/i,/^(?:\u2020)/i,/^(?:\u2021)/i,/^(?:\s+['"])/i,/^(?:[^'"\u2020\u2021]+)/i,/^(?:['"])/i,/^(?:$)/i,/^(?:&&)/i,/^(?:\|\|)/i,/^(?:=)/i,/^(?:<)/i,/^(?:>)/i,/^(?:!=)/i,/^(?:<=)/i,/^(?:>=)/i,/^(?:<>)/i,/^(?:<=>)/i,/^(?:-)/i,/^(?:\*)/i,/^(?:\+)/i,/^(?:\/)/i,/^(?:%)/i,/^(?:\|)/i,/^(?:\^)/i,/^(?:&)/i,/^(?:,)/i,/^(?:\.)/i,/^(?::)/i,/^(?:;)/i,/^(?:~)/i,/^(?:!)/i,/^(?:\()/i,/^(?:\))/i,/^(?:\[)/i,/^(?:\])/i,/^(?:\$\{[^}]*\})/i,/^(?:`)/i,/^(?:[^`]+)/i,/^(?:`)/i,/^(?:')/i,/^(?:(?:\\\\|\\[']|[^'])+)/i,/^(?:')/i,/^(?:")/i,/^(?:(?:\\\\|\\["]|[^"])+)/i,/^(?:")/i,/^(?:$)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i],
conditions: {"hdfs":{"rules":[116,117,118,119,120,121,163],"inclusive":false},"doubleQuotedValue":{"rules":[158,159,166],"inclusive":false},"singleQuotedValue":{"rules":[155,156,165],"inclusive":false},"backtickedValue":{"rules":[152,153,164],"inclusive":false},"between":{"rules":[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,154,157,160,161,162,167],"inclusive":true},"INITIAL":{"rules":[0,1,2,3,4,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,154,157,160,161,167],"inclusive":true}}
});
return lexer;
})();
parser.lexer = lexer;
function Parser () {
  this.yy = {};
}
Parser.prototype = parser;parser.Parser = Parser;
return new Parser;
})();
export default calciteSyntaxParser;
