// Licensed to Cloudera, Inc. under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  Cloudera, Inc. licenses this file
// to you under the Apache License, Version 2.0 (the
// 'License'); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an 'AS IS' BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import 'ext/bootstrap.2.3.2.min';

import { koSetup } from 'jest/koTestUtils';
import { ASSIST_KEY_COMPONENT } from './ko.assistKey';

describe('ko.assistKey.js', () => {
  const setup = koSetup();

  it('should render component', async () => {
    const entry = {
      definition: {
        primaryKey: true
      },
      isPrimaryKey: () => true,
      isForeignKey: () => false,
      isPartitionKey: () => false
    };
    const element = await setup.renderComponent(ASSIST_KEY_COMPONENT, { entry: entry });

    expect(element.innerHTML).toMatchSnapshot();
  });
});
