/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.enterprise.ssl;

import com.cloudera.enterprise.ssl.ReloadingX509TrustManager;
import com.cloudera.enterprise.ssl.SSLFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.text.MessageFormat;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.configuration.MapConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedKeyStoresFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedKeyStoresFactory.class);
    public static final String SSL_KEYSTORE_LOCATION_TPL_KEY = "com.cloudera.enterprise.ssl.{0}.keystore.location";
    public static final String SSL_KEYSTORE_PASSWORD_TPL_KEY = "com.cloudera.enterprise.ssl.{0}.keystore.password";
    public static final String SSL_KEYSTORE_KEYPASSWORD_TPL_KEY = "com.cloudera.enterprise.ssl.{0}.keystore.keypassword";
    public static final String SSL_KEYSTORE_TYPE_TPL_KEY = "com.cloudera.enterprise.ssl.{0}.keystore.type";
    public static final String SSL_TRUSTSTORE_RELOAD_INTERVAL_TPL_KEY = "com.cloudera.enterprise.ssl.{0}.truststore.reload.interval";
    public static final String SSL_TRUSTSTORE_LOCATION_TPL_KEY = "com.cloudera.enterprise.ssl.{0}.truststore.location";
    public static final String SSL_TRUSTSTORE_PASSWORD_TPL_KEY = "com.cloudera.enterprise.ssl.{0}.truststore.password";
    public static final String SSL_TRUSTSTORE_TYPE_TPL_KEY = "com.cloudera.enterprise.ssl.{0}.truststore.type";
    public static final String DEFAULT_KEYSTORE_TYPE = "jks";
    public static final int DEFAULT_SSL_TRUSTSTORE_RELOAD_INTERVAL = 10000;
    private MapConfiguration conf;
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private ReloadingX509TrustManager trustManager;

    @VisibleForTesting
    public static String resolvePropertyName(SSLFactory.Mode mode, String template) {
        return MessageFormat.format(template, mode.toString().toLowerCase());
    }

    public void setConf(MapConfiguration conf) {
        this.conf = conf;
    }

    public MapConfiguration getConf() {
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(SSLFactory.Mode mode) throws IOException, GeneralSecurityException {
        boolean requireClientCert = this.conf.getBoolean("com.cloudera.enterprise.ssl.require.client.cert", false);
        String keystoreType = this.conf.getString(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_TYPE_TPL_KEY), DEFAULT_KEYSTORE_TYPE);
        KeyStore keystore = KeyStore.getInstance(keystoreType);
        String keystoreKeyPassword = null;
        if (requireClientCert || mode == SSLFactory.Mode.SERVER) {
            String locationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_LOCATION_TPL_KEY);
            String keystoreLocation = this.conf.getString(locationProperty, "");
            if (keystoreLocation.isEmpty()) {
                throw new GeneralSecurityException("The property '" + locationProperty + "' has not been set in the ssl configuration file.");
            }
            String passwordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_PASSWORD_TPL_KEY);
            String keystorePassword = this.conf.getString(passwordProperty, "");
            if (keystorePassword.isEmpty()) {
                throw new GeneralSecurityException("The property '" + passwordProperty + "' has not been set in the ssl configuration file.");
            }
            String keyPasswordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_KEYPASSWORD_TPL_KEY);
            keystoreKeyPassword = this.conf.getString(keyPasswordProperty, keystorePassword);
            LOG.debug(mode.toString() + " KeyStore: " + keystoreLocation);
            try (FileInputStream is = new FileInputStream(keystoreLocation);){
                keystore.load(is, keystorePassword.toCharArray());
            }
            LOG.debug(mode.toString() + " Loaded KeyStore: " + keystoreLocation);
        } else {
            keystore.load(null, null);
        }
        KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(SSLFactory.SSLCERTIFICATE);
        keyMgrFactory.init(keystore, keystoreKeyPassword != null ? keystoreKeyPassword.toCharArray() : null);
        this.keyManagers = keyMgrFactory.getKeyManagers();
        String truststoreType = this.conf.getString(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_TYPE_TPL_KEY), DEFAULT_KEYSTORE_TYPE);
        String locationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_LOCATION_TPL_KEY);
        String truststoreLocation = this.conf.getString(locationProperty, "");
        if (truststoreLocation.isEmpty()) {
            throw new GeneralSecurityException("The property '" + locationProperty + "' has not been set in the ssl configuration file.");
        }
        String passwordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_PASSWORD_TPL_KEY);
        String truststorePassword = this.conf.getString(passwordProperty, "");
        if (truststorePassword.isEmpty()) {
            truststorePassword = null;
        }
        long truststoreReloadInterval = this.conf.getLong(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_RELOAD_INTERVAL_TPL_KEY), 10000L);
        LOG.debug(mode.toString() + " TrustStore: " + truststoreLocation);
        this.trustManager = new ReloadingX509TrustManager(truststoreType, truststoreLocation, truststorePassword, truststoreReloadInterval);
        this.trustManager.init();
        LOG.debug(mode.toString() + " Loaded TrustStore: " + truststoreLocation);
        this.trustManagers = new TrustManager[]{this.trustManager};
    }

    public synchronized void destroy() {
        if (this.trustManager != null) {
            this.trustManager.destroy();
            this.trustManager = null;
            this.keyManagers = null;
            this.trustManagers = null;
        }
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }
}

