CREATE DATABASE  IF NOT EXISTS `base` /*!40100 DEFAULT CHARACTER SET utf8 */;
USE `base`;
-- MySQL dump 10.13  Distrib 5.7.17, for Win64 (x86_64)
--
-- Host: localhost    Database: base
-- ------------------------------------------------------
-- Server version	5.7.17-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `sm_enumdefine`
--

DROP TABLE IF EXISTS `sm_enumdefine`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sm_enumdefine` (
  `EnumDefineID` bigint(20) NOT NULL DEFAULT '0' COMMENT '枚举定义ID',
  `EnumDefineCode` varchar(50) NOT NULL COMMENT '枚举定义编码',
  `EnumDefineName` varchar(50) NOT NULL COMMENT '枚举定义名称',
  `IsAdd` bit(1) DEFAULT NULL COMMENT '可增加',
  `IsEdit` bit(1) DEFAULT NULL COMMENT '可编辑',
  `IsSystem` bit(1) DEFAULT NULL COMMENT '是否系统',
  `CreateTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CreateUserID` bigint(20) DEFAULT NULL COMMENT '创建用户ID',
  `ModifyTime` datetime DEFAULT NULL COMMENT '修改时间',
  `ModifyUserID` bigint(20) DEFAULT NULL COMMENT '修改用户ID',
  `Version` int(5) NOT NULL DEFAULT '0' COMMENT '版本',
  PRIMARY KEY (`EnumDefineID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sm_enumdefine`
--

LOCK TABLES `sm_enumdefine` WRITE;
/*!40000 ALTER TABLE `sm_enumdefine` DISABLE KEYS */;
/*!40000 ALTER TABLE `sm_enumdefine` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sm_enumitem`
--

DROP TABLE IF EXISTS `sm_enumitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sm_enumitem` (
  `EnumItemID` bigint(20) NOT NULL DEFAULT '0' COMMENT '枚举项ID',
  `EnumItemValue` int(5) DEFAULT NULL COMMENT '枚举项值',
  `EnumItemName` varchar(50) NOT NULL COMMENT '枚举项名称',
  `EnumDefineID` bigint(20) NOT NULL DEFAULT '0' COMMENT '枚举定义ID',
  `CreateTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CreateUserID` bigint(20) DEFAULT NULL COMMENT '创建用户ID',
  `ModifyTime` datetime DEFAULT NULL COMMENT '修改时间',
  `ModifyUserID` bigint(20) DEFAULT NULL COMMENT '修改用户ID',
  `Version` int(5) NOT NULL DEFAULT '0' COMMENT '版本',
  PRIMARY KEY (`EnumItemID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sm_enumitem`
--

LOCK TABLES `sm_enumitem` WRITE;
/*!40000 ALTER TABLE `sm_enumitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `sm_enumitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sm_function`
--

DROP TABLE IF EXISTS `sm_function`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sm_function` (
  `FunctionID` bigint(20) NOT NULL DEFAULT '0' COMMENT '功能ID',
  `FunctionCode` varchar(50) NOT NULL COMMENT '功能编码',
  `FunctionName` varchar(50) NOT NULL COMMENT '功能名称',
  `TreeCode` varchar(50) NOT NULL COMMENT '树编码',
  `Url` varchar(200) DEFAULT NULL COMMENT '访问地址',
  `FunctionType` int(5) NOT NULL DEFAULT '0' COMMENT '功能类型',
  `ParentID` bigint(20) DEFAULT NULL COMMENT '父ID',
  `IsAuthControll` bit(1) NOT NULL COMMENT '是否权限控制',
  `IsDisable` bit(1) NOT NULL COMMENT '是否禁用',
  `ModuleID` bigint(20) NOT NULL DEFAULT '0' COMMENT '模块ID',
  `Icon` varchar(50) DEFAULT NULL COMMENT '图标',
  `CreateTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CreateUserID` bigint(20) DEFAULT NULL COMMENT '创建用户ID',
  `ModifyTime` datetime DEFAULT NULL COMMENT '修改时间',
  `ModifyUserID` bigint(20) DEFAULT NULL COMMENT '修改用户ID',
  `Version` int(5) NOT NULL DEFAULT '0' COMMENT '版本',
  PRIMARY KEY (`FunctionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sm_function`
--

LOCK TABLES `sm_function` WRITE;
/*!40000 ALTER TABLE `sm_function` DISABLE KEYS */;
/*!40000 ALTER TABLE `sm_function` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sm_mapdefine`
--

DROP TABLE IF EXISTS `sm_mapdefine`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sm_mapdefine` (
  `MapDefineID` bigint(20) NOT NULL DEFAULT '0' COMMENT '映射定义ID',
  `MapDefineCode` varchar(50) NOT NULL COMMENT '映射定义编码',
  `MapDefineName` varchar(50) NOT NULL COMMENT '映射定义名称',
  `IsAdd` bit(1) DEFAULT NULL COMMENT '可增加',
  `IsEdit` bit(1) DEFAULT NULL COMMENT '可编辑',
  `IsSystem` bit(1) DEFAULT NULL COMMENT '是否系统',
  `CreateTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CreateUserID` bigint(20) DEFAULT NULL COMMENT '创建用户ID',
  `ModifyTime` datetime DEFAULT NULL COMMENT '修改时间',
  `ModifyUserID` bigint(20) DEFAULT NULL COMMENT '修改用户ID',
  `Version` int(5) NOT NULL DEFAULT '0' COMMENT '版本',
  PRIMARY KEY (`MapDefineID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sm_mapdefine`
--

LOCK TABLES `sm_mapdefine` WRITE;
/*!40000 ALTER TABLE `sm_mapdefine` DISABLE KEYS */;
/*!40000 ALTER TABLE `sm_mapdefine` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sm_mapitem`
--

DROP TABLE IF EXISTS `sm_mapitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sm_mapitem` (
  `MapItemID` bigint(20) NOT NULL DEFAULT '0' COMMENT '映射项ID',
  `MapItemCode` varchar(50) NOT NULL COMMENT '映射项编码',
  `MapItemName` varchar(50) NOT NULL COMMENT '映射项名称',
  `MapDefineID` bigint(20) NOT NULL DEFAULT '0' COMMENT '映射定义ID',
  `CreateTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CreateUserID` bigint(20) DEFAULT NULL COMMENT '创建用户ID',
  `ModifyTime` datetime DEFAULT NULL COMMENT '修改时间',
  `ModifyUserID` bigint(20) DEFAULT NULL COMMENT '修改用户ID',
  `Version` int(5) NOT NULL DEFAULT '0' COMMENT '版本',
  PRIMARY KEY (`MapItemID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sm_mapitem`
--

LOCK TABLES `sm_mapitem` WRITE;
/*!40000 ALTER TABLE `sm_mapitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `sm_mapitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sm_module`
--

DROP TABLE IF EXISTS `sm_module`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sm_module` (
  `ModuleID` bigint(20) NOT NULL DEFAULT '0' COMMENT '模块ID',
  `ModuleCode` varchar(50) NOT NULL COMMENT '模块编码',
  `ModuleName` varchar(50) NOT NULL COMMENT '模块名称',
  `OrderNo` int(5) NOT NULL DEFAULT '0' COMMENT '序号',
  `IsDisable` bit(1) NOT NULL COMMENT '是否禁用',
  `CreateTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CreateUserID` bigint(20) DEFAULT NULL COMMENT '创建用户ID',
  `ModifyTime` datetime DEFAULT NULL COMMENT '修改时间',
  `ModifyUserID` bigint(20) DEFAULT NULL COMMENT '修改用户ID',
  `Version` int(5) NOT NULL DEFAULT '0' COMMENT '版本',
  PRIMARY KEY (`ModuleID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sm_module`
--

LOCK TABLES `sm_module` WRITE;
/*!40000 ALTER TABLE `sm_module` DISABLE KEYS */;
/*!40000 ALTER TABLE `sm_module` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sm_role`
--

DROP TABLE IF EXISTS `sm_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sm_role` (
  `RoleID` bigint(20) NOT NULL DEFAULT '0' COMMENT '角色ID',
  `RoleCode` varchar(50) NOT NULL COMMENT '角色编码',
  `RoleName` varchar(50) NOT NULL COMMENT '角色名称',
  `IsEffective` bit(1) DEFAULT NULL COMMENT '是否生效',
  `EffectiveFrom` date DEFAULT NULL COMMENT '生效日期',
  `EffectiveTo` date DEFAULT NULL COMMENT '失效日期',
  `CreateTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CreateUserID` bigint(20) DEFAULT NULL COMMENT '创建用户ID',
  `ModifyTime` datetime DEFAULT NULL COMMENT '修改时间',
  `ModifyUserID` bigint(20) DEFAULT NULL COMMENT '修改用户ID',
  `Version` int(5) NOT NULL DEFAULT '0' COMMENT '版本',
  PRIMARY KEY (`RoleID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sm_role`
--

LOCK TABLES `sm_role` WRITE;
/*!40000 ALTER TABLE `sm_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `sm_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sm_rolefunction`
--

DROP TABLE IF EXISTS `sm_rolefunction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sm_rolefunction` (
  `RoleFunctionID` bigint(20) NOT NULL DEFAULT '0' COMMENT '角色功能ID',
  `RoleID` bigint(20) NOT NULL DEFAULT '0' COMMENT '角色ID',
  `FunctionID` bigint(20) NOT NULL DEFAULT '0' COMMENT '功能ID',
  `CreateTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CreateUserID` bigint(20) DEFAULT NULL COMMENT '创建用户ID',
  `ModifyTime` datetime DEFAULT NULL COMMENT '修改时间',
  `ModifyUserID` bigint(20) DEFAULT NULL COMMENT '修改用户ID',
  `Version` int(5) NOT NULL DEFAULT '0' COMMENT '版本',
  PRIMARY KEY (`RoleFunctionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sm_rolefunction`
--

LOCK TABLES `sm_rolefunction` WRITE;
/*!40000 ALTER TABLE `sm_rolefunction` DISABLE KEYS */;
/*!40000 ALTER TABLE `sm_rolefunction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sm_user`
--

DROP TABLE IF EXISTS `sm_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sm_user` (
  `UserID` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `UserCode` varchar(50) NOT NULL COMMENT '用户编码',
  `UserName` varchar(50) NOT NULL COMMENT '用户名称',
  `IsEffective` bit(1) DEFAULT NULL COMMENT '是否生效',
  `EffectiveFrom` date DEFAULT NULL COMMENT '生效日期',
  `EffectiveTo` date DEFAULT NULL COMMENT '失效日期',
  `Pass` varchar(30) NOT NULL COMMENT '密码',
  `CreateTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CreateUserID` bigint(20) DEFAULT NULL COMMENT '创建用户ID',
  `ModifyTime` datetime DEFAULT NULL COMMENT '修改时间',
  `ModifyUserID` bigint(20) DEFAULT NULL COMMENT '修改用户ID',
  `Version` int(5) NOT NULL DEFAULT '0' COMMENT '版本',
  PRIMARY KEY (`UserID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sm_user`
--

LOCK TABLES `sm_user` WRITE;
/*!40000 ALTER TABLE `sm_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `sm_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sm_userrole`
--

DROP TABLE IF EXISTS `sm_userrole`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sm_userrole` (
  `UserRoleID` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户角色ID',
  `UserID` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `RoleID` bigint(20) NOT NULL DEFAULT '0' COMMENT '角色ID',
  `CreateTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `CreateUserID` bigint(20) DEFAULT NULL COMMENT '创建用户ID',
  `ModifyTime` datetime DEFAULT NULL COMMENT '修改时间',
  `ModifyUserID` bigint(20) DEFAULT NULL COMMENT '修改用户ID',
  `Version` int(5) NOT NULL DEFAULT '0' COMMENT '版本',
  PRIMARY KEY (`UserRoleID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sm_userrole`
--

LOCK TABLES `sm_userrole` WRITE;
/*!40000 ALTER TABLE `sm_userrole` DISABLE KEYS */;
/*!40000 ALTER TABLE `sm_userrole` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary view structure for view `view_sm_enumdefine`
--

DROP TABLE IF EXISTS `view_sm_enumdefine`;
/*!50001 DROP VIEW IF EXISTS `view_sm_enumdefine`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `view_sm_enumdefine` AS SELECT 
 1 AS `EnumDefineID`,
 1 AS `EnumDefineCode`,
 1 AS `EnumDefineName`,
 1 AS `IsAdd`,
 1 AS `IsEdit`,
 1 AS `IsSystem`,
 1 AS `CreateTime`,
 1 AS `CreateUserID`,
 1 AS `CreateUserCode`,
 1 AS `CreateUserName`,
 1 AS `ModifyTime`,
 1 AS `ModifyUserID`,
 1 AS `ModifyUserCode`,
 1 AS `ModifyUserName`,
 1 AS `Version`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `view_sm_enumitem`
--

DROP TABLE IF EXISTS `view_sm_enumitem`;
/*!50001 DROP VIEW IF EXISTS `view_sm_enumitem`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `view_sm_enumitem` AS SELECT 
 1 AS `EnumItemID`,
 1 AS `EnumItemValue`,
 1 AS `EnumItemName`,
 1 AS `EnumDefineID`,
 1 AS `EnumDefineCode`,
 1 AS `EnumDefineName`,
 1 AS `CreateTime`,
 1 AS `CreateUserID`,
 1 AS `CreateUserCode`,
 1 AS `CreateUserName`,
 1 AS `ModifyTime`,
 1 AS `ModifyUserID`,
 1 AS `ModifyUserCode`,
 1 AS `ModifyUserName`,
 1 AS `Version`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `view_sm_function`
--

DROP TABLE IF EXISTS `view_sm_function`;
/*!50001 DROP VIEW IF EXISTS `view_sm_function`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `view_sm_function` AS SELECT 
 1 AS `FunctionID`,
 1 AS `FunctionCode`,
 1 AS `FunctionName`,
 1 AS `TreeCode`,
 1 AS `Url`,
 1 AS `FunctionType`,
 1 AS `ParentID`,
 1 AS `ParenFunctionCode`,
 1 AS `ParenFunctionName`,
 1 AS `IsAuthControll`,
 1 AS `IsDisable`,
 1 AS `ModuleID`,
 1 AS `ModuleCode`,
 1 AS `ModuleName`,
 1 AS `Icon`,
 1 AS `CreateTime`,
 1 AS `CreateUserID`,
 1 AS `CreateUserCode`,
 1 AS `CreateUserName`,
 1 AS `ModifyTime`,
 1 AS `ModifyUserID`,
 1 AS `ModifyUserCode`,
 1 AS `ModifyUserName`,
 1 AS `Version`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `view_sm_mapdefine`
--

DROP TABLE IF EXISTS `view_sm_mapdefine`;
/*!50001 DROP VIEW IF EXISTS `view_sm_mapdefine`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `view_sm_mapdefine` AS SELECT 
 1 AS `MapDefineID`,
 1 AS `MapDefineCode`,
 1 AS `MapDefineName`,
 1 AS `IsAdd`,
 1 AS `IsEdit`,
 1 AS `IsSystem`,
 1 AS `CreateTime`,
 1 AS `CreateUserID`,
 1 AS `CreateUserCode`,
 1 AS `CreateUserName`,
 1 AS `ModifyTime`,
 1 AS `ModifyUserID`,
 1 AS `ModifyUserCode`,
 1 AS `ModifyUserName`,
 1 AS `Version`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `view_sm_mapitem`
--

DROP TABLE IF EXISTS `view_sm_mapitem`;
/*!50001 DROP VIEW IF EXISTS `view_sm_mapitem`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `view_sm_mapitem` AS SELECT 
 1 AS `MapItemID`,
 1 AS `MapItemCode`,
 1 AS `MapItemName`,
 1 AS `MapDefineID`,
 1 AS `MapDefineCode`,
 1 AS `MapDefineName`,
 1 AS `CreateTime`,
 1 AS `CreateUserID`,
 1 AS `CreateUserCode`,
 1 AS `CreateUserName`,
 1 AS `ModifyTime`,
 1 AS `ModifyUserID`,
 1 AS `ModifyUserCode`,
 1 AS `ModifyUserName`,
 1 AS `Version`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `view_sm_module`
--

DROP TABLE IF EXISTS `view_sm_module`;
/*!50001 DROP VIEW IF EXISTS `view_sm_module`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `view_sm_module` AS SELECT 
 1 AS `ModuleID`,
 1 AS `ModuleCode`,
 1 AS `ModuleName`,
 1 AS `OrderNo`,
 1 AS `IsDisable`,
 1 AS `CreateTime`,
 1 AS `CreateUserID`,
 1 AS `CreateUserCode`,
 1 AS `CreateUserName`,
 1 AS `ModifyTime`,
 1 AS `ModifyUserID`,
 1 AS `ModifyUserCode`,
 1 AS `ModifyUserName`,
 1 AS `Version`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `view_sm_role`
--

DROP TABLE IF EXISTS `view_sm_role`;
/*!50001 DROP VIEW IF EXISTS `view_sm_role`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `view_sm_role` AS SELECT 
 1 AS `RoleID`,
 1 AS `RoleCode`,
 1 AS `RoleName`,
 1 AS `IsEffective`,
 1 AS `EffectiveFrom`,
 1 AS `EffectiveTo`,
 1 AS `CreateTime`,
 1 AS `CreateUserID`,
 1 AS `CreateUserCode`,
 1 AS `CreateUserName`,
 1 AS `ModifyTime`,
 1 AS `ModifyUserID`,
 1 AS `ModifyUserCode`,
 1 AS `ModifyUserName`,
 1 AS `Version`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `view_sm_rolefunction`
--

DROP TABLE IF EXISTS `view_sm_rolefunction`;
/*!50001 DROP VIEW IF EXISTS `view_sm_rolefunction`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `view_sm_rolefunction` AS SELECT 
 1 AS `RoleFunctionID`,
 1 AS `RoleID`,
 1 AS `RoleCode`,
 1 AS `RoleName`,
 1 AS `FunctionID`,
 1 AS `FunctionCode`,
 1 AS `FunctionName`,
 1 AS `CreateTime`,
 1 AS `CreateUserID`,
 1 AS `CreateUserCode`,
 1 AS `CreateUserName`,
 1 AS `ModifyTime`,
 1 AS `ModifyUserID`,
 1 AS `ModifyUserCode`,
 1 AS `ModifyUserName`,
 1 AS `Version`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `view_sm_user`
--

DROP TABLE IF EXISTS `view_sm_user`;
/*!50001 DROP VIEW IF EXISTS `view_sm_user`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `view_sm_user` AS SELECT 
 1 AS `UserID`,
 1 AS `UserCode`,
 1 AS `UserName`,
 1 AS `IsEffective`,
 1 AS `EffectiveFrom`,
 1 AS `EffectiveTo`,
 1 AS `Pass`,
 1 AS `CreateTime`,
 1 AS `CreateUserID`,
 1 AS `CreateUserCode`,
 1 AS `CreateUserName`,
 1 AS `ModifyTime`,
 1 AS `ModifyUserID`,
 1 AS `ModifyUserCode`,
 1 AS `ModifyUserName`,
 1 AS `Version`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `view_sm_userrole`
--

DROP TABLE IF EXISTS `view_sm_userrole`;
/*!50001 DROP VIEW IF EXISTS `view_sm_userrole`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `view_sm_userrole` AS SELECT 
 1 AS `UserRoleID`,
 1 AS `UserID`,
 1 AS `UserCode`,
 1 AS `UserName`,
 1 AS `RoleID`,
 1 AS `RoleCode`,
 1 AS `RoleName`,
 1 AS `CreateTime`,
 1 AS `CreateUserID`,
 1 AS `CreateUserCode`,
 1 AS `CreateUserName`,
 1 AS `ModifyTime`,
 1 AS `ModifyUserID`,
 1 AS `ModifyUserCode`,
 1 AS `ModifyUserName`,
 1 AS `Version`*/;
SET character_set_client = @saved_cs_client;

--
-- Dumping routines for database 'base'
--

--
-- Final view structure for view `view_sm_enumdefine`
--

/*!50001 DROP VIEW IF EXISTS `view_sm_enumdefine`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `view_sm_enumdefine` AS select `a`.`EnumDefineID` AS `EnumDefineID`,`a`.`EnumDefineCode` AS `EnumDefineCode`,`a`.`EnumDefineName` AS `EnumDefineName`,`a`.`IsAdd` AS `IsAdd`,`a`.`IsEdit` AS `IsEdit`,`a`.`IsSystem` AS `IsSystem`,`a`.`CreateTime` AS `CreateTime`,`a`.`CreateUserID` AS `CreateUserID`,`b`.`UserCode` AS `CreateUserCode`,`b`.`UserName` AS `CreateUserName`,`a`.`ModifyTime` AS `ModifyTime`,`a`.`ModifyUserID` AS `ModifyUserID`,`c`.`UserCode` AS `ModifyUserCode`,`c`.`UserName` AS `ModifyUserName`,`a`.`Version` AS `Version` from ((`sm_enumdefine` `a` left join `sm_user` `b` on((`a`.`CreateUserID` = `b`.`UserID`))) left join `sm_user` `c` on((`a`.`ModifyUserID` = `c`.`UserID`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `view_sm_enumitem`
--

/*!50001 DROP VIEW IF EXISTS `view_sm_enumitem`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `view_sm_enumitem` AS select `a`.`EnumItemID` AS `EnumItemID`,`a`.`EnumItemValue` AS `EnumItemValue`,`a`.`EnumItemName` AS `EnumItemName`,`a`.`EnumDefineID` AS `EnumDefineID`,`b`.`EnumDefineCode` AS `EnumDefineCode`,`b`.`EnumDefineName` AS `EnumDefineName`,`a`.`CreateTime` AS `CreateTime`,`a`.`CreateUserID` AS `CreateUserID`,`c`.`UserCode` AS `CreateUserCode`,`c`.`UserName` AS `CreateUserName`,`a`.`ModifyTime` AS `ModifyTime`,`a`.`ModifyUserID` AS `ModifyUserID`,`d`.`UserCode` AS `ModifyUserCode`,`d`.`UserName` AS `ModifyUserName`,`a`.`Version` AS `Version` from (((`sm_enumitem` `a` left join `sm_enumdefine` `b` on((`a`.`EnumDefineID` = `b`.`EnumDefineID`))) left join `sm_user` `c` on((`a`.`CreateUserID` = `c`.`UserID`))) left join `sm_user` `d` on((`a`.`ModifyUserID` = `d`.`UserID`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `view_sm_function`
--

/*!50001 DROP VIEW IF EXISTS `view_sm_function`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `view_sm_function` AS select `a`.`FunctionID` AS `FunctionID`,`a`.`FunctionCode` AS `FunctionCode`,`a`.`FunctionName` AS `FunctionName`,`a`.`TreeCode` AS `TreeCode`,`a`.`Url` AS `Url`,`a`.`FunctionType` AS `FunctionType`,`a`.`ParentID` AS `ParentID`,`b`.`FunctionCode` AS `ParenFunctionCode`,`b`.`FunctionName` AS `ParenFunctionName`,`a`.`IsAuthControll` AS `IsAuthControll`,`a`.`IsDisable` AS `IsDisable`,`a`.`ModuleID` AS `ModuleID`,`c`.`ModuleCode` AS `ModuleCode`,`c`.`ModuleName` AS `ModuleName`,`a`.`Icon` AS `Icon`,`a`.`CreateTime` AS `CreateTime`,`a`.`CreateUserID` AS `CreateUserID`,`d`.`UserCode` AS `CreateUserCode`,`d`.`UserName` AS `CreateUserName`,`a`.`ModifyTime` AS `ModifyTime`,`a`.`ModifyUserID` AS `ModifyUserID`,`e`.`UserCode` AS `ModifyUserCode`,`e`.`UserName` AS `ModifyUserName`,`a`.`Version` AS `Version` from ((((`sm_function` `a` left join `sm_function` `b` on((`a`.`ParentID` = `b`.`FunctionID`))) left join `sm_module` `c` on((`a`.`ModuleID` = `c`.`ModuleID`))) left join `sm_user` `d` on((`a`.`CreateUserID` = `d`.`UserID`))) left join `sm_user` `e` on((`a`.`ModifyUserID` = `e`.`UserID`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `view_sm_mapdefine`
--

/*!50001 DROP VIEW IF EXISTS `view_sm_mapdefine`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `view_sm_mapdefine` AS select `a`.`MapDefineID` AS `MapDefineID`,`a`.`MapDefineCode` AS `MapDefineCode`,`a`.`MapDefineName` AS `MapDefineName`,`a`.`IsAdd` AS `IsAdd`,`a`.`IsEdit` AS `IsEdit`,`a`.`IsSystem` AS `IsSystem`,`a`.`CreateTime` AS `CreateTime`,`a`.`CreateUserID` AS `CreateUserID`,`b`.`UserCode` AS `CreateUserCode`,`b`.`UserName` AS `CreateUserName`,`a`.`ModifyTime` AS `ModifyTime`,`a`.`ModifyUserID` AS `ModifyUserID`,`c`.`UserCode` AS `ModifyUserCode`,`c`.`UserName` AS `ModifyUserName`,`a`.`Version` AS `Version` from ((`sm_mapdefine` `a` left join `sm_user` `b` on((`a`.`CreateUserID` = `b`.`UserID`))) left join `sm_user` `c` on((`a`.`ModifyUserID` = `c`.`UserID`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `view_sm_mapitem`
--

/*!50001 DROP VIEW IF EXISTS `view_sm_mapitem`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `view_sm_mapitem` AS select `a`.`MapItemID` AS `MapItemID`,`a`.`MapItemCode` AS `MapItemCode`,`a`.`MapItemName` AS `MapItemName`,`a`.`MapDefineID` AS `MapDefineID`,`b`.`MapDefineCode` AS `MapDefineCode`,`b`.`MapDefineName` AS `MapDefineName`,`a`.`CreateTime` AS `CreateTime`,`a`.`CreateUserID` AS `CreateUserID`,`c`.`UserCode` AS `CreateUserCode`,`c`.`UserName` AS `CreateUserName`,`a`.`ModifyTime` AS `ModifyTime`,`a`.`ModifyUserID` AS `ModifyUserID`,`d`.`UserCode` AS `ModifyUserCode`,`d`.`UserName` AS `ModifyUserName`,`a`.`Version` AS `Version` from (((`sm_mapitem` `a` left join `sm_mapdefine` `b` on((`a`.`MapDefineID` = `b`.`MapDefineID`))) left join `sm_user` `c` on((`a`.`CreateUserID` = `c`.`UserID`))) left join `sm_user` `d` on((`a`.`ModifyUserID` = `d`.`UserID`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `view_sm_module`
--

/*!50001 DROP VIEW IF EXISTS `view_sm_module`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `view_sm_module` AS select `a`.`ModuleID` AS `ModuleID`,`a`.`ModuleCode` AS `ModuleCode`,`a`.`ModuleName` AS `ModuleName`,`a`.`OrderNo` AS `OrderNo`,`a`.`IsDisable` AS `IsDisable`,`a`.`CreateTime` AS `CreateTime`,`a`.`CreateUserID` AS `CreateUserID`,`b`.`UserCode` AS `CreateUserCode`,`b`.`UserName` AS `CreateUserName`,`a`.`ModifyTime` AS `ModifyTime`,`a`.`ModifyUserID` AS `ModifyUserID`,`c`.`UserCode` AS `ModifyUserCode`,`c`.`UserName` AS `ModifyUserName`,`a`.`Version` AS `Version` from ((`sm_module` `a` left join `sm_user` `b` on((`a`.`CreateUserID` = `b`.`UserID`))) left join `sm_user` `c` on((`a`.`ModifyUserID` = `c`.`UserID`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `view_sm_role`
--

/*!50001 DROP VIEW IF EXISTS `view_sm_role`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `view_sm_role` AS select `a`.`RoleID` AS `RoleID`,`a`.`RoleCode` AS `RoleCode`,`a`.`RoleName` AS `RoleName`,`a`.`IsEffective` AS `IsEffective`,`a`.`EffectiveFrom` AS `EffectiveFrom`,`a`.`EffectiveTo` AS `EffectiveTo`,`a`.`CreateTime` AS `CreateTime`,`a`.`CreateUserID` AS `CreateUserID`,`b`.`UserCode` AS `CreateUserCode`,`b`.`UserName` AS `CreateUserName`,`a`.`ModifyTime` AS `ModifyTime`,`a`.`ModifyUserID` AS `ModifyUserID`,`c`.`UserCode` AS `ModifyUserCode`,`c`.`UserName` AS `ModifyUserName`,`a`.`Version` AS `Version` from ((`sm_role` `a` left join `sm_user` `b` on((`a`.`CreateUserID` = `b`.`UserID`))) left join `sm_user` `c` on((`a`.`ModifyUserID` = `c`.`UserID`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `view_sm_rolefunction`
--

/*!50001 DROP VIEW IF EXISTS `view_sm_rolefunction`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `view_sm_rolefunction` AS select `a`.`RoleFunctionID` AS `RoleFunctionID`,`a`.`RoleID` AS `RoleID`,`b`.`RoleCode` AS `RoleCode`,`b`.`RoleName` AS `RoleName`,`a`.`FunctionID` AS `FunctionID`,`c`.`FunctionCode` AS `FunctionCode`,`c`.`FunctionName` AS `FunctionName`,`a`.`CreateTime` AS `CreateTime`,`a`.`CreateUserID` AS `CreateUserID`,`d`.`UserCode` AS `CreateUserCode`,`d`.`UserName` AS `CreateUserName`,`a`.`ModifyTime` AS `ModifyTime`,`a`.`ModifyUserID` AS `ModifyUserID`,`e`.`UserCode` AS `ModifyUserCode`,`e`.`UserName` AS `ModifyUserName`,`a`.`Version` AS `Version` from ((((`sm_rolefunction` `a` left join `sm_role` `b` on((`a`.`RoleID` = `b`.`RoleID`))) left join `sm_function` `c` on((`a`.`FunctionID` = `c`.`FunctionID`))) left join `sm_user` `d` on((`a`.`CreateUserID` = `d`.`UserID`))) left join `sm_user` `e` on((`a`.`ModifyUserID` = `e`.`UserID`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `view_sm_user`
--

/*!50001 DROP VIEW IF EXISTS `view_sm_user`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `view_sm_user` AS select `a`.`UserID` AS `UserID`,`a`.`UserCode` AS `UserCode`,`a`.`UserName` AS `UserName`,`a`.`IsEffective` AS `IsEffective`,`a`.`EffectiveFrom` AS `EffectiveFrom`,`a`.`EffectiveTo` AS `EffectiveTo`,`a`.`Pass` AS `Pass`,`a`.`CreateTime` AS `CreateTime`,`a`.`CreateUserID` AS `CreateUserID`,`b`.`UserCode` AS `CreateUserCode`,`b`.`UserName` AS `CreateUserName`,`a`.`ModifyTime` AS `ModifyTime`,`a`.`ModifyUserID` AS `ModifyUserID`,`c`.`UserCode` AS `ModifyUserCode`,`c`.`UserName` AS `ModifyUserName`,`a`.`Version` AS `Version` from ((`sm_user` `a` left join `sm_user` `b` on((`a`.`CreateUserID` = `b`.`UserID`))) left join `sm_user` `c` on((`a`.`ModifyUserID` = `c`.`UserID`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `view_sm_userrole`
--

/*!50001 DROP VIEW IF EXISTS `view_sm_userrole`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `view_sm_userrole` AS select `a`.`UserRoleID` AS `UserRoleID`,`a`.`UserID` AS `UserID`,`b`.`UserCode` AS `UserCode`,`b`.`UserName` AS `UserName`,`a`.`RoleID` AS `RoleID`,`c`.`RoleCode` AS `RoleCode`,`c`.`RoleName` AS `RoleName`,`a`.`CreateTime` AS `CreateTime`,`a`.`CreateUserID` AS `CreateUserID`,`d`.`UserCode` AS `CreateUserCode`,`d`.`UserName` AS `CreateUserName`,`a`.`ModifyTime` AS `ModifyTime`,`a`.`ModifyUserID` AS `ModifyUserID`,`e`.`UserCode` AS `ModifyUserCode`,`e`.`UserName` AS `ModifyUserName`,`a`.`Version` AS `Version` from ((((`sm_userrole` `a` left join `sm_user` `b` on((`a`.`UserID` = `b`.`UserID`))) left join `sm_role` `c` on((`a`.`RoleID` = `c`.`RoleID`))) left join `sm_user` `d` on((`a`.`CreateUserID` = `d`.`UserID`))) left join `sm_user` `e` on((`a`.`ModifyUserID` = `e`.`UserID`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-07-13 16:33:58
