	$(function(){
		var context=$.htextend.curForm();
		
		var attribdata=[];
		if($('#attributeList').val())
			attribdata=JSON.parse($('#attributeList').val());
		$.htgrid.init('attribTable',{
			data : attribdata,
			reorderableRows: true,
			useRowAttrFunc: true,
			uniqueId: "attributeCode", //每一行的唯一标识，一般为主键列
			height: 400,
            //pagination: true,
            //sidePagination: "client",           // 分页方式：client客户端分页，server服务端分页（*）
            //pageNumber: 1,                       // 初始化加载第一页，默认第一页
            //pageSize: 10,                       // 每页的记录行数（*）
            //paginationHAlign: 'left',
			columns: [
				{field : 'sel',radio:true}, 
				{field : 'index',title : '行号',width:'80',formatter: function (value, row, index) {
	                    return index+1;
	                }
				}, 
				{field : 'attributeID',title : '编码',width:'120',visible:false}, 
				{field : 'attributeCode',title : '编码',width:'120'}, 
				{field : 'attributeName',title : '名称',width:'120'},
				{field : 'attributeType',title : '类型',width:'80',cellStyle:function(value, row, index){
					if(value=='normal')
						return {classes:''};
					else if(value=='key')
						return {classes:'bg-red'};
					else if(value=='log')
						return {classes:'bg-yellow'};
					else
						return {classes:'bg-aqua'};
				} },
				{field : 'valueClass',title : '值类型',width :'80',extmap:'valueClass',cellStyle:function(value, row, index){
					if(value=='entity')
						return {classes:'bg-yellow'};
					else if(value=='extenum')
						return {classes:'bg-aqua'};
					else if(value=='extmap')
						return {classes:'bg-olive'};
					else
							return {classes:''};
				} },
				{field : 'isNull',title : '可空',width:'80',extmap:'boolType',cellStyle:function(value, row, index){
					if(eval(value))
						return {classes:'bg-aqua'};
					else
						return {classes:''};
				} },
				{field : 'sourceModel',title : '来源实体',width:'80'},
				{field : 'enumDefine',title : '来源枚举',width:'80'},
				{field : 'mapDefine',title : '来源映射',width:'100'},
				{field : 'sourceAttribute',title : '来源属性',width:'120'},
				{field : 'typeDefine',title : '类型定义',width:'80'},
				{field : 'dataType',title : '数据类型',width:'80'},
				{field : 'dataLength',title : '长度',width:'80'},
				{field : 'dataScale',title : '精度',width:'80'},
				{field : 'defaultValue',title : '缺省值',width:'80'},
				{field : 'isSystem',title : '系统',width:'80',extmap:'boolType'}
			]
		});
		function init() {
			if($('#parentModel').val()!='') {
				//如果有父实体，模型类型=实体
				$("#modelType").setDisable();
			}
			$('#btn_assoentity').enable(eval($("#modelType").val())==3);
			showAttribute(false);
		}
		
		$("#modelType").change(function () {  
			changeModelType($(this).val());
		});
		
		function changeModelType(value) {
			//debugger;
			$('#baseModel').val("");
			$('#tableName').val("");
			if(value==0||value==4) {//BaseModel
				$('#baseModel').setDisable();
				$('#tableName').setDisable();
			}
			else if(value==1){//Entity
				$('#baseModel').setEnable();
				$('#tableName').setEnable();
			}
		}
	    $("#btn_save").on("click", function (event) {
	    	showAttribute(true);
	    	var data=$.htgrid.getData('attribTable');
	    	showAttribute(false);
	    	if(data)
	    		$('#attributeList').val(JSON.stringify(data));
	        $.htextend.save(context,function(){
	        	$.htmenu.getSubMenu();
	        	$.htextend.close();
	        });
	    });
	    $("#btn_close").on("click", function (event) {
	        $.htextend.close();
	    });
	    $("#btn_addline").on("click", function (event) {
	    	$.htextend.openDlg("增加属性","/metadata/model/page/attribute_add",3);
	    });
	    $("#btn_editline").on("click", function (event) {
	    	//debugger;
	    	var row=$.htgrid.getSelection('attribTable');
	    		
	    	//alert('data='+JSON.stringify(row[0]));
	    	if(row&&row.length>0) {
		    	if(eval(row[0].isSystem)) {
		    		//$.htextend.showError("系统属性不能修改");
		    		//return;
		    	}
	    		var data=encodeURIComponent(JSON.stringify(row[0]));
	    		$.htextend.openDlg("编辑属性","/metadata/model/page/attribute_update?data="+data,3);
	    	}
	    });
	    $("#btn_deleteline").on("click", function (event) {
	    	//debugger;
	    	var row=$.htgrid.getSelection('attribTable');
	    	if(row&&row.length>0) {
		    	if(eval(row[0].isSystem)) {
		    		//$.htextend.showError("系统属性不能删除");
		    		//return;
		    	}
				$.htextend.confirm('提示',"要删除记录吗？", function(index){
					$.htgrid.removeSelection('attribTable','attributeCode');
				});
	    	}
	    });
	    $("#btn_assoentity").on("click", function (event) {
	    	//关联实体属性选择
	    	var id=$('#modelID').val();
    		$.htextend.openDlg("关联属性","/metadata/model/page/asso_attribute?id="+id,2);
	    });
	    $("#btn_pub_attribute").on("click", function (event) {
    		//发布为公共属性
	    	var row=$.htgrid.getSelection('attribTable');
	    	if(row&&row.length>0) {
	    		$.htextend.ajax("/metadata/model/model/pubatt/"+$('#modelID').val()+"?attribute="+row[0].attributeCode,"post",{});
	    	}
	    });
	    $("#btn_copy_attribute").on("click", function (event) {
    		$.htextend.openDlg("拷贝属性","/metadata/model/page/attribute_copy",3);
	    });
	    $("#btn_move_attribute").on("click", function (event) {
	    	var row=$.htgrid.getSelection('attribTable');
	    	if(row&&row.length==1) {
	    		$.htextend.input("移动到序号后，0最前",function(index) {
	    			//debugger;
	    			if(eval(index)) {
	    				var from=$('#attribTable',context).bootstrapTable('getIndex',{key:'attributeCode',value:row[0].attributeCode});
	    				$('#attribTable',context).bootstrapTable('moveRow',{from:from,to:index});
	    			}
	    		});
	    	}	    	
	    });
	    $("#chk_showAll").on("click", function (event) {
	    	showAttribute($(this).is(':checked'));
	    });
		
	    function showAttribute(isAll) {
	    	//debugger;
	    	if(isAll) {
	    		$('#attribTable').bootstrapTable('getHiddenRows',true);
	    	}
	    	else {
		    	var data=$.htgrid.getData('attribTable');
		    	for(var i=0;i<data.length;i++) {
		    		if(data[i].attributeType=='log')
		    			$('#attribTable').bootstrapTable('hideRow',{uniqueId:data[i].attributeCode});
		    	}
	    	}
	    }
		init();

	});
