	$(function(){
		var context=$.htextend.getcontext();
		var attribdata=[];
		var models=[[{models}]];
		$.htgrid.init('attribTable',{
			data : attribdata,
			height: 300,
			uniqueId: "attributeCode", //每一行的唯一标识，一般为主键列
            pagination: true,
            sidePagination: "client",           // 分页方式：client客户端分页，server服务端分页（*）
            pageNumber: 1,                       // 初始化加载第一页，默认第一页
            pageSize: 10,                       // 每页的记录行数（*）
            paginationHAlign: 'left',
			columns: [
				{field : 'sel',radio:true}, 
				{field : 'attributeCode',title : '编码',width : 120	}, 
				{field : 'attributeName',title : '名称',width : 120},
				{field : 'attributeType',title : '类型',width:'80',cellStyle:function(value, row, index){
					if(value=='normal')
						return {classes:''};
					else if(value=='key')
						return {classes:'bg-red'};
					else if(value=='log')
						return {classes:'bg-yellow'};
					else
						return {classes:'bg-aqua'};
				} },
				{field : 'valueClass',title : '值类型',width :'80',extmap:'valueClass',cellStyle:function(value, row, index){
					if(value=='entity')
						return {classes:'bg-yellow'};
					else if(value=='extenum')
						return {classes:'bg-aqua'};
					else if(value=='extmap')
						return {classes:'bg-olive'};
					else
							return {classes:''};
				} },
				{field : 'isNull',title : '可空',width:'80',extmap:'boolType',cellStyle:function(value, row, index){
					if(eval(value))
						return {classes:'bg-aqua'};
					else
						return {classes:''};
				} },
				{field : 'sourceModel',title : '来源实体',width : 100},
				{field : 'enumDefine',title : '来源枚举',width : 100},
				{field : 'mapDefine',title : '来源映射',width : 100},
				{field : 'sourceAttribute',title : '来源属性',width : 120},
				{field : 'typeDefine',title : '类型定义',width : 80},
				{field : 'dataType',title : '数据类型',width : 80,extmap:'dataType'},
				{field : 'dataLength',title : '长度',width : 80},
				{field : 'dataScale',title : '精度',width : 80},
				{field : 'defaultValue',title : '缺省值',width:'80'},
				{field : 'isSystem',title : '系统',width : 80,extmap:'boolType'}
			]
		});
		init();
		function init() {
			if($('#parentModel').val()!='') {
				//如果有父实体，模型类型=实体
				$("#modelType").setDisable();
			}
		}
		
		$("#modelType").change(function () {  
			changeModelType($(this).val());
		});
		
		function changeModelType(value) {
			//debugger;
			$('#baseModel').val("");
			$('#tableName').val("");
			if(value==0||value==4) {//BaseModel
				$('#baseModel').setDisable();
				$('#tableName').setDisable();
			}
			else if(value==1){//Entity
				$('#baseModel').setEnable();
				$('#tableName').setEnable();
			}
		}
	    $("#btn_model_save").on("click", function (event) {
	    	var data=$.htgrid.getData('attribTable');
	    	if(data)
	    		$('#attributeList').val(JSON.stringify(data));
	        $.htextend.save(context,function(){
	        	$.htmenu.getSubMenu();
	        	$.htextend.close();
	        });
	    });
	    $("#btn_model_close").on("click", function (event) {
	        $.htextend.close();
	    });
	    $("#btn_addline").on("click", function (event) {
	    	$.htextend.openDlg("增加属性","/metadata/model/page/attribute_add",3);
	    });
	    $("#btn_editline").on("click", function (event) {
	    	//debugger;
	    	var row=$.htgrid.getSelection('attribTable');
	    		
	    	//alert('data='+JSON.stringify(row[0]));
	    	if(row&&row.length>0) {
		    	if(eval(row[0].isSystem)) {
		    		$.htextend.showError("系统属性不能修改");
		    		return;
		    	}
	    		var data=encodeURIComponent(JSON.stringify(row[0]));
	    		$.htextend.openDlg("编辑属性","/metadata/model/page/attribute_update?data="+data,3);
	    	}
	    });
	    $("#btn_deleteline").on("click", function (event) {
	    	var row=$.htgrid.getSelection('attribTable');
	    	if(row&&row.length>0) {
		    	if(eval(row[0].isSystem)) {
		    		$.htextend.showError("系统属性不能删除");
		    		return;
		    	}
				$.htextend.confirm('提示',"要删除记录吗？", function(index){
					$.htgrid.removeSelection('attribTable','attributeCode');
				});
	    	}
	    });
	    $("#btn_copy_attribute").on("click", function (event) {
    		$.htextend.openDlg("拷贝属性","/metadata/model/page/attribute_copy",3);
	    });
		
	    $("#btn_model_copy").on("click", function (event) {
    		$.htextend.openDlg("复制模型","/metadata/model/page/model_copy",2);
	    });
	    
		context.data('selectFinish',function(row) {
			$('#modelCode',context).val(row.modelCode);
			$('#modelName',context).val(row.modelName);
			$('#modelType',context).val(row.modelType);
			$('#baseModel',context).val(row.baseModel);
			$('#attributeList',context).val(row.attributeList);
			var data=JSON.parse(row.attributeList);
			var data2=[];
			for(var i=0;i<data.length;i++) {
				var row=data[i];
				if(row.valueClass=='entity') {
					if(models.indexOf(row.sourceModel)==-1)
						continue;
				}
				
			}
			$('#attribTable',context).bootstrapTable('load',);
		});
	});
