/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.base.web;

import htsoft.platform.base.component.BaseDto;
import htsoft.platform.base.component.BaseService;
import htsoft.platform.base.component.ConditionItem;
import htsoft.platform.base.component.HtException;
import htsoft.platform.base.component.HtSqlQuery;
import htsoft.platform.base.component.PageInfo;
import htsoft.platform.base.component.PageList;
import htsoft.platform.base.utility.ReflectionUtils;
import htsoft.platform.base.utility.StringUtils;
import htsoft.platform.base.web.ActionResult;
import htsoft.platform.base.web.ActionResultStatus;
import htsoft.platform.base.web.PageParams;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;

@Controller
public class BaseController {
    protected <T1> void fillEditData(BaseService service, long id, Class<T1> c, Model model) throws HtException {
        T1 dto = service.findDtoById(c, Long.valueOf(id));
        if (dto == null) {
            throw new HtException("\u5b9e\u4f53\u672a\u627e\u5230");
        }
        model.addAttribute("data", dto);
    }

    protected <T1> ActionResult findByID(BaseService baseService, Class<T1> classz, long id) throws HtException {
        ActionResult result = new ActionResult();
        T1 dto = baseService.findDtoById(classz, Long.valueOf(id));
        result.setStatusCode(ActionResultStatus.SUCCESS);
        result.setMessage("\u6210\u529f");
        result.setData(dto);
        return result;
    }

    protected ActionResult findList(BaseService baseService, Class classz, HtSqlQuery query, PageParams params) throws HtException {
        if (StringUtils.isNotBlank((CharSequence)params.getSortname())) {
            query.setOrderByStr(params.getSortname() + " " + params.getSortorder());
        } else {
            query.setOrderByStr("CreateTime Desc");
        }
        if (params.getCondition() != null) {
            for (String item : params.getCondition()) {
                query.addAndCondition(new ConditionItem(item));
            }
        }
        ActionResult result = new ActionResult();
        if (params.getPagesize() > 0) {
            PageInfo pi = new PageInfo(params.getPage(), params.getPagesize());
            PageList list = baseService.findAllPage(classz, query, pi);
            result.setData(list);
            result.setTotal(list.getPageInfo().getPageCount());
        } else {
            List list = baseService.findAll(classz, query);
            result.setData(list);
            result.setTotal(list.size());
        }
        result.setStatusCode(ActionResultStatus.SUCCESS);
        result.setMessage("\u6210\u529f");
        return result;
    }

    protected ActionResult findList(BaseService baseService, Class classz, HtSqlQuery query) throws HtException {
        ActionResult result = new ActionResult();
        List list = baseService.findAll(classz, query);
        result.setStatusCode(ActionResultStatus.SUCCESS);
        result.setMessage("\u6210\u529f");
        result.setData(list);
        result.setTotal(list.size());
        return result;
    }

    protected ActionResult add(BaseService baseService, BaseDto dto) throws HtException {
        ActionResult result = new ActionResult();
        Serializable id = baseService.addDto(dto);
        result.setMessage("\u6210\u529f");
        result.setData(id);
        return result;
    }

    protected ActionResult update(BaseService baseService, BaseDto dto) throws HtException {
        ActionResult result = new ActionResult();
        baseService.updateDto(dto);
        result.setMessage("\u6210\u529f");
        return result;
    }

    protected ActionResult delete(BaseService baseService, Object id) throws HtException {
        ActionResult result = new ActionResult();
        baseService.deleteById((Serializable)id);
        result.setMessage("\u6210\u529f");
        return result;
    }

    protected ActionResult batchProcess(String methodName, String op, Object[] objlist, Object ... args) throws HtException {
        ActionResult res = new ActionResult();
        ArrayList plist = new ArrayList();
        Object[] pvlist = new Object[args.length + 1];
        plist.add(objlist[0].getClass());
        for (int i = 0; i < args.length; ++i) {
            plist.add(args[i].getClass());
            pvlist[i + 1] = args[i];
        }
        Method method = ReflectionUtils.getDeclaredMethod(this, methodName, plist.toArray(new Class[plist.size()]));
        if (method == null) {
            throw new HtException("\u65b9\u6cd5" + methodName + "\u672a\u627e\u5230");
        }
        int errs = 0;
        ReflectionUtils.makeAccessible(method);
        for (Object obj : objlist) {
            try {
                pvlist[0] = obj;
                ReflectionUtils.invokeMethod(method, this, pvlist);
            }
            catch (Exception ex) {
                ++errs;
                res.getErrorMessageList().add(ex.getMessage());
            }
        }
        if (objlist.length > errs) {
            res.setStatusCode(ActionResultStatus.SUCCESS);
        } else {
            res.setStatusCode(ActionResultStatus.FAILURE);
        }
        StringBuilder mes = new StringBuilder();
        mes.append(op + "\u6210\u529f" + (objlist.length - errs) + ",\u5931\u8d25" + errs);
        res.setMessage(mes.toString());
        return res;
    }
}

