/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.base.utility;

import htsoft.platform.base.component.HtException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;

public class ReflectionUtils {
    public static Method getDeclaredMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod(methodName, parameterTypes);
                return method;
            }
            catch (Exception e) {
                continue;
            }
        }
        return null;
    }

    public static Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
        Method method = ReflectionUtils.getDeclaredMethod(object, methodName, parameterTypes);
        method.setAccessible(true);
        try {
            if (null != method) {
                return method.invoke(object, parameters);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) throws HtException {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new HtException("cannot access method:" + method.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new HtException("method parameter error:" + method.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new HtException("reflect exception:" + method.getName(), e);
        }
    }

    public static Field[] getAllFields(Class clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    public static Field getDeclaredField(Object object, String fieldName) {
        Object field = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                for (Field f : clazz.getDeclaredFields()) {
                    if (!f.getName().equalsIgnoreCase(fieldName)) continue;
                    return f;
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public static Field getDeclaredField(Object object, Class interfaceClass) {
        Class<?> clazz = object.getClass();
        for (Field f : clazz.getDeclaredFields()) {
            if (!interfaceClass.isAssignableFrom(f.getType())) continue;
            return f;
        }
        return null;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) throws HtException {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        if (field != null) {
            ReflectionUtils.setFieldValue(object, field, value);
        }
    }

    public static void setFieldValue(Object object, Field field, Object value) throws HtException {
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Object getFieldValue(Object object, String fieldName) throws HtException {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        if (field == null) {
            throw new HtException("\u7c7b" + object.getClass().getName() + "\u672a\u627e\u5230\u5b57\u6bb5" + fieldName);
        }
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getFieldValue(Object object, Field field) throws HtException {
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || (!Modifier.isPublic(field.getDeclaringClass().getModifiers()) || Modifier.isFinal(field.getModifiers())) && !field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers()) && !method.isAccessible()) {
            method.setAccessible(true);
        }
    }

    public static String fieldsEqual(Object obj1, Object obj2, String fieldlist, String namelist) throws HtException {
        String[] flist = fieldlist.split(",");
        String[] nlist = null;
        String res = "";
        if (namelist != null) {
            nlist = namelist.split(",");
        }
        if (nlist.length != flist.length) {
            throw new HtException("fieldlist\u548cnamelist\u5143\u7d20\u957f\u5ea6\u4e0d\u540c");
        }
        int i = 0;
        for (String field : flist) {
            Object v1 = ReflectionUtils.getFieldValue(obj1, field);
            Object v2 = ReflectionUtils.getFieldValue(obj2, field);
            if (v1 == null) {
                if (v2 != null) {
                    res = res + "," + (nlist != null ? nlist[i] : flist[i]);
                }
            } else if (v1 instanceof Comparable) {
                if (((Comparable)v1).compareTo(v2) != 0) {
                    res = res + "," + (nlist != null ? nlist[i] : flist[i]);
                }
            } else if (!v1.equals(v2)) {
                res = res + "," + (nlist != null ? nlist[i] : flist[i]);
            }
            ++i;
        }
        if (res.length() == 0) {
            return null;
        }
        return res.substring(1);
    }
}

