/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.base.utility;

public class IdWorker {
    private final long startTime = 1514736000000L;
    private long workerIdBits = 5L;
    private long datacenterIdBits = 5L;
    private long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.workerIdBits;
    private long maxDatacenterId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.datacenterIdBits;
    private long sequenceBits;
    private long workerIdLeftShift = this.sequenceBits = 12L;
    private long datacenterIdLeftShift = this.workerIdBits + this.workerIdLeftShift;
    private long timestampLeftShift = this.datacenterIdBits + this.datacenterIdLeftShift;
    private long sequenceMask = 0xFFFFFFFF ^ -1 << (int)this.sequenceBits;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public IdWorker(long workerId, long datacenterId) {
        if (workerId < 0L || workerId > this.maxWorkerId) {
            throw new IllegalArgumentException(String.format("workerId[%d] is less than 0 or greater than maxWorkerId[%d].", workerId, this.maxWorkerId));
        }
        if (datacenterId < 0L || datacenterId > this.maxDatacenterId) {
            throw new IllegalArgumentException(String.format("datacenterId[%d] is less than 0 or greater than maxDatacenterId[%d].", datacenterId, this.maxDatacenterId));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (timestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis();
                this.sequence = 0L;
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1514736000000L << (int)this.timestampLeftShift | this.datacenterId << (int)this.datacenterIdLeftShift | this.workerId << (int)this.workerIdLeftShift | this.sequence;
    }

    protected long tilNextMillis() {
        long timestamp = this.timeGen();
        if (timestamp <= this.lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
    }
}

