/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.base.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    private static int BUFFERSIZE = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String[] paths, String fileName) {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(fileName));
            for (String filePath : paths) {
                File file = new File(filePath);
                String relativePath = file.getName();
                if (file.isDirectory()) {
                    relativePath = relativePath + File.separator;
                }
                FileUtils.zipFile(file, relativePath, zos);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(File file, String relativePath, ZipOutputStream zos) {
        InputStream is = null;
        try {
            if (!file.isDirectory()) {
                ZipEntry zp = new ZipEntry(relativePath);
                zos.putNextEntry(zp);
                is = new FileInputStream(file);
                byte[] buffer = new byte[BUFFERSIZE];
                int length = 0;
                while ((length = is.read(buffer)) >= 0) {
                    zos.write(buffer, 0, length);
                }
                zos.flush();
                zos.closeEntry();
            } else {
                String tempPath = null;
                for (File f : file.listFiles()) {
                    tempPath = relativePath + f.getName();
                    if (f.isDirectory()) {
                        tempPath = tempPath + File.separator;
                    }
                    FileUtils.zipFile(f, tempPath, zos);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String fileName, String path) {
        FileOutputStream fos = null;
        InputStream is = null;
        try {
            ZipFile zf = new ZipFile(new File(fileName));
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry zn = en.nextElement();
                if (zn.isDirectory()) continue;
                is = zf.getInputStream(zn);
                File f = new File(path + zn.getName());
                File file = f.getParentFile();
                file.mkdirs();
                fos = new FileOutputStream(path + zn.getName());
                int len = 0;
                byte[] bufer = new byte[BUFFERSIZE];
                while (-1 != (len = is.read(bufer))) {
                    fos.write(bufer, 0, len);
                }
                fos.close();
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean delFile(File file) {
        File[] files;
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        for (File f : files = file.listFiles()) {
            FileUtils.delFile(f);
        }
        return file.delete();
    }

    public static boolean delFile(String filename) {
        File file = new File(filename);
        return FileUtils.delFile(file);
    }
}

