/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.base.utility;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    public static Date getDate(Date date) {
        String sdata = DateUtils.formatDate("yyyy-MM-dd", date);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date2 = new Date();
        try {
            date2 = dateFormat.parse(sdata);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return date2;
    }

    public static Date getToday() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        try {
            date = dateFormat.parse(dateFormat.format(new Date()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static Date getOffset(Date date, int days, int hours, int minutes, int seconds) {
        Calendar cal_time = Calendar.getInstance();
        cal_time.setTime(date);
        if (days != 0) {
            cal_time.add(5, days);
        }
        if (hours != 0) {
            cal_time.add(10, hours);
        }
        if (minutes != 0) {
            cal_time.add(12, minutes);
        }
        if (seconds != 0) {
            cal_time.add(13, seconds);
        }
        return cal_time.getTime();
    }

    public static String formatToday() {
        return DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
    }

    public static String formatTodayTime() {
        return DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String formatDate(String pattern, Date date) {
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static String formatDate(Date date) {
        return DateUtils.formatDate(date, "yyyy-MM-dd");
    }

    public static String formatDate(Date date, Object ... pattern) {
        if (date == null) {
            return null;
        }
        String formatDate = null;
        formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
        return formatDate;
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getTime() {
        return DateUtils.formatDate(new Date(), "HH:mm:ss");
    }

    public static String getDateTime() {
        return DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getDateTime(Date date) {
        return DateUtils.formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getYear() {
        return DateUtils.formatDate(new Date(), "yyyy");
    }

    public static String getMonth() {
        return DateUtils.formatDate(new Date(), "MM");
    }

    public static String getDay() {
        return DateUtils.formatDate(new Date(), "dd");
    }

    public static String getWeek() {
        return DateUtils.formatDate(new Date(), "E");
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static long pastDays(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 86400000L;
    }

    public static String toStr() {
        return DateUtils.toStr(new Date());
    }

    public static String toStr(Date date) {
        return DateUtils.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static long pastHour(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 60000L;
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return (day > 0L ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static double getDaysBetweenDate(Date before, Date after) {
        return DateUtils.getMillisecBetweenDate(before, after) / 86400000L;
    }

    public static long getMillisecBetweenDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return afterTime - beforeTime;
    }

    public static int getSecondBetweenDate(Date startTime, Date endTime) {
        long a = startTime.getTime();
        long b = endTime.getTime();
        int c = (int)((a - b) / 1000L);
        return c;
    }

    public static String getFirstDayOfMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.add(2, 0);
        c.set(5, 1);
        String first = format.format(c.getTime());
        return first;
    }

    public static Timestamp getTimestamp() {
        return new Timestamp(new Date().getTime());
    }

    public static double getDoubleType(String dateString) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = sdf.parse(dateString);
        return date.getTime();
    }

    public static String getPassHours(String startTime, int hours) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = df.parse(startTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, calendar.get(11) + hours);
        return df.format(calendar.getTime());
    }

    public static String getAddDate(String time, int days) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = dateFormat.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Date newDate = DateUtils.addDate(date, days);
        String st = dateFormat.format(newDate);
        return st;
    }

    public static Date addDate(Date date, long day) {
        long time = date.getTime();
        day = day * 24L * 60L * 60L * 1000L;
        return new Date(time += day);
    }

    public static Date getMoment(int hour, int min, int sec, int mill) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, hour);
        calendar.set(12, min);
        calendar.set(13, sec);
        calendar.set(14, mill);
        return calendar.getTime();
    }

    public static Date getMoment(int year, int month, int day, int hour, int min, int sec, int mill) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, min);
        calendar.set(13, sec);
        calendar.set(14, mill);
        return calendar.getTime();
    }
}

