/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.base.component;

import htsoft.platform.base.component.BaseDto;
import htsoft.platform.base.component.BaseEntity;
import htsoft.platform.base.component.BaseMybatisMapper;
import htsoft.platform.base.component.BaseRowMapper;
import htsoft.platform.base.component.DtoStatus;
import htsoft.platform.base.component.HtDbType;
import htsoft.platform.base.component.HtException;
import htsoft.platform.base.component.HtSqlQuery;
import htsoft.platform.base.component.PageInfo;
import htsoft.platform.base.component.PageList;
import htsoft.platform.base.component.PersistenceService;
import htsoft.platform.base.utility.IdService;
import htsoft.platform.base.utility.ReflectionUtils;
import htsoft.platform.base.utility.UserRequest;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.persistence.Id;
import javax.persistence.Table;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

public class MyBatisServiceImpl<T extends BaseEntity, ID extends Serializable>
implements PersistenceService<T> {
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    private HtDbType dbtype;

    protected JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected BaseMybatisMapper<T> getDao() throws HtException {
        throw new HtException("\u670d\u52a1\u7c7b" + this.getClass().getName() + "\u672a\u5b9e\u73b0getDao()");
    }

    public Class<T> getEntityClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Serializable add(T entity) throws HtException {
        Field ctfield;
        Serializable id = this.setIdValue(entity);
        Field cufield = ReflectionUtils.getDeclaredField(entity, "CreateUserID");
        if (cufield != null && ReflectionUtils.getFieldValue(entity, "CreateUserID") == null && UserRequest.getCurrentUser() != null) {
            ReflectionUtils.setFieldValue(entity, "CreateUserID", (Object)UserRequest.getCurrentUser().getCurrentUserID());
        }
        if ((ctfield = ReflectionUtils.getDeclaredField(entity, "CreateTime")) != null) {
            ReflectionUtils.setFieldValue(entity, ctfield, (Object)new Date());
        }
        this.getDao().add(entity);
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(T entity) throws HtException {
        Field mtfield;
        Field mufield = ReflectionUtils.getDeclaredField(entity, "ModifyUserID");
        if (mufield != null && ReflectionUtils.getFieldValue(entity, "ModifyUserID") == null && UserRequest.getCurrentUser() != null) {
            ReflectionUtils.setFieldValue(entity, "ModifyUserID", (Object)UserRequest.getCurrentUser().getCurrentUserID());
        }
        if ((mtfield = ReflectionUtils.getDeclaredField(entity, "ModifyTime")) != null) {
            ReflectionUtils.setFieldValue(entity, mtfield, (Object)new Date());
        }
        this.getDao().update(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(T entity) throws HtException {
        this.getDao().deleteById((Serializable)this.getIdValue(entity));
    }

    @Override
    public void deleteById(Serializable id) throws HtException {
        Object entity = this.findById(id);
        if (entity == null) {
            throw new HtException("\u5bf9\u8c61\u6ca1\u6709\u627e\u5230\uff0cid=" + id.toString());
        }
        this.delete((T)entity);
    }

    @Override
    public T findById(Serializable id) throws HtException {
        return (T)((BaseEntity)this.getDao().findById(id));
    }

    protected Object getIdValue(Object dto) throws HtException {
        Field idfield = this.getIdField(this.getEntityClass());
        if (idfield == null) {
            throw new HtException("\u5b9e\u4f53\u7c7b" + this.getEntityClass().getName() + "\u6ca1\u6709\u5b9a\u4e49ID\u5b57\u6bb5");
        }
        Object id = ReflectionUtils.getFieldValue(dto, idfield.getName());
        if (id == null) {
            throw new HtException("\u7c7b\u578b" + this.getEntityClass().getName() + "\u6ca1\u6709\u5b57\u6bb5\u503c" + idfield.getName());
        }
        return id;
    }

    private Serializable setIdValue(T entity) throws HtException {
        Field idfield = this.getIdField(this.getEntityClass());
        if (idfield == null) {
            throw new HtException("\u5b9e\u4f53\u7c7b" + this.getEntityClass().getName() + "\u6ca1\u6709\u5b9a\u4e49ID\u5b57\u6bb5");
        }
        Object id = ReflectionUtils.getFieldValue(entity, idfield.getName());
        if (id == null || (Long)id == 0L) {
            id = IdService.newId();
            ReflectionUtils.setFieldValue(entity, idfield, id);
        }
        return (Serializable)id;
    }

    protected Field getIdField(Class c) {
        for (Field field : c.getDeclaredFields()) {
            boolean fieldHasAnno = field.isAnnotationPresent(Id.class);
            if (!fieldHasAnno) continue;
            return field;
        }
        return null;
    }

    @Override
    public HtDbType getDbType() throws HtException {
        if (this.dbtype != null && this.dbtype != HtDbType.None) {
            return this.dbtype;
        }
        try {
            Connection conn = this.jdbcTemplate.getDataSource().getConnection();
            DatabaseMetaData meta = conn.getMetaData();
            conn.close();
            String type = meta.getDatabaseProductName();
            if (type.compareTo("SQLServer") == 0) {
                this.dbtype = HtDbType.Sqlserver;
            } else if (type.compareTo("MySQL") == 0) {
                this.dbtype = HtDbType.MySql;
            } else if (type.compareTo("Oracle") == 0) {
                this.dbtype = HtDbType.Oracle;
            } else {
                throw new HtException("getDbType\u9519\u8bef\uff0c\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b" + type);
            }
            return this.dbtype;
        }
        catch (SQLException e) {
            throw new HtException("getDbType\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0" + e.getMessage());
        }
    }

    public Serializable addDto(BaseDto dto) throws HtException {
        BaseEntity entity;
        try {
            if (dto.getClass() == this.getEntityClass()) {
                entity = (BaseEntity)dto;
            } else {
                entity = (BaseEntity)this.getEntityClass().newInstance();
                BeanUtils.copyProperties((Object)dto, (Object)entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("add\u6784\u9020\u5b9e\u4f53\u7c7b\u9519\u8bef\uff1a" + this.getEntityClass().getName(), e);
        }
        return this.add((T)entity);
    }

    public void updateDto(BaseDto dto) throws HtException {
        Serializable id = (Serializable)this.getIdValue(dto);
        BaseEntity entity = (BaseEntity)this.getDao().findById(id);
        if (entity == null) {
            throw new HtException("\u5b9e\u4f53" + this.getEntityClass().getName() + "\u672a\u627e\u5230\uff0cID:" + id);
        }
        try {
            BeanUtils.copyProperties((Object)dto, (Object)entity);
        }
        catch (BeansException e) {
            e.printStackTrace();
            throw new HtException("update\u590d\u5236\u5b9e\u4f53\u7c7b\u9519\u8bef\uff1a" + this.getEntityClass().getName(), (Exception)((Object)e));
        }
        this.update((T)entity);
    }

    public void deleteDto(BaseDto dto) throws HtException {
        Serializable id = (Serializable)this.getIdValue(dto);
        BaseEntity entity = (BaseEntity)this.getDao().findById(id);
        if (entity == null) {
            throw new HtException("\u5b9e\u4f53" + this.getEntityClass().getName() + "\u672a\u627e\u5230\uff0cID:" + id);
        }
        this.delete((T)entity);
    }

    public void saveDto(BaseDto dto) throws HtException {
        if (dto.getDtoStatus() == DtoStatus.Add.ordinal()) {
            this.addDto(dto);
        } else if (dto.getDtoStatus() == DtoStatus.Update.ordinal()) {
            this.updateDto(dto);
        } else if (dto.getDtoStatus() == DtoStatus.Delete.ordinal()) {
            this.deleteDto(dto);
        }
    }

    @Override
    public <T1> T1 findDtoById(Class<T1> c, Serializable id) throws HtException {
        Object source;
        try {
            source = this.findById(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("BaseService.findDtoById\u67e5\u627e\u9519\u8bef,id=" + id, e);
        }
        if (source == null) {
            return null;
        }
        if (c == this.getEntityClass()) {
            return (T1)source;
        }
        try {
            T1 target = c.newInstance();
            BeanUtils.copyProperties((Object)source, target);
            return target;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new HtException("BaseService.findDtoById\u4e2d\u6784\u9020\u5b9e\u4f53\u7c7b\u9519\u8bef\uff1a" + this.getEntityClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new HtException("BaseService.findDtoById\u4e2d\u6784\u9020\u5b9e\u4f53\u7c7b\u9519\u8bef\uff1a" + this.getEntityClass().getName(), e);
        }
    }

    @Override
    public <T1> List<T1> findAll(Class<T1> c, HtSqlQuery query) throws HtException {
        try {
            List reslist = this.jdbcTemplate.query(query.getSql(), new BaseRowMapper<T1>(c));
            return reslist;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("BaseService.findAll(Class<BaseDto> c, HtSqlQuery query)\u9519\u8bef", e);
        }
    }

    @Override
    public <T1> PageList<T1> findAllPage(Class<T1> c, HtSqlQuery query, PageInfo pi) throws HtException {
        try {
            String csql = query.getCountSql();
            int count = (Integer)this.jdbcTemplate.queryForObject(csql, Integer.class);
            String sql = query.GetPageSql(pi);
            List reslist = this.jdbcTemplate.query(sql, new BaseRowMapper<T1>(c));
            PageList reslist2 = new PageList(reslist);
            reslist2.setPageInfo(pi);
            reslist2.getPageInfo().setPageCount(count);
            return reslist2;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("BaseService.findAllPage(Class<BaseDto> c, HtSqlQuery query)\u9519\u8bef", e);
        }
    }

    @Override
    public <T1> T1 findSingle(Class<T1> c, HtSqlQuery query) throws HtException {
        try {
            Object obj = this.jdbcTemplate.queryForObject(query.getSingleLineSql(), new BaseRowMapper<T1>(c));
            return (T1)obj;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("BaseService.findSingle(HtSqlQuery query)\u9519\u8bef", e);
        }
    }

    @Override
    public <T1> T1 findViewById(String view, Class<T1> c, Serializable id) throws HtException {
        Field idfield = this.getIdField(this.getEntityClass());
        HtSqlQuery query = this.createQuery(view).addAndCondition(idfield.getName(), id);
        return this.findSingle(c, query);
    }

    @Override
    public <T1> T1 getObject(Class<T1> c, HtSqlQuery query) throws HtException {
        try {
            Object obj = this.jdbcTemplate.queryForObject(query.getSingleLineSql(), c);
            return (T1)obj;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("BaseService.getObject(HtSqlQuery query)\u9519\u8bef", e);
        }
    }

    @Override
    public <T1> List<T1> getObjectList(Class<T1> c, HtSqlQuery query) throws HtException {
        try {
            List list = this.jdbcTemplate.queryForList(query.getSql(), c);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("BaseService.getObjectList(HtSqlQuery query)\u9519\u8bef", e);
        }
    }

    @Override
    public int findCount(HtSqlQuery query) throws HtException {
        return (Integer)this.jdbcTemplate.queryForObject(query.getCountSql(), Integer.TYPE);
    }

    @Override
    public HtSqlQuery createQuery() throws HtException {
        return new HtSqlQuery(this.getDbType(), "*", this.getTablename());
    }

    @Override
    public HtSqlQuery createQuery(String tablename) throws HtException {
        return new HtSqlQuery(this.getDbType(), "*", tablename);
    }

    private String getTablename() throws HtException {
        Table t = this.getEntityClass().getAnnotation(Table.class);
        if (t == null) {
            throw new HtException("\u5b9e\u4f53\u7c7b" + this.getEntityClass().getName() + "\u672a\u8bbe\u7f6e@Table");
        }
        return t.name();
    }

    @Override
    public List<T> findAll() throws HtException {
        HtSqlQuery query = this.createQuery();
        List reslist = this.jdbcTemplate.query(query.getSql(), new BaseRowMapper<T>(this.getEntityClass()));
        return reslist;
    }

    @Override
    public long newId() throws HtException {
        return IdService.newId();
    }

    @Override
    public <T1> List<T1> findChildren(String view, Class<T1> c, Serializable id) throws HtException {
        Field idfield = this.getIdField(this.getEntityClass());
        HtSqlQuery query = this.createQuery(view).addAndCondition(idfield.getName(), id);
        return this.findAll(c, query);
    }

    @Override
    public void addList(List<T> entitylist) throws HtException {
        for (BaseEntity entity : entitylist) {
            Field ctfield;
            Serializable id = this.setIdValue(entity);
            Field cufield = ReflectionUtils.getDeclaredField((Object)entity, "CreateUserID");
            if (cufield != null && ReflectionUtils.getFieldValue((Object)entity, "CreateUserID") == null) {
                ReflectionUtils.setFieldValue((Object)entity, "CreateUserID", (Object)UserRequest.getCurrentUser().getCurrentUserID());
            }
            if ((ctfield = ReflectionUtils.getDeclaredField((Object)entity, "CreateTime")) != null) {
                ReflectionUtils.setFieldValue((Object)entity, ctfield, (Object)new Date());
            }
            this.getDao().add(entity);
        }
    }
}

