/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.base.component;

import htsoft.platform.base.component.BaseDto;
import htsoft.platform.base.component.BaseEntity;
import htsoft.platform.base.component.BaseJpaRepository;
import htsoft.platform.base.component.BaseRowMapper;
import htsoft.platform.base.component.CurrentUserInfo;
import htsoft.platform.base.component.DtoStatus;
import htsoft.platform.base.component.HtDbType;
import htsoft.platform.base.component.HtException;
import htsoft.platform.base.component.HtSqlQuery;
import htsoft.platform.base.component.PageInfo;
import htsoft.platform.base.component.PageList;
import htsoft.platform.base.component.PersistenceService;
import htsoft.platform.base.utility.IdService;
import htsoft.platform.base.utility.ReflectionUtils;
import htsoft.platform.base.utility.UserRequest;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.persistence.Id;
import javax.persistence.Table;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={HtException.class})
public class JpaServiceImpl<T extends BaseEntity, ID extends Serializable>
implements PersistenceService<T> {
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    private HtDbType dbtype;

    protected JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected BaseJpaRepository<T, ID> getDao() throws HtException {
        throw new HtException("\u670d\u52a1\u7c7b" + this.getClass().getName() + "\u672a\u8bbe\u7f6ebaseRepository");
    }

    public Class<T> getEntityClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public Serializable add(T entity) throws HtException {
        Field ctfield;
        Serializable id = this.setIdValue(entity);
        Field cufield = ReflectionUtils.getDeclaredField(entity, "CreateUserID");
        CurrentUserInfo ui = UserRequest.getCurrentUser();
        if (ui != null && cufield != null && ReflectionUtils.getFieldValue(entity, "CreateUserID") == null) {
            ReflectionUtils.setFieldValue(entity, "CreateUserID", (Object)ui.getCurrentUserID());
        }
        if ((ctfield = ReflectionUtils.getDeclaredField(entity, "CreateTime")) != null) {
            ReflectionUtils.setFieldValue(entity, ctfield, (Object)new Date());
        }
        this.getDao().add(entity);
        return id;
    }

    @Override
    public <T1 extends BaseDto> Serializable addDto(T1 dto) throws HtException {
        BaseEntity entity;
        try {
            if (dto.getClass() == this.getEntityClass()) {
                entity = (BaseEntity)dto;
            } else {
                entity = (BaseEntity)this.getEntityClass().newInstance();
                BeanUtils.copyProperties(dto, (Object)entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("add\u6784\u9020\u5b9e\u4f53\u7c7b\u9519\u8bef\uff1a" + this.getEntityClass().getName(), e);
        }
        Serializable id = this.add((T)entity);
        BeanUtils.copyProperties((Object)entity, dto);
        return id;
    }

    @Override
    public void update(T entity) throws HtException {
        Field mtfield;
        Field mufield = ReflectionUtils.getDeclaredField(entity, "ModifyUserID");
        CurrentUserInfo ui = UserRequest.getCurrentUser();
        if (ui != null && mufield != null && ReflectionUtils.getFieldValue(entity, "ModifyUserID") == null) {
            ReflectionUtils.setFieldValue(entity, "ModifyUserID", (Object)ui.getCurrentUserID());
        }
        if ((mtfield = ReflectionUtils.getDeclaredField(entity, "ModifyTime")) != null) {
            ReflectionUtils.setFieldValue(entity, mtfield, (Object)new Date());
        }
        this.getDao().update(entity);
    }

    @Override
    public <T1 extends BaseDto> void updateDto(T1 dto) throws HtException {
        Serializable id = (Serializable)this.getIdValue(dto);
        Object entity = this.findById(id);
        if (entity == null) {
            throw new HtException("\u5b9e\u4f53" + this.getEntityClass().getName() + "\u672a\u627e\u5230\uff0cID:" + id);
        }
        try {
            BeanUtils.copyProperties(dto, (Object)entity);
        }
        catch (BeansException e) {
            e.printStackTrace();
            throw new HtException("update\u590d\u5236\u5b9e\u4f53\u7c7b\u9519\u8bef\uff1a" + this.getEntityClass().getName(), (Exception)((Object)e));
        }
        this.update((T)entity);
    }

    @Override
    public void delete(T entity) throws HtException {
        if (entity == null) {
            throw new HtException("delete\u9519\u8bef\uff0c\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7c7b\u540d\uff1a" + this.getEntityClass().getName());
        }
        this.getDao().delete(entity);
    }

    @Override
    public void deleteById(Serializable id) throws HtException {
        Object entity = this.findById(id);
        if (entity == null) {
            throw new HtException("deleteById\u9519\u8bef\uff0c\u5bf9\u8c61\u6ca1\u6709\u627e\u5230\uff0c\u7c7b\u540d\uff1a" + this.getEntityClass().getName() + "\uff1bID=" + id.toString());
        }
        this.delete((T)entity);
    }

    @Override
    public <T1 extends BaseDto> void deleteDto(T1 dto) throws HtException {
        Serializable id = (Serializable)this.getIdValue(dto);
        this.deleteById(id);
    }

    @Override
    public <T1 extends BaseDto> void saveDto(T1 dto) throws HtException {
        if (dto.getDtoStatus() == DtoStatus.Add.ordinal()) {
            this.addDto(dto);
        } else if (dto.getDtoStatus() == DtoStatus.Update.ordinal()) {
            this.updateDto(dto);
        } else if (dto.getDtoStatus() == DtoStatus.Delete.ordinal()) {
            this.deleteDto(dto);
        }
    }

    protected Object getIdValue(BaseDto dto) throws HtException {
        Field idfield = this.getIdField(this.getEntityClass());
        if (idfield == null) {
            throw new HtException("\u5b9e\u4f53\u7c7b" + this.getEntityClass().getName() + "\u6ca1\u6709\u5b9a\u4e49ID\u5b57\u6bb5");
        }
        Object id = ReflectionUtils.getFieldValue((Object)dto, idfield.getName());
        if (id == null) {
            throw new HtException("\u7c7b\u578b" + this.getEntityClass().getName() + "\u6ca1\u6709\u5b57\u6bb5\u503c" + idfield.getName());
        }
        return id;
    }

    private Serializable setIdValue(T entity) throws HtException {
        Field idfield = this.getIdField(this.getEntityClass());
        if (idfield == null) {
            throw new HtException("\u5b9e\u4f53\u7c7b" + this.getEntityClass().getName() + "\u6ca1\u6709\u5b9a\u4e49ID\u5b57\u6bb5");
        }
        Object id = ReflectionUtils.getFieldValue(entity, idfield.getName());
        if (id == null || (Long)id == 0L) {
            id = IdService.newId();
            ReflectionUtils.setFieldValue(entity, idfield, id);
        }
        return (Serializable)id;
    }

    protected Field getIdField(Class c) {
        Field[] fieldArray = c.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            boolean fieldHasAnno = field.isAnnotationPresent(Id.class);
            if (fieldHasAnno) {
                return field;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public T findById(Serializable id) throws HtException {
        Optional entity = this.getDao().findById(id);
        if (entity.isPresent()) {
            return (T)((BaseEntity)entity.get());
        }
        return null;
    }

    @Override
    public <T1> T1 findDtoById(Class<T1> c, Serializable id) throws HtException {
        T1 target;
        Object source = this.findById(id);
        if (source == null) {
            return null;
        }
        if (c == this.getEntityClass()) {
            return (T1)source;
        }
        try {
            target = c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("findById\u4e2d\u6784\u9020\u5b9e\u4f53\u7c7b\u9519\u8bef\uff1a" + this.getEntityClass().getName(), e);
        }
        BeanUtils.copyProperties((Object)source, target);
        return target;
    }

    @Override
    public <T1> T1 findViewById(String view, Class<T1> c, Serializable id) throws HtException {
        Field idfield = this.getIdField(this.getEntityClass());
        HtSqlQuery query = this.createQuery(view).addAndCondition(idfield.getName(), id);
        return this.findSingle(c, query);
    }

    @Override
    public <T1> List<T1> findChildren(String view, Class<T1> c, Serializable id) throws HtException {
        Field idfield = this.getIdField(this.getEntityClass());
        HtSqlQuery query = this.createQuery(view).addAndCondition(idfield.getName(), id);
        return this.findAll(c, query);
    }

    @Override
    public <T1> T1 getObject(Class<T1> c, HtSqlQuery query) throws HtException {
        try {
            Object obj = this.getJdbcTemplate().queryForObject(query.getSingleLineSql(), c);
            return (T1)obj;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("getObject(HtSqlQuery query)\u9519\u8bef" + e.getMessage());
        }
    }

    @Override
    public <T1> List<T1> getObjectList(Class<T1> c, HtSqlQuery query) throws HtException {
        try {
            List list = this.getJdbcTemplate().queryForList(query.getSql(), c);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("getObjectList(HtSqlQuery query)\u9519\u8bef" + e.getMessage());
        }
    }

    @Override
    public <T1> T1 findSingle(Class<T1> c, HtSqlQuery query) throws HtException {
        try {
            Object obj = this.getJdbcTemplate().queryForObject(query.getSingleLineSql(), new BaseRowMapper<T1>(c));
            return (T1)obj;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("findSingle(HtSqlQuery query)\u9519\u8bef" + e.getMessage());
        }
    }

    @Override
    public <T1> List<T1> findAll(Class<T1> c, HtSqlQuery query) throws HtException {
        try {
            List reslist = this.getJdbcTemplate().query(query.getSql(), new BaseRowMapper<T1>(c));
            return reslist;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("findAll(Class<BaseDto> c, HtSqlQuery query)\u9519\u8bef" + e.getMessage());
        }
    }

    @Override
    public <T1> PageList<T1> findAllPage(Class<T1> c, HtSqlQuery query, PageInfo pi) throws HtException {
        try {
            String csql = query.getCountSql();
            int count = (Integer)this.getJdbcTemplate().queryForObject(csql, Integer.class);
            String sql = query.GetPageSql(pi);
            List reslist = this.getJdbcTemplate().query(sql, new BaseRowMapper<T1>(c));
            PageList reslist2 = new PageList(reslist);
            reslist2.setPageInfo(pi);
            reslist2.getPageInfo().setPageCount(count);
            return reslist2;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtException("findAllPage(Class<BaseDto> c, HtSqlQuery query)\u9519\u8bef:" + e.getMessage());
        }
    }

    @Override
    public HtDbType getDbType() throws HtException {
        if (this.dbtype != null && this.dbtype != HtDbType.None) {
            return this.dbtype;
        }
        try {
            Connection conn = this.getJdbcTemplate().getDataSource().getConnection();
            DatabaseMetaData meta = conn.getMetaData();
            conn.close();
            String type = meta.getDatabaseProductName();
            if (type.compareTo("SQLServer") == 0) {
                this.dbtype = HtDbType.Sqlserver;
            } else if (type.compareTo("MySQL") == 0) {
                this.dbtype = HtDbType.MySql;
            } else if (type.compareTo("Oracle") == 0) {
                this.dbtype = HtDbType.Oracle;
            } else {
                throw new HtException("getDbType\u9519\u8bef\uff0c\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b" + type);
            }
            return this.dbtype;
        }
        catch (SQLException e) {
            throw new HtException("getDbType\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0" + e.getMessage());
        }
    }

    @Override
    public int findCount(HtSqlQuery query) throws HtException {
        return (Integer)this.getJdbcTemplate().queryForObject(query.getCountSql(), Integer.TYPE);
    }

    @Override
    public HtSqlQuery createQuery() throws HtException {
        return new HtSqlQuery(this.getDbType(), "*", this.getTablename());
    }

    @Override
    public HtSqlQuery createQuery(String tablename) throws HtException {
        return new HtSqlQuery(this.getDbType(), "*", tablename);
    }

    private String getTablename() throws HtException {
        Table t = this.getEntityClass().getAnnotation(Table.class);
        if (t == null) {
            throw new HtException("\u5b9e\u4f53\u7c7b" + this.getEntityClass().getName() + "\u672a\u8bbe\u7f6e@Table");
        }
        return t.name();
    }

    @Override
    public List<T> findAll() throws HtException {
        HtSqlQuery query = this.createQuery();
        List reslist = this.getJdbcTemplate().query(query.getSql(), new BaseRowMapper<T>(this.getEntityClass()));
        return reslist;
    }

    @Override
    public long newId() throws HtException {
        return IdService.newId();
    }

    @Override
    public void addList(List<T> entitylist) throws HtException {
        for (BaseEntity entity : entitylist) {
            Field ctfield;
            Serializable id = this.setIdValue(entity);
            Field cufield = ReflectionUtils.getDeclaredField((Object)entity, "CreateUserID");
            if (cufield != null && ReflectionUtils.getFieldValue((Object)entity, "CreateUserID") == null) {
                ReflectionUtils.setFieldValue((Object)entity, "CreateUserID", (Object)UserRequest.getCurrentUser().getCurrentUserID());
            }
            if ((ctfield = ReflectionUtils.getDeclaredField((Object)entity, "CreateTime")) != null) {
                ReflectionUtils.setFieldValue((Object)entity, ctfield, (Object)new Date());
            }
            this.getDao().save(entity);
        }
        this.getDao().flush();
    }

    protected void validateExist(HtSqlQuery query, String title) throws HtException {
        this.validateExist(query, title, 0);
    }

    protected void validateExist(HtSqlQuery query, String title, int count) throws HtException {
        if (this.findCount(query) > count) {
            throw new HtException(title);
        }
    }

    protected void validateExist(T entity, String fieldlist, String title) throws HtException {
        this.validateExist(entity, fieldlist, title, 0);
    }

    protected void validateExist(T entity, String fieldlist, String title, int count) throws HtException {
        String[] list1 = fieldlist.split(",");
        HtSqlQuery query = this.createQuery();
        String[] stringArray = list1;
        int n = list1.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Object v = ReflectionUtils.getFieldValue(entity, s);
            query.addAndCondition(s, v);
            ++n2;
        }
        this.validateExist(query, title, count);
    }

    protected void validateNull(T entity, String fieldlist, String fieldnamelist) throws HtException {
        String[] list1 = fieldlist.split(",");
        String[] list2 = fieldnamelist.split(",");
        String namelist = "";
        int i = 0;
        String[] stringArray = list1;
        int n = list1.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Object v = ReflectionUtils.getFieldValue(entity, s);
            if (v == null) {
                namelist = String.valueOf(namelist) + list2[i] + ",";
            }
            ++i;
            ++n2;
        }
        if (namelist != "") {
            throw new HtException(String.valueOf(namelist.substring(0, namelist.length() - 1)) + " \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

