/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.base.component;

import htsoft.platform.base.component.ConditionItem;
import htsoft.platform.base.component.HtCondition;
import htsoft.platform.base.component.HtDbType;
import htsoft.platform.base.component.HtException;
import htsoft.platform.base.component.HtMySqlCondition;
import htsoft.platform.base.component.HtOracleCondition;
import htsoft.platform.base.component.HtSqlServerCondition;
import htsoft.platform.base.component.PageInfo;
import java.text.MessageFormat;

public class HtSqlQuery {
    private String selectStr;
    private String tableName;
    private String orderByStr;
    private HtCondition htcondition;
    private String nsql;
    private HtDbType dbtype;

    public HtSqlQuery(HtDbType dbtype) {
        this.dbtype = dbtype;
        this.htcondition = dbtype == HtDbType.MySql ? new HtMySqlCondition() : (dbtype == HtDbType.Oracle ? new HtOracleCondition() : new HtSqlServerCondition());
        this.nsql = null;
    }

    public HtSqlQuery(HtDbType dbtype, String selectStr, String tableName) {
        this(dbtype);
        this.setSelectStr(selectStr);
        this.setTableName(tableName);
    }

    public HtSqlQuery(HtDbType dbtype, String sql) {
        this(dbtype);
        this.nsql = sql;
    }

    public HtSqlQuery setSql(String sql) {
        this.nsql = sql;
        return this;
    }

    public String getSelectStr() throws HtException {
        if (this.selectStr != null && this.selectStr.toLowerCase().startsWith("select ")) {
            throw new HtException("SelectStr\u4e0d\u80fd\u5305\u542bselect");
        }
        return this.selectStr;
    }

    public HtSqlQuery setSelectStr(String selectStr) {
        this.selectStr = selectStr;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public HtSqlQuery setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String getOrderByStr() {
        return this.orderByStr;
    }

    public HtSqlQuery setOrderByStr(String orderByStr) {
        this.orderByStr = orderByStr;
        return this;
    }

    public HtSqlQuery addAndCondition(ConditionItem item) {
        this.htcondition.addAndCondition(item);
        return this;
    }

    public HtSqlQuery addAndCondition(String key, Object value) throws HtException {
        this.htcondition.addAndCondition(key, value);
        return this;
    }

    public HtSqlQuery addAndCondition(String key, String op, Object value) throws HtException {
        this.htcondition.addAndCondition(key, op, value);
        return this;
    }

    public HtSqlQuery addOrCondition(ConditionItem item) {
        this.htcondition.addOrCondition(item);
        return this;
    }

    public HtSqlQuery addOrCondition(String key, Object value) throws HtException {
        this.htcondition.addOrCondition(key, value);
        return this;
    }

    public HtSqlQuery addOrCondition(String key, String op, Object value) throws HtException {
        this.htcondition.addOrCondition(key, op, value);
        return this;
    }

    public String getSql() {
        return this.getSql(this.selectStr);
    }

    public String getSql(String selectStr) {
        String where;
        if (this.nsql != null) {
            return this.nsql;
        }
        String sel = "*";
        if (selectStr != null && selectStr != "") {
            sel = selectStr;
        }
        String order1 = "";
        if (this.orderByStr != null && this.orderByStr != "") {
            order1 = " order by " + this.orderByStr;
        }
        if ((where = this.htcondition.getCondition()) != null && where != "") {
            where = " where " + where;
        }
        String sql = MessageFormat.format("select {0} from {1} {2} {3}", sel, this.tableName, where, order1);
        return sql;
    }

    public String getCountSql() {
        String sql = this.getSql();
        return "select count(*) from (" + sql + ") a";
    }

    public String getSingleLineSql() throws HtException {
        StringBuffer sbBuffer = new StringBuffer();
        if (this.dbtype == HtDbType.Oracle) {
            return sbBuffer.append("select * from (").append(this.getSql()).append(") where rownum=1").toString();
        }
        if (this.dbtype == HtDbType.MySql) {
            return sbBuffer.append(this.getSql()).append(" limit 0,1").toString();
        }
        if (this.dbtype == HtDbType.Sqlserver) {
            return this.getSql("top 1 " + this.selectStr);
        }
        throw new HtException("getSingleLineSql\u9519\u8bef\uff0c\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
    }

    public String GetPageSql(PageInfo pi) throws HtException {
        String sel = "*";
        String where = "";
        String from = "";
        String order1 = "";
        int startIndex = (pi.pageNo - 1) * pi.pageSize;
        int endIndex = startIndex + pi.pageSize - 1;
        if (this.nsql != null) {
            from = "(" + this.nsql + ") tn";
        } else {
            if (this.selectStr != null && this.selectStr != "") {
                sel = this.selectStr;
            }
            if ((where = this.htcondition.getCondition()) != null && where != "") {
                where = " where " + where;
            }
            from = this.tableName;
        }
        if (this.orderByStr == null || this.orderByStr == "") {
            throw new HtException("HtSqlQuery\u672a\u8bbe\u7f6eorderbyStr");
        }
        order1 = this.orderByStr;
        if (this.dbtype == HtDbType.Sqlserver) {
            return this.GetPageSql_SqlServer(sel, from, where, order1, startIndex, endIndex);
        }
        if (this.dbtype == HtDbType.MySql) {
            return this.GetPageSql_MySql(sel, from, where, order1, startIndex, endIndex);
        }
        if (this.dbtype == HtDbType.Oracle) {
            return this.GetPageSql_Oracle(sel, from, where, order1, startIndex, endIndex);
        }
        throw new HtException("GetPageSql\u9519\u8bef\uff0c\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
    }

    private String GetPageSql_SqlServer(String sel, String from, String where, String orderby, int startIndex, int endIndex) {
        StringBuilder strSql = new StringBuilder();
        strSql.append("select * from (select row_number()over(order by " + orderby).append(")rownumber,").append(sel).append(" from ").append(from).append(where).append(" )a1 where rownumber between " + startIndex + " and " + endIndex);
        return strSql.toString();
    }

    private String GetPageSql_Oracle(String sel, String from, String where, String orderby, int startIndex, int endIndex) {
        StringBuilder strSql = new StringBuilder();
        strSql.append("select " + sel + " from (SELECT ROW_NUMBER() OVER (order by T." + orderby + ")AS MyRow, T.*  from " + from + " T ").append(where);
        strSql.append(" ) TT  WHERE TT.MyRow between " + startIndex + " and " + endIndex);
        return strSql.toString();
    }

    private String GetPageSql_MySql(String sel, String from, String where, String orderby, int startIndex, int endIndex) {
        StringBuilder strSql = new StringBuilder();
        strSql.append("select a.* from (select " + sel + " from " + from + " " + where + " order by " + orderby + ")a limit " + startIndex + "," + (endIndex - startIndex + 1));
        return strSql.toString();
    }

    public HtCondition getHtcondition() {
        return this.htcondition;
    }
}

