/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.base.component;

import com.alibaba.fastjson.JSON;
import htsoft.platform.base.component.ConditionItem;
import htsoft.platform.base.component.HtException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public abstract class HtCondition {
    private String condition = "";

    public HtCondition addAndCondition(ConditionItem item) {
        String cond = this.getItemCond(item);
        this.condition = this.condition == "" ? cond : this.condition + " and " + cond;
        return this;
    }

    public HtCondition addAndCondition(String key, Object value) throws HtException {
        return this.addAndCondition(new ConditionItem(key, value));
    }

    public HtCondition addAndCondition(String key, String op, Object value) throws HtException {
        return this.addAndCondition(new ConditionItem(key, op, value));
    }

    public HtCondition addOrCondition(ConditionItem item) {
        String cond = this.getItemCond(item);
        this.condition = this.condition == "" ? cond : this.condition + " or " + cond;
        return this;
    }

    public HtCondition addOrCondition(String key, Object value) throws HtException {
        return this.addOrCondition(new ConditionItem(key, value));
    }

    public HtCondition addOrCondition(String key, String op, Object value) throws HtException {
        return this.addOrCondition(new ConditionItem(key, op, value));
    }

    protected String getValue(ConditionItem item) {
        try {
            if (item.getOp().equals("in")) {
                return this.getInValue(item);
            }
            if (item.getOp().equals("between")) {
                return this.getBetweenValue(item);
            }
            if (item.getOp().equals("like")) {
                if (item.getValue() == null) {
                    return "'%'";
                }
                if (item.getValue().toString().contains("%")) {
                    return "'" + item.getValue() + "'";
                }
                return "'%" + item.getValue() + "%'";
            }
            Object value = item.getValue();
            if (value.getClass() == String.class) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    format.parse((String)value);
                }
                catch (ParseException e) {
                    return "'" + value + "'";
                }
                return this.getDateValue((String)value);
            }
            if (value.getClass() == Date.class || value.getClass() == Timestamp.class) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String value1 = format.format((Date)value);
                return this.getDateValue(value1);
            }
            return value.toString();
        }
        catch (Exception ex) {
            System.out.println("getValue\u9519\u8bef\uff1a" + item.toString());
            throw ex;
        }
    }

    protected String getDateValue(String value) {
        return "'" + value + "'";
    }

    protected String getInValue(ConditionItem item) {
        StringBuffer sb = new StringBuffer();
        Object value = item.getValue();
        if (value instanceof List) {
            List list = (List)value;
            sb.append("(");
            for (Object obj : list) {
                if (obj instanceof String) {
                    sb.append("'" + obj + "',");
                    continue;
                }
                sb.append(obj + ",");
            }
            String string2 = sb.substring(0, sb.length() - 1);
            string2 = string2 + ")";
            return string2;
        }
        if (value instanceof Object[]) {
            sb.append("(");
            for (Object obj : (Object[])value) {
                if (obj instanceof String) {
                    sb.append("'" + obj + "',");
                    continue;
                }
                sb.append(obj + ",");
            }
            String str = sb.substring(0, sb.length() - 1);
            str = str + ")";
            return str;
        }
        if (value.getClass().isArray()) {
            if (value instanceof int[]) {
                int[] varray = (int[])value;
                sb.append("(");
                for (int i : varray) {
                    sb.append(i + ",");
                }
                String string3 = sb.substring(0, sb.length() - 1);
                string3 = string3 + ")";
                return string3;
            }
            if (value instanceof long[]) {
                long[] varray = (long[])value;
                sb.append("(");
                for (long i : varray) {
                    sb.append(i + ",");
                }
                String string4 = sb.substring(0, sb.length() - 1);
                string4 = string4 + ")";
                return string4;
            }
            System.out.print("ConditionItem\u4e0d\u80fd\u89e3\u6790" + JSON.toJSONString((Object)item));
        }
        return "(" + value + ")";
    }

    protected String getBetweenValue(ConditionItem item) {
        String[] strs = ((String)item.getValue()).split(",");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            format.parse(strs[0]);
            format.parse(strs[1]);
        }
        catch (ParseException e) {
            return strs[0] + " and " + strs[1];
        }
        return this.getDateValue(strs[0]) + " and " + this.getDateValue(strs[1]);
    }

    public String getCondition() {
        return this.condition;
    }

    public String getItemCond(ConditionItem item) {
        Object value = item.getValue();
        if (item.getExp() != null) {
            return item.getExp();
        }
        if (item.getOp().equals("=") && (value == null || value.equals("null") || value.equals("NULL"))) {
            return item.getKey() + " is null";
        }
        if (item.getOp().equals("!=") && (value == null || value.equals("null") || value.equals("NULL"))) {
            return item.getKey() + " is not null";
        }
        return item.getKey() + " " + item.getOp() + " " + this.getValue(item);
    }
}

