/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.base.component;

import com.alibaba.fastjson.JSONObject;
import htsoft.platform.base.component.HtException;

public class ConditionItem {
    private String key;
    private String op;
    private Object value;
    private String exp;

    public ConditionItem() {
        this.op = "=";
    }

    public ConditionItem(String json) throws HtException {
        if (json == null) {
            return;
        }
        if (json.indexOf("key") > -1) {
            JSONObject jsonobj = JSONObject.parseObject((String)json);
            this.setKey(jsonobj.getString("key"));
            if (jsonobj.containsKey((Object)"op")) {
                this.setOp(jsonobj.getString("op"));
            }
            this.setValue(jsonobj.getString("value"));
            this.checkValue(this.value);
        } else {
            this.setExp(json);
        }
    }

    public ConditionItem(JSONObject jsonobj) throws HtException {
        this();
        if (jsonobj == null) {
            return;
        }
        this.setKey(jsonobj.getString("key"));
        if (jsonobj.containsKey((Object)"op")) {
            this.setOp(jsonobj.getString("op"));
        }
        this.setValue(jsonobj.getString("value"));
        this.checkValue(this.value);
    }

    public ConditionItem(String key, Object value) throws HtException {
        this(key, "=", value);
    }

    public ConditionItem(String key, String op, Object value) throws HtException {
        this();
        this.setKey(key);
        this.setValue(value);
        this.setOp(op);
        this.checkValue(value);
    }

    private void checkValue(Object value) throws HtException {
        String svalue;
        if (value != null && value.getClass().equals(String.class) && ((svalue = (String)value).indexOf(";") > -1 || svalue.toLowerCase().indexOf(" or ") > -1)) {
            throw new HtException("\u6761\u4ef6\u503c\u4e0d\u80fd\u5305\u542b;\u6216or");
        }
    }

    public String getExp() {
        return this.exp;
    }

    public void setExp(String exp) throws HtException {
        this.exp = exp;
        if (exp != null && this.exp.indexOf(";") > -1) {
            throw new HtException("\u6761\u4ef6\u503c\u4e0d\u80fd\u5305\u542b;");
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        if (op != null) {
            this.op = op;
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        return "key=" + this.toValue(this.key) + ",op=" + this.toValue(this.op) + ",value=" + this.toValue(this.value) + ",exp=" + this.toValue(this.exp);
    }

    private String toValue(Object o) {
        if (o == null) {
            return "NULL";
        }
        return o.toString();
    }
}

