/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.base.component;

import htsoft.platform.base.utility.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import org.springframework.jdbc.core.RowMapper;

public class BaseRowMapper<T>
implements RowMapper<T> {
    private Class<T> dtoclass;
    HashMap<String, Field> fieldmap;

    public BaseRowMapper(Class<T> c) {
        this.dtoclass = c;
        this.fieldmap = new HashMap();
        for (Field f : ReflectionUtils.getAllFields(this.dtoclass)) {
            this.fieldmap.put(f.getName().toLowerCase(), f);
            f.setAccessible(true);
        }
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        T dto = null;
        try {
            dto = this.dtoclass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = metaData.getColumnLabel(i);
            if (!this.fieldmap.containsKey(columnName.toLowerCase())) continue;
            Field field = this.fieldmap.get(columnName.toLowerCase());
            try {
                Object value = rs.getObject(columnName);
                this.setValue(dto, field, value);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return dto;
    }

    private void setValue(T dto, Field field, Object obj) {
        try {
            field.setAccessible(true);
            if (field.getType().isEnum()) {
                if (obj == null) {
                    field.set(dto, obj);
                } else {
                    Method mt = field.getType().getDeclaredMethod("values", new Class[0]);
                    Enum[] olist = (Enum[])mt.invoke(null, null);
                    int index = 0;
                    index = obj instanceof BigDecimal ? ((BigDecimal)obj).intValue() : ((Integer)obj).intValue();
                    field.set(dto, olist[index]);
                }
            } else if (obj instanceof BigDecimal && (field.getType() == Integer.class || field.getType() == Integer.TYPE)) {
                field.set(dto, ((BigDecimal)obj).intValue());
            } else if (obj instanceof BigDecimal && (field.getType() == Long.class || field.getType() == Long.TYPE)) {
                field.set(dto, ((BigDecimal)obj).longValue());
            } else if (obj instanceof BigDecimal && (field.getType() == Double.class || field.getType() == Double.TYPE)) {
                field.set(dto, ((BigDecimal)obj).doubleValue());
            } else if (obj instanceof BigDecimal && (field.getType() == Float.class || field.getType() == Float.TYPE)) {
                field.set(dto, Float.valueOf(((BigDecimal)obj).floatValue()));
            } else if (obj instanceof Integer && field.getType() == Long.class) {
                field.set(dto, ((Integer)obj).longValue());
            } else if (obj instanceof Boolean && field.getType() == Integer.class) {
                field.set(dto, (Boolean)obj != false ? 1 : 0);
            } else if (obj == null && (field.getType() == Boolean.class || field.getType() == Boolean.TYPE)) {
                field.set(dto, false);
            } else if (obj == null && (field.getType() == Integer.TYPE || field.getType() == Long.TYPE)) {
                field.set(dto, 0);
            } else {
                field.set(dto, obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("BaseRowMapper\u9519\u8bef\uff0cfieldname:" + field.getName() + "  valuetype:" + obj.getClass().getName());
        }
    }
}

