/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.base.component;

import htsoft.platform.base.component.BaseEntity;
import htsoft.platform.base.component.BaseJpaRepository;
import htsoft.platform.base.component.HtSqlQuery;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=false)
public class BaseJpaRepositoryImpl<T extends BaseEntity, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements BaseJpaRepository<T, ID> {
    protected final Class domainClass;
    protected EntityManager em;

    public BaseJpaRepositoryImpl(Class<T> domainClass, EntityManager entityManager) {
        super(domainClass, entityManager);
        this.domainClass = domainClass;
        this.em = entityManager;
        this.em.setFlushMode(FlushModeType.AUTO);
    }

    public EntityManager getEntityManager() {
        return this.em;
    }

    public Class getDomainClass() {
        return this.domainClass;
    }

    @Override
    public void add(T entity) {
        this.em.persist(entity);
        this.em.flush();
    }

    @Override
    public void update(T entity) {
        this.em.merge(entity);
        this.em.flush();
    }

    @Override
    public void delete(T entity) {
        super.delete(entity);
        this.flush();
    }

    @Override
    public List<Object[]> findAll(HtSqlQuery query) {
        return this.em.createNativeQuery(query.getSql()).getResultList();
    }

    @Override
    public void saveList(List<T> entitylist) {
        this.saveAll(entitylist);
        this.flush();
    }
}

