/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.util;

import htsoft.platform.base.component.HtException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class JdbcUtil {
    private String driver;
    private int dbtype;
    private String url;
    private String user;
    private String password;

    public JdbcUtil(int dbtype, String url, String user, String pass) {
        this.dbtype = dbtype;
        if (dbtype == 1) {
            this.driver = "com.mysql.cj.jdbc.Driver";
        }
        this.url = url;
        this.user = user;
        this.password = pass;
    }

    public Connection getConn() throws HtException {
        Connection connection = null;
        try {
            Class.forName(this.driver);
            connection = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (Exception e) {
            throw new HtException("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\uff1a" + this.url + "," + e.getMessage());
        }
        return connection;
    }

    public int update(String sql, Object ... obj) throws HtException {
        Connection connection = this.getConn();
        CallableStatement cs = null;
        int result = 0;
        try {
            cs = connection.prepareCall(sql);
            for (int i = 0; i < obj.length; ++i) {
                cs.setObject(i + 1, obj[i]);
            }
            result = cs.executeUpdate();
        }
        catch (SQLException e) {
            throw new HtException("\u6267\u884csql\u9519\u8bef\uff1a" + sql);
        }
        finally {
            this.close(null, cs, connection);
        }
        return result;
    }

    public int updatePS(String sql, Object ... obj) throws HtException {
        Connection connection = this.getConn();
        PreparedStatement ps = null;
        int result = 0;
        try {
            ps = connection.prepareStatement(sql);
            for (int i = 0; i < obj.length; ++i) {
                ps.setObject(i + 1, obj[i]);
            }
            result = ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new HtException("\u6267\u884csql\u9519\u8bef\uff1a" + sql);
        }
        finally {
            this.close(null, ps, connection);
        }
        return result;
    }

    public int updateS(String sql) throws HtException {
        Connection connection = this.getConn();
        Statement s = null;
        int result = 0;
        try {
            result = s.executeUpdate(sql);
        }
        catch (SQLException sqle) {
            throw new HtException("\u6267\u884csql\u9519\u8bef\uff1a" + sql);
        }
        finally {
            this.close(null, s, connection);
        }
        return result;
    }

    public <T> List<T> queryToClass(String sql, Class<T> c, Object ... obj) throws HtException {
        ArrayList<T> list = new ArrayList<T>();
        Object[] object = obj;
        ResultSet resultSet = this.query(sql, object);
        try {
            while (resultSet.next()) {
                T bean = c.newInstance();
                Field[] field = c.getDeclaredFields();
                for (int i = 0; i < field.length; ++i) {
                    String fieldName = field[i].getName();
                    Object fieldValue = resultSet.getObject(i + 1);
                    String set = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    Method setMethod = c.getDeclaredMethod(set, field[i].getType());
                    setMethod.invoke(bean, fieldValue);
                }
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new HtException("\u6267\u884csql\u9519\u8bef\uff1a" + sql);
        }
        return list;
    }

    public ResultSet query(String sql, Object ... obj) throws HtException {
        Connection connection = this.getConn();
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        try {
            ps = connection.prepareStatement(sql);
            for (int i = 0; i < obj.length; ++i) {
                ps.setObject(i + 1, obj[i]);
            }
            resultSet = ps.executeQuery();
        }
        catch (SQLException e) {
            throw new HtException("\u6267\u884csql\u9519\u8bef\uff1a" + sql);
        }
        return resultSet;
    }

    public void close(ResultSet resultSet, Statement statement, Connection connection) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getTables(String tableName) throws HtException {
        ArrayList<String> tables = new ArrayList<String>();
        Connection connection = this.getConn();
        try {
            DatabaseMetaData meta = connection.getMetaData();
            ResultSet rsTables = meta.getTables(connection.getCatalog(), null, tableName, new String[]{"TABLE"});
            while (rsTables.next()) {
                tables.add(rsTables.getString("TABLE_SCHEM"));
            }
            rsTables.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tables;
    }
}

