/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.util;

import htsoft.platform.base.component.HtException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static List<String> readFileLines(String filename) {
        try {
            String str;
            File file = new File(filename);
            if (!file.exists()) {
                return null;
            }
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ArrayList<String> strlist = new ArrayList<String>();
            while ((str = in.readLine()) != null) {
                strlist.add(str);
            }
            in.close();
            return strlist;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void deleteFile(String path, String filename) {
        File file = new File(path + "\\" + filename);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void deleteDir(String filePath) throws HtException {
        if (filePath == null) {
            throw new HtException("\u8def\u5f84\u4e3a\u7a7a");
        }
        File folder = new File(filePath);
        FileUtils.deleteDir(folder);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean existFile(String filePath) throws HtException {
        if (filePath == null) {
            throw new HtException("\u8def\u5f84\u4e3a\u7a7a");
        }
        File folder = new File(filePath);
        return FileUtils.existFile(folder);
    }

    public static boolean existFile(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            if (children.length == 0) {
                return false;
            }
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.existFile(new File(dir, children[i]));
                if (!success) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static void readToBuffer(StringBuffer buffer, String filePath) throws IOException {
        FileInputStream is = new FileInputStream(filePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = reader.readLine();
        while (line != null) {
            buffer.append(line);
            buffer.append("\n");
            line = reader.readLine();
        }
        reader.close();
        ((InputStream)is).close();
    }

    public static String readFile(String filePath) throws IOException {
        StringBuffer sb = new StringBuffer();
        FileUtils.readToBuffer(sb, filePath);
        return sb.toString();
    }
}

