/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.metadata.model.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import htsoft.platform.base.component.BaseDto;
import htsoft.platform.base.utility.StringUtils;
import htsoft.platform.metadata.model.entity.AttributeTypeEnum;
import htsoft.platform.metadata.model.entity.Meta_ModelAttribute;
import htsoft.platform.metadata.model.entity.ModelTypeEnum;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Transient;

public class Meta_ModelGenCodeDto
extends BaseDto {
    private static final long serialVersionUID = 1L;
    @JSONField(serializeUsing=ToStringSerializer.class)
    protected Long modelID;
    protected String modelCode;
    protected String modelName;
    @JSONField(serializeUsing=ToStringSerializer.class)
    protected Long solutionID;
    @JSONField(serializeUsing=ToStringSerializer.class)
    protected Long componentID;
    protected int modelType;
    protected String baseModel;
    protected String parentModel;
    protected String tableName;
    protected boolean hasView;
    protected String attributeList;
    protected String sourceModel;
    @Transient
    protected List<Meta_ModelGenCodeDto> children = new ArrayList<Meta_ModelGenCodeDto>();
    @Transient
    List<Meta_ModelAttribute> attributes = new ArrayList<Meta_ModelAttribute>();

    public List<Meta_ModelGenCodeDto> getChildren() {
        return this.children;
    }

    public Long getModelID() {
        return this.modelID;
    }

    public void setModelID(Long modelID) {
        this.modelID = modelID;
    }

    public String getModelCode() {
        return this.modelCode;
    }

    public void setModelCode(String modelCode) {
        this.modelCode = modelCode;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Long getSolutionID() {
        return this.solutionID;
    }

    public void setSolutionID(Long solutionID) {
        this.solutionID = solutionID;
    }

    public Long getComponentID() {
        return this.componentID;
    }

    public void setComponentID(Long componentID) {
        this.componentID = componentID;
    }

    public int getModelType() {
        return this.modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public String getBaseModel() {
        return this.baseModel;
    }

    public void setBaseModel(String baseModel) {
        this.baseModel = baseModel;
    }

    public String getParentModel() {
        return this.parentModel;
    }

    public void setParentModel(String parentModel) {
        this.parentModel = parentModel;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean getHasView() {
        return this.hasView;
    }

    public void setHasView(boolean hasView) {
        this.hasView = hasView;
    }

    public String getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(String attributeList) {
        this.attributeList = attributeList;
    }

    public String getSourceModel() {
        return this.sourceModel;
    }

    public void setSourceModel(String sourceModel) {
        this.sourceModel = sourceModel;
    }

    public boolean getIsEntity() {
        return this.getModelType() == ModelTypeEnum.Entity.ordinal();
    }

    public List<Meta_ModelAttribute> getAttributes() {
        if (!StringUtils.isNullOrEmpty((String)this.attributeList) && this.attributes.size() == 0) {
            this.attributes = JSON.parseArray((String)this.attributeList, Meta_ModelAttribute.class);
        }
        return this.attributes;
    }

    public Meta_ModelAttribute getAttribute(AttributeTypeEnum type) {
        for (Meta_ModelAttribute att : this.getAttributes()) {
            if (!att.getAttributeType().equals(type.name().toLowerCase())) continue;
            return att;
        }
        return null;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getCamelCode() {
        return this.getCamel(this.modelCode);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getIdCode() {
        return this.getAttribute(AttributeTypeEnum.Key).getAttributeCode();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getCamelIdCode() {
        String id = this.getIdCode();
        if (id != null) {
            return this.getCamel(id);
        }
        return null;
    }

    public String getMaintainList(int tabs) {
        String code = this.getCamelCode() + "List";
        StringBuilder sb = new StringBuilder();
        this.appendTabs(sb, tabs);
        sb.append("<input type=\"hidden\" id=\"").append(code).append("\" name=\"").append(code).append("\" th:value=\"${data.").append(code).append("}\"");
        sb.append(">");
        return sb.toString();
    }

    public String setDefaultValues(int tabs) {
        StringBuilder sb = new StringBuilder();
        for (Meta_ModelAttribute att : this.attributes) {
            if (att.getDefaultValue() == null) continue;
            this.appendTabs(sb, tabs);
            if (att.getDataType().equals("string")) {
                sb.append(att.getCamelCode()).append("=\"").append(att.getDefaultValue()).append("\";\r\n");
                continue;
            }
            if (att.getDataType().equals("integer")) {
                sb.append(att.getCamelCode()).append("=").append(att.getDefaultValue()).append(";\r\n");
                continue;
            }
            if (att.getDataType().equals("number")) {
                sb.append(att.getCamelCode()).append("=new BigDecimal(").append(att.getDefaultValue()).append(");\r\n");
                continue;
            }
            if (att.getDataType().equals("bool")) {
                sb.append(att.getCamelCode()).append("=").append(att.getDefaultValue()).append(";\r\n");
                continue;
            }
            if (!att.getDataType().equals("date") && !att.getDataType().equals("datetime")) continue;
            sb.append(att.getCamelCode()).append("=Date.parse(\"").append(att.getDefaultValue()).append("\");\r\n");
        }
        return sb.toString();
    }

    private void appendTabs(StringBuilder sb, int tabs) {
        for (int i = 0; i < tabs; ++i) {
            sb.append("\t");
        }
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getCamelSourceModel() {
        return this.getCamel(this.sourceModel);
    }

    public String getCamel(String s) {
        if (s == null) {
            return "";
        }
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public String getTestValue(Meta_ModelAttribute att) {
        if (att.getAttributeType().equals("code")) {
            return "\"test01\"";
        }
        if (att.getAttributeType().equals("docno")) {
            return "\"testdoc01\"";
        }
        if (att.getDataType().equals("integer")) {
            return "0";
        }
        if (att.getDataType().equals("number")) {
            return "0";
        }
        if (att.getDataType().equals("bool")) {
            return "false";
        }
        return "null";
    }

    public Meta_ModelAttribute getAttribute(String type) {
        for (Meta_ModelAttribute att : this.getAttributes()) {
            if (!att.getAttributeType().equals(type)) continue;
            return att;
        }
        return null;
    }
}

