/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.metadata.model.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import htsoft.platform.base.component.BaseEntity;
import htsoft.platform.base.utility.StringUtils;
import htsoft.platform.metadata.model.entity.AttributeTypeEnum;
import htsoft.platform.metadata.model.entity.Meta_ModelAttribute;
import htsoft.platform.metadata.model.entity.ModelTypeEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;

@Entity
@Table(name="meta_model")
public class Meta_Model
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Id
    @JSONField(serializeUsing=ToStringSerializer.class)
    protected Long modelID;
    protected String modelCode;
    protected String modelName;
    @JSONField(serializeUsing=ToStringSerializer.class)
    protected Long solutionID;
    @JSONField(serializeUsing=ToStringSerializer.class)
    protected Long componentID;
    protected int modelType;
    protected String baseModel;
    protected String parentModel;
    protected String tableName;
    protected boolean hasView;
    @Version
    protected int version;
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    protected Date createTime;
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    protected Date modifyTime;
    protected String attributeList;
    protected String sourceModel;
    @Transient
    List<Meta_ModelAttribute> attributes = new ArrayList<Meta_ModelAttribute>();

    public List<Meta_ModelAttribute> getAttributes() {
        if (!StringUtils.isNullOrEmpty((String)this.attributeList) && this.attributes.size() == 0) {
            this.attributes = JSON.parseArray((String)this.attributeList, Meta_ModelAttribute.class);
        }
        return this.attributes;
    }

    public Meta_ModelAttribute getAttribute(AttributeTypeEnum type) {
        for (Meta_ModelAttribute att : this.getAttributes()) {
            if (!att.getAttributeType().equals(type.name().toLowerCase())) continue;
            return att;
        }
        return null;
    }

    public Meta_ModelAttribute getAttribute(String code) {
        String lcode = code.toLowerCase();
        for (Meta_ModelAttribute att : this.getAttributes()) {
            if (!att.getAttributeCode().toLowerCase().equals(lcode)) continue;
            return att;
        }
        return null;
    }

    public Long getModelID() {
        return this.modelID;
    }

    public void setModelID(Long modelID) {
        this.modelID = modelID;
    }

    public String getModelCode() {
        return this.modelCode;
    }

    public void setModelCode(String modelCode) {
        this.modelCode = modelCode;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Long getSolutionID() {
        return this.solutionID;
    }

    public void setSolutionID(Long solutionID) {
        this.solutionID = solutionID;
    }

    public Long getComponentID() {
        return this.componentID;
    }

    public void setComponentID(Long componentID) {
        this.componentID = componentID;
    }

    public int getModelType() {
        return this.modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public String getBaseModel() {
        return this.baseModel;
    }

    public void setBaseModel(String baseModel) {
        this.baseModel = baseModel;
    }

    public String getParentModel() {
        return this.parentModel;
    }

    public void setParentModel(String parentModel) {
        this.parentModel = parentModel;
    }

    public String getSourceModel() {
        return this.sourceModel;
    }

    public void setSourceModel(String sourceModel) {
        this.sourceModel = sourceModel;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean getHasView() {
        return this.hasView;
    }

    public void setHasView(boolean hasView) {
        this.hasView = hasView;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(String attributeList) {
        this.attributeList = attributeList;
        this.attributes.clear();
    }

    public boolean getIsEntity() {
        return this.getModelType() == ModelTypeEnum.Entity.ordinal();
    }
}

