/*
 * Decompiled with CFR 0.152.
 */
package htsoft.platform.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import htsoft.platform.base.annotation.OperationLog;
import htsoft.platform.base.web.ActionResult;
import htsoft.platform.base.web.ActionResultStatus;
import java.lang.reflect.Parameter;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class HttpAspect {
    private static final Logger logger = LoggerFactory.getLogger(HttpAspect.class);

    @Pointcut(value="@annotation(htsoft.platform.base.annotation.OperationLog)")
    public void controllerAspect() {
    }

    @Around(value="controllerAspect()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        long startTimeMillis = 0L;
        long endTimeMillis = 0L;
        HttpServletRequest request = this.getRequest();
        String url = request.getRequestURI();
        String params = this.getParams((JoinPoint)joinPoint);
        String message = "";
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        OperationLog oploginfo = signature.getMethod().getAnnotation(OperationLog.class);
        Class<?> retType = signature.getMethod().getReturnType();
        message = oploginfo.value();
        startTimeMillis = System.currentTimeMillis();
        Object result = joinPoint.proceed();
        endTimeMillis = System.currentTimeMillis();
        return result;
    }

    private HttpServletRequest getRequest() {
        ServletRequestAttributes ra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ra.getRequest();
        return request;
    }

    private HttpServletResponse getResponse() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
    }

    private static String getControllerMethodDescription(JoinPoint joinPoint) throws Exception {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String description = signature.getMethod().getAnnotation(OperationLog.class).value();
        return description;
    }

    @AfterThrowing(pointcut="controllerAspect()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Throwable e) {
        HttpServletRequest request = this.getRequest();
        HttpSession session = request.getSession();
        String className = joinPoint.getTarget().getClass().getName();
        String exclassName = e.getClass().getName();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        OperationLog oploginfo = signature.getMethod().getAnnotation(OperationLog.class);
        String methodName = signature.getName();
        String exmessage = e.getMessage();
        String ip = request.getRemoteAddr();
        String url = request.getRequestURI();
        String methodMessage = "";
        String params = this.getParams(joinPoint);
        try {
            methodMessage = HttpAspect.getControllerMethodDescription(joinPoint);
            Class<?> retType = signature.getMethod().getReturnType();
            if (retType == ActionResult.class) {
                ActionResult result = new ActionResult(ActionResultStatus.FAILURE, methodMessage + "\u9519\u8bef");
                result.setMessage(e.getMessage());
                HttpServletResponse response = this.getResponse();
                response.reset();
                response.setCharacterEncoding("UTF-8");
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                ServletOutputStream output = response.getOutputStream();
                output.write(JSON.toJSONBytes((Object)result, (SerializerFeature[])new SerializerFeature[0]));
                output.flush();
                output.close();
            }
            long endTimeMillis = System.currentTimeMillis();
        }
        catch (Exception ex) {
            logger.error("\u63a7\u5236\u5668{} \u65b9\u6cd5{} \u53d6Message\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{className, methodName, ex.getMessage()});
        }
        logger.error("\u63a7\u5236\u5668\u5f02\u5e38{} \u65b9\u6cd5{} \u5f02\u5e38\u4ee3\u7801:{}\u5f02\u5e38\u4fe1\u606f:{}\u53c2\u6570:{}", new Object[]{className, methodName, exclassName, exmessage, params});
    }

    String getParams(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Object[] args = joinPoint.getArgs();
        Parameter[] params = signature.getMethod().getParameters();
        JSONObject json = new JSONObject();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof ServletRequest || args[i] instanceof ServletResponse || args[i] instanceof MultipartFile) continue;
            json.put(params[i].getName(), args[i]);
        }
        return this.getResult(json.toJSONString());
    }

    String getResult(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() <= 2000) {
            return s;
        }
        return s.substring(0, 2000);
    }
}

